/*! For license information please see pintura.js.LICENSE.txt */
const JFIF_MARKER=65504,EXIF_MARKER=65505,SOS_MARKER=65498,XMP_MARKER=65505,MPF_MARKER=65506,APP2_MARKER=65506,Markers=[{value:65504,name:"jfif"},{value:65498,name:"sos"},{value:65505,subvalue:17784,name:"exif"},{value:65505,subvalue:26740,name:"xmp"},{value:65506,subvalue:19792,name:"mpf"},{value:65506,name:"app2"}],JPEG_SOI_MARKER=65496,JPEG_MARKER_PREFIX=255;var dataViewGetApplicationMarkers=e=>{if(65496!==e.getUint16(0))return;const t=e.byteLength;let o,r,n=2;for(;n<t&&255===e.getUint8(n);){o=e.getUint16(n);const t=Markers.find((t=>t.value===o&&(!t.subvalue||t.subvalue===e.getUint16(n+2+2))));if(t){const{name:o}=t;r||(r={}),r[o]||(r[o]={offset:n,size:e.getUint16(n+2)})}if(65498===o)break;n+=2+e.getUint16(n+2)}return r};const APP1_MARKER=65505,APP1_EXIF_IDENTIFIER=1165519206,TIFF_MARKER=42,BYTE_ALIGN_MOTOROLA=19789,BYTE_ALIGN_INTEL=18761;var dataViewGetExifTags=(e,t)=>{if(65505!==e.getUint16(t))return;const o=e.getUint16(t+2);if(t+=4,1165519206!==e.getUint32(t))return;t+=6;const r=e.getUint16(t);if(18761!==r&&19789!==r)return;const n=18761===r;if(t+=2,42!==e.getUint16(t,n))return;t+=e.getUint32(t+2,n);const i=r=>{const i=[];let a=t;const s=Math.min(e.byteLength,t+o-16);for(;a<s;a+=12){const t=a;e.getUint16(t,n)===r&&i.push(t)}return i};return{read:t=>{const o=i(t);if(o.length)return e.getUint16(o[0]+8,n)},write:(t,o)=>{const r=i(t);return!!r.length&&(r.forEach((t=>e.setUint16(t+8,o,n))),!0)}}};const ORIENTATION_TAG=274;var arrayBufferImageExif=(e,t,o)=>{if(!e)return;const r=new DataView(e),n=dataViewGetApplicationMarkers(r);if(!n||!n.exif)return;const i=dataViewGetExifTags(r,n.exif.offset);return i?void 0===o?i.read(t):i.write(t,o):void 0};const backup="__pqina_webapi__";var getNativeAPIRef=e=>window[backup]?window[backup][e]:window[e],noop$1=(...e)=>{};const FileReaderDataFormat={ArrayBuffer:"readAsArrayBuffer"};var readFile=(e,t=noop$1,o={})=>new Promise(((r,n)=>{const{dataFormat:i=FileReaderDataFormat.ArrayBuffer}=o,a=new(getNativeAPIRef("FileReader"));a.onload=()=>r(a.result),a.onerror=()=>n(a.error),a.onprogress=t,a[i](e)})),blobReadSection=async(e,t=[0,e.size],o)=>await readFile(e.slice(...t),o),getImageOrientationFromFile=async(e,t)=>{const o=await blobReadSection(e,[0,262144],t);return arrayBufferImageExif(o,274)||1};let result$d=null;var isBrowser=()=>(null===result$d&&(result$d="undefined"!=typeof window&&void 0!==window.document),result$d);let result$c=null;var canOrientImages=()=>new Promise((e=>{if(null===result$c){const t="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEASABIAAD/4QA6RXhpZgAATU0AKgAAAAgAAwESAAMAAAABAAYAAAEoAAMAAAABAAIAAAITAAMAAAABAAEAAAAAAAD/2wBDAP//////////////////////////////////////////////////////////////////////////////////////wAALCAABAAIBASIA/8QAJgABAAAAAAAAAAAAAAAAAAAAAxABAAAAAAAAAAAAAAAAAAAAAP/aAAgBAQAAPwBH/9k=";let o=isBrowser()?new Image:{};return o.onload=()=>{result$c=1===o.naturalWidth,o=void 0,e(result$c)},void(o.src=t)}return e(result$c)})),canvasToImageData=e=>e.getContext("2d").getImageData(0,0,e.width,e.height),isString=e=>"string"==typeof e;function setElementStyles(e,t){t.split(";").forEach((t=>{const[o,r]=t.split(":");if(!o.length||!r)return;const[n,i]=r.split("!important");e.style.setProperty(o,n,isString(i)?"important":void 0)}))}var h=(e,t,o=[])=>{const r=document.createElement(e),n=Object.getOwnPropertyDescriptors(r.__proto__);for(const e in t)"style"===e?setElementStyles(r,t[e]):n[e]&&n[e].set||/textContent|innerHTML/.test(e)||"function"==typeof t[e]?r[e]=t[e]:r.setAttribute(e,t[e]);return o.forEach((e=>r.appendChild(e))),r};const MATRICES={1:()=>[1,0,0,1,0,0],2:e=>[-1,0,0,1,e,0],3:(e,t)=>[-1,0,0,-1,e,t],4:(e,t)=>[1,0,0,-1,0,t],5:()=>[0,1,1,0,0,0],6:(e,t)=>[0,1,-1,0,t,0],7:(e,t)=>[0,-1,-1,0,t,e],8:e=>[0,-1,1,0,0,e]};var getImageOrientationMatrix=(e,t,o=-1)=>(-1===o&&(o=1),MATRICES[o](e,t)),releaseCanvas=e=>{e.width=1,e.height=1;const t=e.getContext("2d");t&&t.clearRect(0,0,1,1)},isImageData=e=>"data"in e,isUserAgent=e=>isBrowser()?RegExp(e).test(window.navigator.userAgent):void 0;let result$b=null;var isAndroid=()=>(null===result$b&&(result$b=isUserAgent(/Android/)),result$b),canvasClone=(e,t)=>{const o=h("canvas",{width:e.width,height:e.height});return o.getContext("2d",t).drawImage(e,0,0),o},imageDataToCanvas=async(e,t=1)=>{const o=await canOrientImages(),[r,n]=o||t<5?[e.width,e.height]:[e.height,e.width],i=h("canvas",{width:r,height:n}),a=i.getContext("2d",{willReadFrequently:!0});if(isImageData(e)&&!o&&t>1){const t=h("canvas",{width:e.width,height:e.height});t.getContext("2d",{willReadFrequently:!0}).putImageData(e,0,0),e=t}if(!o&&t>1&&a.transform.apply(a,getImageOrientationMatrix(e.width,e.height,t)),isImageData(e)){if(a.putImageData(e,0,0),isAndroid())return canvasClone(i)}else a.drawImage(e,0,0);return e instanceof HTMLCanvasElement&&releaseCanvas(e),i},orientImageData=async(e,t=1)=>1===t||await canOrientImages()?e:canvasToImageData(await imageDataToCanvas(e,t)),isObject=e=>"object"==typeof e;const copy=e=>e instanceof HTMLElement?e:isObject(e)?deepCopy(e):e,deepCopy=e=>{let t;return Array.isArray(e)?(t=[],e.forEach(((e,o)=>{t[o]=copy(e)}))):(t={},null!==e&&Object.keys(e).forEach((o=>{const r=e[o];t[o]=copy(r)}))),t};var isFunction=e=>"function"==typeof e,imageToCanvas=(e,{width:t,height:o,canvasMemoryLimit:r,contextOptions:n})=>{let i=t||e.naturalWidth,a=o||e.naturalHeight;i||a||(i=300,a=150);const s=i*a;if(r&&s>r){const e=Math.sqrt(r)/Math.sqrt(s);i=Math.floor(i*e),a=Math.floor(a*e)}const l=h("canvas");l.width=i,l.height=a;return l.getContext("2d",n).drawImage(e,0,0,i,a),l},imageToCanvasSafe=(e,t)=>new Promise(((o,r)=>{const n=()=>o(imageToCanvas(e,t));e.complete&&e.width?n():(e.onload=n,e.onerror=()=>r(new Error("Failed to load image")))})),blobToCanvas=async(e,t)=>{const o=h("img",{src:URL.createObjectURL(e)}),r=await imageToCanvasSafe(o,t);return URL.revokeObjectURL(o.src),r},canCreateImageBitmap=()=>"createImageBitmap"in window,canCreateOffscreenCanvas=()=>"OffscreenCanvas"in window,isSVGFile=e=>/svg/.test(e.type),getUniqueId=()=>Math.random().toString(36).substring(2,9),functionToBlob=e=>new Blob(["(","function"==typeof e?e.toString():e,")()"],{type:"application/javascript"});const wrapFunction=e=>`function () {self.onmessage = function (message) {(${e.toString()}).apply(null, message.data.content.concat([function (err, response) {\n    response = response || {};\n    const transfer = 'data' in response ? [response.data.buffer] : 'width' in response ? [response] : [];\n    return self.postMessage({ id: message.data.id, content: response, error: err }, transfer);\n}]))}}`,workerPool=new Map;var thread=(e,t,o)=>new Promise(((r,n)=>{const i=e.toString();let a=workerPool.get(i);if(!a){const t=wrapFunction(e),o=URL.createObjectURL(functionToBlob(t)),r=new Map,n=new Worker(o);a={url:o,worker:n,messages:r,terminationTimeout:void 0,terminate:()=>{clearTimeout(a.terminationTimeout),a.worker.terminate(),URL.revokeObjectURL(o),workerPool.delete(i)}},n.onmessage=function(e){const{id:t,content:o,error:n}=e.data;if(clearTimeout(a.terminationTimeout),a.terminationTimeout=setTimeout((()=>{r.size>0||a.terminate()}),500),!r.has(t))return;const i=r.get(t);r.delete(t),null!=n?i.reject(n):i.resolve(o)},workerPool.set(i,a)}const s=getUniqueId();a.messages.set(s,{resolve:r,reject:n}),a.worker.postMessage({id:s,content:t},o)}));let result$a=null;var isFirefox=()=>(null===result$a&&(result$a=isUserAgent(/Firefox/)),result$a);const mainThreadBlobToImageData=async(e,t)=>{const o=await blobToCanvas(e,{canvasMemoryLimit:t,contextOptions:{willReadFrequently:!0}}),r=canvasToImageData(o);return releaseCanvas(o),r};var blobToImageData=async(e,t)=>{if(isAndroid()&&!isFirefox())return await mainThreadBlobToImageData(e,t);let o;if(canCreateImageBitmap()&&!isSVGFile(e)&&canCreateOffscreenCanvas())try{o=await thread(((e,t,o)=>{createImageBitmap(e).then((e=>{let r=e.width,n=e.height;const i=r*n;if(t&&i>t){const e=Math.sqrt(t)/Math.sqrt(i);r=Math.floor(r*e),n=Math.floor(n*e)}const a=new OffscreenCanvas(r,n),s=a.getContext("2d",{willReadFrequently:!0});s.drawImage(e,0,0,r,n);const l=s.getImageData(0,0,a.width,a.height);o(null,l)})).catch((e=>{o(e)}))}),[e,t])}catch(e){}return o&&o.width?o:await mainThreadBlobToImageData(e,t)},canvasToBlob=(e,t=void 0,o=void 0)=>new Promise(((r,n)=>{try{e.toBlob((e=>{if(!e)return n(new Error("Failed to create blob"));r(e)}),t,o)}catch(e){n(e)}})),imageDataToBlob=async(e,t,o)=>{const r=await imageDataToCanvas(e),n=await canvasToBlob(r,t,o);return releaseCanvas(r),n};const mimeTypes={matroska:"mkv"};var getExtensionFromMimeType=e=>{const t=(e.match(/\/([a-z0-9]+)/)||[])[1];if(/^x/.test(t)){const[,t=""]=e.split("/x-");return mimeTypes[t]}return t},getFilenameWithoutExtension=e=>e.substring(0,e.lastIndexOf("."))||e,getExtensionFromFilename=e=>e.split(".").pop();const ImageExtensionsRegex=/avif|bmp|gif|jpg|jpeg|jpe|jif|jfif|png|svg|tiff|webp/;var getMimeTypeFromExtension=e=>ImageExtensionsRegex.test(e)?"image/"+(/jfif|jif|jpe|jpg/.test(e)?"jpeg":"svg"===e?"svg+xml":e):"",getMimeTypeFromFilename=e=>e&&getMimeTypeFromExtension(getExtensionFromFilename(e).toLowerCase()),matchFilenameToMimeType=(e,t)=>{const o=getMimeTypeFromFilename(e);if(o===t)return e;const r=getExtensionFromMimeType(t)||o;return`${getFilenameWithoutExtension(e)}.${r}`},blobToFile=(e,t,o)=>{const r=(new Date).getTime(),n=e.type.length&&!/null|text/.test(e.type),i=n?e.type:o,a=matchFilenameToMimeType(t,i);try{return new(getNativeAPIRef("File"))([e],a,{lastModified:r,type:n?e.type:i})}catch(t){const o=n?e.slice():e.slice(0,e.size,i);return o.lastModified=r,o.name=a,o}},getAspectRatio=(e,t)=>e/t,passthrough=e=>e;const PI=Math.PI,HALF_PI=Math.PI/2,QUART_PI=HALF_PI/2;var isRotatedSideways=e=>{const t=Math.abs(e)%Math.PI;return t>QUART_PI&&t<Math.PI-QUART_PI};const Direction={Top:"t",Right:"r",Bottom:"b",Left:"l",TopLeft:"tl",TopRight:"tr",BottomRight:"br",BottomLeft:"bl"},{Top:Top,Right:Right,Bottom:Bottom,Left:Left,TopLeft:TopLeft,TopRight:TopRight,BottomRight:BottomRight,BottomLeft:BottomLeft}=Direction;var DirectionCoordinateTable={[Top]:[.5,0],[Right]:[1,.5],[Bottom]:[.5,1],[Left]:[0,.5],[TopLeft]:[0,0],[TopRight]:[1,0],[BottomRight]:[1,1],[BottomLeft]:[0,1]},fixPrecision=(e,t=12)=>parseFloat(e.toFixed(t));const scale=(e,t,o)=>o+(e-o)*t,ellipseCreateFromRect=e=>({x:e.x+.5*e.width,y:e.y+.5*e.height,rx:.5*e.width,ry:.5*e.height}),vectorCreateEmpty=()=>vectorCreate(0,0),vectorCreate=(e,t)=>({x:e,y:t}),vectorCreateFromSize=e=>vectorCreate(e.width,e.height),vectorCreateFromAny=e=>vectorCreate(e.x,e.y),vectorCreateFromPointerEvent=e=>vectorCreate(e.pageX,e.pageY),vectorCreateFromPointerEventOffset=e=>vectorCreate(e.offsetX,e.offsetY),vectorClone=e=>vectorCreate(e.x,e.y),vectorUpdate=(e,t,o)=>(e.x=t,e.y=o,e),vectorInvert=e=>(e.x=-e.x,e.y=-e.y,e),vectorPerpendicular=e=>{const t=e.x;return e.x=-e.y,e.y=t,e},vectorRotate=(e,t,o=vectorCreateEmpty())=>{const r=Math.cos(t),n=Math.sin(t),i=e.x-o.x,a=e.y-o.y;return e.x=o.x+r*i-n*a,e.y=o.y+n*i+r*a,e},vectorLength=e=>Math.sqrt(e.x*e.x+e.y*e.y),vectorNormalize=e=>{const t=Math.sqrt(e.x*e.x+e.y*e.y);return 0===t?vectorCreateEmpty():(e.x/=t,e.y/=t,e)},vectorAngle=e=>Math.atan2(e.y,e.x),vectorAngleBetween=(e,t)=>Math.atan2(t.y-e.y,t.x-e.x),vectorEqual=(e,t)=>e.x===t.x&&e.y===t.y,vectorApply=(e,t)=>(e.x=t(e.x),e.y=t(e.y),e),vectorInSize=(e,t)=>e.x>=0&&e.y>=0&&e.x<=t.width&&e.y<=t.height,vectorAdd=(e,t)=>(e.x+=t.x,e.y+=t.y,e),vectorSubtract=(e,t)=>(e.x-=t.x,e.y-=t.y,e),vectorDivide=(e,t)=>(e.x/=t,e.y/=t,e),vectorMultiply=(e,t)=>(e.x*=t,e.y*=t,e),vectorDot=(e,t)=>e.x*t.x+e.y*t.y,vectorCross=(e,t)=>e.x*t.y-e.y*t.x,vectorDistanceSquared=(e,t=vectorCreateEmpty())=>{const o=e.x-t.x,r=e.y-t.y;return o*o+r*r},vectorDistance=(e,t=vectorCreateEmpty())=>Math.sqrt(vectorDistanceSquared(e,t)),vectorScale=(e,t,o)=>(e.x=scale(e.x,t,o.x),e.y=scale(e.y,t,o.y),e),vectorCenter=e=>{let t=0,o=0;return e.forEach((e=>{t+=e.x,o+=e.y})),vectorCreate(t/e.length,o/e.length)},vectorsFlip=(e,t,o,r,n)=>(e.forEach((e=>{e.x=t?r-(e.x-r):e.x,e.y=o?n-(e.y-n):e.y})),e),vectorsRotate=(e,t,o,r)=>{const n=Math.sin(t),i=Math.cos(t);return e.forEach((e=>{e.x-=o,e.y-=r;const t=e.x*i-e.y*n,a=e.x*n+e.y*i;e.x=o+t,e.y=r+a})),e},toSize=(e,t)=>({width:e,height:t}),sizeClone=e=>toSize(e.width,e.height),sizeCreateFromAny=e=>toSize(e.width,e.height),sizeCreateFromRect=e=>toSize(e.width,e.height),sizeCreateFromArray=e=>toSize(e[0],e[1]),sizeCreateFromImageNaturalSize=e=>toSize(e.naturalWidth,e.naturalHeight),sizeCreateFromElement=e=>/img/i.test(e.nodeName)?sizeCreateFromImageNaturalSize(e):sizeCreateFromAny(e),sizeCreate=(e,t)=>toSize(e,t),sizeEqual=(e,t,o=passthrough)=>o(e.width)===o(t.width)&&o(e.height)===o(t.height),sizeScale=(e,t)=>(e.width*=t,e.height*=t,e),sizeCenter=e=>vectorCreate(.5*e.width,.5*e.height),sizeRotate=(e,t)=>{const o=Math.abs(t),r=Math.abs(Math.cos(o)),n=Math.abs(Math.sin(o)),i=r*e.width+n*e.height,a=n*e.width+r*e.height;return e.width=i,e.height=a,e},sizeTurn=(e,t)=>{const o=e.width,r=e.height;return isRotatedSideways(t)&&(e.width=r,e.height=o),e},sizeContains=(e,t)=>e.width>=t.width&&e.height>=t.height,sizeApply=(e,t)=>(e.width=t(e.width),e.height=t(e.height),e),sizeHypotenuse=e=>Math.sqrt(e.width*e.width+e.height*e.height),sizeMin=(e,t)=>sizeCreate(Math.min(e.width,t.width),Math.min(e.height,t.height)),lineCreate=(e,t)=>({start:e,end:t}),lineClone=e=>lineCreate(vectorClone(e.start),vectorClone(e.end)),lineExtend=(e,t)=>{if(0===t)return e;const o=vectorCreate(e.start.x-e.end.x,e.start.y-e.end.y),r=vectorNormalize(o),n=vectorMultiply(r,t);return e.start.x+=n.x,e.start.y+=n.y,e.end.x-=n.x,e.end.y-=n.y,e},lineMultiply=(e,t)=>{if(0===t)return e;const o=vectorCreate(e.start.x-e.end.x,e.start.y-e.end.y),r=vectorNormalize(o),n=vectorMultiply(r,t);return e.end.x+=n.x,e.end.y+=n.y,e},lineExtrude=({start:e,end:t},o)=>{if(0===o)return[vectorCreate(e.x,e.y),vectorCreate(e.x,e.y),vectorCreate(t.x,t.y),vectorCreate(t.x,t.y)];const r=Math.atan2(t.y-e.y,t.x-e.x),n=Math.sin(r)*o,i=Math.cos(r)*o;return[vectorCreate(n+e.x,-i+e.y),vectorCreate(-n+e.x,i+e.y),vectorCreate(-n+t.x,i+t.y),vectorCreate(n+t.x,-i+t.y)]},CornerSigns=[vectorCreate(-1,-1),vectorCreate(-1,1),vectorCreate(1,1),vectorCreate(1,-1)],toRect=(e,t,o,r)=>({x:e,y:t,width:o,height:r}),rectClone$1=e=>toRect(e.x,e.y,e.width,e.height),rectCreateEmpty=()=>toRect(0,0,0,0),rectCreateFromDimensions=(e,t)=>toRect(0,0,e,t),rectCreateFromSize=e=>toRect(0,0,e.width,e.height),rectCreateFromBounds=e=>toRect(e[3],e[0],e[1]-e[3],e[2]-e[0]),rectCreateFromAny=e=>toRect(e.x||0,e.y||0,e.width||0,e.height||0),rectCreateFromPoints=e=>{let t=e[0].x,o=e[0].x,r=e[0].y,n=e[0].y;return e.forEach((e=>{t=Math.min(t,e.x),o=Math.max(o,e.x),r=Math.min(r,e.y),n=Math.max(n,e.y)})),toRect(t,r,o-t,n-r)},rectCreateFromEllipse=e=>rectCreate(e.x-e.rx,e.y-e.ry,2*e.rx,2*e.ry),rectCreateWithCenter=(e,t)=>toRect(e.x-.5*t.width,e.y-.5*t.height,t.width,t.height),rectCreate=(e,t,o,r)=>toRect(e,t,o,r),rectCenter=e=>vectorCreate(e.x+.5*e.width,e.y+.5*e.height),rectTranslate$1=(e,t)=>(e.x+=t.x,e.y+=t.y,e),rectScale$1=(e,t,o)=>(o=o||rectCenter(e),e.x=t*(e.x-o.x)+o.x,e.y=t*(e.y-o.y)+o.y,e.width=t*e.width,e.height=t*e.height,e),rectClamp=(e,t,o,r)=>{const n=(r.x-e.x)/e.width,i=(r.y-e.y)/e.height;let a=Math.max(t.width,e.width),s=Math.max(t.height,e.height);return a=Math.min(o.width,a),s=Math.min(o.height,s),e.x=r.x-n*a,e.y=r.y-i*s,e.width=a,e.height=s,e},rectGetCornerByTarget=(e,t)=>{const[o,r]=DirectionCoordinateTable[t],n=o*e.width,i=r*e.height;return vectorCreate(e.x+n,e.y+i)},rectMultiply=(e,t)=>(e.x*=t,e.y*=t,e.width*=t,e.height*=t,e),rectDivide=(e,t)=>(e.x/=t,e.y/=t,e.width/=t,e.height/=t,e),rectSubtract=(e,t)=>(e.x-=t.x,e.y-=t.y,e.width-=t.width,e.height-=t.height,e),rectAdd=(e,t)=>(e.x+=t.x,e.y+=t.y,e.width+=t.width,e.height+=t.height,e),rectEqual=(e,t,o=passthrough)=>o(e.x)===o(t.x)&&o(e.y)===o(t.y)&&o(e.width)===o(t.width)&&o(e.height)===o(t.height),rectAspectRatio=e=>getAspectRatio(e.width,e.height),rectUpdate=(e,t,o,r,n)=>(e.x=t,e.y=o,e.width=r,e.height=n,e),rectUpdateWithRect=(e,t)=>(e.x=t.x,e.y=t.y,e.width=t.width,e.height=t.height,e),rectRotate=(e,t,o)=>(o||(o=rectCenter(e)),rectGetCorners(e).map((e=>vectorRotate(e,t,o)))),rectCenterRect=(e,t)=>toRect(.5*e.width-.5*t.width,.5*e.height-.5*t.height,t.width,t.height),rectContainsPoint=(e,t)=>!(t.x<e.x)&&(!(t.y<e.y)&&(!(t.x>e.x+e.width)&&!(t.y>e.y+e.height))),rectCoverRect=(e,t,o=vectorCreateEmpty())=>{if(0===e.width||0===e.height)return rectCreateEmpty();const r=rectAspectRatio(e);t||(t=r);let n=e.width,i=e.height;return t>r?n=i*t:i=n/t,toRect(o.x+.5*(e.width-n),o.y+.5*(e.height-i),n,i)},rectLimitInRect=(e,t,o)=>{const[r,n,i,a]=rectToBounds(e),s={...e};if(r<t.y&&(e.height=e.height-(t.y-r),e.y=t.y),n>t.x+t.width&&(e.width=t.x+t.width-e.x),i>t.y+t.height&&(e.height=t.y+t.height-e.y),a<t.x&&(e.width=e.width-(t.x-a),e.x=t.x),o){const t=Math.min(1,s.width/e.width,s.height/e.height);return rectMultiply(s,t)}return e},rectOffsetInRect=(e,t)=>{const[o,r,n,i]=rectToBounds(e);return o<t.y&&(e.y=Math.max(t.y,e.y)),r>t.width&&(e.x=t.width-e.width),n>t.height&&(e.y=t.height-e.height),i<t.x&&(e.x=Math.max(t.x,e.x)),e},rectContainRect=(e,t=rectAspectRatio(e),o=vectorCreateEmpty())=>{if(0===e.width||0===e.height)return rectCreateEmpty();let r=e.width,n=r/t;return n>e.height&&(n=e.height,r=n*t),toRect(o.x+.5*(e.width-r),o.y+.5*(e.height-n),r,n)},rectToBounds=e=>[Math.min(e.y,e.y+e.height),Math.max(e.x,e.x+e.width),Math.max(e.y,e.y+e.height),Math.min(e.x,e.x+e.width)],rectGetCorners=e=>[vectorCreate(e.x,e.y),vectorCreate(e.x+e.width,e.y),vectorCreate(e.x+e.width,e.y+e.height),vectorCreate(e.x,e.y+e.height)],rectApply=(e,t)=>{if(e)return e.x=t(e.x),e.y=t(e.y),e.width=t(e.width),e.height=t(e.height),e},rectApplyPerspective=(e,t,o=rectCenter(e))=>rectGetCorners(e).map(((e,r)=>{const n=CornerSigns[r];return vectorCreate(scale(e.x,1+n.x*t.x,o.x),scale(e.y,1+n.y*t.y,o.y))})),rectNormalizeOffset=e=>(e.x=0,e.y=0,e),convexPolyCentroid=e=>{const t=e[0],o=e[e.length-1];e=vectorEqual(t,o)?e:[...e,t];const r=t.x,n=t.y;let i,a,s,l=0,c=0,u=0,p=0;const d=e.length;for(;c<d;c++)i=e[c],a=e[c+1>d-1?0:c+1],s=(i.y-n)*(a.x-r)-(a.y-n)*(i.x-r),l+=s,u+=(i.x+a.x-2*r)*s,p+=(i.y+a.y-2*n)*s;return s=3*l,vectorCreate(r+u/s,n+p/s)},lineLineIntersection=(e,t)=>getLineLineIntersectionPoint(e.start,e.end,t.start,t.end),getLineLineIntersectionPoint=(e,t,o,r)=>{const n=(r.y-o.y)*(t.x-e.x)-(r.x-o.x)*(t.y-e.y);if(0===n)return;const i=((r.x-o.x)*(e.y-o.y)-(r.y-o.y)*(e.x-o.x))/n,a=((t.x-e.x)*(e.y-o.y)-(t.y-e.y)*(e.x-o.x))/n;return i<0||i>1||a<0||a>1?void 0:vectorCreate(e.x+i*(t.x-e.x),e.y+i*(t.y-e.y))},linePointsIntersection=(e,t,{ignoreIdenticalLines:o=!1,breakOnIntersection:r=!1}={})=>{const n=t.length,i=[];for(let a=0;a<n-1;a++){if(o&&(vectorEqual(e.start,t[a])||vectorEqual(e.start,t[a+1])||vectorEqual(e.end,t[a])||vectorEqual(e.end,t[a+1])))continue;const n=getLineLineIntersectionPoint(e.start,e.end,t[a],t[a+1]);if(n){if(r)return[n];i.push(n)}}return i.length?i:void 0},pointInPoly$1=(e,t)=>{let o=0,r=0,n=!1;const i=t.length;for(o=0,r=i-1;o<i;r=o++)t[o].y>e.y!=t[r].y>e.y&&e.x<(t[r].x-t[o].x)*(e.y-t[o].y)/(t[r].y-t[o].y)+t[o].x&&(n=!n);return n},polyIntersectsWithPoly=(e,t)=>{if(e.find((e=>pointInPoly$1(e,t))))return!0;return!!t.find((t=>pointInPoly$1(t,e)))},quadLines=e=>{const t=[];for(let o=0;o<e.length;o++){let r=o+1;r===e.length&&(r=0),t.push(lineCreate(vectorClone(e[o]),vectorClone(e[r])))}return t},quadToLines=(e,t=0)=>quadLines(e).map((e=>lineExtend(e,t))),ellipseToPolygon=(e,t,o,r=0,n=!1,i=!1,a=12)=>{const s=[];for(let r=0;r<a;r++)s.push(vectorCreate(e.x+t*Math.cos(r*(2*Math.PI)/a),e.y+o*Math.sin(r*(2*Math.PI)/a)));return(n||i)&&vectorsFlip(s,n,i,e.x,e.y),r&&vectorsRotate(s,r,e.x,e.y),s},circleOverlapsWithLine=(e,t,o,r)=>{const n=vectorCreate(e.x-o.x,e.y-o.y),i=vectorCreate(r.x-o.x,r.y-o.y),a=vectorDot(i,i);let s=vectorDot(n,i)/a;s=s<0?0:s,s=s>1?1:s;const l=vectorCreate(i.x*s+o.x-e.x,i.y*s+o.y-e.y);return vectorDot(l,l)<=t*t},circleOverlapsWithPath=(e,t,o)=>{const r=o.length;for(let n=0;n<r-1;n++)if(circleOverlapsWithLine(e,t,o[n],o[n+1]))return!0;return!1},circleOverlapsWithPolygon=(e,t,o)=>!!pointInPoly$1(e,o)||(!!circleOverlapsWithPath(e,t,o)||circleOverlapsWithLine(e,t,o[0],o[o.length-1])),circleOverlapsWithEllipse=(e,t,o,r,n,i)=>{const a=ellipseToPolygon(vectorCreate(o.x,o.y),o.rx,o.ry,r,n,i,12);return circleOverlapsWithPolygon(e,t,a)},circleOverlapsWithRect=(e,t,o,r,n)=>circleOverlapsWithPolygon(e,t,rectRotate(o,r,n||rectCenter(o)));var getImageTransformedRect=(e,t)=>{const o=rectCreateFromSize(e),r=rectCenter(o),n=rectRotate(o,t,r);return rectNormalizeOffset(rectCreateFromPoints(n))},isElement=(e,t)=>e instanceof HTMLElement&&(!t||new RegExp(`^${t}$`,"i").test(e.nodeName)),isFile=e=>e instanceof File,canvasToFile=async(e,t,o)=>{const r=await canvasToBlob(e,t,o);return blobToFile(r,"canvas")},getFilenameFromURL=e=>e.split("/").pop().split(/\?|\#/).shift();const supportsReplaceChildren=isBrowser()&&!!Node.prototype.replaceChildren,fn$1=supportsReplaceChildren?(e,t)=>e.replaceChildren(t):(e,t)=>{for(;e.lastChild;)e.removeChild(e.lastChild);void 0!==t&&e.append(t)},container=isBrowser()&&h("div",{class:"PinturaMeasure",style:"position:absolute;left:0;top:0;width:99999px;height:0;pointer-events:none;contain:strict;margin:0;padding:0;"});let timeoutId;var appendForMeasuring=e=>(fn$1(container,e),container.parentNode||document.body.append(container),clearTimeout(timeoutId),timeoutId=setTimeout((()=>{container.remove()}),500),e);let result$9=null;var isSafari=()=>(null===result$9&&(result$9=isBrowser()&&/^((?!chrome|android).)*(safari|iphone|ipad)/i.test(navigator.userAgent)),result$9),getImageElementSize=e=>new Promise(((t,o)=>{let r=!1;!e.parentNode&&isSafari()&&(r=!0,e.style.cssText="position:absolute;visibility:hidden;pointer-events:none;left:0;top:0;width:0;height:0;",appendForMeasuring(e));const n=()=>{const o=e.naturalWidth,n=e.naturalHeight;o&&n&&(r&&e.remove(),clearInterval(i),t({width:o,height:n}))};e.onerror=e=>{clearInterval(i),o(e)};const i=setInterval(n,1);n()})),getVideoElementSize=e=>new Promise(((t,o)=>{const r=()=>{t({width:e.videoWidth,height:e.videoHeight})};if(e.readyState>=1)return r();e.onloadedmetadata=r,e.onerror=()=>o(e.error)})),isImage=e=>/^image/.test(e.type),getAsVideoOrImageElement=e=>new Promise((t=>{const o=isString(e)?e:URL.createObjectURL(e),r=()=>{const e=new Image;e.src=o,t(e)};if(e instanceof Blob&&isImage(e))return r();const n=document.createElement("video");n.preload="metadata",n.onloadedmetadata=()=>t(n),n.onerror=r,n.src=o})),isVideoElement=e=>"VIDEO"===e.nodeName,getImageSize=async e=>{let t,o;t=e.src?e:await getAsVideoOrImageElement(e);try{o=isVideoElement(t)?await getVideoElementSize(t):await getImageElementSize(t)}finally{isFile(e)&&URL.revokeObjectURL(t.src)}return o};const awaitComplete=e=>new Promise(((t,o)=>{if(e.complete)return t(e);e.onload=()=>t(e),e.onerror=()=>o(new Error("Failed to load image"))}));var imageToFile=async e=>{const t=await getImageSize(e),o=await awaitComplete(e),r=h("canvas",t);r.getContext("2d",{willReadFrequently:!0}).drawImage(o,0,0);const n=await canvasToBlob(r);return blobToFile(n,getFilenameFromURL(o.src))},isDataURI=e=>/^data:/.test(e),createProgressEvent=(e=0,t=!0)=>new(getNativeAPIRef("ProgressEvent"))("progress",{loaded:100*e,total:100,lengthComputable:t}),dataURIToFile=async(e,t="data-uri",o=noop$1)=>{o(createProgressEvent(0));const r=await fetch(e);o(createProgressEvent(.33));const n=await r.blob();let i;isImage(n)||(i="image/"+(e.includes(",/9j/")?"jpeg":"png")),o(createProgressEvent(.66));const a=blobToFile(n,t,i);return o(createProgressEvent(1)),a},getResponseHeader=(e,t,o=e=>e)=>e.getAllResponseHeaders().indexOf(t)>=0?o(e.getResponseHeader(t)):void 0,getFilenameFromContentDisposition=e=>{if(!e)return null;const t=e.split(/filename=|filename\*=.+''/).splice(1).map((e=>e.trim().replace(/^["']|[;"']{0,2}$/g,""))).filter((e=>e.length));return t.length?decodeURI(t[t.length-1]):null};const EditorErrorCode={URL_REQUEST:"URL_REQUEST",DOCTYPE_MISSING:"DOCTYPE_MISSING"};class EditorError extends Error{constructor(e,t,o){super(e),this.name="EditorError",this.code=t,this.metadata=o}}var configureXHR=(e,t)=>{const{headers:o={},credentials:r}=t||{};Object.entries(o).forEach((([t,o])=>e.setRequestHeader(t,o))),r&&(e.withCredentials="omit"!==r)},fetchFile=(e,t,o)=>new Promise(((r,n)=>{const i=()=>n(new EditorError("Error fetching image",EditorErrorCode.URL_REQUEST,a)),a=new XMLHttpRequest;a.onprogress=t,a.onerror=i,a.onload=()=>{if(!a.response||a.status>=300||a.status<200)return i();const t=getResponseHeader(a,"Content-Type"),o=getResponseHeader(a,"Content-Disposition",getFilenameFromContentDisposition)||getFilenameFromURL(e);r(blobToFile(a.response,o,t||getMimeTypeFromFilename(o)))};const{willRequest:s}=o;Promise.resolve(s&&s(e,{resourceType:"image"})).then((t=>{if(!1===t)return n("Image load rejected");a.open("GET",e,!0),configureXHR(a,t),a.responseType="blob",a.send()})).catch(console.error)})),urlToFile=(e,t,o)=>isDataURI(e)?dataURIToFile(e,void 0,t):fetchFile(e,t,o),isBlob=e=>e instanceof Blob&&!(e instanceof File),isImageBitmap=e=>"close"in e,srcToFile=async(e,t,o)=>{if(isFile(e)||isBlob(e))return e;if(isString(e))return await urlToFile(e,t,o);if(isElement(e,"canvas"))return await canvasToFile(e);if(isElement(e,"img"))return await imageToFile(e);if(isImageData(e)||isImageBitmap(e))return await canvasToFile(await imageDataToCanvas(e));throw new EditorError("Invalid image source","invalid-image-source")};let result$8=null;var isMac=()=>(null===result$8&&(result$8=isBrowser()&&/^mac/i.test(navigator.platform)),result$8);let result$7=null;var isIOS=()=>(null===result$7&&(result$7=isBrowser()&&(isUserAgent(/iPhone|iPad|iPod/)||isMac()&&navigator.maxTouchPoints>=1)),result$7),orientImageSize=async(e,t=1)=>await canOrientImages()||isIOS()||t<5?e:sizeCreate(e.height,e.width),isJPEG=e=>/jpeg/.test(e.type),isPlainObject=e=>"object"==typeof e&&e.constructor==Object,stringify=e=>isPlainObject(e)?JSON.stringify(e):e,post=(e,t,o)=>new Promise(((r,n)=>{const{token:i={},beforeSend:a=noop$1,onprogress:s=noop$1}=o;i.cancel=()=>l.abort();const l=new XMLHttpRequest;l.upload.onprogress=s,l.onload=()=>l.status>=200&&l.status<300?r(l):n(l),l.onerror=()=>n(l),l.ontimeout=()=>n(l),l.open("POST",encodeURI(e)),a(l),l.send(t instanceof FormData?t:t.reduce(((e,t)=>(e.append(...t.map(stringify)),e)),new FormData))})),ctxRotate=(e,t=0,o)=>(0===t||(e.translate(o.x,o.y),e.rotate(t),e.translate(-o.x,-o.y)),e),ctxTranslate=(e,t,o)=>(e.translate(t,o),e),ctxScale=(e,t,o)=>(e.scale(t,o),e),cropImageData=async(e,t={})=>{const{flipX:o,flipY:r,rotation:n,crop:i}=t,a=sizeCreateFromAny(e),s=o||r,l=!!n,c=i&&(i.x||i.y||i.width||i.height),u=c&&rectEqual(i,rectCreateFromSize(a)),p=c&&!u;if(!s&&!l&&!p)return e;let d,m=h("canvas",{width:e.width,height:e.height});if(m.getContext("2d",{willReadFrequently:!0}).putImageData(e,0,0),s){const e=h("canvas",{width:m.width,height:m.height}).getContext("2d",{willReadFrequently:!0});ctxScale(e,o?-1:1,r?-1:1),e.drawImage(m,o?-m.width:0,r?-m.height:0),e.restore(),releaseCanvas(m),m=e.canvas}if(l){const e=sizeApply(sizeCreateFromRect(rectCreateFromPoints(rectRotate(rectCreateFromAny(m),n))),Math.floor),t=h("canvas",{width:i.width,height:i.height}).getContext("2d",{willReadFrequently:!0});ctxTranslate(t,-i.x,-i.y),ctxRotate(t,n,sizeCenter(e)),t.drawImage(m,.5*(e.width-m.width),.5*(e.height-m.height)),t.restore(),releaseCanvas(m),m=t.canvas}else if(p){return d=m.getContext("2d",{willReadFrequently:!0}).getImageData(i.x,i.y,i.width,i.height),releaseCanvas(m),d}return d=m.getContext("2d",{willReadFrequently:!0}).getImageData(0,0,m.width,m.height),releaseCanvas(m),d},resizeTransform=(e,t)=>{const{imageData:o,width:r,height:n}=e,i=o.width,a=o.height,s=Math.round(r),l=Math.round(n),c=o.data,u=new Uint8ClampedArray(s*l*4),p=i/s,d=a/l,h=Math.ceil(.5*p),m=Math.ceil(.5*d);for(let e=0;e<l;e++)for(let t=0;t<s;t++){const o=4*(t+e*s);let r=0,n=0,a=0,l=0,g=0,f=0,$=0;const b=(e+.5)*d;for(let o=Math.floor(e*d);o<(e+1)*d;o++){const e=Math.abs(b-(o+.5))/m,s=(t+.5)*p,u=e*e;for(let e=Math.floor(t*p);e<(t+1)*p;e++){let t=Math.abs(s-(e+.5))/h;const p=Math.sqrt(u+t*t);if(p<-1||p>1)continue;if(r=2*p*p*p-3*p*p+1,r<=0)continue;t=4*(e+o*i);const d=c[t+3];$+=r*d,a+=r,d<255&&(r=r*d/250),l+=r*c[t],g+=r*c[t+1],f+=r*c[t+2],n+=r}}u[o]=l/n,u[o+1]=g/n,u[o+2]=f/n,u[o+3]=$/a}t(null,{data:u,width:s,height:l})},imageDataObjectToImageData=e=>{if(e instanceof ImageData)return e;let t;try{t=new ImageData(e.width,e.height)}catch(o){t=h("canvas").getContext("2d").createImageData(e.width,e.height)}return t.data.set(e.data),t},resizeImageData=async(e,t={},o)=>{const{width:r,height:n,fit:i,upscale:a}=t;if(!r&&!n)return e;let s=r,l=n;if(r?n||(l=r):s=n,"force"!==i){const t=s/e.width,o=l/e.height;let r=1;if("cover"===i?r=Math.max(t,o):"contain"===i&&(r=Math.min(t,o)),r>1&&!1===a)return e;s=Math.round(e.width*r),l=Math.round(e.height*r)}return s=Math.max(s,1),l=Math.max(l,1),e.width===s&&e.height===l?e:o?o(e,s,l):(e=await thread(resizeTransform,[{imageData:e,width:s,height:l}],[e.data.buffer]),imageDataObjectToImageData(e))},colorEffect=(e,t)=>{const{imageData:o,matrix:r}=e;if(!r)return t(null,o);const n=o.data,i=n.length,a=r[0],s=r[1],l=r[2],c=r[3],u=r[4],p=r[5],d=r[6],h=r[7],m=r[8],g=r[9],f=r[10],$=r[11],b=r[12],y=r[13],_=r[14],x=r[15],v=r[16],S=r[17],C=r[18],w=r[19];let T=0,k=0,R=0,P=0,I=0,E=0,M=0,A=0,F=0,L=0,D=0,z=0;for(;T<i;T+=4)k=n[T]/255,R=n[T+1]/255,P=n[T+2]/255,I=n[T+3]/255,E=k*a+R*s+P*l+I*c+u,M=k*p+R*d+P*h+I*m+g,A=k*f+R*$+P*b+I*y+_,F=k*x+R*v+P*S+I*C+w,L=Math.max(0,E*F)+(1-F),D=Math.max(0,M*F)+(1-F),z=Math.max(0,A*F)+(1-F),n[T]=255*Math.max(0,Math.min(1,L)),n[T+1]=255*Math.max(0,Math.min(1,D)),n[T+2]=255*Math.max(0,Math.min(1,z)),n[T+3]=255*I;t(null,{data:n,width:o.width,height:o.height})},convolutionEffect=(e,t)=>{const{imageData:o,matrix:r}=e;if(!r)return t(null,o);let n=r.reduce(((e,t)=>e+t));n=n<=0?1:n;const i=o.width,a=o.height,s=o.data;let l=0,c=0,u=0;const p=Math.round(Math.sqrt(r.length)),d=Math.floor(p/2);let h=0,m=0,g=0,f=0,$=0,b=0,y=0,_=0,x=0,v=0;const S=new Uint8ClampedArray(i*a*4);for(u=0;u<a;u++)for(c=0;c<i;c++){for(h=0,m=0,g=0,f=0,b=0;b<p;b++)for($=0;$<p;$++)y=u+b-d,_=c+$-d,y<0&&(y=a-1),y>=a&&(y=0),_<0&&(_=i-1),_>=i&&(_=0),x=4*(y*i+_),v=r[b*p+$],h+=s[x]*v,m+=s[x+1]*v,g+=s[x+2]*v,f+=s[x+3]*v;S[l]=h/n,S[l+1]=m/n,S[l+2]=g/n,S[l+3]=f/n,l+=4}t(null,{data:S,width:i,height:a})},vignetteEffect=(e,t)=>{let{imageData:o,strength:r}=e;if(!r)return t(null,o);const n=o.width,i=o.height,a=o.data,s=(e,t)=>(l=e-x,c=t-v,Math.sqrt(l*l+c*c));let l,c,u,p,d,h,m,g,f,$,b,y=0,_=0,x=.5*n,v=.5*i,S=s(0,0);for(r>0?(u=0,p=0,d=0):(r=Math.abs(r),u=1,p=1,d=1),_=0;_<i;_++)for(y=0;y<n;y++)C=4*(y+_*n),w=a,T=a,k=s(y,_)*r/S,h=w[C]/255,m=w[C+1]/255,g=w[C+2]/255,f=w[C+3]/255,$=1-k,b=$*f+k,T[C]=($*f*h+k*u)/b*255,T[C+1]=($*f*m+k*p)/b*255,T[C+2]=($*f*g+k*d)/b*255,T[C+3]=255*b;var C,w,T,k;t(null,{data:a,width:o.width,height:o.height})},noiseEffect=(e,t)=>{const{imageData:o,level:r,monochrome:n=!1}=e;if(!r)return t(null,o);const i=o.data,a=i.length;let s,l,c,u=0;const p=()=>255*(2*Math.random()-1)*r,d=n?()=>{const e=p();return[e,e,e]}:()=>[p(),p(),p()];for(;u<a;u+=4)[s,l,c]=d(),i[u]=i[u]+s,i[u+1]=i[u+1]+l,i[u+2]=i[u+2]+c;t(null,{data:i,width:o.width,height:o.height})},gammaEffect=(e,t)=>{const{imageData:o,level:r}=e;if(!r)return t(null,o);const n=o.data,i=n.length;let a,s,l,c=0;for(;c<i;c+=4)a=n[c]/255,s=n[c+1]/255,l=n[c+2]/255,n[c]=255*Math.pow(a,r),n[c+1]=255*Math.pow(s,r),n[c+2]=255*Math.pow(l,r);t(null,{data:n,width:o.width,height:o.height})},isIdentityMatrix=e=>{const t=e.length;let o;const r=t>=20?6:t>=16?5:3;for(let n=0;n<t;n++){if(o=e[n],1===o&&n%r!=0)return!1;if(0!==o&&1!==o)return!1}return!0},filterImageData=async(e,t={})=>{const{colorMatrix:o,convolutionMatrix:r,gamma:n,noise:i,vignette:a}=t,s=[];if(r&&s.push([convolutionEffect,{matrix:r.clarity}]),n>0&&s.push([gammaEffect,{level:1/n}]),o&&!isIdentityMatrix(o)&&s.push([colorEffect,{matrix:o}]),(i>0||i<0)&&s.push([noiseEffect,{level:i}]),(a>0||a<0)&&s.push([vignetteEffect,{strength:a}]),!s.length)return e;const l=(e,t)=>`(err, imageData) => {\n            (${e[t][0].toString()})(Object.assign({ imageData: imageData }, filterInstructions[${t}]), \n                ${e[t+1]?l(e,t+1):"done"})\n        }`,c=`function (options, done) {\n        const filterInstructions = options.filterInstructions;\n        const imageData = options.imageData;\n        (${l(s,0)})(null, imageData)\n    }`;return e=await thread(c,[{imageData:e,filterInstructions:s.map((e=>e[1]))}],[e.data.buffer]),imageDataObjectToImageData(e)},isNumber=e=>"number"==typeof e,isEmoji=e=>isString(e)&&null!==e.match(/(?:[\u2700-\u27bf]|(?:\ud83c[\udde6-\uddff]){2}|[\ud800-\udbff][\udc00-\udfff]|[\u0023-\u0039]\ufe0f?\u20e3|\u3299|\u3297|\u303d|\u3030|\u24c2|\ud83c[\udd70-\udd71]|\ud83c[\udd7e-\udd7f]|\ud83c\udd8e|\ud83c[\udd91-\udd9a]|\ud83c[\udde6-\uddff]|\ud83c[\ude01-\ude02]|\ud83c\ude1a|\ud83c\ude2f|\ud83c[\ude32-\ude3a]|\ud83c[\ude50-\ude51]|\u203c|\u2049|[\u25aa-\u25ab]|\u25b6|\u25c0|[\u25fb-\u25fe]|\u00a9|\u00ae|\u2122|\u2139|\ud83c\udc04|[\u2600-\u26FF]|\u2b05|\u2b06|\u2b07|\u2b1b|\u2b1c|\u2b50|\u2b55|\u231a|\u231b|\u2328|\u23cf|[\u23e9-\u23f3]|[\u23f8-\u23fa]|\ud83c\udccf|\u2934|\u2935|[\u2190-\u21ff])/g),hasProp=(e,t)=>e.hasOwnProperty(t),isArray=e=>Array.isArray(e),isApple=()=>isIOS()||isMac(),isWindows=()=>/^win/i.test(navigator.platform);let x=64,y=102,fontSize=112,hasSetValues=!1;var getEmojiSVG=(e,t)=>(!hasSetValues&&isBrowser()&&(isWindows()&&(y=103),isApple()&&(x=63.5,y=110,fontSize=123),hasSetValues=!0),`<svg${t?` aria-label="${t}"`:""} width="128" height="128" viewBox="0 0 128 128" preserveAspectRatio="xMinYMin meet" xmlns="http://www.w3.org/2000/svg"><text x="${x}" y="${y}" alignment-baseline="text-top" dominant-baseline="text-top" text-anchor="middle" font-size="${fontSize}px">${e}</text></svg>`),SVGToDataURL=e=>`data:image/svg+xml,${e.replace("<","%3C").replace(">","%3E")}`,isBinary=e=>e instanceof Blob,toPercentage=(e,t)=>e/t*100+"%",colorArrayToRGBA=e=>`rgba(${Math.round(255*e[0])}, ${Math.round(255*e[1])}, ${Math.round(255*e[2])}, ${isNumber(e[3])?e[3]:1})`,objectUID=e=>Object.values(e).join("_"),timeout=(e=0)=>new Promise((t=>{setTimeout(t,e)}));const isContextBlank=e=>!new Uint32Array(e.getImageData(0,0,e.canvas.width,e.canvas.height).data.buffer).some((e=>0!==e)),width=80,height=80,whenSVGSafeForDrawing=async(e,t=0)=>{const o=h("canvas",{width:80,height:80}).getContext("2d");return await timeout(t),o.drawImage(e,0,0,80,80),!(isContextBlank(o)&&t<=256)||await whenSVGSafeForDrawing(e,t+16)},safariDrawCache=new Map;var svgToImage=(e,{safariCacheKey:t="*"}={})=>new Promise(((o,r)=>{const n=new Image;n.onerror=()=>r(new Error("Failed to load SVG")),n.onload=()=>{if(!isSafari()||!e.includes("@font-face")||safariDrawCache.has(t))return o(n);whenSVGSafeForDrawing(n).then((()=>{safariDrawCache.set(t,!0),o(n)}))},n.src="data:image/svg+xml,"+e})),blobToDataURL=e=>new Promise(((t,o)=>{const r=new FileReader;r.onerror=()=>o(r.error),r.onload=()=>t(r.result),r.readAsDataURL(e)})),pubsub=()=>{let e=[];return{sub:(t,o)=>(e.push({event:t,callback:o}),()=>e=e.filter((e=>e.event!==t||e.callback!==o))),pub:(t,o)=>{e.filter((e=>e.event===t)).forEach((e=>e.callback(o)))}}};const TextPadding=32,textGetInitialLineOffset=({fontSize:e=16,lineHeight:t=20}={})=>.5*Math.max(0,e-t),textGetLineCount=(e="")=>e.split("\n").length,textGetStyles=({color:e=[0,0,0],fontSize:t=16,fontFamily:o="sans-serif",fontVariant:r="normal",fontWeight:n="normal",fontStyle:i="normal",textAlign:a="left",letterSpacing:s="normal",lineHeight:l=20},c=1)=>`font-size:${t*c}px;font-style:${i};font-weight:${n};font-family:${o};font-variant:${r};line-height:${l*c}px;text-align:${a};letter-spacing:${isNumber(s)?s+"px":"normal"};color:${colorArrayToRGBA(e)};`,textGetContentEditableStyles=(e,t,o=1)=>{const{width:r,height:n,disableNewline:i}=t,a=!r,s=!1===i?textGetLineCount(e):void 0,l=a?"normal":"break-word",c=a&&!s?"nowrap":"pre-line";return`max-width:none;min-width:auto;width:${a?"auto":r*o+"px"};height:${n?n*o+"px":"auto"};margin-top:0;margin-bottom:0;padding-top:${textGetInitialLineOffset(t)*o}px;word-break:${l};word-wrap:normal;white-space:${c};`},TextMeasureCache=new Map,toParts=e=>{const t=[];for(const o of Array.from(e.childNodes))o.nodeType===Node.TEXT_NODE?t.push(textToLines(o)):t.push(...toParts(o));return t},MeasureStyles="pointer-events:none;visibility:hidden;position:absolute;left:0;top:0;",textMeasure=(e="",t)=>{let{width:o=0,height:r="auto",fontSize:n,fontFamily:i,lineHeight:a,fontWeight:s,fontStyle:l,fontVariant:c,letterSpacing:u}=t;const p=objectUID({text:e,fontFamily:i,fontWeight:s,fontStyle:l,fontVariant:c,fontSize:n,lineHeight:a,letterSpacing:u,width:o,height:r});let d=TextMeasureCache.get(p);if(d)return d;let m=1;n>1e3&&isFirefox()&&(m=n/1e3,n=1e3,a*=m);const g=appendForMeasuring(h("pre",{contenteditable:"true",spellcheck:"false",style:`${MeasureStyles}${textGetStyles({fontFamily:i,fontWeight:s,fontStyle:l,fontVariant:c,fontSize:n,letterSpacing:u,lineHeight:a})};${textGetContentEditableStyles(e,t)}"`,innerHTML:e})),f=g.getBoundingClientRect();return d={signature:toParts(g).flat().map((e=>e.text)).join("_;_"),textSize:sizeApply(sizeCreateFromAny(f),(e=>Math.ceil(e*m)))},TextMeasureCache.set(p,d),g.remove(),d},textToLines=e=>{const t=e.nodeValue;if(!t)return[];const o=t.length,r=document.createRange();r.selectNodeContents(e);const n=[];for(let i=0;i<o;i++){r.setStart(e,0),r.setEnd(e,i+1);const o=r.getClientRects().length-1,a=t.charAt(i);n[o]?n[o]+=a:n.push(a)}const i=r.getClientRects();return n.map(((e,t)=>({rect:i[t],text:e})))},TextSizeCache=new Map,textToSize=(e="",t)=>{const{width:o=0,height:r=0}=t;if(o&&r)return sizeCreate(o,r);let{fontSize:n=16,fontFamily:i,lineHeight:a=20,fontWeight:s,fontStyle:l,fontVariant:c,letterSpacing:u}=t;const p=objectUID({text:e,fontFamily:i,fontWeight:s,fontStyle:l,fontVariant:c,fontSize:n,letterSpacing:u,lineHeight:a,width:o});let d=TextSizeCache.get(p);if(d)return d;let m=1;n>1e3&&isFirefox()&&(m=n/1e3,n=1e3,a/=m);const g=appendForMeasuring(h("pre",{contenteditable:"true",spellcheck:"false",style:`${MeasureStyles}${textGetStyles({...t,fontSize:n,lineHeight:a})};${textGetContentEditableStyles(e,t)}"`,innerHTML:e})).getBoundingClientRect();return d=sizeCreateFromAny(g),d=sizeApply(d,(e=>e*m)),o&&(d.width=o),TextSizeCache.set(p,d),d},getPathFromURL=e=>e.pathname.split("/").slice(0,-1).join("/"),createStyleSheetLoader=(e,t)=>{const{sub:o,pub:r}=pubsub();let n,i;return Promise.resolve(t&&t(e,{resourceType:"stylesheet"})).then((t=>{if(!1===t)return i="requestPrevented",r("error",i);const{headers:o,credentials:a}=t||{};fetch(e,{headers:o,credentials:a}).then((e=>e.text())).then((e=>{n=e,r("load",n)})).catch((e=>{i=e,r("error",i)}))})),{sub:(e,t)=>"load"===e&&n?t(n):"error"===e&&i?t(i):void o(e,t)}},StyleSheetLoaders=new Map,loadStylesheet=(e,t)=>new Promise(((o,r)=>{let n=StyleSheetLoaders.get(e);void 0===n&&(n=createStyleSheetLoader(e,t),StyleSheetLoaders.set(e,n)),n.sub("load",o),n.sub("error",r)})),getRulesRemote=async(e,t,o)=>{let r;try{r=await loadStylesheet(e,t)}catch(e){return[]}const n={innerHTML:r,id:getUniqueId()};o&&(n.nonce=o);const i=h("style",n);document.head.append(i);const a=Array.from(document.styleSheets).find((e=>e.ownerNode.id===i.id));return i.remove(),Array.from(a.cssRules)},RemoteStyleSheetRulesCache=new Map,filterFontFaceRules=e=>e.filter((e=>e instanceof CSSFontFaceRule)),filterImportRules=e=>e.filter((e=>e instanceof CSSImportRule)),getFontFaceRulesSafe=async(e,t,o)=>{if(RemoteStyleSheetRulesCache.has(e.href))return RemoteStyleSheetRulesCache.get(e.href);let r;try{r=Array.from(e.cssRules);for(const e of filterImportRules(r)){const n=e.href;if(RemoteStyleSheetRulesCache.has(n)){const e=RemoteStyleSheetRulesCache.get(n);r=[...r,...e];continue}const i=await getRulesRemote(n,t,o);RemoteStyleSheetRulesCache.set(n,i),r=[...r,...i]}}catch(n){const i=e.href;r=await getRulesRemote(i,t,o),RemoteStyleSheetRulesCache.set(i,r)}return filterFontFaceRules(r)},getCSSPropertyValue=(e,t)=>e.style.getPropertyValue(t),isMatchingFontRule=(e,t)=>{if(!e.style)return!1;return getCSSPropertyValue(e,"font-family").replace(/^"|"$/g,"")==t},getMatchingFontRule=(e,t)=>{const o=[];for(const r of e){isMatchingFontRule(r,t)&&o.push(r)}return o},getDocumentStylesheetFontFaceRules=async(e,t)=>{const o=Array.from(document.styleSheets).map((o=>getFontFaceRulesSafe(o,e,t))),r=await Promise.all(o),n=[];return r.forEach((e=>n.push(...e))),n},getFontSources=async(e,t,o)=>{const r=await getDocumentStylesheetFontFaceRules(t,o),n=getMatchingFontRule(r,e);return n.length?n.map((e=>{const t=e.parentStyleSheet&&e.parentStyleSheet.href&&new URL(e.parentStyleSheet.href),o=t?t.origin+getPathFromURL(t)+"/":"",r=e.style.getPropertyValue("src").match(/url\("?(.*?)"?\)/)[1],n=Array.from(e.style).filter((e=>"src"!=e)).reduce(((t,o)=>t+=o+":"+getCSSPropertyValue(e,o)+";"),"");return[/^http/.test(r)?r:o+r,n]})):[]},FontLocal=new Map,FontCache=new Map,getFontFormatByMimeType=e=>!e||/woff2/.test(e)?"woff2":/woff/.test(e)?"woff":/ttf|truetype/.test(e)?"truetype":/otf|opentype/.test(e)?"opentype":/svg/.test(e)?"svg":"woff2",getFontFaceEmbed=async(e,t,o)=>{if(FontLocal.get(e))return;let r=FontCache.get(e);if(!r){const n=await getFontSources(e,t,o);if(!n.length)return void FontLocal.set(e,!0);const i=[];for(const[e,t]of n){const o=await fetch(e).then((e=>e.blob())),r=getFontFormatByMimeType(o.type),n=await blobToDataURL(o);i.push(`@font-face { src:url(${n}) format('${r}');${t};font-display:block; }`)}r=i.join(""),FontCache.set(e,r)}return r};var textToImage=async(e="",t)=>{if(!e.length)return;let{color:o,imageWidth:r=300,imageHeight:n=150,paddingTop:i=0,paddingRight:a=TextPadding,paddingBottom:s=0,paddingLeft:l=TextPadding,fontFamily:c,fontSize:u,pixelRatio:p=1,willRequest:d,outline:h,blur:m,styleNonce:g}=t,f=1,$="";u>1e3&&isFirefox()&&(f=u/1e3,$=`transform-origin:0 0;transform:scale(${f})`);const b=p/f,y=(r+l+a)*p,_=(n+s+i)*p,x=await getFontFaceEmbed(c,d,g);let v="";x&&(v=`<style${g?` nonce="${g}"`:""}>${x}</style>`);const S=e.replace(/%/g,"%25").replace(/#/g,"%23").replace(/&nbsp;/g," ").replace(/&(?!#\d{4};|[a-z]+;)/gi,"&amp;").replace(/<br>|\n/g,"<br/>"),C=`top:${i*b}px;right:${a*b}px;bottom:${s*b}px;left:${l*b}px`;let w=o,T="",k="";if(h||m){const e=colorArrayToRGBA(o);h&&(w=[0,0,0,0],T=`-webkit-text-stroke: ${2*h*b}px ${e}`),m&&(isSafari()?k=`filter:blur(${m*b*.4}px)`:(w=[0,0,0,0],k=`text-shadow: 0 0 ${m*b}px ${e}`))}const R=textGetStyles({...t,color:w,fontSize:u},b),P=textGetContentEditableStyles(e,t,b);return svgToImage(`<svg xmlns="http://www.w3.org/2000/svg" width="${y}" height="${_}" viewBox="0 0 ${y} ${_}"><foreignObject x="0" y="0" width="${y}" height="${_}"><div xmlns="http://www.w3.org/1999/xhtml">${v}<pre contenteditable="true" spellcheck="false" style="position:absolute;${C};${R};${P};${$};${T};${k}">${S}</pre></div></foreignObject></svg>`,{safariCacheKey:c})};const shapeEqual=(e,t)=>JSON.stringify(e)===JSON.stringify(t),shapeDeepCopy=e=>{const t={...e};return deepCopy(t)},getContextSize=(e,t={})=>{const o=rectAspectRatio(e);let r,n;const i=t.width||t.rx,a=t.height||t.ry;if(i&&a)return sizeClone(t);if(i||a){r=parseFloat(i||Number.MAX_SAFE_INTEGER),n=parseFloat(a||Number.MAX_SAFE_INTEGER);const e=Math.min(r,n);isString(i)||isString(a)?(r=`${e}%`,n=e*o+"%"):(r=e,n=e)}else{const e=10;r=`${e}%`,n=e*o+"%"}const s=t.width?"width":t.rx?"rx":void 0,l=t.width?"height":t.rx?"ry":void 0;return{[s||"width"]:r,[l||"height"]:n}},shapeCreateFromEmoji=(e,t={})=>({width:void 0,height:void 0,...t,aspectRatio:1,backgroundImage:SVGToDataURL(getEmojiSVG(e))}),shapeCreateFromImage=(e,t={})=>({backgroundColor:[0,0,0,0],...shapeIsEllipse(t)?{}:{width:void 0,height:void 0,aspectRatio:void 0},...t,backgroundImage:isString(e)?e:isBinary(e)?URL.createObjectURL(e):e}),shapeCreateFromPreset=(e,t)=>{let o;if(isString(e)||isBinary(e)){const r={...getContextSize(t),backgroundSize:"contain"};o=isEmoji(e)?shapeCreateFromEmoji(e,r):shapeCreateFromImage(e,r)}else if(e.src){const r=getContextSize(t,e.shape||e),n={...e.shape,...r};if(e.width&&e.height&&!hasProp(n,"aspectRatio")){const e=shapeGetPropPixelValue(r,"width",t),o=shapeGetPropPixelValue(r,"height",t);n.aspectRatio=getAspectRatio(e,o)}n.backgroundSize||e.shape||e.width&&e.height||(n.backgroundSize="contain"),o=isEmoji(e.src)?shapeCreateFromEmoji(e.src,n):shapeCreateFromImage(e.src,n)}else e.shape&&(o=shapeDeepCopy(e.shape));return hasProp(o,"backgroundImage")&&(hasProp(o,"backgroundColor")||(o.backgroundColor=[0,0,0,0]),hasProp(o,"disableStyle")||(o.disableStyle=["cornerRadius","backgroundColor","strokeColor","strokeWidth"])),t?shapeComputeDisplay(o,t):o},shapeLineGetStartPoint=e=>vectorCreate(e.x1,e.y1),shapeLineGetEndPoint=e=>vectorCreate(e.x2,e.y2),shapeIsText=e=>hasProp(e,"text"),shapeIsTextBlock=e=>shapeIsText(e)&&!(shapeHasRelativeSize(e)||hasProp(e,"width")),shapeIsTextBox=e=>shapeIsText(e)&&(shapeHasRelativeSize(e)||hasProp(e,"width")),shapeIsRect=e=>!shapeIsText(e)&&shapeHasComputedSize(e),shapeIsEllipse=e=>hasProp(e,"rx"),shapeIsLine=e=>hasProp(e,"x1"),shapeIsPath=e=>hasProp(e,"points"),shapeIsTextEmpty=e=>shapeIsText(e)&&!e.text.length,shapeIsTextEditing=e=>shapeIsText(e)&&e.isEditing,shapeIsVisible=e=>!hasProp(e,"opacity")||e.opacity>0,shapeIsSelected=e=>e.isSelected,shapeIsEditing=e=>e.isEditing,shapeIsDraft=e=>e._isDraft,shapeHasSize=e=>hasProp(e,"width")&&hasProp(e,"height"),shapeHasNumericStroke=e=>isNumber(e.strokeWidth)&&e.strokeWidth>0,shapeHasRelativePosition=e=>{const t=hasProp(e,"right"),o=hasProp(e,"bottom");return t||o},shapeHasTexture=e=>hasProp(e,"backgroundImage")||hasProp(e,"text"),shapeHasRelativeSize=e=>(hasProp(e,"x")||hasProp(e,"left"))&&hasProp(e,"right")||(hasProp(e,"y")||hasProp(e,"top"))&&hasProp(e,"bottom"),shapeHasComputedSize=e=>shapeHasSize(e)||shapeHasRelativeSize(e),shapeIsVisibleColor=(e,t)=>{const o=e[t];return!!o&&(3===o.length||o[3]>0)},shapeHasStroke=e=>e.strokeWidth&&shapeIsVisibleColor(e,"strokeColor"),shapeSelect=e=>(e.isSelected=!0,e),shapeMakeDraft=e=>(e._isDraft=!0,e),shapeMakeFinal=e=>(e._isDraft=!1,e),shapeCanStyle=(e,t)=>!0!==e.disableStyle&&(!isArray(e.disableStyle)||!t||!e.disableStyle.includes(t)),shapeCanAcceptSnap=e=>!0!==e.disableAcceptSnap,shapeCanSelect=e=>!0!==e.disableSelect,shapeCanRemove=e=>!0!==e.disableRemove,shapeCanDuplicate=e=>!0!==e.disableDuplicate&&shapeCanMove(e),shapeCanReorder=e=>!0!==e.disableReorder,shapeCanFlip=e=>!e.disableFlip&&(!shapeIsDraft(e)&&!shapeHasRelativePosition(e)&&shapeHasTexture(e)),shapeCanInput=(e,t)=>!!shapeIsText(e)&&(!0!==e.disableInput&&(isFunction(e.disableInput)?e.disableInput(null!=t?t:e.text):t||!0)),shapeCanChangeTextLayout=(e,t)=>!0!==e.disableTextLayout&&(!isArray(e.disableTextLayout)||!t||!e.disableTextLayout.includes(t)),shapeCanSelectPoint=e=>shapeCanAddPoint(e)&&e.points.length>3,shapeCanAddPoint=e=>!!shapeIsPath(e)&&(void 0!==e.disableAddPoints&&!0!==e.disableAddPoints),shapeCanManipulate=e=>!0!==e.disableManipulate&&!shapeIsDraft(e)&&!shapeHasRelativePosition(e),shapeCanMove=e=>shapeCanManipulate(e)&&!0!==e.disableMove,shapeCanResize=e=>shapeCanManipulate(e)&&shapeCanMove(e)&&!0!==e.disableResize&&(shapeHasSize(e)||shapeIsTextBox(e)||shapeIsEllipse(e)||shapeIsLine(e)||shapeIsPath(e)&&hasProp(e,"pathClose")),shapeCanRotate=e=>shapeCanManipulate(e)&&!0!==e.disableRotate&&(shapeHasSize(e)||hasProp(e,"text")||shapeIsEllipse(e)),shapeDeleteRelativeProps=e=>(delete e.left,delete e.right,delete e.top,delete e.bottom,e),shapeDeleteTransformProps=e=>(delete e.rotation,e),shapeFormatStroke=e=>(e.strokeWidth=e.strokeWidth||1,e.strokeColor=e.strokeColor||[0,0,0],e),shapeFormatFill=e=>(e.backgroundColor=e.backgroundColor?e.backgroundColor:e.strokeWidth||e.backgroundImage?void 0:[0,0,0],e),shapeFormatHTMLText=e=>{let t=e.text;t=t.replace(/&(#[0-9]+|[a-z]+);/gi,((e,t)=>`___${t}___`)),t=t.replace(/&/,"&amp;"),e.text=t.replace(/___(#[0-9]+|[a-z]+)___/gi,((e,t)=>`&${t};`))},shapeFormatPlainText=e=>{shapeFormatHTMLText(e);let t=e.text;t=t.replace(/</g,"&gt;"),t=t.replace(/>/g,"&lt;"),e.text=t},shapeFormatText=e=>{if(e.fontSize=e.fontSize||"4%",e.fontFamily=e.fontFamily||"sans-serif",e.fontWeight=e.fontWeight||"normal",e.fontStyle=e.fontStyle||"normal",e.fontVariant=e.fontVariant||"normal",e.lineHeight=e.lineHeight||"120%",e.color=e.color||[0,0,0],e.format="html"===e.format?"html":"text",e.textShadow){const[t,o,r,n]=e.textShadow;e.textShadowX=t,e.textShadowY=o,e.textShadowBlur=r,e.textShadowColor=n,delete e.textShadow}if(e.textOutline){const[t,o]=e.textOutline;e.textOutlineWidth=t,e.textOutlineColor=o,delete e.textOutline}return"html"===e.format?shapeFormatHTMLText(e):shapeFormatPlainText(e),shapeIsTextBlock(e)?shapeFormatTextBlock(e):shapeFormatTextBox(e)},shapeFormatTextBlock=e=>(!1!==e.disableNewline&&(delete e.textAlign,e.text=e.text.replace(/\n/g," ")),shapeDeleteRelativeProps(e)),shapeFormatTextBox=e=>(e.textAlign=e.textAlign||"left",e),shapeFormatRect=e=>(e.cornerRadius=e.cornerRadius||0,e.strokeWidth=e.strokeWidth||0,e.strokeColor=e.strokeColor||[0,0,0],shapeFormatFill(e)),shapeFormatEllipse=e=>(e.strokeWidth=e.strokeWidth||0,e.strokeColor=e.strokeColor||[0,0,0],shapeFormatFill(e)),shapeFormatPath=e=>(shapeFormatStroke(e),shapeDeleteTransformProps(e),hasProp(e,"pathClose")||(e.disableResize=!0,hasProp(e,"disableMove")||(e.disableMove=!0)),shapeDeleteRelativeProps(e)),shapeFormatLine=e=>(shapeFormatStroke(e),e.lineStart=e.lineStart||void 0,e.lineEnd=e.lineEnd||void 0,shapeDeleteTransformProps(e),shapeDeleteRelativeProps(e)),shapeFormatDefaults=e=>{isString(e.id)||(e.id=getUniqueId()),hasProp(e,"rotation")||(e.rotation=0),hasProp(e,"opacity")||(e.opacity=1),hasProp(e,"disableErase")||(e.disableErase=!0)},shapeFormat=e=>(shapeFormatDefaults(e),shapeIsText(e)?shapeFormatText(e):shapeIsRect(e)?shapeFormatRect(e):shapeIsPath(e)?shapeFormatPath(e):shapeIsLine(e)?shapeFormatLine(e):shapeIsEllipse(e)&&shapeFormatEllipse(e),e),shapeGetDescription=e=>shapeIsText(e)?"text":shapeIsRect(e)?"rectangle":shapeIsPath(e)?"path":shapeIsLine(e)?"line":shapeIsEllipse(e)?"ellipse":void 0,toPixelValue=(e,t)=>parseFloat(e)/100*t,xRegExp=new RegExp(/^x|left|right|^width|rx|fontSize|eraseRadius|feather|cornerRadius|strokeWidth|strokeDash/,"i"),yRegExp=new RegExp(/^y|top|bottom|^height|ry/,"i"),compute=(e,t,{width:o,height:r})=>{if(Array.isArray(t))return t.map((t=>(isObject(t)&&computeProps(t,{width:o,height:r}),isString(t)&&(t=compute(e,t,{width:o,height:r})),t)));if("string"!=typeof t)return t;if(!t.endsWith("%"))return t;const n=parseFloat(t)/100;return xRegExp.test(e)?fixPrecision(o*n,6):yRegExp.test(e)?fixPrecision(r*n,6):t},shapeComputeProp=compute,computeRelativeToValue=(e,t)=>Math.round(t*(parseFloat(e)/100)),PROPS_RELATIVE_TO_FONT_SIZE=["lineHeight","textOutlineWidth","textShadowX","textShadowY","textShadowBlur"],computeProps=(e,t)=>{Object.entries(e).map((([o,r])=>{e[o]=compute(o,r,t)})),e.text&&PROPS_RELATIVE_TO_FONT_SIZE.filter((t=>isString(e[t]))).forEach((t=>{e[t]=computeRelativeToValue(e[t],e.fontSize)}))},shapeComputeDisplay=(e,t)=>(computeProps(e,t),shapeComputeRect(e,t),e),shapeGetPropPixelTotal=(e,t)=>{let o;return/^x|width|rx|fontSize|strokeWidth|cornerRadius/.test(e)?o=t.width:/^y|height|ry/.test(e)&&(o=t.height),o},shapeUpdateProp=(e,t,o,r)=>{if(!isString(e[t]))return e[t]=o,e;const n=shapeGetPropPixelTotal(t,r);return e[t]=void 0===n?o:toPercentage(o,n),e},shapeGetPropPixelValue=(e,t,o)=>Array.isArray(e[t])?e[t].map((e=>Object.entries(e).reduce(((e,[t,r])=>(e[t]=isString(r)?toPixelValue(r,shapeGetPropPixelTotal(t,o)):r,e)),{}))):isString(e[t])?toPixelValue(e[t],shapeGetPropPixelTotal(t,o)):e[t],shapeGetPropsPixelValues=(e,t,o)=>t.reduce(((t,r)=>{const n=shapeGetPropPixelValue(e,r,o);return t[r]=n,t}),{}),shapeUpdateProps=(e,t,o)=>(Object.keys(t).forEach((r=>shapeUpdateProp(e,r,t[r],o))),e),shapeBounds=e=>{const t=rectCreateEmpty(),o=e.strokeWidth||0;if(shapeIsRect(e))t.x=e.x-.5*o,t.y=e.y-.5*o,t.width=e.width+o,t.height=e.height+o;else if(shapeIsLine(e)){const{x1:r,y1:n,x2:i,y2:a}=e,s=Math.abs(Math.min(r,i)),l=Math.abs(Math.max(r,i)),c=Math.abs(Math.min(n,a)),u=Math.abs(Math.min(n,a));t.x=s+.5*o,t.y=l+.5*o,t.width=l-s+o,t.height=u-c+o}else shapeIsEllipse(e)&&(t.x=e.x-e.rx+.5*o,t.y=e.y-e.ry+.5*o,t.width=2*e.rx+o,t.height=2*e.ry+o);return t&&hasProp(e,"rotation")&&rectRotate(t,e.rotation),rectToBounds(t)},shapesBounds=(e,t)=>{const o=e.filter((e=>e.x<0||e.y<0||e.x1<0||e.y1<0)).reduce(((e,t)=>{const[o,r,n,i]=shapeBounds(t);return e.top=Math.min(o,e.top),e.left=Math.min(i,e.left),e.bottom=Math.max(n,e.bottom),e.right=Math.max(r,e.right),e}),{top:0,right:0,bottom:0,left:0});return o.right>0&&(o.right-=t.width),o.bottom>0&&(o.bottom-=t.height),o},shapesFromCompositShape=(e,t,o)=>{const r=shapeDeepCopy(e);shapeComputeDisplay(r,t);const n=o(r);return Array.isArray(n)?n:[n]},shapeComputeRect=(e,t)=>{if(hasProp(e,"left")&&(e.x=e.left),hasProp(e,"right")&&!isString(e.right)){const o=t.width-e.right;hasProp(e,"left")?(e.x=e.left,e.width=Math.max(0,o-e.left)):hasProp(e,"width")&&(e.x=o-e.width)}if(hasProp(e,"top")&&(e.y=e.top),hasProp(e,"bottom")&&!isString(e.bottom)){const o=t.height-e.bottom;hasProp(e,"top")?(e.y=e.top,e.height=Math.max(0,o-e.top)):hasProp(e,"height")&&(e.y=o-e.height)}return e},shapeScale=(e,t)=>(shapeIsPath(e)&&e.points.filter((e=>isNumber(e.x))).forEach((e=>{e.x*=t,e.y*=t})),shapeIsLine(e)&&isNumber(e.x1)&&(e.x1*=t,e.y1*=t,e.x2*=t,e.y2*=t),isNumber(e.x)&&isNumber(e.y)&&(e.x*=t,e.y*=t),isNumber(e.width)&&isNumber(e.height)&&(e.width*=t,e.height*=t),isNumber(e.rx)&&isNumber(e.ry)&&(e.rx*=t,e.ry*=t),shapeHasNumericStroke(e)&&(e.strokeWidth*=t),shapeIsText(e)&&(e._scale=t,isNumber(e.fontSize)&&(e.fontSize*=t),isNumber(e.lineHeight)&&(e.lineHeight*=t),isNumber(e.width)&&!isNumber(e.height)&&(e.width*=t)),hasProp(e,"cornerRadius")&&isNumber(e.cornerRadius)&&(e.cornerRadius*=t),e),shapeGetLength=e=>{if(e.x1)return vectorDistance(vectorCreate(e.x1,e.y1),vectorCreate(e.x2,e.y2))},shapeGetCenter=e=>{if(shapeIsRect(e))return vectorCreate(e.x+.5*e.width,e.y+.5*e.height);if(shapeIsEllipse(e))return vectorCreate(e.x,e.y);if(e.text){if(shapeIsTextBox(e)){const t=e.height||textToSize(e.text,e).height;return vectorCreate(e.x+.5*e.width,e.y+.5*t)}const t=textToSize(e.text,e);return vectorCreate(e.x+.5*t.width,e.y+.5*t.height)}return shapeIsPath(e)?vectorCenter(e.points):shapeIsLine(e)?vectorCenter([shapeLineGetStartPoint(e),shapeLineGetEndPoint(e)]):void 0},shapeGetLevel=(e,t)=>{let o=!1;t.flipX&&e.flipX?o=!0:!t.flipX&&e.flipX?o=!1:t.flipX&&!e.flipX&&(o=!0);let r=!1;t.flipY&&e.flipY?r=!0:!t.flipY&&e.flipY?r=!1:t.flipY&&!e.flipY&&(r=!0);let n=-t.rotation;return!o&&!r||o&&r||(n=-n),{flipX:o,flipY:r,rotation:n}};var ctxRoundRect=(e,t,o,r,n,i)=>(r<2*i&&(i=r/2),n<2*i&&(i=n/2),e.beginPath(),e.moveTo(t+i,o),e.arcTo(t+r,o,t+r,o+n,i),e.arcTo(t+r,o+n,t,o+n,i),e.arcTo(t,o+n,t,o,i),e.arcTo(t,o,t+r,o,i),e.closePath(),e),isCanvas=e=>/canvas/i.test(e.nodeName),isRemoteURL=e=>new URL(e,location.href).origin!==location.origin,loadImage=(e,t=void 0)=>new Promise(((o,r)=>{let n=e,i=!1;const a=()=>{i||(i=!0,isFunction(t)&&Promise.resolve().then((()=>t(sizeCreate(n.naturalWidth,n.naturalHeight)))))};if(n.src||(n=new Image,isString(e)&&isRemoteURL(e)&&(n.crossOrigin="anonymous"),n.src=isString(e)?e:URL.createObjectURL(e)),n.complete)return a(),o(n);isFunction(t)&&getImageElementSize(n).then(a).catch(r),n.onload=()=>{a(),o(n)},n.onerror=()=>r(new Error("Failed to load image"))}));const cache=new Map([]),getImage=(e,t={})=>new Promise(((o,r)=>{const{onMetadata:n=noop$1,onLoad:i=o,onError:a=r,onComplete:s=noop$1}=t;let l=cache.get(e);if(l||(l={loading:!1,complete:!1,error:!1,image:void 0,size:void 0,bus:pubsub()},cache.set(e,l)),l.bus.sub("meta",n),l.bus.sub("load",i),l.bus.sub("error",a),l.bus.sub("complete",s),isCanvas(e)){const t=e,o=t.cloneNode();l.complete=!0,l.image=o,l.size=sizeCreateFromElement(t)}if(l.complete)return l.bus.pub("meta",{size:l.size}),l.error?l.bus.pub("error",l.error):l.bus.pub("load",l.image),l.bus.pub("complete"),void(l.bus=pubsub());l.loading||(l.loading=!0,loadImage(e,(e=>{l.size=e,l.bus.pub("meta",{size:e})})).then((e=>{l.image=e,l.bus.pub("load",e)})).catch((e=>{l.error=e,l.bus.pub("error",e)})).finally((()=>{l.complete=!0,l.loading=!1,l.bus.pub("complete"),l.bus=pubsub()})))})),drawCanvas=(e,t,o,r)=>e.drawImage(t,o.x,o.x,o.width,o.height,r.x,r.y,r.width,r.height);var ctxDrawImage=async(e,t,o,r,n=drawCanvas,i)=>{e.save(),e.clip(),await n(e,t,o,r,i),e.restore()};const getDrawImageParams=(e,t,o,r,n)=>{const i=rectClone$1(e);if(r){const e=rectApply(rectCreateFromPoints(r),fixPrecision);return e.x*=o.width,e.width*=o.width,e.y*=o.height,e.height*=o.height,{srcRect:e,destRect:i}}const a=rectCreate(0,0,o.width,o.height);if("contain"===t){const t=rectContainRect(e,rectAspectRatio(a));i.width=t.width,i.height=t.height,n?(i.x+=n.x,i.y+=n.y):(i.x+=t.x,i.y+=t.y)}else if("cover"===t){const e=rectCoverRect(i,a.width/a.height);i.width=e.width,i.height=e.height,n?(i.x+=n.x,i.y+=n.y):(i.x+=e.x,i.y+=e.y)}else t?(i.width=t.width,i.height=t.height,n&&(i.x+=n.x,i.y+=n.y)):n&&(i.width=o.width,i.height=o.height,i.x+=n.x,i.y+=n.y);return{srcRect:a,destRect:i}},defineRectShape=(e,t)=>(t.cornerRadius>0?ctxRoundRect(e,t.x,t.y,t.width,t.height,t.cornerRadius):e.rect(t.x,t.y,t.width,t.height),e),fillRectShape=(e,t)=>(t.backgroundColor&&e.fill(),e),strokeRectShape=(e,t)=>(t.strokeWidth&&e.stroke(),e);var drawRect=async(e,t,o={})=>{const{drawImage:r}=o;if(e.lineWidth=t.strokeWidth?t.strokeWidth:1,e.strokeStyle=t.strokeColor?colorArrayToRGBA(t.strokeColor):"none",e.fillStyle=t.backgroundColor?colorArrayToRGBA(t.backgroundColor):"none",e.globalAlpha=t.opacity,t.backgroundImage){let o;if(o=isCanvas(t.backgroundImage)?t.backgroundImage:await getImage(t.backgroundImage),defineRectShape(e,t),fillRectShape(e,t),"repeat"===t.backgroundRepeat){const n=t.backgroundPosition||{x:0,y:0},{srcRect:i,destRect:a}=getDrawImageParams(t,t.backgroundSize||sizeCreateFromElement(o),sizeCreateFromElement(o),t.backgroundCorners,{x:0,y:0}),s=document.createElement("canvas");s.width=a.width,s.height=a.height;const l=s.getContext("2d",{willReadFrequently:!1,desynchronized:!0});await r(l,o,i,{...a,x:0,y:0});const c=e.createPattern(s,"repeat");e.fillStyle=c,e.save(),e.beginPath(),e.rect(t.x+n.x,t.y+n.y,t.width-n.x,t.height-n.y),e.clip(),e.translate(a.x+n.x,a.y+n.y),e.fill(),releaseCanvas(s),e.restore()}else{const{srcRect:n,destRect:i}=getDrawImageParams(t,t.backgroundSize,sizeCreateFromElement(o),t.backgroundCorners,t.backgroundPosition);await ctxDrawImage(e,o,n,i,r,{feather:t.feather})}return e.beginPath(),defineRectShape(e,t),strokeRectShape(e,t),[]}return defineRectShape(e,t),fillRectShape(e,t),strokeRectShape(e,t),[]},drawEllipse=async(e,t,o={})=>new Promise((async(r,n)=>{const{drawImage:i}=o;if(e.lineWidth=t.strokeWidth||1,e.strokeStyle=t.strokeColor?colorArrayToRGBA(t.strokeColor):"none",e.fillStyle=t.backgroundColor?colorArrayToRGBA(t.backgroundColor):"none",e.globalAlpha=t.opacity,e.ellipse(t.x,t.y,t.rx,t.ry,0,0,2*Math.PI),t.backgroundColor&&e.fill(),t.backgroundImage){let o;try{o=await getImage(t.backgroundImage)}catch(e){n(e)}const a=rectCreate(t.x-t.rx,t.y-t.ry,2*t.rx,2*t.ry),{srcRect:s,destRect:l}=getDrawImageParams(a,t.backgroundSize,sizeCreateFromElement(o),t.backgroundCorners,t.backgroundPosition);await ctxDrawImage(e,o,s,l,i),t.strokeWidth&&e.stroke(),r([])}else t.strokeWidth&&e.stroke(),r([])})),drawText=async(e,t,o)=>{const r=isNumber(t.width)?Math.floor(t.width):void 0,n=isNumber(t.height)?Math.floor(t.height):void 0,i=r&&n?sizeCreateFromAny(t):textToSize(t.text,{...t,width:r,height:n}),a={x:t.x,y:t.y,width:i.width,height:i.height};if(drawRect(e,{...t,...a,options:o}),!t.text.length)return[];const{textOutlineWidth:s=0,textShadowX:l=0,textShadowY:c=0,textShadowBlur:u=0,textShadowColor:p,outline:d,blur:h,...m}=t,g=!!t.height;if(g&&(e.rect(a.x,a.y,a.width,a.height),e.save(),e.clip()),l||c||u){e.save(),e.translate(l,c);const i={...a};g||(i.height+=TextPadding+u),await drawTextImage(e,i,{...t,width:r,height:n},{...o,paddingLeft:TextPadding+u,paddingRight:TextPadding+u,paddingTop:u,paddingBottom:u+(g?-1*c:t.fontSize),shapeExtendedProps:{color:p,blur:u}}),e.restore()}if(s){const i={...a};g||(i.height+=TextPadding+s),await drawTextImage(e,i,{...t,width:r,height:n},{...o,paddingLeft:TextPadding+s,paddingRight:TextPadding+s,paddingTop:s,paddingBottom:s+g?0:t.fontSize,shapeExtendedProps:{color:t.textOutlineColor,outline:s}})}return g&&e.restore(),await drawTextImage(e,a,{...m,width:r,height:n},{...o,paddingLeft:TextPadding,paddingRight:TextPadding,paddingTop:0,paddingBottom:g?0:t.fontSize}),[]};const drawTextImage=async(e,t,o,r)=>{const{willRequest:n,shapeExtendedProps:i,paddingLeft:a,paddingRight:s,paddingTop:l,paddingBottom:c,styleNonce:u}=r,p=isNumber(o.width)?Math.floor(t.width):void 0,d=isNumber(o.height)?Math.floor(t.height):void 0,h=Math.ceil(t.width),m=Math.ceil(t.height),g=await textToImage(o.text,{...o,...i,...t,width:p,height:d,paddingLeft:a,paddingRight:s,paddingTop:l,paddingBottom:c,imageWidth:h,imageHeight:m,willRequest:n,styleNonce:u});e.drawImage(g,o.x-a,o.y-l,g.width,g.height)};var drawLine=async(e,t)=>new Promise((async o=>{e.lineWidth=t.strokeWidth||1,e.strokeStyle=t.strokeColor?colorArrayToRGBA(t.strokeColor):"none",e.globalAlpha=t.opacity,t.bitmap&&(e.lineCap=t.strokeCap,e.lineJoin=t.strokeJoin,e.setLineDash(t.strokeDash||[]));let r=shapeLineGetStartPoint(t),n=shapeLineGetEndPoint(t);e.moveTo(r.x,r.y),e.lineTo(n.x,n.y),t.strokeWidth&&e.stroke(),o([])})),drawPath=async(e,t)=>new Promise(((o,r)=>{if(t.bitmap&&1===t.points.length)return void drawEllipse(e,{x:t.points[0].x,y:t.points[0].y,rx:.5*t.strokeWidth,ry:.5*t.strokeWidth,backgroundColor:t.strokeColor}).then((()=>o([])));e.lineWidth=t.strokeWidth||1,e.strokeStyle=t.strokeColor?colorArrayToRGBA(t.strokeColor):"none",e.fillStyle=t.backgroundColor?colorArrayToRGBA(t.backgroundColor):"none",e.globalAlpha=t.opacity;const{points:n}=t;t.bitmap&&(e.lineCap=t.strokeCap,e.lineJoin=t.strokeJoin,e.setLineDash(t.strokeDash||[])),t.pathClose&&e.beginPath(),e.moveTo(n[0].x,n[0].y);const i=n.length;for(let t=1;t<i;t++)e.lineTo(n[t].x,n[t].y);t.pathClose&&e.closePath(),t.strokeWidth&&e.stroke(),t.backgroundColor&&e.fill(),o([])})),ctxFlip=(e,t,o,r)=>t||o?(e.translate(r.x,r.y),e.scale(t?-1:1,o?-1:1),e.translate(-r.x,-r.y),e):e;const drawShape=async(e,t,o)=>{e.globalCompositeOperation="subtract"===t.drawMode?"destination-out":"source-over";const r=shapeGetCenter(t);let n;if(ctxRotate(e,t.rotation,r),ctxFlip(e,t.flipX,t.flipY,r),shapeIsRect(t)?n=drawRect:shapeIsEllipse(t)?n=drawEllipse:shapeIsLine(t)?n=drawLine:shapeIsPath(t)?n=drawPath:shapeIsText(t)&&(n=drawText),n){const r=await n(e,t,o);if(!r.length)return[];return[t,...await drawShapes(e,r,o)]}return[]};var drawShapes=async(e,t,o)=>{let r=[];for(const n of t)e.save(),e.beginPath(),r=[...r,...await drawShape(e,n,o)],e.restore();return r},drawImageData=async(e,t={})=>{const{shapes:o=[],contextBounds:r=e,transform:n=noop$1,drawImage:i,willRequest:a,styleNonce:s,canvasMemoryLimit:l,computeShape:c=passthrough,preprocessShape:u=passthrough}=t;if(!o.length)return e;const p=h("canvas");p.width=r.width,p.height=r.height;const d=p.getContext("2d",{willReadFrequently:!0});d.putImageData(e,r.x||0,r.y||0);const m=o.map(shapeDeepCopy).map(c).map(u).flat().filter(Boolean);n(d),await drawShapes(d,m,{drawImage:i,canvasMemoryLimit:l,willRequest:a,styleNonce:s});const g=d.getImageData(0,0,p.width,p.height);return releaseCanvas(p),g},fillImageData=async(e,t={})=>{const{backgroundColor:o,backgroundImage:r}=t,n=!(!o||o&&0===o[3]);if(!r&&!n)return e;const i=h("canvas");i.width=e.width,i.height=e.height;const a=i.getContext("2d",{willReadFrequently:!0});if(a.putImageData(e,0,0),a.globalCompositeOperation="destination-over",n&&(a.fillStyle=colorArrayToRGBA(o),a.fillRect(0,0,i.width,i.height)),r){let t;t=isCanvas(r)?r:await getImage(r);const{srcRect:o,destRect:n}=getDrawImageParams({x:0,y:0,width:e.width,height:e.height},"cover",{width:t.width,height:t.height});a.drawImage(t,o.x,o.y,o.width,o.height,n.x,n.y,n.width,n.height)}const s=a.getImageData(0,0,i.width,i.height);return releaseCanvas(i),s},dotColorMatrix=(e,t)=>{const o=new Array(20);return o[0]=e[0]*t[0]+e[1]*t[5]+e[2]*t[10]+e[3]*t[15],o[1]=e[0]*t[1]+e[1]*t[6]+e[2]*t[11]+e[3]*t[16],o[2]=e[0]*t[2]+e[1]*t[7]+e[2]*t[12]+e[3]*t[17],o[3]=e[0]*t[3]+e[1]*t[8]+e[2]*t[13]+e[3]*t[18],o[4]=e[0]*t[4]+e[1]*t[9]+e[2]*t[14]+e[3]*t[19]+e[4],o[5]=e[5]*t[0]+e[6]*t[5]+e[7]*t[10]+e[8]*t[15],o[6]=e[5]*t[1]+e[6]*t[6]+e[7]*t[11]+e[8]*t[16],o[7]=e[5]*t[2]+e[6]*t[7]+e[7]*t[12]+e[8]*t[17],o[8]=e[5]*t[3]+e[6]*t[8]+e[7]*t[13]+e[8]*t[18],o[9]=e[5]*t[4]+e[6]*t[9]+e[7]*t[14]+e[8]*t[19]+e[9],o[10]=e[10]*t[0]+e[11]*t[5]+e[12]*t[10]+e[13]*t[15],o[11]=e[10]*t[1]+e[11]*t[6]+e[12]*t[11]+e[13]*t[16],o[12]=e[10]*t[2]+e[11]*t[7]+e[12]*t[12]+e[13]*t[17],o[13]=e[10]*t[3]+e[11]*t[8]+e[12]*t[13]+e[13]*t[18],o[14]=e[10]*t[4]+e[11]*t[9]+e[12]*t[14]+e[13]*t[19]+e[14],o[15]=e[15]*t[0]+e[16]*t[5]+e[17]*t[10]+e[18]*t[15],o[16]=e[15]*t[1]+e[16]*t[6]+e[17]*t[11]+e[18]*t[16],o[17]=e[15]*t[2]+e[16]*t[7]+e[17]*t[12]+e[18]*t[17],o[18]=e[15]*t[3]+e[16]*t[8]+e[17]*t[13]+e[18]*t[18],o[19]=e[15]*t[4]+e[16]*t[9]+e[17]*t[14]+e[18]*t[19]+e[19],o},getColorMatrixFromColorMatrices=e=>e.length?e.reduce(((e,t)=>dotColorMatrix([...e],t)),e.shift()):[],roundFraction=(e,t=2)=>Math.round(e*t)/t,getImageRedactionScaleFactor=(e,t)=>{const o=e.width*e.height,r=t.reduce(((e,t)=>(t.width>e.width&&t.height>e.height&&(e.width=t.width,e.height=t.height),e)),{width:0,height:0}),n=r.width*r.height,i=Math.max(.5,.5+(1-n/o)/2);return roundFraction(i,5)};function noop(){}const identity=e=>e;function assign(e,t){for(const o in t)e[o]=t[o];return e}function run(e){return e()}function blank_object(){return Object.create(null)}function run_all(e){e.forEach(run)}function is_function(e){return"function"==typeof e}function safe_not_equal(e,t){return e!=e?t==t:e!==t||e&&"object"==typeof e||"function"==typeof e}let src_url_equal_anchor;function src_url_equal(e,t){return src_url_equal_anchor||(src_url_equal_anchor=document.createElement("a")),src_url_equal_anchor.href=t,e===src_url_equal_anchor.href}function is_empty(e){return 0===Object.keys(e).length}function subscribe(e,...t){if(null==e)return noop;const o=e.subscribe(...t);return o.unsubscribe?()=>o.unsubscribe():o}function get_store_value(e){let t;return subscribe(e,(e=>t=e))(),t}function component_subscribe(e,t,o){e.$$.on_destroy.push(subscribe(t,o))}function create_slot(e,t,o,r){if(e){const n=get_slot_context(e,t,o,r);return e[0](n)}}function get_slot_context(e,t,o,r){return e[1]&&r?assign(o.ctx.slice(),e[1](r(t))):o.ctx}function get_slot_changes(e,t,o,r){if(e[2]&&r){const n=e[2](r(o));if(void 0===t.dirty)return n;if("object"==typeof n){const e=[],o=Math.max(t.dirty.length,n.length);for(let r=0;r<o;r+=1)e[r]=t.dirty[r]|n[r];return e}return t.dirty|n}return t.dirty}function update_slot_base(e,t,o,r,n,i){if(n){const a=get_slot_context(t,o,r,i);e.p(a,n)}}function get_all_dirty_from_scope(e){if(e.ctx.length>32){const t=[],o=e.ctx.length/32;for(let e=0;e<o;e++)t[e]=-1;return t}return-1}function exclude_internal_props(e){const t={};for(const o in e)"$"!==o[0]&&(t[o]=e[o]);return t}function compute_rest_props(e,t){const o={};t=new Set(t);for(const r in e)t.has(r)||"$"===r[0]||(o[r]=e[r]);return o}function set_store_value(e,t,o){return e.set(o),t}function action_destroyer(e){return e&&is_function(e.destroy)?e.destroy:noop}const is_client="undefined"!=typeof window;let now=is_client?()=>window.performance.now():()=>Date.now(),raf=is_client?e=>requestAnimationFrame(e):noop;const tasks=new Set;function run_tasks(e){tasks.forEach((t=>{t.c(e)||(tasks.delete(t),t.f())})),0!==tasks.size&&raf(run_tasks)}function loop(e){let t;return 0===tasks.size&&raf(run_tasks),{promise:new Promise((o=>{tasks.add(t={c:e,f:o})})),abort(){tasks.delete(t)}}}function append(e,t){e.appendChild(t)}function get_root_for_style(e){if(!e)return document;const t=e.getRootNode?e.getRootNode():e.ownerDocument;return t&&t.host?t:e.ownerDocument}function append_empty_stylesheet(e){const t=element("style");return append_stylesheet(get_root_for_style(e),t),t.sheet}function append_stylesheet(e,t){return append(e.head||e,t),t.sheet}function insert(e,t,o){e.insertBefore(t,o||null)}function detach(e){e.parentNode.removeChild(e)}function element(e){return document.createElement(e)}function svg_element(e){return document.createElementNS("http://www.w3.org/2000/svg",e)}function text(e){return document.createTextNode(e)}function space(){return text(" ")}function empty(){return text("")}function listen(e,t,o,r){return e.addEventListener(t,o,r),()=>e.removeEventListener(t,o,r)}function prevent_default(e){return function(t){return t.preventDefault(),e.call(this,t)}}function stop_propagation(e){return function(t){return t.stopPropagation(),e.call(this,t)}}function attr(e,t,o){null==o?e.removeAttribute(t):e.getAttribute(t)!==o&&e.setAttribute(t,o)}function set_attributes(e,t){const o=Object.getOwnPropertyDescriptors(e.__proto__);for(const r in t)null==t[r]?e.removeAttribute(r):"style"===r?e.style.cssText=t[r]:"__value"===r?e.value=e[r]=t[r]:o[r]&&o[r].set?e[r]=t[r]:attr(e,r,t[r])}function set_custom_element_data_map(e,t){Object.keys(t).forEach((o=>{set_custom_element_data(e,o,t[o])}))}function set_custom_element_data(e,t,o){t in e?e[t]="boolean"==typeof e[t]&&""===o||o:attr(e,t,o)}function children(e){return Array.from(e.childNodes)}function set_data(e,t){t=""+t,e.wholeText!==t&&(e.data=t)}function set_input_value(e,t){e.value=null==t?"":t}function set_style(e,t,o,r){null===o?e.style.removeProperty(t):e.style.setProperty(t,o,r?"important":"")}function custom_event(e,t,{bubbles:o=!1,cancelable:r=!1}={}){const n=document.createEvent("CustomEvent");return n.initCustomEvent(e,o,r,t),n}class HtmlTag{constructor(e=!1){this.is_svg=!1,this.is_svg=e,this.e=this.n=null}c(e){this.h(e)}m(e,t,o=null){this.e||(this.is_svg?this.e=svg_element(t.nodeName):this.e=element(t.nodeName),this.t=t,this.c(e)),this.i(o)}h(e){this.e.innerHTML=e,this.n=Array.from(this.e.childNodes)}i(e){for(let t=0;t<this.n.length;t+=1)insert(this.t,this.n[t],e)}p(e){this.d(),this.h(e),this.i(this.a)}d(){this.n.forEach(detach)}}function construct_svelte_component(e,t){return new e(t)}const managed_styles=new Map;let current_component,active=0;function hash(e){let t=5381,o=e.length;for(;o--;)t=(t<<5)-t^e.charCodeAt(o);return t>>>0}function create_style_information(e,t){const o={stylesheet:append_empty_stylesheet(t),rules:{}};return managed_styles.set(e,o),o}function create_rule(e,t,o,r,n,i,a,s=0){const l=16.666/r;let c="{\n";for(let e=0;e<=1;e+=l){const r=t+(o-t)*i(e);c+=100*e+`%{${a(r,1-r)}}\n`}const u=c+`100% {${a(o,1-o)}}\n}`,p=`__svelte_${hash(u)}_${s}`,d=get_root_for_style(e),{stylesheet:h,rules:m}=managed_styles.get(d)||create_style_information(d,e);m[p]||(m[p]=!0,h.insertRule(`@keyframes ${p} ${u}`,h.cssRules.length));const g=e.style.animation||"";return e.style.animation=`${g?`${g}, `:""}${p} ${r}ms linear ${n}ms 1 both`,active+=1,p}function delete_rule(e,t){const o=(e.style.animation||"").split(", "),r=o.filter(t?e=>e.indexOf(t)<0:e=>-1===e.indexOf("__svelte")),n=o.length-r.length;n&&(e.style.animation=r.join(", "),active-=n,active||clear_rules())}function clear_rules(){raf((()=>{active||(managed_styles.forEach((e=>{const{ownerNode:t}=e.stylesheet;t&&detach(t)})),managed_styles.clear())}))}function set_current_component(e){current_component=e}function get_current_component(){if(!current_component)throw new Error("Function called outside component initialization");return current_component}function onMount(e){get_current_component().$$.on_mount.push(e)}function afterUpdate(e){get_current_component().$$.after_update.push(e)}function onDestroy(e){get_current_component().$$.on_destroy.push(e)}function createEventDispatcher(){const e=get_current_component();return(t,o,{cancelable:r=!1}={})=>{const n=e.$$.callbacks[t];if(n){const i=custom_event(t,o,{cancelable:r});return n.slice().forEach((t=>{t.call(e,i)})),!i.defaultPrevented}return!0}}function setContext(e,t){return get_current_component().$$.context.set(e,t),t}function getContext(e){return get_current_component().$$.context.get(e)}function getAllContexts(){return get_current_component().$$.context}function bubble(e,t){const o=e.$$.callbacks[t.type];o&&o.slice().forEach((e=>e.call(this,t)))}const dirty_components=[],binding_callbacks=[],render_callbacks=[],flush_callbacks=[],resolved_promise=Promise.resolve();let update_scheduled=!1;function schedule_update(){update_scheduled||(update_scheduled=!0,resolved_promise.then(flush))}function tick$1(){return schedule_update(),resolved_promise}function add_render_callback(e){render_callbacks.push(e)}function add_flush_callback(e){flush_callbacks.push(e)}const seen_callbacks=new Set;let promise,flushidx=0;function flush(){const e=current_component;do{for(;flushidx<dirty_components.length;){const e=dirty_components[flushidx];flushidx++,set_current_component(e),update(e.$$)}for(set_current_component(null),dirty_components.length=0,flushidx=0;binding_callbacks.length;)binding_callbacks.pop()();for(let e=0;e<render_callbacks.length;e+=1){const t=render_callbacks[e];seen_callbacks.has(t)||(seen_callbacks.add(t),t())}render_callbacks.length=0}while(dirty_components.length);for(;flush_callbacks.length;)flush_callbacks.pop()();update_scheduled=!1,seen_callbacks.clear(),set_current_component(e)}function update(e){if(null!==e.fragment){e.update(),run_all(e.before_update);const t=e.dirty;e.dirty=[-1],e.fragment&&e.fragment.p(e.ctx,t),e.after_update.forEach(add_render_callback)}}function wait(){return promise||(promise=Promise.resolve(),promise.then((()=>{promise=null}))),promise}function dispatch(e,t,o){e.dispatchEvent(custom_event(`${t?"intro":"outro"}${o}`))}const outroing=new Set;let outros;function group_outros(){outros={r:0,c:[],p:outros}}function check_outros(){outros.r||run_all(outros.c),outros=outros.p}function transition_in(e,t){e&&e.i&&(outroing.delete(e),e.i(t))}function transition_out(e,t,o,r){if(e&&e.o){if(outroing.has(e))return;outroing.add(e),outros.c.push((()=>{outroing.delete(e),r&&(o&&e.d(1),r())})),e.o(t)}else r&&r()}const null_transition={duration:0};function create_bidirectional_transition(e,t,o,r){let n=t(e,o),i=r?0:1,a=null,s=null,l=null;function c(){l&&delete_rule(e,l)}function u(e,t){const o=e.b-i;return t*=Math.abs(o),{a:i,b:e.b,d:o,duration:t,start:e.start,end:e.start+t,group:e.group}}function p(t){const{delay:o=0,duration:r=300,easing:p=identity,tick:d=noop,css:h}=n||null_transition,m={start:now()+o,b:t};t||(m.group=outros,outros.r+=1),a||s?s=m:(h&&(c(),l=create_rule(e,i,t,r,o,p,h)),t&&d(0,1),a=u(m,r),add_render_callback((()=>dispatch(e,t,"start"))),loop((t=>{if(s&&t>s.start&&(a=u(s,r),s=null,dispatch(e,a.b,"start"),h&&(c(),l=create_rule(e,i,a.b,a.duration,0,p,n.css))),a)if(t>=a.end)d(i=a.b,1-i),dispatch(e,a.b,"end"),s||(a.b?c():--a.group.r||run_all(a.group.c)),a=null;else if(t>=a.start){const e=t-a.start;i=a.a+a.d*p(e/a.duration),d(i,1-i)}return!(!a&&!s)})))}return{run(e){is_function(n)?wait().then((()=>{n=n(),p(e)})):p(e)},end(){c(),a=s=null}}}const globals="undefined"!=typeof window?window:"undefined"!=typeof globalThis?globalThis:global;function destroy_block(e,t){e.d(1),t.delete(e.key)}function outro_and_destroy_block(e,t){transition_out(e,1,1,(()=>{t.delete(e.key)}))}function update_keyed_each(e,t,o,r,n,i,a,s,l,c,u,p){let d=e.length,h=i.length,m=d;const g={};for(;m--;)g[e[m].key]=m;const f=[],$=new Map,b=new Map;for(m=h;m--;){const e=p(n,i,m),s=o(e);let l=a.get(s);l?r&&l.p(e,t):(l=c(s,e),l.c()),$.set(s,f[m]=l),s in g&&b.set(s,Math.abs(m-g[s]))}const y=new Set,_=new Set;function x(e){transition_in(e,1),e.m(s,u),a.set(e.key,e),u=e.first,h--}for(;d&&h;){const t=f[h-1],o=e[d-1],r=t.key,n=o.key;t===o?(u=t.first,d--,h--):$.has(n)?!a.has(r)||y.has(r)?x(t):_.has(n)?d--:b.get(r)>b.get(n)?(_.add(r),x(t)):(y.add(n),d--):(l(o,a),d--)}for(;d--;){const t=e[d];$.has(t.key)||l(t,a)}for(;h;)x(f[h-1]);return f}function get_spread_update(e,t){const o={},r={},n={$$scope:1};let i=e.length;for(;i--;){const a=e[i],s=t[i];if(s){for(const e in a)e in s||(r[e]=1);for(const e in s)n[e]||(o[e]=s[e],n[e]=1);e[i]=s}else for(const e in a)n[e]=1}for(const e in r)e in o||(o[e]=void 0);return o}function get_spread_object(e){return"object"==typeof e&&null!==e?e:{}}function bind(e,t,o){const r=e.$$.props[t];void 0!==r&&(e.$$.bound[r]=o,o(e.$$.ctx[r]))}function create_component(e){e&&e.c()}function mount_component(e,t,o,r){const{fragment:n,after_update:i}=e.$$;n&&n.m(t,o),r||add_render_callback((()=>{const t=e.$$.on_mount.map(run).filter(is_function);e.$$.on_destroy?e.$$.on_destroy.push(...t):run_all(t),e.$$.on_mount=[]})),i.forEach(add_render_callback)}function destroy_component(e,t){const o=e.$$;null!==o.fragment&&(run_all(o.on_destroy),o.fragment&&o.fragment.d(t),o.on_destroy=o.fragment=null,o.ctx=[])}function make_dirty(e,t){-1===e.$$.dirty[0]&&(dirty_components.push(e),schedule_update(),e.$$.dirty.fill(0)),e.$$.dirty[t/31|0]|=1<<t%31}function init(e,t,o,r,n,i,a,s=[-1]){const l=current_component;set_current_component(e);const c=e.$$={fragment:null,ctx:[],props:i,update:noop,not_equal:n,bound:blank_object(),on_mount:[],on_destroy:[],on_disconnect:[],before_update:[],after_update:[],context:new Map(t.context||(l?l.$$.context:[])),callbacks:blank_object(),dirty:s,skip_bound:!1,root:t.target||l.$$.root};a&&a(c.root);let u=!1;if(c.ctx=o?o(e,t.props||{},((t,o,...r)=>{const i=r.length?r[0]:o;return c.ctx&&n(c.ctx[t],c.ctx[t]=i)&&(!c.skip_bound&&c.bound[t]&&c.bound[t](i),u&&make_dirty(e,t)),o})):[],c.update(),u=!0,run_all(c.before_update),c.fragment=!!r&&r(c.ctx),t.target){if(t.hydrate){const e=children(t.target);c.fragment&&c.fragment.l(e),e.forEach(detach)}else c.fragment&&c.fragment.c();t.intro&&transition_in(e.$$.fragment),mount_component(e,t.target,t.anchor,t.customElement),flush()}set_current_component(l)}class SvelteComponent{$destroy(){destroy_component(this,1),this.$destroy=noop}$on(e,t){if(!is_function(t))return noop;const o=this.$$.callbacks[e]||(this.$$.callbacks[e]=[]);return o.push(t),()=>{const e=o.indexOf(t);-1!==e&&o.splice(e,1)}}$set(e){this.$$set&&!is_empty(e)&&(this.$$.skip_bound=!0,this.$$set(e),this.$$.skip_bound=!1)}}const subscriber_queue=[];function readable(e,t){return{subscribe:writable(e,t).subscribe}}function writable(e,t=noop){let o;const r=new Set;function n(t){if(safe_not_equal(e,t)&&(e=t,o)){const t=!subscriber_queue.length;for(const t of r)t[1](),subscriber_queue.push(t,e);if(t){for(let e=0;e<subscriber_queue.length;e+=2)subscriber_queue[e][0](subscriber_queue[e+1]);subscriber_queue.length=0}}}return{set:n,update:function(t){n(t(e))},subscribe:function(i,a=noop){const s=[i,a];return r.add(s),1===r.size&&(o=t(n)||noop),i(e),()=>{r.delete(s),0===r.size&&(o(),o=null)}}}}function derived(e,t,o){const r=!Array.isArray(e),n=r?[e]:e,i=t.length<2;return readable(o,(e=>{let o=!1;const a=[];let s=0,l=noop;const c=()=>{if(s)return;l();const o=t(r?a[0]:a,e);i?e(o):l=is_function(o)?o:noop},u=n.map(((e,t)=>subscribe(e,(e=>{a[t]=e,s&=~(1<<t),o&&c()}),(()=>{s|=1<<t}))));return o=!0,c(),function(){run_all(u),l()}}))}var mergeObjects=e=>e.reduce(((e,t)=>Object.assign(e,t)),{});const UPDATE_VALUE=e=>({updateValue:e}),DEFAULT_VALUE=e=>({defaultValue:e}),CUSTOM_STORE=e=>({store:e}),DERIVED_STORE=e=>({store:(t,o)=>derived(...e(o))}),UNIQUE_DERIVED_STORE=e=>({store:(t,o)=>{const[r,n,i=()=>!1]=e(o);let a,s=!0;return derived(r,((e,t)=>{n(e,(e=>{!s&&i(a,e)||(a=e,s=!1,t(e))}))}))}}),MAP_STORE=e=>({store:(t,o)=>{const[r,n={},i]=e(o);let a=[];const s={},l=e=>r(e,s),c=e=>{(a.length||e.length)&&(a=e,u())},u=()=>{const e=a.map(l);i&&e.sort(i),a=[...e],d(e)};Object.entries(n).map((([e,t])=>t.subscribe((t=>{s[e]=t,t&&u()}))));const{subscribe:p,set:d}=writable(t||[]);return{set:c,update:e=>c(e(a)),subscribe:p}}}),createStore$1=(e,t,o)=>{const{store:r=e=>writable(e),defaultValue:n=noop$1,updateValue:i}=o,a=r(n(),t,e),{subscribe:s,update:l=noop$1}=a;let c;const u=e=>{let t=!0;c&&c(),c=s((o=>{if(t)return t=!1;e(o),c(),c=void 0}))},p=i?i(e):passthrough;return a.set=e=>l((t=>p(e,t,u))),a.defaultValue=n,a};var createStores=e=>{const t={},o={};return e.forEach((([e,...r])=>{const n=mergeObjects(r),i=t[e]=createStore$1(o,t,n),a={get:()=>get_store_value(i),set:i.set};Object.defineProperty(o,e,a)})),{stores:t,accessors:o}};const sourceStore=()=>{let e;const{subscribe:t,set:o}=writable(),r=t=>{e!==t&&(e=t,o(e))};return{set:r,subscribe:t,update:t=>r(t(e))}};var props=[["src",CUSTOM_STORE(sourceStore)],["imageReader"],["imageWriter"],["imageScrambler"],["imageRedactionRendering",DEFAULT_VALUE((()=>"pixelated"))],["images",DEFAULT_VALUE((()=>[]))],["shapePreprocessor"],["willRequestResource"],["willRequest"],["csp"]],capitalizeFirstLetter=e=>e.charAt(0).toUpperCase()+e.slice(1),defineMethods=(e,t)=>{Object.keys(t).forEach((o=>{const r=isFunction(t[o])?{value:t[o],writable:!1}:t[o];Object.defineProperty(e,o,r)}))};const pointInPoly=(e,t)=>{let o,r,n,i,a,s,l,c,u,p;const d=t.length;for(o=0;o<d;o++)if(r=t[o],n=t[o+1>d-1?0:o+1],i=r.x-e.x,a=r.y-e.y,s=n.x-e.x,l=n.y-e.y,c=i-s,u=a-l,p=c*a-u*i,p<-1e-5)return!1;return!0},scalar=1e4;var offsetRectToFitPolygon=(e,t)=>{const o=quadLines(t),r=vectorCreateEmpty();rectGetCorners(e).forEach((e=>{vectorAdd(e,r),pointInPoly(e,t)||o.forEach((t=>{const o=Math.atan2(t.start.y-t.end.y,t.start.x-t.end.x),n=1e4*Math.sin(Math.PI-o),i=1e4*Math.cos(Math.PI-o),a=vectorCreate(e.x+n,e.y+i),s=lineExtend(lineClone(t),1e4),l=lineLineIntersection(lineCreate(e,a),s);l&&vectorAdd(r,vectorSubtract(vectorClone(l),e))}))}));const n=rectClone$1(e);vectorAdd(n,r);return!!rectGetCorners(n).every((e=>pointInPoly(e,t)))&&(rectUpdateWithRect(e,n),!0)},limitCropRectToImage=(e,t)=>{const o=rectGetCorners(e),r=quadToLines(t,5),n=rectCenter(e),i=[];o.forEach((e=>{const t=lineMultiply(lineCreate(vectorClone(n),vectorClone(e)),1e6);let o=!1;r.map(lineClone).forEach((e=>{const r=lineLineIntersection(t,e);r&&!o&&(i.push(r),o=!0)}))}));const a=vectorDistance(i[0],i[2])<vectorDistance(i[1],i[3])?[i[0],i[2]]:[i[1],i[3]],s=rectCreateFromPoints(a);return s.width<e.width&&(rectUpdateWithRect(e,s),!0)},getImagePolygon=(e,t,o={x:0,y:0})=>{const r=rectCreateFromSize(e),n=rectCenter(r),i=rectApplyPerspective(r,o,n).map((e=>vectorRotate(e,t,n))),a=rectCreateFromPoints(i);return i.map((e=>vectorSubtract(e,a)))},getMaxSizeInRect=(e,t=0,o=rectAspectRatio(e))=>{let r,n;if(0!==t){const i=Math.atan2(1,o),a=Math.sign(t)*t,s=a%Math.PI,l=a%HALF_PI;let c;c=s>QUART_PI&&s<HALF_PI+QUART_PI?l>QUART_PI?a:HALF_PI-l:l>QUART_PI?HALF_PI-l:a;const u=Math.min(Math.abs(e.height/Math.sin(i+c)),Math.abs(e.width/Math.cos(i-c)));r=Math.cos(i)*u,n=r/o}else r=e.width,n=r/o,n>e.height&&(n=e.height,r=n*o);return sizeCreate(r,n)},limitRectToImage=(e,t,o=0,r=vectorCreateEmpty(),n)=>{if(isNumber(o)&&0!==o||r.x||r.y){const n=rectAspectRatio(e),i=getImagePolygon(t,o,r),a=getMaxSizeInRect(t,o,n);if(!(e.width<a.width&&e.height<a.height)){const t=.5*e.width-.5*a.width,o=.5*e.height-.5*a.height;e.width>a.width&&(e.width=a.width,e.x+=t),e.height>a.height&&(e.height=a.height,e.y+=o)}offsetRectToFitPolygon(e,i);limitCropRectToImage(e,i)&&offsetRectToFitPolygon(e,i)}else{const o=rectAspectRatio(e);e.width=Math.min(e.width,t.width),e.height=Math.min(e.height,t.height),e.x=Math.max(e.x,0),e.x+e.width>t.width&&(e.x-=e.x+e.width-t.width),e.y=Math.max(e.y,0),e.y+e.height>t.height&&(e.y-=e.y+e.height-t.height);const r=rectCenter(e),i=rectContainRect(e,o);i.width=Math.max(n.width,i.width),i.height=Math.max(n.height,i.height),i.x=r.x-.5*i.width,i.y=r.y-.5*i.height,rectUpdateWithRect(e,i)}},applyCropRectAction=(e,t,o,r,n,i,a,s)=>{const l=sizeClone(a),c=sizeClone(s),u=fixPrecision(Math.max(t.width/c.width,t.height/c.height)),p=fixPrecision(Math.min(t.width/l.width,t.height/l.height)),d=rectClone$1(t);if(p<1||u>1){const o=rectCenter(e),r=rectCenter(t),n=p<1?p:u,i=(r.x+o.x)/2,a=(r.y+o.y)/2,s=d.width/n,l=d.height/n;rectUpdate(d,i-.5*s,a-.5*l,s,l)}return i?(limitRectToImage(d,o,r,n,l),{crop:d}):{crop:d}},getBaseCropRect=(e,t,o)=>{const r=rectCreateFromSize(e),n=rectCenter(r),i=rectRotate(r,o,n),a=rectCenter(rectNormalizeOffset(rectCreateFromPoints(i))),s=rectCenter(t),l=vectorRotate(s,-o,a),c=vectorSubtract(l,a),u=vectorApply(vectorAdd(n,c),fixPrecision);return rectCreate(u.x-.5*t.width,u.y-.5*t.height,t.width,t.height)},clamp=(e,t,o)=>Math.max(t,Math.min(e,o)),applyRotationAction=(e,t,o,r,n,i,a,s,l,c)=>{const u=sizeClone(l),p=sizeClone(c);a&&(p.width=Math.min(c.width,n.width),p.height=Math.min(c.height,n.height));let d=!1;const h=(t,o)=>{const l=getBaseCropRect(n,r,t),c=rectCreateFromSize(n),m=rectCenter(c),g=rectApplyPerspective(c,i,m),f=vectorSubtract(vectorClone(m),convexPolyCentroid(g)),$=vectorRotate(rectCenter(l),o,m),b=vectorSubtract(vectorClone(m),$);g.forEach((e=>vectorRotate(e,o,m)));const y=rectCreateFromPoints(g),_=convexPolyCentroid(g),x=vectorAdd(vectorSubtract(vectorSubtract(_,b),y),f),v=rectCreate(x.x-.5*l.width,x.y-.5*l.height,l.width,l.height);if(s&&rectScale$1(v,s.width/v.width),a){const e=getImagePolygon(n,o,i);limitCropRectToImage(v,e)}const S=fixPrecision(Math.min(v.width/u.width,v.height/u.height),8),C=fixPrecision(Math.max(v.width/p.width,v.height/p.height),8);if(S<1||C>1){if(fixPrecision(Math.abs(o-t))===fixPrecision(Math.PI/2)&&!d)return d=!0,h(e,e+Math.sign(o-t)*Math.PI)}return{rotation:o,crop:rectApply(v,(e=>fixPrecision(e,8)))}},m=Math.sign(t)*Math.round(Math.abs(t)/HALF_PI)*HALF_PI,g=clamp(t,m+o[0],m+o[1]);return h(e,g)};const ORDERED_STATE_PROPS=["cropLimitToImage","cropMinSize","cropMaxSize","cropAspectRatio","flipX","flipY","rotation","crop","colorMatrix","convolutionMatrix","gamma","vignette","manipulation","redaction","annotation","decoration","selection","frame","backgroundColor","backgroundImage","targetSize","metadata","trim","volume","minDuration","maxDuration","currentTime"],clone=e=>isArray(e)?e.map(clone):isBlob(e)||isFile(e)?e:isObject(e)?{...e}:e,filterShapeState=e=>e.map((e=>Object.entries(e).reduce(((e,[t,o])=>(t.startsWith("_")||(e[t]=o),e)),{})));var stateStore=(e,t,o)=>{const r=ORDERED_STATE_PROPS.map((e=>t[e]));let n=!1;const i=writable({}),{subscribe:a}=derived([...r,i],((e,t)=>{if(n)return;const o=ORDERED_STATE_PROPS.reduce(((t,o,r)=>(t[o]=clone(e[r]),t)),{});o.crop&&rectApply(o.crop,Math.round),o.manipulation=o.manipulation&&filterShapeState(o.manipulation),o.redaction=o.redaction&&filterShapeState(o.redaction),o.annotation=o.annotation&&filterShapeState(o.annotation),o.decoration=o.decoration&&filterShapeState(o.decoration),o.selection=o.selection&&filterShapeState(o.selection),t(o)})),s=e=>{e&&(n=!0,o.cropOrigin=void 0,ORDERED_STATE_PROPS.filter((t=>hasProp(e,t))).forEach((t=>{const r=e[t];o[t]=null===r?void 0:clone(r)})),n=!1,i.set({}))};return{set:s,update:e=>s(e(null)),subscribe:a}},toNumericAspectRatio=e=>{if(e){if(/:/.test(e)){const[t,o]=e.split(":");return t/o}return parseFloat(e)}};const simpleEqual=(e,t)=>e===t;var arrayEqual=(e,t,o=simpleEqual)=>{if(e.length!==t.length)return!1;for(let r=0;r<e.length;r++)if(!o(e[r],t[r]))return!1;return!0},padColorArray=(e=[0,0,0,0],t=1)=>4===e.length?e:[...e,t];const isCropCentered=(e,t,o)=>{const r=vectorApply(rectCenter(e),(e=>fixPrecision(e,8))),n=rectCreateFromSize(t),i=rectCenter(n),a=rectRotate(n,o,i),s=vectorApply(sizeCenter(rectCreateFromPoints(a)),(e=>fixPrecision(e,8))),l=Math.abs(s.x-r.x),c=Math.abs(s.y-r.y);return l<1&&c<1},isCropMaxSize=(e,t,o)=>{const r=getMaxSizeInRect(t,o,rectAspectRatio(e));return sizeEqual(sizeApply(r,Math.round),sizeApply(sizeClone(e),Math.round))},updateCropRect=e=>(t,o=t)=>{const{loadState:r,size:n,cropMinSize:i,cropMaxSize:a,cropLimitToImage:s,cropAspectRatio:l,rotation:c,perspective:u}=e;if(!t&&!o||!r||!r.beforeComplete)return t;t||(t=rectCreateFromSize(getMaxSizeInRect(n,c,l||rectAspectRatio(n))));const p=applyCropRectAction(o,t,n,c,u,s,i,a),d=rectApply(p.crop,(e=>fixPrecision(e,8)));return rectEqual(o,d)?o:d},updateCropAspectRatio=e=>(t,o)=>{const{loadState:r,crop:n,size:i,rotation:a,cropLimitToImage:s}=e,l=toNumericAspectRatio(t);if(!l)return;if(!n||!r||!r.beforeComplete)return l;const c=o?Math.abs(t-o):1;if(isCropCentered(n,i,a)&&s&&c>=.1){const o=sizeTurn(sizeClone(i),a);e.crop=rectApply(rectContainRect(rectCreateFromSize(o),t),fixPrecision)}else{const t={width:n.height*l,height:n.height},o=.5*(n.width-t.width),r=.5*(n.height-t.height);e.crop=rectApply(rectCreate(n.x+o,n.y+r,t.width,t.height),fixPrecision)}return l},updateCropLimitToImage=e=>(t,o,r)=>{const{crop:n}=e;return n?(!o&&t&&r((()=>e.crop=rectClone$1(e.crop))),t):t},updateRotation=e=>(t,o,r)=>{if(t===o)return t;const{loadState:n,size:i,rotationRange:a,cropMinSize:s,cropMaxSize:l,crop:c,perspective:u,cropLimitToImage:p,cropOrigin:d}=e;if(!c||!n||!n.beforeComplete)return t;const h=p&&isCropMaxSize(c,i,o),m=p&&isCropCentered(c,i,o),g=applyRotationAction(o,t,a,c,i,u,p,d,s,l);if(h&&m){const e=getMaxSizeInRect(i,t,rectAspectRatio(g.crop));g.crop.x+=.5*g.crop.width,g.crop.y+=.5*g.crop.height,g.crop.x-=.5*e.width,g.crop.y-=.5*e.height,g.crop.width=e.width,g.crop.height=e.height}return r((()=>{e.crop=rectApply(g.crop,(e=>fixPrecision(e,8)))})),g.rotation},updateRotationRange=(e,t,o,r,n)=>{if(!n)return[-1/0,1/0];const i=Math.max(o.width/r.width,o.height/r.height),a=sizeCreate(r.width*i,r.height*i),s=sizeHypotenuse(a);if(s<Math.min(e.width,e.height))return[-1/0,1/0];const l=t?e.height:e.width,c=t?e.width:e.height,u=Math.acos(a.height/s),p=u-Math.acos(c/s),d=Math.asin(l/s)-u;if(Number.isNaN(p)&&Number.isNaN(d))return[-1/0,1/0];const h=Number.isNaN(p)?d:Number.isNaN(d)?p:Math.min(p,d);return[-h,h]},updateCropRange=(e,t,o,r,n,i)=>{const a=sizeClone(r),s=sizeClone(n);return i?[a,sizeApply(getMaxSizeInRect(e,t,o),Math.round)]:[a,s]},formatShape=(e,t)=>{const{context:o,props:r}=t;return e._isFormatted||((e=shapeFormat(e))._isFormatted=!0,Object.assign(e,r)),e._isDraft||!shapeHasRelativeSize(e)||e._context&&rectEqual(o,e._context)||(shapeComputeRect(e,o),e._context={...o}),e},formatSelectionShape=(e,t)=>(e._isFormatted||(e.disableMove=!0,e.disableSelect=!0,e.disableResize=!0,e.disableRotate=!0),formatShape(e,t)),updateFrame=()=>e=>{if(!e)return;const t={frameStyle:void 0,x:0,y:0,width:"100%",height:"100%",disableStyle:["backgroundColor","strokeColor","strokeWidth"]};return isString(e)?t.frameStyle=e:Object.assign(t,e),t};var ImageStorePropDescriptors=[["file"],["size"],["loadState"],["processState"],["aspectRatio",DERIVED_STORE((({size:e})=>[e,e=>e?rectAspectRatio(e):void 0]))],["perspectiveX",DEFAULT_VALUE((()=>0))],["perspectiveY",DEFAULT_VALUE((()=>0))],["perspective",DERIVED_STORE((({perspectiveX:e,perspectiveY:t})=>[[e,t],([e,t])=>({x:e,y:t})]))],["rotation",DEFAULT_VALUE((()=>0)),UPDATE_VALUE(updateRotation)],["flipX",DEFAULT_VALUE((()=>!1))],["flipY",DEFAULT_VALUE((()=>!1))],["flip",DERIVED_STORE((({flipX:e,flipY:t})=>[[e,t],([e,t])=>({x:e,y:t})]))],["isRotatedSideways",UNIQUE_DERIVED_STORE((({rotation:e})=>[[e],([e],t)=>t(isRotatedSideways(e)),(e,t)=>e!==t]))],["crop",UPDATE_VALUE(updateCropRect)],["cropAspectRatio",UPDATE_VALUE(updateCropAspectRatio)],["cropOrigin"],["cropMinSize",DEFAULT_VALUE((()=>({width:1,height:1})))],["cropMaxSize",DEFAULT_VALUE((()=>({width:32768,height:32768})))],["cropLimitToImage",DEFAULT_VALUE((()=>!0)),UPDATE_VALUE(updateCropLimitToImage)],["cropSize",UNIQUE_DERIVED_STORE((({crop:e})=>[[e],([e],t)=>{e&&t(sizeCreate(e.width,e.height))},(e,t)=>sizeEqual(e,t)]))],["cropRectAspectRatio",DERIVED_STORE((({cropSize:e})=>[[e],([e],t)=>{e&&t(fixPrecision(rectAspectRatio(e),5))}]))],["cropRange",UNIQUE_DERIVED_STORE((({size:e,rotation:t,cropRectAspectRatio:o,cropMinSize:r,cropMaxSize:n,cropLimitToImage:i})=>[[e,t,o,r,n,i],([e,t,o,r,n,i],a)=>{if(!e)return;a(updateCropRange(e,t,o,r,n,i))},(e,t)=>arrayEqual(e,t)]))],["rotationRange",UNIQUE_DERIVED_STORE((({size:e,isRotatedSideways:t,cropMinSize:o,cropSize:r,cropLimitToImage:n})=>[[e,t,o,r,n],([e,t,o,r,n],i)=>{if(!e||!r)return;i(updateRotationRange(e,t,o,r,n))},(e,t)=>arrayEqual(e,t)]))],["backgroundColor",UPDATE_VALUE((()=>e=>padColorArray(e)))],["backgroundImage"],["targetSize"],["colorMatrix"],["convolutionMatrix"],["gamma"],["noise"],["vignette"],["duration"],["currentTime"],["minDuration",DEFAULT_VALUE((()=>1/24))],["maxDuration",DEFAULT_VALUE((()=>1/0))],["volume",DEFAULT_VALUE((()=>1))],["trim"],["redaction",MAP_STORE((({size:e})=>[formatShape,{context:e}]))],["manipulation",MAP_STORE((({size:e})=>[formatShape,{context:e}]))],["annotation",MAP_STORE((({size:e})=>[formatShape,{context:e}]))],["decoration",MAP_STORE((({crop:e})=>[formatShape,{context:e}]))],["selection",MAP_STORE((({size:e})=>[formatSelectionShape,{context:e}]))],["frame",UPDATE_VALUE(updateFrame)],["metadata"],["state",CUSTOM_STORE(stateStore)]],process=async(e,t,o={},r)=>{const{ontaskstart:n,ontaskprogress:i,ontaskend:a,token:s}=r;let l=!1;const c={cancel:noop$1};s.cancel=()=>{l=!0,c.cancel()};for(const[r,s]of t.entries()){if(l)return;const[t,u]=s;n(r,u);try{e=await t(e,{...o,taskCancelToken:c},(e=>i(r,u,e)))}catch(e){throw l=!0,e}a(r,u)}return e},createImageCore=({minSize:e={width:1,height:1},minDuration:t=0}={})=>{const{stores:o,accessors:r}=createStores(ImageStorePropDescriptors),{pub:n,sub:i}=pubsub(),a=(e,t)=>{const o=()=>r[e]||{},i=t=>{r[e]={...o(),...t,timeStamp:Date.now()}},a=()=>o().error,s=e=>{a()||(i({error:e}),n(`${t}error`,{...o()}))};return{start(){n(`${t}start`)},onabort(){i({abort:!0}),n(`${t}abort`,{...o()})},ontaskstart(e,r){a()||(i({index:e,task:r,taskProgress:void 0,taskLengthComputable:void 0}),n(`${t}taskstart`,{...o()}))},ontaskprogress(e,r,s){a()||(i({index:e,task:r,taskProgress:s.loaded/s.total,taskLengthComputable:s.lengthComputable}),n(`${t}taskprogress`,{...o()}),n(`${t}progress`,{...o()}))},ontaskend(e,r){a()||(i({index:e,task:r}),n(`${t}taskend`,{...o()}))},ontaskerror(e){s(e)},error(e){s(e)},beforeComplete(e){a()||(i({beforeComplete:!0}),n(`before${t}`,e))},complete(e){a()||(i({complete:!0}),n(t,e))}}};return defineMethods(r,{read:(o,{reader:n},i={})=>{if(!n)return;Object.assign(r,{file:void 0,size:void 0,loadState:void 0});let s={cancel:noop$1},l=!1;const c=a("loadState","load"),u={token:s,...c},p={src:o,size:void 0,dest:void 0,duration:void 0};return Promise.resolve().then((async()=>{try{if(c.start(),l)return c.onabort();const o=await process(p,n,i,u);if(l)return c.onabort();const{size:a,duration:s,dest:d}=o||{};if(!a||!a.width||!a.height)throw new EditorError("Image size missing","IMAGE_SIZE_MISSING",o);if(s>0&&s<t)throw new EditorError("Video too short","VIDEO_TOO_SHORT",{...o,minDuration:t});if(a.width<e.width||a.height<e.height)throw new EditorError("Image too small","IMAGE_TOO_SMALL",{...o,minWidth:e.width,minHeight:e.height});Object.assign(r,{file:d,size:a,duration:s}),c.beforeComplete(o),c.complete(o)}catch(e){c.error(e)}finally{s=void 0}})),()=>{l=!0,s&&s.cancel(),c.onabort()}},write:(e,t)=>{if(!r.loadState.complete)return;r.processState=void 0;const o=a("processState","process"),n={src:r.file,imageState:r.state,dest:void 0};if(isFunction(e)&&(e=e(r.file,r.state)),!e)return o.start(),void o.complete(n);let i={cancel:noop$1},s=!1;const l=t,c={token:i,...o};return Promise.resolve().then((async()=>{try{if(o.start(),s)return o.onabort();const t=await process(n,e,l,c);if(s)return o.onabort();o.complete(t)}catch(e){o.error(e)}finally{i=void 0}})),()=>{s=!0,i&&i.cancel()}},on:i}),{accessors:r,stores:o}};const editorEventsToBubble=["loadstart","loadabort","loaderror","loadprogress","load","processstart","processabort","processerror","processprogress","process"],imagePrivateProps=["flip","cropOrigin","isRotatedSideways","perspective","perspectiveX","perspectiveY","cropRange"],editorPrivateProps=["images"],imagePublicProps=ImageStorePropDescriptors.map((([e])=>e)).filter((e=>!imagePrivateProps.includes(e))),getImagePropGroupedName=e=>`image${capitalizeFirstLetter(e)}`,getEditorProps$1=()=>{const e=imagePublicProps.map(getImagePropGroupedName),t=props.map((([e])=>e)).filter((e=>!editorPrivateProps.includes(e)));return e.concat(t)},isImageSource=e=>isString(e)||isBinary(e)||isElement(e),isImageState=e=>hasProp(e,"crop");var createImageEditor=()=>{const{stores:e,accessors:t}=createStores(props),{sub:o,pub:r}=pubsub(),n=()=>t.images?t.images[0]:{};let i={};const a={};imagePublicProps.forEach((e=>{Object.defineProperty(t,getImagePropGroupedName(e),{get:()=>{const t=n();if(t)return t.accessors[e]},set:t=>{i[getImagePropGroupedName(e)]=t,a[getImagePropGroupedName(e)]=t;const o=n();o&&(o.accessors[e]=t)}})}));const s=()=>t.images&&t.images[0],l=e.src.subscribe((e=>{if(!e)return t.images=[];t.imageReader&&(t.images.length&&(i={}),u(e))})),c=e.imageReader.subscribe((e=>{e&&(t.images.length||t.src&&u(t.src))})),u=e=>{Promise.resolve().then((()=>d(e,i))).catch((()=>{}))};let p;const d=(e,o={})=>new Promise(((n,l)=>{let c=s();const u=!(!1===o.cropLimitToImage||!1===o.imageCropLimitToImage||!1===a.imageCropLmitedToImage),d=o.cropMinSize||o.imageCropMinSize||a.imageCropMinSize,h=u?d:c&&c.accessors.cropMinSize,g=o.minDuration||o.imageMinDuration;c&&m(),c=createImageCore({minSize:h,minDuration:g}),editorEventsToBubble.map((e=>{return c.accessors.on(e,(t=e,e=>r(t,e)));var t}));const f=()=>{i={},$.forEach((e=>e()))},$=[];$.push(c.accessors.on("loaderror",(e=>{f(),l(e)}))),$.push(c.accessors.on("loadabort",(()=>{f(),l({name:"AbortError"})}))),$.push(c.accessors.on("load",(e=>{p=void 0,f(),n(e)}))),$.push(c.accessors.on("beforeload",(()=>((e,o)=>{if(isImageState(o))return void(t.imageState=o);if(!o.imageCrop){const t=e.accessors.size,r=o.imageRotation||0,n=sizeRotate(sizeClone(t),r),i=rectCreateFromSize(n);i.width=fixPrecision(Math.abs(i.width),6),i.height=fixPrecision(Math.abs(i.height),6);const a=o.imageCropAspectRatio||(o.imageCropLimitToImage?rectAspectRatio(t):rectAspectRatio(i));let s;o.imageCropLimitToImage?s=rectContainRect(i,a):(s=rectCoverRect(i,a),s.x=(t.width-s.width)/2,s.y=(t.height-s.height)/2),o.imageCrop=s}if(e.accessors.duration&&!o.imageTrim&&o.imageMaxDuration){const{duration:t}=e.accessors;o.imageTrim=[[0,Math.min(o.imageMaxDuration/t,1)]]}const r=["imageCropLimitToImage","imageCrop","imageCropAspectRatio","imageRotation"];r.filter((e=>hasProp(o,e))).forEach((e=>{t[e]=o[e],delete o[e]}));const n=Object.keys(o).filter((e=>!r.includes(e))).reduce(((e,t)=>(e[t]=o[t],e)),{});Object.assign(t,n)})(c,o)))),t.images=[c],o.imageReader&&(t.imageReader=o.imageReader),o.imageWriter&&(t.imageWriter=o.imageWriter),p=c.accessors.read(e,{reader:t.imageReader},{willRequest:t.willRequest})}));let h;const m=()=>{const e=s();e&&(p&&p(),e.accessors.loadState=void 0,t.images=[])};return Object.defineProperty(t,"stores",{get:()=>e}),defineMethods(t,{on:o,loadImage:d,abortLoadImage:()=>{p&&p(),t.images=[]},editImage:(e,o)=>new Promise(((r,n)=>{d(e,o).then((()=>{const{images:e}=t,o=e[0],i=()=>{a(),s()},a=o.accessors.on("processerror",(e=>{i(),n(e)})),s=o.accessors.on("process",(e=>{i(),r(e)}))})).catch(n)})),removeImage:m,processImage:(e,o)=>new Promise(((r,n)=>{try{const i=[],a=()=>{h=void 0,i.forEach((e=>e()))};(async()=>{if(isImageSource(e))try{await d(e,o)}catch(e){n(e)}else e&&(isImageState(e)?t.imageState=e:Object.assign(t,e));const l=s();if(!l)return n("no image");i.push(l.accessors.on("processerror",(e=>{a(),n(e)}))),i.push(l.accessors.on("processabort",(()=>{a(),n({name:"AbortError"})}))),i.push(l.accessors.on("process",(e=>{a(),r(e)}))),h=l.accessors.write(t.imageWriter,{redactionRenderStyle:t.imageRedactionRendering,shapePreprocessor:t.shapePreprocessor||passthrough,imageScrambler:t.imageScrambler,willRequest:t.willRequest,csp:t.csp||{},willRequestResource:t.willRequestResource})})()}catch(e){n(e)}})),abortProcessImage:()=>{const e=s();e&&(h&&h(),e.accessors.processState=void 0)},destroy:()=>{l&&l(),c&&c()}}),t};const processImage=(e,t)=>{const{processImage:o}=createImageEditor();return o(e,t)};var getCanvasMemoryLimit=()=>isSafari()?isIOS()?/15_|16_/.test(navigator.userAgent)?14745600:16777216:/15_/.test(navigator.userAgent)?16777216:1/0:1/0,filterObjectProperties=(e,t)=>Object.keys(e).filter((e=>!t.includes(e))).reduce(((t,o)=>(t[o]=e[o],t)),{}),videoFixDuration=e=>new Promise((t=>{if(e.duration===1/0)return e.ontimeupdate=()=>{e.ontimeupdate=void 0,t(e)},void(e.currentTime=Number.MAX_SAFE_INTEGER);t(e)})),getVideoElementDuration=e=>new Promise(((t,o)=>{const r=()=>{videoFixDuration(e).then((()=>{t(e.duration)}))};if(e.readyState>=1)return r();e.onloadedmetadata=r,e.onerror=()=>o(e.error)})),arrayFlatten=e=>e.reduce(((e,t)=>[...e,...Array.isArray(t)?[...t]:[t]]),[]),getVideoFileRotationMetadata=async e=>{const t=await blobToArrayBuffer(e),o=new DataView(t);return getRotationMetadataInDataView(o)};const blobToArrayBuffer=e=>new Promise((t=>{const o=new FileReader;o.onload=()=>t(o.result),o.readAsArrayBuffer(e)})),getRotationMetadataInMP4=(e,t,o)=>{let r=!1,n=-1;for(let i=t;i<o;i++){if(r||1953653099!==e.getUint32(i)||(r=!0,i+=4),!r)continue;if(64==e.getUint8(i)){n=i;break}}if(n<0)return 0;const i=e.getUint32(n-28),a=e.getUint32(n-20),s=e.getUint32(n-32),l=e.getUint32(n-16);return 65536===i&&4294901760===a?90:4294901760===s&&4294901760===l?180:4294901760===i&&65536===a?270:0},MOOV_ATOM=1836019574,MVHD_ATOM=1836476516,TKHD_ATOM=1953196132,TRAK_ATOM=1953653099,getAtoms=(e,t=0,o=e.byteLength)=>{const r=[],n=t+o;for(;t<n;){const o=e.getUint32(t);if(o<0)break;const n=e.getUint32(t+4);if(r.push({type:n,size:o,offset:t,bodyOffset:t+8,bodySize:o-8}),o<8)break;t+=o}return r},getRotationMetadataInMOV=e=>{const t=getAtoms(e).find((e=>e.type===MOOV_ATOM));if(!t)return 0;const o=getAtoms(e,t.bodyOffset,t.bodySize);o.filter((e=>e.type===TRAK_ATOM)).forEach((t=>{o.push(...getAtoms(e,t.bodyOffset,t.bodySize))}));const r=[MVHD_ATOM,TKHD_ATOM],n=o.filter((e=>r.includes(e.type)));for(const{type:t,bodyOffset:o}of n){const r=e.getUint8(o);let n=o+4;n+=t===MVHD_ATOM?32:36,n+=1===r?12:0;const i=e.getInt32(n),a=e.getInt32(n+4);if(0===i&&a>0)return 90;if(i<0&&0===a)return 180;if(0===i&&a<0)return 270}return 0},getRotationMetadataInDataView=(e,{limit:t=1024}={})=>{let o=0;o+=4;if(1718909296!==e.getUint32(o))return 0;o+=4;const r=e.getUint32(o);return 1836069938===r?getRotationMetadataInMP4(e,o,t):1903435808===r?getRotationMetadataInMOV(e):0};var iOSTriggerVideoLoad=e=>{isIOS()&&(e.load(),e.play().catch((()=>{})),e.pause())},blobToVideo=e=>new Promise(((t,o)=>{(isFirefox()?getVideoFileRotationMetadata(e):Promise.resolve(0)).then((r=>{const n=document.createElement("video");n.onerror=()=>o(n.error),n.playsInline=!0,n.preload="auto",n.onseeked=()=>{n.onseeked=void 0,t(n)},n.onloadeddata=()=>{n.onloadeddata=void 0,n.dataset.rotation=r?`${r}`:"0",videoFixDuration(n).then(t),n.currentTime=0},n.src=URL.createObjectURL(e),iOSTriggerVideoLoad(n)}))})),seekTo=(e,t)=>new Promise((o=>{if(e.currentTime===t)return o(e);let r=e.onseeked;e.onseeked=()=>{e.onseeked=r,o(e)},e.currentTime=clamp(t,0,e.duration)})),videoToImageData=(e,t=0)=>new Promise(((o,r)=>{blobToVideo(e).then((e=>{seekTo(e,t).then((e=>{const t=h("canvas");getVideoElementSize(e).then((({width:r,height:n})=>{t.width=r,t.height=n;const i=t.getContext("2d",{willReadFrequently:!0}),a=()=>{i.drawImage(e,0,0,t.width,t.height);const r=i.getImageData(0,0,t.width,t.height);releaseCanvas(t),URL.revokeObjectURL(e.src),o(r)};isSafari()?setTimeout(a,16):a()}))}))}))})),isVideoFile=e=>/video/.test(e.type);const createCanvasImageDrawer=({imageDataResizer:e,canvasMemoryLimit:t}={})=>async(o,r,n,i,a)=>{n.width=Math.max(n.width,1),n.height=Math.max(n.height,1),i.width=Math.max(i.width,1),i.height=Math.max(i.height,1);const{dest:s}=await processImage(r,{imageReader:createDefaultImageReader$1(),imageWriter:createDefaultImageWriter$1({format:"canvas",targetSize:{...i,upscale:!0},imageDataResizer:e,canvasMemoryLimit:t}),imageCrop:n}),{feather:l=0}=a||{};if(l>0){const e=h("canvas");e.width=s.width,e.height=s.height;const t=e.getContext("2d",{willReadFrequently:!0}),o=1/l;let r=0;for(r=0;r<l;r++){const e=r*o;t.strokeStyle=`rgba(0,0,0,${e*e})`,t.strokeRect(r+.5,r+.5,s.width-2*r-1,s.height-2*r-1)}t.fillStyle="#000",t.fillRect(r,r,s.width+.5-2*r,s.height+.5-2*r);const n=s.getContext("2d");n.globalCompositeOperation="destination-in",n.drawImage(e,0,0),releaseCanvas(e)}o.drawImage(s,i.x,i.y,i.width,i.height),releaseCanvas(s)},connect=(e,t=(...e)=>e,o)=>async(r,n,i)=>{i(createProgressEvent(0,!1));let a=!1;const s=await e(...t(r,n,(e=>{a=!0,i(e)})));return o&&o(r,s),a||i(createProgressEvent(1,!1)),r},AnyToFile=({willRequest:e,srcProp:t="src",destProp:o="dest"}={})=>[connect(srcToFile,((o,r,n)=>[o[t],n,{...r,willRequest:e}]),((e,t)=>e[o]=t)),"any-to-file"],BlobGuardMimeType=({srcProp:e="dest",destProp:t="dest"}={})=>[connect((async e=>{if(/octet-stream/.test(e.type)){console.warn(`Pintura: File has unknown mime type "${e.type}", make sure your server sets the correct Content-Type header.`);let t="image";const o=await getAsVideoOrImageElement(e);/video/i.test(o.nodeName)&&(t="video");const r={type:t+"/unknown"};return isFile(e)?new File([e],e.name,{...r,lastModified:e.lastModified}):new Blob([e],r)}return e}),(t=>[t[e]]),((e,o)=>e[t]=o)),"any-to-file"],BlobReadImageSize=({srcProp:e="src",destProp:t="size"}={})=>[connect(getImageSize,(t=>[t[e]]),((e,o)=>e[t]=o)),"read-image-size"],getMediaDuration=async e=>{const t=await getAsVideoOrImageElement(e);if(isVideoElement(t))return await getVideoElementDuration(t)},BlobReadMediaDuration=({srcProp:e="src",destProp:t="duration"}={})=>[connect(getMediaDuration,(t=>[t[e]]),((e,o)=>e[t]=o)),"read-media-duration"],ImageSizeMatchOrientation=({srcSize:e="size",srcOrientation:t="orientation",destSize:o="size"}={})=>[connect(orientImageSize,(o=>[o[e],o[t]]),((e,t)=>e[o]=t)),"image-size-match-orientation"],BlobCopy=({srcProp:e="src",destProp:t="copy"}={})=>[connect(((e,t)=>isJPEG(e)?readFile(e,t):void 0),(t=>[t[e],onprogress]),((e,o)=>e[t]=o)),"read-image-head"],ImageHeadReadExifOrientationTag=({srcProp:e="copy",destProp:t="orientation"}={})=>[connect(arrayBufferImageExif,(t=>[t[e],274]),((e,o=1)=>e[t]=o)),"read-exif-orientation-tag"],ImageHeadClearExifOrientationTag=({srcProp:e="copy"}={})=>[connect(arrayBufferImageExif,(t=>[t[e],274,1])),"clear-exif-orientation-tag"],CalculateCanvasScalar=({srcImageSize:e="size",srcCanvasSize:t="imageData",srcImageState:o="imageState",destImageSize:r="size",destScalar:n="scalar"}={})=>[connect(((e,t)=>[Math.min(t.width/e.width,t.height/e.height),sizeCreateFromAny(t)]),(r=>[r[e],r[t],r[o]]),((e,[t,o])=>{e[n]=t,e[r]=o})),"calculate-canvas-scalar"],BlobToImageData=({srcProp:e="src",destProp:t="imageData",canvasMemoryLimit:o,srcImageState:r="imageState"}={})=>[connect(((e,t,o)=>isVideoFile(e)?videoToImageData(e,o.currentTime):blobToImageData(e,t)),(t=>[t[e],o,t[r]]),((e,o)=>e[t]=o)),"blob-to-image-data"],ImageDataMatchOrientation=({srcImageData:e="imageData",srcOrientation:t="orientation"}={})=>[connect(orientImageData,(o=>[o[e],o[t]]),((e,t)=>e.imageData=t)),"image-data-match-orientation"],ImageDataFill=({srcImageData:e="imageData",srcImageState:t="imageState"}={})=>[connect(fillImageData,(o=>[o[e],{backgroundColor:o[t].backgroundColor,backgroundImage:o[t].backgroundImage}]),((e,t)=>e.imageData=t)),"image-data-fill"],ImageDataCrop=({srcImageData:e="imageData",srcImageState:t="imageState",destScalar:o="scalar"}={})=>[connect(cropImageData,(r=>{const n=r[o];let{crop:i}=r[t];return i&&1!==n&&(i=rectScale$1(rectClone$1(i),n,vectorCreateEmpty())),[r[e],{crop:i,rotation:r[t].rotation,flipX:r[t].flipX,flipY:r[t].flipY}]}),((e,t)=>e.imageData=t)),"image-data-crop"],hasTargetSize=e=>!!(e.targetSize&&e.targetSize.width||e.targetSize&&e.targetSize.height),ImageDataResize=({targetSize:e={width:void 0,height:void 0,fit:void 0,upscale:void 0},imageDataResizer:t,srcProp:o="imageData",srcImageState:r="imageState",destImageScaledSize:n="imageScaledSize"})=>[connect(resizeImageData,(n=>{const i=Math.min(e.width||Number.MAX_SAFE_INTEGER,n[r].targetSize&&n[r].targetSize.width||Number.MAX_SAFE_INTEGER),a=Math.min(e.height||Number.MAX_SAFE_INTEGER,n[r].targetSize&&n[r].targetSize.height||Number.MAX_SAFE_INTEGER);return[n[o],{width:i,height:a,fit:e.fit||"contain",upscale:!!hasTargetSize(n[r])||(e.upscale||!1)},t]}),((e,t)=>{sizeEqual(e.imageData,t)||(e[n]=sizeCreateFromAny(t)),e.imageData=t})),"image-data-resize"],ImageDataFilter=({srcImageData:e="imageData",srcImageState:t="imageState",destImageData:o="imageData"}={})=>[connect(filterImageData,(o=>{const{colorMatrix:r}=o[t],n=r&&Object.keys(r).map((e=>r[e])).filter(Boolean);return[o[e],{colorMatrix:n&&getColorMatrixFromColorMatrices(n),convolutionMatrix:o[t].convolutionMatrix,gamma:o[t].gamma,noise:o[t].noise,vignette:o[t].vignette}]}),((e,t)=>e[o]=t)),"image-data-filter"],ImageDataRedact=({srcImageData:e="imageData",srcImageState:t="imageState",destImageData:o="imageData",destScalar:r="scalar"}={})=>[connect((async(e,t,o,r,n,i)=>{if(!t||!r.length)return e;let a;try{const n={dataSizeScalar:getImageRedactionScaleFactor(e,r)};o&&o[3]>0&&(n.backgroundColor=[...o]),a=await t(e,n)}catch(e){}const s=h("canvas");s.width=e.width,s.height=e.height;const l=s.getContext("2d",{willReadFrequently:!0});if(l.putImageData(e,0,0),"auto"===i){const t=Math.sqrt(e.width*e.height);l.filter=`blur(${Math.round(t/100)}px)`}const c=new Path2D;r.forEach((e=>{const t=rectCreate(e.x,e.y,e.width,e.height);rectMultiply(t,n);const o=rectRotate(rectClone$1(t),e.rotation),r=new Path2D;o.forEach(((e,t)=>{if(0===t)return r.moveTo(e.x,e.y);r.lineTo(e.x,e.y)})),c.addPath(r)})),l.clip(c,"nonzero"),l.imageSmoothingEnabled=!1,l.drawImage(a,0,0,s.width,s.height),releaseCanvas(a);const u=l.getImageData(0,0,s.width,s.height);return releaseCanvas(s),u}),((o,{imageScrambler:n,redactionRenderStyle:i})=>[o[e],n,o[t].backgroundColor,o[t].redaction,o[r],i]),((e,t)=>e[o]=t)),"image-data-redact"],ImageDataAnnotate=({srcImageData:e="imageData",srcSize:t="size",srcImageState:o="imageState",srcShapes:r="annotation",destImageData:n="imageData",destImageScaledSize:i="imageScaledSize",destScalar:a="scalar",imageDataResizer:s,canvasMemoryLimit:l,shapeFilter:c=passthrough,shapeClip:u=!0,destImageContext:p="imageContext"}={})=>[connect(drawImageData,((n,{shapePreprocessor:d,willRequestResource:h,csp:m,willRequest:g})=>{const f=n[o][r].filter(c);if(!f.length)return[n[e]];const $=n[a],{crop:b}=n[o],y=n[t];let _=$;const x=n[i];x&&(_=Math.min(x.width/b.width,x.height/b.height));const v={width:y.width/$,height:y.height/$};return[n[e],{shapes:f,computeShape:e=>(e=shapeComputeDisplay(e,v),e=filterObjectProperties(e,["left","right","top","bottom"]),e=shapeScale(e,_)),transform:e=>{const r=n[t],{rotation:a=0,flipX:s,flipY:l,cropLimitToImage:c}=n[o],{crop:d=rectCreateFromSize(r)}=n[o];let h=1;h=n[i]?_:$;const m={width:r.width/$*h,height:r.height/$*h},g=getImageTransformedRect(m,a),f=g.width,b=g.height,y=.5*m.width-.5*f,x=.5*m.height-.5*b,v=sizeCenter(m);e.translate(-y,-x),e.translate(-d.x*h,-d.y*h),e.translate(v.x,v.y),e.rotate(a),e.translate(-v.x,-v.y);const S=n[p]||{x:0,y:0};e.translate(S.x,S.y),e.scale(s?-1:1,l?-1:1),e.translate(s?-m.width*$:0,l?-m.height*$:0),c&&u&&(e.rect(0,0,m.width,m.height),e.clip())},drawImage:createCanvasImageDrawer({imageDataResizer:s,canvasMemoryLimit:l}),preprocessShape:e=>d(e,{isPreview:!1,...n[o]}),canvasMemoryLimit:l,willRequest:g||h,styleNonce:m.styleNonce}]}),((e,t)=>e[n]=t)),"image-data-annotate"],ImageDataDecorate=({srcImageData:e="imageData",srcImageState:t="imageState",destImageData:o="imageData",destImageScaledSize:r="imageScaledSize",imageDataResizer:n,canvasMemoryLimit:i,destScalar:a="scalar",shapeFilter:s=passthrough,destImageContext:l="imageContext"}={})=>[connect(drawImageData,((o,{shapePreprocessor:c,willRequestResource:u,willRequest:p,csp:d})=>{let h=o[t].decoration.filter(s);if(!h.length)return[o[e]];let m=o[a];const{crop:g}=o[t],f=o[r];if(f){const e=Math.min(f.width/g.width,f.height/g.height);m=e}return[o[e],{shapes:h,drawImage:createCanvasImageDrawer({imageDataResizer:n,canvasMemoryLimit:i}),computeShape:e=>(e=shapeComputeDisplay(e,g),e=filterObjectProperties(e,["left","right","top","bottom"]),e=shapeScale(e,m)),preprocessShape:e=>c(e,{isPreview:!1,...o[t]}),canvasMemoryLimit:i,willRequest:p||u,styleNonce:d.styleNonce,transform:e=>{const t=o[l]||{x:0,y:0};e.translate(t.x,t.y)}}]}),((e,t)=>e[o]=t)),"image-data-decorate"],ImageDataFrame=({srcImageData:e="imageData",srcImageState:t="imageState",destImageData:o="imageData",destImageScaledSize:r="imageScaledSize",imageDataResizer:n,canvasMemoryLimit:i,destScalar:a="scalar",destImageContext:s="imageContext"}={})=>[connect(((e,t)=>new Promise((o=>{if(!t)return o([e]);drawImageData(e,t).then((e=>{o([e,t.contextBounds])}))}))),((o,{shapePreprocessor:s,willRequestResource:l,willRequest:c,csp:u})=>{const p=o[t].frame;if(!p)return[o[e]];const d=o[a];let{crop:h}=o[t];h&&1!==d&&(h=rectScale$1(rectClone$1(h),d,vectorCreateEmpty()));const m={...h},g=shapesBounds(shapesFromCompositShape(p,m,s),m);m.x=Math.abs(g.left),m.y=Math.abs(g.top),m.width+=Math.abs(g.left)+Math.abs(g.right),m.height+=Math.abs(g.top)+Math.abs(g.bottom);const f=o[r],$=f?Math.min(f.width/h.width,f.height/h.height):1;return rectMultiply(m,$),m.x=Math.floor(m.x),m.y=Math.floor(m.y),m.width=Math.floor(m.width),m.height=Math.floor(m.height),[o[e],{shapes:[p],contextBounds:m,computeShape:t=>shapeComputeDisplay(t,o[e]),transform:e=>{e.translate(m.x,m.y)},drawImage:createCanvasImageDrawer({imageDataResizer:n,canvasMemoryLimit:i}),preprocessShape:e=>s(e,{isPreview:!1,...o[t]}),canvasMemoryLimit:i,willRequest:c||l,styleNonce:u.styleNonce}]}),((e,[t,r])=>{e[s]=r,e[o]=t})),"image-data-frame"],ImageDataToBlob=({mimeType:e,quality:t,srcImageData:o="imageData",srcFile:r="src",destBlob:n="blob"}={})=>[connect(imageDataToBlob,(n=>[n[o],e||getMimeTypeFromFilename(n[r].name)||n[r].type,t]),((e,t)=>e[n]=t)),"image-data-to-blob"],ImageDataToCanvas=({srcImageData:e="imageData",srcOrientation:t="orientation",destCanvas:o="dest"}={})=>[connect(imageDataToCanvas,(o=>[o[e],o[t]]),((e,t)=>e[o]=t)),"image-data-to-canvas"],writeImageHead=async(e,t)=>{if(!isJPEG(e)||!t)return e;const o=(e,t)=>{let o=2;const r=new DataView(e),n=r.byteLength;for(t(r.getUint8(0),0,2,n);o<n&&255==r.getUint8(o);){const e=r.getUint8(o+1),i=r.getUint16(o+2)+2;if(!1===t(e,o,i,n))break;o+=i}},r=e=>e>=224&&e<=237,n=(e=>{const t=[];return o(e,((o,n,i)=>{if(218===o)return!1;r(o)&&t.push(new Uint8Array(e,n,i))})),t})(t),i=((e,t)=>{const n=[];o(e,((o,i,a,s)=>0===i?(n.push(new Uint8Array(e,i,a)),void n.push(...t)):218===o?(n.push(new Uint8Array(e,i,s-i)),!1):void(r(o)||n.push(new Uint8Array(e,i,a)))));let i=n.reduce(((e,t)=>e+t.length),0),a=new Uint8Array(i),s=0;return n.forEach((e=>{a.set(e,s),s+=e.length})),a})(await readFile(e),n);return new Blob([i],{type:"image/jpeg"})},BlobWriteImageHead=(e="blob",t="copy",o="blob")=>[connect(writeImageHead,(o=>[o[e],o[t]]),((e,t)=>e[o]=t)),"blob-write-image-head"],BlobToFile=({renameFile:e,srcBlob:t="blob",srcFile:o="src",destFile:r="dest",defaultFilename:n}={})=>[connect(blobToFile,(r=>[r[t],e?e(r[o]):r[o].name||`${n}.${getExtensionFromMimeType(r[t].type)}`]),((e,t)=>e[r]=t)),"blob-to-file"],Store=({url:e="./",dataset:t=e=>[["dest",e.dest,e.dest.name],["imageState",e.imageState]],destStore:o="store",credentials:r,headers:n={}})=>[connect((async(t,o)=>await post(e,t,{onprogress:o,beforeSend:e=>configureXHR(e,{headers:n,credentials:r})})),((e,o,r)=>[t(e),r]),((e,t)=>e[o]=t)),"store"],PropFilter=e=>[connect((t=>e&&e.length?(Object.keys(t).forEach((o=>{e.includes(o)||delete t[o]})),t):t)),"prop-filter"],createDefaultImageReader$1=(e={})=>{const{orientImage:t=!0,outputProps:o=["src","dest","size","duration"],preprocessImageFile:r,request:n={}}=e;return[AnyToFile({willRequest:()=>n}),BlobGuardMimeType(),r&&[connect(r,((e,t,o)=>[e.dest,t,o]),((e,t)=>e.dest=t)),"preprocess-image-file"],BlobReadImageSize({srcProp:"dest"}),BlobReadMediaDuration({srcProp:"dest"}),t&&BlobCopy({srcProp:"dest"}),t&&ImageHeadReadExifOrientationTag(),t&&ImageSizeMatchOrientation(),PropFilter(o)].filter(Boolean)},createStore=e=>e&&(isString(e)?Store({url:e}):isFunction(e)?[e,"store"]:Store(e)),createDefaultImageWriter$1=(e={})=>(t,o,r={})=>{let{canvasMemoryLimit:n=getCanvasMemoryLimit(),orientImage:i=!0,copyImageHead:a=!0,mimeType:s,quality:l,renameFile:c,targetSize:u,imageDataResizer:p,store:d,format:h="file",outputProps:m=["src","dest","imageState","store"],preprocessImageSource:g,preprocessImageState:f,postprocessImageData:$,postprocessImageBlob:b,testSrcSupport:y=!1}={...e,...r};if(!y||isImage(t))return"blob"===h&&(h="file"),[g&&[connect(g,((e,t,o)=>[e.src,t,o,e.imageState]),((e,t)=>e.src=t)),"preprocess-image-source"],(i||a)&&BlobCopy(),i&&ImageHeadReadExifOrientationTag(),BlobReadImageSize(),f&&[connect(f,((e,t,o,r)=>[e.imageState,t,o,{size:e.size,orientation:e.orientation}]),((e,t)=>e.imageState=t)),"preprocess-image-state"],BlobToImageData({canvasMemoryLimit:n}),i&&ImageSizeMatchOrientation(),i&&ImageDataMatchOrientation(),CalculateCanvasScalar(),ImageDataRedact(),ImageDataCrop(),ImageDataResize({imageDataResizer:p,targetSize:u}),ImageDataAnnotate({imageDataResizer:p,canvasMemoryLimit:n,srcShapes:"manipulation"}),ImageDataFilter(),ImageDataFill(),ImageDataAnnotate({imageDataResizer:p,canvasMemoryLimit:n,srcShapes:"annotation",shapeFilter:e=>!e.aboveFrame}),ImageDataDecorate({imageDataResizer:p,canvasMemoryLimit:n,shapeFilter:e=>!e.aboveFrame}),ImageDataFrame({imageDataResizer:p,canvasMemoryLimit:n}),ImageDataAnnotate({imageDataResizer:p,canvasMemoryLimit:n,srcShapes:"annotation",shapeFilter:e=>e.aboveFrame,shapeClip:!1}),ImageDataDecorate({imageDataResizer:p,canvasMemoryLimit:n,shapeFilter:e=>e.aboveFrame}),$&&[connect($,((e,t,o)=>[e.imageData,t,o]),((e,t)=>e.imageData=t)),"postprocess-image-data"],"file"===h?ImageDataToBlob({mimeType:s,quality:l}):"canvas"===h?ImageDataToCanvas():[e=>(e.dest=e.imageData,e)],"file"===h&&i&&ImageHeadClearExifOrientationTag(),"file"===h&&a&&BlobWriteImageHead(),b&&[connect(b,(({blob:e,imageData:t,src:o},r,n)=>[{blob:e,imageData:t,src:o},r,n]),((e,t)=>e.blob=t)),"postprocess-image-file"],"file"===h&&BlobToFile({defaultFilename:"image",renameFile:c}),"file"===h?createStore(d):isFunction(d)&&[d,"store"],PropFilter(m)].filter(Boolean)},isWriter=e=>Array.isArray(e)||isFunction(e),createDefaultMediaWriter$1=(e,...t)=>(o,r)=>{isWriter(e)&&(t=[e,...t]);const n=isObject(e)?e:{};n.testSrcSupport=!0,t=Array.isArray(t)?arrayFlatten(t):t;for(let e=0;e<t.length;e++){const i=t[e](o,r,n);if(Array.isArray(i))return i}};var calculateImageTransforms=(e,t,o,r,n,i,a,s,l,c,u)=>{if(!(e&&t&&o&&r&&s))return;s*=i;const p=rectNormalizeOffset(rectClone$1(t)),d=rectCenter(p),h=rectCenter(e),m=rectCreateFromSize(o),g=rectCenter(m),f=getBaseCropRect(o,r,l),$=rectCenter(f),b=vectorSubtract(vectorClone(g),$),y=vectorSubtract(vectorClone(h),d);b.x+=y.x,b.y+=y.y;const _=vectorInvert(vectorClone(b));_.x+=y.x,_.y+=y.y;const x=rectCenter(rectTranslate$1(rectTranslate$1(rectClone$1(n),a),e)),v=vectorSubtract(x,h);return vectorAdd(b,v),{origin:_,translation:b,rotation:{x:u?Math.PI:0,y:c?Math.PI:0,z:l},scale:s}};let result$6=null;var supportsWebGL2=()=>{if(null===result$6)if("WebGL2RenderingContext"in window){let e;try{e=h("canvas"),result$6=!!e.getContext("webgl2")}catch(e){result$6=!1}e&&releaseCanvas(e),e=void 0}else result$6=!1;return result$6},isPowerOf2=e=>!(e&e-1),stringReplace=(e,t={},o="",r="")=>Object.keys(t).filter((e=>!isObject(t[e]))).reduce(((e,n)=>e.replace(new RegExp(o+n+r),t[n])),e),SHADER_FRAG_HEAD="#version 300 es\nprecision highp float;\n\nout vec4 fragColor;",SHADER_FRAG_INIT="\nfloat a=1.0;vec4 fillColor=uColor;vec4 textureColor=texture(uTexture,vTexCoord);textureColor*=(1.0-step(uRepeat.y,vTexCoord.y))*step(0.0,vTexCoord.y)*(1.0-step(uRepeat.x,vTexCoord.x))*step(0.0,vTexCoord.x);",SHADER_FRAG_MASK="\nuniform float uMaskFeather[8];uniform float uMaskBounds[4];uniform float uMaskOpacity;float mask(float x,float y,float bounds[4],float opacity){return 1.0-(1.0-(smoothstep(bounds[3],bounds[3]+1.0,x)*(1.0-smoothstep(bounds[1]-1.0,bounds[1],x))*(1.0-step(bounds[0],y))*step(bounds[2],y)))*(1.0-opacity);}",SHADER_FRAG_MASK_APPLY="\nfloat m=mask(gl_FragCoord.x,gl_FragCoord.y,uMaskBounds,uMaskOpacity);",SHADER_FRAG_MASK_FEATHER_APPLY="\nfloat leftFeatherOpacity=step(uMaskFeather[1],gl_FragCoord.x)*uMaskFeather[0]+((1.0-uMaskFeather[0])*smoothstep(uMaskFeather[1],uMaskFeather[3],gl_FragCoord.x));float rightFeatherOpacity=(1.0-step(uMaskFeather[7],gl_FragCoord.x))*uMaskFeather[4]+((1.0-uMaskFeather[4])*smoothstep(uMaskFeather[7],uMaskFeather[5],gl_FragCoord.x));a*=leftFeatherOpacity*rightFeatherOpacity;",SHADER_FRAG_RECT_AA="\nvec2 scaledPoint=vec2(vRectCoord.x*uSize.x,vRectCoord.y*uSize.y);a*=smoothstep(0.0,uEdgeFeather,uSize.x-scaledPoint.x);a*=smoothstep(0.0,uEdgeFeather,uSize.y-scaledPoint.y);a*=smoothstep(0.0,uEdgeFeather,scaledPoint.x);a*=smoothstep(0.0,uEdgeFeather,scaledPoint.y);",SHADER_FRAG_CORNER_RADIUS="\nvec2 s=(uSize-2.0)*.5;vec2 r=(vRectCoord*uSize)-1.0;vec2 p=r-s;float cornerRadius=uCornerRadius[0];bool left=r.x<s.x;bool top=r.y<s.y;if(!left&&top){cornerRadius=uCornerRadius[1];}if(!left&&!top){cornerRadius=uCornerRadius[3];}if(left&&!top){cornerRadius=uCornerRadius[2];}a*=1.0-clamp(length(max(abs(p)-(s-cornerRadius),0.0))-cornerRadius,0.0,1.0);",SHADER_FRAG_SHAPE_BLEND_COLOR="\nif(m<=0.0)discard;fillColor.a*=a;fillColor.rgb*=fillColor.a;fillColor.rgb*=m;fillColor.rgb+=(1.0-m)*(uCanvasColor.rgb*fillColor.a);textureColor*=uTextureOpacity;textureColor.a*=a;textureColor.rgb*=m*a;textureColor.rgb+=(1.0-m)*(uCanvasColor.rgb*textureColor.a);fragColor=textureColor+(fillColor*(1.0-textureColor.a));",SHADER_FRAG_TEXTURE_COLORIZE="\nif(uTextureColor.a!=0.0&&textureColor.a>0.0){vec3 colorFlattened=textureColor.rgb/textureColor.a;if(colorFlattened.r>=.9999&&colorFlattened.g==0.0&&colorFlattened.b>=.9999){textureColor.rgb=uTextureColor.rgb*textureColor.a;}textureColor*=uTextureColor.a;}",SHADER_VERT_HEAD="#version 300 es\n\nin vec4 aPosition;uniform mat4 uMatrix;",SHADER_VERT_MULTIPLY_MATRUX="\ngl_Position=uMatrix*vec4(aPosition.x,aPosition.y,0,1);",SHADER_VERT_TEXTURE="\nin vec2 aTexCoord;out vec2 vTexCoord;";const SHADER_VERT_SNIPPETS={head:SHADER_VERT_HEAD,text:SHADER_VERT_TEXTURE,matrix:SHADER_VERT_MULTIPLY_MATRUX},SHADER_FRAG_SNIPPETS={head:SHADER_FRAG_HEAD,mask:SHADER_FRAG_MASK,init:SHADER_FRAG_INIT,colorize:SHADER_FRAG_TEXTURE_COLORIZE,maskapply:SHADER_FRAG_MASK_APPLY,maskfeatherapply:SHADER_FRAG_MASK_FEATHER_APPLY,rectaa:SHADER_FRAG_RECT_AA,cornerradius:SHADER_FRAG_CORNER_RADIUS,fragcolor:SHADER_FRAG_SHAPE_BLEND_COLOR},transpileShader=(e,t,o)=>(t=stringReplace(t,o===e.VERTEX_SHADER?SHADER_VERT_SNIPPETS:SHADER_FRAG_SNIPPETS,"##").trim(),supportsWebGL2()?t:(t=(t=t.replace(/#version.+/gm,"").trim()).replace(/^\/\/\#/gm,"#"),o===e.VERTEX_SHADER&&(t=t.replace(/in /gm,"attribute ").replace(/out /g,"varying ")),o===e.FRAGMENT_SHADER&&(t=t.replace(/in /gm,"varying ").replace(/out.*?;/gm,"").replace(/texture\(/g,"texture2D(").replace(/fragColor/g,"gl_FragColor")),`${t}`)),compileShader=(e,t,o)=>{const r=e.createShader(o),n=transpileShader(e,t,o);return e.shaderSource(r,n),e.compileShader(r),e.getShaderParameter(r,e.COMPILE_STATUS)||console.error(e.getShaderInfoLog(r)),r},createShader=(e,t,o,r,n)=>{const i=compileShader(e,t,e.VERTEX_SHADER),a=compileShader(e,o,e.FRAGMENT_SHADER),s=e.createProgram();e.attachShader(s,i),e.attachShader(s,a),e.linkProgram(s);const l={};return r.forEach((t=>{l[t]=e.getAttribLocation(s,t)})),n.forEach((t=>{l[t]=e.getUniformLocation(s,t)})),{program:s,locations:l,destroy(){e.detachShader(s,i),e.detachShader(s,a),e.deleteShader(i),e.deleteShader(a),e.deleteProgram(s)}}},canMipMap=e=>"VIDEO"!==e.nodeName&&(!!supportsWebGL2()||isPowerOf2(e.width)&&isPowerOf2(e.height)),applyTextureProperties=(e,t,o)=>{e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,canMipMap(t)?e.LINEAR_MIPMAP_LINEAR:e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,o.filterParam),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,o.wrapParam),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,o.wrapParam),canMipMap(t)&&e.generateMipmap(e.TEXTURE_2D)},updateTexture=(e,t,o,r)=>(e.bindTexture(e.TEXTURE_2D,t),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,o),applyTextureProperties(e,o,r),e.bindTexture(e.TEXTURE_2D,null),t),applyOpacity=(e,t=1)=>e?[e[0],e[1],e[2],isNumber(e[3])?t*e[3]:t]:[0,0,0,0],mat4Create=()=>{const e=new Float32Array(16);return e[0]=1,e[5]=1,e[10]=1,e[15]=1,e},mat4Perspective=(e,t,o,r,n)=>{const i=1/Math.tan(t/2),a=1/(r-n);e[0]=i/o,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=i,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=(n+r)*a,e[11]=-1,e[12]=0,e[13]=0,e[14]=2*n*r*a,e[15]=0},mat4Ortho=(e,t,o,r,n,i,a)=>{const s=1/(t-o),l=1/(r-n),c=1/(i-a);e[0]=-2*s,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=-2*l,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=2*c,e[11]=0,e[12]=(t+o)*s,e[13]=(n+r)*l,e[14]=(a+i)*c,e[15]=1},mat4Translate=(e,t,o,r)=>{e[12]=e[0]*t+e[4]*o+e[8]*r+e[12],e[13]=e[1]*t+e[5]*o+e[9]*r+e[13],e[14]=e[2]*t+e[6]*o+e[10]*r+e[14],e[15]=e[3]*t+e[7]*o+e[11]*r+e[15]},mat4Scale=(e,t)=>{e[0]*=t,e[1]*=t,e[2]*=t,e[3]*=t,e[4]*=t,e[5]*=t,e[6]*=t,e[7]*=t,e[8]*=t,e[9]*=t,e[10]*=t,e[11]*=t},mat4ScaleX=(e,t)=>{e[0]*=t,e[1]*=t,e[2]*=t,e[3]*=t},mat4ScaleY=(e,t)=>{e[4]*=t,e[5]*=t,e[6]*=t,e[7]*=t},mat4RotateX=(e,t)=>{const o=Math.sin(t),r=Math.cos(t),n=e[4],i=e[5],a=e[6],s=e[7],l=e[8],c=e[9],u=e[10],p=e[11];e[4]=n*r+l*o,e[5]=i*r+c*o,e[6]=a*r+u*o,e[7]=s*r+p*o,e[8]=l*r-n*o,e[9]=c*r-i*o,e[10]=u*r-a*o,e[11]=p*r-s*o},mat4RotateY=(e,t)=>{const o=Math.sin(t),r=Math.cos(t),n=e[0],i=e[1],a=e[2],s=e[3],l=e[8],c=e[9],u=e[10],p=e[11];e[0]=n*r-l*o,e[1]=i*r-c*o,e[2]=a*r-u*o,e[3]=s*r-p*o,e[8]=n*o+l*r,e[9]=i*o+c*r,e[10]=a*o+u*r,e[11]=s*o+p*r},mat4RotateZ=(e,t)=>{const o=Math.sin(t),r=Math.cos(t),n=e[0],i=e[1],a=e[2],s=e[3],l=e[4],c=e[5],u=e[6],p=e[7];e[0]=n*r+l*o,e[1]=i*r+c*o,e[2]=a*r+u*o,e[3]=s*r+p*o,e[4]=l*r-n*o,e[5]=c*r-i*o,e[6]=u*r-a*o,e[7]=p*r-s*o};var degToRad=e=>e*Math.PI/180,getWebGLContext=(e,t)=>supportsWebGL2()?e.getContext("webgl2",t):e.getContext("webgl",t)||e.getContext("experimental-webgl",t),imageFragmentShader="\n##head\nin vec2 vTexCoord;uniform sampler2D uTexture;uniform sampler2D uTextureOverlay;uniform sampler2D uTextureBlend;uniform vec2 uTextureSize;uniform float uOpacity;uniform int uAntialias;uniform vec4 uOverlayColor;uniform mat4 uColorMatrix;uniform vec4 uColorOffset;uniform float uClarityKernel[9];uniform float uClarityKernelWeight;uniform float uColorGamma;uniform float uColorVignette;uniform float uMaskClip;uniform float uMaskOpacity;uniform float uMaskBounds[4];uniform float uMaskCornerRadius[4];uniform float uMaskFeather[8];vec4 applyGamma(vec4 c,float g){c.r=pow(c.r,g);c.g=pow(c.g,g);c.b=pow(c.b,g);return c;}vec4 applyColorMatrix(vec4 c,mat4 m,vec4 o){vec4 res=(c*m)+(o*c.a);res=clamp(res,0.0,1.0);return res;}vec4 applyConvolutionMatrix(vec4 c,float k0,float k1,float k2,float k3,float k4,float k5,float k6,float k7,float k8,float w){vec2 pixel=vec2(1)/uTextureSize;vec4 colorSum=texture(uTexture,vTexCoord-pixel)*k0+texture(uTexture,vTexCoord+pixel*vec2(0.0,-1.0))*k1+texture(uTexture,vTexCoord+pixel*vec2(1.0,-1.0))*k2+texture(uTexture,vTexCoord+pixel*vec2(-1.0,0.0))*k3+texture(uTexture,vTexCoord)*k4+texture(uTexture,vTexCoord+pixel*vec2(1.0,0.0))*k5+texture(uTexture,vTexCoord+pixel*vec2(-1.0,1.0))*k6+texture(uTexture,vTexCoord+pixel*vec2(0.0,1.0))*k7+texture(uTexture,vTexCoord+pixel)*k8;vec4 color=vec4(clamp((colorSum/w),0.0,1.0).rgb,c.a);return color;}vec4 blendPremultipliedAlpha(vec4 back,vec4 front){return front+(back*(1.0-front.a));}vec4 applyVignette(vec4 c,vec2 pos,vec2 center,float v){float d=distance(pos,center)/length(center);float f=1.0-(d*abs(v));if(v>0.0){c.rgb*=f;}else if(v<0.0){c.rgb+=(1.0-f)*(1.0-c.rgb);}return c;}void main(){float x=gl_FragCoord.x;float y=gl_FragCoord.y;float a=1.0;float maskTop=uMaskBounds[0];float maskRight=uMaskBounds[1];float maskBottom=uMaskBounds[2];float maskLeft=uMaskBounds[3];float leftFeatherOpacity=step(uMaskFeather[1],x)*uMaskFeather[0]+((1.0-uMaskFeather[0])*smoothstep(uMaskFeather[1],uMaskFeather[3],x));float rightFeatherOpacity=(1.0-step(uMaskFeather[7],x))*uMaskFeather[4]+((1.0-uMaskFeather[4])*smoothstep(uMaskFeather[7],uMaskFeather[5],x));a*=leftFeatherOpacity*rightFeatherOpacity;float overlayColorAlpha=(smoothstep(maskLeft,maskLeft+1.0,x)*(1.0-smoothstep(maskRight-1.0,maskRight,x))*(1.0-step(maskTop,y))*step(maskBottom,y));if(uOverlayColor.a==0.0){a*=overlayColorAlpha;}vec2 offset=vec2(maskLeft,maskBottom);vec2 size=vec2(maskRight-maskLeft,maskTop-maskBottom)*.5;vec2 center=offset.xy+size.xy;int pixelX=int(step(center.x,x));int pixelY=int(step(y,center.y));float cornerRadius=0.0;if(pixelX==0&&pixelY==0)cornerRadius=uMaskCornerRadius[0];if(pixelX==1&&pixelY==0)cornerRadius=uMaskCornerRadius[1];if(pixelX==0&&pixelY==1)cornerRadius=uMaskCornerRadius[2];if(pixelX==1&&pixelY==1)cornerRadius=uMaskCornerRadius[3];float cornerOffset=sign(cornerRadius)*length(max(abs(gl_FragCoord.xy-size-offset)-size+cornerRadius,0.0))-cornerRadius;float cornerOpacity=1.0-smoothstep(0.0,1.0,cornerOffset);a*=cornerOpacity;if(uAntialias==1){vec2 scaledPoint=vec2(vTexCoord.x*uTextureSize.x,vTexCoord.y*uTextureSize.y);a*=smoothstep(0.0,1.0,uTextureSize.x-scaledPoint.x);a*=smoothstep(0.0,1.0,uTextureSize.y-scaledPoint.y);a*=smoothstep(0.0,1.0,scaledPoint.x);a*=smoothstep(0.0,1.0,scaledPoint.y);}vec4 color=texture(uTexture,vTexCoord);if(uClarityKernelWeight!=-1.0){color=applyConvolutionMatrix(color,uClarityKernel[0],uClarityKernel[1],uClarityKernel[2],uClarityKernel[3],uClarityKernel[4],uClarityKernel[5],uClarityKernel[6],uClarityKernel[7],uClarityKernel[8],uClarityKernelWeight);}color=blendPremultipliedAlpha(color,texture(uTextureBlend,vTexCoord));color=applyGamma(color,uColorGamma);color=applyColorMatrix(color,uColorMatrix,uColorOffset);color*=a;if(uColorVignette!=0.0){vec2 pos=gl_FragCoord.xy-offset;color=applyVignette(color,pos,center-offset,uColorVignette);}color=blendPremultipliedAlpha(color,texture(uTextureOverlay,vTexCoord));if(overlayColorAlpha<=0.0){color*=1.0-uOverlayColor.a;}color*=uOpacity;fragColor=color;}",imageVertexShader="\n##head\n##text\nvoid main(){vTexCoord=aTexCoord;gl_Position=uMatrix*aPosition;}",pathVertexShader="#version 300 es\n\nin vec4 aPosition;in vec2 aNormal;in float aMiter;out vec2 vNormal;out float vMiter;out float vWidth;uniform float uWidth;uniform float uSharpness;uniform mat4 uMatrix;void main(){vMiter=aMiter;vNormal=aNormal;vWidth=(uWidth*.5)+uSharpness;gl_Position=uMatrix*vec4(aPosition.x+(aNormal.x*vWidth*aMiter),aPosition.y+(aNormal.y*vWidth*aMiter),0,1);}",pathFragmentShader="\n##head\n##mask\nin vec2 vNormal;in float vMiter;in float vWidth;uniform float uWidth;uniform vec4 uColor;uniform vec4 uCanvasColor;void main(){vec4 fillColor=uColor;float m=mask(gl_FragCoord.x,gl_FragCoord.y,uMaskBounds,uMaskOpacity);if(m<=0.0)discard;fillColor.a*=clamp(smoothstep(vWidth-.5,vWidth-1.0,abs(vMiter)*vWidth),0.0,1.0);fillColor.rgb*=fillColor.a;fillColor.rgb*=m;fillColor.rgb+=(1.0-m)*(uCanvasColor.rgb*fillColor.a);fragColor=fillColor;}",rectVertexShader="\n##head\n##text\nin vec2 aRectCoord;out vec2 vRectCoord;void main(){vTexCoord=aTexCoord;vRectCoord=aRectCoord;\n##matrix\n}",rectFragmentShader="\n##head\n##mask\nin vec2 vTexCoord;in vec2 vRectCoord;uniform sampler2D uTexture;uniform vec4 uTextureColor;uniform float uTextureOpacity;uniform vec2 uRepeat;uniform vec4 uColor;uniform float uCornerRadius[4];uniform vec2 uSize;uniform vec2 uPosition;uniform vec4 uCanvasColor;uniform int uInverted;uniform float uEdgeFeather;void main(){\n##init\n##colorize\n##rectaa\n##cornerradius\n##maskfeatherapply\nif(uInverted==1)a=1.0-a;\n##maskapply\n##fragcolor\n}",ellipseVertexShader="\n##head\n##text\nout vec2 vTexCoordDouble;void main(){vTexCoordDouble=vec2(aTexCoord.x*2.0-1.0,aTexCoord.y*2.0-1.0);vTexCoord=aTexCoord;\n##matrix\n}",ellipseFragmentShader="\n##head\n##mask\nin vec2 vTexCoord;in vec2 vTexCoordDouble;uniform sampler2D uTexture;uniform float uTextureOpacity;uniform vec2 uTextureAdjust;uniform vec2 uRepeat;uniform vec2 uRadius;uniform vec4 uColor;uniform int uInverted;uniform vec4 uCanvasColor;void main(){\n##init\nfloat ar=uRadius.x/uRadius.y;vec2 rAA=vec2(uRadius.x-1.0,uRadius.y-(1.0/ar));vec2 scaledPointSq=vec2((vTexCoordDouble.x*uTextureAdjust.x*uRadius.x)*(vTexCoordDouble.x*uTextureAdjust.x*uRadius.x),(vTexCoordDouble.y*uTextureAdjust.y*uRadius.y)*(vTexCoordDouble.y*uTextureAdjust.y*uRadius.y));float p=(scaledPointSq.x/(uRadius.x*uRadius.x))+(scaledPointSq.y/(uRadius.y*uRadius.y));float pAA=(scaledPointSq.x/(rAA.x*rAA.x))+(scaledPointSq.y/(rAA.y*rAA.y));a=smoothstep(1.0,p/pAA,p);if(uInverted==1)a=1.0-a;\n##maskapply\n##fragcolor\n}",triangleVertexShader="\n##head\nvoid main(){\n##matrix\n}",triangleFragmentShader="\n##head\n##mask\nuniform vec4 uColor;uniform vec4 uCanvasColor;void main(){vec4 fillColor=uColor;\n##maskapply\nfillColor.rgb*=fillColor.a;fillColor.rgb*=m;fillColor.rgb+=(1.0-m)*(uCanvasColor.rgb*fillColor.a);fragColor=fillColor;}";const getIndex=(e,t)=>{const o=e.length;return t>=o?e[t%o]:t<0?e[t%o+o]:e[t]},getPolygonArea=e=>{let t,o,r,n,i,a=0;const s=e.length;for(t=0;t<s;t++)o=e[t],r=e[(t+1)%s],n=r.x-o.x,i=(r.y+o.y)/2,a+=n*i;return a},isPointInTriangle=(e,t,o,r)=>{const n=vectorCreate(o.x-t.x,o.y-t.y),i=vectorCreate(r.x-o.x,r.y-o.y),a=vectorCreate(t.x-r.x,t.y-r.y),s=vectorCreate(e.x-t.x,e.y-t.y),l=vectorCreate(e.x-o.x,e.y-o.y),c=vectorCreate(e.x-r.x,e.y-r.y),u=vectorCross(n,s),p=vectorCross(i,l),d=vectorCross(a,c);return u<=0&&p<=0&&d<=0},isIntersectingSelf=e=>{const t=e.length;for(let o=0;o<t;o++){const t=lineCreate(e[o],getIndex(e,o+1));if(linePointsIntersection(t,e,{ignoreIdenticalLines:!0,breakOnIntersection:!0}))return!0}return!1},triangulate=e=>{if(e.length<3)return[];if(isIntersectingSelf(e))return[];getPolygonArea(e)<0&&e.reverse();const t=e.length,o=[...Array(t).keys()],r=[];let n,i,a,s,l,c,u,p,d,h,m,g,f=1024;for(;o.length>3;){if(f<=0)return[];for(f--,n=0;n<o.length;n++)if(a=o[n],s=getIndex(o,n-1),l=getIndex(o,n+1),c=e[a],u=e[s],p=e[l],d=vectorCreate(u.x-c.x,u.y-c.y),h=vectorCreate(p.x-c.x,p.y-c.y),!(vectorCross(d,h)<0)){for(m=!0,i=0;i<t;i++)if(i!==a&&i!==s&&i!==l&&(g=e[i],isPointInTriangle(g,u,c,p))){m=!1;break}if(m){r.push([u,c,p]),o.splice(n,1);break}}}return r.push([e[o[0]],e[o[1]],e[o[2]]]),r},createPathSegment=(e,t,o,r,n)=>{const i=vectorNormalize(vectorCreate(r.x-o.x,r.y-o.y)),a=vectorNormalize(vectorCreate(n.x-r.x,n.y-r.y)),s=vectorNormalize(vectorCreate(i.x+a.x,i.y+a.y)),l=vectorCreate(-s.y,s.x),c=vectorCreate(-i.y,i.x),u=Math.min(1/vectorDot(l,c),5);e[t]=r.x,e[t+1]=r.y,e[t+2]=l.x*u,e[t+3]=l.y*u,e[t+4]=-1,e[t+5]=r.x,e[t+6]=r.y,e[t+7]=l.x*u,e[t+8]=l.y*u,e[t+9]=1},createPathVertices=(e,t)=>{let o,r,n,i=0;const a=e.length,s=new Float32Array(10*(t?a+1:a)),l=e[0],c=e[a-1];for(i=0;i<a;i++)o=e[i-1],r=e[i],n=e[i+1],o||(o=t?c:vectorCreate(r.x+(r.x-n.x),r.y+(r.y-n.y))),n||(n=t?l:vectorCreate(r.x+(r.x-o.x),r.y+(r.y-o.y))),createPathSegment(s,10*i,o,r,n);return t&&createPathSegment(s,10*a,c,l,e[1]),s},rectPointsToVertices=e=>{const t=new Float32Array(8);return t[0]=e[3].x,t[1]=e[3].y,t[2]=e[0].x,t[3]=e[0].y,t[4]=e[2].x,t[5]=e[2].y,t[6]=e[1].x,t[7]=e[1].y,t},createRectPoints=(e,t=0,o,r)=>{const n=rectGetCorners(e),i=e.x+.5*e.width,a=e.y+.5*e.height;return(o||r)&&vectorsFlip(n,o,r,i,a),0!==t&&vectorsRotate(n,t,i,a),n},createEllipseOutline=(e,t,o,r,n,i,a)=>{const s=.5*Math.abs(o),l=.5*Math.abs(r),c=Math.abs(o)+Math.abs(r),u=Math.max(20,Math.round(c/6));return ellipseToPolygon(vectorCreate(e+s,t+l),s,l,n,i,a,u)},createRectOutline=(e,t,o,r,n,i,a,s)=>{const l=[];if(i.every((e=>0===e)))l.push(vectorCreate(e,t),vectorCreate(e+o,t),vectorCreate(e+o,t+r),vectorCreate(e,t+r));else{const[n,a,s,c]=i,u=e,p=e+o,d=t,h=t+r;l.push(vectorCreate(u+n,d)),pushRectCornerPoints(l,p-a,d+a,a,-1),l.push(vectorCreate(p,d+a)),pushRectCornerPoints(l,p-c,h-c,c,0),l.push(vectorCreate(p-c,h)),pushRectCornerPoints(l,u+s,h-s,s,1),l.push(vectorCreate(u,h-s)),pushRectCornerPoints(l,u+n,d+n,n,2)}return(a||s)&&vectorsFlip(l,a,s,e+.5*o,t+.5*r),n&&vectorsRotate(l,n,e+.5*o,t+.5*r),l},pushRectCornerPoints=(e,t,o,r,n)=>{const i=Math.min(20,Math.max(4,Math.round(r/2)));let a=0,s=0,l=0,c=0,u=0;for(;u<i;u++)a=u/i,s=n*HALF_PI+a*HALF_PI,l=r*Math.cos(s),c=r*Math.sin(s),e.push(vectorCreate(t+l,o+c))};let limit=null;var getWebGLTextureSizeLimit=()=>{if(null!==limit)return limit;let e=h("canvas");const t=getWebGLContext(e);return limit=t?t.getParameter(t.MAX_TEXTURE_SIZE):void 0,releaseCanvas(e),e=void 0,limit},isChrome=()=>isBrowser()&&!!window.chrome;const RECT_UV=new Float32Array([0,1,0,0,1,1,1,0]),RECT_UV_ROTATED=new Float32Array([1,0,0,0,1,1,0,1]),SHOULD_APPLY_ROTATED_UV_TO_VIDEO_TEXTURES=isBrowser()&&isFirefox(),CLARITY_IDENTITY=[0,0,0,0,1,0,0,0,0],COLOR_MATRIX_IDENTITY$1=[1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0],TEXTURE_TRANSPARENT_INDEX=0,TEXTURE_PREVIEW_BLEND_INDEX=1,TEXTURE_PREVIEW_OVERLAY_INDEX=2,TEXTURE_PREVIEW_INDEX=3,TEXTURE_SHAPE_INDEX=4,COLOR_TRANSPARENT=[0,0,0,0],NO_CORNERS=[0,0,0,0],calculateBackgroundUVMap=(e,t,o,r,n)=>{if(!o||!r)return RECT_UV;let i=r.x/o.width,a=r.y/o.height,s=e/o.width/n,l=t/o.height/n;s-=i,l-=a;return new Float32Array([-i,l,-i,-a,s,l,s,-a])},limitCornerRadius=(e,t)=>Math.floor(clamp(e,0,Math.min(.5*(t.width-1),.5*(t.height-1))));var createWebGLCanvas=(e,t={})=>{const{alpha:o=!1}=t,r={width:0,height:0},n={width:0,height:0},i=getWebGLTextureSizeLimit()||1024;let a,s,l;const c=mat4Create(),u=mat4Create();let p,d,h,m,g,f,$,b,y,_=0,x=0,v=0,S=1;const C=new Map([]),w=()=>{R.stencilOp(R.KEEP,R.KEEP,R.KEEP),R.stencilFunc(R.ALWAYS,1,255),R.stencilMask(255)},T=degToRad(30),k=Math.tan(T/2),R=getWebGLContext(e,{alpha:o,antialias:!1,premultipliedAlpha:!0,stencil:!0});if(!R)return;R.getExtension("OES_standard_derivatives"),R.disable(R.DEPTH_TEST),R.enable(R.STENCIL_TEST),R.enable(R.BLEND),R.blendFunc(R.ONE,R.ONE_MINUS_SRC_ALPHA),R.pixelStorei(R.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!(!o&&isFirefox())),w();const P=R.createTexture();R.bindTexture(R.TEXTURE_2D,P),R.texImage2D(R.TEXTURE_2D,0,R.RGBA,1,1,0,R.RGBA,R.UNSIGNED_BYTE,new Uint8Array(COLOR_TRANSPARENT)),C.set(0,P);const I=R.createTexture();C.set(2,I);const E=R.createFramebuffer(),M=R.createTexture();C.set(1,M);const A=R.createFramebuffer(),F=createShader(R,imageVertexShader,imageFragmentShader,["aPosition","aTexCoord"],["uMatrix","uTexture","uTextureBlend","uTextureOverlay","uTextureSize","uColorGamma","uColorVignette","uColorOffset","uColorMatrix","uClarityKernel","uClarityKernelWeight","uOpacity","uMaskOpacity","uMaskBounds","uMaskCornerRadius","uMaskFeather","uOverlayColor","uAntialias"]),L=R.createBuffer(),D=R.createBuffer();R.bindBuffer(R.ARRAY_BUFFER,D),R.bufferData(R.ARRAY_BUFFER,RECT_UV,R.STATIC_DRAW);const z=R.createBuffer();R.bindBuffer(R.ARRAY_BUFFER,z),R.bufferData(R.ARRAY_BUFFER,RECT_UV_ROTATED,R.STATIC_DRAW);const O=createShader(R,pathVertexShader,pathFragmentShader,["aPosition","aNormal","aMiter"],["uColor","uCanvasColor","uMatrix","uWidth","uSharpness","uMaskBounds","uMaskOpacity"]),B=R.createBuffer();isChrome()&&(R.bindBuffer(R.ARRAY_BUFFER,B),R.bufferData(R.ARRAY_BUFFER,1,R.DYNAMIC_DRAW));const N=(e,t,o,r=!1)=>{const{program:n,locations:i}=O;R.useProgram(n),R.enableVertexAttribArray(i.aPosition),R.enableVertexAttribArray(i.aNormal),R.enableVertexAttribArray(i.aMiter);const a=createPathVertices(e,r),s=5*Float32Array.BYTES_PER_ELEMENT,c=2*Float32Array.BYTES_PER_ELEMENT,u=4*Float32Array.BYTES_PER_ELEMENT;R.uniform1f(i.uWidth,t),R.uniform1f(i.uSharpness,l),R.uniform4fv(i.uColor,o),R.uniformMatrix4fv(i.uMatrix,!1,p),R.uniform4f(i.uCanvasColor,_,x,v,S),R.uniform1fv(i.uMaskBounds,$),R.uniform1f(i.uMaskOpacity,f),R.bindBuffer(R.ARRAY_BUFFER,B),R.bufferData(R.ARRAY_BUFFER,a,R.STATIC_DRAW),R.vertexAttribPointer(i.aPosition,2,R.FLOAT,!1,s,0),R.vertexAttribPointer(i.aNormal,2,R.FLOAT,!1,s,c),R.vertexAttribPointer(i.aMiter,1,R.FLOAT,!1,s,u),R.drawArrays(R.TRIANGLE_STRIP,0,a.length/5),R.disableVertexAttribArray(i.aPosition),R.disableVertexAttribArray(i.aNormal),R.disableVertexAttribArray(i.aMiter)},V=createShader(R,triangleVertexShader,triangleFragmentShader,["aPosition"],["uColor","uCanvasColor","uMatrix","uMaskBounds","uMaskOpacity"]),W=R.createBuffer(),U=createShader(R,rectVertexShader,rectFragmentShader,["aPosition","aTexCoord","aRectCoord"],["uTexture","uColor","uMatrix","uCanvasColor","uTextureColor","uTextureOpacity","uRepeat","uPosition","uSize","uMaskBounds","uMaskOpacity","uMaskFeather","uCornerRadius","uInverted","uEdgeFeather"]),H=R.createBuffer(),G=R.createBuffer(),j=R.createBuffer(),q=createShader(R,ellipseVertexShader,ellipseFragmentShader,["aPosition","aTexCoord"],["uTexture","uTextureOpacity","uTextureAdjust","uRepeat","uColor","uCanvasColor","uMatrix","uRadius","uInverted","uMaskBounds","uMaskOpacity"]),X=R.createBuffer(),Y=R.createBuffer(),Z=new Map,K={2:{width:0,height:0},1:{width:0,height:0}},J=(e,t,o,n=1)=>{const a=Math.min(Math.min(4096,i)/o.width,Math.min(4096,i)/o.height,n),l=Math.floor(a*o.width),c=Math.floor(a*o.height);sizeEqual(o,K[e])?R.bindFramebuffer(R.FRAMEBUFFER,t):(R.bindTexture(R.TEXTURE_2D,C.get(e)),R.texImage2D(R.TEXTURE_2D,0,R.RGBA,l,c,0,R.RGBA,R.UNSIGNED_BYTE,null),R.texParameteri(R.TEXTURE_2D,R.TEXTURE_MIN_FILTER,R.LINEAR),R.texParameteri(R.TEXTURE_2D,R.TEXTURE_WRAP_S,R.CLAMP_TO_EDGE),R.texParameteri(R.TEXTURE_2D,R.TEXTURE_WRAP_T,R.CLAMP_TO_EDGE),R.bindFramebuffer(R.FRAMEBUFFER,t),R.framebufferTexture2D(R.FRAMEBUFFER,R.COLOR_ATTACHMENT0,R.TEXTURE_2D,C.get(e),0),K[e]=o);const d=o.width*s,h=o.height*s;mat4Ortho(u,0,d,h,0,-1,1),mat4Translate(u,0,h,0),mat4ScaleX(u,1),mat4ScaleY(u,-1),p=u,R.viewport(0,0,l,c),R.colorMask(!0,!0,!0,!0),R.clearColor(0,0,0,0),R.clear(R.COLOR_BUFFER_BIT),y=[1,0,1,0,1,Math.max(r.width,o.width),1,Math.max(r.width,o.width)]},Q=(e,t)=>{const{forceRelease:o=!1}=t||{},{src:r}=Z.get(e);r instanceof HTMLCanvasElement&&(o||r.dataset.retain||releaseCanvas(r)),Z.delete(e),R.deleteTexture(e)},ee=e=>Z.get(e).isRotatedVideo;return{drawPath:(e,t=0,o=!1,r=!1,n,i,a,l,c)=>{if(e.length<2)return;const u=e.map((e=>({x:e.x*s,y:e.y*s}))),d=n*s;if(d>0&&N(u,d,applyOpacity(i,c),a),u.length<3||!l||0===l[3]||!a)return;const h=triangulate(u),m=new Float32Array(6*h.length);h.forEach((([e,t,o],r)=>{const n=6*r;m[n+0]=e.x,m[n+1]=e.y,m[n+2]=t.x,m[n+3]=t.y,m[n+4]=o.x,m[n+5]=o.y})),((e,t)=>{const{program:o,locations:r}=V;R.useProgram(o),R.enableVertexAttribArray(r.aPosition),R.uniform4fv(r.uColor,t),R.uniformMatrix4fv(r.uMatrix,!1,p),R.uniform1fv(r.uMaskBounds,$),R.uniform1f(r.uMaskOpacity,f),R.uniform4f(r.uCanvasColor,_,x,v,S),R.bindBuffer(R.ARRAY_BUFFER,W),R.bufferData(R.ARRAY_BUFFER,e,R.STATIC_DRAW),R.vertexAttribPointer(r.aPosition,2,R.FLOAT,!1,0,0),R.drawArrays(R.TRIANGLES,0,e.length/2),R.disableVertexAttribArray(r.aPosition)})(m,applyOpacity(l,c))},drawRect:(e,t=0,o=!1,r=!1,n,i,a,l=void 0,c=void 0,u=!1,d=void 0,h,m,g,b=void 0,C=1/s,w,T)=>{const k=rectMultiply(rectClone$1(e),s),I=n.map((t=>limitCornerRadius(t||0,e))).map((e=>e*s));if(i||a){const e=rectClone$1(k);e.x-=.5,e.y-=.5,e.width+=1,e.height+=1;const n=createRectPoints(e,t,o,r),h=rectPointsToVertices(n);let m;w&&(m=applyOpacity(w),0===m[3]&&(m[3]=.001));const E=l&&u?[e.width/l.width,e.height/l.height]:[1,1];((e,t,o,r,n,i=P,a,l=1,c=COLOR_TRANSPARENT,u=RECT_UV,d=y,h=1,m)=>{const{program:g,locations:b}=U;R.useProgram(g),R.enableVertexAttribArray(b.aPosition),R.enableVertexAttribArray(b.aTexCoord),R.enableVertexAttribArray(b.aRectCoord),R.uniform4fv(b.uColor,n),R.uniform2fv(b.uSize,[t,o]),R.uniform2fv(b.uPosition,[e[2],e[3]]),R.uniform2fv(b.uRepeat,a),R.uniform1i(b.uInverted,m?1:0),R.uniform1fv(b.uCornerRadius,r),R.uniform4f(b.uCanvasColor,_,x,v,S),R.uniform1fv(b.uMaskFeather,d.map(((e,t)=>t%2==0?e:e*s))),R.uniform1fv(b.uMaskBounds,$),R.uniform1f(b.uMaskOpacity,f),R.uniform1f(b.uEdgeFeather,Math.max(0,h)),R.uniformMatrix4fv(b.uMatrix,!1,p),R.uniform1i(b.uTexture,4),R.uniform4fv(b.uTextureColor,c),R.uniform1f(b.uTextureOpacity,l),R.activeTexture(R.TEXTURE0+4),R.bindTexture(R.TEXTURE_2D,i),R.bindBuffer(R.ARRAY_BUFFER,G),R.bufferData(R.ARRAY_BUFFER,u,R.STATIC_DRAW),R.vertexAttribPointer(b.aTexCoord,2,R.FLOAT,!1,0,0),R.bindBuffer(R.ARRAY_BUFFER,j),R.bufferData(R.ARRAY_BUFFER,RECT_UV,R.STATIC_DRAW),R.vertexAttribPointer(b.aRectCoord,2,R.FLOAT,!1,0,0),R.bindBuffer(R.ARRAY_BUFFER,H),R.bufferData(R.ARRAY_BUFFER,e,R.STATIC_DRAW),R.vertexAttribPointer(b.aPosition,2,R.FLOAT,!1,0,0),R.drawArrays(R.TRIANGLE_STRIP,0,e.length/2),R.disableVertexAttribArray(b.aPosition),R.disableVertexAttribArray(b.aTexCoord),R.disableVertexAttribArray(b.aRectCoord)})(h,e.width,e.height,I,applyOpacity(i,g),a,E,g,m,d?new Float32Array(d):calculateBackgroundUVMap(e.width,e.height,l,c,s),b,C*s,T)}h&&(h=Math.min(h,k.width,k.height),N(createRectOutline(k.x,k.y,k.width,k.height,t,I,o,r),h*s,applyOpacity(m,g),!0))},drawEllipse:(e,t,o,r,n,i,a,l,c=void 0,u=void 0,d=void 0,h,m,g,b)=>{const y=rectMultiply(rectCreate(e.x-t,e.y-o,2*t,2*o),s);if(a||l){const e=rectClone$1(y);b||(e.x-=.5,e.y-=.5,e.width+=1,e.height+=1);const t=createRectPoints(e,r,n,i);((e,t,o,r,n=P,i,a=RECT_UV,s=1,l=!1)=>{const{program:c,locations:u}=q;R.useProgram(c),R.enableVertexAttribArray(u.aPosition),R.enableVertexAttribArray(u.aTexCoord),R.uniformMatrix4fv(u.uMatrix,!1,p),R.uniform2fv(u.uRadius,[.5*t,.5*o]),R.uniform2fv(u.uTextureAdjust,[i.width/(.5*t),i.height/(.5*o)]),R.uniform1i(u.uInverted,l?1:0),R.uniform4fv(u.uColor,r),R.uniform4f(u.uCanvasColor,_,x,v,S),R.uniform2fv(u.uRepeat,[1,1]),R.uniform1fv(u.uMaskBounds,$),R.uniform1f(u.uMaskOpacity,f),R.uniform1i(u.uTexture,4),R.uniform1f(u.uTextureOpacity,s),R.activeTexture(R.TEXTURE0+4),R.bindTexture(R.TEXTURE_2D,n),R.bindBuffer(R.ARRAY_BUFFER,Y),R.bufferData(R.ARRAY_BUFFER,a,R.STATIC_DRAW),R.vertexAttribPointer(u.aTexCoord,2,R.FLOAT,!1,0,0),R.bindBuffer(R.ARRAY_BUFFER,X),R.bufferData(R.ARRAY_BUFFER,e,R.STATIC_DRAW),R.vertexAttribPointer(u.aPosition,2,R.FLOAT,!1,0,0),R.drawArrays(R.TRIANGLE_STRIP,0,e.length/2),R.disableVertexAttribArray(u.aPosition),R.disableVertexAttribArray(u.aTexCoord)})(rectPointsToVertices(t),e.width,e.height,applyOpacity(a,g),l,c||sizeCreate(.5*e.width,.5*e.height),d?new Float32Array(d):calculateBackgroundUVMap(e.width,e.height,c,u,s),g,b)}h&&N(createEllipseOutline(y.x,y.y,y.width,y.height,r,n,i),h*s,applyOpacity(m,g),!0)},drawImage:(e,t,o,n,i,l,c,u,p,d,h=COLOR_MATRIX_IDENTITY$1,m=1,g,y=1,_=0,x=b,v=NO_CORNERS,S=COLOR_TRANSPARENT,w=!1,P=!1,I=!0)=>{const E=t.width*s,M=t.height*s,A=-.5*E,O=.5*M,B=.5*E,N=-.5*M,V=new Float32Array([A,N,0,A,O,0,B,N,0,B,O,0]);R.bindBuffer(R.ARRAY_BUFFER,L),R.bufferData(R.ARRAY_BUFFER,V,R.STATIC_DRAW);const W=t.height/2/k*(r.height/t.height)*-1;i*=s,l*=s,o*=s,n*=s;const{program:U,locations:H}=F,G=mat4Create();mat4Perspective(G,T,a,1,2*-W),mat4Translate(G,i,-l,W),mat4Translate(G,o,-n,0),mat4RotateZ(G,-p),mat4Scale(G,d),mat4Translate(G,-o,n,0),mat4RotateY(G,u),mat4RotateX(G,c),R.useProgram(U),R.enableVertexAttribArray(H.aPosition),R.enableVertexAttribArray(H.aTexCoord),R.uniform1i(H.uTexture,3),R.uniform2f(H.uTextureSize,t.width,t.height),R.activeTexture(R.TEXTURE0+3),R.bindTexture(R.TEXTURE_2D,e);const j=P?1:0,q=C.get(j);R.uniform1i(H.uTextureBlend,j),R.activeTexture(R.TEXTURE0+j),R.bindTexture(R.TEXTURE_2D,q);const X=w?2:0,Y=C.get(X);R.uniform1i(H.uTextureOverlay,X),R.activeTexture(R.TEXTURE0+X),R.bindTexture(R.TEXTURE_2D,Y),R.bindBuffer(R.ARRAY_BUFFER,L),R.vertexAttribPointer(H.aPosition,3,R.FLOAT,!1,0,0);const Z=SHOULD_APPLY_ROTATED_UV_TO_VIDEO_TEXTURES&&ee(e);let K;R.bindBuffer(R.ARRAY_BUFFER,Z?z:D),R.vertexAttribPointer(H.aTexCoord,2,R.FLOAT,!1,0,0),R.uniformMatrix4fv(H.uMatrix,!1,G),R.uniform4fv(H.uOverlayColor,S),!g||arrayEqual(g,CLARITY_IDENTITY)?(g=CLARITY_IDENTITY,K=-1):(K=g.reduce(((e,t)=>e+t),0),K=K<=0?1:K),R.uniform1fv(H.uClarityKernel,g),R.uniform1f(H.uClarityKernelWeight,K),R.uniform1f(H.uColorGamma,1/y),R.uniform1f(H.uColorVignette,_),R.uniform1i(H.uAntialias,I?1:0),R.uniform4f(H.uColorOffset,h[4],h[9],h[14],h[19]),R.uniformMatrix4fv(H.uColorMatrix,!1,[h[0],h[1],h[2],h[3],h[5],h[6],h[7],h[8],h[10],h[11],h[12],h[13],h[15],h[16],h[17],h[18]]),R.uniform1f(H.uOpacity,m),R.uniform1f(H.uMaskOpacity,f),R.uniform1fv(H.uMaskBounds,$),R.uniform1fv(H.uMaskCornerRadius,v.map((e=>e*s))),R.uniform1fv(H.uMaskFeather,x.map(((e,t)=>t%2==0?e:e*s))),R.drawArrays(R.TRIANGLE_STRIP,0,4),R.disableVertexAttribArray(H.aPosition),R.disableVertexAttribArray(H.aTexCoord)},textureFilterNearest:R.NEAREST,textureFilterLinear:R.LINEAR,textureClamp:R.CLAMP_TO_EDGE,textureRepeat:R.REPEAT,textureCreate:()=>R.createTexture(),textureUpdate:(e,t,o)=>(Z.set(e,{src:t,options:o,isRotatedVideo:"VIDEO"===t.nodeName&&(t.dataset&&90==t.dataset.rotation||270==t.dataset.rotation)}),updateTexture(R,e,t,o)),textureGetSize:e=>{const{src:t,options:o}=Z.get(e),r=sizeCreateFromAny(t);return o.scalar?sizeApply(r,(e=>e/o.scalar)):r},textureDelete:Q,enablePreviewStencil:()=>{R.stencilOp(R.KEEP,R.KEEP,R.REPLACE),R.stencilFunc(R.ALWAYS,1,255),R.stencilMask(255)},applyPreviewStencil:()=>{R.stencilFunc(R.EQUAL,1,255),R.stencilMask(0)},disablePreviewStencil:w,setCanvasColor(e){_=e[0],x=e[1],v=e[2],S=o?e[3]:1,R.clear(R.COLOR_BUFFER_BIT)},resetCanvasMatrix:()=>{mat4Ortho(c,0,r.width,r.height,0,-1,1)},updateCanvasMatrix(e,t,o,n,i){const a=e.width,l=e.height,u=r.width*(.5/s),p=r.height*(.5/s),d={x:u+(o.x+t.x),y:p+(o.y+t.y)},h={x:d.x-t.x,y:d.y-t.y},m=.5*a,g=.5*l;vectorRotate(h,i.z,d),vectorScale(h,n,d);mat4Translate(c,(h.x-m)*s,(h.y-g)*s,0),mat4Translate(c,m*s,g*s,0),mat4RotateZ(c,i.z);const f=i.x>Math.PI/2;mat4RotateX(c,f?Math.PI:0);const $=i.y>Math.PI/2;mat4RotateY(c,$?Math.PI:0),mat4Scale(c,n),mat4Translate(c,-m*s,-g*s,0)},drawToCanvas(){R.bindFramebuffer(R.FRAMEBUFFER,null),p=c,R.viewport(0,0,R.drawingBufferWidth,R.drawingBufferHeight),R.colorMask(!0,!0,!0,!0),R.clearColor(_,x,v,S),R.clear(R.COLOR_BUFFER_BIT),y=[1,0,1,0,1,r.width,1,r.width]},drawToImageBlendBuffer(e,t){J(1,A,e,t)},drawToImageOverlayBuffer(e,t){J(2,E,e,t)},enableMask(e,t){const o=e.x*s,n=e.y*s,i=e.width*s,a=e.height*s;g=o,h=g+i,d=r.height-n,m=r.height-(n+a),f=1-t,$=[d,h,m,g]},disableMask(){g=0,h=r.width,d=r.height,m=0,f=1,$=[d,h,m,g]},resize:(t,o,i)=>{s=Math.max(1,i),l=1===s?.75:1,n.width=t,n.height=o,r.width=t*s,r.height=o*s,a=getAspectRatio(r.width,r.height),e.width=r.width,e.height=r.height,mat4Ortho(c,0,r.width,r.height,0,-1,1),b=[1,0,1,0,1,n.width,1,n.width]},release(){Array.from(Z.keys()).forEach((e=>Q(e,{forceRelease:!0}))),Z.clear(),C.forEach((e=>{R.deleteTexture(e)})),C.clear(),F.destroy(),O.destroy(),V.destroy(),U.destroy(),q.destroy(),e.width=1,e.height=1,e=void 0}}},numberToEven=e=>e%2==0?e:e+1;const createCanvasReader=()=>[[async(e,t,o)=>{const{src:r}=e,n=parseInt(r.width,10),i=parseInt(r.height,10),a=await canvasToBlob(r);return{...e,dest:a,size:{width:n,height:i}}},"read-canvas"]];var imageStateToCanvas=(e,t,o)=>{const{targetCanvas:r,targetSize:n,disableDraw:i=!1,shapePreprocessor:a}=o||{},s=r||document.createElement("canvas"),{crop:l,colorMatrix:c,convolutionMatrix:u}=t,p=isVideoElement(e),d={width:p?e.videoWidth:e.width,height:p?e.videoHeight:e.height},{upscale:m=!1,fit:g="contain",width:f,height:$}=n||{};let b=1;"contain"===g?b=Math.min((f||Number.MAX_SAFE_INTEGER)/l.width,($||Number.MAX_SAFE_INTEGER)/l.height):"cover"===g&&(b=Math.max((f||l.width)/l.width,($||l.height)/l.height)),m||(b=Math.min(b,1));const y="force"===g?f:Math.floor(l.width*b),_="force"===g?$:Math.floor(l.height*b),x=p?numberToEven(y):y,v=p?numberToEven(_):_,S=createWebGLCanvas(s,{alpha:!0});S.resize(x,v,1);const C=S.textureCreate();let w;S.setCanvasColor([0,0,0,0]),S.drawToCanvas(),S.disableMask(),S.disablePreviewStencil();{const e=Object.values(c||{}).filter(Boolean);e.length&&(w=getColorMatrixFromColorMatrices(e))}const T={x:0,y:0,width:x,height:v},{origin:k,translation:R,rotation:P,scale:I}=calculateImageTransforms(T,T,d,l,{x:0,y:0,width:x,height:v},b,{x:0,y:0},1,t.rotation,t.flipX,t.flipY),E=[d,k.x,k.y,R.x,R.y,P.x,P.y,P.z,I,w,1,u&&u.clarity,isNumber(t.gamma)?t.gamma:1,t.vignette||0,[1,0,1,0,1,v,1,x],void 0,void 0,void 0,void 0,!1];let M=!1;const A=t.decoration.length||t.annotation.length,F=A&&S.textureCreate(),L=()=>{S.textureUpdate(C,e,{filterParam:S.textureFilterLinear,wrapParam:S.textureClamp})},D=()=>{L(),S.drawImage(C,...E),A&&M&&S.drawRect(T,0,!1,!1,[0,0,0,0],void 0,F)};return L(),!i&&D(),{canvas:s,prepare:async()=>{if(!A)return;const{dest:e}=await processImage(h("canvas",d),{shapePreprocessor:a,imageReader:createCanvasReader(),imageWriter:createDefaultImageWriter$1({format:"canvas"}),imageState:{...t,redaction:[],frame:void 0,gamma:void 0,convolutionMatrix:void 0,colorMatrix:void 0,backgroundColor:[0,0,0,0],backgroundImage:void 0,trim:void 0,vignette:void 0,volume:void 0}});S.textureUpdate(F,e,{filterParam:S.textureFilterLinear,wrapParam:S.textureClamp}),M=!0,!i&&D()},redraw:D,destroy:()=>{S.release()}}},scrambleEffect=(e,t)=>{const{imageData:o,amount:r=1}=e,n=Math.round(2*Math.max(1,r)),i=Math.round(.5*n),a=o.width,s=o.height,l=new Uint8ClampedArray(a*s*4),c=o.data;let u,p,d,h,m,g=0,f=0,$=0;const b=a*s*4-4;for(d=0;d<s;d++)for(u=crypto.getRandomValues(new Uint8ClampedArray(s)),p=0;p<a;p++)h=u[d]/255,f=0,$=0,h<.5&&(f=4*(-i+Math.round(Math.random()*n))),h>.5&&($=(-i+Math.round(Math.random()*n))*(4*a)),m=Math.min(Math.max(0,g+f+$),b),l[g]=c[m],l[g+1]=c[m+1],l[g+2]=c[m+2],l[g+3]=c[m+3],g+=4;t(null,{data:l,width:o.width,height:o.height})};const BLUR_MATRIX=[.0625,.125,.0625,.125,.25,.125,.0625,.125,.0625];var imageDataScramble=async(e,t={})=>{if(!e)return;const{width:o,height:r}=e,{dataSize:n=96,dataSizeScalar:i=1,scrambleAmount:a=4,blurAmount:s=6,outputFormat:l="canvas",backgroundColor:c=[0,0,0]}=t,u=Math.round(n*i),p=Math.min(u/o,u/r),d=Math.floor(o*p),m=Math.floor(r*p),g=h("canvas",{width:d,height:m}),f=g.getContext("2d",{willReadFrequently:!0});if(c.length=3,f.fillStyle=colorArrayToRGBA(c),f.fillRect(0,0,d,m),isImageData(e)){const t=h("canvas",{width:o,height:r});t.getContext("2d",{willReadFrequently:!0}).putImageData(e,0,0),f.drawImage(t,0,0,d,m),releaseCanvas(t)}else f.drawImage(e,0,0,d,m);const $=f.getImageData(0,0,d,m),b=[];if(a>0&&b.push([scrambleEffect,{amount:a}]),s>0)for(let e=0;e<s;e++)b.push([convolutionEffect,{matrix:BLUR_MATRIX}]);let y;if(b.length){const e=(t,o)=>`(err, imageData) => {\n(${t[o][0].toString()})(Object.assign({ imageData: imageData }, filterInstructions[${o}]), \n${t[o+1]?e(t,o+1):"done"})\n}`,t=`function (options, done) {\nconst filterInstructions = options.filterInstructions;\nconst imageData = options.imageData;\n(${e(b,0)})(null, imageData)\n}`,o=await thread(t,[{imageData:$,filterInstructions:b.map((e=>e[1]))}],[$.data.buffer]);y=imageDataObjectToImageData(o)}else y=$;return"canvas"===l?(f.putImageData(y,0,0),g):y};function circOut(e){return Math.sqrt(1- --e*e)}function is_date(e){return"[object Date]"===Object.prototype.toString.call(e)}function get_interpolator(e,t){if(e===t||e!=e)return()=>e;const o=typeof e;if(o!==typeof t||Array.isArray(e)!==Array.isArray(t))throw new Error("Cannot interpolate values of different type");if(Array.isArray(e)){const o=t.map(((t,o)=>get_interpolator(e[o],t)));return e=>o.map((t=>t(e)))}if("object"===o){if(!e||!t)throw new Error("Object cannot be null");if(is_date(e)&&is_date(t)){e=e.getTime();const o=(t=t.getTime())-e;return t=>new Date(e+t*o)}const o=Object.keys(t),r={};return o.forEach((o=>{r[o]=get_interpolator(e[o],t[o])})),e=>{const t={};return o.forEach((o=>{t[o]=r[o](e)})),t}}if("number"===o){const o=t-e;return t=>e+t*o}throw new Error(`Cannot interpolate ${o} values`)}function tweened(e,t={}){const o=writable(e);let r,n=e;function i(i,a){if(null==e)return o.set(e=i),Promise.resolve();n=i;let s=r,l=!1,{delay:c=0,duration:u=400,easing:p=identity,interpolate:d=get_interpolator}=assign(assign({},t),a);if(0===u)return s&&(s.abort(),s=null),o.set(e=n),Promise.resolve();const h=now()+c;let m;return r=loop((t=>{if(t<h)return!0;l||(m=d(e,i),"function"==typeof u&&(u=u(e,i)),l=!0),s&&(s.abort(),s=null);const r=t-h;return r>u?(o.set(e=i),!1):(o.set(e=m(p(r/u))),!0)})),r.promise}return{set:i,update:(t,o)=>i(t(n,e),o),subscribe:o.subscribe}}function tick_spring(e,t,o,r){if("number"==typeof o){const n=r-o,i=(o-t)/(e.dt||1/60),a=(i+(e.opts.stiffness*n-e.opts.damping*i)*e.inv_mass)*e.dt;return Math.abs(a)<e.opts.precision&&Math.abs(n)<e.opts.precision?r:(e.settled=!1,o+a)}if(isArray(o))return o.map(((n,i)=>tick_spring(e,t[i],o[i],r[i])));if("object"==typeof o){const n={};for(const i in o)n[i]=tick_spring(e,t[i],o[i],r[i]);return n}throw new Error(`Cannot spring ${typeof o} values`)}function spring(e,t={}){const o=writable(e),{stiffness:r=.15,damping:n=.8,precision:i=.01}=t;let a,s,l,c=e,u=e,p=1,d=0,h=!1;function m(t,r={}){u=t;const n=l={};if(null==e||r.hard||g.stiffness>=1&&g.damping>=1)return h=!0,a=null,c=t,o.set(e=u),Promise.resolve();if(r.soft){const e=!0===r.soft?.5:+r.soft;d=1/(60*e),p=0}if(!s){a=null,h=!1;const t={inv_mass:void 0,opts:g,settled:!0,dt:void 0};s=loop((r=>{if(null===a&&(a=r),h)return h=!1,s=null,!1;p=Math.min(p+d,1),t.inv_mass=p,t.opts=g,t.settled=!0,t.dt=60*(r-a)/1e3;const n=tick_spring(t,c,e,u);return a=r,c=e,o.set(e=n),t.settled&&(s=null),!t.settled}))}return new Promise((e=>{s.promise.then((()=>{n===l&&e()}))}))}const g={set:m,update:(t,o)=>m(t(u,e),o),subscribe:o.subscribe,stiffness:r,damping:n,precision:i};return g}var prefersReducedMotion=readable(!1,(e=>{const t=window.matchMedia("(prefers-reduced-motion:reduce)"),o=()=>e(t.matches);return o(),t.addListener(o),()=>t.removeListener(o)})),hasResizeObserver=()=>"ResizeObserver"in window;const rectNext=rectCreateEmpty(),updateNodeRect=(e,t,o,r,n)=>{e.rect||(e.rect=rectCreateEmpty());const i=e.rect;rectUpdate(rectNext,t,o,r,n),rectEqual(i,rectNext)||(rectUpdateWithRect(i,rectNext),e.dispatchEvent(new CustomEvent("measure",{detail:i})))},r=Math.round,measureViewRect=e=>{const t=e.getBoundingClientRect();frame&&updateNodeRect(e,r(t.x),r(t.y),r(t.width),r(t.height))},measureOffset=e=>{frame&&updateNodeRect(e,e.offsetLeft,e.offsetTop,e.offsetWidth,e.offsetHeight)},elements=[];let frame,observer,rootObserver;function tick(){elements.length?(elements.forEach((e=>e.measure(e))),frame=requestAnimationFrame(tick)):frame=void 0}let rootRects=new Map([]),observedRoots=0,observedNodes=0;var measurable=(e,t={})=>{const{observePosition:o=!1,observeViewRect:r=!1,once:n=!1,disabled:i=!1,isMeasureRoot:a=!1}=t;if(hasResizeObserver()&&a&&(rootObserver||(rootObserver=new ResizeObserver((e=>{e.forEach((e=>{rootRects.set(e.target,e.contentRect)}));const t=Array.from(rootRects.values()).some((({width:e,height:t})=>e>0&&t>0));t?t&&!1===frame&&tick():(frame&&cancelAnimationFrame(frame),frame=!1)}))),rootObserver.observe(e),observedRoots++),!i)return!hasResizeObserver()||o||r?(e.measure=r?measureViewRect:measureOffset,elements.push(e),void 0===frame&&(frame=requestAnimationFrame(tick)),e.measure(e),{destroy(){a&&rootObserver&&(rootRects.delete(e),rootObserver.unobserve(e),observedRoots--,0===observedRoots&&(rootObserver.disconnect(),rootObserver=void 0));const t=elements.indexOf(e);elements.splice(t,1),delete e.measure}}):(observer||(observer=new ResizeObserver((e=>{e.forEach((e=>{frame&&measureOffset(e.target)}))}))),observer.observe(e),measureOffset(e),n?observer.unobserve(e):observedNodes++,{destroy(){a&&rootObserver&&(rootRects.delete(e),rootObserver.unobserve(e),observedRoots--,0===observedRoots&&(rootObserver.disconnect(),rootObserver=void 0)),n||(observer.unobserve(e),observedNodes--,0===observedNodes&&(observer.disconnect(),observer=void 0))}})},focusvisible=e=>{let t=!1;const o={pointerdown:()=>{t=!1},keydown:()=>{t=!0},keyup:()=>{t=!1},focus:e=>{t&&(e.target.dataset.focusVisible="")},blur:e=>{delete e.target.dataset.focusVisible}};return Object.keys(o).forEach((t=>e.addEventListener(t,o[t],!0))),{destroy(){Object.keys(o).forEach((t=>e.removeEventListener(t,o[t],!0)))}}};const getResourceFromItem=async e=>new Promise((t=>{if("file"===e.kind)return t(e.getAsFile());e.getAsString(t)})),getResourcesFromEvent=e=>new Promise(((t,o)=>{const{items:r}=e.dataTransfer;if(!r)return t([]);Promise.all(Array.from(r).map(getResourceFromItem)).then((e=>{t(e.filter((e=>isBinary(e)&&isImage(e)||/^http/.test(e))))})).catch(o)}));var dropable=(e,t={})=>{const o=e=>{e.preventDefault()},r=async o=>{o.preventDefault(),o.stopPropagation();try{const r=await getResourcesFromEvent(o);e.dispatchEvent(new CustomEvent("dropfiles",{detail:{event:o,resources:r},...t}))}catch(e){}};return e.addEventListener("drop",r),e.addEventListener("dragover",o),{destroy(){e.removeEventListener("drop",r),e.removeEventListener("dragover",o)}}};let result$5=null;var isSoftwareRendering=()=>{if(null===result$5)if(isBrowser()){const e=h("canvas");result$5=!getWebGLContext(e,{failIfMajorPerformanceCaveat:!0}),releaseCanvas(e)}else result$5=!1;return result$5},createTransparencyGrid=e=>{const t=.5*e,o=h("canvas",{"data-retain":!0,width:e,height:e}),r=o.getContext("2d");return r.fillStyle="#f0f",r.fillRect(0,0,t,t),r.fillRect(t,t,t,t),o},durationToMilliseconds=e=>{let t=parseFloat(e);return/^[0-9]+s$/.test(e)?1e3*t:t},isTexture=e=>e instanceof WebGLTexture,backgroundCornersToUVMap=([e,t,o,r])=>[r.x,r.y,e.x,e.y,o.x,o.y,t.x,t.y],isVideoPlaying=e=>e.currentTime>0&&!e.paused&&!e.ended&&e.readyState>2,ctxDrawSelection=(e,t,o)=>{const{selectionColor:r=[1,1,1],scalar:n=1}=o||{};let i=!1;for(const o of t){const t="subtract"===o.drawMode;if(t&&!i)continue;e.globalCompositeOperation=t?"destination-out":"source-over",e.save(),e.beginPath();const a=shapeGetCenter(o);ctxScale(e,n,n),ctxRotate(e,o.rotation,a),ctxFlip(e,o.flipX,o.flipY,a),o.width?drawRect(e,{...o,backgroundColor:r}):o.points?drawPath(e,Object.assign({},o,o.pathClose?{backgroundColor:r,strokeColor:[0,0,0,0]}:{strokeColor:r,strokeJoin:"round",strokeCap:"round"})):o.rx&&drawEllipse(e,{...o,backgroundColor:r,strokeColor:[0,0,0,0],strokeJoin:"round",strokeCap:"round"}),e.restore(),i=!0}};function create_fragment$U(e){let t,o,r,n;return{c(){t=element("div"),o=element("canvas"),attr(t,"class","PinturaCanvas")},m(i,a){insert(i,t,a),append(t,o),e[37](o),r||(n=[listen(o,"measure",e[38]),action_destroyer(measurable.call(null,o))],r=!0)},p:noop,i:noop,o:noop,d(o){o&&detach(t),e[37](null),r=!1,run_all(n)}}}const SELECTION_MAX_SIZE=2048;let throttledMinRedrawDist=48;function instance$V(e,t,o){let r,n,i,a,s,l,c;const u=[0,0,0,0],p=vectorCreateEmpty(),d=isBrowser()&&createTransparencyGrid(128),m=createEventDispatcher();let g,{isAnimated:f}=t,{isTransparent:$}=t,{maskRect:b}=t,{maskOpacity:y=1}=t,{maskFrameOpacity:_=.95}=t,{maskMarkupOpacity:x=1}=t,{clipAnnotationsToImage:v=!0}=t,{pixelRatio:S=1}=t,{textPixelRatio:C=S}=t,{backgroundColor:w}=t,{willRender:T=passthrough}=t,{didRender:k=passthrough}=t,{willRequest:R}=t,{csp:P}=t,{loadImageData:I=passthrough}=t,{enableGrid:E=!1}=t,{gridColors:M}=t,{gridSize:A}=t,{gridOpacity:F=0}=t,{images:L=[]}=t,{interfaceImages:D=[]}=t,{selectionColor:z}=t,O=null,B=null,N=null;const V=(e,t)=>e.set(t,{hard:!f}),W={precision:1e-4*.01};let U=0;const H=tweened(void 0,{duration:0});component_subscribe(e,H,(e=>o(36,c=e)));const G=spring(1,W);component_subscribe(e,G,(e=>o(35,s=e)));const j=spring(1,W);component_subscribe(e,j,(e=>o(51,i=e)));const q=writable();component_subscribe(e,q,(e=>o(53,l=e)));const X=writable();component_subscribe(e,X,(e=>o(52,a=e)));const Y={},Z=(e,t)=>{let o=Y[e.id];const r=Math.min(1,2048/t.width);let n=o?o.element:h("canvas",{width:t.width*r,height:t.height*r,"data-retain":!0});if(!o||((e,t)=>{if(e.total!==t.length)return!0;const o=e.last,r=t[t.length-1];return o.drawMode!==r.drawMode||!(!shapeIsRect(o)||shapeIsRect(r)&&rectEqual(o,r))||!(!shapeIsEllipse(o)||shapeIsEllipse(r)&&o.x===r.x&&o.y===r.y&&o.rx===r.rx&&o.ry===r.ry)||!(!shapeIsPath(o)||shapeIsPath(r)&&r.points.length===o.points.length)})(o,e.actions)){n=n.cloneNode(),ctxDrawSelection(n.getContext("2d"),e.actions,{selectionColor:[1,0,1],scalar:r});const t=e.actions.length;Y[e.id]={total:t,last:{...e.actions[t-1]},element:n}}return{x:0,y:0,...t,fillColor:e.color||[1,1,1],backgroundImage:n}};let K;const J=()=>{cancelAnimationFrame(K),K=requestAnimationFrame((()=>{$e=!0,ke=0,n()}))},Q=new Map([]),ee=new Map([]),te=(e,t)=>({filterParam:"pixelated"===e?O.textureFilterNearest:O.textureFilterLinear,wrapParam:"repeat"===t?O.textureRepeat:O.textureClamp}),oe=(e,t,o)=>{if(!Q.has(e)){Q.set(e,e);const n=te(t,o);if(!isString(r=e)&&(isImageBitmap(r)||isImageData(r)||isCanvas(r)||isVideoElement(r))){const t=O.textureCreate();O.textureUpdate(t,e,n),Q.set(e,t)}else I(e).then((t=>{if(!O||!t)return;const o=O.textureCreate();O.textureUpdate(o,t,n),Q.set(e,o),J()})).catch((t=>{Q.set(e,t)}))}var r;if(isVideoElement(e)&&(isVideoPlaying(e)||"true"===e.dataset.redraw)){const r=Q.get(e),n=te(t,o);return O.textureUpdate(r,e,n),e.dataset.redraw=!1,r}return Q.get(e)},re=(e,t={})=>{const o=t.id||e.id;if(e.width&&e.width<1||e.height&&e.height<1||!e.text.length)return void ee.delete(o);let{text:r,textAlign:n,fontFamily:i,fontSize:a=16,fontWeight:s,fontVariant:l,fontStyle:c,letterSpacing:u,lineHeight:p=a,width:d,height:h}=e,{outline:m=0,blur:g=0,paddingTop:f=0,paddingRight:$=0,paddingBottom:b=0,paddingLeft:y=0}=t;d=isNumber(d)?Math.floor(d):d,h=isNumber(h)?Math.floor(h):h;const{textSize:_,signature:x}=textMeasure(r,{...e,width:d,height:void 0}),v=objectUID({text:r,textAlign:n,fontFamily:i,fontSize:a,fontWeight:s,fontVariant:l,fontStyle:c,lineHeight:p,letterSpacing:u,outline:m,blur:g,signature:x});if(!Q.has(v)){Q.set(v,r);const e=Math.ceil(_.width),t=Math.ceil(_.height);if(0===e||0===t)return;const x=getWebGLTextureSizeLimit(),S=Math.min(1,(x-(y+$)*C)/(e*C),(x-(f+b)*C)/(t*C));textToImage(r,{fontSize:a,fontFamily:i,fontWeight:s,fontVariant:l,fontStyle:c,letterSpacing:u,textAlign:n,lineHeight:p,width:d,height:h,imageWidth:e,imageHeight:t,paddingLeft:y,paddingTop:f,paddingRight:$,paddingBottom:b,pixelRatio:C*S,willRequest:R,outline:m,blur:g,styleNonce:P.styleNonce,color:[1,0,1]}).then((e=>{if(!O)return;const t=O.textureCreate();O.textureUpdate(t,e,{filterParam:O.textureFilterLinear,wrapParam:O.textureClamp,scalar:S}),Q.set(v,t),ee.set(o,t),J()})).catch(console.error)}const S=Q.get(v);return isTexture(S)?S:ee.get(o)},ne=new Map,ie=e=>{let t;return e.backgroundImage?t=oe(e.backgroundImage,e.backgroundImageRendering,"repeat"===e.backgroundRepeat?"repeat":void 0):e.bitmap&&e.points&&(t=(e=>{const{id:t,points:o,strokeWidth:r,strokeCap:n,strokeJoin:i,strokeColor:a,strokeDash:s}=e;let l=Q.get(t),c=ne.get(t);const u=objectUID({points:o.map((e=>`${e.x},${e.y}`)).join(","),strokeWidth:r,strokeCap:n,strokeJoin:i,strokeColor:a,strokeDash:(s||[]).join(",")});if(c){const{hash:e}=c;if(Q.has(t)){if(u===e)return Q.get(t)}else c=void 0}if(!c){const o=h("canvas",{width:1,height:1});c={canvas:o,hash:void 0},ne.set(e.id,c),l=O.textureCreate(),O.textureUpdate(l,o,{filterParam:O.textureFilterLinear,wrapParam:O.textureClamp}),Q.set(t,l)}const{canvas:p}=c,d=Math.ceil(e.strokeWidth),m=rectCreateFromPoints(o),g=Math.floor(m.x)-.5*d,f=Math.floor(m.y)-.5*d,$=Math.ceil(m.width+d),b=Math.ceil(m.height+d);p.width=Math.max($,1),p.height=Math.max(b,1);const y=p.getContext("2d");return y.clearRect(0,0,p.width,p.height),$>=1&&b>=1&&(y.translate(-g,-f),drawPath(y,e),y.resetTransform()),O.textureUpdate(l,p,{filterParam:O.textureFilterLinear,wrapParam:O.textureClamp}),ne.set(t,{canvas:p,hash:u}),Q.get(t)})(e)),t},ae=({texture:e,size:t,origin:o,translation:r,rotation:n,scale:i,colorMatrix:a,opacity:s,convolutionMatrix:l,gamma:c,vignette:u,maskFeather:p,maskCornerRadius:d,overlayColor:h,enableOverlay:m,enableManipulation:g,enableAntialiasing:f})=>{let $=0,b=0;if(1===S){const e=Math.abs(1-i)<Number.EPSILON;$=e&&B%2!=0?.5:0,b=e&&N%2!=0?.5:0}return O.drawImage(e,t,o.x,o.y,r.x+$,r.y+b,n.x,n.y,n.z,i,a,clamp(s,0,1),l,c,u,p,d,h,m,g,f),e},se=(e,t,o)=>{const r=rectCenter(t),n=rectCenter(e),i=r.x-n.x,a=r.y-n.y,s=vectorRotate(r,o,n);return{x:s.x-n.x-i,y:s.y-n.y-a}},le=(e,t,o)=>{let r,n;const i=getAspectRatio(o.width,o.height);if("repeat"===e.backgroundRepeat&&(r={...o},n={x:0,y:0}),"contain"===e.backgroundSize){const o=rectContainRect(t,i,t);r=sizeCreateFromRect(o),n=e.backgroundPosition?e.backgroundPosition:vectorCreate(.5*(t.width-r.width),.5*(t.height-r.height))}else if("cover"===e.backgroundSize){const o=rectCoverRect(t,i,t);r=sizeCreateFromRect(o),e.backgroundPosition?n=e.backgroundPosition:(n=vectorCreate(o.x,o.y),n=vectorCreate(.5*(t.width-r.width),.5*(t.height-r.height)))}else e.backgroundSize?(r=e.backgroundSize,n=e.backgroundPosition||{x:0,y:0}):e.backgroundPosition&&(r={...o},n=e.backgroundPosition);return{backgroundSize:r,backgroundPosition:n}},ce=(e=[],t)=>{e.forEach((e=>{let o=ie(e);const r="complete"!==e.status&&("loading"===e.status||e.backgroundImage&&o===e.backgroundImage);r&&J();const n="error"===e.status||e.backgroundImage&&o instanceof Error;let i=isTexture(o)?o:void 0;const a=e._scale||1,s=e._translate||p,l=e.strokeWidth&&e.strokeWidth*a,c=e.cornerRadius?((e,t)=>[e,e,e,e].map((e=>e*t)))(e.cornerRadius,a):u,d=!!e.width,h=isString(e.text),m=isArray(e.points),g=shapeIsEllipse(e);if(m){const r=e.points.map((e=>vectorCreate(e.x*a+s.x,e.y*a+s.y)));if(e.bitmap){o&&t.push(o);const n=rectCreateFromPoints(r),s=Math.ceil(e.strokeWidth*a);O.drawRect({x:Math.floor(n.x)-.5*s,y:Math.floor(n.y)-.5*s,width:Math.ceil(n.width+s),height:Math.ceil(n.height+s)},e.rotation,e.flipX,e.flipY,[0,0,0,0],void 0,i,void 0,void 0,void 0,void 0,void 0,void 0,e.opacity,void 0,void 0,!1,!1)}else O.drawPath(r,e.rotation,e.flipX,e.flipY,l,e.strokeColor,e.pathClose,e.backgroundColor,e.opacity)}else if(g){let c=e.x,u=e.y;c*=a,u*=a,c+=s.x,u+=s.y;const p=rectCreateFromEllipse({x:c,y:u,rx:e.rx*a,ry:e.ry*a}),d=vectorCreate(c,u),h=i&&O.textureGetSize(i);let m,g;if(h&&e.backgroundImage&&(e.backgroundSize||e.backgroundPosition||e.backgroundRepeat)){const t=le(e,p,h);m=t.backgroundSize,g=t.backgroundPosition}O.drawEllipse(d,e.rx*a,e.ry*a,e.rotation,e.flipX,e.flipY,e.backgroundColor,i,m,g,e.backgroundCorners&&backgroundCornersToUVMap(e.backgroundCorners),l,e.strokeColor,e.opacity,e.inverted),o&&t.push(o),(r||n)&&(e.backgroundColor||e.strokeColor&&e.strokeWidth||O.drawEllipse(d,e.rx*a,e.ry*a,e.rotation,e.flipX,e.flipY,n?[1,0,0,.25*e.opacity]:[0,0,0,.25*e.opacity]),n&&ge(d),r&&me(d))}else if(h){const{fontSize:o=16}=e,r=o>1e3&&isFirefox()?o/1e3:1,n=Math.max(16,Math.ceil(o/r*.25)),i=Math.abs(e.rotation)>0,p=isNumber(e.width)?Math.floor(e.width):e.width,d=isNumber(e.height)?Math.floor(e.height):e.height,h=textToSize(e.text,{...e,width:p,height:d}),m=Math.ceil(h.width),g=Math.ceil(h.height),f={x:e.x*a+s.x,y:e.y*a+s.y,width:m*a,height:g*a},$=!!e.height;(e.backgroundColor||e.strokeColor)&&O.drawRect(f,e.rotation,e.flipX,e.flipY,c,e.backgroundColor,void 0,void 0,void 0,!1,void 0,l,e.strokeColor,e.opacity,void 0,void 0,void 0,e.inverted);const{textShadowX:b,textShadowY:y,textShadowBlur:_}=e;if(b||y||_){const o=Math.ceil(.5*_),l=Math.max(n,$?0:o),c=re(e,{id:e.id+"shadow",blur:_,paddingTop:l,paddingRight:l,paddingBottom:l,paddingLeft:l});if(c&&!e._prerender){t.push(c);const o=O.textureGetSize(c),l={x:0,y:0},u={width:o.width/C*a,height:o.height/C*a},p=n*a/r;let d;if($)d={...f},l.x=b-p,l.y=y-p;else if(d={x:e.x*a+s.x-p,y:e.y*a+s.y-p,width:u.width,height:u.height},i){const t=se(f,d,e.rotation);d.x+=t.x,d.y+=t.y;const o=vectorRotate(vectorCreate(b,y),e.rotation);d.x+=o.x,d.y+=o.y}else d.x+=b,d.y+=y;O.drawRect(d,e.rotation,e.flipX,e.flipY,[0,0,0,0],void 0,c,u,l,!1,void 0,void 0,void 0,e.opacity,void 0,0,e.textShadowColor)}}if(e.textOutlineWidth){const o=Math.ceil(.5*e.textOutlineWidth),l=n+o,c=re(e,{id:e.id+"outline",outline:e.textOutlineWidth,paddingTop:l,paddingRight:l,paddingBottom:l,paddingLeft:l});if(c&&!e._prerender){t.push(c);const l=O.textureGetSize(c),u={x:0,y:0},p={width:l.width/C*a,height:l.height/C*a},d=(n+o)*a/r,h={x:e.x*a+s.x-d,y:e.y*a+s.y-d,width:p.width,height:e.height?g+d:p.height};if(i){const t=se(f,h,e.rotation);h.x+=t.x,h.y+=t.y}O.drawRect(h,e.rotation,e.flipX,e.flipY,[0,0,0,0],void 0,c,p,u,!1,void 0,void 0,void 0,e.opacity,void 0,0,e.textOutlineColor)}}const x=re(e,{id:e.id+"text",paddingTop:n,paddingRight:n,paddingBottom:n,paddingLeft:n});if(x&&!e._prerender){t.push(x);const o=O.textureGetSize(x),l={x:0,y:0},c={width:o.width/C*a,height:o.height/C*a},p=n*a/r,d={x:e.x*a+s.x-p,y:e.y*a+s.y-p,width:c.width,height:e.height?g+p:c.height};if(i){const t=se(f,d,e.rotation);d.x+=t.x,d.y+=t.y}const h=e.color||[0,0,0];e._prerender&&(h[3]=0),O.drawRect(d,e.rotation,e.flipX,e.flipY,u,!1,x,c,l,!1,!1,void 0,void 0,e.opacity,void 0,e.feather,h,e.inverted)}}else if(d){o&&t.push(o);const u=rectCreateFromAny(e);let p,d;a&&s&&(u.x*=a,u.y*=a,u.x+=s.x,u.y+=s.y,u.width*=a,u.height*=a);const{backgroundRepeat:h="no-repeat"}=e,m=i&&O.textureGetSize(i);if(m&&e.backgroundImage&&(e.backgroundSize||e.backgroundPosition||e.backgroundRepeat)){const t=le(e,u,m);p=t.backgroundSize,d=t.backgroundPosition}if(O.drawRect(u,e.rotation,e.flipX,e.flipY,c,e.backgroundColor,i,p,d,"repeat"===h,e.backgroundCorners&&backgroundCornersToUVMap(e.backgroundCorners),l,e.strokeColor,e.opacity,void 0,e.feather,e.fillColor,e.inverted),r||n){e.backgroundColor&&0!==e.backgroundColor[3]||e.strokeColor&&e.strokeWidth||O.drawRect(u,e.rotation,e.flipX,e.flipY,c,n?[1,.2549,.2118,.25*e.opacity]:[0,0,0,.25*e.opacity]);const t=rectCenter(u);n&&ge(t),r&&me(t)}}else o&&t.push(o)}))};let ue=0;const pe=[{x:-5,y:-5},{x:5,y:5}],de=[{x:5,y:-5},{x:-5,y:5}],he=ellipseToPolygon({x:0,y:0},10,10,0,!1,!1,16);he.length=9;const me=e=>{ue=Date.now()/50,O.drawEllipse(e,15,15,0,!1,!1,[0,0,0,.5]);const t=vectorsRotate(he.map((t=>({x:t.x+e.x,y:t.y+e.y}))),ue,e.x,e.y);O.drawPath(t,0,!1,!1,2,[1,1,1])},ge=e=>{O.drawEllipse(e,13,13,0,!1,!1,[1,.2549,.2118,.75]);const t=pe.map((t=>({x:t.x+e.x,y:t.y+e.y}))),o=de.map((t=>({x:t.x+e.x,y:t.y+e.y})));O.drawPath(t,0,!1,!1,3,[1,1,1]),O.drawPath(o,0,!1,!1,3,[1,1,1])},fe=(e,t,o,r,n,i)=>O.drawRect(t,0,!1,!1,u,u,e,r,o,!0,void 0,0,void 0,i,void 0,void 0,n);let $e=!1,be=!0,ye=!1;const _e=[],xe=[],ve=[],Se=e=>!e.aboveFrame,Ce=e=>e.aboveFrame,we=()=>{ve.length=0;const e=L[0],{manipulationShapes:t,manipulationShapesDirty:o,annotationShapes:r,annotationShapesDirty:n,interfaceShapes:p,decorationShapes:h,frameShapes:m,selectionShapes:g}=T({opacity:e.opacity,rotation:e.rotation,scale:e.scale,images:L,size:sizeCreate(B,N),backgroundColor:[...c],selectionRect:l}),f=[...c],y=l,_=clamp(s,0,1),S=a,w=Math.abs(e.rotation.x/Math.PI*2-1),R=Math.abs(e.rotation.y/Math.PI*2-1),P=w<.99||R<.99,I={...e.size},V=e.backgroundColor,W=e.backgroundImage,U=t.length>0,H=r.length>0,G=r.filter(Ce).length>0,j=h.filter(Ce).length>0,q=V[3]>0,X=!!v&&x>=1;if(_<1&&q){const e=f[0],t=f[1],o=f[2],r=1-_,n=V[0]*r,i=V[1]*r,a=V[2]*r,s=1-r;f[0]=n+e*s,f[1]=i+t*s,f[2]=a+o*s,f[3]=1}O.setCanvasColor($?u:f);U&&(o||$e)?(O.disableMask(),O.drawToImageBlendBuffer(I),_e.length=0,ce(t,_e)):U||(_e.length=0),ve.push(..._e),be&&(O.drawToImageOverlayBuffer(I,C),be=!1);if(P){if(H&&(n||$e)||!ye){O.disableMask(),O.drawToImageOverlayBuffer(I,C),xe.length=0;const e=G?r.filter(Se):r;ce(e,xe)}else H||(xe.length=0);ye=!0}else ye=!1;if(O.drawToCanvas(),O.enableMask(y,_),E&&A>=1&&2===M.length&&F&&((e,t,o,r,n)=>{const i=sizeCreate(t,t),a=oe(d,"pixelated","repeat"),s=vectorCreate(-e.x%t,-e.y%t),l=vectorCreate(s.x+.5*i.width,s.y);fe(a,e,s,i,o,n),fe(a,e,l,i,r,n)})(y,A,M[0],M[1],F),q&&O.drawRect(y,0,!1,!1,u,V),W){O.enableMask(y,1);const e=Math.max(b.width/W.width,b.height/W.height),t=W.width*e,o=W.height*e,r={x:b.x+.5*b.width-.5*t,y:b.y+.5*b.height-.5*o,width:t,height:o};O.drawRect(r,0,!1,!1,u,u,oe(W,"linear")),O.enableMask(y,_)}if(X&&O.enablePreviewStencil(),ve.push(...[...L].reverse().map((e=>ae({...e,texture:oe(e.data),enableOverlay:P&&H,enableManipulation:U,enableAntialiasing:!0,mask:y,maskOpacity:_,overlayColor:S})))),O.enableMask(y,x),!P){X&&O.applyPreviewStencil(),O.resetCanvasMatrix(),O.updateCanvasMatrix(I,e.origin,e.translation,e.scale,e.rotation),xe.length=0;const t=G?r.filter(Se):r;ce(t,xe),X&&O.disablePreviewStencil()}if(ve.push(...xe),O.resetCanvasMatrix(),O.enableMask(y,x),ce(j?h.filter(Se):h,ve),m.length){O.enableMask(y,1);const e=m.filter((e=>!e.expandsCanvas)),t=m.filter((e=>e.expandsCanvas));e.length&&ce(e,ve),t.length&&(O.enableMask({x:y.x+.5,y:y.y+.5,width:y.width-1,height:y.height-1},i),ce(t,ve))}if(G&&(O.resetCanvasMatrix(),O.updateCanvasMatrix(I,e.origin,e.translation,e.scale,e.rotation),ce(r.filter(Ce),ve),O.resetCanvasMatrix()),j&&(O.resetCanvasMatrix(),ce(h.filter(Ce),ve),O.resetCanvasMatrix()),z&&g.length&&!P){O.resetCanvasMatrix(),O.updateCanvasMatrix(I,e.origin,e.translation,e.scale,e.rotation);const t=[...z];t[3]=.5;const o=[{id:"selection",color:t,actions:[...g]}].map((e=>Z(e,I)));ce(o,ve),O.resetCanvasMatrix()}O.disableMask(),ce(p,ve),D.forEach((e=>{if(O.enableMask(e.mask,e.maskOpacity),e.backgroundColor){const t=W&&rectCoverRect({...e.mask},W.width/W.height),o=W&&oe(W,"linear");O.drawRect(e.mask,0,!1,!1,e.maskCornerRadius,e.backgroundColor,o,t,t,void 0,void 0,void 0,void 0,e.opacity,e.maskFeather),o&&ve.push(o)}const t=ae({...e,texture:oe(e.data),enableAntialiasing:!1,translation:{x:e.translation.x+e.offset.x-.5*B,y:e.translation.y+e.offset.y-.5*N}});ve.push(t)})),O.disableMask(),(e=>{Q.forEach(((t,o)=>{!e.find((e=>e===t))&&isTexture(t)&&(Array.from(ee.values()).includes(t)||(Q.delete(o),O.textureDelete(t)))}))})(ve),k(),$e=!1};let Te,ke=0;const Re=()=>{clearTimeout(Te);const e=Date.now();e-ke<throttledMinRedrawDist?Te=setTimeout(Re,throttledMinRedrawDist):(ke=e,we())};afterUpdate((()=>n())),onMount((()=>o(31,O=createWebGLCanvas(g,{alpha:$})))),onDestroy((()=>{O&&(ne.forEach((({canvas:e})=>releaseCanvas(e))),ne.clear(),O.release(),o(31,O=void 0),o(0,g=void 0))}));return e.$$set=e=>{"isAnimated"in e&&o(9,f=e.isAnimated),"isTransparent"in e&&o(10,$=e.isTransparent),"maskRect"in e&&o(11,b=e.maskRect),"maskOpacity"in e&&o(12,y=e.maskOpacity),"maskFrameOpacity"in e&&o(13,_=e.maskFrameOpacity),"maskMarkupOpacity"in e&&o(14,x=e.maskMarkupOpacity),"clipAnnotationsToImage"in e&&o(15,v=e.clipAnnotationsToImage),"pixelRatio"in e&&o(16,S=e.pixelRatio),"textPixelRatio"in e&&o(17,C=e.textPixelRatio),"backgroundColor"in e&&o(18,w=e.backgroundColor),"willRender"in e&&o(19,T=e.willRender),"didRender"in e&&o(20,k=e.didRender),"willRequest"in e&&o(21,R=e.willRequest),"csp"in e&&o(22,P=e.csp),"loadImageData"in e&&o(23,I=e.loadImageData),"enableGrid"in e&&o(24,E=e.enableGrid),"gridColors"in e&&o(25,M=e.gridColors),"gridSize"in e&&o(26,A=e.gridSize),"gridOpacity"in e&&o(27,F=e.gridOpacity),"images"in e&&o(28,L=e.images),"interfaceImages"in e&&o(29,D=e.interfaceImages),"selectionColor"in e&&o(30,z=e.selectionColor)},e.$$.update=()=>{if(1&e.$$.dirty[0]&&g){const e=getComputedStyle(g).getPropertyValue("--color-transition-duration");o(32,U=durationToMilliseconds(e))}262656&e.$$.dirty[0]|2&e.$$.dirty[1]&&w&&H.set(w,{duration:f?U:0}),4096&e.$$.dirty[0]&&V(G,isNumber(y)?y:1),8192&e.$$.dirty[0]&&V(j,isNumber(_)?_:1),2048&e.$$.dirty[0]&&b&&q.set(b),48&e.$$.dirty[1]&&c&&X.set([c[0],c[1],c[2],clamp(s,0,1)]),268435462&e.$$.dirty[0]|1&e.$$.dirty[1]&&o(34,r=!!(O&&B&&N&&L.length)),65542&e.$$.dirty[0]|1&e.$$.dirty[1]&&B&&N&&O&&(ke=0,O.resize(B,N,S)),8&e.$$.dirty[1]&&o(33,n=r?isSoftwareRendering()?Re:we:noop$1),12&e.$$.dirty[1]&&r&&n&&n()},[g,B,N,m,H,G,j,q,X,f,$,b,y,_,x,v,S,C,w,T,k,R,P,I,E,M,A,F,L,D,z,O,U,n,r,s,c,function(e){binding_callbacks[e?"unshift":"push"]((()=>{g=e,o(0,g)}))},e=>{o(1,B=e.detail.width),o(2,N=e.detail.height),m("measure",{width:B,height:N})}]}class Canvas extends SvelteComponent{constructor(e){super(),init(this,e,instance$V,create_fragment$U,safe_not_equal,{isAnimated:9,isTransparent:10,maskRect:11,maskOpacity:12,maskFrameOpacity:13,maskMarkupOpacity:14,clipAnnotationsToImage:15,pixelRatio:16,textPixelRatio:17,backgroundColor:18,willRender:19,didRender:20,willRequest:21,csp:22,loadImageData:23,enableGrid:24,gridColors:25,gridSize:26,gridOpacity:27,images:28,interfaceImages:29,selectionColor:30},null,[-1,-1,-1])}}var arrayJoin=(e,t=Boolean,o=" ")=>e.filter(t).join(o);function get_each_context$8(e,t,o){const r=e.slice();return r[17]=t[o],r}const get_default_slot_changes$1=e=>({tab:4&e}),get_default_slot_context$1=e=>({tab:e[17]});function create_if_block$n(e){let t,o,r,n=[],i=new Map,a=e[2];const s=e=>e[17].id;for(let t=0;t<a.length;t+=1){let o=get_each_context$8(e,a,t),r=s(o);i.set(r,n[t]=create_each_block$8(r,o))}return{c(){t=element("ul");for(let e=0;e<n.length;e+=1)n[e].c();attr(t,"class",o=arrayJoin(["PinturaTabList",e[0]])),attr(t,"role","tablist"),attr(t,"data-layout",e[1])},m(o,i){insert(o,t,i);for(let e=0;e<n.length;e+=1)n[e].m(t,null);e[14](t),r=!0},p(e,l){1124&l&&(a=e[2],group_outros(),n=update_keyed_each(n,l,s,1,e,a,i,t,outro_and_destroy_block,create_each_block$8,null,get_each_context$8),check_outros()),(!r||1&l&&o!==(o=arrayJoin(["PinturaTabList",e[0]])))&&attr(t,"class",o),(!r||2&l)&&attr(t,"data-layout",e[1])},i(e){if(!r){for(let e=0;e<a.length;e+=1)transition_in(n[e]);r=!0}},o(e){for(let e=0;e<n.length;e+=1)transition_out(n[e]);r=!1},d(o){o&&detach(t);for(let e=0;e<n.length;e+=1)n[e].d();e[14](null)}}}function create_each_block$8(e,t){let o,r,n,i,a,s,l,c,u,p,d;const h=t[11].default,m=create_slot(h,t,t[10],get_default_slot_context$1);function g(...e){return t[12](t[17],...e)}function f(...e){return t[13](t[17],...e)}return{key:e,first:null,c(){o=element("li"),r=element("button"),m&&m.c(),a=space(),attr(r,"type","button"),attr(r,"title",n=t[17].label),r.disabled=i=t[17].disabled,attr(o,"role","tab"),attr(o,"aria-controls",s=t[17].href.substring(1)),attr(o,"id",l=t[17].tabId),attr(o,"aria-selected",c=t[17].selected),this.first=o},m(e,t){insert(e,o,t),append(o,r),m&&m.m(r,null),append(o,a),u=!0,p||(d=[listen(r,"keydown",g),listen(r,"click",f)],p=!0)},p(e,a){t=e,m&&m.p&&(!u||1028&a)&&update_slot_base(m,h,t,t[10],u?get_slot_changes(h,t[10],a,get_default_slot_changes$1):get_all_dirty_from_scope(t[10]),get_default_slot_context$1),(!u||4&a&&n!==(n=t[17].label))&&attr(r,"title",n),(!u||4&a&&i!==(i=t[17].disabled))&&(r.disabled=i),(!u||4&a&&s!==(s=t[17].href.substring(1)))&&attr(o,"aria-controls",s),(!u||4&a&&l!==(l=t[17].tabId))&&attr(o,"id",l),(!u||4&a&&c!==(c=t[17].selected))&&attr(o,"aria-selected",c)},i(e){u||(transition_in(m,e),u=!0)},o(e){transition_out(m,e),u=!1},d(e){e&&detach(o),m&&m.d(e),p=!1,run_all(d)}}}function create_fragment$T(e){let t,o,r=e[4]&&create_if_block$n(e);return{c(){r&&r.c(),t=empty()},m(e,n){r&&r.m(e,n),insert(e,t,n),o=!0},p(e,[o]){e[4]?r?(r.p(e,o),16&o&&transition_in(r,1)):(r=create_if_block$n(e),r.c(),transition_in(r,1),r.m(t.parentNode,t)):r&&(group_outros(),transition_out(r,1,1,(()=>{r=null})),check_outros())},i(e){o||(transition_in(r),o=!0)},o(e){transition_out(r),o=!1},d(e){r&&r.d(e),e&&detach(t)}}}function instance$U(e,t,o){let r,n,i,{$$slots:a={},$$scope:s}=t,{class:l}=t,{name:c}=t,{selected:u}=t,{tabs:p=[]}=t,{layout:d}=t;const h=createEventDispatcher(),m=e=>{const t=i.querySelectorAll('[role="tab"] button')[e];t&&t.focus()},g=(e,t)=>{e.preventDefault(),e.stopPropagation(),h("select",t)},f=({key:e},t)=>{if(!/arrow/i.test(e))return;const o=p.findIndex((e=>e.id===t));return/right|down/i.test(e)?m(o<p.length-1?o+1:0):/left|up/i.test(e)?m(o>0?o-1:p.length-1):void 0};return e.$$set=e=>{"class"in e&&o(0,l=e.class),"name"in e&&o(7,c=e.name),"selected"in e&&o(8,u=e.selected),"tabs"in e&&o(9,p=e.tabs),"layout"in e&&o(1,d=e.layout),"$$scope"in e&&o(10,s=e.$$scope)},e.$$.update=()=>{896&e.$$.dirty&&o(2,r=p.map((e=>{const t=e.id===u;return{...e,tabId:`tab-${c}-${e.id}`,href:`#panel-${c}-${e.id}`,selected:t}}))),4&e.$$.dirty&&o(4,n=r.length>1)},[l,d,r,i,n,g,f,c,u,p,s,a,(e,t)=>f(t,e.id),(e,t)=>g(t,e.id),function(e){binding_callbacks[e?"unshift":"push"]((()=>{i=e,o(3,i)}))}]}class TabList extends SvelteComponent{constructor(e){super(),init(this,e,instance$U,create_fragment$T,safe_not_equal,{class:0,name:7,selected:8,tabs:9,layout:1})}}var styleable=(e,t)=>{if(!t)return;const o=t=>{setElementStyles(e,t)};return o(t),{update:o}};const get_default_slot_changes_1=e=>({panel:16&e}),get_default_slot_context_1=e=>({panel:e[4][0].id,panelIsActive:!0});function get_each_context$7(e,t,o){const r=e.slice();return r[14]=t[o].id,r[15]=t[o].shouldDraw,r[16]=t[o].panelId,r[17]=t[o].tabindex,r[18]=t[o].labelledBy,r[19]=t[o].isActive,r[20]=t[o].hidden,r[3]=t[o].visible,r}const get_default_slot_changes=e=>({panel:16&e,panelIsActive:16&e}),get_default_slot_context=e=>({panel:e[14],panelIsActive:e[19]});function create_else_block$b(e){let t,o,r,n,i,a,s;const l=e[11].default,c=create_slot(l,e,e[10],get_default_slot_context_1);return{c(){t=element("div"),o=element("div"),c&&c.c(),attr(o,"class",r=arrayJoin([e[1]])),attr(t,"class",e[0])},m(r,l){insert(r,t,l),append(t,o),c&&c.m(o,null),i=!0,a||(s=[action_destroyer(n=styleable.call(null,t,e[2])),listen(t,"measure",e[13]),action_destroyer(measurable.call(null,t))],a=!0)},p(e,a){c&&c.p&&(!i||1040&a)&&update_slot_base(c,l,e,e[10],i?get_slot_changes(l,e[10],a,get_default_slot_changes_1):get_all_dirty_from_scope(e[10]),get_default_slot_context_1),(!i||2&a&&r!==(r=arrayJoin([e[1]])))&&attr(o,"class",r),(!i||1&a)&&attr(t,"class",e[0]),n&&is_function(n.update)&&4&a&&n.update.call(null,e[2])},i(e){i||(transition_in(c,e),i=!0)},o(e){transition_out(c,e),i=!1},d(e){e&&detach(t),c&&c.d(e),a=!1,run_all(s)}}}function create_if_block$m(e){let t,o,r,n,i,a,s=[],l=new Map,c=e[4];const u=e=>e[14];for(let t=0;t<c.length;t+=1){let o=get_each_context$7(e,c,t),r=u(o);l.set(r,s[t]=create_each_block$7(r,o))}return{c(){t=element("div");for(let e=0;e<s.length;e+=1)s[e].c();attr(t,"class",o=arrayJoin(["PinturaTabPanels",e[0]]))},m(o,l){insert(o,t,l);for(let e=0;e<s.length;e+=1)s[e].m(t,null);n=!0,i||(a=[action_destroyer(r=styleable.call(null,t,e[2])),listen(t,"measure",e[12]),action_destroyer(measurable.call(null,t,{observePosition:!0}))],i=!0)},p(e,i){1042&i&&(c=e[4],group_outros(),s=update_keyed_each(s,i,u,1,e,c,l,t,outro_and_destroy_block,create_each_block$7,null,get_each_context$7),check_outros()),(!n||1&i&&o!==(o=arrayJoin(["PinturaTabPanels",e[0]])))&&attr(t,"class",o),r&&is_function(r.update)&&4&i&&r.update.call(null,e[2])},i(e){if(!n){for(let e=0;e<c.length;e+=1)transition_in(s[e]);n=!0}},o(e){for(let e=0;e<s.length;e+=1)transition_out(s[e]);n=!1},d(e){e&&detach(t);for(let e=0;e<s.length;e+=1)s[e].d();i=!1,run_all(a)}}}function create_if_block_1$g(e){let t;const o=e[11].default,r=create_slot(o,e,e[10],get_default_slot_context);return{c(){r&&r.c()},m(e,o){r&&r.m(e,o),t=!0},p(e,n){r&&r.p&&(!t||1040&n)&&update_slot_base(r,o,e,e[10],t?get_slot_changes(o,e[10],n,get_default_slot_changes):get_all_dirty_from_scope(e[10]),get_default_slot_context)},i(e){t||(transition_in(r,e),t=!0)},o(e){transition_out(r,e),t=!1},d(e){r&&r.d(e)}}}function create_each_block$7(e,t){let o,r,n,i,a,s,l,c,u,p=t[15]&&create_if_block_1$g(t);return{key:e,first:null,c(){o=element("div"),p&&p.c(),r=space(),attr(o,"class",n=arrayJoin(["PinturaTabPanel",t[1]])),o.hidden=i=t[20],attr(o,"id",a=t[16]),attr(o,"tabindex",s=t[17]),attr(o,"aria-labelledby",l=t[18]),attr(o,"data-inert",c=!t[3]),this.first=o},m(e,t){insert(e,o,t),p&&p.m(o,null),append(o,r),u=!0},p(e,d){(t=e)[15]?p?(p.p(t,d),16&d&&transition_in(p,1)):(p=create_if_block_1$g(t),p.c(),transition_in(p,1),p.m(o,r)):p&&(group_outros(),transition_out(p,1,1,(()=>{p=null})),check_outros()),(!u||2&d&&n!==(n=arrayJoin(["PinturaTabPanel",t[1]])))&&attr(o,"class",n),(!u||16&d&&i!==(i=t[20]))&&(o.hidden=i),(!u||16&d&&a!==(a=t[16]))&&attr(o,"id",a),(!u||16&d&&s!==(s=t[17]))&&attr(o,"tabindex",s),(!u||16&d&&l!==(l=t[18]))&&attr(o,"aria-labelledby",l),(!u||16&d&&c!==(c=!t[3]))&&attr(o,"data-inert",c)},i(e){u||(transition_in(p),u=!0)},o(e){transition_out(p),u=!1},d(e){e&&detach(o),p&&p.d()}}}function create_fragment$S(e){let t,o,r,n;const i=[create_if_block$m,create_else_block$b],a=[];function s(e,t){return e[5]?0:1}return t=s(e),o=a[t]=i[t](e),{c(){o.c(),r=empty()},m(e,o){a[t].m(e,o),insert(e,r,o),n=!0},p(e,[n]){let l=t;t=s(e),t===l?a[t].p(e,n):(group_outros(),transition_out(a[l],1,1,(()=>{a[l]=null})),check_outros(),o=a[t],o?o.p(e,n):(o=a[t]=i[t](e),o.c()),transition_in(o,1),o.m(r.parentNode,r))},i(e){n||(transition_in(o),n=!0)},o(e){transition_out(o),n=!1},d(e){a[t].d(e),e&&detach(r)}}}function instance$T(e,t,o){let r,n,{$$slots:i={},$$scope:a}=t,{class:s}=t,{name:l}=t,{selected:c}=t,{panelClass:u}=t,{panels:p=[]}=t,{visible:d}=t,{style:h}=t;const m={};return e.$$set=e=>{"class"in e&&o(0,s=e.class),"name"in e&&o(6,l=e.name),"selected"in e&&o(7,c=e.selected),"panelClass"in e&&o(1,u=e.panelClass),"panels"in e&&o(8,p=e.panels),"visible"in e&&o(3,d=e.visible),"style"in e&&o(2,h=e.style),"$$scope"in e&&o(10,a=e.$$scope)},e.$$.update=()=>{968&e.$$.dirty&&o(4,r=p.map((e=>{const t=e===c;t&&o(9,m[e]=!0,m);const r=d?-1!==d.indexOf(e):t;return{id:e,panelId:`panel-${l}-${e}`,labelledBy:`tab-${l}-${e}`,isActive:t,hidden:!t,visible:r,tabindex:t?0:-1,shouldDraw:t||m[e]}}))),16&e.$$.dirty&&o(5,n=r.length>1)},[s,u,h,d,r,n,l,c,p,m,a,i,function(t){bubble.call(this,e,t)},function(t){bubble.call(this,e,t)}]}class TabPanels extends SvelteComponent{constructor(e){super(),init(this,e,instance$T,create_fragment$S,safe_not_equal,{class:0,name:6,selected:7,panelClass:1,panels:8,visible:3,style:2})}}var getComponentExportedProps=e=>{const t=Object.getOwnPropertyDescriptors(e.prototype);return Object.keys(t).filter((e=>!!t[e].get))};function create_if_block$l(e){let t,o,r,n;const i=[e[5],{locale:e[1]}];function a(t){e[22](t)}var s=e[10];function l(e){let t={};for(let e=0;e<i.length;e+=1)t=assign(t,i[e]);return void 0!==e[3]&&(t.name=e[3]),{props:t}}return s&&(t=construct_svelte_component(s,l(e)),binding_callbacks.push((()=>bind(t,"name",a))),e[23](t),t.$on("measure",e[11])),{c(){t&&create_component(t.$$.fragment),r=empty()},m(e,o){t&&mount_component(t,e,o),insert(e,r,o),n=!0},p(e,n){const c=34&n[0]?get_spread_update(i,[32&n[0]&&get_spread_object(e[5]),2&n[0]&&{locale:e[1]}]):{};if(!o&&8&n[0]&&(o=!0,c.name=e[3],add_flush_callback((()=>o=!1))),s!==(s=e[10])){if(t){group_outros();const e=t;transition_out(e.$$.fragment,1,0,(()=>{destroy_component(e,1)})),check_outros()}s?(t=construct_svelte_component(s,l(e)),binding_callbacks.push((()=>bind(t,"name",a))),e[23](t),t.$on("measure",e[11]),create_component(t.$$.fragment),transition_in(t.$$.fragment,1),mount_component(t,r.parentNode,r)):t=null}else s&&t.$set(c)},i(e){n||(t&&transition_in(t.$$.fragment,e),n=!0)},o(e){t&&transition_out(t.$$.fragment,e),n=!1},d(o){e[23](null),o&&detach(r),t&&destroy_component(t,o)}}}function create_fragment$R(e){let t,o,r,n=e[6]&&create_if_block$l(e);return{c(){t=element("div"),n&&n.c(),attr(t,"data-util",e[3]),attr(t,"class",o=arrayJoin(["PinturaUtilPanel",e[2]])),set_style(t,"opacity",e[7])},m(o,i){insert(o,t,i),n&&n.m(t,null),e[24](t),r=!0},p(e,i){e[6]?n?(n.p(e,i),64&i[0]&&transition_in(n,1)):(n=create_if_block$l(e),n.c(),transition_in(n,1),n.m(t,null)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),(!r||8&i[0])&&attr(t,"data-util",e[3]),(!r||4&i[0]&&o!==(o=arrayJoin(["PinturaUtilPanel",e[2]])))&&attr(t,"class",o),128&i[0]&&set_style(t,"opacity",e[7])},i(e){r||(transition_in(n),r=!0)},o(e){transition_out(n),r=!1},d(o){o&&detach(t),n&&n.d(),e[24](null)}}}function instance$S(e,t,o){let r,n,i,a,s;const l=createEventDispatcher();let{isActive:c=!0}=t,{stores:u}=t,{view:p}=t,{props:d}=t,{component:h}=t,{locale:m}=t,{class:g}=t;const f=getContext("isAnimated");let $;component_subscribe(e,f,(e=>o(21,s=e)));const b=spring(0),y=derived(b,(e=>clamp(e,0,1)));component_subscribe(e,y,(e=>o(20,a=e)));let _=!c;const x=writable(c),v=derived(x,(async(e,t)=>{if(!e)return t(e);await tick$1(),t(e)}),!1),S=derived(y,(e=>e)),C=derived(y,(e=>e>0)),w={isActive:v,isActiveFraction:S,isVisible:C},T=p,k=getComponentExportedProps(T),R=Object.keys(d||{}).reduce(((e,t)=>k.includes(t)?(e[t]=d[t],e):e),{}),P=Object.keys(w).reduce(((e,t)=>k.includes(t)?(e[t]=w[t],e):e),{});let I,E;const M=e=>{o(17,$={...e.detail}),F&&c&&l("measure",{...$})};setContext("measurable",measurable);const A=getAllContexts();let F=!1;return onMount((()=>{if(o(19,F=!0),i)return;o(0,h=new T({target:E,props:{...n,locale:m},context:A})),o(3,I=h.name);const e=h.$on("measure",M);return()=>{e(),h.$destroy()}})),e.$$set=e=>{"isActive"in e&&o(12,c=e.isActive),"stores"in e&&o(13,u=e.stores),"view"in e&&o(14,p=e.view),"props"in e&&o(15,d=e.props),"component"in e&&o(0,h=e.component),"locale"in e&&o(1,m=e.locale),"class"in e&&o(2,g=e.class)},e.$$.update=()=>{135169&e.$$.dirty[0]&&$&&c&&h&&l("measure",$),2101248&e.$$.dirty[0]&&b.set(c?1:0,{hard:!1===s}),1310720&e.$$.dirty[0]&&(a<=0&&!_?o(18,_=!0):a>0&&_&&o(18,_=!1)),786432&e.$$.dirty[0]&&F&&l(_?"hide":"show"),1048576&e.$$.dirty[0]&&l("fade",a),1048576&e.$$.dirty[0]&&o(7,r=a),4096&e.$$.dirty[0]&&x.set(c),8192&e.$$.dirty[0]&&o(5,n={...R,...P,stores:u})},o(6,i=!k.includes("external")),[h,m,g,I,E,n,i,r,f,y,T,M,c,u,p,d,b,$,_,F,a,s,function(e){I=e,o(3,I)},function(e){binding_callbacks[e?"unshift":"push"]((()=>{h=e,o(0,h)}))},function(e){binding_callbacks[e?"unshift":"push"]((()=>{E=e,o(4,E)}))}]}class UtilPanel extends SvelteComponent{constructor(e){super(),init(this,e,instance$S,create_fragment$R,safe_not_equal,{isActive:12,stores:13,view:14,props:15,component:0,locale:1,class:2,opacity:16},null,[-1,-1])}get opacity(){return this.$$.ctx[16]}}function create_fragment$Q(e){let t,o,r,n,i,a;const s=e[5].default,l=create_slot(s,e,e[4],null);return{c(){t=svg_element("svg"),l&&l.c(),attr(t,"class",e[3]),attr(t,"width",e[0]),attr(t,"height",e[1]),attr(t,"viewBox",o="0 0 "+e[0]+"\n    "+e[1]),attr(t,"xmlns","http://www.w3.org/2000/svg"),attr(t,"aria-hidden","true"),attr(t,"focusable","false"),attr(t,"stroke-linecap","round"),attr(t,"stroke-linejoin","round")},m(o,s){insert(o,t,s),l&&l.m(t,null),n=!0,i||(a=action_destroyer(r=styleable.call(null,t,e[2])),i=!0)},p(e,[i]){l&&l.p&&(!n||16&i)&&update_slot_base(l,s,e,e[4],n?get_slot_changes(s,e[4],i,null):get_all_dirty_from_scope(e[4]),null),(!n||8&i)&&attr(t,"class",e[3]),(!n||1&i)&&attr(t,"width",e[0]),(!n||2&i)&&attr(t,"height",e[1]),(!n||3&i&&o!==(o="0 0 "+e[0]+"\n    "+e[1]))&&attr(t,"viewBox",o),r&&is_function(r.update)&&4&i&&r.update.call(null,e[2])},i(e){n||(transition_in(l,e),n=!0)},o(e){transition_out(l,e),n=!1},d(e){e&&detach(t),l&&l.d(e),i=!1,a()}}}function instance$R(e,t,o){let{$$slots:r={},$$scope:n}=t,{width:i=24}=t,{height:a=24}=t,{style:s}=t,{class:l}=t;return e.$$set=e=>{"width"in e&&o(0,i=e.width),"height"in e&&o(1,a=e.height),"style"in e&&o(2,s=e.style),"class"in e&&o(3,l=e.class),"$$scope"in e&&o(4,n=e.$$scope)},[i,a,s,l,n,r]}class Icon extends SvelteComponent{constructor(e){super(),init(this,e,instance$R,create_fragment$Q,safe_not_equal,{width:0,height:1,style:2,class:3})}}var _isEventTarget=(e,t)=>t===e.target||t.contains(e.target),toKeyboardShortcut=e=>e.map((e=>"CMD"===e?isMac()?"⌘":"Ctrl":e)).join("+"),toTitle=(e,t,o)=>{const r=isString(t)?t:e;return o?`${r} (${toKeyboardShortcut(o)})`:r};const{document:document_1$1}=globals;function create_fragment$P(e){let t,o,r,n;return{c(){t=space(),o=element("button"),attr(o,"class","PinturaImageButton"),attr(o,"type","button"),attr(o,"title",e[1]),o.disabled=e[2]},m(i,a){insert(i,t,a),insert(i,o,a),o.innerHTML=e[0],e[11](o),r||(n=[listen(document_1$1.body,"load",e[5],!0),listen(document_1$1.body,"error",e[6],!0),listen(o,"pointerdown",e[4])],r=!0)},p(e,[t]){1&t&&(o.innerHTML=e[0]),2&t&&attr(o,"title",e[1]),4&t&&(o.disabled=e[2])},i:noop,o:noop,d(i){i&&detach(t),i&&detach(o),e[11](null),r=!1,run_all(n)}}}function instance$Q(e,t,o){let r,{html:n}=t,{title:i}=t,{onclick:a}=t,{disabled:s=!1}=t,{ongrab:l=noop$1}=t,{ondrag:c=noop$1}=t,{ondrop:u=noop$1}=t;const p=e=>vectorDistanceSquared(d,vectorCreate(e.pageX,e.pageY))<256;let d;const h=e=>{document.documentElement.removeEventListener("pointermove",m),document.documentElement.removeEventListener("pointerup",h);const t=vectorCreate(e.pageX,e.pageY);if(vectorDistanceSquared(d,t)<32)return a(e);p(e)||u(e)},m=e=>{p(e)||c(e)},g=e=>r&&r.contains(e)&&"IMG"===e.nodeName;return e.$$set=e=>{"html"in e&&o(0,n=e.html),"title"in e&&o(1,i=e.title),"onclick"in e&&o(7,a=e.onclick),"disabled"in e&&o(2,s=e.disabled),"ongrab"in e&&o(8,l=e.ongrab),"ondrag"in e&&o(9,c=e.ondrag),"ondrop"in e&&o(10,u=e.ondrop)},e.$$.update=()=>{8&e.$$.dirty&&r&&r.querySelector("img")&&o(3,r.dataset.loader=!0,r)},[n,i,s,r,e=>{d=vectorCreate(e.pageX,e.pageY),l(e),document.documentElement.addEventListener("pointermove",m),document.documentElement.addEventListener("pointerup",h)},({target:e})=>{g(e)&&o(3,r.dataset.load=!0,r)},({target:e})=>{g(e)&&o(3,r.dataset.error=!0,r)},a,l,c,u,function(e){binding_callbacks[e?"unshift":"push"]((()=>{r=e,o(3,r)}))}]}class ImageButton extends SvelteComponent{constructor(e){super(),init(this,e,instance$Q,create_fragment$P,safe_not_equal,{html:0,title:1,onclick:7,disabled:2,ongrab:8,ondrag:9,ondrop:10})}}function get_each_context$6(e,t,o){const r=e.slice();return r[13]=t[o],r}function create_each_block$6(e,t){let o,r,n,i,a,s,l;function c(){return t[9](t[13])}function u(...e){return t[10](t[13],...e)}function p(...e){return t[11](t[13],...e)}function d(...e){return t[12](t[13],...e)}return r=new ImageButton({props:{onclick:c,ongrab:u,ondrag:p,ondrop:d,disabled:t[1]||t[13].disabled,title:t[13].title,html:t[13].thumb}}),{key:e,first:null,c(){o=element("li"),create_component(r.$$.fragment),n=space(),set_style(o,"opacity",t[6]),this.first=o},m(e,c){insert(e,o,c),mount_component(r,o,null),append(o,n),a=!0,s||(l=action_destroyer(i=t[8].call(null,o,t[13])),s=!0)},p(e,n){t=e;const a={};5&n&&(a.onclick=c),9&n&&(a.ongrab=u),17&n&&(a.ondrag=p),33&n&&(a.ondrop=d),3&n&&(a.disabled=t[1]||t[13].disabled),1&n&&(a.title=t[13].title),1&n&&(a.html=t[13].thumb),r.$set(a),i&&is_function(i.update)&&1&n&&i.update.call(null,t[13]),64&n&&set_style(o,"opacity",t[6])},i(e){a||(transition_in(r.$$.fragment,e),a=!0)},o(e){transition_out(r.$$.fragment,e),a=!1},d(e){e&&detach(o),destroy_component(r),s=!1,l()}}}function create_fragment$O(e){let t,o,r=[],n=new Map,i=e[0];const a=e=>e[13].id;for(let t=0;t<i.length;t+=1){let o=get_each_context$6(e,i,t),s=a(o);n.set(s,r[t]=create_each_block$6(s,o))}return{c(){t=element("ul");for(let e=0;e<r.length;e+=1)r[e].c();attr(t,"class","PinturaImageButtonList")},m(e,n){insert(e,t,n);for(let e=0;e<r.length;e+=1)r[e].m(t,null);o=!0},p(e,[o]){127&o&&(i=e[0],group_outros(),r=update_keyed_each(r,o,a,1,e,i,n,t,outro_and_destroy_block,create_each_block$6,null,get_each_context$6),check_outros())},i(e){if(!o){for(let e=0;e<i.length;e+=1)transition_in(r[e]);o=!0}},o(e){for(let e=0;e<r.length;e+=1)transition_out(r[e]);o=!1},d(e){e&&detach(t);for(let e=0;e<r.length;e+=1)r[e].d()}}}function instance$P(e,t,o){let r,{items:n}=t,{disabled:i}=t,{onclickitem:a}=t,{ongrabitem:s}=t,{ondragitem:l}=t,{ondropitem:c}=t;const u=spring(0,{stiffness:.25,damping:.9});component_subscribe(e,u,(e=>o(6,r=e)));onMount((()=>u.set(1)));return e.$$set=e=>{"items"in e&&o(0,n=e.items),"disabled"in e&&o(1,i=e.disabled),"onclickitem"in e&&o(2,a=e.onclickitem),"ongrabitem"in e&&o(3,s=e.ongrabitem),"ondragitem"in e&&o(4,l=e.ondragitem),"ondropitem"in e&&o(5,c=e.ondropitem)},[n,i,a,s,l,c,r,u,(e,t)=>t.mount&&t.mount(e.firstChild,t),e=>a(e.id),(e,t)=>s&&s(e.id,t),(e,t)=>l&&l(e.id,t),(e,t)=>c&&c(e.id,t)]}class ImageButtonList extends SvelteComponent{constructor(e){super(),init(this,e,instance$P,create_fragment$O,safe_not_equal,{items:0,disabled:1,onclickitem:2,ongrabitem:3,ondragitem:4,ondropitem:5})}}var getDevicePixelRatio=()=>isBrowser()&&window.devicePixelRatio||1;let fn=null;var snapToPixel=e=>(null===fn&&(fn=1===getDevicePixelRatio()?Math.round:e=>e),fn(e)),focus=(e,t={})=>{if(e){if(t.preventScroll&&isSafari()){const t=document.body.scrollTop;return e.focus(),void(document.body.scrollTop=t)}e.focus(t)}},isTextarea=e=>/textarea/i.test(e.nodeName),isTextInput=e=>/date|email|number|search|text|url/.test(e.type),isTextField=e=>isTextarea(e)||isTextInput(e)||e.isContentEditable;const get_details_slot_changes=e=>({}),get_details_slot_context=e=>({}),get_label_slot_changes=e=>({}),get_label_slot_context=e=>({});function create_else_block$a(e){let t,o;const r=[e[7]];let n={$$slots:{default:[create_default_slot$h]},$$scope:{ctx:e}};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new Button({props:n}),e[53](t),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=128&o[0]?get_spread_update(r,[get_spread_object(e[7])]):{};67108864&o[1]&&(n.$$scope={dirty:o,ctx:e}),t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(o){e[53](null),destroy_component(t,o)}}}function create_if_block_2$b(e){let t,o;const r=[e[7]];let n={};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new Button({props:n}),e[52](t),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=128&o[0]?get_spread_update(r,[get_spread_object(e[7])]):{};t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(o){e[52](null),destroy_component(t,o)}}}function create_default_slot$h(e){let t;const o=e[51].label,r=create_slot(o,e,e[57],get_label_slot_context);return{c(){r&&r.c()},m(e,o){r&&r.m(e,o),t=!0},p(e,n){r&&r.p&&(!t||67108864&n[1])&&update_slot_base(r,o,e,e[57],t?get_slot_changes(o,e[57],n,get_label_slot_changes):get_all_dirty_from_scope(e[57]),get_label_slot_context)},i(e){t||(transition_in(r,e),t=!0)},o(e){transition_out(r,e),t=!1},d(e){r&&r.d(e)}}}function create_if_block_1$f(e){let t,o,r,n,i,a,s;const l=e[51].details,c=create_slot(l,e,e[57],get_details_slot_context);return{c(){t=element("div"),c&&c.c(),o=space(),r=element("span"),attr(r,"class","PinturaPanelTip"),attr(r,"data-top",e[10]),set_style(r,"opacity",e[14]),set_style(r,"transform",e[13]),set_style(r,"top",e[12]),set_style(r,"left",e[11]),attr(t,"class",n=arrayJoin(["PinturaPanel","pintura-editor-panel",e[2]])),attr(t,"tabindex","-1"),set_style(t,"opacity",e[18]),set_style(t,"pointer-events",e[17]),set_style(t,"transform",e[16]),set_style(t,"max-height",e[15])},m(n,l){insert(n,t,l),c&&c.m(t,null),append(t,o),append(t,r),e[54](t),i=!0,a||(s=[listen(t,"close",e[55]),listen(t,"keydown",e[25]),listen(t,"measure",e[56]),action_destroyer(measurable.call(null,t))],a=!0)},p(e,o){c&&c.p&&(!i||67108864&o[1])&&update_slot_base(c,l,e,e[57],i?get_slot_changes(l,e[57],o,get_details_slot_changes):get_all_dirty_from_scope(e[57]),get_details_slot_context),(!i||1024&o[0])&&attr(r,"data-top",e[10]),16384&o[0]&&set_style(r,"opacity",e[14]),8192&o[0]&&set_style(r,"transform",e[13]),4096&o[0]&&set_style(r,"top",e[12]),2048&o[0]&&set_style(r,"left",e[11]),(!i||4&o[0]&&n!==(n=arrayJoin(["PinturaPanel","pintura-editor-panel",e[2]])))&&attr(t,"class",n),262144&o[0]&&set_style(t,"opacity",e[18]),131072&o[0]&&set_style(t,"pointer-events",e[17]),65536&o[0]&&set_style(t,"transform",e[16]),32768&o[0]&&set_style(t,"max-height",e[15])},i(e){i||(transition_in(c,e),i=!0)},o(e){transition_out(c,e),i=!1},d(o){o&&detach(t),c&&c.d(o),e[54](null),a=!1,run_all(s)}}}function create_fragment$N(e){let t,o,r,n,i,a,s,l,c;const u=[create_if_block_2$b,create_else_block$a],p=[];function d(e,t){return e[1]?0:1}o=d(e),r=p[o]=u[o](e);let h=e[6]&&create_if_block_1$f(e),m=!1;return{c(){t=space(),r.c(),n=space(),h&&h.c(),i=space(),a=empty()},m(r,u){insert(r,t,u),p[o].m(r,u),insert(r,n,u),h&&h.m(r,u),insert(r,i,u),insert(r,a,u),s=!0,l||(c=[listen(document.body,"pointerdown",(function(){is_function(e[9])&&e[9].apply(this,arguments)})),listen(document.body,"pointerup",(function(){is_function(e[8])&&e[8].apply(this,arguments)}))],l=!0)},p(t,a){let s=o;o=d(e=t),o===s?p[o].p(e,a):(group_outros(),transition_out(p[s],1,1,(()=>{p[s]=null})),check_outros(),r=p[o],r?r.p(e,a):(r=p[o]=u[o](e),r.c()),transition_in(r,1),r.m(n.parentNode,n)),e[6]?h?(h.p(e,a),64&a[0]&&transition_in(h,1)):(h=create_if_block_1$f(e),h.c(),transition_in(h,1),h.m(i.parentNode,i)):h&&(group_outros(),transition_out(h,1,1,(()=>{h=null})),check_outros())},i(e){s||(transition_in(r),transition_in(h),transition_in(m),s=!0)},o(e){transition_out(r),transition_out(h),transition_out(m),s=!1},d(e){e&&detach(t),p[o].d(e),e&&detach(n),h&&h.d(e),e&&detach(i),e&&detach(a),l=!1,run_all(c)}}}let panelMargin=12;function instance$O(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,S,C,w,T,k,R,{$$slots:P={},$$scope:I}=t,{buttonClass:E}=t,{buttonLabel:M}=t,{buttonLabelClass:A}=t,{buttonHideLabel:F}=t,{buttonIcon:L}=t,{buttonTitle:D}=t,{panelClass:z}=t,{isActive:O=!1}=t,{onshow:B=({panel:e})=>focus(e,{preventScroll:!0})}=t,{onhide:N=noop$1}=t;const V=getContext("isAnimated");component_subscribe(e,V,(e=>o(50,R=e)));const W=getContext("rootPortal");component_subscribe(e,W,(e=>o(45,S=e)));const U=getContext("rootRect");let H,G,j;component_subscribe(e,U,(e=>o(48,T=e)));const q=()=>o(33,j=r&&r.getBoundingClientRect());let X=vectorCreateEmpty(),Y=spring(0);component_subscribe(e,Y,(e=>o(47,w=e)));let Z=vectorCreateEmpty();const K=writable({x:0,y:0});component_subscribe(e,K,(e=>o(46,C=e)));const J=spring(-5,{stiffness:.1,damping:.35,precision:.001});component_subscribe(e,J,(e=>o(49,k=e)));let Q=!0;const ee=e=>_isEventTarget(e,S)||G.isEventTarget(e);let te,oe,re=!1;const ne=e=>{isTextField(e.target)||(O||q(),o(38,oe=e),o(0,O=!O))},ie=e=>{/down/i.test(e.key)&&(o(0,O=!0),o(38,oe=e))};onDestroy((()=>{if(!S)return;if(!te)return;const e=te;tick$1().then((()=>{e.parentNode&&e.remove()}))}));return e.$$set=e=>{"buttonClass"in e&&o(26,E=e.buttonClass),"buttonLabel"in e&&o(1,M=e.buttonLabel),"buttonLabelClass"in e&&o(27,A=e.buttonLabelClass),"buttonHideLabel"in e&&o(28,F=e.buttonHideLabel),"buttonIcon"in e&&o(29,L=e.buttonIcon),"buttonTitle"in e&&o(30,D=e.buttonTitle),"panelClass"in e&&o(2,z=e.panelClass),"isActive"in e&&o(0,O=e.isActive),"onshow"in e&&o(31,B=e.onshow),"onhide"in e&&o(32,N=e.onhide),"$$scope"in e&&o(57,I=e.$$scope)},e.$$.update=()=>{if(16&e.$$.dirty[0]&&(r=G&&G.getElement()),1&e.$$.dirty[0]|64&e.$$.dirty[1]&&o(8,x=O?e=>{re&&(o(37,re=!1),ee(e)||o(0,O=!1))}:void 0),1&e.$$.dirty[0]|524288&e.$$.dirty[1]&&Y.set(O?1:0,{hard:!1===R}),1&e.$$.dirty[0]|524288&e.$$.dirty[1]&&J.set(O?0:-5,{hard:!1===R}),262144&e.$$.dirty[1]&&o(42,n=1-k/-5),1&e.$$.dirty[0]|131072&e.$$.dirty[1]&&T&&O&&q(),9&e.$$.dirty[0]|131076&e.$$.dirty[1]&&T&&H&&j&&O){o(36,Q=!0);let e=j.x-T.x+.5*j.width-.5*H.width,t=j.y-T.y+j.height;const r=panelMargin,n=panelMargin,i=T.width-panelMargin,a=T.height-panelMargin,s=e,l=t,c=s+H.width,u=l+H.height;if(s<r&&(o(35,Z.x=s-r,Z),e=r),c>i&&(o(35,Z.x=c-i,Z),e=i-H.width),u>a){o(34,X.y=-1,X);n<t-H.height-j.height?(o(35,Z.y=0,Z),t-=H.height+j.height):(o(35,Z.y=t-(u-a),Z),t-=u-a-panelMargin,o(36,Q=!1))}else o(34,X.y=1,X);set_store_value(K,C=vectorApply(vectorCreate(e,t),snapToPixel),C)}65536&e.$$.dirty[1]&&o(6,i=w>0),294920&e.$$.dirty[1]&&o(44,a=`translateX(${Math.round(C.x)+X.x*panelMargin}px) translateY(${Math.round(C.y)+X.y*panelMargin+X.y*k}px)`),131072&e.$$.dirty[1]&&o(43,s=`--panel-max-height:${T.height-2*panelMargin}px`),65536&e.$$.dirty[1]&&o(18,l=w),65536&e.$$.dirty[1]&&o(17,c=w<1?"none":"all"),8192&e.$$.dirty[1]&&o(16,u=a),4096&e.$$.dirty[1]&&o(15,p=s),2048&e.$$.dirty[1]&&o(40,d=.5+.5*n),2048&e.$$.dirty[1]&&o(41,h=n),8&e.$$.dirty[0]|32768&e.$$.dirty[1]&&o(39,m=H&&C),1312&e.$$.dirty[1]&&o(14,g=m&&Q?h:0),768&e.$$.dirty[1]&&o(13,f=m?`scaleX(${d})rotate(45deg)`:"none"),8&e.$$.dirty[0]|280&e.$$.dirty[1]&&o(12,$=m?`${X.y<0?Z.y+H.height:0}px`:"0"),8&e.$$.dirty[0]|272&e.$$.dirty[1]&&o(11,b=m?`${Z.x+.5*H.width}px`:"0"),8&e.$$.dirty[1]&&o(10,y=X.y>=0),1&e.$$.dirty[0]&&o(9,_=O?e=>{ee(e)||o(37,re=!0)}:void 0),96&e.$$.dirty[0]|16384&e.$$.dirty[1]&&i&&S&&te&&te.parentNode!==S&&S.append(te),1&e.$$.dirty[0]&&(O||o(38,oe=void 0)),97&e.$$.dirty[0]|129&e.$$.dirty[1]&&O&&i&&te&&B({e:oe,panel:te}),65&e.$$.dirty[0]|2&e.$$.dirty[1]&&i&&!O&&N(),2080374786&e.$$.dirty[0]&&o(7,v={label:M,icon:L,class:arrayJoin(["PinturaPanelButton",E]),onkeydown:ie,onclick:ne,hideLabel:F,labelClass:A,title:D})},[O,M,z,H,G,te,i,v,x,_,y,b,$,f,g,p,u,c,l,V,W,U,Y,K,J,e=>{/esc/i.test(e.key)&&(o(0,O=!1),r.focus())},E,A,F,L,D,B,N,j,X,Z,Q,re,oe,m,d,h,n,s,a,S,C,w,T,k,R,P,function(e){binding_callbacks[e?"unshift":"push"]((()=>{G=e,o(4,G)}))},function(e){binding_callbacks[e?"unshift":"push"]((()=>{G=e,o(4,G)}))},function(e){binding_callbacks[e?"unshift":"push"]((()=>{te=e,o(5,te)}))},e=>{e.stopPropagation(),o(0,O=!1)},e=>o(3,H=sizeCreateFromAny(e.detail)),I]}class Panel extends SvelteComponent{constructor(e){super(),init(this,e,instance$O,create_fragment$N,safe_not_equal,{buttonClass:26,buttonLabel:1,buttonLabelClass:27,buttonHideLabel:28,buttonIcon:29,buttonTitle:30,panelClass:2,isActive:0,onshow:31,onhide:32},null,[-1,-1,-1])}}var ArrowKeys={Up:38,Down:40,Left:37,Right:39};function create_fragment$M(e){let t,o,r,n,i,a,s,l;const c=e[15].default,u=create_slot(c,e,e[14],null);return{c(){t=element("li"),o=element("input"),r=space(),n=element("label"),u&&u.c(),attr(o,"type","radio"),attr(o,"class","implicit"),attr(o,"id",e[7]),attr(o,"name",e[0]),o.value=e[3],o.disabled=e[6],o.hidden=e[5],o.checked=e[4],attr(n,"for",e[7]),attr(n,"title",e[2]),attr(t,"class",i=arrayJoin(["PinturaRadioGroupOption",e[1]])),attr(t,"data-hidden",e[5]),attr(t,"data-disabled",e[6]),attr(t,"data-selected",e[4])},m(i,c){insert(i,t,c),append(t,o),append(t,r),append(t,n),u&&u.m(n,null),a=!0,s||(l=[listen(o,"change",stop_propagation(e[16])),listen(o,"keydown",e[9]),listen(o,"click",e[10])],s=!0)},p(e,[r]){(!a||128&r)&&attr(o,"id",e[7]),(!a||1&r)&&attr(o,"name",e[0]),(!a||8&r)&&(o.value=e[3]),(!a||64&r)&&(o.disabled=e[6]),(!a||32&r)&&(o.hidden=e[5]),(!a||16&r)&&(o.checked=e[4]),u&&u.p&&(!a||16384&r)&&update_slot_base(u,c,e,e[14],a?get_slot_changes(c,e[14],r,null):get_all_dirty_from_scope(e[14]),null),(!a||128&r)&&attr(n,"for",e[7]),(!a||4&r)&&attr(n,"title",e[2]),(!a||2&r&&i!==(i=arrayJoin(["PinturaRadioGroupOption",e[1]])))&&attr(t,"class",i),(!a||32&r)&&attr(t,"data-hidden",e[5]),(!a||64&r)&&attr(t,"data-disabled",e[6]),(!a||16&r)&&attr(t,"data-selected",e[4])},i(e){a||(transition_in(u,e),a=!0)},o(e){transition_out(u,e),a=!1},d(e){e&&detach(t),u&&u.d(e),s=!1,run_all(l)}}}function instance$N(e,t,o){let r,n,{$$slots:i={},$$scope:a}=t,{name:s}=t,{class:l}=t,{label:c}=t,{id:u}=t,{value:p}=t,{checked:d}=t,{onkeydown:h}=t,{onclick:m}=t,{hidden:g=!1}=t,{disabled:f=!1}=t;const $=Object.values(ArrowKeys),b=getContext("keysPressed");component_subscribe(e,b,(e=>o(17,n=e)));return e.$$set=e=>{"name"in e&&o(0,s=e.name),"class"in e&&o(1,l=e.class),"label"in e&&o(2,c=e.label),"id"in e&&o(11,u=e.id),"value"in e&&o(3,p=e.value),"checked"in e&&o(4,d=e.checked),"onkeydown"in e&&o(12,h=e.onkeydown),"onclick"in e&&o(13,m=e.onclick),"hidden"in e&&o(5,g=e.hidden),"disabled"in e&&o(6,f=e.disabled),"$$scope"in e&&o(14,a=e.$$scope)},e.$$.update=()=>{2049&e.$$.dirty&&o(7,r=`${s}-${u}`)},[s,l,c,p,d,g,f,r,b,e=>{h(e)},e=>{n.some((e=>$.includes(e)))||m(e)},u,h,m,a,i,function(t){bubble.call(this,e,t)}]}class RadioItem extends SvelteComponent{constructor(e){super(),init(this,e,instance$N,create_fragment$M,safe_not_equal,{name:0,class:1,label:2,id:11,value:3,checked:4,onkeydown:12,onclick:13,hidden:5,disabled:6})}}var flattenOptions=(e=[])=>e.reduce(((e,t)=>(isArray(t)?isArray(t[1]):!!t.options)?e.concat(isArray(t)?t[1]:t.options):(e.push(t),e)),[]);const mapOption=(e,t,o)=>{let r;return isArray(e)?r={id:t,value:e[0],label:e[1],...e[2]||{}}:(r=e,r.id=null!=r.id?r.id:t),o?o(r):r};var mapOptions=(e=[],t)=>{let o=0;return e.map((e=>(o++,isArray(e)?isArray(e[1])?{id:o,label:e[0],options:e[1].map((e=>mapOption(e,++o,t)))}:mapOption(e,o,t):e.options?{id:e.id||o,label:e.label,options:e.options.map((e=>mapOption(e,++o,t)))}:mapOption(e,o,t))))},opop=(e,...t)=>e&&e(...t),localize=(e,t,o)=>isFunction(e)?e(t,o):e;const localizeOptions=(e,t)=>e.map((([e,o,r])=>{if(isArray(o))return[localize(e,t),localizeOptions(o,t)];{const n=[e,localize(o,t)];if(r){let e={...r};r.icon&&(e.icon=localize(r.icon,t)),n.push(e)}return n}}));var localizeOptions$1=(e,t)=>localizeOptions(e,t),isConfirmKey=e=>/enter| /i.test(e),isDeepEqual=(e,t)=>Array.isArray(e)&&Array.isArray(t)?arrayEqual(e,t):e===t;function get_each_context$5(e,t,o){const r=e.slice();return r[27]=t[o],r}const get_option_slot_changes_1=e=>({option:1024&e[0]}),get_option_slot_context_1=e=>({option:e[27]});function get_each_context_1(e,t,o){const r=e.slice();return r[27]=t[o],r}const get_option_slot_changes=e=>({option:1024&e[0]}),get_option_slot_context=e=>({option:e[27]}),get_group_slot_changes=e=>({option:1024&e[0]}),get_group_slot_context=e=>({option:e[27]});function create_if_block_1$e(e){let t,o,r,n,i,a=[],s=new Map,l=e[1]&&create_if_block_7$2(e),c=e[10];const u=e=>e[27].id;for(let t=0;t<c.length;t+=1){let o=get_each_context$5(e,c,t),r=u(o);s.set(r,a[t]=create_each_block$5(r,o))}return{c(){t=element("fieldset"),l&&l.c(),o=space(),r=element("ul");for(let e=0;e<a.length;e+=1)a[e].c();attr(r,"class","PinturaRadioGroupOptions"),attr(t,"class",n=arrayJoin(["PinturaRadioGroup",e[3]])),attr(t,"data-layout",e[5]),attr(t,"title",e[7])},m(e,n){insert(e,t,n),l&&l.m(t,null),append(t,o),append(t,r);for(let e=0;e<a.length;e+=1)a[e].m(r,null);i=!0},p(e,p){e[1]?l?l.p(e,p):(l=create_if_block_7$2(e),l.c(),l.m(t,o)):l&&(l.d(1),l=null),8419153&p[0]&&(c=e[10],group_outros(),a=update_keyed_each(a,p,u,1,e,c,s,r,outro_and_destroy_block,create_each_block$5,null,get_each_context$5),check_outros()),(!i||8&p[0]&&n!==(n=arrayJoin(["PinturaRadioGroup",e[3]])))&&attr(t,"class",n),(!i||32&p[0])&&attr(t,"data-layout",e[5]),(!i||128&p[0])&&attr(t,"title",e[7])},i(e){if(!i){for(let e=0;e<c.length;e+=1)transition_in(a[e]);i=!0}},o(e){for(let e=0;e<a.length;e+=1)transition_out(a[e]);i=!1},d(e){e&&detach(t),l&&l.d();for(let e=0;e<a.length;e+=1)a[e].d()}}}function create_if_block_7$2(e){let t,o,r;return{c(){t=element("legend"),o=text(e[1]),attr(t,"class",r=e[2]&&"implicit")},m(e,r){insert(e,t,r),append(t,o)},p(e,n){2&n[0]&&set_data(o,e[1]),4&n[0]&&r!==(r=e[2]&&"implicit")&&attr(t,"class",r)},d(e){e&&detach(t)}}}function create_else_block$9(e){let t,o;return t=new RadioItem({props:{name:e[4],label:e[27].label,id:e[27].id,value:e[27].value,disabled:e[27].disabled,hidden:e[27].hidden,class:e[8],checked:e[12](e[27])===e[0],onkeydown:e[13](e[27]),onclick:e[14](e[27]),$$slots:{default:[create_default_slot_2$5]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16&o[0]&&(r.name=e[4]),1024&o[0]&&(r.label=e[27].label),1024&o[0]&&(r.id=e[27].id),1024&o[0]&&(r.value=e[27].value),1024&o[0]&&(r.disabled=e[27].disabled),1024&o[0]&&(r.hidden=e[27].hidden),256&o[0]&&(r.class=e[8]),1025&o[0]&&(r.checked=e[12](e[27])===e[0]),1024&o[0]&&(r.onkeydown=e[13](e[27])),1024&o[0]&&(r.onclick=e[14](e[27])),8389696&o[0]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_2$a(e){let t,o,r,n,i,a,s=[],l=new Map;const c=e[22].group,u=create_slot(c,e,e[23],get_group_slot_context),p=u||fallback_block_1(e);let d=e[27].options;const h=e=>e[27].id;for(let t=0;t<d.length;t+=1){let o=get_each_context_1(e,d,t),r=h(o);l.set(r,s[t]=create_each_block_1(r,o))}return{c(){t=element("li"),p&&p.c(),o=space(),r=element("ul");for(let e=0;e<s.length;e+=1)s[e].c();n=space(),attr(r,"class","PinturaRadioGroupOptions"),attr(t,"class",i=arrayJoin(["PinturaRadioGroupOptionGroup",e[9]]))},m(e,i){insert(e,t,i),p&&p.m(t,null),append(t,o),append(t,r);for(let e=0;e<s.length;e+=1)s[e].m(r,null);append(t,n),a=!0},p(e,o){u?u.p&&(!a||8389632&o[0])&&update_slot_base(u,c,e,e[23],a?get_slot_changes(c,e[23],o,get_group_slot_changes):get_all_dirty_from_scope(e[23]),get_group_slot_context):p&&p.p&&(!a||1024&o[0])&&p.p(e,a?o:[-1,-1]),8418641&o[0]&&(d=e[27].options,group_outros(),s=update_keyed_each(s,o,h,1,e,d,l,r,outro_and_destroy_block,create_each_block_1,null,get_each_context_1),check_outros()),(!a||512&o[0]&&i!==(i=arrayJoin(["PinturaRadioGroupOptionGroup",e[9]])))&&attr(t,"class",i)},i(e){if(!a){transition_in(p,e);for(let e=0;e<d.length;e+=1)transition_in(s[e]);a=!0}},o(e){transition_out(p,e);for(let e=0;e<s.length;e+=1)transition_out(s[e]);a=!1},d(e){e&&detach(t),p&&p.d(e);for(let e=0;e<s.length;e+=1)s[e].d()}}}function create_if_block_6$4(e){let t,o;return t=new Icon({props:{$$slots:{default:[create_default_slot_3$3]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};8389632&o[0]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_3$3(e){let t,o=e[27].icon+"";return{c(){t=svg_element("g")},m(e,r){insert(e,t,r),t.innerHTML=o},p(e,r){1024&r[0]&&o!==(o=e[27].icon+"")&&(t.innerHTML=o)},d(e){e&&detach(t)}}}function create_if_block_5$5(e){let t,o,r=e[27].label+"";return{c(){t=element("span"),o=text(r),attr(t,"class",e[6])},m(e,r){insert(e,t,r),append(t,o)},p(e,n){1024&n[0]&&r!==(r=e[27].label+"")&&set_data(o,r),64&n[0]&&attr(t,"class",e[6])},d(e){e&&detach(t)}}}function fallback_block_2(e){let t,o,r,n=e[27].icon&&create_if_block_6$4(e),i=!e[27].hideLabel&&create_if_block_5$5(e);return{c(){n&&n.c(),t=space(),i&&i.c(),o=space()},m(e,a){n&&n.m(e,a),insert(e,t,a),i&&i.m(e,a),insert(e,o,a),r=!0},p(e,r){e[27].icon?n?(n.p(e,r),1024&r[0]&&transition_in(n,1)):(n=create_if_block_6$4(e),n.c(),transition_in(n,1),n.m(t.parentNode,t)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),e[27].hideLabel?i&&(i.d(1),i=null):i?i.p(e,r):(i=create_if_block_5$5(e),i.c(),i.m(o.parentNode,o))},i(e){r||(transition_in(n),r=!0)},o(e){transition_out(n),r=!1},d(e){n&&n.d(e),e&&detach(t),i&&i.d(e),e&&detach(o)}}}function create_default_slot_2$5(e){let t;const o=e[22].option,r=create_slot(o,e,e[23],get_option_slot_context_1),n=r||fallback_block_2(e);return{c(){n&&n.c()},m(e,o){n&&n.m(e,o),t=!0},p(e,i){r?r.p&&(!t||8389632&i[0])&&update_slot_base(r,o,e,e[23],t?get_slot_changes(o,e[23],i,get_option_slot_changes_1):get_all_dirty_from_scope(e[23]),get_option_slot_context_1):n&&n.p&&(!t||1088&i[0])&&n.p(e,t?i:[-1,-1])},i(e){t||(transition_in(n,e),t=!0)},o(e){transition_out(n,e),t=!1},d(e){n&&n.d(e)}}}function fallback_block_1(e){let t,o,r=e[27].label+"";return{c(){t=element("span"),o=text(r),attr(t,"class","PinturaRadioGroupOptionGroupLabel")},m(e,r){insert(e,t,r),append(t,o)},p(e,t){1024&t[0]&&r!==(r=e[27].label+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_if_block_4$7(e){let t,o;return t=new Icon({props:{$$slots:{default:[create_default_slot_1$7]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};8389632&o[0]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_1$7(e){let t,o=e[27].icon+"";return{c(){t=svg_element("g")},m(e,r){insert(e,t,r),t.innerHTML=o},p(e,r){1024&r[0]&&o!==(o=e[27].icon+"")&&(t.innerHTML=o)},d(e){e&&detach(t)}}}function create_if_block_3$8(e){let t,o,r=e[27].label+"";return{c(){t=element("span"),o=text(r),attr(t,"class",e[6])},m(e,r){insert(e,t,r),append(t,o)},p(e,n){1024&n[0]&&r!==(r=e[27].label+"")&&set_data(o,r),64&n[0]&&attr(t,"class",e[6])},d(e){e&&detach(t)}}}function fallback_block$2(e){let t,o,r,n=e[27].icon&&create_if_block_4$7(e),i=!e[27].hideLabel&&create_if_block_3$8(e);return{c(){n&&n.c(),t=space(),i&&i.c(),o=space()},m(e,a){n&&n.m(e,a),insert(e,t,a),i&&i.m(e,a),insert(e,o,a),r=!0},p(e,r){e[27].icon?n?(n.p(e,r),1024&r[0]&&transition_in(n,1)):(n=create_if_block_4$7(e),n.c(),transition_in(n,1),n.m(t.parentNode,t)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),e[27].hideLabel?i&&(i.d(1),i=null):i?i.p(e,r):(i=create_if_block_3$8(e),i.c(),i.m(o.parentNode,o))},i(e){r||(transition_in(n),r=!0)},o(e){transition_out(n),r=!1},d(e){n&&n.d(e),e&&detach(t),i&&i.d(e),e&&detach(o)}}}function create_default_slot$g(e){let t;const o=e[22].option,r=create_slot(o,e,e[23],get_option_slot_context),n=r||fallback_block$2(e);return{c(){n&&n.c()},m(e,o){n&&n.m(e,o),t=!0},p(e,i){r?r.p&&(!t||8389632&i[0])&&update_slot_base(r,o,e,e[23],t?get_slot_changes(o,e[23],i,get_option_slot_changes):get_all_dirty_from_scope(e[23]),get_option_slot_context):n&&n.p&&(!t||1088&i[0])&&n.p(e,t?i:[-1,-1])},i(e){t||(transition_in(n,e),t=!0)},o(e){transition_out(n,e),t=!1},d(e){n&&n.d(e)}}}function create_each_block_1(e,t){let o,r,n;return r=new RadioItem({props:{name:t[4],label:t[27].label,id:t[27].id,value:t[27].value,disabled:t[27].disabled,hidden:t[27].hidden,class:t[8],checked:t[12](t[27])===t[0],onkeydown:t[13](t[27]),onclick:t[14](t[27]),$$slots:{default:[create_default_slot$g]},$$scope:{ctx:t}}}),{key:e,first:null,c(){o=empty(),create_component(r.$$.fragment),this.first=o},m(e,t){insert(e,o,t),mount_component(r,e,t),n=!0},p(e,o){t=e;const n={};16&o[0]&&(n.name=t[4]),1024&o[0]&&(n.label=t[27].label),1024&o[0]&&(n.id=t[27].id),1024&o[0]&&(n.value=t[27].value),1024&o[0]&&(n.disabled=t[27].disabled),1024&o[0]&&(n.hidden=t[27].hidden),256&o[0]&&(n.class=t[8]),1025&o[0]&&(n.checked=t[12](t[27])===t[0]),1024&o[0]&&(n.onkeydown=t[13](t[27])),1024&o[0]&&(n.onclick=t[14](t[27])),8389696&o[0]&&(n.$$scope={dirty:o,ctx:t}),r.$set(n)},i(e){n||(transition_in(r.$$.fragment,e),n=!0)},o(e){transition_out(r.$$.fragment,e),n=!1},d(e){e&&detach(o),destroy_component(r,e)}}}function create_each_block$5(e,t){let o,r,n,i,a;const s=[create_if_block_2$a,create_else_block$9],l=[];function c(e,t){return e[27].options?0:1}return r=c(t),n=l[r]=s[r](t),{key:e,first:null,c(){o=empty(),n.c(),i=empty(),this.first=o},m(e,t){insert(e,o,t),l[r].m(e,t),insert(e,i,t),a=!0},p(e,o){let a=r;r=c(t=e),r===a?l[r].p(t,o):(group_outros(),transition_out(l[a],1,1,(()=>{l[a]=null})),check_outros(),n=l[r],n?n.p(t,o):(n=l[r]=s[r](t),n.c()),transition_in(n,1),n.m(i.parentNode,i))},i(e){a||(transition_in(n),a=!0)},o(e){transition_out(n),a=!1},d(e){e&&detach(o),l[r].d(e),e&&detach(i)}}}function create_fragment$L(e){let t,o,r,n=e[11].length&&create_if_block_1$e(e),i=!1;return{c(){n&&n.c(),t=space(),o=empty()},m(e,i){n&&n.m(e,i),insert(e,t,i),insert(e,o,i),r=!0},p(e,o){e[11].length?n?(n.p(e,o),2048&o[0]&&transition_in(n,1)):(n=create_if_block_1$e(e),n.c(),transition_in(n,1),n.m(t.parentNode,t)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros())},i(e){r||(transition_in(n),transition_in(i),r=!0)},o(e){transition_out(n),transition_out(i),r=!1},d(e){n&&n.d(e),e&&detach(t),e&&detach(o)}}}function instance$M(e,t,o){let r,n,i,{$$slots:a={},$$scope:s}=t;const l=createEventDispatcher();let{label:c}=t,{hideLabel:u=!0}=t,{class:p}=t,{name:d=`radio-group-${getUniqueId()}`}=t,{selectedIndex:h=-1}=t,{options:m=[]}=t,{onchange:g}=t,{layout:f}=t,{optionMapper:$}=t,{optionFilter:b}=t,{value:y}=t,{optionLabelClass:_}=t,{title:x}=t,{locale:v}=t,{optionClass:S}=t,{optionGroupClass:C}=t;const w=e=>i.findIndex((t=>t.id===e.id)),T=(e,t)=>{o(0,h=w(e));const r={index:h,...e};opop(g,r,t),l("change",r)};return e.$$set=e=>{"label"in e&&o(1,c=e.label),"hideLabel"in e&&o(2,u=e.hideLabel),"class"in e&&o(3,p=e.class),"name"in e&&o(4,d=e.name),"selectedIndex"in e&&o(0,h=e.selectedIndex),"options"in e&&o(15,m=e.options),"onchange"in e&&o(16,g=e.onchange),"layout"in e&&o(5,f=e.layout),"optionMapper"in e&&o(17,$=e.optionMapper),"optionFilter"in e&&o(18,b=e.optionFilter),"value"in e&&o(19,y=e.value),"optionLabelClass"in e&&o(6,_=e.optionLabelClass),"title"in e&&o(7,x=e.title),"locale"in e&&o(20,v=e.locale),"optionClass"in e&&o(8,S=e.optionClass),"optionGroupClass"in e&&o(9,C=e.optionGroupClass),"$$scope"in e&&o(23,s=e.$$scope)},e.$$.update=()=>{1343488&e.$$.dirty[0]&&o(11,r=localizeOptions$1(b?m.filter(b):m,v)),133120&e.$$.dirty[0]&&o(10,n=mapOptions(r,$)),1024&e.$$.dirty[0]&&o(21,i=flattenOptions(n)),2654209&e.$$.dirty[0]&&h<0&&(o(0,h=i.findIndex((e=>isDeepEqual(e.value,y)))),h<0&&o(0,h=(e=>e.findIndex((e=>void 0===e[0])))(m)))},[h,c,u,p,d,f,_,x,S,C,n,r,w,e=>t=>{isConfirmKey(t.key)&&T(e,t)},e=>t=>{T(e,t)},m,g,$,b,y,v,i,a,s]}class RadioGroup extends SvelteComponent{constructor(e){super(),init(this,e,instance$M,create_fragment$L,safe_not_equal,{label:1,hideLabel:2,class:3,name:4,selectedIndex:0,options:15,onchange:16,layout:5,optionMapper:17,optionFilter:18,value:19,optionLabelClass:6,title:7,locale:20,optionClass:8,optionGroupClass:9},null,[-1,-1])}}function create_if_block$k(e){let t,o,r,n,i,a,s,l,c,u;return{c(){t=element("div"),o=element("button"),r=text("▲"),i=space(),a=element("button"),s=text("▼"),attr(o,"type","button"),attr(o,"tabindex","-1"),attr(o,"aria-label",n=`increase ${e[7]}`),attr(a,"type","button"),attr(a,"tabindex","-1"),attr(a,"aria-label",l=`decrease ${e[7]}`),attr(t,"class","PinturaInputSpinners")},m(n,l){insert(n,t,l),append(t,o),append(o,r),append(t,i),append(t,a),append(a,s),c||(u=[listen(o,"click",e[17]),listen(a,"click",e[18])],c=!0)},p(e,t){128&t&&n!==(n=`increase ${e[7]}`)&&attr(o,"aria-label",n),128&t&&l!==(l=`decrease ${e[7]}`)&&attr(a,"aria-label",l)},d(e){e&&detach(t),c=!1,run_all(u)}}}function create_fragment$K(e){let t,o,r,n,i,a,s="number"===e[1]&&e[9]&&create_if_block$k(e);return{c(){t=element("div"),o=element("input"),n=space(),s&&s.c(),attr(o,"class","PinturaInputField"),attr(o,"title",e[7]),attr(o,"type",e[1]),attr(o,"min",e[4]),attr(o,"max",e[5]),attr(o,"step",e[6]),attr(o,"inputmode",e[3]),o.value=r=e[14]?e[13]:e[0],attr(o,"placeholder",e[8]),attr(o,"maxlength",e[12]),o.disabled=e[2],attr(o,"spellcheck","false"),attr(o,"autocorrect","off"),attr(o,"autocapitalize","off"),set_style(o,"min-width",e[11]?`${e[11]}em`:void 0),attr(t,"class","PinturaInput")},m(r,l){insert(r,t,l),append(t,o),e[26](o),append(t,n),s&&s.m(t,null),i||(a=[listen(o,"input",e[16]),listen(o,"blur",(function(){is_function(e[14]&&e[15])&&(e[14]&&e[15]).apply(this,arguments)})),listen(o,"keydown",e[19]),listen(o,"keyup",e[20])],i=!0)},p(n,[i]){e=n,128&i&&attr(o,"title",e[7]),2&i&&attr(o,"type",e[1]),16&i&&attr(o,"min",e[4]),32&i&&attr(o,"max",e[5]),64&i&&attr(o,"step",e[6]),8&i&&attr(o,"inputmode",e[3]),24577&i&&r!==(r=e[14]?e[13]:e[0])&&o.value!==r&&(o.value=r),256&i&&attr(o,"placeholder",e[8]),4096&i&&attr(o,"maxlength",e[12]),4&i&&(o.disabled=e[2]),2048&i&&set_style(o,"min-width",e[11]?`${e[11]}em`:void 0),"number"===e[1]&&e[9]?s?s.p(e,i):(s=create_if_block$k(e),s.c(),s.m(t,null)):s&&(s.d(1),s=null)},i:noop,o:noop,d(o){o&&detach(t),e[26](null),s&&s.d(),i=!1,run_all(a)}}}function instance$L(e,t,o){let r,n,i,a,s,l,{value:c}=t,{type:u="text"}=t,{disabled:p=!1}=t,{inputmode:d}=t,{min:h}=t,{max:m}=t,{step:g}=t,{onchange:f=noop$1}=t,{onkeydown:$=noop$1}=t,{title:b}=t,{stepMultiplier:y=10}=t,{placeholder:_}=t,{enableSpinButtons:x=!0}=t,{enableStopPropagation:v=!1}=t;const S=()=>{let e=s.value;return"number"===u&&(e="numeric"===d?parseInt(e,10):parseFloat(e),!isNumber(e)||Number.isNaN(e)?e=h||0:r&&(e=clamp(e,h,m))),e};let C=c;const w=()=>{const e=clamp(S()+(l?g*y:g),h,m);e!==c&&(o(25,C=e),o(0,c=e),f(c))},T=()=>{const e=clamp(S()-(l?g*y:g),h,m);e!==c&&(o(25,C=e),o(0,c=e),f(c))};return e.$$set=e=>{"value"in e&&o(0,c=e.value),"type"in e&&o(1,u=e.type),"disabled"in e&&o(2,p=e.disabled),"inputmode"in e&&o(3,d=e.inputmode),"min"in e&&o(4,h=e.min),"max"in e&&o(5,m=e.max),"step"in e&&o(6,g=e.step),"onchange"in e&&o(21,f=e.onchange),"onkeydown"in e&&o(22,$=e.onkeydown),"title"in e&&o(7,b=e.title),"stepMultiplier"in e&&o(23,y=e.stepMultiplier),"placeholder"in e&&o(8,_=e.placeholder),"enableSpinButtons"in e&&o(9,x=e.enableSpinButtons),"enableStopPropagation"in e&&o(24,v=e.enableStopPropagation)},e.$$.update=()=>{48&e.$$.dirty&&o(14,r=isNumber(h)&&isNumber(m)),33555457&e.$$.dirty&&o(13,n=s===document.activeElement?C:c),32&e.$$.dirty&&o(11,i=m?(m+"").length:void 0),2056&e.$$.dirty&&o(12,a="numeric"===d&&i?i:void 0)},[c,u,p,d,h,m,g,b,_,x,s,i,a,n,r,()=>{o(25,C=S()),f(c)},()=>{o(25,C=s.value),f(S())},w,T,e=>{l=e.shiftKey,$(e);const{key:t}=e;v&&e.stopPropagation(),/up|down/i.test(t)&&(/up/i.test(t)&&w(),/down/i.test(t)&&T(),e.preventDefault(),e.stopPropagation())},e=>{const{key:t}=e;/up|down/i.test(t)&&(e.preventDefault(),e.stopPropagation())},f,$,y,v,C,function(e){binding_callbacks[e?"unshift":"push"]((()=>{s=e,o(10,s)}))}]}class Input extends SvelteComponent{constructor(e){super(),init(this,e,instance$L,create_fragment$K,safe_not_equal,{value:0,type:1,disabled:2,inputmode:3,min:4,max:5,step:6,onchange:21,onkeydown:22,title:7,stepMultiplier:23,placeholder:8,enableSpinButtons:9,enableStopPropagation:24})}}const get_controls_slot_changes=e=>({}),get_controls_slot_context=e=>({});function create_else_block$8(e){let t,o,r,n,i=(e[2]||e[20])+"",a=e[6]&&create_if_block_4$6(e);return{c(){a&&a.c(),t=space(),o=element("span"),attr(o,"class",r=arrayJoin(["PinturaButtonLabel",e[3],e[5]&&"implicit"]))},m(e,r){a&&a.m(e,r),insert(e,t,r),insert(e,o,r),o.innerHTML=i,n=!0},p(e,s){e[6]?a?(a.p(e,s),64&s[0]&&transition_in(a,1)):(a=create_if_block_4$6(e),a.c(),transition_in(a,1),a.m(t.parentNode,t)):a&&(group_outros(),transition_out(a,1,1,(()=>{a=null})),check_outros()),(!n||1048580&s[0])&&i!==(i=(e[2]||e[20])+"")&&(o.innerHTML=i),(!n||40&s[0]&&r!==(r=arrayJoin(["PinturaButtonLabel",e[3],e[5]&&"implicit"])))&&attr(o,"class",r)},i(e){n||(transition_in(a),n=!0)},o(e){transition_out(a),n=!1},d(e){a&&a.d(e),e&&detach(t),e&&detach(o)}}}function create_if_block_3$7(e){let t,o;return t=new Input({props:{value:e[10],onchange:e[16],enableStopPropagation:!0,type:"number",inputmode:"numeric",min:e[8].reduce(func,1/0),max:e[8].reduce(func_1,-1/0),enableSpinButtons:!1}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};1024&o[0]&&(r.value=e[10]),65536&o[0]&&(r.onchange=e[16]),256&o[0]&&(r.min=e[8].reduce(func,1/0)),256&o[0]&&(r.max=e[8].reduce(func_1,-1/0)),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_4$6(e){let t,o;return t=new Icon({props:{class:"PinturaButtonIcon",$$slots:{default:[create_default_slot_1$6]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};536870976&o[0]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_1$6(e){let t;return{c(){t=svg_element("g")},m(o,r){insert(o,t,r),t.innerHTML=e[6]},p(e,o){64&o[0]&&(t.innerHTML=e[6])},d(e){e&&detach(t)}}}function create_label_slot$2(e){let t,o,r,n,i;const a=[create_if_block_3$7,create_else_block$8],s=[];function l(e,t){return e[17]?0:1}return o=l(e),r=s[o]=a[o](e),{c(){t=element("span"),r.c(),attr(t,"slot","label"),attr(t,"class",n=arrayJoin(["PinturaButtonInner",e[17]&&"PinturaComboBox",e[4]]))},m(e,r){insert(e,t,r),s[o].m(t,null),i=!0},p(e,c){let u=o;o=l(e),o===u?s[o].p(e,c):(group_outros(),transition_out(s[u],1,1,(()=>{s[u]=null})),check_outros(),r=s[o],r?r.p(e,c):(r=s[o]=a[o](e),r.c()),transition_in(r,1),r.m(t,null)),(!i||131088&c[0]&&n!==(n=arrayJoin(["PinturaButtonInner",e[17]&&"PinturaComboBox",e[4]])))&&attr(t,"class",n)},i(e){i||(transition_in(r),i=!0)},o(e){transition_out(r),i=!1},d(e){e&&detach(t),s[o].d()}}}function create_group_slot$1(e){let t,o,r=e[31].label+"";return{c(){t=element("span"),o=text(r),attr(t,"slot","group")},m(e,r){insert(e,t,r),append(t,o)},p(e,t){1&t[1]&&r!==(r=e[31].label+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_if_block_2$9(e){let t,o;return t=new Icon({props:{style:isFunction(e[14])?e[14](e[31].value):e[14],$$slots:{default:[create_default_slot$f]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16384&o[0]|1&o[1]&&(r.style=isFunction(e[14])?e[14](e[31].value):e[14]),536870912&o[0]|1&o[1]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot$f(e){let t,o=e[31].icon+"";return{c(){t=svg_element("g")},m(e,r){insert(e,t,r),t.innerHTML=o},p(e,r){1&r[1]&&o!==(o=e[31].icon+"")&&(t.innerHTML=o)},d(e){e&&detach(t)}}}function create_if_block$j(e){let t,o,r,n,i,a,s,l=e[31].label+"",c=e[31].sublabel&&create_if_block_1$d(e);return{c(){t=element("span"),o=new HtmlTag(!1),r=space(),c&&c.c(),o.a=r,attr(t,"class",n=arrayJoin(["PinturaDropdownOptionLabel",e[11]]))},m(n,u){insert(n,t,u),o.m(l,t),append(t,r),c&&c.m(t,null),a||(s=action_destroyer(i=styleable.call(null,t,isFunction(e[15])?e[15](e[31].value):e[15])),a=!0)},p(e,r){1&r[1]&&l!==(l=e[31].label+"")&&o.p(l),e[31].sublabel?c?c.p(e,r):(c=create_if_block_1$d(e),c.c(),c.m(t,null)):c&&(c.d(1),c=null),2048&r[0]&&n!==(n=arrayJoin(["PinturaDropdownOptionLabel",e[11]]))&&attr(t,"class",n),i&&is_function(i.update)&&32768&r[0]|1&r[1]&&i.update.call(null,isFunction(e[15])?e[15](e[31].value):e[15])},d(e){e&&detach(t),c&&c.d(),a=!1,s()}}}function create_if_block_1$d(e){let t,o=e[31].sublabel+"";return{c(){t=element("span"),attr(t,"class","PinturaDropdownOptionSublabel")},m(e,r){insert(e,t,r),t.innerHTML=o},p(e,r){1&r[1]&&o!==(o=e[31].sublabel+"")&&(t.innerHTML=o)},d(e){e&&detach(t)}}}function create_option_slot$5(e){let t,o,r,n=e[31].icon&&create_if_block_2$9(e),i=!e[31].hideLabel&&create_if_block$j(e);return{c(){t=element("span"),n&&n.c(),o=space(),i&&i.c(),attr(t,"slot","option")},m(e,a){insert(e,t,a),n&&n.m(t,null),append(t,o),i&&i.m(t,null),r=!0},p(e,r){e[31].icon?n?(n.p(e,r),1&r[1]&&transition_in(n,1)):(n=create_if_block_2$9(e),n.c(),transition_in(n,1),n.m(t,o)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),e[31].hideLabel?i&&(i.d(1),i=null):i?i.p(e,r):(i=create_if_block$j(e),i.c(),i.m(t,null))},i(e){r||(transition_in(n),r=!0)},o(e){transition_out(n),r=!1},d(e){e&&detach(t),n&&n.d(),i&&i.d()}}}function create_details_slot$3(e){let t,o,r,n,i,a;const s=e[27].controls,l=create_slot(s,e,e[29],get_controls_slot_context);return r=new RadioGroup({props:{class:"PinturaOptionsList PinturaScrollableContent",name:e[7],value:e[10],selectedIndex:e[9],optionFilter:e[12],optionMapper:e[13],optionLabelClass:arrayJoin(["PinturaDropdownOptionLabel",e[11]]),optionGroupClass:"PinturaListOptionGroup",optionClass:"PinturaListOption",options:e[18],onchange:e[21],$$slots:{option:[create_option_slot$5,({option:e})=>({31:e}),({option:e})=>[0,e?1:0]],group:[create_group_slot$1,({option:e})=>({31:e}),({option:e})=>[0,e?1:0]]},$$scope:{ctx:e}}}),{c(){t=element("div"),l&&l.c(),o=space(),create_component(r.$$.fragment),attr(t,"slot","details"),attr(t,"class","PinturaOptionsListWrapper")},m(s,c){insert(s,t,c),l&&l.m(t,null),append(t,o),mount_component(r,t,null),n=!0,i||(a=listen(t,"keydown",e[23]),i=!0)},p(e,t){l&&l.p&&(!n||536870912&t[0])&&update_slot_base(l,s,e,e[29],n?get_slot_changes(s,e[29],t,get_controls_slot_changes):get_all_dirty_from_scope(e[29]),get_controls_slot_context);const o={};128&t[0]&&(o.name=e[7]),1024&t[0]&&(o.value=e[10]),512&t[0]&&(o.selectedIndex=e[9]),4096&t[0]&&(o.optionFilter=e[12]),8192&t[0]&&(o.optionMapper=e[13]),2048&t[0]&&(o.optionLabelClass=arrayJoin(["PinturaDropdownOptionLabel",e[11]])),262144&t[0]&&(o.options=e[18]),536922112&t[0]|1&t[1]&&(o.$$scope={dirty:t,ctx:e}),r.$set(o)},i(e){n||(transition_in(l,e),transition_in(r.$$.fragment,e),n=!0)},o(e){transition_out(l,e),transition_out(r.$$.fragment,e),n=!1},d(e){e&&detach(t),l&&l.d(e),destroy_component(r),i=!1,a()}}}function create_fragment$J(e){let t,o,r;function n(t){e[28](t)}let i={onshow:e[22],buttonTitle:toTitle(e[2],e[1]),buttonClass:arrayJoin(["PinturaDropdownButton",e[0],e[5]&&"PinturaDropdownIconOnly"]),$$slots:{details:[create_details_slot$3],label:[create_label_slot$2]},$$scope:{ctx:e}};return void 0!==e[19]&&(i.isActive=e[19]),t=new Panel({props:i}),binding_callbacks.push((()=>bind(t,"isActive",n))),{c(){create_component(t.$$.fragment)},m(e,o){mount_component(t,e,o),r=!0},p(e,r){const n={};6&r[0]&&(n.buttonTitle=toTitle(e[2],e[1])),33&r[0]&&(n.buttonClass=arrayJoin(["PinturaDropdownButton",e[0],e[5]&&"PinturaDropdownIconOnly"])),538443772&r[0]&&(n.$$scope={dirty:r,ctx:e}),!o&&524288&r[0]&&(o=!0,n.isActive=e[19],add_flush_callback((()=>o=!1))),t.$set(n)},i(e){r||(transition_in(t.$$.fragment,e),r=!0)},o(e){transition_out(t.$$.fragment,e),r=!1},d(e){destroy_component(t,e)}}}const func=(e,[t])=>t<e?t:e,func_1=(e,[t])=>t>e?t:e;function instance$K(e,t,o){let r,n,{$$slots:i={},$$scope:a}=t,{class:s}=t,{title:l}=t,{label:c}=t,{labelClass:u}=t,{innerClass:p}=t,{hideLabel:d=!1}=t,{icon:h}=t,{name:m}=t,{options:g=[]}=t,{selectedIndex:f=-1}=t,{value:$}=t,{optionLabelClass:b}=t,{optionFilter:y}=t,{optionMapper:_}=t,{optionIconStyle:x}=t,{optionLabelStyle:v}=t,{locale:S}=t,{onchange:C=noop$1}=t,{onload:w=noop$1}=t,{ondestroy:T=noop$1}=t,{enableInput:k=!1}=t;let R;return onMount((()=>w({options:g}))),onDestroy((()=>T({options:g}))),e.$$set=e=>{"class"in e&&o(0,s=e.class),"title"in e&&o(1,l=e.title),"label"in e&&o(2,c=e.label),"labelClass"in e&&o(3,u=e.labelClass),"innerClass"in e&&o(4,p=e.innerClass),"hideLabel"in e&&o(5,d=e.hideLabel),"icon"in e&&o(6,h=e.icon),"name"in e&&o(7,m=e.name),"options"in e&&o(8,g=e.options),"selectedIndex"in e&&o(9,f=e.selectedIndex),"value"in e&&o(10,$=e.value),"optionLabelClass"in e&&o(11,b=e.optionLabelClass),"optionFilter"in e&&o(12,y=e.optionFilter),"optionMapper"in e&&o(13,_=e.optionMapper),"optionIconStyle"in e&&o(14,x=e.optionIconStyle),"optionLabelStyle"in e&&o(15,v=e.optionLabelStyle),"locale"in e&&o(24,S=e.locale),"onchange"in e&&o(16,C=e.onchange),"onload"in e&&o(25,w=e.onload),"ondestroy"in e&&o(26,T=e.ondestroy),"enableInput"in e&&o(17,k=e.enableInput),"$$scope"in e&&o(29,a=e.$$scope)},e.$$.update=()=>{16777472&e.$$.dirty[0]&&o(18,r=S?localizeOptions$1(g,S):g),263168&e.$$.dirty[0]&&o(20,n=r.reduce(((e,t)=>{if(e)return e;const o=Array.isArray(t)?t:[t,t],[r,n]=o;return isDeepEqual(r,$)?n:void 0}),void 0)||(e=>{const t=e.find((e=>void 0===e[0]));if(t)return t[1]})(r)||$)},[s,l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,C,k,r,R,n,e=>{o(20,n=e.value),C(e),o(19,R=!1)},({e:e,panel:t})=>{if(e&&e.key&&/up|down/i.test(e.key))return focus(t.querySelector("input:not([disabled])"));focus(t.querySelector("fieldset"))},e=>{/tab/i.test(e.key)&&e.preventDefault()},S,w,T,i,function(e){R=e,o(19,R)},a]}class Dropdown extends SvelteComponent{constructor(e){super(),init(this,e,instance$K,create_fragment$J,safe_not_equal,{class:0,title:1,label:2,labelClass:3,innerClass:4,hideLabel:5,icon:6,name:7,options:8,selectedIndex:9,value:10,optionLabelClass:11,optionFilter:12,optionMapper:13,optionIconStyle:14,optionLabelStyle:15,locale:24,onchange:16,onload:25,ondestroy:26,enableInput:17},null,[-1,-1])}}function create_details_slot$2(e){let t;return{c(){t=element("div"),attr(t,"slot","details")},m(o,r){insert(o,t,r),e[14](t)},p:noop,d(o){o&&detach(t),e[14](null)}}}function create_fragment$I(e){let t,o,r;function n(t){e[15](t)}let i={buttonLabel:e[0],buttonClass:e[1],buttonIcon:e[2],buttonHideLabel:e[3],buttonTitle:e[4],buttonLabelClass:e[5],onshow:e[6],onhide:e[7],$$slots:{details:[create_details_slot$2]},$$scope:{ctx:e}};return void 0!==e[9]&&(i.isActive=e[9]),t=new Panel({props:i}),binding_callbacks.push((()=>bind(t,"isActive",n))),{c(){create_component(t.$$.fragment)},m(e,o){mount_component(t,e,o),r=!0},p(e,[r]){const n={};1&r&&(n.buttonLabel=e[0]),2&r&&(n.buttonClass=e[1]),4&r&&(n.buttonIcon=e[2]),8&r&&(n.buttonHideLabel=e[3]),16&r&&(n.buttonTitle=e[4]),32&r&&(n.buttonLabelClass=e[5]),64&r&&(n.onshow=e[6]),128&r&&(n.onhide=e[7]),65792&r&&(n.$$scope={dirty:r,ctx:e}),!o&&512&r&&(o=!0,n.isActive=e[9],add_flush_callback((()=>o=!1))),t.$set(n)},i(e){r||(transition_in(t.$$.fragment,e),r=!0)},o(e){transition_out(t.$$.fragment,e),r=!1},d(e){destroy_component(t,e)}}}function instance$J(e,t,o){let{buttonLabel:r}=t,{buttonClass:n}=t,{buttonIcon:i}=t,{buttonHideLabel:a}=t,{buttonTitle:s}=t,{buttonLabelClass:l}=t,{root:c}=t,{ondestroy:u=noop$1}=t,{onshow:p=noop$1}=t,{onhide:d=noop$1}=t;let h,m=!1;return onDestroy(u),e.$$set=e=>{"buttonLabel"in e&&o(0,r=e.buttonLabel),"buttonClass"in e&&o(1,n=e.buttonClass),"buttonIcon"in e&&o(2,i=e.buttonIcon),"buttonHideLabel"in e&&o(3,a=e.buttonHideLabel),"buttonTitle"in e&&o(4,s=e.buttonTitle),"buttonLabelClass"in e&&o(5,l=e.buttonLabelClass),"root"in e&&o(10,c=e.root),"ondestroy"in e&&o(11,u=e.ondestroy),"onshow"in e&&o(6,p=e.onshow),"onhide"in e&&o(7,d=e.onhide)},e.$$.update=()=>{1280&e.$$.dirty&&h&&c&&h.firstChild!==c&&(h.hasChildNodes()?h.replaceChild(c,h.firstChild):h.append(c))},[r,n,i,a,s,l,p,d,h,m,c,u,()=>o(9,m=!1),()=>o(9,m=!0),function(e){binding_callbacks[e?"unshift":"push"]((()=>{h=e,o(8,h)}))},function(e){m=e,o(9,m)}]}class DynamicPanel extends SvelteComponent{constructor(e){super(),init(this,e,instance$J,create_fragment$I,safe_not_equal,{buttonLabel:0,buttonClass:1,buttonIcon:2,buttonHideLabel:3,buttonTitle:4,buttonLabelClass:5,root:10,ondestroy:11,onshow:6,onhide:7,hide:12,show:13})}get hide(){return this.$$.ctx[12]}get show(){return this.$$.ctx[13]}}var nudgeable=(e,t={})=>{const{direction:o,shiftMultiplier:r=10,bubbles:n=!1,preventDefault:i=!1,stopKeydownPropagation:a=!0}=t,s="horizontal"===o,l="vertical"===o,c=t=>{const{key:o}=t,c=t.shiftKey,u=/up|down/i.test(o),p=/left|right/i.test(o);if(!p&&!u)return;if(s&&u)return;if(l&&p)return;const d=c?r:1;a&&t.stopPropagation(),i&&t.preventDefault(),e.dispatchEvent(new CustomEvent("nudge",{bubbles:n,detail:vectorCreate((/left/i.test(o)?-1:/right/i.test(o)?1:0)*d,(/up/i.test(o)?-1:/down/i.test(o)?1:0)*d)}))};return e.addEventListener("keydown",c),{destroy(){e.removeEventListener("keydown",c)}}},numberRoundTo=(e,t)=>(t=1/t,Math.round(e*t)/t),toFraction=(e,t,o)=>(e-t)/(o-t);const get_knob_slot_changes=e=>({}),get_knob_slot_context=e=>({});function create_if_block$i(e){let t,o,r,n,i,a,s,l;return o=new Icon({props:{$$slots:{default:[create_default_slot_1$5]},$$scope:{ctx:e}}}),i=new Icon({props:{$$slots:{default:[create_default_slot$e]},$$scope:{ctx:e}}}),{c(){t=element("button"),create_component(o.$$.fragment),r=space(),n=element("button"),create_component(i.$$.fragment),attr(t,"type","button"),attr(t,"aria-label","Increase"),attr(n,"type","button"),attr(n,"aria-label","Decrease")},m(c,u){insert(c,t,u),mount_component(o,t,null),insert(c,r,u),insert(c,n,u),mount_component(i,n,null),a=!0,s||(l=[listen(t,"pointerdown",e[18](1)),listen(n,"pointerdown",e[18](-1))],s=!0)},p(e,t){const r={};32&t[1]&&(r.$$scope={dirty:t,ctx:e}),o.$set(r);const n={};32&t[1]&&(n.$$scope={dirty:t,ctx:e}),i.$set(n)},i(e){a||(transition_in(o.$$.fragment,e),transition_in(i.$$.fragment,e),a=!0)},o(e){transition_out(o.$$.fragment,e),transition_out(i.$$.fragment,e),a=!1},d(e){e&&detach(t),destroy_component(o),e&&detach(r),e&&detach(n),destroy_component(i),s=!1,run_all(l)}}}function create_default_slot_1$5(e){let t;return{c(){t=svg_element("path"),attr(t,"d","M8 12 h8 M12 8 v8")},m(e,o){insert(e,t,o)},p:noop,d(e){e&&detach(t)}}}function create_default_slot$e(e){let t;return{c(){t=svg_element("path"),attr(t,"d","M9 12 h6")},m(e,o){insert(e,t,o)},p:noop,d(e){e&&detach(t)}}}function create_fragment$H(e){let t,o,r,n,i,a,s,l,c,u,p,d,h,m,g;const f=e[34].default,$=create_slot(f,e,e[36],null),b=e[34].knob,y=create_slot(b,e,e[36],get_knob_slot_context);let _=e[7]&&create_if_block$i(e);return{c(){t=element("div"),o=element("div"),r=element("input"),n=space(),i=element("div"),$&&$.c(),s=space(),l=element("div"),c=element("div"),y&&y.c(),p=space(),_&&_.c(),attr(r,"type","range"),attr(r,"id",e[3]),attr(r,"min",e[0]),attr(r,"max",e[1]),attr(r,"step",e[2]),r.value=e[12],set_style(r,"pointer-events",e[8]?"none":void 0),attr(i,"class",a=arrayJoin(["PinturaSliderTrack",e[4]])),attr(c,"class",u=arrayJoin(["PinturaSliderKnob",e[5]])),attr(l,"class","PinturaSliderKnobController"),set_style(l,"transform",e[15]),attr(o,"class","PinturaSliderControl"),set_style(o,"--slider-position",Math.round(e[13])),attr(t,"class",d=arrayJoin(["PinturaSlider",e[10]])),attr(t,"data-direction",e[6])},m(a,u){insert(a,t,u),append(t,o),append(o,r),e[35](r),append(o,n),append(o,i),$&&$.m(i,null),append(o,s),append(o,l),append(l,c),y&&y.m(c,null),append(t,p),_&&_.m(t,null),h=!0,m||(g=[listen(r,"input",e[16]),listen(r,"nudge",e[17]),action_destroyer(nudgeable.call(null,r)),listen(o,"pointerdown",(function(){is_function(e[9]&&e[11])&&(e[9]&&e[11]).apply(this,arguments)}))],m=!0)},p(n,s){e=n,(!h||8&s[0])&&attr(r,"id",e[3]),(!h||1&s[0])&&attr(r,"min",e[0]),(!h||2&s[0])&&attr(r,"max",e[1]),(!h||4&s[0])&&attr(r,"step",e[2]),(!h||4096&s[0])&&(r.value=e[12]),256&s[0]&&set_style(r,"pointer-events",e[8]?"none":void 0),$&&$.p&&(!h||32&s[1])&&update_slot_base($,f,e,e[36],h?get_slot_changes(f,e[36],s,null):get_all_dirty_from_scope(e[36]),null),(!h||16&s[0]&&a!==(a=arrayJoin(["PinturaSliderTrack",e[4]])))&&attr(i,"class",a),y&&y.p&&(!h||32&s[1])&&update_slot_base(y,b,e,e[36],h?get_slot_changes(b,e[36],s,get_knob_slot_changes):get_all_dirty_from_scope(e[36]),get_knob_slot_context),(!h||32&s[0]&&u!==(u=arrayJoin(["PinturaSliderKnob",e[5]])))&&attr(c,"class",u),32768&s[0]&&set_style(l,"transform",e[15]),8192&s[0]&&set_style(o,"--slider-position",Math.round(e[13])),e[7]?_?(_.p(e,s),128&s[0]&&transition_in(_,1)):(_=create_if_block$i(e),_.c(),transition_in(_,1),_.m(t,null)):_&&(group_outros(),transition_out(_,1,1,(()=>{_=null})),check_outros()),(!h||1024&s[0]&&d!==(d=arrayJoin(["PinturaSlider",e[10]])))&&attr(t,"class",d),(!h||64&s[0])&&attr(t,"data-direction",e[6])},i(e){h||(transition_in($,e),transition_in(y,e),transition_in(_),h=!0)},o(e){transition_out($,e),transition_out(y,e),transition_out(_),h=!1},d(o){o&&detach(t),e[35](null),$&&$.d(o),y&&y.d(o),_&&_.d(),m=!1,run_all(g)}}}function instance$I(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$,{$$slots:b={},$$scope:y}=t,{min:_=0}=t,{max:x=100}=t,{step:v=1}=t,{id:S}=t,{value:C=0}=t,{valueMin:w}=t,{valueMax:T}=t,{trackClass:k}=t,{knobClass:R}=t,{ongrab:P=noop$1}=t,{onchange:I=noop$1}=t,{onrelease:E=noop$1}=t,{onexceed:M=noop$1}=t,{direction:A="x"}=t,{getValue:F=passthrough}=t,{setValue:L=passthrough}=t,{enableSpinButtons:D=!0}=t,{enableForceUseKnob:z=!1}=t,{enableStopPropagation:O=!0}=t,{enablePointerdownListener:B=!0}=t,{maxInteractionDistance:N=6}=t,{class:V}=t;const W=e=>L(numberRoundTo(clamp(e,_,x),v),C),U=(e,t,r={})=>{const{grabbed:i=!1,released:a=!1}=r,s=W(_+e/t*n),l=w||_,c=T||x;o(19,C=isString(s)?s:clamp(s,l,c)),$!==s&&($=s,!isString(s)&&(s<l||s>c)&&M(C,s),C!==f&&(f=C,i&&P(C),I(C),a&&E(C)))};let H;let G;const j=e=>{const t=e[u]-g;U(m+t,h)},q=e=>{G=setTimeout((()=>{h=void 0}),50),document.documentElement.removeEventListener("pointermove",j),document.documentElement.removeEventListener("pointerup",q),I(C),E(C)},X=()=>{o(19,C=W(r+Z*v)),I(C)};let Y,Z=1,K=!1;const J=e=>{clearTimeout(Y),K||X(),E(C),document.removeEventListener("pointerup",J)};return e.$$set=e=>{"min"in e&&o(0,_=e.min),"max"in e&&o(1,x=e.max),"step"in e&&o(2,v=e.step),"id"in e&&o(3,S=e.id),"value"in e&&o(19,C=e.value),"valueMin"in e&&o(20,w=e.valueMin),"valueMax"in e&&o(21,T=e.valueMax),"trackClass"in e&&o(4,k=e.trackClass),"knobClass"in e&&o(5,R=e.knobClass),"ongrab"in e&&o(22,P=e.ongrab),"onchange"in e&&o(23,I=e.onchange),"onrelease"in e&&o(24,E=e.onrelease),"onexceed"in e&&o(25,M=e.onexceed),"direction"in e&&o(6,A=e.direction),"getValue"in e&&o(26,F=e.getValue),"setValue"in e&&o(27,L=e.setValue),"enableSpinButtons"in e&&o(7,D=e.enableSpinButtons),"enableForceUseKnob"in e&&o(8,z=e.enableForceUseKnob),"enableStopPropagation"in e&&o(28,O=e.enableStopPropagation),"enablePointerdownListener"in e&&o(9,B=e.enablePointerdownListener),"maxInteractionDistance"in e&&o(29,N=e.maxInteractionDistance),"class"in e&&o(10,V=e.class),"$$scope"in e&&o(36,y=e.$$scope)},e.$$.update=()=>{67633152&e.$$.dirty[0]&&o(12,r=void 0!==C?F(C):0),3&e.$$.dirty[0]&&(n=x-_),4099&e.$$.dirty[0]&&o(31,i=toFraction(r,_,x)),1&e.$$.dirty[1]&&o(13,a=100*i),64&e.$$.dirty[0]&&o(32,s=A.toUpperCase()),64&e.$$.dirty[0]&&o(33,l="x"===A?"Width":"Height"),4&e.$$.dirty[1]&&(c=`offset${l}`),2&e.$$.dirty[1]&&(u=`page${s}`),8192&e.$$.dirty[0]|2&e.$$.dirty[1]&&o(15,p=`translate${s}(${a}%)`)},[_,x,v,S,k,R,A,D,z,B,V,e=>{clearTimeout(G);let t=!1;O&&e.stopPropagation(),clearTimeout(H);const o=d.getBoundingClientRect();if(h=d[c],g=e[u],m=g-o[A],z){if(Math.abs(m-i*h)>N)return;t=!0,e.stopPropagation()}return document.activeElement!==d&&d.focus(),U(m,h,{grabbed:!0}),document.documentElement.addEventListener("pointermove",j),document.documentElement.addEventListener("pointerup",q),t},r,a,d,p,e=>{h||(o(19,C=L(parseFloat(e.target.value))),C!==f&&(f=C,I(C)))},e=>{const t=d[c];U(r/n*t+e.detail[A],t),clearTimeout(H),H=setTimeout((()=>{E(C)}),250)},e=>t=>{clearTimeout(H),Z=e,K=!1,Y=setInterval((()=>{K=!0,X()}),100),document.addEventListener("pointercancel",J),document.addEventListener("pointerup",J)},C,w,T,P,I,E,M,F,L,O,N,e=>{const t=d.getBoundingClientRect(),o=e[u]-t[A],r=d[c];return Math.abs(o-i*r)},i,s,l,b,function(e){binding_callbacks[e?"unshift":"push"]((()=>{d=e,o(14,d)}))},y]}class Slider extends SvelteComponent{constructor(e){super(),init(this,e,instance$I,create_fragment$H,safe_not_equal,{min:0,max:1,step:2,id:3,value:19,valueMin:20,valueMax:21,trackClass:4,knobClass:5,ongrab:22,onchange:23,onrelease:24,onexceed:25,direction:6,getValue:26,setValue:27,enableSpinButtons:7,enableForceUseKnob:8,enableStopPropagation:28,enablePointerdownListener:9,maxInteractionDistance:29,class:10,eventDistanceToKnob:30,handlePointerDown:11},null,[-1,-1])}get eventDistanceToKnob(){return this.$$.ctx[30]}get handlePointerDown(){return this.$$.ctx[11]}}function create_if_block_1$c(e){let t,o;return t=new Icon({props:{class:"PinturaButtonIcon",$$slots:{default:[create_default_slot$d]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};1048580&o&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot$d(e){let t;return{c(){t=svg_element("g")},m(o,r){insert(o,t,r),t.innerHTML=e[2]},p(e,o){4&o&&(t.innerHTML=e[2])},d(e){e&&detach(t)}}}function create_if_block$h(e){let t,o,r=localize(e[8],e[6])+"";return{c(){t=element("span"),o=text(r),attr(t,"class","PinturaButtonLabelPrefix")},m(e,r){insert(e,t,r),append(t,o)},p(e,t){320&t&&r!==(r=localize(e[8],e[6])+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_label_slot$1(e){let t,o,r,n,i,a,s,l,c,u=e[2]&&create_if_block_1$c(e),p=e[8]&&create_if_block$h(e);return{c(){t=element("span"),u&&u.c(),o=space(),p&&p.c(),r=space(),n=element("span"),i=text(e[9]),attr(n,"class",a=arrayJoin(["PinturaButtonLabel",e[3],e[5]&&"implicit"])),attr(t,"slot","label"),attr(t,"title",s=localize(e[1],e[6])),attr(t,"class",l=arrayJoin(["PinturaButtonInner",e[4]]))},m(e,a){insert(e,t,a),u&&u.m(t,null),append(t,o),p&&p.m(t,null),append(t,r),append(t,n),append(n,i),c=!0},p(e,d){e[2]?u?(u.p(e,d),4&d&&transition_in(u,1)):(u=create_if_block_1$c(e),u.c(),transition_in(u,1),u.m(t,o)):u&&(group_outros(),transition_out(u,1,1,(()=>{u=null})),check_outros()),e[8]?p?p.p(e,d):(p=create_if_block$h(e),p.c(),p.m(t,r)):p&&(p.d(1),p=null),(!c||512&d)&&set_data(i,e[9]),(!c||40&d&&a!==(a=arrayJoin(["PinturaButtonLabel",e[3],e[5]&&"implicit"])))&&attr(n,"class",a),(!c||66&d&&s!==(s=localize(e[1],e[6])))&&attr(t,"title",s),(!c||16&d&&l!==(l=arrayJoin(["PinturaButtonInner",e[4]])))&&attr(t,"class",l)},i(e){c||(transition_in(u),c=!0)},o(e){transition_out(u),c=!1},d(e){e&&detach(t),u&&u.d(),p&&p.d()}}}function create_details_slot$1(e){let t,o,r,n,i;const a=[e[12],{value:e[7]},{onchange:e[11]}];let s={};for(let e=0;e<a.length;e+=1)s=assign(s,a[e]);return o=new Slider({props:s}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"slot","details")},m(a,s){insert(a,t,s),mount_component(o,t,null),r=!0,n||(i=listen(t,"keydown",e[10]),n=!0)},p(e,t){const r=6272&t?get_spread_update(a,[4096&t&&get_spread_object(e[12]),128&t&&{value:e[7]},2048&t&&{onchange:e[11]}]):{};o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o),n=!1,i()}}}function create_fragment$G(e){let t,o;return t=new Panel({props:{panelClass:"PinturaSliderPanel",buttonClass:arrayJoin(["PinturaSliderButton",e[0],e[5]&&"PinturaSliderIconOnly"]),$$slots:{details:[create_details_slot$1],label:[create_label_slot$1]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,[o]){const r={};33&o&&(r.buttonClass=arrayJoin(["PinturaSliderButton",e[0],e[5]&&"PinturaSliderIconOnly"])),1053694&o&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function instance$H(e,t,o){const r=["class","title","label","icon","labelClass","innerClass","hideLabel","locale","value","onchange","labelPrefix"];let n=compute_rest_props(t,r),{class:i}=t,{title:a}=t,{label:s=Math.round}=t,{icon:l}=t,{labelClass:c}=t,{innerClass:u}=t,{hideLabel:p=!1}=t,{locale:d}=t,{value:h}=t,{onchange:m=noop$1}=t,{labelPrefix:g}=t;const{min:f,max:$,getValue:b=passthrough}=n;let y;const _=e=>o(9,y=(e=>isFunction(s)?s(b(e),f,$,e):s)(e));return e.$$set=e=>{t=assign(assign({},t),exclude_internal_props(e)),o(12,n=compute_rest_props(t,r)),"class"in e&&o(0,i=e.class),"title"in e&&o(1,a=e.title),"label"in e&&o(13,s=e.label),"icon"in e&&o(2,l=e.icon),"labelClass"in e&&o(3,c=e.labelClass),"innerClass"in e&&o(4,u=e.innerClass),"hideLabel"in e&&o(5,p=e.hideLabel),"locale"in e&&o(6,d=e.locale),"value"in e&&o(7,h=e.value),"onchange"in e&&o(14,m=e.onchange),"labelPrefix"in e&&o(8,g=e.labelPrefix)},e.$$.update=()=>{8320&e.$$.dirty&&_(h)},[i,a,l,c,u,p,d,h,g,y,e=>{/tab/i.test(e.key)&&e.preventDefault()},e=>{_(e),m(e)},n,s,m]}class ToggleSlider extends SvelteComponent{constructor(e){super(),init(this,e,instance$H,create_fragment$G,safe_not_equal,{class:0,title:1,label:13,icon:2,labelClass:3,innerClass:4,hideLabel:5,locale:6,value:7,onchange:14,labelPrefix:8})}}function create_fragment$F(e){let t,o,r,n,i,a,s,l;return{c(){t=element("span"),o=svg_element("svg"),r=svg_element("g"),n=svg_element("circle"),i=svg_element("circle"),a=space(),s=element("span"),l=text(e[3]),attr(n,"class","PinturaProgressIndicatorBar"),attr(n,"r","8.5"),attr(n,"cx","10"),attr(n,"cy","10"),attr(n,"stroke-linecap","round"),attr(n,"opacity",".25"),attr(i,"class","PinturaProgressIndicatorFill"),attr(i,"r","8.5"),attr(i,"stroke-dasharray",e[2]),attr(i,"cx","10"),attr(i,"cy","10"),attr(i,"transform","rotate(-90) translate(-20)"),attr(r,"fill","none"),attr(r,"stroke","currentColor"),attr(r,"stroke-width","2.5"),attr(r,"stroke-linecap","round"),attr(r,"opacity",e[1]),attr(o,"width","20"),attr(o,"height","20"),attr(o,"viewBox","0 0 20 20"),attr(o,"xmlns","http://www.w3.org/2000/svg"),attr(o,"aria-hidden","true"),attr(o,"focusable","false"),attr(s,"class","implicit"),attr(t,"class","PinturaProgressIndicator"),attr(t,"data-status",e[0]),set_style(t,"opacity",e[4])},m(e,c){insert(e,t,c),append(t,o),append(o,r),append(r,n),append(r,i),append(t,a),append(t,s),append(s,l)},p(e,[o]){4&o&&attr(i,"stroke-dasharray",e[2]),2&o&&attr(r,"opacity",e[1]),8&o&&set_data(l,e[3]),1&o&&attr(t,"data-status",e[0]),16&o&&set_style(t,"opacity",e[4])},i:noop,o:noop,d(e){e&&detach(t)}}}function instance$G(e,t,o){let r,n,i,a,s,l,c,u;const p=createEventDispatcher();let{progress:d}=t,{min:h=0}=t,{max:m=100}=t,{labelBusy:g="Busy"}=t,{opacity:f}=t;const $=getContext("isAnimated");component_subscribe(e,$,(e=>o(14,s=e)));const b=spring(f,{precision:.01});component_subscribe(e,b,(e=>o(4,u=e)));const y=spring(0,{precision:.01}),_=spring(0,{precision:.01});component_subscribe(e,_,(e=>o(15,l=e)));const x=derived([y],(e=>clamp(e,h,m)));component_subscribe(e,x,(e=>o(16,c=e)));const v=x.subscribe((e=>{1===d&&Math.round(e)>=100&&p("complete")}));return onMount((()=>{_.set(1,{hard:!s})})),onDestroy((()=>{v()})),e.$$set=e=>{"progress"in e&&o(9,d=e.progress),"min"in e&&o(10,h=e.min),"max"in e&&o(11,m=e.max),"labelBusy"in e&&o(12,g=e.labelBusy),"opacity"in e&&o(13,f=e.opacity)},e.$$.update=()=>{24576&e.$$.dirty&&isNumber(f)&&b.set(f,{hard:!s}),16896&e.$$.dirty&&d&&d!==1/0&&y.set(100*d,{hard:!s}),70144&e.$$.dirty&&o(3,r=d===1/0?g:`${Math.round(c)}%`),66048&e.$$.dirty&&o(2,n=d===1/0?"26.5 53":c/100*53+" 53"),32768&e.$$.dirty&&o(1,i=l),512&e.$$.dirty&&o(0,a=d===1/0?"busy":"loading")},[a,i,n,r,u,$,b,_,x,d,h,m,g,f,s,l,c]}class ProgressIndicator extends SvelteComponent{constructor(e){super(),init(this,e,instance$G,create_fragment$F,safe_not_equal,{progress:9,min:10,max:11,labelBusy:12,opacity:13})}}function create_if_block$g(e){let t,o,r=localize(e[0],e[1])+"";return{c(){t=element("span"),o=text(r),attr(t,"class",e[3])},m(e,r){insert(e,t,r),append(t,o)},p(e,n){3&n&&r!==(r=localize(e[0],e[1])+"")&&set_data(o,r),8&n&&attr(t,"class",e[3])},d(e){e&&detach(t)}}}function create_fragment$E(e){let t,o,r,n,i=e[0]&&create_if_block$g(e);return r=new DynamicComponentTree_1({props:{items:e[2]}}),{c(){t=element("li"),i&&i.c(),o=space(),create_component(r.$$.fragment),attr(t,"class","PinturaShapeStyle")},m(e,a){insert(e,t,a),i&&i.m(t,null),append(t,o),mount_component(r,t,null),n=!0},p(e,[n]){e[0]?i?i.p(e,n):(i=create_if_block$g(e),i.c(),i.m(t,o)):i&&(i.d(1),i=null);const a={};4&n&&(a.items=e[2]),r.$set(a)},i(e){n||(transition_in(r.$$.fragment,e),n=!0)},o(e){transition_out(r.$$.fragment,e),n=!1},d(e){e&&detach(t),i&&i.d(),destroy_component(r)}}}function instance$F(e,t,o){let r,{title:n}=t,{locale:i}=t,{items:a}=t,{hideTitle:s=!1}=t;return e.$$set=e=>{"title"in e&&o(0,n=e.title),"locale"in e&&o(1,i=e.locale),"items"in e&&o(2,a=e.items),"hideTitle"in e&&o(4,s=e.hideTitle)},e.$$.update=()=>{16&e.$$.dirty&&o(3,r="PinturaShapeStyleLabel"+(s?" implicit":""))},[n,i,a,r,s]}class ShapeStyle extends SvelteComponent{constructor(e){super(),init(this,e,instance$F,create_fragment$E,safe_not_equal,{title:0,locale:1,items:2,hideTitle:4})}}var RGBToHSV=(e,t,o)=>{let r=Math.max(e,t,o),n=r-Math.min(e,t,o),i=n&&(r==e?(t-o)/n:r==t?2+(o-e)/n:4+(e-t)/n);return[60*(i<0?i+6:i)/360,r&&n/r,r]},HSVToRGB=(e,t,o)=>{let r,n,i;const a=Math.floor(6*e),s=6*e-a,l=o*(1-t),c=o*(1-s*t),u=o*(1-(1-s)*t);switch(a%6){case 0:r=o,n=u,i=l;break;case 1:r=c,n=o,i=l;break;case 2:r=l,n=o,i=u;break;case 3:r=l,n=c,i=o;break;case 4:r=u,n=l,i=o;break;case 5:r=o,n=l,i=c}return[r,n,i]};function create_fragment$D(e){let t,o;return{c(){t=element("div"),o=element("span"),attr(t,"class","PinturaColorPreview"),attr(t,"title",e[0]),set_style(t,"--color",e[1])},m(e,r){insert(e,t,r),append(t,o)},p(e,[o]){1&o&&attr(t,"title",e[0]),2&o&&set_style(t,"--color",e[1])},i:noop,o:noop,d(e){e&&detach(t)}}}function instance$E(e,t,o){let r,{color:n}=t,{title:i}=t;return e.$$set=e=>{"color"in e&&o(2,n=e.color),"title"in e&&o(0,i=e.title)},e.$$.update=()=>{4&e.$$.dirty&&o(1,r=n?colorArrayToRGBA(n):"transparent")},[i,r,n]}class ColorPreview extends SvelteComponent{constructor(e){super(),init(this,e,instance$E,create_fragment$D,safe_not_equal,{color:2,title:0})}}var hexToRGB=e=>{const[,t,o,r,n]=e.split("");e=e.length>=4&&e.length<=5?`#${t}${t}${o}${o}${r}${r}${n?`${n}${n}`:""}`:e;const[i,a,s,l,c]=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})?$/i.exec(e)||[];if(i)return[a,s,l,c].filter((e=>void 0!==e)).map((e=>parseInt(e,16)/255))},colorStringToColorArray=e=>(e=e.trim(),/^rgba/.test(e)?e.substring(5).split(",").map(parseFloat).map(((e,t)=>e/(3===t?1:255))):/^rgb/.test(e)?e.substring(4).split(",").map(parseFloat).map((e=>e/255)):/^#/.test(e)?hexToRGB(e):/[0-9]{1,3}\s?,\s?[0-9]{1,3}\s?,\s?[0-9]{1,3}/.test(e)?e.split(",").map((e=>parseInt(e,10))).map((e=>e/255)):void 0);let result$4=null;var supportsEyeDropper=()=>(null===result$4&&(result$4=isBrowser()&&"EyeDropper"in window),result$4);function create_if_block_6$3(e){let t,o;return{c(){t=element("span"),o=text(e[0])},m(e,r){insert(e,t,r),append(t,o)},p(e,t){1&t[0]&&set_data(o,e[0])},d(e){e&&detach(t)}}}function create_label_slot(e){let t,o,r,n;o=new ColorPreview({props:{color:e[4],title:localize(e[8],e[10])}});let i=!e[9]&&create_if_block_6$3(e);return{c(){t=element("span"),create_component(o.$$.fragment),r=space(),i&&i.c(),attr(t,"slot","label"),attr(t,"class","PinturaButtonLabel")},m(e,a){insert(e,t,a),mount_component(o,t,null),append(t,r),i&&i.m(t,null),n=!0},p(e,r){const n={};16&r[0]&&(n.color=e[4]),1280&r[0]&&(n.title=localize(e[8],e[10])),o.$set(n),e[9]?i&&(i.d(1),i=null):i?i.p(e,r):(i=create_if_block_6$3(e),i.c(),i.m(t,null))},i(e){n||(transition_in(o.$$.fragment,e),n=!0)},o(e){transition_out(o.$$.fragment,e),n=!1},d(e){e&&detach(t),destroy_component(o),i&&i.d()}}}function create_if_block_2$8(e){let t,o,r,n,i,a,s,l,c,u,p,d;s=new Slider({props:{class:"PinturaHuePicker",onchange:e[27],value:e[16],min:0,max:1,step:.01}});let h=e[11]&&create_if_block_5$4(e),m=(e[14]||e[15])&&create_if_block_3$6(e);return{c(){t=element("div"),o=element("div"),r=element("div"),n=element("div"),i=space(),a=element("div"),create_component(s.$$.fragment),l=space(),h&&h.c(),c=space(),m&&m.c(),attr(n,"role","button"),attr(n,"aria-label","Saturation slider"),attr(n,"class","PinturaPickerKnob"),attr(n,"tabindex","0"),set_style(n,"background-color",e[20]),attr(r,"class","PinturaPickerKnobController"),set_style(r,"transform",`translate(${e[25]}%,${e[24]}%)`),attr(o,"class","PinturaSaturationPicker"),set_style(o,"background-color",e[21]),set_style(a,"--knob-background",e[21]),attr(t,"class","PinturaPicker")},m(g,f){insert(g,t,f),append(t,o),append(o,r),append(r,n),e[41](o),append(t,i),append(t,a),mount_component(s,a,null),append(t,l),h&&h.m(t,null),append(t,c),m&&m.m(t,null),u=!0,p||(d=[listen(n,"nudge",e[30]),action_destroyer(nudgeable.call(null,n,{preventDefault:!0})),listen(o,"pointerdown",e[29])],p=!0)},p(e,i){1048576&i[0]&&set_style(n,"background-color",e[20]),50331648&i[0]&&set_style(r,"transform",`translate(${e[25]}%,${e[24]}%)`),2097152&i[0]&&set_style(o,"background-color",e[21]);const l={};65536&i[0]&&(l.value=e[16]),s.$set(l),2097152&i[0]&&set_style(a,"--knob-background",e[21]),e[11]?h?(h.p(e,i),2048&i[0]&&transition_in(h,1)):(h=create_if_block_5$4(e),h.c(),transition_in(h,1),h.m(t,c)):h&&(group_outros(),transition_out(h,1,1,(()=>{h=null})),check_outros()),e[14]||e[15]?m?(m.p(e,i),49152&i[0]&&transition_in(m,1)):(m=create_if_block_3$6(e),m.c(),transition_in(m,1),m.m(t,null)):m&&(group_outros(),transition_out(m,1,1,(()=>{m=null})),check_outros())},i(e){u||(transition_in(s.$$.fragment,e),transition_in(h),transition_in(m),u=!0)},o(e){transition_out(s.$$.fragment,e),transition_out(h),transition_out(m),u=!1},d(o){o&&detach(t),e[41](null),destroy_component(s),h&&h.d(),m&&m.d(),p=!1,run_all(d)}}}function create_if_block_5$4(e){let t,o,r;return o=new Slider({props:{class:"PinturaOpacityPicker",onchange:e[28],value:e[17],min:0,max:1,step:.01}}),{c(){t=element("div"),create_component(o.$$.fragment),set_style(t,"--knob-background",e[18]),set_style(t,"--track-background",`linear-gradient(to right,${e[19]},${e[20]})`)},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,r){const n={};131072&r[0]&&(n.value=e[17]),o.$set(n),262144&r[0]&&set_style(t,"--knob-background",e[18]),1572864&r[0]&&set_style(t,"--track-background",`linear-gradient(to right,${e[19]},${e[20]})`)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function create_if_block_3$6(e){let t,o,r,n,i,a,s,l=e[15]&&create_if_block_4$5(e);return{c(){t=element("div"),o=element("input"),n=space(),l&&l.c(),attr(o,"class","PinturaColorPickerInput"),attr(o,"type","text"),o.disabled=r=!e[14],o.value=e[23],attr(t,"class","PinturColorPickerInputGroup")},m(r,c){insert(r,t,c),append(t,o),append(t,n),l&&l.m(t,null),i=!0,a||(s=[listen(o,"keydown",e[32]),listen(o,"input",e[31])],a=!0)},p(e,n){(!i||16384&n[0]&&r!==(r=!e[14]))&&(o.disabled=r),(!i||8388608&n[0]&&o.value!==e[23])&&(o.value=e[23]),e[15]?l?(l.p(e,n),32768&n[0]&&transition_in(l,1)):(l=create_if_block_4$5(e),l.c(),transition_in(l,1),l.m(t,null)):l&&(group_outros(),transition_out(l,1,1,(()=>{l=null})),check_outros())},i(e){i||(transition_in(l),i=!0)},o(e){transition_out(l),i=!1},d(e){e&&detach(t),l&&l.d(),a=!1,run_all(s)}}}function create_if_block_4$5(e){let t,o;return t=new Button({props:{icon:'<path stroke="currentColor" stroke-linecap="square" d="m13 14-7 7a2.704 2.704 0 0 1-3 0 2.704 2.704 0 0 1 0-3l7-7"/><path fill="currentColor" d="M9.475 9.475 14.5 14.5c.263.263.69.265.955.005l.783-.767a4.209 4.209 0 0 0 1.262-3.006V10l4-4c.5-.5.375-2.125-.5-3s-2.5-1-3-.5l-4 4h-.732a4.329 4.329 0 0 0-3.03 1.238l-.758.742a.7.7 0 0 0-.005.995Z"/>',hideLabel:!0,label:"Pick a color",class:"PinturaEyeDropper",onclick:e[33]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p:noop,i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block$f(e){let t,o;return t=new RadioGroup({props:{label:localize(e[10].labelColorPalette,e[10]),class:arrayJoin(["PinturaColorPresets",e[9]?"PinturaColorPresetsGrid":"PinturaColorPresetsList"]),hideLabel:!1,name:e[1],value:e[4],optionGroupClass:"PinturaListOptionGroup",optionClass:"PinturaListOption",options:e[2].map(e[42]),selectedIndex:e[3],optionMapper:e[7],optionLabelClass:e[6],onchange:e[43],$$slots:{option:[create_option_slot$4,({option:e})=>({59:e}),({option:e})=>[0,e?268435456:0]],group:[create_group_slot,({option:e})=>({59:e}),({option:e})=>[0,e?268435456:0]]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};1024&o[0]&&(r.label=localize(e[10].labelColorPalette,e[10])),512&o[0]&&(r.class=arrayJoin(["PinturaColorPresets",e[9]?"PinturaColorPresetsGrid":"PinturaColorPresetsList"])),2&o[0]&&(r.name=e[1]),16&o[0]&&(r.value=e[4]),1028&o[0]&&(r.options=e[2].map(e[42])),8&o[0]&&(r.selectedIndex=e[3]),128&o[0]&&(r.optionMapper=e[7]),64&o[0]&&(r.optionLabelClass=e[6]),512&o[0]|805306368&o[1]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_group_slot(e){let t,o,r=e[59].label+"";return{c(){t=element("span"),o=text(r),attr(t,"slot","group")},m(e,r){insert(e,t,r),append(t,o)},p(e,t){268435456&t[1]&&r!==(r=e[59].label+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_if_block_1$b(e){let t,o,r=e[59].label+"";return{c(){t=element("span"),o=text(r),attr(t,"class","PinturaButtonLabel")},m(e,r){insert(e,t,r),append(t,o)},p(e,t){268435456&t[1]&&r!==(r=e[59].label+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_option_slot$4(e){let t,o,r,n;o=new ColorPreview({props:{title:e[59].label,color:e[59].value}});let i=!e[9]&&create_if_block_1$b(e);return{c(){t=element("span"),create_component(o.$$.fragment),r=space(),i&&i.c(),attr(t,"slot","option")},m(e,a){insert(e,t,a),mount_component(o,t,null),append(t,r),i&&i.m(t,null),n=!0},p(e,r){const n={};268435456&r[1]&&(n.title=e[59].label),268435456&r[1]&&(n.color=e[59].value),o.$set(n),e[9]?i&&(i.d(1),i=null):i?i.p(e,r):(i=create_if_block_1$b(e),i.c(),i.m(t,null))},i(e){n||(transition_in(o.$$.fragment,e),n=!0)},o(e){transition_out(o.$$.fragment,e),n=!1},d(e){e&&detach(t),destroy_component(o),i&&i.d()}}}function create_details_slot(e){let t,o,r,n=e[13]&&create_if_block_2$8(e),i=e[12]&&create_if_block$f(e);return{c(){t=element("div"),n&&n.c(),o=space(),i&&i.c(),attr(t,"slot","details"),attr(t,"class","PinturaColorPickerPanel")},m(e,a){insert(e,t,a),n&&n.m(t,null),append(t,o),i&&i.m(t,null),r=!0},p(e,r){e[13]?n?(n.p(e,r),8192&r[0]&&transition_in(n,1)):(n=create_if_block_2$8(e),n.c(),transition_in(n,1),n.m(t,o)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),e[12]?i?(i.p(e,r),4096&r[0]&&transition_in(i,1)):(i=create_if_block$f(e),i.c(),transition_in(i,1),i.m(t,null)):i&&(group_outros(),transition_out(i,1,1,(()=>{i=null})),check_outros())},i(e){r||(transition_in(n),transition_in(i),r=!0)},o(e){transition_out(n),transition_out(i),r=!1},d(e){e&&detach(t),n&&n.d(),i&&i.d()}}}function create_fragment$C(e){let t,o;return t=new Panel({props:{buttonClass:arrayJoin(["PinturaColorPickerButton",e[5]]),$$slots:{details:[create_details_slot],label:[create_label_slot]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};32&o[0]&&(r.buttonClass=arrayJoin(["PinturaColorPickerButton",e[5]])),67108831&o[0]|536870912&o[1]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function instance$D(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,{label:f}=t,{name:$}=t,{options:b=[]}=t,{selectedIndex:y=-1}=t,{value:_}=t,{buttonClass:x}=t,{optionLabelClass:v}=t,{optionMapper:S}=t,{onchange:C}=t,{title:w}=t,{hidePresetLabel:T=!0}=t,{locale:k}=t,{enableOpacity:R=!0}=t,{enablePresets:P=!0}=t,{enablePicker:I=!0}=t,{enableInput:E=!1}=t,{enableEyeDropper:M=!1}=t,A="transparent",F="transparent";const L=(e,t)=>{if(d=[e[0],e[1],e[2]],t){let t=RGBToHSV(...d),r=t[0],n=t[1],i=t[2];isNumber(V)&&(r=V),isNumber(B)&&(n=B),isNumber(N)&&(i=N),o(16,l=r),o(36,c=n),o(37,u=i),o(17,p=isNumber(e[3])?e[3]:1)}o(18,h=colorArrayToRGBA(e)),o(19,m=colorArrayToRGBA([...d,0])),o(20,A=colorArrayToRGBA([...d,1])),o(21,F=colorArrayToRGBA(HSVToRGB(l,1,1)))},D=()=>{const e=[...HSVToRGB(l,c,u),p];L(e),C(e)},z=e=>{const t=3===e.length?[...e,1]:e;O(),L(t,!0),C(t)},O=()=>{B=void 0,N=void 0,V=void 0};let B,N,V;const W=(e,t)=>{const r=clamp(e.x/t.width,0,1),n=clamp(e.y/t.height,0,1);var i,a;a=1-n,o(36,c=i=r),o(37,u=a),B=i,N=a,D()};let U,H,G,j;const q=e=>{const t=vectorSubtract(vectorCreateFromPointerEvent(e),j);W(vectorAdd(vectorClone(G),t),H)},X=e=>{H=void 0,document.documentElement.removeEventListener("pointermove",q),document.documentElement.removeEventListener("pointerup",X)};let Y;return e.$$set=e=>{"label"in e&&o(0,f=e.label),"name"in e&&o(1,$=e.name),"options"in e&&o(2,b=e.options),"selectedIndex"in e&&o(3,y=e.selectedIndex),"value"in e&&o(4,_=e.value),"buttonClass"in e&&o(5,x=e.buttonClass),"optionLabelClass"in e&&o(6,v=e.optionLabelClass),"optionMapper"in e&&o(7,S=e.optionMapper),"onchange"in e&&o(34,C=e.onchange),"title"in e&&o(8,w=e.title),"hidePresetLabel"in e&&o(9,T=e.hidePresetLabel),"locale"in e&&o(10,k=e.locale),"enableOpacity"in e&&o(11,R=e.enableOpacity),"enablePresets"in e&&o(12,P=e.enablePresets),"enablePicker"in e&&o(13,I=e.enablePicker),"enableInput"in e&&o(14,E=e.enableInput),"enableEyeDropper"in e&&o(35,M=e.enableEyeDropper)},e.$$.update=()=>{16&e.$$.dirty[1]&&o(15,r=M&&supportsEyeDropper()),16&e.$$.dirty[0]|128&e.$$.dirty[1]&&(!_||g&&arrayEqual(_,g)||(o(38,g=[..._]),L(_,!0))),32&e.$$.dirty[1]&&o(25,n=100*c),64&e.$$.dirty[1]&&o(24,i=100-100*u),256&e.$$.dirty[1]&&o(40,a=!!Y&&(Y.length>=4&&Y.length<=5)),51216&e.$$.dirty[0]|512&e.$$.dirty[1]&&o(23,s=(E||r)&&_?((e,t,o)=>{let r=e.map((e=>Math.round(255*e).toString(16).toLowerCase().padStart(2,"0")));return(!t&&r.length>3||"ff"===r[3])&&r.pop(),o&&(r=r.map((e=>e.substring(0,1)))),`#${r.join("")}`})(_,R,a):void 0)},[f,$,b,y,_,x,v,S,w,T,k,R,P,I,E,r,l,p,h,m,A,F,U,s,i,n,z,e=>{o(16,l=e),V=e,D()},e=>{o(17,p=e),D()},e=>{e.stopPropagation(),H=sizeCreate(U.offsetWidth,U.offsetHeight),G=vectorCreateFromPointerEventOffset(e),j=vectorCreateFromPointerEvent(e),W(G,H),document.documentElement.addEventListener("pointermove",q),document.documentElement.addEventListener("pointerup",X)},e=>{H=sizeCreate(U.offsetWidth,U.offsetHeight);const t=n/100*H.width,o=i/100*H.height;W({x:t+e.detail.x,y:o+e.detail.y},H)},e=>{const{value:t}=e.target,r=t.length;if(!t.startsWith("#")||r<4||6===r||8===r||r>9)return;if(!R&&r>7)return;const n=colorStringToColorArray(t);n&&(o(39,Y=t),O(),L(n),C(n))},e=>{e.stopPropagation()},e=>{(new EyeDropper).open().then((({sRGBHex:e})=>{const t=colorStringToColorArray(e);t&&(t[3]=1,o(39,Y=_),O(),L(t),C(t))})).catch((e=>{}))},C,M,c,u,g,Y,a,function(e){binding_callbacks[e?"unshift":"push"]((()=>{U=e,o(22,U)}))},([e,t])=>[e,isFunction(t)?t(k):t],e=>z(e.value)]}class ColorPicker extends SvelteComponent{constructor(e){super(),init(this,e,instance$D,create_fragment$C,safe_not_equal,{label:0,name:1,options:2,selectedIndex:3,value:4,buttonClass:5,optionLabelClass:6,optionMapper:7,onchange:34,title:8,hidePresetLabel:9,locale:10,enableOpacity:11,enablePresets:12,enablePicker:13,enableInput:14,enableEyeDropper:35},null,[-1,-1])}}function create_fragment$B(e){let t,o,r;return o=new DynamicComponentTree_1({props:{items:e[0]}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"class","PinturaShorthandControl PinturaShapeStyle")},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,[t]){const r={};1&t&&(r.items=e[0]),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function instance$C(e,t,o){let r,n,{value:i}=t,{onchange:a}=t,{controls:s=[]}=t;return e.$$set=e=>{o(6,t=assign(assign({},t),exclude_internal_props(e))),"value"in e&&o(1,i=e.value),"onchange"in e&&o(2,a=e.onchange),"controls"in e&&o(3,s=e.controls)},e.$$.update=()=>{o(4,r=(e=>{const{controls:t,...o}=e;return o})(t)),30&e.$$.dirty&&o(0,n=s.map(((e,t)=>{const[o,n,s]=e;return[o,n,{...r,...s,value:i[t],onchange:e=>{const o=[...i];o[t]=e,a(o)}}]})))},t=exclude_internal_props(t),[n,i,a,s,r]}class ShorthandControl extends SvelteComponent{constructor(e){super(),init(this,e,instance$C,create_fragment$B,safe_not_equal,{value:1,onchange:2,controls:3})}}function create_fragment$A(e){let t,o;return t=new Dropdown({props:{label:e[4],options:e[1],title:e[2],selectedIndex:e[5],onchange:e[10]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,[o]){const r={};16&o&&(r.label=e[4]),2&o&&(r.options=e[1]),4&o&&(r.title=e[2]),32&o&&(r.selectedIndex=e[5]),9&o&&(r.onchange=e[10]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function instance$B(e,t,o){let r,n,i,a,{options:s}=t,{title:l}=t,{onchange:c}=t,{selectedIndex:u=-1}=t,{value:p}=t,{label:d}=t;return e.$$set=e=>{"options"in e&&o(1,s=e.options),"title"in e&&o(2,l=e.title),"onchange"in e&&o(3,c=e.onchange),"selectedIndex"in e&&o(0,u=e.selectedIndex),"value"in e&&o(6,p=e.value),"label"in e&&o(7,d=e.label)},e.$$.update=()=>{67&e.$$.dirty&&o(9,r=((e,t,o)=>{if(e)return t>-1?e[t]:void 0!==o?e.find((e=>e[0]===o)):e[0]})(s,u,p)),514&e.$$.dirty&&o(5,n=s&&s.findIndex((e=>e===r))),512&e.$$.dirty&&o(8,i=r&&r[1]),384&e.$$.dirty&&o(4,a=d||i)},[u,s,l,c,a,n,p,d,i,r,e=>{o(0,u=e.index),c&&c(e)}]}class Select extends SvelteComponent{constructor(e){super(),init(this,e,instance$B,create_fragment$A,safe_not_equal,{options:1,title:2,onchange:3,selectedIndex:0,value:6,label:7})}}function get_each_context$4(e,t,o){const r=e.slice();return r[9]=t[o][0],r[0]=t[o][1],r[10]=t[o][2],r[2]=t[o][3],r}function create_else_block$7(e){let t,o,r;const n=[e[10]];var i=e[3][e[9]]||e[9];function a(e){let t={};for(let e=0;e<n.length;e+=1)t=assign(t,n[e]);return{props:t}}return i&&(t=construct_svelte_component(i,a())),{c(){t&&create_component(t.$$.fragment),o=empty()},m(e,n){t&&mount_component(t,e,n),insert(e,o,n),r=!0},p(e,r){const s=4&r?get_spread_update(n,[get_spread_object(e[10])]):{};if(i!==(i=e[3][e[9]]||e[9])){if(t){group_outros();const e=t;transition_out(e.$$.fragment,1,0,(()=>{destroy_component(e,1)})),check_outros()}i?(t=construct_svelte_component(i,a()),create_component(t.$$.fragment),transition_in(t.$$.fragment,1),mount_component(t,o.parentNode,o)):t=null}else i&&t.$set(s)},i(e){r||(t&&transition_in(t.$$.fragment,e),r=!0)},o(e){t&&transition_out(t.$$.fragment,e),r=!1},d(e){e&&detach(o),t&&destroy_component(t,e)}}}function create_if_block$e(e){let t,o=e[9],r=e[9]&&create_dynamic_element(e);return{c(){r&&r.c(),t=empty()},m(e,o){r&&r.m(e,o),insert(e,t,o)},p(e,n){e[9]?o?safe_not_equal(o,e[9])?(r.d(1),r=create_dynamic_element(e),r.c(),r.m(t.parentNode,t)):r.p(e,n):(r=create_dynamic_element(e),r.c(),r.m(t.parentNode,t)):o&&(r.d(1),r=null),o=e[9]},i:noop,o(e){transition_out(r)},d(e){e&&detach(t),r&&r.d(e)}}}function create_if_block_3$5(e){let t,o,r=e[10].innerHTML+"";return{c(){t=new HtmlTag(!1),o=empty(),t.a=o},m(e,n){t.m(r,e,n),insert(e,o,n)},p(e,o){4&o&&r!==(r=e[10].innerHTML+"")&&t.p(r)},i:noop,o:noop,d(e){e&&detach(o),e&&t.d()}}}function create_if_block_2$7(e){let t,o=e[10].textContent+"";return{c(){t=text(o)},m(e,o){insert(e,t,o)},p(e,r){4&r&&o!==(o=e[10].textContent+"")&&set_data(t,o)},i:noop,o:noop,d(e){e&&detach(t)}}}function create_if_block_1$a(e){let t,o;return t=new DynamicComponentTree_1({props:{items:e[2],discardEmptyItems:!0}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};4&o&&(r.items=e[2]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_dynamic_element(e){let t,o,r,n,i;const a=[create_if_block_1$a,create_if_block_2$7,create_if_block_3$5],s=[];function l(e,t){return e[2]&&e[2].length?0:e[10].textContent?1:e[10].innerHTML?2:-1}~(o=l(e))&&(r=s[o]=a[o](e));let c=[e[4](e[10])],u={};for(let e=0;e<c.length;e+=1)u=assign(u,c[e]);return{c(){t=element(e[9]),r&&r.c(),n=space(),/-/.test(e[9])?set_custom_element_data_map(t,u):set_attributes(t,u)},m(e,r){insert(e,t,r),~o&&s[o].m(t,null),append(t,n),i=!0},p(e,i){let p=o;o=l(e),o===p?~o&&s[o].p(e,i):(r&&(group_outros(),transition_out(s[p],1,1,(()=>{s[p]=null})),check_outros()),~o?(r=s[o],r?r.p(e,i):(r=s[o]=a[o](e),r.c()),transition_in(r,1),r.m(t,n)):r=null),u=get_spread_update(c,[4&i&&e[4](e[10])]),/-/.test(e[9])?set_custom_element_data_map(t,u):set_attributes(t,u)},i(e){i||(transition_in(r),i=!0)},o(e){transition_out(r),i=!1},d(e){e&&detach(t),~o&&s[o].d()}}}function create_each_block$4(e,t){let o,r,n,i,a,s;const l=[create_if_block$e,create_else_block$7],c=[];function u(e,t){return 4&t&&(r=null),null==r&&(r=!e[5](e[9])),r?0:1}return n=u(t,-1),i=c[n]=l[n](t),{key:e,first:null,c(){o=empty(),i.c(),a=empty(),this.first=o},m(e,t){insert(e,o,t),c[n].m(e,t),insert(e,a,t),s=!0},p(e,o){let r=n;n=u(t=e,o),n===r?c[n].p(t,o):(group_outros(),transition_out(c[r],1,1,(()=>{c[r]=null})),check_outros(),i=c[n],i?i.p(t,o):(i=c[n]=l[n](t),i.c()),transition_in(i,1),i.m(a.parentNode,a))},i(e){s||(transition_in(i),s=!0)},o(e){transition_out(i),s=!1},d(e){e&&detach(o),c[n].d(e),e&&detach(a)}}}function create_fragment$z(e){let t,o,r=[],n=new Map,i=e[2];const a=e=>e[0]+e[1];for(let t=0;t<i.length;t+=1){let o=get_each_context$4(e,i,t),s=a(o);n.set(s,r[t]=create_each_block$4(s,o))}return{c(){for(let e=0;e<r.length;e+=1)r[e].c();t=empty()},m(e,n){for(let t=0;t<r.length;t+=1)r[t].m(e,n);insert(e,t,n),o=!0},p(e,[o]){62&o&&(i=e[2],group_outros(),r=update_keyed_each(r,o,a,1,e,i,n,t.parentNode,outro_and_destroy_block,create_each_block$4,t,get_each_context$4),check_outros())},i(e){if(!o){for(let e=0;e<i.length;e+=1)transition_in(r[e]);o=!0}},o(e){for(let e=0;e<r.length;e+=1)transition_out(r[e]);o=!1},d(e){for(let t=0;t<r.length;t+=1)r[t].d(e);e&&detach(t)}}}function instance$A(e,t,o){let r,n,{items:i}=t,{discardEmptyItems:a=!0}=t,{key:s=""}=t;const l={Button:Button,ImageButton:ImageButton,ImageButtonList:ImageButtonList,Dropdown:Dropdown,Select:Select,RadioGroup:RadioGroup,Input:Input,Panel:DynamicPanel,ProgressIndicator:ProgressIndicator,ShapeStyle:ShapeStyle,ToggleSlider:ToggleSlider,ColorPicker:ColorPicker,ShorthandControl:ShorthandControl},c=e=>!isString(e)||!!l[e],u=e=>{if(!e)return!1;const[t,,o,r=[]]=e;return!!c(t)||(r.some(u)||o.textContent||o.innerHTML)};return e.$$set=e=>{"items"in e&&o(6,i=e.items),"discardEmptyItems"in e&&o(7,a=e.discardEmptyItems),"key"in e&&o(0,s=e.key)},e.$$.update=()=>{1&e.$$.dirty&&o(1,r=s),192&e.$$.dirty&&o(2,n=(i&&a?i.filter(u):i)||[])},[s,r,n,l,(e={})=>{const{textContent:t,innerHTML:o,...r}=e;return r},c,i,a]}class DynamicComponentTree_1 extends SvelteComponent{constructor(e){super(),init(this,e,instance$A,create_fragment$z,safe_not_equal,{items:6,discardEmptyItems:7,key:0})}get items(){return this.$$.ctx[6]}set items(e){this.$$set({items:e}),flush()}get discardEmptyItems(){return this.$$.ctx[7]}set discardEmptyItems(e){this.$$set({discardEmptyItems:e}),flush()}get key(){return this.$$.ctx[0]}set key(e){this.$$set({key:e}),flush()}}function create_if_block_1$9(e){let t,o;return t=new Icon({props:{class:"PinturaButtonIcon",$$slots:{default:[create_default_slot$c]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};536870920&o&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot$c(e){let t;return{c(){t=svg_element("g")},m(o,r){insert(o,t,r),t.innerHTML=e[3]},p(e,o){8&o&&(t.innerHTML=e[3])},d(e){e&&detach(t)}}}function create_else_block$6(e){let t;return{c(){t=element("span"),attr(t,"class",e[11])},m(o,r){insert(o,t,r),t.innerHTML=e[0]},p(e,o){1&o&&(t.innerHTML=e[0]),2048&o&&attr(t,"class",e[11])},i:noop,o:noop,d(e){e&&detach(t)}}}function create_if_block$d(e){let t,o,r;return o=new DynamicComponentTree_1({props:{items:e[0]}}),{c(){t=element("span"),create_component(o.$$.fragment),attr(t,"class",e[11])},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,n){const i={};1&n&&(i.items=e[0]),o.$set(i),(!r||2048&n)&&attr(t,"class",e[11])},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function fallback_block$1(e){let t,o,r,n,i,a,s=e[3]&&create_if_block_1$9(e);const l=[create_if_block$d,create_else_block$6],c=[];function u(e,t){return 1&t&&(r=null),null==r&&(r=!!isArray(e[0])),r?0:1}return n=u(e,-1),i=c[n]=l[n](e),{c(){t=element("span"),s&&s.c(),o=space(),i.c(),attr(t,"class",e[13])},m(e,r){insert(e,t,r),s&&s.m(t,null),append(t,o),c[n].m(t,null),a=!0},p(e,r){e[3]?s?(s.p(e,r),8&r&&transition_in(s,1)):(s=create_if_block_1$9(e),s.c(),transition_in(s,1),s.m(t,o)):s&&(group_outros(),transition_out(s,1,1,(()=>{s=null})),check_outros());let p=n;n=u(e,r),n===p?c[n].p(e,r):(group_outros(),transition_out(c[p],1,1,(()=>{c[p]=null})),check_outros(),i=c[n],i?i.p(e,r):(i=c[n]=l[n](e),i.c()),transition_in(i,1),i.m(t,null)),(!a||8192&r)&&attr(t,"class",e[13])},i(e){a||(transition_in(s),transition_in(i),a=!0)},o(e){transition_out(s),transition_out(i),a=!1},d(e){e&&detach(t),s&&s.d(),c[n].d()}}}function create_fragment$y(e){let t,o,r,n,i,a;const s=e[27].default,l=create_slot(s,e,e[29],null),c=l||fallback_block$1(e);return{c(){t=element("button"),c&&c.c(),attr(t,"type",e[6]),t.disabled=e[5],attr(t,"class",e[12]),attr(t,"title",o=toTitle(e[0],e[1],e[2]))},m(o,s){insert(o,t,s),c&&c.m(t,null),e[28](t),n=!0,i||(a=[listen(t,"keydown",(function(){is_function(e[8])&&e[8].apply(this,arguments)})),listen(t,"click",(function(){is_function(e[7])&&e[7].apply(this,arguments)})),listen(t,"pointerdown",(function(){is_function(e[14])&&e[14].apply(this,arguments)})),action_destroyer(r=styleable.call(null,t,e[4])),action_destroyer(e[9].call(null,t))],i=!0)},p(i,[a]){e=i,l?l.p&&(!n||536870912&a)&&update_slot_base(l,s,e,e[29],n?get_slot_changes(s,e[29],a,null):get_all_dirty_from_scope(e[29]),null):c&&c.p&&(!n||10249&a)&&c.p(e,n?a:-1),(!n||64&a)&&attr(t,"type",e[6]),(!n||32&a)&&(t.disabled=e[5]),(!n||4096&a)&&attr(t,"class",e[12]),(!n||7&a&&o!==(o=toTitle(e[0],e[1],e[2])))&&attr(t,"title",o),r&&is_function(r.update)&&16&a&&r.update.call(null,e[4])},i(e){n||(transition_in(c,e),n=!0)},o(e){transition_out(c,e),n=!1},d(o){o&&detach(t),c&&c.d(o),e[28](null),i=!1,run_all(a)}}}function instance$z(e,t,o){let r,n,i,a,s,l,{$$slots:c={},$$scope:u}=t,{class:p}=t,{label:d}=t,{title:h}=t,{shortcut:m}=t,{labelClass:g}=t,{innerClass:f}=t,{hideLabel:$=!1}=t,{icon:b}=t,{style:y}=t,{disabled:_}=t,{type:x="button"}=t,{onclick:v}=t,{onkeydown:S}=t,{onhold:C}=t,{action:w=()=>{}}=t,{holdThreshold:T=500}=t,{holdSpeedUpFactor:k=.5}=t,{holdSpeedMin:R=20}=t;const P=e=>{o(25,l=setTimeout((()=>{C(),P(Math.max(e*k,R))}),e))};let I;return e.$$set=e=>{"class"in e&&o(15,p=e.class),"label"in e&&o(0,d=e.label),"title"in e&&o(1,h=e.title),"shortcut"in e&&o(2,m=e.shortcut),"labelClass"in e&&o(16,g=e.labelClass),"innerClass"in e&&o(17,f=e.innerClass),"hideLabel"in e&&o(18,$=e.hideLabel),"icon"in e&&o(3,b=e.icon),"style"in e&&o(4,y=e.style),"disabled"in e&&o(5,_=e.disabled),"type"in e&&o(6,x=e.type),"onclick"in e&&o(7,v=e.onclick),"onkeydown"in e&&o(8,S=e.onkeydown),"onhold"in e&&o(19,C=e.onhold),"action"in e&&o(9,w=e.action),"holdThreshold"in e&&o(20,T=e.holdThreshold),"holdSpeedUpFactor"in e&&o(21,k=e.holdSpeedUpFactor),"holdSpeedMin"in e&&o(22,R=e.holdSpeedMin),"$$scope"in e&&o(29,u=e.$$scope)},e.$$.update=()=>{101187584&e.$$.dirty&&o(26,n=C?()=>{l&&(clearTimeout(l),o(25,l=void 0),document.documentElement.removeEventListener("pointerup",n))}:noop$1),68681728&e.$$.dirty&&o(14,r=C?()=>{document.documentElement.addEventListener("pointerup",n),P(T)}:noop$1),131072&e.$$.dirty&&o(13,i=arrayJoin(["PinturaButtonInner",f])),294912&e.$$.dirty&&o(12,a=arrayJoin(["PinturaButton",$&&"PinturaButtonIconOnly",p])),327680&e.$$.dirty&&o(11,s=arrayJoin([$?"implicit":"PinturaButtonLabel",g]))},[d,h,m,b,y,_,x,v,S,w,I,s,a,i,r,p,g,f,$,C,T,k,R,e=>_isEventTarget(e,I),()=>I,l,n,c,function(e){binding_callbacks[e?"unshift":"push"]((()=>{I=e,o(10,I)}))},u]}class Button extends SvelteComponent{constructor(e){super(),init(this,e,instance$z,create_fragment$y,safe_not_equal,{class:15,label:0,title:1,shortcut:2,labelClass:16,innerClass:17,hideLabel:18,icon:3,style:4,disabled:5,type:6,onclick:7,onkeydown:8,onhold:19,action:9,holdThreshold:20,holdSpeedUpFactor:21,holdSpeedMin:22,isEventTarget:23,getElement:24})}get isEventTarget(){return this.$$.ctx[23]}get getElement(){return this.$$.ctx[24]}}var arrayRemove=(e,t)=>{const o=e.findIndex(t);if(o>=0)return e.splice(o,1)};const INERTIA_THRESHOLD=.25,INERTIA_DISTANCE_MULTIPLIER=50,INERTIA_DURATION_MULTIPLIER=80,TAP_DURATION_MAX=300,TAP_DISTANCE_MAX=64,DOUBLE_TAP_DURATION_MAX=700,DOUBLE_TAP_DISTANCE_MAX=128,isContextMenuAction=e=>isNumber(e.button)&&0!==e.button;var interactable=(e,t={})=>{const{inertia:o=!1,inertiaDurationMultiplier:r=INERTIA_DURATION_MULTIPLIER,shouldStartInteraction:n=()=>!0,pinch:i=!1,multiTouch:a,getEventPosition:s=e=>vectorCreate(e.clientX,e.clientY),observeKeys:l=!1}=t;function c(t,o){e.dispatchEvent(new CustomEvent(t,{detail:o}))}function u(){C&&C(),C=void 0}const p=[],d=e=>0===e.timeStamp?Date.now():e.timeStamp,h=e=>{const t=arrayRemove(p,(t=>t.event.pointerId===e.pointerId));if(t)return t[0]},m=()=>{const e=vectorClone(p[0].position);if(p[1]){const t=.5*(p[1].position.x-e.x),o=.5*(p[1].position.y-e.y);e.x+=t,e.y+=o}return e},g=e=>{e.origin.x=e.position.x,e.origin.y=e.position.y,e.translation.x=0,e.translation.y=0},f=e=>{const t=$(e);if(!t)return;const o=d(e),r=s(e),n=Math.max(1,o-t.timeStamp);t.velocity.x=(r.x-t.position.x)/n,t.velocity.y=(r.y-t.position.y)/n,t.velocityHistory.push(vectorClone(t.velocity)),t.velocityHistory=t.velocityHistory.slice(-3),t.velocityAverage=t.velocityHistory.reduce(((e,t,o,r)=>(e.x+=t.x/r.length,e.y+=t.y/r.length,e)),vectorCreateEmpty()),t.translation.x=r.x-t.origin.x,t.translation.y=r.y-t.origin.y,t.timeStamp=o,t.position.x=r.x,t.position.y=r.y,t.event=e},$=e=>{const t=(e=>p.findIndex((t=>t.event.pointerId===e.pointerId)))(e);if(!(t<0))return p[t]},b=()=>1===p.length,y=()=>2===p.length,_=e=>{const t=vectorCenter(e.map((e=>e.position))),o=((e,t)=>e.reduce(((e,o)=>e+vectorDistance(t,o.position)),0)/e.length)(e,t);return{center:t,distance:o,velocity:vectorCenter(e.map((e=>e.velocity))),translation:vectorCenter(e.map((e=>e.translation)))}};let x,v,S,C,w,T,k,R,P,I=0;e.addEventListener("pointerdown",L);const E=["Meta","Control","Alt","Shift"];function M(e){if(!E.includes(e.key))return;const{metaKey:t,ctrlKey:o,altKey:r,shiftKey:n}=e;F({metaKey:t,ctrlKey:o,altKey:r,shiftKey:n})}let A=Date.now();const F=e=>{const t=vectorClone(p[0].translation);let o=k;if(i&&y()){o*=vectorDistance(p[0].position,p[1].position)/w,vectorAdd(t,p[1].translation)}vectorAdd(t,T);const r=Date.now();r-A<16||(A=r,c("interactionupdate",{position:m(),translation:t,scalar:i?o:void 0,isMultiTouching:y(),...e}))};function L(t){if(!y()&&!isContextMenuAction(t)&&n(t,e))if(u(),(e=>{const t=d(e),o={timeStamp:t,timeStampInitial:t,position:s(e),origin:s(e),velocity:vectorCreateEmpty(),velocityHistory:[],velocityAverage:vectorCreateEmpty(),translation:vectorCreateEmpty(),interactionState:void 0,event:e};p.push(o),o.interactionState=_(p)})(t),l&&(window.addEventListener("keydown",M),window.addEventListener("keyup",M)),b())document.documentElement.addEventListener("pointermove",D),document.documentElement.addEventListener("pointerup",z),document.documentElement.addEventListener("pointercancel",z),document.addEventListener("visibilitychange",B),R=!1,k=1,T=vectorCreateEmpty(),w=void 0,c("interactionstart",{origin:vectorClone($(t).origin)});else if(i)R=!0,w=vectorDistance(p[0].position,p[1].position),T.x+=p[0].translation.x,T.y+=p[0].translation.y,g(p[0]);else if(!1===a)return p.length=0,V(),c("interactioncancel")}function D(e){e.preventDefault(),f(e);const{metaKey:t=!1,ctrlKey:o=!1,altKey:r=!1,shiftKey:n=!1}=l?e:{};F({metaKey:t,ctrlKey:o,altKey:r,shiftKey:n})}function z(e){if(!$(e))return;const t=m(),n=h(e);if(i&&b()){const e=vectorDistance(p[0].position,n.position);k*=e/w,T.x+=p[0].translation.x+n.translation.x,T.y+=p[0].translation.y+n.translation.y,g(p[0])}let a=!1,s=!1;if(!R&&n){const e=performance.now(),t=e-n.timeStampInitial,o=vectorDistanceSquared(n.translation);a=o<64&&t<300,s=!!(P&&a&&e-I<700&&vectorDistanceSquared(P,n.position)<128),a&&(P=vectorClone(n.position),I=e)}if(p.length>0)return;V();const l=vectorClone(n.translation),u=vectorClone(n.velocityAverage);let d=!1;c("interactionrelease",{isTap:a,isDoubleTap:s,position:t,translation:l,scalar:k,preventInertia:()=>d=!0});const f=vectorDistance(u);if(d||!o||f<.25)return N(l,{isTap:a,isDoubleTap:s});v=vectorClone(t),S=vectorClone(l),x=tweened(vectorClone(l),{easing:circOut,duration:f*r}),x.set({x:l.x+50*u.x,y:l.y+50*u.y}).then((()=>{C&&N(get_store_value(x),{isTap:a,isDoubleTap:s})})),C=x.subscribe(O)}function O(e){e&&c("interactionupdate",{position:vectorCreate(v.x+(e.x-S.x),v.y+(e.y-S.y)),translation:e,scalar:i?k:void 0})}function B(e){if("visible"===document.visibilityState||!p.length)return;const t=_(p);u(),c("interactionend",{...t}),p.length=0,V()}function N(e,t){u(),c("interactionend",{...t,translation:e,scalar:i?k:void 0})}function V(){l&&window.removeEventListener("keydown",M),l&&window.removeEventListener("keyup",M),document.documentElement.removeEventListener("pointermove",D),document.documentElement.removeEventListener("pointerup",z),document.documentElement.removeEventListener("pointercancel",z),document.addEventListener("visibilitychange",B)}return{destroy(){u(),e.removeEventListener("pointerdown",L)}}};function elastify(e,t){return t?t*Math.sign(e)*Math.log10(1+Math.abs(e)/t):e}const elastifyRects=(e,t,o)=>{if(!t||!o)return{...e};const r=e.x+elastify(t.x-e.x,o),n=e.x+e.width+elastify(t.x+t.width-(e.x+e.width),o),i=e.y+elastify(t.y-e.y,o);return{x:r,y:i,width:n-r,height:e.y+e.height+elastify(t.y+t.height-(e.y+e.height),o)-i}},elastifyVectors=(e,t,o)=>t&&o?vectorCreate(e.x+elastify(t.x-e.x,o),e.y+elastify(t.y-e.y,o)):{...e};var unitToPixels=(e,t)=>{if(e)return/em/.test(e)?16*parseInt(e,10):/px/.test(e)?parseInt(e,10):void 0},getWheelDelta=(e,t)=>{let o=e.detail||0;const{deltaX:r,deltaY:n,wheelDelta:i,wheelDeltaX:a,wheelDeltaY:s}=e,{fixScrollDirection:l=!1}=t||{};return isNumber(a)&&Math.abs(a)>Math.abs(s)?o=a/-120:isNumber(r)&&Math.abs(r)>Math.abs(n)?o=r/20:(i||s)&&(o=(i||s)/-120),o||(o=n/20),(isFirefox()||isSafari())&&(o*=2),l&&isMac()&&(o*=-1),o};function create_fragment$x(e){let t,o,r,n,i,a,s;const l=e[38].default,c=create_slot(l,e,e[37],null);return{c(){t=element("div"),o=element("div"),c&&c.c(),set_style(o,"transform",e[6]),attr(t,"class",r=arrayJoin(["PinturaScrollable",e[0]])),attr(t,"data-direction",e[1]),attr(t,"data-state",e[7]),set_style(t,"--scrollable-feather-start-opacity",e[4]),set_style(t,"--scrollable-feather-end-opacity",e[5])},m(r,l){insert(r,t,l),append(t,o),c&&c.m(o,null),e[40](t),i=!0,a||(s=[listen(o,"interactionstart",e[10]),listen(o,"interactionupdate",e[12]),listen(o,"interactionend",e[13]),listen(o,"interactionrelease",e[11]),action_destroyer(interactable.call(null,o,{inertia:!0})),listen(o,"measure",e[39]),action_destroyer(measurable.call(null,o)),listen(t,"wheel",e[15],{passive:!1}),listen(t,"scroll",e[17]),listen(t,"focusin",e[16]),listen(t,"nudge",e[18]),listen(t,"measure",e[14]),action_destroyer(measurable.call(null,t,{observePosition:!0})),action_destroyer(n=nudgeable.call(null,t,{direction:"x"===e[1]?"horizontal":"vertical",stopKeydownPropagation:!1}))],a=!0)},p(e,a){c&&c.p&&(!i||64&a[1])&&update_slot_base(c,l,e,e[37],i?get_slot_changes(l,e[37],a,null):get_all_dirty_from_scope(e[37]),null),64&a[0]&&set_style(o,"transform",e[6]),(!i||1&a[0]&&r!==(r=arrayJoin(["PinturaScrollable",e[0]])))&&attr(t,"class",r),(!i||2&a[0])&&attr(t,"data-direction",e[1]),(!i||128&a[0])&&attr(t,"data-state",e[7]),n&&is_function(n.update)&&2&a[0]&&n.update.call(null,{direction:"x"===e[1]?"horizontal":"vertical",stopKeydownPropagation:!1}),16&a[0]&&set_style(t,"--scrollable-feather-start-opacity",e[4]),32&a[0]&&set_style(t,"--scrollable-feather-end-opacity",e[5])},i(e){i||(transition_in(c,e),i=!0)},o(e){transition_out(c,e),i=!1},d(o){o&&detach(t),c&&c.d(o),e[40](null),a=!1,run_all(s)}}}function instance$y(e,t,o){let r,n,i,a,s,l,c,u,p,{$$slots:d={},$$scope:h}=t;const m=createEventDispatcher();let g,f,$,b,y="idle",_=spring(0);component_subscribe(e,_,(e=>o(36,u=e)));let{class:x}=t,{scrollBlockInteractionDist:v=5}=t,{scrollStep:S=10}=t,{scrollFocusMargin:C=64}=t,{scrollDirection:w="x"}=t,{scrollAutoCancel:T=!1}=t,{elasticity:k=0}=t,{onscroll:R=noop$1}=t,{maskFeatherSize:P}=t,{maskFeatherStartOpacity:I}=t,{maskFeatherEndOpacity:E}=t,{scroll:M}=t;const A=getContext("fixScrollDirection");let F,L,D;component_subscribe(e,A,(e=>o(47,p=e)));let z=!0;const O=_.subscribe((e=>{const t=vectorCreateEmpty();t[w]=e,R(t)})),B=e=>Math.max(Math.min(0,e),$[r]-f[r]);let N,V,W;const U=(e,t={})=>{const{elastic:r=!1,animate:n=!1,preventScrollState:i=!1}=t;Math.abs(e-g)>v&&"idle"===y&&!b&&!i&&o(29,y="scrolling");const a=B(e),s=r&&k&&!b?a+elastify(e-a,k):a;let l=!0;n?l=!1:z||(l=!b),z=!1,_.set(s,{hard:l}).then((e=>{b&&(z=!0)}))};onDestroy((()=>{O()}));return e.$$set=e=>{"class"in e&&o(0,x=e.class),"scrollBlockInteractionDist"in e&&o(22,v=e.scrollBlockInteractionDist),"scrollStep"in e&&o(23,S=e.scrollStep),"scrollFocusMargin"in e&&o(24,C=e.scrollFocusMargin),"scrollDirection"in e&&o(1,w=e.scrollDirection),"scrollAutoCancel"in e&&o(25,T=e.scrollAutoCancel),"elasticity"in e&&o(26,k=e.elasticity),"onscroll"in e&&o(27,R=e.onscroll),"maskFeatherSize"in e&&o(21,P=e.maskFeatherSize),"maskFeatherStartOpacity"in e&&o(19,I=e.maskFeatherStartOpacity),"maskFeatherEndOpacity"in e&&o(20,E=e.maskFeatherEndOpacity),"scroll"in e&&o(28,M=e.scroll),"$$scope"in e&&o(37,h=e.$$scope)},e.$$.update=()=>{if(2&e.$$.dirty[0]&&o(33,r="x"===w?"width":"height"),2&e.$$.dirty[0]&&o(31,n=w.toUpperCase()),8&e.$$.dirty[0]&&o(35,i=F&&getComputedStyle(F)),8&e.$$.dirty[0]|16&e.$$.dirty[1]&&o(34,a=i&&unitToPixels(i.getPropertyValue("--scrollable-feather-size"))),1075314692&e.$$.dirty[0]|44&e.$$.dirty[1]&&null!=u&&$&&null!=a&&f){const e=-1*u/a,t=-($[r]-f[r]-u)/a;o(19,I=clamp(1-e,0,1)),o(20,E=clamp(1-t,0,1)),o(21,P=a),o(4,L=I),o(5,D=E)}268435464&e.$$.dirty[0]&&F&&void 0!==M&&(isNumber(M)?U(M):U(M.scrollOffset,M)),1073741828&e.$$.dirty[0]|4&e.$$.dirty[1]&&o(32,s=$&&f?f[r]>$[r]:void 0),536870912&e.$$.dirty[0]|2&e.$$.dirty[1]&&o(7,l=arrayJoin([y,s?"overflows":void 0])),35&e.$$.dirty[1]&&o(6,c=s?`translate${n}(${u}px)`:"none")},[x,w,f,F,L,D,c,l,_,A,()=>{s&&(V=!1,N=!0,W=vectorCreate(0,0),b=!1,o(29,y="idle"),g=get_store_value(_))},({detail:e})=>{s&&(b=!0,o(29,y="idle"))},({detail:e})=>{s&&(V||N&&(N=!1,vectorDistanceSquared(e.translation)<.1)||(!T||"x"!==w||(e=>{const t=vectorApply(vectorCreate(e.x-W.x,e.y-W.y),Math.abs);W=vectorClone(e);const o=vectorDistanceSquared(t),r=t.x-t.y;return!(o>1&&r<-.5)})(e.translation)?U(g+e.translation[w],{elastic:!0}):V=!0))},({detail:e})=>{if(!s)return;if(V)return;const t=g+e.translation[w],o=B(t);z=!1,_.set(o).then((e=>{b&&(z=!0)}))},({detail:e})=>{o(30,$=e),m("measure",{x:e.x,y:e.y,width:e.width,height:e.height})},e=>{if(!s)return;e.preventDefault(),e.stopPropagation();const t=e.shiftKey,o=getWheelDelta(e,{fixScrollDirection:p})*(t?-1:1),r=get_store_value(_);U(r+o*S,{animate:!0})},e=>{if(!s)return;if(!b)return;let t=e.target;e.target.classList.contains("implicit")&&(t=t.parentNode);const o=t["x"===w?"offsetLeft":"offsetTop"],n=o+t["x"===w?"offsetWidth":"offsetHeight"],i=get_store_value(_),a=C+P;i+o<a?U(-o+a):i+n>$[r]-a&&U($[r]-n-a,{animate:!0})},()=>{o(3,F["x"===w?"scrollLeft":"scrollTop"]=0,F)},({detail:e})=>{if(F.querySelector("[data-focus-visible]"))return;const t=-2*e[w],o=get_store_value(_);U(o+t*S,{animate:!0,preventScrollState:!0})},I,E,P,v,S,C,T,k,R,M,y,$,n,s,r,a,i,u,h,d,e=>o(2,f=e.detail),function(e){binding_callbacks[e?"unshift":"push"]((()=>{F=e,o(3,F)}))}]}class Scrollable extends SvelteComponent{constructor(e){super(),init(this,e,instance$y,create_fragment$x,safe_not_equal,{class:0,scrollBlockInteractionDist:22,scrollStep:23,scrollFocusMargin:24,scrollDirection:1,scrollAutoCancel:25,elasticity:26,onscroll:27,maskFeatherSize:21,maskFeatherStartOpacity:19,maskFeatherEndOpacity:20,scroll:28},null,[-1,-1])}}function create_fragment$w(e){let t,o,r,n,i;return{c(){t=element("span"),attr(t,"class","PinturaStatusMessage")},m(o,a){insert(o,t,a),t.innerHTML=e[0],r=!0,n||(i=[listen(t,"measure",(function(){is_function(e[1])&&e[1].apply(this,arguments)})),action_destroyer(measurable.call(null,t))],n=!0)},p(o,[n]){e=o,(!r||1&n)&&(t.innerHTML=e[0])},i(n){r||(add_render_callback((()=>{o||(o=create_bidirectional_transition(t,e[4],{duration:e[2]},!0)),o.run(1)})),r=!0)},o(n){o||(o=create_bidirectional_transition(t,e[4],{duration:e[2]},!1)),o.run(0),r=!1},d(e){e&&detach(t),e&&o&&o.end(),n=!1,run_all(i)}}}function instance$x(e,t,o){let r,n,{text:i}=t,{onmeasure:a=noop$1}=t;const s=getContext("isAnimated");return component_subscribe(e,s,(e=>o(5,n=e))),e.$$set=e=>{"text"in e&&o(0,i=e.text),"onmeasure"in e&&o(1,a=e.onmeasure)},e.$$.update=()=>{32&e.$$.dirty&&o(2,r=n?500:0)},[i,a,r,s,function(e,{duration:t}){return{duration:t,tick:t=>{e.style.opacity=t}}},n]}class StatusMessage extends SvelteComponent{constructor(e){super(),init(this,e,instance$x,create_fragment$w,safe_not_equal,{text:0,onmeasure:1})}}function create_fragment$v(e){let t,o,r;const n=e[5].default,i=create_slot(n,e,e[4],null);return{c(){t=element("span"),i&&i.c(),attr(t,"class",o=`PinturaStatusAside ${e[1]}`),set_style(t,"transform",e[2]),set_style(t,"opacity",e[0])},m(e,o){insert(e,t,o),i&&i.m(t,null),r=!0},p(e,[a]){i&&i.p&&(!r||16&a)&&update_slot_base(i,n,e,e[4],r?get_slot_changes(n,e[4],a,null):get_all_dirty_from_scope(e[4]),null),(!r||2&a&&o!==(o=`PinturaStatusAside ${e[1]}`))&&attr(t,"class",o),4&a&&set_style(t,"transform",e[2]),1&a&&set_style(t,"opacity",e[0])},i(e){r||(transition_in(i,e),r=!0)},o(e){transition_out(i,e),r=!1},d(e){e&&detach(t),i&&i.d(e)}}}function instance$w(e,t,o){let r,{$$slots:n={},$$scope:i}=t,{offset:a=0}=t,{opacity:s=0}=t,{class:l}=t;return e.$$set=e=>{"offset"in e&&o(3,a=e.offset),"opacity"in e&&o(0,s=e.opacity),"class"in e&&o(1,l=e.class),"$$scope"in e&&o(4,i=e.$$scope)},e.$$.update=()=>{8&e.$$.dirty&&o(2,r=`translateX(${a}px)`)},[s,l,r,a,i,n]}class StatusAside extends SvelteComponent{constructor(e){super(),init(this,e,instance$w,create_fragment$v,safe_not_equal,{offset:3,opacity:0,class:1})}}var cursorMoveToEnd=e=>e.selectionStart=e.selectionEnd=e.value.length;let result$3=null;var supportsVisualViewport=()=>(null===result$3&&(result$3=isBrowser()&&"visualViewport"in window),result$3),createSoftKeyboardObserver=e=>{if(!supportsVisualViewport())return!1;const t=visualViewport.height,o=()=>{e(visualViewport.height<t?"visible":"hidden")};return visualViewport.addEventListener("resize",o),()=>visualViewport.removeEventListener("resize",o)};function create_if_block_1$8(e){let t,o;const r=[{onclick:e[1]},e[3]];let n={};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new Button({props:n}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=10&o[0]?get_spread_update(r,[2&o[0]&&{onclick:e[1]},8&o[0]&&get_spread_object(e[3])]):{};t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block$c(e){let t,o;const r=[{onclick:e[0]},{class:"PinturaInputFormButtonConfirm"},e[2]];let n={};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new Button({props:n}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=5&o[0]?get_spread_update(r,[1&o[0]&&{onclick:e[0]},r[1],4&o[0]&&get_spread_object(e[2])]):{};t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_fragment$u(e){let t,o,r,n,i,a,s,l,c=e[3]&&create_if_block_1$8(e);const u=e[28].default,p=create_slot(u,e,e[27],null);let d=e[2]&&create_if_block$c(e);return{c(){t=element("div"),o=element("div"),c&&c.c(),r=space(),n=element("div"),p&&p.c(),i=space(),d&&d.c(),attr(n,"class","PinturaInputFormFields"),attr(o,"class","PinturaInputFormInner"),attr(t,"class","PinturaInputForm"),attr(t,"data-layout",e[4]),set_style(t,"opacity",e[6]),set_style(t,"left",e[7]),set_style(t,"top",e[8]),set_style(t,"right",e[9]),set_style(t,"bottom",e[10])},m(u,h){insert(u,t,h),append(t,o),c&&c.m(o,null),append(o,r),append(o,n),p&&p.m(n,null),append(o,i),d&&d.m(o,null),e[29](t),a=!0,s||(l=[listen(n,"keydown",e[14]),listen(t,"focusin",e[11]),listen(t,"focusout",e[12]),listen(t,"measure",e[13]),action_destroyer(measurable.call(null,t))],s=!0)},p(e,n){e[3]?c?(c.p(e,n),8&n[0]&&transition_in(c,1)):(c=create_if_block_1$8(e),c.c(),transition_in(c,1),c.m(o,r)):c&&(group_outros(),transition_out(c,1,1,(()=>{c=null})),check_outros()),p&&p.p&&(!a||134217728&n[0])&&update_slot_base(p,u,e,e[27],a?get_slot_changes(u,e[27],n,null):get_all_dirty_from_scope(e[27]),null),e[2]?d?(d.p(e,n),4&n[0]&&transition_in(d,1)):(d=create_if_block$c(e),d.c(),transition_in(d,1),d.m(o,null)):d&&(group_outros(),transition_out(d,1,1,(()=>{d=null})),check_outros()),(!a||16&n[0])&&attr(t,"data-layout",e[4]),64&n[0]&&set_style(t,"opacity",e[6]),128&n[0]&&set_style(t,"left",e[7]),256&n[0]&&set_style(t,"top",e[8]),512&n[0]&&set_style(t,"right",e[9]),1024&n[0]&&set_style(t,"bottom",e[10])},i(e){a||(transition_in(c),transition_in(p,e),transition_in(d),a=!0)},o(e){transition_out(c),transition_out(p,e),transition_out(d),a=!1},d(o){o&&detach(t),c&&c.d(),p&&p.d(o),d&&d.d(),e[29](null),s=!1,run_all(l)}}}const panelDelay=200;function instance$v(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,{$$slots:m={},$$scope:g}=t,{onconfirm:f}=t,{oncancel:$}=t,{autoFocus:b=!0}=t,{autoPositionCursor:y=!0}=t,{buttonConfirm:_}=t,{buttonCancel:x}=t,{layout:v="stack"}=t,{parentRect:S}=t,{align:C}=t,{justify:w}=t,{parentMargin:T=16}=t,{panelOffset:k=vectorCreateEmpty()}=t,R=!1,P={top:void 0,bottom:void 0},I=0;const E=()=>{const e=h.querySelector("input, textarea");e.focus(),I>=1||e.select()},M=()=>{R=!0,F||!isIOS()&&!isAndroid()||o(23,P={top:"1em",bottom:"auto"}),isIOS()&&(e=>{let t;const o=e=>t=e.touches[0].screenY,r=e=>{const o=e.touches[0].screenY,r=e.target;/textarea/i.test(r.nodeName)?(o>t?0==r.scrollTop&&e.preventDefault():o<t?r.scrollTop+r.offsetHeight==r.scrollHeight&&e.preventDefault():e.preventDefault(),t=o):e.preventDefault()};e.addEventListener("touchstart",o),e.addEventListener("touchmove",r)})(h),o(6,I=1)};let A;const F=createSoftKeyboardObserver((e=>{a?"hidden"!==e||R?(clearTimeout(l),l=void 0,o(23,P={top:visualViewport.height-s.height-k.y+"px"}),"visible"===e?(o(5,h.dataset.stick=!0,h),E(),M()):(R=!1,o(6,I=0))):E():o(23,P={top:"4.5em",bottom:"auto"})}));return onMount((()=>{b&&E()})),onDestroy((()=>{F&&F()})),e.$$set=e=>{"onconfirm"in e&&o(0,f=e.onconfirm),"oncancel"in e&&o(1,$=e.oncancel),"autoFocus"in e&&o(15,b=e.autoFocus),"autoPositionCursor"in e&&o(16,y=e.autoPositionCursor),"buttonConfirm"in e&&o(2,_=e.buttonConfirm),"buttonCancel"in e&&o(3,x=e.buttonCancel),"layout"in e&&o(4,v=e.layout),"parentRect"in e&&o(17,S=e.parentRect),"align"in e&&o(18,C=e.align),"justify"in e&&o(19,w=e.justify),"parentMargin"in e&&o(20,T=e.parentMargin),"panelOffset"in e&&o(21,k=e.panelOffset),"$$scope"in e&&o(27,g=e.$$scope)},e.$$.update=()=>{4325376&e.$$.dirty[0]&&o(26,r=S&&s),73269248&e.$$.dirty[0]&&o(25,n=r?((e,t,o,r,n)=>{let i,a;return i="center"===r?e.x+.5*e.width-.5*t.width:"right"===r?e.x+e.width-t.width-n:e.x+n,a="center"===o?e.y+.5*e.height-.5*t.height:"bottom"===o?e.y+e.height-t.height-n:e.y+n,{top:`${a}px`,right:"auto",bottom:"auto",left:`${i}px`}})(S,s,C,w,T):void 0),100663296&e.$$.dirty[0]&&o(7,c=r?n.left:void 0),109051904&e.$$.dirty[0]&&o(8,u=r?n.top:P.top),100663296&e.$$.dirty[0]&&o(9,p=r?n.right:void 0),109051904&e.$$.dirty[0]&&o(10,d=r?n.bottom:P.bottom),32&e.$$.dirty[0]&&o(24,i=h&&getComputedStyle(h)),16777216&e.$$.dirty[0]&&(a=i&&"1"===i.getPropertyValue("--editor-modal"))},[f,$,_,x,v,h,I,c,u,p,d,e=>{((e=>/textarea/i.test(e))(e.target)||isTextInput(e.target))&&(A=Date.now(),y&&cursorMoveToEnd(e.target),clearTimeout(l),l=setTimeout(M,200))},e=>{Date.now()-A>50||(e.stopPropagation(),E())},({detail:e})=>{o(22,s={width:e.width,height:e.height})},e=>"Enter"===e.key?f():"Escape"===e.key?$():void 0,b,y,S,C,w,T,k,s,P,i,n,r,g,m,function(e){binding_callbacks[e?"unshift":"push"]((()=>{h=e,o(5,h)}))}]}class InputForm extends SvelteComponent{constructor(e){super(),init(this,e,instance$v,create_fragment$u,safe_not_equal,{onconfirm:0,oncancel:1,autoFocus:15,autoPositionCursor:16,buttonConfirm:2,buttonCancel:3,layout:4,parentRect:17,align:18,justify:19,parentMargin:20,panelOffset:21},null,[-1,-1])}}var fastSeek=(e,t)=>{e.fastSeek&&e.fastSeek(t),e.currentTime=t};const ImagePropsDerived=["aspectRatio","isRotatedSideways","flip","cropSize"],ImageStoreProps=ImageStorePropDescriptors.map((([e])=>e)).filter((e=>!ImagePropsDerived.includes(e))),proxy=function(e,t,o){let r=[];return{set:t,update:o,publish:e=>{r.forEach((t=>t(e)))},subscribe:t=>(r.push(t),e(t),()=>{r=r.filter((e=>e!==t))})}};var createImageProxy=()=>{let e,t;const o=ImageStoreProps.reduce(((e,o)=>(e[o]=proxy((e=>{if(!t)return e();t.stores[o].subscribe(e)()}),(e=>{t&&t.stores[o].set(e)}),(e=>{t&&t.stores[o].update(e)})),e)),{});return{update:r=>{if(t=r,e&&(e.forEach((e=>e())),e=void 0),!r)return o.file.publish(void 0),void o.loadState.publish(void 0);e=ImageStoreProps.map((e=>r.stores[e].subscribe((t=>{o[e].publish(t)}))))},stores:o,destroy:()=>{e&&e.forEach((e=>e()))}}},createPingRouter=(e,t=!0)=>o=>{"ping"===o.type&&(t&&o.stopPropagation(),e(o.detail.type,o.detail.data))},createPing=(e,t)=>new CustomEvent("ping",{detail:{type:e,data:t},cancelable:!0,bubbles:!0}),toKebabCase=(e,t)=>(t?stringReplace(e,t):e).replace(/([a-z])([A-Z])/g,"$1-$2").replace(/\s+/g,"-").toLowerCase(),matchMedia$1=(e,t)=>{const o=matchMedia(e);return o.addListener(t),t(o),{get matches(){return o.matches},destroy:()=>o.removeListener(t)}},mediaQueryStore=(e,t=passthrough)=>{const{subscribe:o,set:r}=writable(void 0);return{subscribe:o,destroy:matchMedia$1(e,(({matches:e})=>r(t(e)))).destroy}},canPreventNavSwipe=()=>{if(!isIOS())return!1;const e=navigator.userAgent.match(/OS (\d+)_(\d+)_?(\d+)?/i)||[],[,t,o]=e.map((e=>parseInt(e,10)||0));return t>13||13===t&&o>=4},historyCreate=(e,t,o)=>{const{sub:r,pub:n}=pubsub(),{willUndo:i=()=>!0}=o||{},a=[],s=writable(0),l=[],c=()=>l.forEach((e=>e({index:get_store_value(s),length:a.length}))),u={get index(){return get_store_value(s)},set index(e){e=Number.isInteger(e)?e:0,e=clamp(e,0,a.length-1),s.set(e),t(a[u.index]),c()},get state(){return a[a.length-1]},length(){return a.length},undo(){if(!1===i())return;const e=u.index--;return n("undo",e),e},redo(){const e=u.index++;return n("redo",u.index),e},revert(){a.length=1,u.index=0,n("revert")},write(o){o&&t({...e(),...o});const r=e(),i=a[a.length-1];JSON.stringify(r)!==JSON.stringify(i)&&(a.length=u.index+1,a.push(r),s.set(a.length-1),c(),n("writehistory"))},set(e={}){a.length=0,u.index=0;const t=Array.isArray(e)?e:[e];a.push(...t),u.index=a.length-1},get(){return[...a]},subscribe(e){return l.push(e),e({index:u.index,length:a.length}),()=>l.splice(l.indexOf(e),1)},on:r};return u},imageBitmapToImageData=async e=>canvasToImageData(await imageDataToCanvas(e)),blobToImageBitmap=(e,t,o)=>new Promise(((r,n)=>{(async()=>{isVideoFile(e)&&r(await videoToImageData(e));const i=await t.read(e),a=e=>blobToImageData(e,o).then((e=>t.apply(e,i))).then(r).catch(n);if(isSVGFile(e)||!canCreateImageBitmap()||isSafari()||isIOS())return a(e);let s;try{s=await thread(((e,t)=>createImageBitmap(e).then((e=>t(null,e))).catch(t)),[e])}catch(e){}s&&s.width?await canOrientImages()?isChrome()&&i>1?r(await imageBitmapToImageData(s)):r(s):r(t.apply(s,i)):a(e)})()})),imageDataContain=(e,t)=>new Promise((async o=>{if(e.width<t.width&&e.height<t.height)return o(e);const r=Math.min(t.width/e.width,t.height/e.height),n=r*e.width,i=r*e.height,a=h("canvas",{width:n,height:i}),s=a.getContext("2d",{willReadFrequently:!0}),l=isImageData(e)?await imageDataToCanvas(e):e;s.drawImage(l,0,0,n,i),o(canvasToImageData(a))}));let result$2=null;var supportsWebGL=()=>{if(null===result$2){let e=h("canvas");result$2=!!getWebGLContext(e),releaseCanvas(e),e=void 0}return result$2},isBitmap=e=>/^image/.test(e.type)&&!/svg/.test(e.type);const COLOR_MATRIX_IDENTITY=[1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0],SPRING_PROPS={precision:1e-4},SPRING_PROPS_FRACTION={precision:.01*SPRING_PROPS.precision};var createImage=(e,t,o={})=>{const{resize:r=1,opacity:n=0}=o,i={opacity:[spring(n,{...SPRING_PROPS,stiffness:.1}),passthrough],resize:[spring(r,{...SPRING_PROPS,stiffness:.1}),passthrough],translation:[spring(void 0,SPRING_PROPS),passthrough],rotation:[spring(void 0,SPRING_PROPS_FRACTION),passthrough],origin:[spring(void 0,SPRING_PROPS),passthrough],scale:[spring(void 0,SPRING_PROPS_FRACTION),passthrough],gamma:[spring(void 0,SPRING_PROPS_FRACTION),e=>e||1],vignette:[spring(void 0,SPRING_PROPS_FRACTION),e=>e||0],colorMatrix:[spring([...COLOR_MATRIX_IDENTITY],SPRING_PROPS),e=>e||[...COLOR_MATRIX_IDENTITY]],convolutionMatrix:[writable(void 0),e=>e&&e.clarity||void 0],backgroundColor:[spring(void 0,SPRING_PROPS),(e,t,o)=>{if(Array.isArray(e)){if(Array.isArray(t)){const r=[...e];0===t[3]?(r[3]=0,o(r)):0===r[3]&&((e=[...t])[3]=0)}return e}}],backgroundImage:[writable(void 0),passthrough]},a=Object.entries(i).map((([e,t])=>[e,t[0]])),s=a.map((([,e])=>e)),l=Object.entries(i).reduce(((e,[t,o])=>{const[r,n]=o;return e[t]=(e,o)=>r.set(n(e,c[t],(e=>{r.set(e,{hard:!0})})),o),e}),{});let c;const u=derived(s,(o=>(c=o.reduce(((e,t,o)=>(e[a[o][0]]=t,e)),{}),c.data=e,c.size=t,c.scale*=o[1],c)));return u.get=()=>c,u.set=(e,t)=>{const o={hard:!t};Object.entries(e).forEach((([e,t])=>{l[e]&&l[e](t,o)}))},u},storeList=()=>{const e=[],t=[],o=[],r=()=>{t.forEach((e=>e(o)))},n=t=>{t.unsub=t.subscribe((n=>((t,n)=>{const i=e.indexOf(t);i<0||(o[i]=n,r())})(t,n))),r()};return{get length(){return e.length},clear:()=>{e.forEach((e=>e.unsub())),e.length=0,o.length=0},unshift:t=>{e.unshift(t),n(t)},get:t=>e[t],push:t=>{e.push(t),n(t)},remove:t=>{t.unsub();const r=e.indexOf(t);e.splice(r,1),o.splice(r,1)},forEach:t=>e.forEach(t),filter:t=>e.filter(t),subscribe:e=>(t.push(e),e(o),()=>{t.splice(t.indexOf(e),1)})}},isDarkColor=e=>e[0]<.25&&e[1]<.25&&e[2]<.25,browse=(e={})=>new Promise((t=>{const{accept:o="image/*"}=e,r=h("input",{style:"position:absolute;visibility:hidden;width:0;height:0;",type:"file",accept:o}),n=()=>{const[e]=r.files;r.parentNode&&r.remove(),r.removeEventListener("change",n),t(e)};r.addEventListener("change",n),isIOS()&&document.body.append(r),r.click()})),runSafe=e=>{try{return e()}catch(e){console.error(e)}},getRangeCenter=([e,t])=>e+.5*(t-e),toPercentageNumber=e=>Math.round(100*e),getEventPositionInViewport=e=>vectorCreate(e.clientX,e.clientY),getEventPositionInStage=(e,t,o)=>{const r=getEventPositionInViewport(e);return vectorSubtract(vectorSubtract(r,t),o)};function instance$u(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,S,{root:C}=t,{locale:w}=t,{stores:T}=t,{allowPan:k=!0}=t,{allowZoom:R=!0}=t,{enablePan:P=!0}=t,{enableZoom:I=!0}=t,{enableZoomControls:E=I}=t,{enableZoomInput:M=!0}=t,{enablePanInput:A=!0}=t,{enablePanLimit:F=!0}=t,{panLimitGutterScalar:L=0}=t,{zoomOptions:D=[.25,.5,1,1.25,1.5,2,3,4,6,8,16]}=t,{zoomAdjustStep:z=.25}=t,{zoomAdjustFactor:O=.1}=t,{zoomAdjustWheelFactor:B=1}=t,{elasticity:N=5}=t,{imageSelectionRectCentered:V}=t,{imageSelectionRectScalar:W}=t,{zoomLevel:U=null}=t,{zoomControls:H}=t,{zoomMultiTouching:G=!1}=t;const{isAnimated:j,isInteracting:q,rootRect:X,stageRect:Y,stageScalar:Z,imageSelectionPan:K,imageSelectionZoom:J,imageSelectionStageFitScalar:Q,imageSelectionRect:ee,imageSelectionStoredState:te,imagePreviewUpscale:oe}=T;component_subscribe(e,j,(e=>o(70,v=e))),component_subscribe(e,q,(e=>o(69,_=e))),component_subscribe(e,X,(e=>o(66,$=e))),component_subscribe(e,Y,(e=>o(65,f=e))),component_subscribe(e,Z,(e=>o(46,x=e))),component_subscribe(e,K,(e=>o(64,h=e))),component_subscribe(e,J,(e=>o(43,d=e))),component_subscribe(e,Q,(e=>o(44,m=e))),component_subscribe(e,ee,(e=>o(67,b=e))),component_subscribe(e,te,(e=>o(71,S=e))),component_subscribe(e,oe,(e=>o(45,g=e)));const re=getContext("fixScrollDirection");component_subscribe(e,re,(e=>o(68,y=e)));let ne,ie,ae,se,le=!1;const ce=e=>{const t=C.querySelector(".PinturaMain > .PinturaUtilMain")||C.querySelector('div[tabindex="0"] .PinturaUtilMain');return!!t&&(!!t.contains(e.target)&&!isTextField(e.target))},ue=(e={})=>{const{pan:t=h,zoom:o=d}=e;set_store_value(te,S={translation:t,zoom:o},S)},pe=()=>h&&0===h.x&&0===h.y,de=()=>{set_store_value(J,d=void 0,d),pe()||set_store_value(K,h=vectorCreateEmpty(),h),me.set(void 0,{hard:!0})},he=()=>{de(),ue()},me=spring(void 0,{precision:.01});me.subscribe((e=>{if(void 0===e)return set_store_value(J,d=void 0,d),void(pe()||set_store_value(K,h=vectorCreateEmpty(),h));const t=d;e<=1?pe()||set_store_value(K,h=vectorCreateEmpty(),h):e<=t&&set_store_value(K,h=vectorMultiply(h,.8),h),set_store_value(J,d=e,d)}));const ge=e=>{me.update((t=>{const o=e(t||m);return ue({zoom:o}),o}))},fe=e=>{e?me.set(e,{hard:!1===v}):(e=void 0,me.set(void 0,{hard:!0})),set_store_value(J,d=e,d),ue({zoom:e})},$e=(e,t)=>{const o=W*t,r={...V},n=1-clamp(L,0,1);rectScale$1(r,o<n?o:n);const i={...V};rectScale$1(i,o),rectTranslate$1(i,e);const a={...i};return i.x>r.x&&(a.x=r.x),i.y>r.y&&(a.y=r.y),i.x+i.width<r.x+r.width&&(a.x=r.x+r.width-i.width),i.y+i.height<r.y+r.height&&(a.y=r.y+r.height-i.height),vectorSubtract(rectCenter(a),rectCenter(r))},be=({translation:e,zoom:t=1,elastify:o=!0})=>{if(!ne)return;let r=e;const n=vectorCreate(ne.x+r.x,ne.y+r.y);if(!F)return n;const i=$e(n,t);return o?elastifyVectors(i,n,N):i};let ye,_e;const xe=()=>{_e=void 0,set_store_value(q,_=!0,_),o(34,le=A),ye=!1,ae=!1,ne={...h},ie=g?d||m:i?d||1:d||m},ve=e=>{const{scalar:t,translation:n,isMultiTouching:i}=e.detail;if(!ne||!i&&!A)return;i&&vectorMultiply(n,.5),(A||i)&&(ye=!0),G||o(13,G=i);const a=r?clamp(ie*t,s,l):1,c=be({translation:n,zoom:a,elastify:!0}),u=vectorLength(c);se=vectorLength(h),ae=u<se,r&&J.set(a),K.set(c),_e=G&&{translation:e.detail.translation,scalar:t}},Se=e=>{set_store_value(q,_=!1,_),o(34,le=!1),o(13,G=!1),ae&&se<50&&(ne=void 0,ie=void 0,K.set(vectorCreateEmpty()))},Ce=e=>{set_store_value(q,_=!1,_),o(34,le=!1),o(13,G=!1),Promise.resolve().then((()=>{if(ye&&ne){const t=_e||e.detail,o=r?clamp(ie*t.scalar,s,l):1,n=be({elastify:!1,translation:t.translation,zoom:o});K.set(n)}ne=void 0,ie=void 0,A&&e.detail.isDoubleTap&&he(),ue()}))};let we,Te=Date.now(),ke=0,Re=!1,Pe=!1;const Ie=e=>{if(!ce(e))return;if(e.preventDefault(),e.stopPropagation(),Pe)return;clearTimeout(we);const t=getWheelDelta(e,{fixScrollDirection:y}),o=Date.now(),r=o-Te;Te=o;const n=Math.abs(t/r)>.2;ke=n?ke+1:0;const i=1+-1*t*B/(n?50:100),a=getEventPositionInStage(e,$,f);Ee(a,i,{isZoomingFast:n})},Ee=(e,t,{isZoomingFast:o})=>{const r=g?d||m:i?d||1:d||m,n=r*t,a=vectorCreateEmpty(),c=h,u=g?m:i?1:m,p=Math.abs(n-u),f=n<r,$=r>u&&f||r<u&&n>r,y=ke>=5;if(o||(Re=!1),ke>0&&!Re&&(Re=$),y&&Re)return he(),Pe=!0,void setTimeout((()=>{Pe=!1}),100);if(y)return;!o&&$&&p<=.05&&(we=setTimeout((()=>{he()}),250)),set_store_value(J,d=clamp(n,s,l),d);const _=rectClone$1(b);rectScale$1(_,r),rectTranslate$1(_,c);const x=rectCenter(_),v=rectClone$1(_);rectScale$1(v,d-r+1,e);const S=rectCenter(v),C=vectorDivide(vectorSubtract(S,x),r);vectorUpdate(a,c.x+C.x,c.y+C.y),set_store_value(K,h=f&&o?vectorMultiply(vectorClone(h),.85):$e(a,r),h),ue()},Me=e=>(e?"add":"remove")+"EventListener";let Ae,Fe,Le,De;const ze=e=>{e.preventDefault(),Fe={...h},De=rectClone$1(b),Le=getEventPositionInStage(e,$,f),Ae=g?d||m:i?d||1:d||m},Oe=e=>{e.preventDefault(),set_store_value(J,d=clamp(e.scale*Ae,s,l),d);const t=rectClone$1(De);rectScale$1(t,Ae),rectTranslate$1(t,Fe);const o=rectCenter(t),r=rectClone$1(t);rectScale$1(r,d-Ae+1,Le);const n=rectCenter(r),i=vectorDivide(vectorSubtract(n,o),Ae),a={x:Fe.x+i.x,y:Fe.y+i.y};set_store_value(K,h=$e(a,d),h)},Be=e=>{e.preventDefault()},Ne=e=>{C[Me(e)]("wheel",Ie),isIOS()||(C[Me(e)]("gesturestart",ze),C[Me(e)]("gesturechange",Oe),C[Me(e)]("gestureend",Be))},Ve=e=>{const t=Me(e);C[t]("interactionstart",xe),C[t]("interactionupdate",ve),C[t]("interactionrelease",Se),C[t]("interactionend",Ce)};let We;return onMount((()=>{We=interactable(C,{drag:!0,pinch:!0,inertia:!0,inertiaDurationMultiplier:10,shouldStartInteraction:ce})})),onDestroy((()=>{Ne(!1),Ve(!1),We.destroy(),We=void 0})),e.$$set=e=>{"root"in e&&o(14,C=e.root),"locale"in e&&o(15,w=e.locale),"stores"in e&&o(16,T=e.stores),"allowPan"in e&&o(17,k=e.allowPan),"allowZoom"in e&&o(18,R=e.allowZoom),"enablePan"in e&&o(19,P=e.enablePan),"enableZoom"in e&&o(20,I=e.enableZoom),"enableZoomControls"in e&&o(21,E=e.enableZoomControls),"enableZoomInput"in e&&o(22,M=e.enableZoomInput),"enablePanInput"in e&&o(23,A=e.enablePanInput),"enablePanLimit"in e&&o(24,F=e.enablePanLimit),"panLimitGutterScalar"in e&&o(25,L=e.panLimitGutterScalar),"zoomOptions"in e&&o(26,D=e.zoomOptions),"zoomAdjustStep"in e&&o(27,z=e.zoomAdjustStep),"zoomAdjustFactor"in e&&o(28,O=e.zoomAdjustFactor),"zoomAdjustWheelFactor"in e&&o(29,B=e.zoomAdjustWheelFactor),"elasticity"in e&&o(30,N=e.elasticity),"imageSelectionRectCentered"in e&&o(31,V=e.imageSelectionRectCentered),"imageSelectionRectScalar"in e&&o(32,W=e.imageSelectionRectScalar),"zoomLevel"in e&&o(33,U=e.zoomLevel),"zoomControls"in e&&o(12,H=e.zoomControls),"zoomMultiTouching"in e&&o(13,G=e.zoomMultiTouching)},e.$$.update=()=>{var t,f;5505024&e.$$.dirty[0]&&o(36,r=R&&I&&M),655360&e.$$.dirty[0]&&o(35,n=k&&P),393216&e.$$.dirty[0]&&(k||R?(set_store_value(J,d=I?S.zoom:void 0,d),set_store_value(K,h=P?vectorClone(S.translation):pe()?h:vectorCreateEmpty(),h),me.set(d)):de()),32768&e.$$.dirty[1]&&(i=x>=1),67141632&e.$$.dirty[0]|57344&e.$$.dirty[1]&&o(40,a=[(g||x<1)&&[m,toPercentageNumber(m)+"%",{sublabel:w.labelZoomFit}],...D.map((e=>[e,toPercentageNumber(e)+"%"]))].filter(Boolean).map((e=>(1===e[0]&&(e[2]={sublabel:w.labelZoomActual}),e))).sort(((e,t)=>{const o=e[0]||m,r=t[0]||m;return o<r?-1:r<o?1:0}))),8704&e.$$.dirty[1]&&o(38,s=Math.min(a.reduce(((e,[t])=>t<e?t:e),Number.MAX_SAFE_INTEGER),m)),512&e.$$.dirty[1]&&o(37,l=a.reduce(((e,[t])=>t>e?t:e),Number.MIN_SAFE_INTEGER)),4&e.$$.dirty[1]&&null!==U&&fe(U),61440&e.$$.dirty[1]&&o(42,u=d||(g||x<1?m:1)),2560&e.$$.dirty[1]&&o(39,(t=a.map((([e])=>e)),f=u,c=t.findIndex((e=>e===f)))),2048&e.$$.dirty[1]&&o(41,p=toPercentageNumber(u)+"%"),405045248&e.$$.dirty[0]|6080&e.$$.dirty[1]&&o(12,H=(R||R)&&E?[["Button","zoom-out",{hideLabel:!0,label:w.labelZoomOut,icon:w.iconZoomOut,disabled:d===s,onclick:()=>ge((e=>Math.max(s,e-z))),onhold:()=>ge((e=>Math.max(s,e*(1-O))))}],["Dropdown","zoom-level",{label:p,title:w.labelZoom,labelClass:"PinturaFixedWidthCharacters",options:a,selectedIndex:c,onchange:e=>fe(e.value)}],["Button","zoom-in",{hideLabel:!0,label:w.labelZoomIn,icon:w.iconZoomIn,disabled:d===l,onclick:()=>ge((e=>Math.min(l,e+z))),onhold:()=>ge((e=>Math.min(l,e*(1+O))))}]]:[]),16384&e.$$.dirty[0]|32&e.$$.dirty[1]&&C&&Ne(r),16384&e.$$.dirty[0]|16&e.$$.dirty[1]&&C&&Ve(n),8404992&e.$$.dirty[0]|24&e.$$.dirty[1]&&C&&C.style.setProperty("--cursor",n&&A?le?"grabbing":"grab":"")},[j,q,X,Y,Z,K,J,Q,ee,te,oe,re,H,G,C,w,T,k,R,P,I,E,M,A,F,L,D,z,O,B,N,V,W,U,le,n,r,l,s,c,a,p,u,d,m,g,x]}class CanvasPanAndZoom extends SvelteComponent{constructor(e){super(),init(this,e,instance$u,null,safe_not_equal,{root:14,locale:15,stores:16,allowPan:17,allowZoom:18,enablePan:19,enableZoom:20,enableZoomControls:21,enableZoomInput:22,enablePanInput:23,enablePanLimit:24,panLimitGutterScalar:25,zoomOptions:26,zoomAdjustStep:27,zoomAdjustFactor:28,zoomAdjustWheelFactor:29,elasticity:30,imageSelectionRectCentered:31,imageSelectionRectScalar:32,zoomLevel:33,zoomControls:12,zoomMultiTouching:13},null,[-1,-1,-1,-1])}}const{window:window_1$1}=globals;function create_if_block_2$6(e){let t,o,r,n=e[41]&&create_if_block_8$1(e),i=e[38]&&create_if_block_3$4(e);return{c(){n&&n.c(),t=space(),i&&i.c(),o=empty()},m(e,a){n&&n.m(e,a),insert(e,t,a),i&&i.m(e,a),insert(e,o,a),r=!0},p(e,r){e[41]?n?(n.p(e,r),1024&r[1]&&transition_in(n,1)):(n=create_if_block_8$1(e),n.c(),transition_in(n,1),n.m(t.parentNode,t)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),e[38]?i?(i.p(e,r),128&r[1]&&transition_in(i,1)):(i=create_if_block_3$4(e),i.c(),transition_in(i,1),i.m(o.parentNode,o)):i&&(group_outros(),transition_out(i,1,1,(()=>{i=null})),check_outros())},i(e){r||(transition_in(n),transition_in(i),r=!0)},o(e){transition_out(n),transition_out(i),r=!1},d(e){n&&n.d(e),e&&detach(t),i&&i.d(e),e&&detach(o)}}}function create_if_block_8$1(e){let t,o,r,n,i;const a=[create_if_block_9$1,create_if_block_10$1],s=[];function l(e,t){return e[39]?0:e[35]?1:-1}return~(r=l(e))&&(n=s[r]=a[r](e)),{c(){t=element("div"),o=element("p"),n&&n.c(),set_style(o,"transform",e[72]),attr(t,"class","PinturaStatus"),set_style(t,"opacity",e[54])},m(e,n){insert(e,t,n),append(t,o),~r&&s[r].m(o,null),i=!0},p(e,i){let c=r;r=l(e),r===c?~r&&s[r].p(e,i):(n&&(group_outros(),transition_out(s[c],1,1,(()=>{s[c]=null})),check_outros()),~r?(n=s[r],n?n.p(e,i):(n=s[r]=a[r](e),n.c()),transition_in(n,1),n.m(o,null)):n=null),1024&i[2]&&set_style(o,"transform",e[72]),8388608&i[1]&&set_style(t,"opacity",e[54])},i(e){i||(transition_in(n),i=!0)},o(e){transition_out(n),i=!1},d(e){e&&detach(t),~r&&s[r].d()}}}function create_if_block_10$1(e){let t,o,r,n;t=new StatusMessage({props:{text:e[35].text||"",onmeasure:e[221]}});let i=e[35].aside&&create_if_block_11$1(e);return{c(){create_component(t.$$.fragment),o=space(),i&&i.c(),r=empty()},m(e,a){mount_component(t,e,a),insert(e,o,a),i&&i.m(e,a),insert(e,r,a),n=!0},p(e,o){const n={};16&o[1]&&(n.text=e[35].text||""),t.$set(n),e[35].aside?i?(i.p(e,o),16&o[1]&&transition_in(i,1)):(i=create_if_block_11$1(e),i.c(),transition_in(i,1),i.m(r.parentNode,r)):i&&(group_outros(),transition_out(i,1,1,(()=>{i=null})),check_outros())},i(e){n||(transition_in(t.$$.fragment,e),transition_in(i),n=!0)},o(e){transition_out(t.$$.fragment,e),transition_out(i),n=!1},d(e){destroy_component(t,e),e&&detach(o),i&&i.d(e),e&&detach(r)}}}function create_if_block_9$1(e){let t,o,r,n;return t=new StatusMessage({props:{text:e[39],onmeasure:e[221]}}),r=new StatusAside({props:{class:"PinturaStatusIcon",offset:e[82],opacity:e[83],$$slots:{default:[create_default_slot_5$1]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment),o=space(),create_component(r.$$.fragment)},m(e,i){mount_component(t,e,i),insert(e,o,i),mount_component(r,e,i),n=!0},p(e,o){const n={};256&o[1]&&(n.text=e[39]),t.$set(n);const i={};1048576&o[2]&&(i.offset=e[82]),2097152&o[2]&&(i.opacity=e[83]),8&o[0]|2097152&o[19]&&(i.$$scope={dirty:o,ctx:e}),r.$set(i)},i(e){n||(transition_in(t.$$.fragment,e),transition_in(r.$$.fragment,e),n=!0)},o(e){transition_out(t.$$.fragment,e),transition_out(r.$$.fragment,e),n=!1},d(e){destroy_component(t,e),e&&detach(o),destroy_component(r,e)}}}function create_if_block_11$1(e){let t,o;return t=new StatusAside({props:{class:"PinturaStatusButton",offset:e[82],opacity:e[83],$$slots:{default:[create_default_slot_7]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};1048576&o[2]&&(r.offset=e[82]),2097152&o[2]&&(r.opacity=e[83]),16&o[1]|2097152&o[19]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_13(e){let t,o;return t=new ProgressIndicator({props:{progress:e[35].progressIndicator.progress}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16&o[1]&&(r.progress=e[35].progressIndicator.progress),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_12(e){let t,o;const r=[e[35].closeButton,{hideLabel:!0}];let n={};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new Button({props:n}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=16&o[1]?get_spread_update(r,[get_spread_object(e[35].closeButton),r[1]]):{};t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_7(e){let t,o,r,n=e[35].progressIndicator.visible&&create_if_block_13(e),i=e[35].closeButton&&e[35].text&&create_if_block_12(e);return{c(){n&&n.c(),t=space(),i&&i.c(),o=empty()},m(e,a){n&&n.m(e,a),insert(e,t,a),i&&i.m(e,a),insert(e,o,a),r=!0},p(e,r){e[35].progressIndicator.visible?n?(n.p(e,r),16&r[1]&&transition_in(n,1)):(n=create_if_block_13(e),n.c(),transition_in(n,1),n.m(t.parentNode,t)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),e[35].closeButton&&e[35].text?i?(i.p(e,r),16&r[1]&&transition_in(i,1)):(i=create_if_block_12(e),i.c(),transition_in(i,1),i.m(o.parentNode,o)):i&&(group_outros(),transition_out(i,1,1,(()=>{i=null})),check_outros())},i(e){r||(transition_in(n),transition_in(i),r=!0)},o(e){transition_out(n),transition_out(i),r=!1},d(e){n&&n.d(e),e&&detach(t),i&&i.d(e),e&&detach(o)}}}function create_default_slot_6(e){let t,o=e[3].iconSupportError+"";return{c(){t=svg_element("g")},m(e,r){insert(e,t,r),t.innerHTML=o},p(e,r){8&r[0]&&o!==(o=e[3].iconSupportError+"")&&(t.innerHTML=o)},d(e){e&&detach(t)}}}function create_default_slot_5$1(e){let t,o;return t=new Icon({props:{$$slots:{default:[create_default_slot_6]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};8&o[0]|2097152&o[19]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_3$4(e){let t,o,r,n,i,a,s,l,c,u,p,d,h,m,g=e[10]&&create_if_block_7$1(e),f=e[46]&&e[45]&&create_if_block_5$3(e);const $=[create_if_block_4$4,create_else_block$5],b=[];function y(e,t){return e[46]?0:1}function _(t){e[442](t)}function x(t){e[443](t)}function v(t){e[444](t)}r=y(e),n=b[r]=$[r](e),a=new Canvas({props:{isAnimated:e[53],isTransparent:e[20],pixelRatio:e[57],textPixelRatio:e[6],backgroundColor:e[56],maskRect:e[58],maskOpacity:e[73]?e[73].maskOpacity:1,maskMarkupOpacity:e[7],maskFrameOpacity:e[5],clipAnnotationsToImage:e[85],images:e[55],interfaceImages:e[86],loadImageData:e[28],enableGrid:e[11],gridSize:e[87],gridColors:[e[88],e[89]],gridOpacity:e[90],selectionColor:e[91],csp:e[92]||{},willRequest:e[81]||e[93],willRender:e[439],didRender:e[440]}});let S={root:e[2],locale:e[3],stores:e[202],allowPan:e[95],enablePan:e[17],enablePanLimit:e[21],panLimitGutterScalar:e[22],enablePanInput:e[96],allowZoom:e[97],enableZoom:e[18],enableZoomInput:void 0!==e[19]?e[19]:e[98],enableZoomControls:e[99],zoomOptions:e[13]||e[23],zoomAdjustStep:e[14]||e[24],zoomAdjustFactor:e[15]||e[25],zoomAdjustWheelFactor:e[16]||e[26],imageSelectionRectCentered:e[100],imageSelectionRectScalar:e[101],elasticity:imageSelectionRectElasticity*e[8]};return void 0!==e[0]&&(S.zoomLevel=e[0]),void 0!==e[33]&&(S.zoomControls=e[33]),void 0!==e[34]&&(S.zoomMultiTouching=e[34]),u=new CanvasPanAndZoom({props:S}),binding_callbacks.push((()=>bind(u,"zoomLevel",_))),binding_callbacks.push((()=>bind(u,"zoomControls",x))),binding_callbacks.push((()=>bind(u,"zoomMultiTouching",v))),{c(){g&&g.c(),t=space(),f&&f.c(),o=space(),n.c(),i=space(),create_component(a.$$.fragment),s=space(),l=element("div"),c=space(),create_component(u.$$.fragment),attr(l,"class","PinturaRootPortal")},m(n,p){g&&g.m(n,p),insert(n,t,p),f&&f.m(n,p),insert(n,o,p),b[r].m(n,p),insert(n,i,p),mount_component(a,n,p),insert(n,s,p),insert(n,l,p),e[441](l),insert(n,c,p),mount_component(u,n,p),m=!0},p(e,s){e[10]?g?(g.p(e,s),1024&s[0]&&transition_in(g,1)):(g=create_if_block_7$1(e),g.c(),transition_in(g,1),g.m(t.parentNode,t)):g&&(group_outros(),transition_out(g,1,1,(()=>{g=null})),check_outros()),e[46]&&e[45]?f?(f.p(e,s),49152&s[1]&&transition_in(f,1)):(f=create_if_block_5$3(e),f.c(),transition_in(f,1),f.m(o.parentNode,o)):f&&(group_outros(),transition_out(f,1,1,(()=>{f=null})),check_outros());let l=r;r=y(e),r===l?b[r].p(e,s):(group_outros(),transition_out(b[l],1,1,(()=>{b[l]=null})),check_outros(),n=b[r],n?n.p(e,s):(n=b[r]=$[r](e),n.c()),transition_in(n,1),n.m(i.parentNode,i));const c={};4194304&s[1]&&(c.isAnimated=e[53]),1048576&s[0]&&(c.isTransparent=e[20]),67108864&s[1]&&(c.pixelRatio=e[57]),64&s[0]&&(c.textPixelRatio=e[6]),33554432&s[1]&&(c.backgroundColor=e[56]),134217728&s[1]&&(c.maskRect=e[58]),2048&s[2]&&(c.maskOpacity=e[73]?e[73].maskOpacity:1),128&s[0]&&(c.maskMarkupOpacity=e[7]),32&s[0]&&(c.maskFrameOpacity=e[5]),8388608&s[2]&&(c.clipAnnotationsToImage=e[85]),16777216&s[1]&&(c.images=e[55]),16777216&s[2]&&(c.interfaceImages=e[86]),268435456&s[0]&&(c.loadImageData=e[28]),2048&s[0]&&(c.enableGrid=e[11]),33554432&s[2]&&(c.gridSize=e[87]),201326592&s[2]&&(c.gridColors=[e[88],e[89]]),268435456&s[2]&&(c.gridOpacity=e[90]),536870912&s[2]&&(c.selectionColor=e[91]),1073741824&s[2]&&(c.csp=e[92]||{}),524288&s[2]|1&s[3]&&(c.willRequest=e[81]||e[93]),512&s[0]|270991424&s[1]|2&s[3]&&(c.willRender=e[439]),62&s[2]&&(c.didRender=e[440]),a.$set(c);const m={};4&s[0]&&(m.root=e[2]),8&s[0]&&(m.locale=e[3]),4&s[3]&&(m.allowPan=e[95]),131072&s[0]&&(m.enablePan=e[17]),2097152&s[0]&&(m.enablePanLimit=e[21]),4194304&s[0]&&(m.panLimitGutterScalar=e[22]),8&s[3]&&(m.enablePanInput=e[96]),16&s[3]&&(m.allowZoom=e[97]),262144&s[0]&&(m.enableZoom=e[18]),524288&s[0]|32&s[3]&&(m.enableZoomInput=void 0!==e[19]?e[19]:e[98]),64&s[3]&&(m.enableZoomControls=e[99]),8396800&s[0]&&(m.zoomOptions=e[13]||e[23]),16793600&s[0]&&(m.zoomAdjustStep=e[14]||e[24]),33587200&s[0]&&(m.zoomAdjustFactor=e[15]||e[25]),67174400&s[0]&&(m.zoomAdjustWheelFactor=e[16]||e[26]),128&s[3]&&(m.imageSelectionRectCentered=e[100]),256&s[3]&&(m.imageSelectionRectScalar=e[101]),256&s[0]&&(m.elasticity=imageSelectionRectElasticity*e[8]),!p&&1&s[0]&&(p=!0,m.zoomLevel=e[0],add_flush_callback((()=>p=!1))),!d&&4&s[1]&&(d=!0,m.zoomControls=e[33],add_flush_callback((()=>d=!1))),!h&&8&s[1]&&(h=!0,m.zoomMultiTouching=e[34],add_flush_callback((()=>h=!1))),u.$set(m)},i(e){m||(transition_in(g),transition_in(f),transition_in(n),transition_in(a.$$.fragment,e),transition_in(u.$$.fragment,e),m=!0)},o(e){transition_out(g),transition_out(f),transition_out(n),transition_out(a.$$.fragment,e),transition_out(u.$$.fragment,e),m=!1},d(n){g&&g.d(n),n&&detach(t),f&&f.d(n),n&&detach(o),b[r].d(n),n&&detach(i),destroy_component(a,n),n&&detach(s),n&&detach(l),e[441](null),n&&detach(c),destroy_component(u,n)}}}function create_if_block_7$1(e){let t,o,r,n,i;return o=new DynamicComponentTree_1({props:{items:e[69]}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"class","PinturaNav PinturaNavTools")},m(a,s){insert(a,t,s),mount_component(o,t,null),r=!0,n||(i=[listen(t,"measure",e[428]),action_destroyer(measurable.call(null,t))],n=!0)},p(e,t){const r={};128&t[2]&&(r.items=e[69]),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o),n=!1,run_all(i)}}}function create_if_block_5$3(e){let t,o,r;return o=new Scrollable({props:{elasticity:e[8]*scrollElasticity,scrollDirection:e[76]?"y":"x",$$slots:{default:[create_default_slot_2$4]},$$scope:{ctx:e}}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"class","PinturaNav PinturaNavMain")},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,t){const r={};256&t[0]&&(r.elasticity=e[8]*scrollElasticity),16384&t[2]&&(r.scrollDirection=e[76]?"y":"x"),12288&t[1]|135168&t[2]|2097152&t[19]&&(r.$$scope={dirty:t,ctx:e}),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function create_else_block_1(e){let t,o;const r=[e[79],{tabs:e[44]}];let n={$$slots:{default:[create_default_slot_3$2,({tab:e})=>({609:e}),({tab:e})=>[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,e?1048576:0]]},$$scope:{ctx:e}};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new TabList({props:n}),t.$on("select",e[429]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=8192&o[1]|131072&o[2]?get_spread_update(r,[131072&o[2]&&get_spread_object(e[79]),8192&o[1]&&{tabs:e[44]}]):{};3145728&o[19]&&(n.$$scope={dirty:o,ctx:e}),t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_6$2(e){let t,o;return t=new DynamicComponentTree_1({props:{items:e[44]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};8192&o[1]&&(r.items=e[44]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_4$2(e){let t,o=e[609].icon+"";return{c(){t=svg_element("g")},m(e,r){insert(e,t,r),t.innerHTML=o},p(e,r){1048576&r[19]&&o!==(o=e[609].icon+"")&&(t.innerHTML=o)},d(e){e&&detach(t)}}}function create_default_slot_3$2(e){let t,o,r,n,i,a=e[609].label+"";return t=new Icon({props:{$$slots:{default:[create_default_slot_4$2]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment),o=space(),r=element("span"),n=text(a)},m(e,a){mount_component(t,e,a),insert(e,o,a),insert(e,r,a),append(r,n),i=!0},p(e,o){const r={};3145728&o[19]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r),(!i||1048576&o[19])&&a!==(a=e[609].label+"")&&set_data(n,a)},i(e){i||(transition_in(t.$$.fragment,e),i=!0)},o(e){transition_out(t.$$.fragment,e),i=!1},d(e){destroy_component(t,e),e&&detach(o),e&&detach(r)}}}function create_default_slot_2$4(e){let t,o,r,n;const i=[create_if_block_6$2,create_else_block_1],a=[];function s(e,t){return e[74]?0:1}return t=s(e),o=a[t]=i[t](e),{c(){o.c(),r=empty()},m(e,o){a[t].m(e,o),insert(e,r,o),n=!0},p(e,n){let l=t;t=s(e),t===l?a[t].p(e,n):(group_outros(),transition_out(a[l],1,1,(()=>{a[l]=null})),check_outros(),o=a[t],o?o.p(e,n):(o=a[t]=i[t](e),o.c()),transition_in(o,1),o.m(r.parentNode,r))},i(e){n||(transition_in(o),n=!0)},o(e){transition_out(o),n=!1},d(e){a[t].d(e),e&&detach(r)}}}function create_else_block$5(e){let t,o,r;function n(t){e[435](t)}let i={locale:e[3],class:"PinturaMain",view:e[207](e[43]),props:e[206](e[43],e[27]),stores:e[202]};return void 0!==e[1][e[43]]&&(i.component=e[1][e[43]]),t=new UtilPanel({props:i}),binding_callbacks.push((()=>bind(t,"component",n))),t.$on("measure",e[233]),t.$on("show",e[436]),t.$on("hide",e[437]),t.$on("fade",e[438]),{c(){create_component(t.$$.fragment)},m(e,o){mount_component(t,e,o),r=!0},p(e,r){const n={};8&r[0]&&(n.locale=e[3]),4096&r[1]&&(n.view=e[207](e[43])),134217728&r[0]|4096&r[1]&&(n.props=e[206](e[43],e[27])),!o&&2&r[0]|4096&r[1]&&(o=!0,n.component=e[1][e[43]],add_flush_callback((()=>o=!1))),t.$set(n)},i(e){r||(transition_in(t.$$.fragment,e),r=!0)},o(e){transition_out(t.$$.fragment,e),r=!1},d(e){destroy_component(t,e)}}}function create_if_block_4$4(e){let t,o;const r=[{class:"PinturaMain"},{visible:e[62]},e[79],{panels:e[78]}];let n={$$slots:{default:[create_default_slot_1$4,({panel:e,panelIsActive:t})=>({607:e,608:t}),({panel:e,panelIsActive:t})=>[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(e?262144:0)|(t?524288:0)]]},$$scope:{ctx:e}};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new TabPanels({props:n}),t.$on("measure",e[434]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=196609&o[2]?get_spread_update(r,[r[0],1&o[2]&&{visible:e[62]},131072&o[2]&&get_spread_object(e[79]),65536&o[2]&&{panels:e[78]}]):{};134217738&o[0]|2883584&o[19]&&(n.$$scope={dirty:o,ctx:e}),t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_1$4(e){let t,o,r;function n(t){e[430](t,e[607])}let i={locale:e[3],view:e[207](e[607]),props:e[206](e[607],e[27]),isActive:e[608],stores:e[202]};return void 0!==e[1][e[607]]&&(i.component=e[1][e[607]]),t=new UtilPanel({props:i}),binding_callbacks.push((()=>bind(t,"component",n))),t.$on("measure",e[233]),t.$on("show",(function(){return e[431](e[607])})),t.$on("hide",(function(){return e[432](e[607])})),t.$on("fade",(function(...t){return e[433](e[607],...t)})),{c(){create_component(t.$$.fragment)},m(e,o){mount_component(t,e,o),r=!0},p(r,n){e=r;const i={};8&n[0]&&(i.locale=e[3]),262144&n[19]&&(i.view=e[207](e[607])),134217728&n[0]|262144&n[19]&&(i.props=e[206](e[607],e[27])),524288&n[19]&&(i.isActive=e[608]),!o&&2&n[0]|262144&n[19]&&(o=!0,i.component=e[1][e[607]],add_flush_callback((()=>o=!1))),t.$set(i)},i(e){r||(transition_in(t.$$.fragment,e),r=!0)},o(e){transition_out(t.$$.fragment,e),r=!1},d(e){destroy_component(t,e)}}}function create_if_block_1$7(e){let t;return{c(){t=element("span"),attr(t,"class","PinturaEditorOverlay"),set_style(t,"opacity",e[102])},m(e,o){insert(e,t,o)},p(e,o){512&o[3]&&set_style(t,"opacity",e[102])},d(e){e&&detach(t)}}}function create_if_block$b(e){let t,o;const r=[{layout:"row"},{parentRect:e[50]},e[60]];let n={$$slots:{default:[create_default_slot$b]},$$scope:{ctx:e}};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new InputForm({props:n}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=537395200&o[1]?get_spread_update(r,[r[0],524288&o[1]&&{parentRect:e[50]},536870912&o[1]&&get_spread_object(e[60])]):{};1610612736&o[1]|2097152&o[19]&&(n.$$scope={dirty:o,ctx:e}),t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot$b(e){let t,o,r;return{c(){t=element("input"),t.value=o=e[60].text,attr(t,"placeholder",r=e[60].placeholder),attr(t,"type","text"),attr(t,"spellcheck","false"),attr(t,"autocorrect","off"),attr(t,"autocapitalize","off")},m(o,r){insert(o,t,r),e[445](t)},p(e,n){536870912&n[1]&&o!==(o=e[60].text)&&t.value!==o&&(t.value=o),536870912&n[1]&&r!==(r=e[60].placeholder)&&attr(t,"placeholder",r)},d(o){o&&detach(t),e[445](null)}}}function create_fragment$t(e){let t,o,r,n,i,a;add_render_callback(e[427]);let s=e[40]&&create_if_block_2$6(e),l=e[102]>0&&create_if_block_1$7(e),c=e[60]&&create_if_block$b(e);return{c(){t=element("div"),s&&s.c(),o=space(),l&&l.c(),r=space(),c&&c.c(),attr(t,"id",e[4]),attr(t,"class",e[77]),attr(t,"data-env",e[75]),attr(t,"dir",e[12])},m(u,p){insert(u,t,p),s&&s.m(t,null),append(t,o),l&&l.m(t,null),append(t,r),c&&c.m(t,null),e[446](t),n=!0,i||(a=[listen(window_1$1,"keydown",e[224]),listen(window_1$1,"keyup",e[225]),listen(window_1$1,"blur",e[226]),listen(window_1$1,"paste",e[230]),listen(window_1$1,"resize",e[427]),listen(t,"ping",(function(){is_function(e[68])&&e[68].apply(this,arguments)})),listen(t,"contextmenu",e[227]),listen(t,"touchstart",e[222],{passive:!1}),listen(t,"touchmove",(function(){is_function(e[71])&&e[71].apply(this,arguments)})),listen(t,"pointermove",(function(){is_function(e[70])&&e[70].apply(this,arguments)})),listen(t,"transitionend",e[212]),listen(t,"dropfiles",e[228]),listen(t,"measure",e[447]),listen(t,"click",(function(){is_function(e[42]?e[229]:noop$1)&&(e[42]?e[229]:noop$1).apply(this,arguments)})),action_destroyer(measurable.call(null,t,{observeViewRect:!0,isMeasureRoot:!0})),action_destroyer(focusvisible.call(null,t)),action_destroyer(dropable.call(null,t))],i=!0)},p(i,a){(e=i)[40]?s?(s.p(e,a),512&a[1]&&transition_in(s,1)):(s=create_if_block_2$6(e),s.c(),transition_in(s,1),s.m(t,o)):s&&(group_outros(),transition_out(s,1,1,(()=>{s=null})),check_outros()),e[102]>0?l?l.p(e,a):(l=create_if_block_1$7(e),l.c(),l.m(t,r)):l&&(l.d(1),l=null),e[60]?c?(c.p(e,a),536870912&a[1]&&transition_in(c,1)):(c=create_if_block$b(e),c.c(),transition_in(c,1),c.m(t,null)):c&&(group_outros(),transition_out(c,1,1,(()=>{c=null})),check_outros()),(!n||16&a[0])&&attr(t,"id",e[4]),(!n||32768&a[2])&&attr(t,"class",e[77]),(!n||8192&a[2])&&attr(t,"data-env",e[75]),(!n||4096&a[0])&&attr(t,"dir",e[12])},i(e){n||(transition_in(s),transition_in(c),n=!0)},o(e){transition_out(s),transition_out(c),n=!1},d(o){o&&detach(t),s&&s.d(),l&&l.d(),c&&c.d(),e[446](null),i=!1,run_all(a)}}}let frameUpdateRequestDist=16;const imageCropRectElasticity=5,imageSelectionRectElasticity=1,OVERLAY_ID="stage-overlay",OVERLAY_OPACITY_TWEEN_DIST=64,scrollElasticity=10,rangeInputElasticity=5;function instance$t(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,S,C,w,T,k,R,P,I,E,M,A,F,L,D,z,O,B,N,V,W,U,H,G,j,q,X,Y,Z,K,J,Q,ee,te,oe,re,ne,ie,ae,se,le,ce,ue,pe,de,he,me,ge,fe,$e,be,ye,_e,xe,ve,Se,Ce,we,Te,ke,Re,Pe,Ie,Ee,Me,Ae,Fe,Le,De,ze,Oe,Be,Ne,Ve,We,Ue,He,Ge,je,qe,Xe,Ye,Ze,Ke,Je,Qe,et,tt,ot,rt,nt,it,at,st,lt,ct,ut,pt,dt,ht,mt,gt,ft,$t,bt,yt,_t,xt,vt,St,Ct,wt,Tt,kt,Rt,Pt,It,Et,Mt,At,Ft,Lt,Dt,zt,Ot,Bt,Nt,Vt,Wt,Ut,Ht,Gt,jt,qt,Xt,Yt,Zt,Kt,Jt,Qt,eo,to,oo,ro,no,io,ao,so,lo,co,uo,po,ho,mo,go,fo,$o,bo,yo,_o,xo,vo,So,Co,wo,To,ko,Ro,Po,Io,Eo,Mo,Ao,Fo,Lo,Do,zo,Oo,Bo,No,Vo,Wo,Uo,Ho,Go,jo,qo,Xo,Yo,Zo,Ko,Jo,Qo,er,tr,or=noop,rr=noop;component_subscribe(e,prefersReducedMotion,(e=>o(415,fo=e))),e.$$.on_destroy.push((()=>or())),e.$$.on_destroy.push((()=>rr()));const nr=pubsub(),ir=createEventDispatcher();let{class:ar}=t,{layout:sr}=t,{stores:lr}=t,{locale:cr}=t,{id:ur}=t,{util:pr}=t,{utils:dr}=t,{animations:hr="auto"}=t,{disabled:mr=!1}=t,{previewUpscale:gr=!1}=t,{previewPad:fr=!1}=t,{previewMaskOpacity:$r=.95}=t,{previewImageDataMaxSize:br}=t,{previewImageTextPixelRatio:yr}=t,{markupMaskOpacity:_r=1}=t,{zoomMaskOpacity:xr=.85}=t,{elasticityMultiplier:vr=10}=t,{willRevert:Sr=()=>Promise.resolve(!0)}=t,{willProcessImage:Cr=()=>Promise.resolve(!0)}=t,{willRenderCanvas:wr=passthrough}=t,{willRenderToolbar:Tr=passthrough}=t,{willRenderUtilTabs:kr=passthrough}=t,{willSetHistoryInitialState:Rr=passthrough}=t,{enableButtonExport:Pr=!0}=t,{enableButtonRevert:Ir=!0}=t,{enableNavigateHistory:Er=!0}=t,{enableToolbar:Mr=!0}=t,{enableUtils:Ar=!0}=t,{enableButtonClose:Fr=!1}=t,{enableDropImage:Lr=!1}=t,{enablePasteImage:Dr=!1}=t,{enableBrowseImage:zr=!1}=t,{enableTransparencyGrid:Or=!1}=t,{layoutDirectionPreference:Br="auto"}=t,{layoutHorizontalUtilsPreference:Nr="left"}=t,{layoutVerticalUtilsPreference:Vr="bottom"}=t,{layoutVerticalToolbarPreference:Wr="top"}=t,{layoutVerticalControlGroupsPreference:Ur="bottom"}=t,{layoutVerticalControlTabsPreference:Hr="bottom"}=t,{status:Gr}=t,{formatStatusImageLoading:jr=function(e,t){const{state:o}=e;if(!o||!o.task)return t.statusImageLoadNone;if(o.error){if("IMAGE_TOO_SMALL"===o.error.code)return t.statusImageLoadMinSize;if("VIDEO_TOO_SHORT"===o.error.code){const e=Array.isArray(t.unitSeconds)?1===o.error.metadata.minDuration?t.unitSeconds[0]:t.unitSeconds[1]:t.unitSeconds;return stringReplace(t.statusImageLoadMinDuration,{seconds:e},"{","}")}return t.statusImageLoadError}return"blob-to-bitmap"===o.task?t.statusImageLoadPrepare:t.statusImageLoadBusy}}=t,{formatStatusImageProcessing:qr=function(e,t){const{state:o}=e;if(o&&o.task)return"store"===o.task?o.error?t.statusImageUploadError:t.statusImageUploadBusy:o.error?t.statusImageProcessError:t.statusImageProcessBusy}}=t,{formatStatusSupportError:Xr=function(e,t){const{features:o}=e;return{features:o.join(", ")}}}=t,{textDirection:Yr}=t,{markupEditorZoomLevel:Zr=null}=t,{markupEditorZoomLevels:Kr}=t,{markupEditorZoomAdjustStep:Jr}=t,{markupEditorZoomAdjustFactor:Qr}=t,{markupEditorZoomAdjustWheelFactor:en}=t,{markupEditorInteractionMode:tn=!1}=t,{muteAudio:on=!0}=t,{willSetMediaInitialTimeOffset:rn=(e,t)=>e*getRangeCenter(t[0])}=t,{enablePan:nn=!0}=t,{enableZoom:an=!0}=t,{enableZoomControls:sn=!0}=t,{enableZoomInput:ln}=t,{enablePanInput:cn}=t,{enableCanvasAlpha:un=!1}=t,{enablePanLimit:pn}=t,{panLimitGutterScalar:dn}=t,{pan:hn=null}=t,{zoomPresetOptions:mn=[.25,.5,1,1.25,1.5,2,3,4,6,8,16]}=t,{zoomAdjustStep:gn=.25}=t,{zoomAdjustFactor:fn=.1}=t,{zoomAdjustWheelFactor:$n=1}=t,{zoomLevel:bn=null}=t,{fixScrollDirection:yn=!1}=t;const _n=writable(yn);let xn,vn;setContext("fixScrollDirection",_n);let{imagePreviewSrc:Sn}=t,{imageOrienter:Cn={read:()=>1,apply:e=>e}}=t,{pluginComponents:wn}=t,{pluginOptions:Tn={}}=t;const kn=nr.sub,Rn={};let{root:Pn}=t;const In=()=>{Ye.setAttribute("data-redraw","true"),Jn.set({})},En=writable(!0);component_subscribe(e,En,(e=>o(480,gt=e)));const Mn=writable(void 0);component_subscribe(e,Mn,(e=>o(425,Ao=e)));const An=writable(0);component_subscribe(e,An,(e=>o(422,Io=e)));const Fn=writable(!1),Ln=e=>{Fn.set("play"===e.type),nr.pub(e.type)};let Dn,zn;let On,Bn,Nn=!1;const Vn=()=>{if(!i||!Un())return;Bn=p,set_store_value(Mn,Ao=void 0,Ao);const e=Ye;Nn=!1;const t=1/24,o=Yn();(Math.abs(c*o-Io*o)<=t||o-o*Io<=t)&&set_store_value(An,Io=l,Io),Kn(Io*Yn()),e.play().catch((()=>{}));let r=Zn();const n=()=>{if(Un())return;On=requestAnimationFrame(n);let e=Zn();e-r<=0&&(e=r+.01),r=e,set_store_value(An,Io=e/Yn(),Io),Bn>=0&&Io>=c&&(set_store_value(An,Io=c,Io),Wn()),p>-1&&(Nn=!0),Nn&&-1===p&&d>0&&(set_store_value(An,Io=s[d][0],Io),Kn(Io*Yn())),set_store_value(pi,To=Io*Yn(),To),In()};n()},Wn=()=>{i&&!Un()&&(set_store_value(Mn,Ao=void 0,Ao),Bn=void 0,Ye.pause(),cancelAnimationFrame(On),In())},Un=()=>Ye&&Ye.paused,Hn=()=>{if(i)return Un()?Vn():Wn()},Gn=()=>{if(!i)return;Ye.muted=!0},jn=()=>{if(!i)return;Ye.muted=!1},qn=()=>{i&&set_store_value(Xn,Mo=!Mo,Mo)},Xn=writable(on);component_subscribe(e,Xn,(e=>o(424,Mo=e)));const Yn=()=>{if(i)return Ye.duration},Zn=()=>{if(!i)return;return Ye.currentTime},Kn=e=>{i&&(fastSeek(Ye,e),set_store_value(An,Io=e/Eo,Io))},Jn=writable({});component_subscribe(e,Jn,(e=>o(52,bt=e))),setContext("redrawTrigger",Jn);const Qn=writable(vr);component_subscribe(e,Qn,(e=>o(497,Ro=e))),setContext("elasticityMultiplier",Qn);let ei=[];const ti=spring();component_subscribe(e,ti,(e=>o(102,tr=e)));const oi=getWebGLTextureSizeLimit()||1024,ri=sizeCreate(oi,oi),ni=getCanvasMemoryLimit(),ii=e=>Promise.resolve(ko&&ko(e,{resourceType:"image"})).then((t=>{if(!1===t)return;const{headers:o,credentials:r}=t||{};return fetch(e,{headers:o,credentials:r}).then((e=>{if(200!==e.status)throw`${e.status} (${e.statusText})`;return e.blob()})).then((e=>blobToImageBitmap(e,Cn,ni))).then((e=>imageDataContain(e,g)))}));let{imageSourceToImageData:ai=e=>isString(e)?ii(e):isElement(e)?new Promise((t=>t(canvasToImageData(e)))):isBlob(e)||isFile(e)?blobToImageBitmap(e,Cn,ni).then((e=>imageDataContain(e,g))):void 0}=t;const si=createImageProxy(),{file:li,size:ci,duration:ui,currentTime:pi,trim:di,volume:hi,minDuration:mi,maxDuration:gi,loadState:fi,processState:$i,cropAspectRatio:bi,cropLimitToImage:yi,crop:_i,cropMinSize:xi,cropMaxSize:vi,cropRange:Si,cropOrigin:Ci,cropRectAspectRatio:wi,rotation:Ti,rotationRange:ki,targetSize:Ri,flipX:Pi,flipY:Ii,backgroundColor:Ei,backgroundImage:Mi,colorMatrix:Ai,convolutionMatrix:Fi,gamma:Li,vignette:Di,noise:zi,decoration:Oi,annotation:Bi,manipulation:Ni,redaction:Vi,frame:Wi,selection:Ui,state:Hi}=si.stores;component_subscribe(e,li,(e=>o(399,Ot=e))),component_subscribe(e,ci,(e=>o(372,Je=e))),component_subscribe(e,ui,(e=>o(423,Eo=e))),component_subscribe(e,pi,(e=>o(496,To=e))),component_subscribe(e,di,(e=>o(420,wo=e))),component_subscribe(e,hi,(e=>o(421,Po=e))),component_subscribe(e,gi,(e=>o(426,Fo=e))),component_subscribe(e,fi,(e=>o(391,Rt=e))),component_subscribe(e,$i,(e=>o(390,kt=e))),component_subscribe(e,bi,(e=>o(493,bo=e))),component_subscribe(e,yi,(e=>o(85,Oo=e))),component_subscribe(e,_i,(e=>o(410,oo=e))),component_subscribe(e,Ti,(e=>o(375,tt=e))),component_subscribe(e,Pi,(e=>o(374,et=e))),component_subscribe(e,Ii,(e=>o(373,Qe=e))),component_subscribe(e,Ei,(e=>o(381,dt=e))),component_subscribe(e,Oi,(e=>o(48,Ke=e))),component_subscribe(e,Bi,(e=>o(49,ot=e))),component_subscribe(e,Ni,(e=>o(378,ct=e))),component_subscribe(e,Vi,(e=>o(379,ut=e))),component_subscribe(e,Wi,(e=>o(47,Ze=e))),component_subscribe(e,Ui,(e=>o(59,vo=e))),component_subscribe(e,Hi,(e=>o(482,Vt=e))),setContext("components",{DynamicComponentTree:DynamicComponentTree_1}),setContext("previewcontrols",{play:Vn,pause:Wn,togglePlayPause:Hn,mute:Gn,unmute:jn,toggleMute:qn,setCurrentTime:Kn,getCurrentTime:Zn,getDuration:Yn,frameOffset:An,framePeekOffset:Mn,isPlaying:Fn,isMuted:Xn});const Gi=(e,t,o=0)=>new Promise(((r,n)=>{if(isVideoFile(e))return void blobToVideo(e).then((e=>{const t=isNumber(To)?To:rn(e.duration,wo||[[0,1]]);seekTo(e,t).then(r)}));let i,a=!1;t.cancel=()=>a=!0;const s=Date.now();ai(e).then((e=>{const t=Date.now()-s;clearTimeout(i),i=setTimeout((()=>{a||r(e)}),Math.max(0,o-t))})).catch(n)})),{images:ji,shapePreprocessor:qi,imageScrambler:Xi,imageRedactionRendering:Yi,willRequest:Zi,willRequestResource:Ki,csp:Ji}=lr;let Qi;component_subscribe(e,ji,(e=>o(419,Co=e))),component_subscribe(e,qi,(e=>o(418,So=e))),component_subscribe(e,Xi,(e=>o(382,ht=e))),component_subscribe(e,Yi,(e=>o(380,pt=e))),component_subscribe(e,Zi,(e=>o(81,ko=e))),component_subscribe(e,Ki,(e=>o(93,jo=e))),component_subscribe(e,Ji,(e=>o(92,Go=e)));const ea=derived(Mi,((e,t)=>{if(!e)return t(void 0);Qi&&(Qi.cancel(),Qi=void 0),Qi={cancel:noop$1},Gi(e,Qi).then(t).catch((e=>{}))})),ta=Hi.subscribe((e=>nr.pub("update",e))),oa=writable();setContext("ui",writable({})),setContext("selection",Ui);const ra=writable(!0);component_subscribe(e,ra,(e=>o(95,Xo=e)));const na=writable(!0);component_subscribe(e,na,(e=>o(97,Zo=e)));const ia=writable(!0);component_subscribe(e,ia,(e=>o(417,xo=e)));const aa=writable(!0);component_subscribe(e,aa,(e=>o(494,yo=e)));const sa=writable(!0);component_subscribe(e,sa,(e=>o(98,Ko=e)));const la=writable();component_subscribe(e,la,(e=>o(99,Jo=e)));const ca=writable();component_subscribe(e,ca,(e=>o(495,_o=e)));const ua=derived([ca,aa],(()=>void 0!==_o?_o:yo));component_subscribe(e,ua,(e=>o(96,Yo=e)));const pa=writable([0,0,0]);component_subscribe(e,pa,(e=>o(56,jt=e)));const da=writable([1,1,1]);component_subscribe(e,da,(e=>o(478,lt=e)));const ha=spring([1,1,1]);component_subscribe(e,ha,(e=>o(477,st=e)));const ma=writable();component_subscribe(e,ma,(e=>o(91,Ho=e)));const ga=writable(),fa=writable();component_subscribe(e,fa,(e=>o(51,ft=e)));const $a=writable();component_subscribe(e,$a,(e=>o(376,nt=e)));const ba=writable(rectCreateEmpty());component_subscribe(e,ba,(e=>o(80,Wt=e)));const ya=writable(0);component_subscribe(e,ya,(e=>o(416,$o=e)));const _a=writable(rectCreateEmpty());component_subscribe(e,_a,(e=>o(84,zo=e)));const xa=writable();component_subscribe(e,xa,(e=>o(475,Xe=e)));const va=mediaQueryStore("(pointer: fine)",(e=>e?"pointer-fine":"pointer-coarse"));component_subscribe(e,va,(e=>o(397,Dt=e)));const Sa=mediaQueryStore("(hover: hover)",(e=>e?"pointer-hover":"pointer-no-hover"));component_subscribe(e,Sa,(e=>o(396,Lt=e)));const Ca=writable(!1),wa=writable(!1);component_subscribe(e,wa,(e=>o(377,at=e)));const Ta=readable(void 0,(e=>{const t=spring(0),o=[wa.subscribe((e=>{t.set(e?1:0,{hard:!_t})})),t.subscribe(e)];return()=>o.forEach((e=>e()))}));component_subscribe(e,Ta,(e=>o(476,it=e)));const ka=writable();component_subscribe(e,ka,(e=>o(481,Mt=e)));const Ra=writable();let Pa;component_subscribe(e,Ra,(e=>o(53,_t=e))),setContext("isAnimated",Ra);const Ia=writable(gr);component_subscribe(e,Ia,(e=>o(400,Bt=e)));const Ea=writable(!1);component_subscribe(e,Ea,(e=>o(487,io=e))),setContext("imageIsStatic",Ea);const Ma=writable();component_subscribe(e,Ma,(e=>o(488,ao=e)));const Aa=writable();component_subscribe(e,Aa,(e=>o(485,ro=e)));const Fa=readable(void 0,(e=>{const t=writable(void 0),o=[_i.subscribe((()=>{if(!oo)return;if(io)return t.set(rectClone$1(oo));const e=elastifyRects(oo,ro,5*vr);t.set(e)})),t.subscribe(e)];return()=>o.forEach((e=>e()))})),La=writable();component_subscribe(e,La,(e=>o(484,to=e)));const Da=writable();component_subscribe(e,Da,(e=>o(486,no=e)));const za=writable(void 0);component_subscribe(e,za,(e=>o(491,ho=e)));const Oa=writable(vectorCreateEmpty());component_subscribe(e,Oa,(e=>o(492,mo=e)));const Ba=(e,t)=>{if(!t||!e)return{top:0,right:0,bottom:0,left:0};const o=shapesFromCompositShape(t,e,f),r=shapesBounds(o,e);return{top:Math.abs(r.top),right:Math.abs(r.right),bottom:Math.abs(r.bottom),left:Math.abs(r.left)}},Na=writable({}),Va=derived([xa,ba,_a,Na],(([e,t,o,r],n)=>{if(!e)return n(void 0);let i=0;1!==M.length||h||"bottom"===Wr||(i=o.y+o.height),n(rectCreate(e.x+t.x,e.y+t.y+i,e.width,e.height))}));let Wa={left:0,right:0,top:0,bottom:0};const Ua=writable(!1),Ha=derived([Ua,Wi,Va,wa],(([e,t,o,r],n)=>{if(!o)return n({left:0,right:0,top:0,bottom:0});if(!e)return;const i=Math.min(o.width,o.height),a=Ba({width:i,height:i},t);fixPrecision(Wa.top,4)===fixPrecision(a.top,4)&&fixPrecision(Wa.bottom,4)===fixPrecision(a.bottom,4)&&fixPrecision(Wa.right,4)===fixPrecision(a.right,4)&&fixPrecision(Wa.left,4)===fixPrecision(a.left,4)||(Wa=a,n(a))}));component_subscribe(e,Ha,(e=>o(408,Jt=e)));const Ga=derived([Ua,Ha],(([e,t],o)=>{if(!e)return o(!1);o(Object.values(t).some((e=>e>0)))}));component_subscribe(e,Ga,(e=>o(409,Qt=e)));const ja=derived([Ua,xa,Ga,Ha],(([e,t,o,r],n)=>{if(t)return e&&o?void n(rectCreate(t.x+r.left,t.y+r.top,t.width-r.left-r.right,t.height-r.top-r.bottom)):n({...t})})),qa=derived([Va,Ga,Ha],(([e,t,o],r)=>e?t?void r(rectCreate(e.x+o.left,e.y+o.top,e.width-o.left-o.right,e.height-o.top-o.bottom)):r(e):r(void 0)));component_subscribe(e,qa,(e=>o(50,rt=e)));const Xa=derived([Ea,ci,Ti],(([e,t,o],r)=>{if(!e||!t)return r(void 0);const n=rectCreateFromSize(t);r(rectRotate(n,o))})),Ya=derived([Xa],(([e],t)=>{if(!e)return t(void 0);const o=rectCreateFromPoints(e);t(rectNormalizeOffset(o))}));component_subscribe(e,Ya,(e=>o(412,co=e)));const Za=derived([qa,_i,Ya,Ia],(([e,t,o,r],n)=>{if(!e||!t||!(!ao&&!ro))return;const{width:i,height:a}=o||t,s=Math.min(e.width/i,e.height/a);n(r?s:Math.min(1,s))}));component_subscribe(e,Za,(e=>o(411,lo=e)));const Ka=derived([Ea,ci,Ti,qa,xa,Za],(([e,t,o,r,n,i],a)=>{if(!(e&&r&&n&&t))return a(void 0);const s=rectCreateFromSize(t),l=rectNormalizeOffset(rectScale$1(s,i)),c=rectCenterRect(r,l);l.x=c.x,l.y=c.y;a(rectRotate(l,o))}));setContext("imageStaticVisualCorners",Ka);const Ja=writable(void 0);component_subscribe(e,Ja,(e=>o(414,go=e)));const Qa=derived([_i,qa],(([e,t])=>{if(t&&e)return Math.min(t.width/e.width,t.height/e.height)})),es=derived([_i,La],(([e,t])=>e&&t?Math.min(e.width/t.width,e.height/t.height):1));component_subscribe(e,es,(e=>o(101,er=e)));const ts=derived([Ja,es],(([e,t])=>e&&t?t*e:1));component_subscribe(e,ts,(e=>o(490,uo=e)));const os=writable(vectorCreateEmpty());component_subscribe(e,os,(e=>o(413,po=e)));const rs=writable({scalar:uo,translation:po}),ns=()=>{rs.set({scalar:void 0,translation:vectorCreateEmpty()})},is=readable(void 0,(e=>{const t=spring(void 0,{precision:1e-4}),o=1===getDevicePixelRatio()?e=>rectApply(e,Math.round):passthrough,r=()=>{if(!to)return;const e=at||!Mt;if(io){const o=rectClone$1(to);return rectTranslate$1(o,mo),rectTranslate$1(o,rt),t.set(o,{hard:e})}const r=elastifyRects(to,ho,imageSelectionRectElasticity*vr);r.width<0&&(r.width=0,r.x=to.x),r.height<0&&(r.height=0,r.y=to.y),rectTranslate$1(r,rt),rectTranslate$1(r,po),rectScale$1(r,uo),!e&&o(r),t.set(r,{hard:e})},n=[qa.subscribe(r),La.subscribe(r),ts.subscribe(r),os.subscribe(r),Wi.subscribe(r),t.subscribe(e)];return()=>n.forEach((e=>e()))}));component_subscribe(e,is,(e=>o(58,Kt=e)));const as=writable(1);component_subscribe(e,as,(e=>o(483,eo=e)));const ss=()=>{if(!oo||!rt)return;let e=rectMultiply(rectClone$1(oo),lo||1);const t=rectCenterRect(rt,rectMultiply(rectClone$1(co),lo));rectTranslate$1(e,t);const o=Xe.width/e.width,r=Xe.height/e.height,n=Math.min(1,o,r);as.set(n),rectScale$1(e,n),rectOffsetInRect(e,{...Xe,x:0,y:0}),La.set(e)},ls=derived([qa,Za,_i,ci],(([e,t,o,r],n)=>{e&&(o||r)&&n(cs(e,t||1,o||r))}));component_subscribe(e,ls,(e=>o(100,Qo=e)));const cs=(e,t,o)=>o.width<=e.width&&o.height<=e.height?rectCenterRect(e,rectMultiply(rectClone$1(o),t)):rectContainRect(e,rectAspectRatio(o));let us,ps;const ds=e=>{if(h&&us&&rectEqual(us,e)&&ps===lo)return;if(io)return ss();us=e,ps=lo;const t=cs(e,lo,oo||Je);La.set(t)};let hs=!1;const ms=Za.subscribe((e=>{!hs&&void 0!==e&&oo&&(ds(rt),hs=!0)})),gs=qa.subscribe((e=>{e&&void 0!==lo&&oo&&ds(e)})),fs=Ea.subscribe((e=>{!e&&rt&&ds(rt)}));let $s;const bs=Da.subscribe((e=>{if(!e)return $s=void 0,void set_store_value(Ma,ao=void 0,ao);$s=so;const t=rectClone$1(oo);Ma.set(t)})),ys=La.subscribe((e=>{if(!e||!no)return;const t=rectSubtract(rectClone$1(e),no);rectDivide(t,$s);const o=rectAdd(rectClone$1(ao),t);_i.set(o)})),_s=_i.subscribe((e=>{if(!e||!to)return;if(io)return void(no||ss());if(at||no||ro)return;const t=rectAspectRatio(to),o=rectAspectRatio(e);if(fixPrecision(t,6)===fixPrecision(o,6))return;const{width:r,height:n}=oo,i=Math.min(rt.width/r,rt.height/n),a=sizeCreate(e.width*i,e.height*i),s=.5*(to.width-a.width),l=.5*(to.height-a.height),c=rectCreate(Math.max(0,Math.min(rt.width-a.width,to.x+s)),Math.max(0,Math.min(rt.height-a.height,to.y+l)),a.width,a.height);La.set(c)})),xs=derived([Za,_i,La,Ea],(([e,t,o,r],n)=>{if(!e||!t||!o)return;if(r)return n(eo);const i=o.width/t.width,a=o.height/t.height;n(Math.max(i,a)/e)})),vs=derived([Za,xs],(([e,t],o)=>{if(!t)return;o(e*t)}));component_subscribe(e,vs,(e=>o(489,so=e)));let Ss={left:0,right:0,top:0,bottom:0};const Cs=derived([Wi,La],(([e,t],o)=>{if(!t)return o(Ss);const r=Ba(t,e);fixPrecision(Ss.top,4)===fixPrecision(r.top,4)&&fixPrecision(Ss.bottom,4)===fixPrecision(r.bottom,4)&&fixPrecision(Ss.right,4)===fixPrecision(r.right,4)&&fixPrecision(Ss.left,4)===fixPrecision(r.left,4)||(Ss=r,o(r))})),ws=derived([Cs],(([e],t)=>{t(Object.values(e).some((e=>e>0)))})),Ts=spring(.075,{stiffness:.03,damping:.4,precision:.001}),ks=derived([ha,pa,Ts,is,ts,Wi,ws,Cs,Ga],(([e,t,o,r,n,i,a,s,l],c)=>{if(!r||h)return c([]);let{x:u,y:p,width:d,height:m}=r;u+=.5,p+=.5,d-=.5,m-=.5;const g=[];if(i){if(a){let{left:e,right:o,top:r,bottom:i}=s;e*=n,o*=n,r*=n,i*=n;const a=isDarkColor(t)?[1,1,1,.125]:[0,0,0,.075];g.push({x:u-e-.5,y:p-r-.5,width:d+e+o+1,height:m+r+i+1,strokeWidth:1,strokeColor:a,opacity:l?1:.5})}const r=isDarkColor(e);i&&i.frameColor&&isDarkColor(i.frameColor)||r||(g.push({x:u-1,y:p-1,width:d+2,height:m+2,strokeWidth:2,strokeColor:[0,0,0,.1],opacity:o}),g.push({x:u+1,y:p+1,width:d-2,height:m-2,strokeWidth:2,strokeColor:[0,0,0,.1],opacity:o}))}c([...g,{x:u,y:p,width:d,height:m,strokeWidth:1,strokeColor:e,opacity:o}])})),Rs=writable([]);component_subscribe(e,Rs,(e=>o(402,Ut=e)));const Ps=derived([ks,Rs],(([e,t],o)=>{o([...e,...t])}));component_subscribe(e,Ps,(e=>o(94,qo=e)));const Is=spring(0,{precision:.001});component_subscribe(e,Is,(e=>o(404,Gt=e)));const Es=spring();component_subscribe(e,Es,(e=>o(407,Yt=e)));const Ms=spring();component_subscribe(e,Ms,(e=>o(406,Xt=e)));const As=spring();component_subscribe(e,As,(e=>o(405,qt=e)));const Fs=spring();component_subscribe(e,Fs,(e=>o(403,Ht=e)));const Ls=writable(!1);component_subscribe(e,Ls,(e=>o(389,Tt=e)));const Ds=writable();let zs;component_subscribe(e,Ds,(e=>o(392,Pt=e)));const Os=derived([Ls,Ds],(([e,t],r)=>{if(!e||!t)return void r(void 0);if(zs&&(zs.cancel(),o(295,zs=void 0)),isCanvas(t))return r(canvasClone(t));const n=al.length?0:_t?250:0;o(295,zs={cancel:noop$1}),Gi(t,zs,n).then(r).catch((e=>{set_store_value(fi,Rt.error=e,Rt)})).finally((()=>{o(295,zs=void 0)}))}));or(),or=subscribe(Os,(e=>o(371,Ye=e)));let{imagePreviewCurrent:Bs}=t;const Ns=writable({});component_subscribe(e,Ns,(e=>o(394,At=e)));const Vs=writable([]);component_subscribe(e,Vs,(e=>o(86,Bo=e)));const Ws=derived([qa,$a,ci,Fa,La,vs,Ti,Pi,Ii,ts,os,Ca],(([e,t,o,r,n,i,a,s,l,c,u,p],d)=>{if(!e||!n)return;const h=calculateImageTransforms(e,t,o,r,n,c,u,i,a,s,l);!p&&R(h),d(h)}));component_subscribe(e,Ws,(e=>o(395,Ft=e)));const Us=derived([Ai,Fi,Li,Di,zi],(([e,t,o,r,n],i)=>{const a=e&&Object.keys(e).map((t=>e[t])).filter(Boolean);i({gamma:o||void 0,vignette:r||void 0,noise:n||void 0,convolutionMatrix:t||void 0,colorMatrix:a&&a.length&&getColorMatrixFromColorMatrices(a)})}));let Hs,Gs;const js=canPreventNavSwipe(),qs=writable({});component_subscribe(e,qs,(e=>o(383,$t=e))),setContext("env",qs);const Xs=getDevicePixelRatio(),Ys=readable(Xs,(e=>{const t=()=>e(getDevicePixelRatio()),o=matchMedia(`(resolution: ${Xs}dppx)`);return o.addListener(t),()=>o.removeListener(t)}));component_subscribe(e,Ys,(e=>o(57,Zt=e)));const Zs=historyCreate((()=>Vt),(e=>{set_store_value(Hi,Vt=e,Vt),ba.set(Wt)}),{willUndo:()=>!ol()||(tl(),!1)});rr(),rr=subscribe(Zs,(e=>o(401,Nt=e)));const Ks=()=>{const e={x:0,y:0,...Je},t=rectApply(rectContainRect(e,Vt.cropAspectRatio),Math.round),o=Rr({...Vt,rotation:0,crop:t},Vt),r=[o];JSON.stringify(o)!==JSON.stringify(Vt)&&r.push({...Vt}),Zs.set(r)},Js=fi.subscribe((e=>{e&&e.complete&&Ks()})),Qs=()=>Sr().then((e=>e&&Zs.revert())),el=[Bi,Oi,Vi,Ni],tl=()=>{el.forEach((e=>{e.update((e=>e.length&&shapeIsDraft(e[e.length-1])?e.slice(0,-1):e))}))},ol=()=>E.filter((e=>e.length)).some((e=>shapeIsDraft(e[e.length-1]))),rl=writable(!1);component_subscribe(e,rl,(e=>o(384,yt=e)));const nl=()=>{set_store_value(rl,yt=!0,yt),Cr().then((e=>{if(!e)return void set_store_value(rl,yt=!1,yt);let t;t=Al.subscribe((e=>{1===e&&(t&&t(),ir("processImage"))}))}))},il=$i.subscribe((e=>{if(!e)return void set_store_value(rl,yt=!1,yt);set_store_value(rl,yt=!0,yt);const{complete:t,abort:o}=e;(t||o)&&set_store_value(rl,yt=!1,yt)})),al=storeList();component_subscribe(e,al,(e=>o(55,It=e)));const sl=derived([al],(([e],t)=>{if(!e.length)return t();const{origin:o,translation:r,rotation:n,scale:i}=e[0];t({origin:o,translation:r,rotation:n,scale:i})})),ll=writable();component_subscribe(e,ll,(e=>o(398,zt=e)));let cl,ul=[];const pl=writable(),dl=writable(),hl=derived([Ja,dl,Za,Qa],(([e,t,o,r])=>e||(t||o<1?r:1))),ml={...lr,imageFile:li,imageSize:ci,mediaDuration:ui,mediaMinDuration:mi,mediaMaxDuration:gi,mediaTrim:di,imageBackgroundColor:Ei,imageBackgroundImage:Mi,imageCropAspectRatio:bi,imageCropMinSize:xi,imageCropMaxSize:vi,imageCropLimitToImage:yi,imageCropRect:_i,imageCropRectOrigin:Ci,imageCropRectSnapshot:Ma,imageCropRectAspectRatio:wi,imageCropRange:Si,imageRotation:Ti,imageRotationRange:ki,imageFlipX:Pi,imageFlipY:Ii,imageOutputSize:Ri,imageColorMatrix:Ai,imageConvolutionMatrix:Fi,imageGamma:Li,imageVignette:Di,imageNoise:zi,imageManipulation:Ni,imageDecoration:Oi,imageAnnotation:Bi,imageRedaction:Vi,imageFrame:Wi,imagePreview:Os,imagePreviewSource:Ds,imageTransforms:Ws,imagePreviewModifiers:Ns,history:Zs,animation:ka,pixelRatio:Ys,elasticityMultiplier:vr,scrollElasticity:scrollElasticity,rangeInputElasticity:5,redrawTrigger:Jn,pointerAccuracy:va,pointerHoverable:Sa,env:qs,rootRect:$a,stageRect:qa,stageRectBase:Va,stageRecenter:Na,stageScalar:Za,stagePadding:Ha,stagePadded:Ga,presentationScalar:vs,imagePreviewUpscale:dl,utilRect:xa,utilRectPadded:ja,allowPlayPause:En,allowPan:ra,allowZoom:na,allowZoomControls:ia,enableZoomInput:sa,enablePanInput:aa,enablePanInputStatus:ua,imageSelectionMultiTouching:pl,rootBackgroundColor:pa,rootForegroundColor:da,rootLineColor:ha,rootColorSecondary:ga,imageOutlineOpacity:Ts,utilTools:ll,imageSelectionPan:os,imageSelectionZoom:Ja,imageSelectionZoomCurrent:hl,imageSelectionStageFitScalar:Qa,imageSelectionStoredState:rs,imageOverlayMarkup:Rs,interfaceImages:Vs,isInteracting:wa,isTransformingImage:Ca,isInteractingFraction:Ta,imageCropRectIntent:Aa,imageCropRectPresentation:Fa,imageSelectionRect:La,imageSelectionRectIntent:za,imageSelectionRectPresentation:is,imageSelectionRectSnapshot:Da,imageScalar:xs,imageTransformsInterpolated:sl,imageEffects:Us};delete ml.image;const gl=`util-${getUniqueId()}`;let fl=[];const $l=e=>A.find((([t])=>e===t));let bl=[];const yl=e=>{o(62,bl=bl.concat(e))},_l=e=>{o(62,bl=bl.filter((t=>t!==e)))},xl=(e,t)=>{o(301,z[e]=t,z)};let vl=isIOS();const Sl=(e,t,o)=>{let r=ce.getPropertyValue(e);r=o?o(r):/^[0-9]+$/.test(r)?parseFloat(r):void 0,t.set(r,{hard:!_t})},Cl=(e,t,o=!1)=>{const r=(e=>{const t=ce.getPropertyValue(e);return colorStringToColorArray(t)})(e);r&&0!==r[3]&&(o||(r.length=3),t.set(r,{hard:!_t}))},wl=writable();component_subscribe(e,wl,(e=>o(87,No=e)));const Tl=writable();component_subscribe(e,Tl,(e=>o(88,Vo=e)));const kl=writable();component_subscribe(e,kl,(e=>o(89,Wo=e)));const Rl=spring(0,{damping:.9});component_subscribe(e,Rl,(e=>o(90,Uo=e)));const Pl=()=>{Cl("color",da),Cl(un?"--color-background":"background-color",pa),Cl("outline-color",ha),Cl("--color-primary",ma),Cl("--color-secondary",ga),Cl("--grid-color-even",Tl,!0),Cl("--grid-color-odd",kl,!0),Sl("--grid-size",wl),Sl("--editor-inset-top",ya,(e=>parseInt(e,10)))},Il=derived([Ws,Us,Ei,ea],(([e,t,o,r])=>e&&{...e,...t,backgroundColor:o,backgroundImage:r}));component_subscribe(e,Il,(e=>o(393,Et=e)));const El=e=>{al.forEach(((t,o)=>{const r=0===o?1:0;t.set({...e,opacity:r,resize:1},Mt)}))};let Ml;const Al=tweened(void 0,{duration:500});let Fl;component_subscribe(e,Al,(e=>o(54,Ct=e)));const Ll=writable(!1);let Dl;component_subscribe(e,Ll,(e=>o(388,wt=e)));const zl=spring(void 0,{stiffness:.1,damping:.7,precision:.25});component_subscribe(e,zl,(e=>o(82,Lo=e)));const Ol=spring(0,{stiffness:.1,precision:.05});component_subscribe(e,Ol,(e=>o(83,Do=e)));const Bl=spring(0,{stiffness:.02,damping:.5,precision:.25});component_subscribe(e,Bl,(e=>o(386,vt=e)));const Nl=spring(void 0,{stiffness:.02,damping:.5,precision:.25});component_subscribe(e,Nl,(e=>o(387,St=e)));const Vl=spring(void 0,{stiffness:.02,damping:.5,precision:.25});let Wl;component_subscribe(e,Vl,(e=>o(385,xt=e)));const Ul=()=>{ir("abortLoadImage")},Hl=()=>{ir("abortProcessImage"),set_store_value(rl,yt=!1,yt)},Gl=e=>{e.target&&"true"===e.target.dataset.touchScroll||e.preventDefault()},jl=js?e=>{const t=e.touches?e.touches[0]:e;t.pageX>20&&t.pageX<window.innerWidth-20||Gl(e)}:noop$1,ql=writable([]);component_subscribe(e,ql,(e=>o(479,mt=e))),setContext("keysPressed",ql);const Xl=e=>{!e||isBinary(e)&&!isBitmap(e)||!isBinary(e)&&!/^http/.test(e)||ir("loadImage",e)},Yl=e=>{e&&Xl(e)};let Zl;let Kl,Jl=[];const Ql=writable();setContext("rootPortal",Ql),setContext("rootRect",$a);const ec=()=>({foregroundColor:[...lt],lineColor:[...st],utilVisibility:{...z},isInteracting:at,isInteractingFraction:it,rootRect:rectClone$1(nt),stageRect:rectClone$1(rt),manipulationShapesDirty:$c,annotationShapesDirty:hc,decorationShapesDirty:gc,frameShapesDirty:fc}),tc=(e,t,o)=>shapeComputeDisplay(e,sizeCreate(Math.round(t.width/o),Math.round(t.height/o))),oc=(e,t,o)=>(e._translate=vectorCreateFromAny(t),e._scale=o,e),rc=e=>{const t=[];return e.forEach((e=>t.push(nc(e)))),t.filter(Boolean)},nc=e=>shapeIsLine(e)?(e.points=[vectorCreate(e.x1,e.y1),vectorCreate(e.x2,e.y2)],e):(!shapeIsTextEmpty(e)||e.backgroundColor&&0!==e.backgroundColor[3]||(shapeIsTextBlock(e)&&(e.width=5,e.height=e.lineHeight),e.strokeWidth=1,e.strokeColor=[1,1,1,.5],e.backgroundColor=[0,0,0,.1]),e);let ic,ac=[],sc=[],lc=[],cc=[],uc=[],pc={};const dc=(e,t,o,r,n,i,a)=>{const{manipulationShapesDirty:s,annotationShapesDirty:l,decorationShapesDirty:c,frameShapesDirty:u,selectionRect:p,scale:d}=e,h=ic!==d,m=h||!rectEqual(pc,p);m&&(ic=d,pc=p),s&&(lc=t.filter(shapeIsVisible).map(shapeDeepCopy).map((e=>shapeComputeDisplay(e,Je)))),(l||o!==ot)&&(ac=o.filter(shapeIsVisible).map(shapeDeepCopy).sort(((e,t)=>e.alwaysOnTop?1:t.alwaysOnTop?-1:0)).map((e=>shapeComputeDisplay(e,Je)))),(h||mc||l||o!==ot)&&(sc=rc(ac.map((e=>f(e,{flipX:et,flipY:Qe,rotation:tt,scale:d,context:rectCreateFromSize(Je)}))).flat())),(c||r!==Ke||m)&&(cc=rc(r.filter(shapeIsVisible).map(shapeDeepCopy).sort(((e,t)=>e.alwaysOnTop?1:t.alwaysOnTop?-1:0)).map((e=>tc(e,p,d))).map((e=>f(e,{context:p}))).flat().map((e=>oc(e,p,d))))),(u||i!==Ze||m)&&(uc=i?rc([i].map(shapeDeepCopy).map((e=>tc(e,p,d))).map(f).flat().map((e=>oc(e,p,d)))):[]);let g=rc(n.filter(shapeIsVisible));return{manipulationShapesDirty:s,manipulationShapes:lc,annotationShapesDirty:l,annotationShapes:sc,decorationShapesDirty:c,decorationShapes:cc,frameShapesDirty:u,frameShapes:uc,interfaceShapes:g,selectionShapes:a.map(shapeDeepCopy).map((e=>shapeComputeDisplay(e,Je)))}};let hc=!0;let mc=!0;let gc=!0;let fc=!0;let $c=!0;onDestroy((()=>{Wn(),Ye&&isString(Ye.src)&&/^blob:/.test(Ye.src)&&URL.revokeObjectURL(Ye.src),ta(),gs(),ms(),fs(),bs(),ys(),_s(),Js(),il(),va.destroy(),Sa.destroy(),si.destroy(),al.clear(),ac.length=0,sc.length=0,lc.length=0,cc.length=0,uc.length=0;try{o(235,Bs=void 0),o(296,Ml=void 0)}catch(e){}}));return e.$$set=e=>{"class"in e&&o(236,ar=e.class),"layout"in e&&o(237,sr=e.layout),"stores"in e&&o(238,lr=e.stores),"locale"in e&&o(3,cr=e.locale),"id"in e&&o(4,ur=e.id),"util"in e&&o(239,pr=e.util),"utils"in e&&o(240,dr=e.utils),"animations"in e&&o(241,hr=e.animations),"disabled"in e&&o(242,mr=e.disabled),"previewUpscale"in e&&o(243,gr=e.previewUpscale),"previewPad"in e&&o(244,fr=e.previewPad),"previewMaskOpacity"in e&&o(5,$r=e.previewMaskOpacity),"previewImageDataMaxSize"in e&&o(245,br=e.previewImageDataMaxSize),"previewImageTextPixelRatio"in e&&o(6,yr=e.previewImageTextPixelRatio),"markupMaskOpacity"in e&&o(7,_r=e.markupMaskOpacity),"zoomMaskOpacity"in e&&o(246,xr=e.zoomMaskOpacity),"elasticityMultiplier"in e&&o(8,vr=e.elasticityMultiplier),"willRevert"in e&&o(247,Sr=e.willRevert),"willProcessImage"in e&&o(248,Cr=e.willProcessImage),"willRenderCanvas"in e&&o(9,wr=e.willRenderCanvas),"willRenderToolbar"in e&&o(249,Tr=e.willRenderToolbar),"willRenderUtilTabs"in e&&o(250,kr=e.willRenderUtilTabs),"willSetHistoryInitialState"in e&&o(251,Rr=e.willSetHistoryInitialState),"enableButtonExport"in e&&o(252,Pr=e.enableButtonExport),"enableButtonRevert"in e&&o(253,Ir=e.enableButtonRevert),"enableNavigateHistory"in e&&o(254,Er=e.enableNavigateHistory),"enableToolbar"in e&&o(10,Mr=e.enableToolbar),"enableUtils"in e&&o(255,Ar=e.enableUtils),"enableButtonClose"in e&&o(256,Fr=e.enableButtonClose),"enableDropImage"in e&&o(257,Lr=e.enableDropImage),"enablePasteImage"in e&&o(258,Dr=e.enablePasteImage),"enableBrowseImage"in e&&o(259,zr=e.enableBrowseImage),"enableTransparencyGrid"in e&&o(11,Or=e.enableTransparencyGrid),"layoutDirectionPreference"in e&&o(260,Br=e.layoutDirectionPreference),"layoutHorizontalUtilsPreference"in e&&o(261,Nr=e.layoutHorizontalUtilsPreference),"layoutVerticalUtilsPreference"in e&&o(262,Vr=e.layoutVerticalUtilsPreference),"layoutVerticalToolbarPreference"in e&&o(263,Wr=e.layoutVerticalToolbarPreference),"layoutVerticalControlGroupsPreference"in e&&o(264,Ur=e.layoutVerticalControlGroupsPreference),"layoutVerticalControlTabsPreference"in e&&o(265,Hr=e.layoutVerticalControlTabsPreference),"status"in e&&o(234,Gr=e.status),"formatStatusImageLoading"in e&&o(266,jr=e.formatStatusImageLoading),"formatStatusImageProcessing"in e&&o(267,qr=e.formatStatusImageProcessing),"formatStatusSupportError"in e&&o(268,Xr=e.formatStatusSupportError),"textDirection"in e&&o(12,Yr=e.textDirection),"markupEditorZoomLevel"in e&&o(269,Zr=e.markupEditorZoomLevel),"markupEditorZoomLevels"in e&&o(13,Kr=e.markupEditorZoomLevels),"markupEditorZoomAdjustStep"in e&&o(14,Jr=e.markupEditorZoomAdjustStep),"markupEditorZoomAdjustFactor"in e&&o(15,Qr=e.markupEditorZoomAdjustFactor),"markupEditorZoomAdjustWheelFactor"in e&&o(16,en=e.markupEditorZoomAdjustWheelFactor),"markupEditorInteractionMode"in e&&o(270,tn=e.markupEditorInteractionMode),"muteAudio"in e&&o(271,on=e.muteAudio),"willSetMediaInitialTimeOffset"in e&&o(272,rn=e.willSetMediaInitialTimeOffset),"enablePan"in e&&o(17,nn=e.enablePan),"enableZoom"in e&&o(18,an=e.enableZoom),"enableZoomControls"in e&&o(273,sn=e.enableZoomControls),"enableZoomInput"in e&&o(19,ln=e.enableZoomInput),"enablePanInput"in e&&o(274,cn=e.enablePanInput),"enableCanvasAlpha"in e&&o(20,un=e.enableCanvasAlpha),"enablePanLimit"in e&&o(21,pn=e.enablePanLimit),"panLimitGutterScalar"in e&&o(22,dn=e.panLimitGutterScalar),"pan"in e&&o(275,hn=e.pan),"zoomPresetOptions"in e&&o(23,mn=e.zoomPresetOptions),"zoomAdjustStep"in e&&o(24,gn=e.zoomAdjustStep),"zoomAdjustFactor"in e&&o(25,fn=e.zoomAdjustFactor),"zoomAdjustWheelFactor"in e&&o(26,$n=e.zoomAdjustWheelFactor),"zoomLevel"in e&&o(0,bn=e.zoomLevel),"fixScrollDirection"in e&&o(276,yn=e.fixScrollDirection),"imagePreviewSrc"in e&&o(279,Sn=e.imagePreviewSrc),"imageOrienter"in e&&o(280,Cn=e.imageOrienter),"pluginComponents"in e&&o(281,wn=e.pluginComponents),"pluginOptions"in e&&o(27,Tn=e.pluginOptions),"root"in e&&o(2,Pn=e.root),"imageSourceToImageData"in e&&o(28,ai=e.imageSourceToImageData),"imagePreviewCurrent"in e&&o(235,Bs=e.imagePreviewCurrent)},e.$$.update=()=>{if(268435456&e.$$.dirty[8]&&_n.set(yn),8&e.$$.dirty[0]&&o(353,r=!!cr),1&e.$$.dirty[0]|2097152&e.$$.dirty[8]&&o(0,bn=null===bn?Zr:bn),2&e.$$.dirty[0]|4&e.$$.dirty[9]){let e=!1;wn.forEach((([t])=>{Rn[t]||(o(1,Rn[t]={},Rn),e=!0)})),e&&o(293,ei=[...wn])}if(8388608&e.$$.dirty[7]|16384&e.$$.dirty[9]|4096&e.$$.dirty[11]&&o(351,M=r&&ei.length?dr||ei.map((([e])=>e)):[]),134217728&e.$$.dirty[0]|16384&e.$$.dirty[9]|1024&e.$$.dirty[11]|134217728&e.$$.dirty[12]&&o(352,A=((e,t,o,r)=>{const n=t.filter((([t])=>e.includes(t))).filter((([e,{isSupported:t}])=>t({...r,...o[e]}))).map((([e,t])=>[e,t.Component]));return arrayEqual(n,fl,((e,t)=>e[0]===t[0]&&e[1]===t[1]))?fl:(fl=n,n)})(M,ei,Tn,{src:Ot})),2048&e.$$.dirty[11]&&o(305,F=A.length),8&e.$$.dirty[0]|67108864&e.$$.dirty[9]|1024&e.$$.dirty[11]&&o(350,L=F&&M.map((e=>{const t=$l(e);if(t)return{id:e,view:t[1],tabIcon:cr[`${e}Icon`],tabLabel:cr[`${e}Label`]}})).filter(Boolean)||[]),512&e.$$.dirty[11]&&o(370,n=!!L.find((e=>"trim"===e.id))),1610612736&e.$$.dirty[11]|1048576&e.$$.dirty[13]&&o(304,i=!!(Eo&&Ye&&n)),4194304&e.$$.dirty[7]|67108864&e.$$.dirty[9]&&o(43,D=F&&pr&&"string"==typeof pr&&$l(pr)?pr:F>0?A[0][0]:void 0),4096&e.$$.dirty[1]|33554432&e.$$.dirty[9]&&i&&D&&Wn(),33554432&e.$$.dirty[9]|1073741824&e.$$.dirty[11]&&(i?(Ye.addEventListener("play",Ln),Ye.addEventListener("pause",Ln)):Ye&&"video"===Ye.nodeName&&(Ye.removeEventListener("play",Ln),Ye.removeEventListener("pause",Ln))),33554432&e.$$.dirty[9]&&i&&An.set(Zn()/Yn()),4718592&e.$$.dirty[13]&&(e=>{if(!Un())return;const t=Date.now();if(zn&&t-zn<frameUpdateRequestDist)return;zn=t;const o=Eo*e;if(o.toFixed(1)===Dn)return;Dn=o.toFixed(1);const r=Ye,n=()=>{r.removeEventListener("seeked",n),In()};r.addEventListener("seeked",n),fastSeek(r,o)})(Ao||Io),524288&e.$$.dirty[13]&&o(368,a=Io&&fixPrecision(Io,6)),9568256&e.$$.dirty[13]&&o(366,s=wo||[[0,Math.min(Eo,Fo)/Eo]]),33554432&e.$$.dirty[11]&&(l=s[0][0]),33554432&e.$$.dirty[11]&&(c=s[s.length-1][1]),33554432&e.$$.dirty[11]&&o(369,u=s.map((([e,t])=>[fixPrecision(e,6),fixPrecision(t,6)]))),402653184&e.$$.dirty[11]&&o(367,p=u.findIndex((([e,t])=>a>=e&&a<=t))),469762048&e.$$.dirty[11]&&(d=-1===p&&u.findIndex(((e,t,o)=>{const r=o[t-1];return r?a<=e[0]&&a>=r[1]:a<=e[0]}))),8388608&e.$$.dirty[8]&&Xn.set(on),1073741824&e.$$.dirty[11]|2097152&e.$$.dirty[13]&&(Ye&&Mo?Gn():jn()),33554432&e.$$.dirty[9]|524288&e.$$.dirty[13]&&i&&pi.set(Yn()*Io),1073741824&e.$$.dirty[11]|262144&e.$$.dirty[13]&&Ye&&(e=>{if(!i)return;Ye.volume=Math.min(1,e)})(Po),256&e.$$.dirty[0]&&set_store_value(Qn,Ro=vr,Ro),1048576&e.$$.dirty[7]&&o(362,h="overlay"===sr),128&e.$$.dirty[8]|2097152&e.$$.dirty[11]&&o(45,m=Ar&&!h),134217730&e.$$.dirty[0]&&Tn&&Object.entries(Tn).forEach((([e,t])=>{Object.entries(t).forEach((([t,r])=>{Rn[e]&&o(1,Rn[e][t]=r,Rn)}))})),4096&e.$$.dirty[13]&&o(363,y=!fo),16777216&e.$$.dirty[7]|12582912&e.$$.dirty[11]&&set_store_value(Ra,_t="always"===hr?$:"never"!==hr&&($&&y),_t),4194304&e.$$.dirty[1]|33554432&e.$$.dirty[7]&&ti.set(mr?1:0,{hard:!_t}),268435456&e.$$.dirty[7]&&(g=br?sizeMin(br,ri):ri),65536&e.$$.dirty[13]&&si.update(Co[0]),32768&e.$$.dirty[13]&&(f=So?(e,t)=>So(e,{flipX:void 0,flipY:void 0,rotation:void 0,...t,isPreview:!0}):passthrough),268435456&e.$$.dirty[1]&&Array.isArray(vo)&&ir("selectionchange",[...vo]),33554432&e.$$.dirty[8]|16384&e.$$.dirty[13]&&la.set(xo&&sn),71303168&e.$$.dirty[8]&&ca.set("pan"===tn||cn),1048576&e.$$.dirty[1]&&ft&&$a.set(rectCreate(ft.x,ft.y,ft.width,ft.height)),2097152&e.$$.dirty[11]|524304&e.$$.dirty[12]&&nt&&h&&Rt&&Rt.complete&&(()=>{const e=bo,t=rectAspectRatio(nt);e&&e===t||(bi.set(rectAspectRatio(nt)),Ks())})(),1024&e.$$.dirty[11]&&o(46,V=M.length>1),32768&e.$$.dirty[1]&&(V||ba.set(rectCreateEmpty())),1024&e.$$.dirty[0]|8192&e.$$.dirty[13]&&(Mr||_a.set(rectCreate(0,$o,0,0))),8388608&e.$$.dirty[11]|32&e.$$.dirty[12]&&o(365,b=!at&&$),1048576&e.$$.dirty[1]&&o(306,Ve=ft&&ft.width>0&&ft.height>0),8&e.$$.dirty[0]|201326592&e.$$.dirty[9]&&o(40,We=Ve&&cr&&!!F),512&e.$$.dirty[1]&&setTimeout((()=>o(294,Pa=We)),1),16777216&e.$$.dirty[7]|32768&e.$$.dirty[9]|20971520&e.$$.dirty[11]&&set_store_value(ka,Mt="always"===hr?b:"never"!==hr&&(b&&Pa&&y),Mt),67108864&e.$$.dirty[7]|2097152&e.$$.dirty[11]&&Ia.set(gr||h),134217728&e.$$.dirty[7]&&Ua.set(fr),134217728&e.$$.dirty[8]&&hn&&os.set(hn),4&e.$$.dirty[0]|2304&e.$$.dirty[13]&&Pn&&(Pn.dispatchEvent(createPing("markupzoom",go)),Pn.dispatchEvent(createPing("zoom",isNumber(go)?go:lo))),4&e.$$.dirty[0]|1024&e.$$.dirty[13]&&Pn&&(Pn.dispatchEvent(createPing("markuppan",po)),Pn.dispatchEvent(createPing("pan",po))),128&e.$$.dirty[13]&&oo&&ns(),512&e.$$.dirty[13]&&co&&ss(),4198400&e.$$.dirty[1]&&D&&Ts.set(.075,{hard:!_t}),536870912&e.$$.dirty[7]&&o(360,_=xr),96&e.$$.dirty[13]&&o(361,x=Qt?-Math.max(...Object.values(Jt)):0),138936320&e.$$.dirty[1]|1572864&e.$$.dirty[11]&&Kt){let e=Kt.x-rt.x,t=rt.x+rt.width-(Kt.x+Kt.width),o=Kt.y-rt.y,r=rt.y+rt.height-(Kt.y+Kt.height),n=Math.min(e,o,t,r);Is.set(n>x?0:Math.min(_,Math.abs(n/64)),{hard:!_t})}if(67108864&e.$$.dirty[1]&&o(359,v=.55/Zt),4718592&e.$$.dirty[1]|262144&e.$$.dirty[11]&&rt&&Es.set({x:0,y:rt.y,width:rt.x<64?0:rt.x,height:rt.height+v},{hard:!_t}),4718592&e.$$.dirty[1]|262144&e.$$.dirty[11]|16&e.$$.dirty[12]&&rt&&Ms.set({x:0,y:0,width:nt.width,height:rt.y+v},{hard:!_t}),4718592&e.$$.dirty[1]|262144&e.$$.dirty[11]|16&e.$$.dirty[12]&&rt){let e=rt.x+rt.width,t=nt.width-(rt.x+rt.width);t<64&&(e+=t,t=0),As.set({x:e,y:rt.y,width:t,height:rt.height+v},{hard:!_t})}var t,R;if(4718592&e.$$.dirty[1]|16&e.$$.dirty[12]&&rt&&Fs.set({x:0,y:rt.y+rt.height,width:nt.width,height:nt.height-(rt.y+rt.height)},{hard:!_t}),33554432&e.$$.dirty[1]|18&e.$$.dirty[13]&&o(355,S=Yt&&{id:OVERLAY_ID,backgroundColor:jt,opacity:Gt,...Yt}),33554432&e.$$.dirty[1]|10&e.$$.dirty[13]&&o(358,C=Xt&&{id:OVERLAY_ID,backgroundColor:jt,opacity:Gt,...Xt}),33554432&e.$$.dirty[1]|6&e.$$.dirty[13]&&o(357,w=qt&&{id:OVERLAY_ID,backgroundColor:jt,opacity:Gt,...qt}),33554432&e.$$.dirty[1]|3&e.$$.dirty[13]&&o(356,T=Ht&&{id:OVERLAY_ID,backgroundColor:jt,opacity:Gt,...Ht}),245760&e.$$.dirty[11]&&o(354,k=[C,w,T,S].filter(Boolean)),8192&e.$$.dirty[11]|1073741824&e.$$.dirty[12]&&k&&Ut&&Rs.update((e=>[...e.filter((e=>e.id!==OVERLAY_ID)),...k])),1&e.$$.dirty[9]|134217728&e.$$.dirty[12]&&Ds.set(Sn||(Ot||void 0)),4&e.$$.dirty[0]|262144&e.$$.dirty[7]|1073741824&e.$$.dirty[11]&&(o(235,Bs=Ye),Ye&&Pn.dispatchEvent(createPing("loadpreview",Bs))),1048576&e.$$.dirty[12]&&Pt&&(os.set(vectorCreateEmpty()),Ja.set(void 0),ns(),Vs.set([])),536870912&e.$$.dirty[12]&&o(310,P=Nt.index>0),536870912&e.$$.dirty[12]&&o(309,I=Nt.index<Nt.length-1),393216&e.$$.dirty[1]|192&e.$$.dirty[12]&&(E=[ot,Ke,ut,ct]),8&e.$$.dirty[1]&&pl.set(cl),268435456&e.$$.dirty[12]&&dl.set(Bt),4096&e.$$.dirty[1]&&oa.set(D),4194304&e.$$.dirty[9]|512&e.$$.dirty[11]&&o(301,z=L.reduce(((e,t)=>(e[t.id]=z&&z[t.id]||0,e)),{})),4096&e.$$.dirty[1]&&o(79,O={name:gl,selected:D}),512&e.$$.dirty[11]&&o(332,B=L.map((e=>({id:e.id,icon:e.tabIcon,label:e.tabLabel})))),512&e.$$.dirty[11]&&o(78,N=L.map((e=>e.id))),524288&e.$$.dirty[7]&&o(77,W=arrayJoin(["PinturaRoot","PinturaRootComponent",ar])),16&e.$$.dirty[12]&&o(346,U=nt&&(nt.width>1e3?"wide":nt.width<600?"narrow":void 0)),16&e.$$.dirty[12]&&o(333,H=nt&&(nt.width<=320||nt.height<=460)),16&e.$$.dirty[12]&&o(345,G=nt&&(nt.height>1e3?"tall":nt.height<600?"short":void 0)),4&e.$$.dirty[0]&&o(312,j=Pn&&Pn.parentNode&&Pn.parentNode.classList.contains("PinturaModal")),1&e.$$.dirty[1]|4&e.$$.dirty[10]|16&e.$$.dirty[12]&&o(338,q=j&&nt&&Hs>nt.width),2&e.$$.dirty[1]|4&e.$$.dirty[10]|16&e.$$.dirty[12]&&o(337,X=j&&nt&&Gs>nt.height),402653184&e.$$.dirty[10]&&o(339,Y=q&&X),1048576&e.$$.dirty[0]&&o(336,Z=un),32&e.$$.dirty[11]&&o(307,K="narrow"===U),4096&e.$$.dirty[8]|16&e.$$.dirty[12]&&o(347,(t=nt,R=Br,J=nt?"auto"===R?t.width>t.height?"landscape":"portrait":"horizontal"===R?t.width<500?"portrait":"landscape":"vertical"===R?t.height<400?"landscape":"portrait":void 0:"landscape")),64&e.$$.dirty[11]&&o(76,Q="landscape"===J),268435456&e.$$.dirty[9]|16&e.$$.dirty[11]&&o(335,ee=K||"short"===G),1&e.$$.dirty[1]|16&e.$$.dirty[12]&&o(334,te=vl&&nt&&Hs===nt.width&&!js),4&e.$$.dirty[1]|67108864&e.$$.dirty[12]&&o(308,oe=[...zt||[],...ul].filter(Boolean)),8192&e.$$.dirty[8]&&o(344,re=`has-navigation-preference-${Nr}`),16384&e.$$.dirty[8]&&o(343,ne=`has-navigation-preference-${Vr}`),32768&e.$$.dirty[8]&&o(340,ie=`has-toolbar-preference-${Wr}`),65536&e.$$.dirty[8]&&o(342,ae=`has-controlgroups-preference-${Ur}`),131072&e.$$.dirty[8]&&o(341,se=`has-controltabs-preference-${Hr}`),16&e.$$.dirty[12]&&o(349,le=void 0!==nt&&nt.width>0&&nt.height>0),4&e.$$.dirty[0]|256&e.$$.dirty[11]&&o(348,ce=le&&Pn&&getComputedStyle(Pn)),128&e.$$.dirty[11]&&ce&&Pl(),1024&e.$$.dirty[0]|4243456&e.$$.dirty[1]|34603008&e.$$.dirty[7]|2139095044&e.$$.dirty[10]|127&e.$$.dirty[11]|50333696&e.$$.dirty[12]&&qs.set({...$t,layoutMode:sr,orientation:J,horizontalSpace:U,verticalSpace:G,navigationHorizontalPreference:re,navigationVerticalPreference:ne,controlGroupsVerticalPreference:ae,controlTabsVerticalpreference:se,toolbarVerticalPreference:ie,isModal:j,isDisabled:mr,isCentered:Y,isCenteredHorizontally:q,isCenteredVertically:X,isAnimated:_t,isTransparent:Z,pointerAccuracy:Dt,pointerHoverable:Lt,isCompact:ee,hasSwipeNavigation:te,hasLimitedSpace:H,hasToolbar:Mr,hasNavigation:V&&m,isIOS:vl,browserVersion:isChrome()?`chrome-${(navigator.userAgent.match(/Chrome\/([0-9]+)/)||[])[1]}`:void 0}),2048&e.$$.dirty[12]&&o(75,ue=Object.entries($t).map((([e,t])=>/^is|has/.test(e)?t?toKebabCase(e):void 0:t)).filter(Boolean).join(" ")),4096&e.$$.dirty[1]&&D&&ll.set([]),4096&e.$$.dirty[1]|4&e.$$.dirty[8]|4194304&e.$$.dirty[10]|2048&e.$$.dirty[12]&&o(44,pe=kr(B.map((e=>({...e,selected:D===e.id}))),{...$t},(()=>Jn.set({})))),8192&e.$$.dirty[1]&&o(74,de=!!pe.find((e=>Array.isArray(e)))),12582912&e.$$.dirty[12]&&o(73,he=Ft&&Object.entries(At).filter((([,e])=>null!=e)).reduce(((e,[,t])=>e={...e,...t}),{})),524288&e.$$.dirty[12]&&o(329,$e=Rt&&"any-to-file"===Rt.task),524288&e.$$.dirty[10]&&$e&&al&&al.clear(),2097152&e.$$.dirty[12]&&o(331,me=!!Et&&!!Et.translation),131072&e.$$.dirty[9]|2097152&e.$$.dirty[10]|1073741824&e.$$.dirty[11]&&me&&Ye&&Ye!==Ml&&(o(296,Ml=Ye),(()=>{const e=al.length?void 0:{resize:1.05},t=createImage(Ye,Je,e);al.unshift(t),El(Et)})()),2097152&e.$$.dirty[10]|2097152&e.$$.dirty[12]&&me&&El(Et),16777216&e.$$.dirty[1]&&It&&It.length>1){let e=[];al.forEach(((t,o)=>{0!==o&&t.get().opacity<=0&&e.push(t)})),e.forEach((e=>al.remove(e)))}if(8&e.$$.dirty[0]|1048576&e.$$.dirty[10]&&o(39,fe=cr&&ge.length&&function(e,t){if(isFunction(t.labelSupportError))return t.labelSupportError(e);const o=Xr({features:e},t);return stringReplace(t.labelSupportError,o,"{","}")}(ge,cr)),524288&e.$$.dirty[12]&&o(321,be=Rt&&!!Rt.error),524288&e.$$.dirty[12]&&o(42,ye=!Rt||!Rt.complete&&void 0===Rt.task),524288&e.$$.dirty[12]&&o(322,_e=Rt&&(Rt.taskLengthComputable?Rt.taskProgress:1/0)),524288&e.$$.dirty[10]&&$e&&set_store_value(Ls,Tt=!1,Tt),4194304&e.$$.dirty[1]|262144&e.$$.dirty[9]|524288&e.$$.dirty[12]&&Rt&&Rt.complete){const e=_t?250:0;clearTimeout(Fl),o(297,Fl=setTimeout((()=>{set_store_value(Ls,Tt=!0,Tt)}),e))}if(2048&e.$$.dirty[1]|2048&e.$$.dirty[10]|655360&e.$$.dirty[12]&&o(326,xe=Rt&&!be&&!ye&&!Tt),65536&e.$$.dirty[9]|1073741824&e.$$.dirty[11]|1048576&e.$$.dirty[12]&&o(325,ve=!(!Pt||Ye&&!zs)),4194304&e.$$.dirty[1]|131072&e.$$.dirty[12])if(Tt){setTimeout((()=>Rl.set(1,{hard:!_t})),_t?500:0)}else Rl.set(0,{hard:!_t});if(266240&e.$$.dirty[12]&&o(320,Se=!!(yt||kt&&void 0!==kt.progress&&!kt.complete)),1024&e.$$.dirty[10]&&Se&&Wn(),2048&e.$$.dirty[1]|524288&e.$$.dirty[12]&&o(323,Ce=Rt&&!(Rt.error||ye)),8&e.$$.dirty[0]|524288&e.$$.dirty[12]&&o(324,we=cr&&function(e,t){const o=e?!e.complete||e.error?e:{task:"blob-to-bitmap",progress:1/0}:void 0;let r=isFunction(t.statusLabelLoadImage)?t.statusLabelLoadImage(o):jr({state:o},t);return e&&e.error&&e.error.metadata&&(r=stringReplace(r,e.error.metadata,"{","}")),r}(Rt,cr)),8&e.$$.dirty[0]|262144&e.$$.dirty[12]&&o(319,Te=kt&&cr&&function(e,t){return isFunction(t.statusLabelProcessImage)?t.statusLabelProcessImage(e):qr({state:e},t)}(kt,cr)),262144&e.$$.dirty[12]&&o(317,ke=kt&&(kt.taskLengthComputable?kt.taskProgress:1/0)),262144&e.$$.dirty[12]&&o(318,Re=kt&&!kt.error),262144&e.$$.dirty[12]&&o(316,Pe=!(!kt||!kt.error)),8&e.$$.dirty[0]|2048&e.$$.dirty[1]|131072&e.$$.dirty[7]|131008&e.$$.dirty[10])if(Gr){let e,t,r,n,i;isString(Gr)&&(e=Gr),isNumber(Gr)?t=Gr:Array.isArray(Gr)&&([e,t,i]=Gr,!1===t&&(n=!0),isNumber(t)&&(r=!0)),o(35,Dl=(e||t)&&{text:e,aside:n||r,progressIndicator:{visible:r,progress:t},closeButton:n&&{label:cr.statusLabelButtonClose,icon:cr.statusIconButtonClose,onclick:i||(()=>o(234,Gr=void 0))}})}else o(35,Dl=cr&&ye||be||xe||ve?{text:we,aside:be||Ce,progressIndicator:{visible:Ce,progress:_e},closeButton:be&&{label:cr.statusLabelButtonClose,icon:cr.statusIconButtonClose,onclick:Ul}}:cr&&Se&&Te?{text:Te,aside:Pe||Re,progressIndicator:{visible:Re,progress:ke},closeButton:Pe&&{label:cr.statusLabelButtonClose,icon:cr.statusIconButtonClose,onclick:Hl}}:void 0);if(131072&e.$$.dirty[7]&&o(328,Ie=void 0!==Gr),4194304&e.$$.dirty[1]|4&e.$$.dirty[10]|262144&e.$$.dirty[12]&&j&&kt&&kt.complete&&(Ll.set(!0),setTimeout((()=>Ll.set(!1)),_t?100:0)),4&e.$$.dirty[0]|4096&e.$$.dirty[1]|131072&e.$$.dirty[12]&&Tt&&Pn&&Pn.dispatchEvent(createPing("selectutil",D)),2304&e.$$.dirty[1]|363520&e.$$.dirty[10]|65536&e.$$.dirty[12]&&o(327,Ee=wt||fe||ye||be||xe||ve||Se||Ie),131072&e.$$.dirty[10]&&set_store_value(Al,Ct=Ee?1:0,Ct),4194304&e.$$.dirty[1]|131072&e.$$.dirty[10]&&Al.set(Ee?1:0,{duration:_t?500:1}),8388608&e.$$.dirty[1]&&o(41,Me=Ct>0),16&e.$$.dirty[1]&&o(315,Ae=!(!Dl||!Dl.aside)),4195344&e.$$.dirty[1]|524288&e.$$.dirty[9]|32&e.$$.dirty[10]|32768&e.$$.dirty[12]&&Me&&Dl){clearTimeout(Wl);const e={hard:!1===_t};if(Ae){const t=!!Dl.error||!_t;Ol.set(1,e),zl.set(St,{hard:t}),o(298,Wl=setTimeout((()=>{Bl.set(16,e)}),1))}else Ol.set(0,e),o(298,Wl=setTimeout((()=>{Bl.set(0,e)}),1))}if(1024&e.$$.dirty[1]&&(Me||(Vl.set(void 0,{hard:!0}),zl.set(void 0,{hard:!0}),Bl.set(0,{hard:!0}))),16384&e.$$.dirty[12]&&o(314,Fe=.5*vt),16&e.$$.dirty[10]|8192&e.$$.dirty[12]&&o(72,Le=`translateX(${xt-Fe}px)`),256&e.$$.dirty[1]|1073741824&e.$$.dirty[11]|1&e.$$.dirty[12]&&o(38,qe=Ye&&Je&&!fe),128&e.$$.dirty[1]|12&e.$$.dirty[10]&&o(311,ze=De&&(qe||j)?Gl:noop$1),2&e.$$.dirty[10]&&o(71,Oe=ze),2&e.$$.dirty[10]&&o(70,Be=ze),8&e.$$.dirty[0]|2097152&e.$$.dirty[1]|370&e.$$.dirty[8]|1879048192&e.$$.dirty[9]|1&e.$$.dirty[10]|2048&e.$$.dirty[12]&&o(69,Ne=cr&&bt&&runSafe((()=>Tr([["div","alpha",{class:"PinturaNavGroup"},[["div","alpha-set",{class:"PinturaNavSet"},[Fr&&["Button","close",{label:cr.labelClose,icon:cr.iconButtonClose,onclick:()=>ir("close"),hideLabel:!0}],Ir&&["Button","revert",{label:cr.labelButtonRevert,icon:cr.iconButtonRevert,disabled:!P,onclick:Qs,hideLabel:!0}]]]]],["div","beta",{class:"PinturaNavGroup PinturaNavGroupFloat"},[Er&&["div","history",{class:"PinturaNavSet"},[["Button","undo",{label:cr.labelButtonUndo,icon:cr.iconButtonUndo,disabled:!P,onclick:Zs.undo,hideLabel:!0}],["Button","redo",{label:cr.labelButtonRedo,icon:cr.iconButtonRedo,disabled:!I,onclick:Zs.redo,hideLabel:!0}]]],oe.length&&["div","plugin-tools",{class:"PinturaNavSet"},oe.filter(Boolean).map((([e,t,o])=>[e,t,{...o}]))]]],["div","gamma",{class:"PinturaNavGroup"},[Pr&&["Button","export",{label:cr.labelButtonExport,icon:K&&cr.iconButtonExport,class:"PinturaButtonExport",onclick:nl,hideLabel:K}]]]],{...$t},(()=>Jn.set({})))))),128&e.$$.dirty[12]&&o(303,Ue=ut&&!!ut.length),16777216&e.$$.dirty[9]|129&e.$$.dirty[12]&&o(302,He=Ue&&getImageRedactionScaleFactor(Je,ut)),25165824&e.$$.dirty[9]|1073741824&e.$$.dirty[11]|1536&e.$$.dirty[12]&&Ue&&((e,t,r,n)=>{if(!t)return;const i={dataSizeScalar:r};n&&n[3]>0&&(i.backgroundColor=[...n]),t(e,i).then((e=>{Zl&&releaseCanvas(Zl),o(299,Zl=e)}))})(Ye,ht,He,dt),1048576&e.$$.dirty[9]|385&e.$$.dirty[12]&&ut&&Zl&&Je){const{width:e,height:t}=Je,r=isSafari()?"pixelated":"auto"===pt?"auto":"pixelated";o(300,Jl=ut.map((o=>{const n=rectCreate(o.x,o.y,o.width,o.height),i=rectRotate(rectClone$1(n),o.rotation).map((o=>vectorCreate(o.x/e,o.y/t)));return{...o,id:"redaction",flipX:!1,flipY:!1,cornerRadius:0,strokeWidth:0,strokeColor:void 0,backgroundColor:[0,0,0,0],backgroundImage:Zl,backgroundImageRendering:r,backgroundCorners:i}})))}2097152&e.$$.dirty[9]|64&e.$$.dirty[12]&&o(37,Ge=[...Jl,...ct||[]]),32&e.$$.dirty[1]&&Kl&&Ql.set(Kl),4&e.$$.dirty[0]|128&e.$$.dirty[1]&&qe&&Pn&&Pn.dispatchEvent(createPing("ready")),262144&e.$$.dirty[1]&&o(63,hc=!0),15&e.$$.dirty[12]&&o(64,mc=!0),131072&e.$$.dirty[1]&&o(65,gc=!0),65536&e.$$.dirty[1]&&o(66,fc=!0),64&e.$$.dirty[1]&&o(67,$c=!0)},o(364,$=!isSoftwareRendering()),R=1===getDevicePixelRatio()?e=>{e&&(vectorApply(e.origin,Math.round),vectorApply(e.translation,Math.round))}:passthrough,o(330,ge=[!supportsWebGL()&&"WebGL"].filter(Boolean)),o(313,De=isIOS()||isAndroid()&&isFirefox()),o(68,je=createPingRouter(nr.pub)),[bn,Rn,Pn,cr,ur,$r,yr,_r,vr,wr,Mr,Or,Yr,Kr,Jr,Qr,en,nn,an,ln,un,pn,dn,mn,gn,fn,$n,Tn,ai,Os,Zs,Hs,Gs,ul,cl,Dl,Kl,Ge,qe,fe,We,Me,ye,D,pe,m,V,Ze,Ke,ot,rt,ft,bt,_t,Ct,It,jt,Zt,Kt,vo,xn,vn,bl,hc,mc,gc,fc,$c,je,Ne,Be,Oe,Le,he,de,ue,Q,W,N,O,Wt,ko,Lo,Do,zo,Oo,Bo,No,Vo,Wo,Uo,Ho,Go,jo,qo,Xo,Yo,Zo,Ko,Jo,Qo,er,tr,En,Mn,An,Xn,Jn,Qn,ti,li,ci,ui,pi,di,hi,gi,fi,$i,bi,yi,_i,Ti,Pi,Ii,Ei,Oi,Bi,Ni,Vi,Wi,Ui,Hi,ji,qi,Xi,Yi,Zi,Ki,Ji,ra,na,ia,aa,sa,la,ca,ua,pa,da,ha,ma,fa,$a,ba,ya,_a,xa,va,Sa,wa,Ta,ka,Ra,Ia,Ea,Ma,Aa,La,Da,za,Oa,Ha,Ga,qa,Ya,Za,Ja,es,ts,os,is,as,ls,vs,Rs,Ps,Is,Es,Ms,As,Fs,Ls,Ds,Ns,Vs,Ws,qs,Ys,rl,al,ll,ml,yl,_l,xl,(e,t)=>t[e],e=>L.find((t=>t.id===e)).view,wl,Tl,kl,Rl,({target:e,propertyName:t})=>{e===Pn&&/background|outline/.test(t)&&ce&&Pl()},Il,Al,Ll,zl,Ol,Bl,Nl,Vl,e=>{const t=!(!Dl||!Dl.closeButton)||!_t;Nl.set(e.detail.width,{hard:t}),Vl.set(Math.round(.5*-e.detail.width),{hard:t})},jl,ql,e=>{const{keyCode:t,metaKey:o,ctrlKey:r,shiftKey:n}=e;if(9===t&&mr)return void e.preventDefault();if(e.target&&32===t&&Pn.contains(e.target)&&!isTextField(e.target)&&(gt&&i&&Hn(),e.preventDefault()),90===t&&(o||r))return void(n&&o?Zs.redo():Zs.undo());if(89===t&&r)return void Zs.redo();if(229===t)return;const a=new Set([...mt,t]);ql.set(Array.from(a))},({key:e,keyCode:t})=>{if("Meta"===e)return ql.set([]);ql.set(mt.filter((e=>e!==t)))},()=>{ql.set([])},e=>{isTextField(e.target)||e.preventDefault()},e=>{Lr&&Xl(e.detail.resources[0])},()=>{zr&&browse().then(Yl)},e=>{if(!Dr)return;const t=clamp((window.innerWidth-Math.abs(nt.x))/nt.width,0,1),o=clamp((window.innerHeight-Math.abs(nt.y))/nt.height,0,1);t<.75&&o<.75||Xl((e.clipboardData||window.clipboardData).files[0])},ec,dc,e=>{Xe&&rectEqual(e.detail,Xe)||set_store_value(xa,Xe=e.detail,Xe)},Gr,Bs,ar,sr,lr,pr,dr,hr,mr,gr,fr,br,xr,Sr,Cr,Tr,kr,Rr,Pr,Ir,Er,Ar,Fr,Lr,Dr,zr,Br,Nr,Vr,Wr,Ur,Hr,jr,qr,Xr,Zr,tn,on,rn,sn,cn,hn,yn,()=>o(60,xn=void 0),(e,t,r)=>{const{text:n="",placeholder:i="",autoClose:a=!0,align:s="top",justify:l="center",buttonConfirm:c,buttonCancel:u}=r;o(60,xn={align:s,justify:l,text:n,placeholder:i,buttonConfirm:c,buttonCancel:u,onconfirm:()=>{e(vn.value),a&&o(60,xn=void 0)},oncancel:()=>{t(void 0),o(60,xn=void 0)}})},Sn,Cn,wn,kn,Vn,Wn,Un,Hn,Gn,jn,qn,Yn,Zn,Kn,ei,Pa,zs,Ml,Fl,Wl,Zl,Jl,z,He,Ue,i,F,Ve,K,oe,I,P,ze,j,De,Fe,Ae,Pe,ke,Re,Te,Se,be,_e,Ce,we,ve,xe,Ee,Ie,$e,ge,me,B,H,te,ee,Z,X,q,Y,ie,se,ae,ne,re,G,U,J,ce,le,L,M,A,r,k,S,T,w,C,v,_,x,h,y,$,b,s,p,a,u,n,Ye,Je,Qe,et,tt,nt,at,ct,ut,pt,dt,ht,$t,yt,xt,vt,St,wt,Tt,kt,Rt,Pt,Et,At,Ft,Lt,Dt,zt,Ot,Bt,Nt,Ut,Ht,Gt,qt,Xt,Yt,Jt,Qt,oo,lo,co,po,go,fo,$o,xo,So,Co,wo,Po,Io,Eo,Mo,Ao,Fo,function(){o(31,Hs=window_1$1.innerWidth),o(32,Gs=window_1$1.innerHeight)},e=>set_store_value(_a,zo=e.detail,zo),({detail:e})=>o(43,D=e),function(t,r){e.$$.not_equal(Rn[r],t)&&(Rn[r]=t,o(1,Rn),o(281,wn),o(27,Tn))},e=>yl(e),e=>_l(e),(e,{detail:t})=>xl(e,t),e=>set_store_value(ba,Wt=e.detail,Wt),function(t){e.$$.not_equal(Rn[D],t)&&(Rn[D]=t,o(1,Rn),o(281,wn),o(27,Tn))},()=>yl(D),()=>_l(D),({detail:e})=>xl(D,e),e=>{const t={...e,...ec()},{annotationShapes:o,decorationShapes:r,interfaceShapes:n,frameShapes:i,selectionShapes:a}=wr({annotationShapes:ot,decorationShapes:Ke,interfaceShapes:qo,frameShapes:Ze,selectionShapes:vo},t);return dc(t,Ge,o,r,n,i,a)},()=>{o(63,hc=!1),o(64,mc=!1),o(65,gc=!1),o(66,fc=!1),o(67,$c=!1)},function(e){binding_callbacks[e?"unshift":"push"]((()=>{Kl=e,o(36,Kl)}))},function(e){bn=e,o(0,bn),o(269,Zr)},function(e){ul=e,o(33,ul)},function(e){cl=e,o(34,cl)},function(e){binding_callbacks[e?"unshift":"push"]((()=>{vn=e,o(61,vn)}))},function(e){binding_callbacks[e?"unshift":"push"]((()=>{Pn=e,o(2,Pn)}))},e=>set_store_value(fa,ft=e.detail,ft)]}class Ui extends SvelteComponent{constructor(e){super(),init(this,e,instance$t,create_fragment$t,safe_not_equal,{class:236,layout:237,stores:238,locale:3,id:4,util:239,utils:240,animations:241,disabled:242,previewUpscale:243,previewPad:244,previewMaskOpacity:5,previewImageDataMaxSize:245,previewImageTextPixelRatio:6,markupMaskOpacity:7,zoomMaskOpacity:246,elasticityMultiplier:8,willRevert:247,willProcessImage:248,willRenderCanvas:9,willRenderToolbar:249,willRenderUtilTabs:250,willSetHistoryInitialState:251,enableButtonExport:252,enableButtonRevert:253,enableNavigateHistory:254,enableToolbar:10,enableUtils:255,enableButtonClose:256,enableDropImage:257,enablePasteImage:258,enableBrowseImage:259,enableTransparencyGrid:11,layoutDirectionPreference:260,layoutHorizontalUtilsPreference:261,layoutVerticalUtilsPreference:262,layoutVerticalToolbarPreference:263,layoutVerticalControlGroupsPreference:264,layoutVerticalControlTabsPreference:265,status:234,formatStatusImageLoading:266,formatStatusImageProcessing:267,formatStatusSupportError:268,textDirection:12,markupEditorZoomLevel:269,markupEditorZoomLevels:13,markupEditorZoomAdjustStep:14,markupEditorZoomAdjustFactor:15,markupEditorZoomAdjustWheelFactor:16,markupEditorInteractionMode:270,muteAudio:271,willSetMediaInitialTimeOffset:272,enablePan:17,enableZoom:18,enableZoomControls:273,enableZoomInput:19,enablePanInput:274,enableCanvasAlpha:20,enablePanLimit:21,panLimitGutterScalar:22,pan:275,zoomPresetOptions:23,zoomAdjustStep:24,zoomAdjustFactor:25,zoomAdjustWheelFactor:26,zoomLevel:0,fixScrollDirection:276,hideTextInput:277,showTextInput:278,imagePreviewSrc:279,imageOrienter:280,pluginComponents:281,pluginOptions:27,sub:282,pluginInterface:1,root:2,play:283,pause:284,isPaused:285,togglePlayPause:286,mute:287,unmute:288,toggleMute:289,getDuration:290,getCurrentTime:291,setCurrentTime:292,imageSourceToImageData:28,imagePreview:29,imagePreviewCurrent:235,history:30},null,[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])}get class(){return this.$$.ctx[236]}set class(e){this.$$set({class:e}),flush()}get layout(){return this.$$.ctx[237]}set layout(e){this.$$set({layout:e}),flush()}get stores(){return this.$$.ctx[238]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[3]}set locale(e){this.$$set({locale:e}),flush()}get id(){return this.$$.ctx[4]}set id(e){this.$$set({id:e}),flush()}get util(){return this.$$.ctx[239]}set util(e){this.$$set({util:e}),flush()}get utils(){return this.$$.ctx[240]}set utils(e){this.$$set({utils:e}),flush()}get animations(){return this.$$.ctx[241]}set animations(e){this.$$set({animations:e}),flush()}get disabled(){return this.$$.ctx[242]}set disabled(e){this.$$set({disabled:e}),flush()}get previewUpscale(){return this.$$.ctx[243]}set previewUpscale(e){this.$$set({previewUpscale:e}),flush()}get previewPad(){return this.$$.ctx[244]}set previewPad(e){this.$$set({previewPad:e}),flush()}get previewMaskOpacity(){return this.$$.ctx[5]}set previewMaskOpacity(e){this.$$set({previewMaskOpacity:e}),flush()}get previewImageDataMaxSize(){return this.$$.ctx[245]}set previewImageDataMaxSize(e){this.$$set({previewImageDataMaxSize:e}),flush()}get previewImageTextPixelRatio(){return this.$$.ctx[6]}set previewImageTextPixelRatio(e){this.$$set({previewImageTextPixelRatio:e}),flush()}get markupMaskOpacity(){return this.$$.ctx[7]}set markupMaskOpacity(e){this.$$set({markupMaskOpacity:e}),flush()}get zoomMaskOpacity(){return this.$$.ctx[246]}set zoomMaskOpacity(e){this.$$set({zoomMaskOpacity:e}),flush()}get elasticityMultiplier(){return this.$$.ctx[8]}set elasticityMultiplier(e){this.$$set({elasticityMultiplier:e}),flush()}get willRevert(){return this.$$.ctx[247]}set willRevert(e){this.$$set({willRevert:e}),flush()}get willProcessImage(){return this.$$.ctx[248]}set willProcessImage(e){this.$$set({willProcessImage:e}),flush()}get willRenderCanvas(){return this.$$.ctx[9]}set willRenderCanvas(e){this.$$set({willRenderCanvas:e}),flush()}get willRenderToolbar(){return this.$$.ctx[249]}set willRenderToolbar(e){this.$$set({willRenderToolbar:e}),flush()}get willRenderUtilTabs(){return this.$$.ctx[250]}set willRenderUtilTabs(e){this.$$set({willRenderUtilTabs:e}),flush()}get willSetHistoryInitialState(){return this.$$.ctx[251]}set willSetHistoryInitialState(e){this.$$set({willSetHistoryInitialState:e}),flush()}get enableButtonExport(){return this.$$.ctx[252]}set enableButtonExport(e){this.$$set({enableButtonExport:e}),flush()}get enableButtonRevert(){return this.$$.ctx[253]}set enableButtonRevert(e){this.$$set({enableButtonRevert:e}),flush()}get enableNavigateHistory(){return this.$$.ctx[254]}set enableNavigateHistory(e){this.$$set({enableNavigateHistory:e}),flush()}get enableToolbar(){return this.$$.ctx[10]}set enableToolbar(e){this.$$set({enableToolbar:e}),flush()}get enableUtils(){return this.$$.ctx[255]}set enableUtils(e){this.$$set({enableUtils:e}),flush()}get enableButtonClose(){return this.$$.ctx[256]}set enableButtonClose(e){this.$$set({enableButtonClose:e}),flush()}get enableDropImage(){return this.$$.ctx[257]}set enableDropImage(e){this.$$set({enableDropImage:e}),flush()}get enablePasteImage(){return this.$$.ctx[258]}set enablePasteImage(e){this.$$set({enablePasteImage:e}),flush()}get enableBrowseImage(){return this.$$.ctx[259]}set enableBrowseImage(e){this.$$set({enableBrowseImage:e}),flush()}get enableTransparencyGrid(){return this.$$.ctx[11]}set enableTransparencyGrid(e){this.$$set({enableTransparencyGrid:e}),flush()}get layoutDirectionPreference(){return this.$$.ctx[260]}set layoutDirectionPreference(e){this.$$set({layoutDirectionPreference:e}),flush()}get layoutHorizontalUtilsPreference(){return this.$$.ctx[261]}set layoutHorizontalUtilsPreference(e){this.$$set({layoutHorizontalUtilsPreference:e}),flush()}get layoutVerticalUtilsPreference(){return this.$$.ctx[262]}set layoutVerticalUtilsPreference(e){this.$$set({layoutVerticalUtilsPreference:e}),flush()}get layoutVerticalToolbarPreference(){return this.$$.ctx[263]}set layoutVerticalToolbarPreference(e){this.$$set({layoutVerticalToolbarPreference:e}),flush()}get layoutVerticalControlGroupsPreference(){return this.$$.ctx[264]}set layoutVerticalControlGroupsPreference(e){this.$$set({layoutVerticalControlGroupsPreference:e}),flush()}get layoutVerticalControlTabsPreference(){return this.$$.ctx[265]}set layoutVerticalControlTabsPreference(e){this.$$set({layoutVerticalControlTabsPreference:e}),flush()}get status(){return this.$$.ctx[234]}set status(e){this.$$set({status:e}),flush()}get formatStatusImageLoading(){return this.$$.ctx[266]}set formatStatusImageLoading(e){this.$$set({formatStatusImageLoading:e}),flush()}get formatStatusImageProcessing(){return this.$$.ctx[267]}set formatStatusImageProcessing(e){this.$$set({formatStatusImageProcessing:e}),flush()}get formatStatusSupportError(){return this.$$.ctx[268]}set formatStatusSupportError(e){this.$$set({formatStatusSupportError:e}),flush()}get textDirection(){return this.$$.ctx[12]}set textDirection(e){this.$$set({textDirection:e}),flush()}get markupEditorZoomLevel(){return this.$$.ctx[269]}set markupEditorZoomLevel(e){this.$$set({markupEditorZoomLevel:e}),flush()}get markupEditorZoomLevels(){return this.$$.ctx[13]}set markupEditorZoomLevels(e){this.$$set({markupEditorZoomLevels:e}),flush()}get markupEditorZoomAdjustStep(){return this.$$.ctx[14]}set markupEditorZoomAdjustStep(e){this.$$set({markupEditorZoomAdjustStep:e}),flush()}get markupEditorZoomAdjustFactor(){return this.$$.ctx[15]}set markupEditorZoomAdjustFactor(e){this.$$set({markupEditorZoomAdjustFactor:e}),flush()}get markupEditorZoomAdjustWheelFactor(){return this.$$.ctx[16]}set markupEditorZoomAdjustWheelFactor(e){this.$$set({markupEditorZoomAdjustWheelFactor:e}),flush()}get markupEditorInteractionMode(){return this.$$.ctx[270]}set markupEditorInteractionMode(e){this.$$set({markupEditorInteractionMode:e}),flush()}get muteAudio(){return this.$$.ctx[271]}set muteAudio(e){this.$$set({muteAudio:e}),flush()}get willSetMediaInitialTimeOffset(){return this.$$.ctx[272]}set willSetMediaInitialTimeOffset(e){this.$$set({willSetMediaInitialTimeOffset:e}),flush()}get enablePan(){return this.$$.ctx[17]}set enablePan(e){this.$$set({enablePan:e}),flush()}get enableZoom(){return this.$$.ctx[18]}set enableZoom(e){this.$$set({enableZoom:e}),flush()}get enableZoomControls(){return this.$$.ctx[273]}set enableZoomControls(e){this.$$set({enableZoomControls:e}),flush()}get enableZoomInput(){return this.$$.ctx[19]}set enableZoomInput(e){this.$$set({enableZoomInput:e}),flush()}get enablePanInput(){return this.$$.ctx[274]}set enablePanInput(e){this.$$set({enablePanInput:e}),flush()}get enableCanvasAlpha(){return this.$$.ctx[20]}set enableCanvasAlpha(e){this.$$set({enableCanvasAlpha:e}),flush()}get enablePanLimit(){return this.$$.ctx[21]}set enablePanLimit(e){this.$$set({enablePanLimit:e}),flush()}get panLimitGutterScalar(){return this.$$.ctx[22]}set panLimitGutterScalar(e){this.$$set({panLimitGutterScalar:e}),flush()}get pan(){return this.$$.ctx[275]}set pan(e){this.$$set({pan:e}),flush()}get zoomPresetOptions(){return this.$$.ctx[23]}set zoomPresetOptions(e){this.$$set({zoomPresetOptions:e}),flush()}get zoomAdjustStep(){return this.$$.ctx[24]}set zoomAdjustStep(e){this.$$set({zoomAdjustStep:e}),flush()}get zoomAdjustFactor(){return this.$$.ctx[25]}set zoomAdjustFactor(e){this.$$set({zoomAdjustFactor:e}),flush()}get zoomAdjustWheelFactor(){return this.$$.ctx[26]}set zoomAdjustWheelFactor(e){this.$$set({zoomAdjustWheelFactor:e}),flush()}get zoomLevel(){return this.$$.ctx[0]}set zoomLevel(e){this.$$set({zoomLevel:e}),flush()}get fixScrollDirection(){return this.$$.ctx[276]}set fixScrollDirection(e){this.$$set({fixScrollDirection:e}),flush()}get hideTextInput(){return this.$$.ctx[277]}get showTextInput(){return this.$$.ctx[278]}get imagePreviewSrc(){return this.$$.ctx[279]}set imagePreviewSrc(e){this.$$set({imagePreviewSrc:e}),flush()}get imageOrienter(){return this.$$.ctx[280]}set imageOrienter(e){this.$$set({imageOrienter:e}),flush()}get pluginComponents(){return this.$$.ctx[281]}set pluginComponents(e){this.$$set({pluginComponents:e}),flush()}get pluginOptions(){return this.$$.ctx[27]}set pluginOptions(e){this.$$set({pluginOptions:e}),flush()}get sub(){return this.$$.ctx[282]}get pluginInterface(){return this.$$.ctx[1]}get root(){return this.$$.ctx[2]}set root(e){this.$$set({root:e}),flush()}get play(){return this.$$.ctx[283]}get pause(){return this.$$.ctx[284]}get isPaused(){return this.$$.ctx[285]}get togglePlayPause(){return this.$$.ctx[286]}get mute(){return this.$$.ctx[287]}get unmute(){return this.$$.ctx[288]}get toggleMute(){return this.$$.ctx[289]}get getDuration(){return this.$$.ctx[290]}get getCurrentTime(){return this.$$.ctx[291]}get setCurrentTime(){return this.$$.ctx[292]}get imageSourceToImageData(){return this.$$.ctx[28]}set imageSourceToImageData(e){this.$$set({imageSourceToImageData:e}),flush()}get imagePreview(){return this.$$.ctx[29]}get imagePreviewCurrent(){return this.$$.ctx[235]}set imagePreviewCurrent(e){this.$$set({imagePreviewCurrent:e}),flush()}get history(){return this.$$.ctx[30]}}const utilPrivateProps=["klass","stores","isVisible","isActive","isActiveFraction","locale"],viewPrivateProps=["history","klass","stores","navButtons","pluginComponents","pluginInterface","pluginOptions","sub","imagePreviewSrc","imagePreview","imagePreviewCurrent"],mergeProps=["locale"];let editorProps;const pluginProps=new Set([]),propPluginRef={},pluginComponents=new Map,setEditorViewPlugins=(...e)=>{e.filter((e=>!!e.util)).forEach((e=>{const[t,o,r=()=>!0]=e.util;pluginComponents.has(t)||(pluginComponents.set(t,{Component:o,isSupported:r}),getComponentExportedProps(o).filter((e=>!utilPrivateProps.includes(e))).forEach((e=>{pluginProps.add(e),propPluginRef[e]?propPluginRef[e].push(t):propPluginRef[e]=[t]})))}))},getEditorViewProps=()=>(editorProps=new Set(getComponentExportedProps(Ui).filter((e=>!viewPrivateProps.includes(e)))),[...editorProps,...pluginProps]),attachEditorView=(e,t)=>{const o={},r=new Ui({target:e,props:{stores:t,pluginComponents:Array.from(pluginComponents)}});let n=!1;const i=()=>{n||(isBrowser()&&window.removeEventListener("pagehide",i),r&&(n=!0,r.$destroy()))};editorProps||(editorProps=new Set(getComponentExportedProps(Ui).filter((e=>!viewPrivateProps.includes(e))))),editorProps.forEach((e=>{Object.defineProperty(o,e,{get:()=>r[e],set:mergeProps.includes(e)?t=>{r[e]={...r[e],...t}}:t=>r[e]=t})})),Object.defineProperty(o,"previewImageData",{get:()=>r.imagePreviewCurrent}),pluginProps.forEach((e=>{const t=propPluginRef[e],n=t[0];Object.defineProperty(o,e,{get:()=>r.pluginInterface[n][e],set:o=>{const n=t.reduce(((t,n)=>(t[n]={...r.pluginOptions[n],[e]:o},t)),{});r.pluginOptions={...r.pluginOptions,...n}}})})),Object.defineProperty(o,"element",{get:()=>r.root,set:()=>{}});const a=r.history;return defineMethods(o,{on:(e,t)=>{if(n)return()=>{};if(/undo|redo|revert|writehistory/.test(e))return a.on(e,t);const o=[r.sub(e,t),r.$on(e,(e=>t(e instanceof CustomEvent&&!e.detail?void 0:e)))].filter(Boolean);return()=>o.forEach((e=>e()))},updateImagePreview:e=>{r.imagePreviewSrc=e},close:()=>!n&&r.pub("close"),destroy:i}),Object.defineProperty(o,"history",{get:()=>({undo:()=>a.undo(),redo:()=>a.redo(),revert:()=>a.revert(),get:()=>a.get(),getCollapsed:()=>a.get().splice(0,a.index+1),set:e=>a.set(e),write:e=>a.write(e),get length(){return a.length()},get index(){return a.index},set index(e){a.index=e}})}),isBrowser()&&window.addEventListener("pagehide",i),o};var editorEvents=[...editorEventsToBubble,"init","update","undo","redo","revert","writehistory","destroy","show","hide","close","ready","zoom","pan","loadpreview","selectshape","blurshape","updateshape","addshape","removeshape","selectstyle","markuptap","markupzoom","markuppan","selectutil","selectcontrol","selectiondown","selectionup","selectionchange"];const dispatchElementEvent=(e,t,o)=>e.dispatchEvent(new CustomEvent(t,{detail:o,bubbles:!0,cancelable:!0}));var dispatchEditorEvents=(e,t,o={})=>{const{prefix:r="pintura:"}=o;return editorEvents.map((o=>e.on(o,(e=>isElement(t)?dispatchElementEvent(t,`${r}${o}`,e):t(o,e)))))},naturalAspectRatioToNumber=e=>{if(void 0===e||isNumber(e))return e;if(!isString(e))return!1;const t=e;if(!t.length)return;const[o,r]=t.split(/\/|:/g).map((e=>parseFloat(e.replace(/,/,".")))).filter(Boolean);return!!o&&(r?Math.abs(o/r):o)},arrayInsert=(e,t,o)=>(e.splice(t,0,o),e);const isNode=e=>isString(e[0]),isNodeList=e=>!isNode(e),getNodeId=e=>e[1],getNodeChildren=e=>e[3]||[];function createNode(e,t,o,r){return Array.isArray(o)&&(r=o,o={}),[e,t,o||{},r||[]]}const insertNode=(e,t,o,r=e=>e)=>{const n=findNodeList(t,o),i=n.findIndex((e=>getNodeId(e)===t));arrayInsert(n,r(i),e)},insertNodeBefore=(e,t,o)=>insertNode(e,t,o),insertNodeAfter=(e,t,o)=>insertNode(e,t,o,(e=>e+1)),appendNode=(e,t)=>{if(isNodeList(t))return t.push(e);t[3]=[...getNodeChildren(t),e]},removeNode=(e,t)=>{const o=findNodeList(e,t);return arrayRemove(o,(t=>getNodeId(t)===e)),o},findNode=(e,t)=>{if(t&&t.length){if(isNode(t)){if(getNodeId(t)===e)return t;const o=findNode(e,getNodeChildren(t));if(o)return o}if(isNodeList(t))for(const o of t){const t=findNode(e,o);if(t)return t}}},findNodeList=(e,t)=>{if(isNodeList(t)){if(t.find((t=>getNodeId(t)===e)))return t;const o=t.find((t=>findNodeList(e,getNodeChildren(t))));return o&&o[3]}return findNodeList(e,getNodeChildren(t))},updateNode=(e,t)=>{const[,,o]=e;Object.assign(o,t)},pastel=()=>[.75,.25,.25,0,0,.25,.75,.25,0,0,.25,.25,.75,0,0,0,0,0,1,0],chrome=()=>[1.398,-.316,.065,-.273,.201,-.051,1.278,-.08,-.273,.201,-.051,.119,1.151,-.29,.215,0,0,0,1,0],fade=()=>[1.073,-.015,.092,-.115,-.017,.107,.859,.184,-.115,-.017,.015,.077,1.104,-.115,-.017,0,0,0,1,0],warm=()=>[1.06,0,0,0,0,0,1.01,0,0,0,0,0,.93,0,0,0,0,0,1,0],cold=()=>[1.1,0,0,0,-.1,0,1.1,0,0,-.1,0,0,1.2,0,-.1,0,0,0,1,0],invert=()=>[-1,0,0,1,0,0,-1,0,1,0,0,0,-1,1,0,0,0,0,1,0],monoDefault=()=>[.212,.715,.114,0,0,.212,.715,.114,0,0,.212,.715,.114,0,0,0,0,0,1,0],monoNoir=()=>[.15,1.3,-.25,.1,-.2,.15,1.3,-.25,.1,-.2,.15,1.3,-.25,.1,-.2,0,0,0,1,0],monoWash=()=>[.163,.518,.084,-.01,.208,.163,.529,.082,-.02,.21,.171,.529,.084,0,.214,0,0,0,1,0],monoStark=()=>[.338,.991,.117,.093,-.196,.302,1.049,.096,.078,-.196,.286,1.016,.146,.101,-.196,0,0,0,1,0],sepiaDefault=()=>[.393,.768,.188,0,0,.349,.685,.167,0,0,.272,.533,.13,0,0,0,0,0,1,0],sepiaBlues=()=>[.289,.62,.185,0,.077,.257,.566,.163,0,.115,.2,.43,.128,0,.188,0,0,0,1,0],sepiaRust=()=>[.269,.764,.172,.05,.1,.239,.527,.152,0,.176,.186,.4,.119,0,.159,0,0,0,1,0],sepiaColor=()=>[.547,.764,.134,0,-.147,.281,.925,.12,0,-.135,.225,.558,.33,0,-.113,0,0,0,1,0],filterFunctionsDefault={chrome:chrome,fade:fade,pastel:pastel,cold:cold,warm:warm,monoDefault:monoDefault,monoWash:monoWash,monoNoir:monoNoir,monoStark:monoStark,sepiaDefault:sepiaDefault,sepiaRust:sepiaRust,sepiaBlues:sepiaBlues,sepiaColor:sepiaColor},filterOptionsDefault=[["Default",[[void 0,e=>e.labelDefault]]],["Classic",[["chrome",e=>e.filterLabelChrome],["fade",e=>e.filterLabelFade],["cold",e=>e.filterLabelCold],["warm",e=>e.filterLabelWarm],["pastel",e=>e.filterLabelPastel]]],["Monochrome",[["monoDefault",e=>e.filterLabelMonoDefault],["monoNoir",e=>e.filterLabelMonoNoir],["monoStark",e=>e.filterLabelMonoStark],["monoWash",e=>e.filterLabelMonoWash]]],["Sepia",[["sepiaDefault",e=>e.filterLabelSepiaDefault],["sepiaRust",e=>e.filterLabelSepiaRust],["sepiaBlues",e=>e.filterLabelSepiaBlues],["sepiaColor",e=>e.filterLabelSepiaColor]]]];var _plugin_filter_defaults={filterFunctions:filterFunctionsDefault,filterOptions:filterOptionsDefault};const propertyMap={borderColor:"strokeColor",borderWidth:"strokeWidth",lineWidth:"strokeWidth",fontColor:"color",lineColor:"strokeColor",src:"backgroundImage",fit:"backgroundSize"},convertValue=e=>0===e||"0%"===e||"0px"===e?0:/px$/.test(e)?parseInt(e,10):/\%$/.test(e)?e:e<=1?100*e+"%":void 0,addValues=(e,t)=>{let o,r;return/%$/.test(e)?(o=parseFloat(e),r=parseFloat(t),`${o+r}%`):/px$/.test(e)?(o=parseInt(e,10),r=parseInt(t,10),`${o+r}px`):void 0},shapeFromLegacyMarkup=(e,t,o)=>{const r=Object.keys(o).reduce(((t,r)=>{let n=o[r];if(r=propertyMap[r]||r,/px$/.test(n))n=convertValue(n);else if(/^(?:x|y|left|right|top|bottom|width|height|fontSize|borderWidth|strokeWidth)$/.test(r)&&"number"==typeof n){if("strokeWidth"===r||"borderWidth"===r||"fontSize"===r){n=Math.min(e.width,e.height)*n+"px"}n=convertValue(n)}return/color/i.test(r)&&n&&(n=colorStringToColorArray(n)),null===n&&(n=void 0),t[r]=n,t}),{});if("line"===t&&(r.lineDecoration.length>=1&&(r.lineEnd="arrow"),2===r.lineDecoration.length&&(r.lineStart="arrow"),r.x1=r.x,r.y1=r.y,r.x2=addValues(r.x,r.width),r.y2=addValues(r.y,r.height),delete r.x,delete r.y,delete r.width,delete r.height,delete r.lineDecoration,delete r.lineStyle),"text"===t){if(!isNumber(r.y)){const t=Math.min(e.width,e.height);r.y=t*(parseFloat(r.y)/100)}r.y=r.y-r.fontSize,delete r.width,delete r.height,delete r.borderStyle,r.lineHeight=r.lineHeight||"120%"}if("ellipse"===t){let t,o;if(/%$/.test(r.width)){t=parseFloat(r.width)/100,o=parseFloat(r.height)/100;const n=t*e.width,i=o*e.height;t=n/e.width*100,o=i/e.height*100}else t=r.width,o=r.height;r.rx=.5*t,r.ry=.5*o,/%$/.test(r.width)&&(r.rx+="%",r.ry+="%"),r.x=addValues(r.x,r.rx),r.y=addValues(r.y,r.ry),delete r.width,delete r.height,delete r.borderStyle}if("rect"===t&&delete r.borderStyle,"path"===t){let e,t=[];for(const o of r.points){if(!e){t.push(o),e=o;continue}vectorDistanceSquared(e,o)<1e-9||(t.push(o),e=o,e=o)}r.points=t.map((e=>({x:convertValue(e.x),y:convertValue(e.y)})))}return r},getOffsetPointOnEdge=(e,t)=>{const o=e,r=t,n=1.5707963267948966-t,i=Math.sin(1.5707963267948966),a=Math.sin(r),s=Math.sin(n),l=Math.cos(n),c=o/i;return vectorCreate(l*(c*a),l*(c*s))},getRotatedRectSize=(e,t)=>{const o=e.width,r=e.height,n=getOffsetPointOnEdge(o,t),i=getOffsetPointOnEdge(r,t),a=vectorCreate(e.x+Math.abs(n.x),e.y-Math.abs(n.y)),s=vectorCreate(e.x+e.width+Math.abs(i.y),e.y+Math.abs(i.x)),l=vectorCreate(e.x-Math.abs(i.y),e.y+e.height-Math.abs(i.x));return{width:vectorDistance(a,s),height:vectorDistance(a,l)}},getBoundsAroundCenter=(e,t)=>{const o=t.x>.5?1-t.x:t.x,r=t.y>.5?1-t.y:t.y;return sizeCreate(2*o*e.width,2*r*e.height)},getCanvasSize=(e,t,o=1)=>{const r=e.height/e.width,n=t;let i=1,a=r;a>n&&(a=n,i=a/r);const s=Math.max(1/i,n/a),l=e.width/(o*s*i);return{width:l,height:l*t}},getCenteredCropRect=(e,t)=>{let o=e.width,r=o*t;r>e.height&&(r=e.height,o=r/t);const n=.5*(e.width-o),i=.5*(e.height-r);return rectCreate(n,i,o,r)},getCorrectedLegacyAspectRatio=(e,t)=>null!=t?1/t:e.width/e.height,imagePropertiesFromLegacyCrop=(e,{flip:t,aspectRatio:o,rotation:r,center:n,zoom:i,scaleToFit:a})=>{const s={flipX:!1,flipY:!1},l=!n||n&&.5===n.x&&.5===n.y;t&&t.horizontal&&(s.flipX=t.horizontal),t&&t.vertical&&(s.flipY=t.vertical);const c=getCorrectedLegacyAspectRatio(e,o),u=!(!1===a),p=getCanvasSize(e,o,i),d=l?e:getBoundsAroundCenter(e,u?n:{x:.5,y:.5}),h=getCenteredCropRect(e,o);if((o||!l||i)&&(s.crop=rectContainRect(rectCreateFromSize(d),c)),"number"==typeof r&&null!==r&&0!==r){null!=r&&(s.rotation=r);const t=getRotatedRectSize(h,r),o=Math.max(t.width/d.width,t.height/d.height),i=vectorCreate(n.x*e.width,n.y*e.height),a=getImageTransformedRect(e,r),l=sizeCenter(a),c=vectorCreate(.5*(a.width-e.width),.5*(a.height-e.height)),u=rectRotate({x:c.x+i.x-p.width/o*.5,y:c.y+i.y-p.height/o*.5,width:p.width/o,height:p.height/o},r),m=vectorsRotate(u.map(vectorClone),r,l.x,l.y),g=rectCenter(rectCreateFromPoints(m)),f=vectorsRotate(m.map(vectorClone),-2*r,g.x,g.y);s.crop=rectCreateFromPoints(f)}else null!=i&&rectScale$1(s.crop,1/i);return u||(s.cropLimitToImage=!1),s},isLegacyData=(e={})=>{if("markup"in e||"color"in e||"filter"in e)return!0;const{crop:t}=e;return!(!t||!("flip"in t||"center"in t||"aspectRatio"in t||"rotation"in t))};var legacyDataToImageState=(e,t,o={})=>{const r={};if(!isLegacyData(o))return o;if(o.crop&&Object.assign(r,imagePropertiesFromLegacyCrop(t,o.crop)),o.markup){const e=Array.isArray(o.markup)?o.markup:Object.values(o.markup);r.decoration=e.map((e=>shapeFromLegacyMarkup(r.crop||t,e[0],e[1])))}if(o.color||o.colors){const e=o.color||o.colors;Object.keys(e).filter((t=>e[t])).map((t=>[t,Array.isArray(e[t].matrix)?e[t].matrix:Object.values(e[t].matrix)])).forEach((([e,t])=>{r.colorMatrix||(r.colorMatrix={}),r.colorMatrix[e]=t}))}if(o.filter||o.filters){const t=o.filters||o.filter;r.colorMatrix||(r.colorMatrix={});const n=e?e.filterFunctions:filterFunctionsDefault;r.colorMatrix.filter="string"==typeof t&&n[t]?n[t]():t.matrix}const n=o.size?o.size:!!o.resize&&o.resize.size;return n&&n.width&&n.height&&(r.targetSize={width:n.width,height:n.height}),r};const isOperaMini=()=>"[object OperaMini]"===Object.prototype.toString.call(window.operamini),hasPromises=()=>"Promise"in window,hasCreateObjectURL=()=>"URL"in window&&"createObjectURL"in window.URL,hasVisibility=()=>"visibilityState"in document,hasTiming=()=>"performance"in window,hasFileConstructor=()=>"File"in window;let result$1=null;var isModernBrowser=()=>(null===result$1&&(result$1=isBrowser()&&!isOperaMini()&&hasVisibility()&&hasPromises()&&hasFileConstructor()&&hasCreateObjectURL()&&hasTiming()),result$1);const brightness={base:0,min:-.25,max:.25,getLabel:e=>toPercentageNumber(e/.25),getStore:({imageColorMatrix:e})=>e,getValue:e=>{if(e.brightness)return e.brightness[4]},setValue:(e,t)=>e.update((e=>({...e,brightness:[1,0,0,0,t,0,1,0,0,t,0,0,1,0,t,0,0,0,1,0]})))},contrast={base:1,min:.5,max:1.5,getLabel:e=>toPercentageNumber(2*(e-.5)-1),getStore:({imageColorMatrix:e})=>e,getValue:e=>{if(e.contrast)return e.contrast[0]},setValue:(e,t)=>e.update((e=>({...e,contrast:[t,0,0,0,.5*(1-t),0,t,0,0,.5*(1-t),0,0,t,0,.5*(1-t),0,0,0,1,0]})))},saturation={base:1,min:0,max:2,getLabel:e=>toPercentageNumber(e-1),getStore:({imageColorMatrix:e})=>e,getValue:e=>{if(e.saturation)return(e.saturation[0]-.213)/.787},setValue:(e,t)=>e.update((e=>({...e,saturation:[.213+.787*t,.715-.715*t,.072-.072*t,0,0,.213-.213*t,.715+.285*t,.072-.072*t,0,0,.213-.213*t,.715-.715*t,.072+.928*t,0,0,0,0,0,1,0]})))},exposure={base:1,min:.5,max:1.5,getLabel:e=>toPercentageNumber(2*(e-.5)-1),getStore:({imageColorMatrix:e})=>e,getValue:e=>{if(e.exposure)return e.exposure[0]},setValue:(e,t)=>e.update((e=>({...e,exposure:[t,0,0,0,0,0,t,0,0,0,0,0,t,0,0,0,0,0,1,0]})))},gamma={base:1,min:.15,max:4,getLabel:e=>toPercentageNumber(e<1?(e-.15)/.85-1:(e-1)/3),getStore:({imageGamma:e})=>e},vignette={base:0,min:-1,max:1,getStore:({imageVignette:e})=>e},clarity={base:0,min:-1,max:1,getStore:({imageConvolutionMatrix:e})=>e,getValue:e=>{if(e.clarity)return 0===e.clarity[0]?e.clarity[1]/-1:e.clarity[1]/-2},setValue:(e,t)=>{e.update((e=>({...e,clarity:t>=0?[0,-1*t,0,-1*t,1+4*t,-1*t,0,-1*t,0]:[-1*t,-2*t,-1*t,-2*t,1+-3*t,-2*t,-1*t,-2*t,-1*t]})))}},temperature={base:0,min:-1,max:1,getStore:({imageColorMatrix:e})=>e,getValue:e=>{if(!e.temperature)return;const t=e.temperature[0];return t>=1?(t-1)/.1:(1-t)/-.15},setValue:(e,t)=>e.update((e=>({...e,temperature:t>0?[1+.1*t,0,0,0,0,0,1,0,0,0,0,0,1+.1*-t,0,0,0,0,0,1,0]:[1+.15*t,0,0,0,0,0,1+.05*t,0,0,0,0,0,1+.15*-t,0,0,0,0,0,1,0]})))},finetuneControlConfigurationDefault={gamma:gamma,brightness:brightness,contrast:contrast,saturation:saturation,exposure:exposure,temperature:temperature,clarity:clarity,vignette:vignette},finetuneOptionsDefault=[["brightness",e=>e.finetuneLabelBrightness],["contrast",e=>e.finetuneLabelContrast],["saturation",e=>e.finetuneLabelSaturation],["exposure",e=>e.finetuneLabelExposure],["temperature",e=>e.finetuneLabelTemperature],["gamma",e=>e.finetuneLabelGamma],!isSoftwareRendering()&&["clarity",e=>e.finetuneLabelClarity],["vignette",e=>e.finetuneLabelVignette]].filter(Boolean);var _plugin_finetune_defaults={finetuneControlConfiguration:finetuneControlConfigurationDefault,finetuneOptions:finetuneOptionsDefault};const createDivThumb=(e,t="thumb")=>["div",t,{style:e,textContent:" "}],solidSharp={shape:{frameColor:[1,1,1],frameStyle:"solid",frameSize:"2.5%"},thumb:'<rect stroke-width="5" x="0" y="0" width="100%" height="100%"/>'},solidRound={shape:{frameColor:[1,1,1],frameStyle:"solid",frameSize:"2.5%",frameRound:!0},thumb:'<rect stroke-width="5" x="0" y="0" width="100%" height="100%" rx="12%"/>'},lineSingle={shape:{frameColor:[1,1,1],frameStyle:"line",frameInset:"2.5%",frameSize:".3125%",frameRadius:0},thumb:[createDivThumb("top:.5em;left:.5em;right:.5em;bottom:.5em;box-shadow:inset 0 0 0 1px currentColor")]},lineMultiple={shape:{frameColor:[1,1,1],frameStyle:"line",frameAmount:2,frameInset:"2.5%",frameSize:".3125%",frameOffset:"1.25%",frameRadius:0},thumb:[createDivThumb("top:.75em;left:.75em;right:.75em;bottom:.75em; outline: 3px double")]},edgeSeparate={shape:{frameColor:[1,1,1],frameStyle:"edge",frameInset:"2.5%",frameOffset:"5%",frameSize:".3125%"},thumb:[createDivThumb("top:.75em;left:.5em;bottom:.75em;border-left:1px solid","a"),createDivThumb("top:.75em;right:.5em;bottom:.75em;border-right:1px solid","b"),createDivThumb("top:.5em;left:.75em;right:.75em;border-top:1px solid","c"),createDivThumb("bottom:.5em;left:.75em;right:.75em;border-bottom:1px solid","d")]},edgeCross={shape:{frameColor:[1,1,1],frameStyle:"edge",frameInset:"2.5%",frameSize:".3125%"},thumb:[createDivThumb("top:-.5em;left:.5em;right:.5em;bottom:-.5em; box-shadow: inset 0 0 0 1px currentColor","a"),createDivThumb("top:.5em;left:-.5em;right:-.5em;bottom:.5em;box-shadow:inset 0 0 0 1px currentColor","b")]},edgeOverlap={shape:{frameColor:[1,1,1],frameStyle:"edge",frameOffset:"1.5%",frameSize:".3125%"},thumb:[createDivThumb("top:.3125em;left:.5em;bottom:.3125em;border-left:1px solid","a"),createDivThumb("top:.3125em;right:.5em;bottom:.3125em;border-right:1px solid","b"),createDivThumb("top:.5em;left:.3125em;right:.3125em;border-top:1px solid","c"),createDivThumb("bottom:.5em;left:.3125em;right:.3125em;border-bottom:1px solid","d")]},hook={shape:{frameColor:[1,1,1],frameStyle:"hook",frameInset:"2.5%",frameSize:".3125%",frameLength:"5%"},thumb:[createDivThumb("top:.5em;left:.5em;width:.75em;height:.75em; border-left: 1px solid;border-top: 1px solid","a"),createDivThumb("top:.5em;right:.5em;width:.75em;height:.75em; border-right: 1px solid;border-top: 1px solid","b"),createDivThumb("bottom:.5em;left:.5em;width:.75em;height:.75em; border-left: 1px solid;border-bottom: 1px solid","c"),createDivThumb("bottom:.5em;right:.5em;width:.75em;height:.75em; border-right: 1px solid;border-bottom: 1px solid","d")]},polaroid={shape:{frameColor:[1,1,1],frameStyle:"polaroid"},thumb:'<rect stroke-width="20%" x="-5%" y="-5%" width="110%" height="96%"/>'},frameStylesDefault={solidSharp:solidSharp,solidRound:solidRound,lineSingle:lineSingle,lineMultiple:lineMultiple,edgeSeparate:edgeSeparate,edgeCross:edgeCross,edgeOverlap:edgeOverlap,hook:hook,polaroid:polaroid},frameOptionsDefault=[[void 0,e=>e.labelNone],["solidSharp",e=>e.frameLabelMatSharp],["solidRound",e=>e.frameLabelMatRound],["lineSingle",e=>e.frameLabelLineSingle],["lineMultiple",e=>e.frameLabelLineMultiple],["edgeCross",e=>e.frameLabelEdgeCross],["edgeSeparate",e=>e.frameLabelEdgeSeparate],["edgeOverlap",e=>e.frameLabelEdgeOverlap],["hook",e=>e.frameLabelCornerHooks],["polaroid",e=>e.frameLabelPolaroid]];var _plugin_frame_defaults={frameStyles:frameStylesDefault,frameOptions:frameOptionsDefault},upperCaseFirstLetter=e=>e.charAt(0).toUpperCase()+e.slice(1);let result=null;var canCheckFontAvailability=()=>{if(null===result)if(isBrowser())try{result=!1===document.fonts.check("16px TestNonExistingFont")}catch(e){result=!1}else result=!1;return result};const toLocaleFn=(e,t)=>o=>o[t?`${t}${upperCaseFirstLetter(e)}`:e],mapToSizeOption=e=>[e,`${e}`],createLocaleMapper=(e,t)=>o=>[e[o],toLocaleFn(o,t)],autoFormatNumberItems=e=>e.map(mapToSizeOption),maybeAutoFormatNumberItems=e=>Array.isArray(e)&&e.every(isNumber)?autoFormatNumberItems(e):e,toolColorDefault=[1,.2549,.2118],toolStrokeWidthDefault="0.5%",toolStrokeColorDefault=[1,1,1,0],SELECTION_TOOL_DEFAULTS={brush:["path",{bitmap:!0,drawMode:"add",strokeWidth:"5%",cursorStyle:"ellipse",cursorSize:"strokeWidth",disableStyle:["strokeColor"],settings:{strokeWidth:{control:"brushSize"}}}],lassoo:["path",{drawMode:"add",disableStyle:["strokeWidth","strokeColor"],pathClose:!0}],rectangle:["rectangle",{disableStyle:["backgroundColor","strokeWidth","strokeColor","cornerRadius"],drawMode:"add"}],ellipse:["ellipse",{disableStyle:["backgroundColor","strokeWidth","strokeColor"],drawMode:"add"}]},SELECTION_TOOL_DEFAULT_LIST=["brush","lassoo","rectangle","ellipse"],createSelectionToolStyles=(e,t)=>{const{tools:o=SELECTION_TOOL_DEFAULT_LIST}=t||{},r=o.reduce(((t,o)=>{const[r,n]=SELECTION_TOOL_DEFAULTS[o],i=createToolStyle(r,{...n,action:e},{position:"absolute",isSelection:!0});return Object.assign(t,{[`selection-${o}-${e}`]:i})}),{});return r},createSelectionTools=(e,t)=>{const{tools:o=SELECTION_TOOL_DEFAULT_LIST,hideLabel:r=!0}=t||{};return o.map((t=>[`selection-${t}-${e}`,toLocaleFn(t,"shapeLabelToolSelection"),{hideLabel:r,icon:toLocaleFn(t,"shapeIconToolSelection")}]))},createSelectionModeControl=e=>{const{hideLabel:t=!0}=e||{};return createOptionControl(["new","add","subtract"].map((e=>[e,toLocaleFn(e,"shapeLabelSelectionMode"),{icon:toLocaleFn(e,"shapeIconSelectionMode"),hideLabel:t}])),{title:e=>e.shapeTitleSelectionMode,layout:"radio"})},createBrushSizeControl=e=>createStrokeWidthControl(e,{title:e=>e.shapeTitleBrushSize,layout:"radio",optionHideLabel:!0,optionIcon:(e,t)=>`<circle fill="currentColor" stroke-width=".05em" stroke="currentColor" fill-opacity=".25" cx="12" cy="12" r="${2+8*t}"/>`}),toolShapeDefaults={eraser:()=>({eraseRadius:8,cursorStyle:"ellipse",cursorSize:"eraseRadius"}),path:()=>({points:[],disableAddPoints:!1}),line:()=>({x1:0,y1:0,x2:0,y2:0,disableErase:!1}),rectangle:()=>({x:0,y:0,width:0,height:0}),ellipse:()=>({x:0,y:0,rx:0,ry:0}),text:()=>({x:0,y:0,text:"Text"})},createToolStyle=(e,t={},o)=>{if(!toolShapeDefaults[e])return;const{position:r="relative",inputMode:n="drag",isSelection:i=!1}=o||{};return[{...toolShapeDefaults[e](),...t},{position:r,inputMode:n,isSelection:i}]},createToolStyles=e=>{const t={sharpie:createToolStyle("path",{bitmap:!0,strokeJoin:"round",strokeCap:"round",strokeWidth:"0.5%",strokeColor:[...toolColorDefault],cursorStyle:"ellipse",cursorSize:"strokeWidth",disableErase:!1,disableResize:!0,disableMove:!0}),eraser:createToolStyle("eraser"),path:createToolStyle("path",{pathClose:void 0,strokeWidth:"0.5%",strokeColor:[...toolColorDefault],backgroundColor:[0,0,0,0]},{inputMode:"step"}),line:createToolStyle("line",{strokeColor:[...toolColorDefault],strokeWidth:"0.5%"}),arrow:createToolStyle("line",{lineStart:"none",lineEnd:"arrow-solid",strokeColor:[...toolColorDefault],strokeWidth:"0.5%"}),rectangle:createToolStyle("rectangle",{strokeColor:[...toolStrokeColorDefault],backgroundColor:[...toolColorDefault]}),ellipse:createToolStyle("ellipse",{strokeColor:[...toolStrokeColorDefault],backgroundColor:[...toolColorDefault]}),text:createToolStyle("text",{color:[...toolColorDefault],fontSize:"2%"})};return e&&Object.entries(e).forEach((([e,o])=>{Array.isArray(o)?t[e]=o:isObject(o)&&t[e]&&(t[e]=[{...t[e][0],...o},t[e][1]])})),t},createToolbarItem=(e,t,o)=>[e,t||toLocaleFn(e,"shapeLabelTool"),{icon:toLocaleFn(e,"shapeIconTool"),...o}],createToolbar=(e=["move","view","sharpie","eraser","path","line","arrow","rectangle","ellipse","text","preset"])=>e.map((e=>isString(e)?createToolbarItem(e):Array.isArray(e)?isObject(e[1])?createToolbarItem(e[0],void 0,e[1]):createToolbarItem(e[0],e[1],e[2]):void 0)).filter(Boolean),createDefaultColorOptions=()=>({transparent:[1,1,1,0],white:[1,1,1],silver:[.8667,.8667,.8667],gray:[.6667,.6667,.6667],black:[0,0,0],navy:[0,.1216,.2471],blue:[0,.4549,.851],aqua:[.498,.8588,1],teal:[.2235,.8,.8],olive:[.2392,.6,.4392],green:[.1804,.8,.251],yellow:[1,.8627,0],orange:[1,.5216,.1059],red:[1,.2549,.2118],maroon:[.5216,.0784,.2941],fuchsia:[.9412,.0706,.7451],purple:[.6941,.051,.7882]}),createDefaultFontSizeOptions=()=>[16,18,20,24,30,36,48,64,72,96,128,144],createDefaultLineHeightOptions=createDefaultFontSizeOptions,createDefaultFontScaleOptions=()=>({extraSmall:"2%",small:"4%",mediumSmall:"8%",medium:"10%",mediumLarge:"15%",large:"20%",extraLarge:"25%"}),createDefaultLineHeightScaleOptions=()=>({extraSmall:"40%",small:"60%",mediumSmall:"100%",medium:"120%",mediumLarge:"140%",large:"180%",extraLarge:"220%"}),createDefaultStrokeWidthOptions=()=>[1,2,3,4,6,8,12,16,20,24,32,48,64],createDefaultStrokeScaleOptions=()=>({extraSmall:"0.25%",small:"0.5%",mediumSmall:"1%",medium:"1.75%",mediumLarge:"2.5%",large:"3.5%",extraLarge:"5%"}),createDefaultLineEndStyleOptions=()=>["bar","arrow","arrowSolid","circle","circleSolid","square","squareSolid"],createDefaultFontFamilyOptions=()=>[["Helvetica, Arial, Verdana, 'Droid Sans', sans-serif","Sans Serif"],["'Arial Black', 'Avenir-Black', 'Arial Bold'","Black"],["'Arial Narrow', 'Futura-CondensedMedium'","Narrow"],["'Trebuchet MS'","Humanist"],["Georgia, 'Avenir-Black', 'Times New Roman', 'Droid Serif', serif","Serif"],["Palatino","Old-Style"],["'Times New Roman', 'TimesNewRomanPSMT'","Transitional"],["Menlo, Monaco, 'Lucida Console', monospace","Monospaced"],["'Courier New', monospace","Slab Serif"]],createDefaultTextAlignOptions=()=>["left","center","right"],createDefaultFontStyleOptions=()=>[["normal","bold"],["italic","normal"],["italic","bold"]],createColorOptions=e=>Object.keys(e).map(createLocaleMapper(e,"shapeTitleColor")),createFontSizeOptions=e=>e.map(mapToSizeOption),createFontScaleOptions=e=>Object.keys(e).map(createLocaleMapper(e,"labelSize")),createLineHeightOptions=e=>e.map(mapToSizeOption),createLineHeightScaleOptions=e=>Object.keys(e).map(createLocaleMapper(e,"labelSize")),createStrokeWidthOptions=e=>e.map(mapToSizeOption),createStrokeScaleOptions=e=>Object.keys(e).map(createLocaleMapper(e,"labelSize")),createFontFamilyOptions=e=>[...e],createFontStyleOptions=e=>e.map((e=>[e,t=>t[`shapeLabelFontStyle${e.filter((e=>"normal"!==e)).map(upperCaseFirstLetter).join("")}`]])),createLineEndStyleOptions=e=>e.map((e=>[toKebabCase(e),t=>t[`shapeTitleLineDecoration${upperCaseFirstLetter(e)}`],{icon:t=>t[`shapeIconLineDecoration${upperCaseFirstLetter(e)}`]}])),createTextAlignOptions=e=>e.map((e=>[e,t=>t[`shapeTitleTextAlign${upperCaseFirstLetter(e)}`],{hideLabel:!0,icon:t=>t[`shapeIconTextAlign${upperCaseFirstLetter(e)}`]}])),createControlOptions=(e,t)=>{const{defaultKey:o,defaultValue:r,defaultOptions:n}=t||{},i=[];return o&&(i[0]=[r,e=>e[o],{...n}]),[...i,...e]},someFontsAvailableInStack=e=>e.split(",").map((e=>e.trim())).some((e=>document.fonts.check(`16px ${e}`))),createSliderControl=(e={})=>["ToggleSlider",{...e}],createOptionsControl=(e,t={})=>["Dropdown",{...t,options:e}],FontTestClass="PinturaFontTest",createFontFamilyControl=(e,t={defaultKey:"labelDefault"})=>["Dropdown",{title:e=>e.shapeTitleFontFamily,onload:({options:e=[]})=>{canCheckFontAvailability()&&e.map((([e])=>e)).filter(Boolean).filter((e=>!someFontsAvailableInStack(e))).forEach((e=>{const t=`${FontTestClass}-${e.replace(/[^a-zA-Z0-9]+/g,"").toLowerCase()}`;document.getElementById(t)||document.body.append(h("span",{textContent:" ",id:t,class:FontTestClass,style:`font-family:${e};font-size:0;color:transparent;`}))}))},ondestroy:()=>{if(!canCheckFontAvailability())return;document.querySelectorAll(".PinturaFontTest").forEach((e=>e.remove()))},optionLabelStyle:e=>`font-family: ${e}`,options:createControlOptions(e,t),optionFilter:e=>{if(!canCheckFontAvailability())return!0;const[t]=e;if(!t)return!0;return someFontsAvailableInStack(t)}}],createColorPickerControl=(e,t={})=>["ColorPicker",{options:createControlOptions(e),...t}],createColorControl=(e,t={})=>createColorPickerControl(e,{title:e=>e.labelColor,...t}),createLabeledColorControl=e=>(t,o={})=>createColorPickerControl(t,{title:t=>t[e],...o}),createBackgroundColorControl=createLabeledColorControl("shapeTitleBackgroundColor"),createFontColorControl=createLabeledColorControl("shapeTitleTextColor"),createStrokeColorControl=(e,t={})=>createColorPickerControl(e,{title:e=>e.shapeTitleStrokeColor,options:createControlOptions(e),buttonClass:"PinturaColorPickerButtonStroke",onchange:(e,o)=>{const r=o.strokeWidth;(isNumber(r)||isString(r)?parseFloat(r):0)>0||(o.strokeWidth=t&&t.defaultStrokeWidth||"0.5%")},...t}),createStrokeWidthControl=(e,t)=>{const{title:o,optionHideLabel:r=!1,layout:n,optionIcon:i=!1}=t||{},a=maybeAutoFormatNumberItems(e),s=e.map((([e])=>isString(e)?parseFloat(e):e)),l=Math.max(...s),c=Math.min(...s),u=l-c;return["radio"===n?"RadioGroup":"Dropdown",{title:!1===o?void 0:o||(e=>e.shapeTitleStrokeWidth),options:e=>{const o=t?a.map((e=>{const[t,o,n={}]=e,a=isString(t)?parseFloat(t):t,s=(a-c)/u;let l;return"line"===i?l=`<path stroke="currentColor" stroke-linecap="square" stroke-width="${.1+.875*s}em" d="M3,12 H20"/>`:"dot"===i?l=`<circle fill="currentColor" cx="12" cy="12" r="${2+8*s}"/>`:isString(i)?l=i:isFunction(i)&&(l=i(a,s)),[t,o,{icon:l,hideLabel:r,...n}]})):a;return hasProp(e,"backgroundColor")?createControlOptions(o,{defaultKey:"shapeLabelStrokeNone"}):createControlOptions(o)},onchange:(e,t)=>{if(!e)return;const o=t.strokeColor||[];if(o[3])return;const r=[...o];r[3]=1,t.strokeColor=r}}]},createOptionControl=(e,t)=>{const{title:o,layout:r}=t||{};return["radio"===r?"RadioGroup":"Dropdown",{title:o,options:createControlOptions(e)}]},createLineControl=(e,t,o)=>["Dropdown",{title:e=>e[t],options:createControlOptions(e,{defaultKey:"labelNone",defaultOptions:{icon:'<g stroke="currentColor" stroke-linecap="round" stroke-width=".125em"><path d="M5,12 H14"/></g>'}}),optionIconStyle:o}],createLineStartStyleControl=e=>createLineControl(e,"shapeTitleLineStart","transform: scaleX(-1)"),createLineEndStyleControl=e=>createLineControl(e,"shapeTitleLineEnd"),createFontStyleControl=e=>["Dropdown",{title:e=>e.shapeTitleFontStyle,optionLabelStyle:e=>e&&`font-style:${e[0]};font-weight:${e[1]}`,options:createControlOptions(e,{defaultKey:"shapeLabelFontStyleNormal"})}],createShorthandControl=e=>["ShorthandControl",e],createSizeControl=(e,t,o,r)=>{r||e.find((([e])=>e===o))||(r={defaultKey:"labelAuto",defaultValue:o});const n=maybeAutoFormatNumberItems(e);return["Dropdown",{title:t,options:createControlOptions(n,r),...r}]},createFontSizeControl=(e,t)=>createSizeControl(e,(e=>e.shapeTitleFontSize),"4%",t),createLineHeightControl=(e,t)=>createSizeControl(e,(e=>e.shapeTitleLineHeight),"120%",t),createTextAlignControl=e=>["RadioGroup",{title:e=>e.shapeTitleTextAlign,options:createControlOptions(e)}],DefaultShapeOptionFactories={colorOptions:()=>createColorOptions(createDefaultColorOptions()),lineEndStyleOptions:()=>createLineEndStyleOptions(createDefaultLineEndStyleOptions()),fontFamilyOptions:()=>createFontFamilyOptions(createDefaultFontFamilyOptions()),fontStyleOptions:()=>createFontStyleOptions(createDefaultFontStyleOptions()),textAlignOptions:()=>createTextAlignOptions(createDefaultTextAlignOptions()),strokeWidthOptions:()=>createStrokeScaleOptions(createDefaultStrokeScaleOptions()),brushSizeOptions:()=>createStrokeScaleOptions(Object.entries(createDefaultStrokeScaleOptions()).reduce(((e,[t,o])=>(e[t]=2*parseFloat(o)+"%",e)),{})),fontSizeOptions:()=>createFontScaleOptions(createDefaultFontScaleOptions()),lineHeightOptions:()=>createLineHeightScaleOptions(createDefaultLineHeightScaleOptions())},sliderNumberFormatter=new Intl.NumberFormat("default",{minimumFractionDigits:1,maximumFractionDigits:1}),setSliderOptionalPercentageValue=(e,t)=>isString(t)?`${e}%`:e,getSliderOptionalPercentageLabel=(e,t,o,r)=>isString(r)?`${Math.round(e/o*100)}%`:`${sliderNumberFormatter.format(e)}`,TextShadowSliderOptions={getValue:e=>parseFloat(e),setValue:setSliderOptionalPercentageValue,label:getSliderOptionalPercentageLabel,step:.05,labelClass:"PinturaPercentageLabel"},TextShadowControl={factory:createShorthandControl,options:{title:"Text shadow",controls:[["ToggleSlider","x",{...TextShadowSliderOptions,min:-100,max:100,labelPrefix:"X"}],["ToggleSlider","y",{...TextShadowSliderOptions,min:-100,max:100,labelPrefix:"Y"}],["ToggleSlider","blur",{...TextShadowSliderOptions,min:0,max:25,labelPrefix:e=>e.shapeTitleTextShadowBlur}],["ColorPicker","color",{enablePresets:!1}]]}},TextOutlineControl={factory:createShorthandControl,options:{title:"Text outline",controls:[["ToggleSlider","width",{getValue:e=>parseFloat(e),setValue:setSliderOptionalPercentageValue,label:getSliderOptionalPercentageLabel,min:0,max:15,step:.05,labelClass:"PinturaPercentageLabel",labelPrefix:e=>e.shapeTitleTextOutlineWidth}],["ColorPicker","color",{enablePresets:!1}]]}},DefaultShapeControls={defaultColor:{factory:createColorControl,items:"colorOptions"},defaultNumber:{factory:createSliderControl},defaultPercentage:{factory:createSliderControl,options:{getValue:e=>parseFloat(e),setValue:e=>`${e}%`,step:.05,label:(e,t,o)=>`${Math.round(e/o*100)}%`,labelClass:"PinturaPercentageLabel"}},backgroundColor:{items:"colorOptions",factory:createBackgroundColorControl},strokeColor:{items:"colorOptions",factory:createStrokeColorControl},strokeWidth:{items:"strokeWidthOptions",factory:createStrokeWidthControl},brushSize:{items:"brushSizeOptions",factory:createBrushSizeControl},drawMode:{factory:createSelectionModeControl},lineStart:{items:"lineEndStyleOptions",factory:createLineStartStyleControl},lineEnd:{items:"lineEndStyleOptions",factory:createLineEndStyleControl},color:{items:"colorOptions",factory:createFontColorControl},fontFamily:{items:"fontFamilyOptions",factory:createFontFamilyControl},fontStyle_fontWeight:{items:"fontStyleOptions",factory:createFontStyleControl},fontSize:{items:"fontSizeOptions",factory:createFontSizeControl},lineHeight:{items:"lineHeightOptions",factory:createLineHeightControl},textAlign:{items:"textAlignOptions",factory:createTextAlignControl},textShadowX_textShadowY_textShadowBlur_textShadowColor:TextShadowControl,textOutlineWidth_textOutlineColor:TextOutlineControl,cornerRadius:{factory:"defaultPercentage",options:{min:0,max:50,title:e=>e.shapeTitleCornerRadius}},frameColor:{factory:"defaultColor"},frameSize:{factory:"defaultPercentage",options:{min:.2,max:10,title:e=>e.labelSize}},frameInset:{factory:"defaultPercentage",options:{min:.5,max:10,title:e=>e.labelOffset}},frameOffset:{factory:"defaultPercentage",options:{min:.5,max:10,title:e=>e.labelOffset}},frameRadius:{factory:"defaultPercentage",options:{min:.5,max:10,title:e=>e.labelRadius}},frameAmount:{factory:"defaultNumber",options:{min:1,max:5,step:1,title:e=>e.labelAmount}}},createShapeStyleControls=(e={})=>{const t={...DefaultShapeControls,...e},o={};return Object.entries(t).forEach((([e,r])=>{if(!/Options$/.test(e))if(DefaultShapeControls[e]&&isObject(r)&&!isArray(r)){const{component:r,factory:n,items:i,options:a={}}=t[e];if(isString(n))o[e]=[n,a];else{const s=DefaultShapeControls[e].items;let l=isString(s)?t[s]||DefaultShapeOptionFactories[s]():void 0;isString(i)&&DefaultShapeOptionFactories[i]?l=t[i]?t[i].every((e=>!Array.isArray(e)))?t[i].map((e=>[e,e])):t[i]:DefaultShapeOptionFactories[i]():(i||a.items)&&(l=i||a.items);let c=n||DefaultShapeControls[e].factory;isFunction(c)?o[e]=l?c(l,a):c(a):r&&(o[e]=[r,{...a,items:i}])}}else o[e]=r})),o};function create_fragment$s(e){let t,o,r,n,i;const a=e[7].default,s=create_slot(a,e,e[6],null);return{c(){t=element("div"),o=element("div"),s&&s.c(),attr(o,"class","PinturaToolbarInner"),attr(t,"class","PinturaToolbar"),attr(t,"data-layout",e[1]),attr(t,"data-overflow",e[0])},m(a,l){insert(a,t,l),append(t,o),s&&s.m(o,null),r=!0,n||(i=[listen(o,"measure",e[3]),action_destroyer(measurable.call(null,o)),listen(t,"measure",e[2]),action_destroyer(measurable.call(null,t))],n=!0)},p(e,[o]){s&&s.p&&(!r||64&o)&&update_slot_base(s,a,e,e[6],r?get_slot_changes(a,e[6],o,null):get_all_dirty_from_scope(e[6]),null),(!r||2&o)&&attr(t,"data-layout",e[1]),(!r||1&o)&&attr(t,"data-overflow",e[0])},i(e){r||(transition_in(s,e),r=!0)},o(e){transition_out(s,e),r=!1},d(e){e&&detach(t),s&&s.d(e),n=!1,run_all(i)}}}function instance$s(e,t,o){let r,n,{$$slots:i={},$$scope:a}=t,s=0,l=0,c=0;const u=()=>{o(0,n="compact"===r&&s>c?"overflow":void 0)};return e.$$set=e=>{"$$scope"in e&&o(6,a=e.$$scope)},e.$$.update=()=>{48&e.$$.dirty&&o(1,r=l>c?"compact":"default")},[n,r,({detail:e})=>{const{width:t}=e;o(5,c=t),u()},({detail:e})=>{const{width:t}=e;t>l&&o(4,l=t),s=t,n||u()},l,c,a,i]}class Toolbar extends SvelteComponent{constructor(e){super(),init(this,e,instance$s,create_fragment$s,safe_not_equal,{})}}function create_fragment$r(e){let t,o,r,n;const i=e[5].default,a=create_slot(i,e,e[4],null);return{c(){t=element("div"),a&&a.c(),attr(t,"class",e[0])},m(i,s){insert(i,t,s),a&&a.m(t,null),o=!0,r||(n=[listen(t,"measure",(function(){is_function(e[1]&&e[3])&&(e[1]&&e[3]).apply(this,arguments)})),action_destroyer(e[2].call(null,t))],r=!0)},p(r,[n]){e=r,a&&a.p&&(!o||16&n)&&update_slot_base(a,i,e,e[4],o?get_slot_changes(i,e[4],n,null):get_all_dirty_from_scope(e[4]),null),(!o||1&n)&&attr(t,"class",e[0])},i(e){o||(transition_in(a,e),o=!0)},o(e){transition_out(a,e),o=!1},d(e){e&&detach(t),a&&a.d(e),r=!1,run_all(n)}}}function instance$r(e,t,o){let{$$slots:r={},$$scope:n}=t;const i=createEventDispatcher();let{class:a=null}=t;const s=getContext("measurable");let l=!1;return onMount((()=>o(1,l=!0))),e.$$set=e=>{"class"in e&&o(0,a=e.class),"$$scope"in e&&o(4,n=e.$$scope)},[a,l,s,({detail:e})=>i("measure",e),n,r]}class Measure extends SvelteComponent{constructor(e){super(),init(this,e,instance$r,create_fragment$r,safe_not_equal,{class:0})}}const get_footer_slot_changes=e=>({}),get_footer_slot_context=e=>({}),get_main_slot_changes=e=>({}),get_main_slot_context=e=>({}),get_header_slot_changes=e=>({}),get_header_slot_context=e=>({});function create_if_block_2$5(e){let t,o;const r=e[4].header,n=create_slot(r,e,e[3],get_header_slot_context);return{c(){t=element("div"),n&&n.c(),attr(t,"class","PinturaUtilHeader")},m(e,r){insert(e,t,r),n&&n.m(t,null),o=!0},p(e,t){n&&n.p&&(!o||8&t)&&update_slot_base(n,r,e,e[3],o?get_slot_changes(r,e[3],t,get_header_slot_changes):get_all_dirty_from_scope(e[3]),get_header_slot_context)},i(e){o||(transition_in(n,e),o=!0)},o(e){transition_out(n,e),o=!1},d(e){e&&detach(t),n&&n.d(e)}}}function fallback_block(e){let t,o;return t=new Measure({props:{class:"PinturaStage"}}),t.$on("measure",e[5]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p:noop,i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_1$6(e){let t,o;const r=e[4].footer,n=create_slot(r,e,e[3],get_footer_slot_context);return{c(){t=element("div"),n&&n.c(),attr(t,"class","PinturaUtilFooter")},m(e,r){insert(e,t,r),n&&n.m(t,null),o=!0},p(e,t){n&&n.p&&(!o||8&t)&&update_slot_base(n,r,e,e[3],o?get_slot_changes(r,e[3],t,get_footer_slot_changes):get_all_dirty_from_scope(e[3]),get_footer_slot_context)},i(e){o||(transition_in(n,e),o=!0)},o(e){transition_out(n,e),o=!1},d(e){e&&detach(t),n&&n.d(e)}}}function create_fragment$q(e){let t,o,r,n,i,a,s=e[1]&&create_if_block_2$5(e);const l=e[4].main,c=create_slot(l,e,e[3],get_main_slot_context),u=c||fallback_block(e);let p=e[2]&&create_if_block_1$6(e),d=!1;return{c(){s&&s.c(),t=space(),o=element("div"),u&&u.c(),r=space(),p&&p.c(),n=space(),i=empty(),attr(o,"class","PinturaUtilMain")},m(l,c){s&&s.m(l,c),insert(l,t,c),insert(l,o,c),u&&u.m(o,null),e[6](o),insert(l,r,c),p&&p.m(l,c),insert(l,n,c),insert(l,i,c),a=!0},p(e,[o]){e[1]?s?(s.p(e,o),2&o&&transition_in(s,1)):(s=create_if_block_2$5(e),s.c(),transition_in(s,1),s.m(t.parentNode,t)):s&&(group_outros(),transition_out(s,1,1,(()=>{s=null})),check_outros()),c&&c.p&&(!a||8&o)&&update_slot_base(c,l,e,e[3],a?get_slot_changes(l,e[3],o,get_main_slot_changes):get_all_dirty_from_scope(e[3]),get_main_slot_context),e[2]?p?(p.p(e,o),4&o&&transition_in(p,1)):(p=create_if_block_1$6(e),p.c(),transition_in(p,1),p.m(n.parentNode,n)):p&&(group_outros(),transition_out(p,1,1,(()=>{p=null})),check_outros())},i(e){a||(transition_in(s),transition_in(u,e),transition_in(p),transition_in(d),a=!0)},o(e){transition_out(s),transition_out(u,e),transition_out(p),transition_out(d),a=!1},d(a){s&&s.d(a),a&&detach(t),a&&detach(o),u&&u.d(a),e[6](null),a&&detach(r),p&&p.d(a),a&&detach(n),a&&detach(i)}}}function instance$q(e,t,o){let{$$slots:r={},$$scope:n}=t,{hasHeader:i=!!t.$$slots.header}=t,{hasFooter:a=!!t.$$slots.footer}=t,{root:s}=t;return e.$$set=e=>{o(7,t=assign(assign({},t),exclude_internal_props(e))),"hasHeader"in e&&o(1,i=e.hasHeader),"hasFooter"in e&&o(2,a=e.hasFooter),"root"in e&&o(0,s=e.root),"$$scope"in e&&o(3,n=e.$$scope)},t=exclude_internal_props(t),[s,i,a,n,r,function(t){bubble.call(this,e,t)},function(e){binding_callbacks[e?"unshift":"push"]((()=>{s=e,o(0,s)}))}]}class Util extends SvelteComponent{constructor(e){super(),init(this,e,instance$q,create_fragment$q,safe_not_equal,{hasHeader:1,hasFooter:2,root:0})}}function create_if_block$a(e){let t;return{c(){t=element("div"),attr(t,"class","PinturaRangeInputMeter"),set_style(t,"transform",`translateX(${e[10].x-e[13].x}px) translateY(${e[10].y-e[13].y}px)`)},m(o,r){insert(o,t,r),t.innerHTML=e[7]},p(e,o){128&o[0]&&(t.innerHTML=e[7]),1024&o[0]&&set_style(t,"transform",`translateX(${e[10].x-e[13].x}px) translateY(${e[10].y-e[13].y}px)`)},d(e){e&&detach(t)}}}function create_fragment$p(e){let t,o,r,n,i,a,s,l,c,u,p,d=e[10]&&create_if_block$a(e);return{c(){t=element("div"),o=element("span"),r=space(),n=element("button"),i=text(e[1]),s=space(),l=element("div"),d&&d.c(),attr(o,"class","PinturaRangeInputValue"),attr(n,"class","PinturaRangeInputReset"),attr(n,"type","button"),n.disabled=a=e[0]===e[2],attr(l,"class","PinturaRangeInputInner"),attr(l,"data-value-limited",e[5]),set_style(l,"--range-mask-from",e[9]),set_style(l,"--range-mask-to",e[8]),attr(t,"class","PinturaRangeInput"),attr(t,"tabindex","0")},m(a,h){insert(a,t,h),append(t,o),o.innerHTML=e[3],append(t,r),append(t,n),append(n,i),append(t,s),append(t,l),d&&d.m(l,null),u||(p=[listen(n,"click",e[18]),listen(l,"interactionstart",e[14]),listen(l,"interactionupdate",e[16]),listen(l,"interactionend",e[17]),listen(l,"interactionrelease",e[15]),action_destroyer(c=interactable.call(null,l,{inertia:e[6]})),listen(l,"measure",e[39]),action_destroyer(measurable.call(null,l)),listen(t,"wheel",e[20],{passive:!1}),listen(t,"nudge",e[21]),action_destroyer(nudgeable.call(null,t,{direction:"horizontal",preventDefault:!0}))],u=!0)},p(e,t){8&t[0]&&(o.innerHTML=e[3]),2&t[0]&&set_data(i,e[1]),5&t[0]&&a!==(a=e[0]===e[2])&&(n.disabled=a),e[10]?d?d.p(e,t):(d=create_if_block$a(e),d.c(),d.m(l,null)):d&&(d.d(1),d=null),32&t[0]&&attr(l,"data-value-limited",e[5]),c&&is_function(c.update)&&64&t[0]&&c.update.call(null,{inertia:e[6]}),512&t[0]&&set_style(l,"--range-mask-from",e[9]),256&t[0]&&set_style(l,"--range-mask-to",e[8])},i:noop,o:noop,d(e){e&&detach(t),d&&d.d(),u=!1,run_all(p)}}}const radiusBig=2,radiusSmall=.75,indicatorSpacing=10,indicatorInterval=5,indicatorCount=40;function instance$p(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,{labelReset:g="Reset"}=t,{direction:f="x"}=t,{min:$=0}=t,{max:b=1}=t,{base:y=$}=t,{value:_=0}=t,{valueLabel:x=0}=t,{valueMin:v}=t,{valueMax:S}=t,{oninputstart:C=noop$1}=t,{oninputmove:w=noop$1}=t,{oninputend:T=noop$1}=t,{elasticity:k=0}=t,{nudgeMultiplier:R}=t,{step:P=8}=t;const I=getContext("isAnimated");component_subscribe(e,I,(e=>o(6,d=e)));const E=getContext("fixScrollDirection");component_subscribe(e,E,(e=>o(45,h=e)));const M=(e,t,o)=>Math.ceil((e-o)/t)*t+o;let A,F,L;const D={x:2,y:0},z=(e,t,o)=>`M ${e-o} ${t} a ${o} ${o} 0 1 0 0 -1`;let O,B,N=!1,V={snap:!1,elastic:!1};const W=(e,t,o)=>{const r=e[f]+t[f],n=clamp(r,B[1][f],B[0][f]),i=k?n+elastify(r-n,k):n,a=o.elastic?i:n,s=vectorCreate(0,0);return s[f]=a,U.set(s,{hard:o.snap}),clamp(G(s,f),$,b)},U=spring();component_subscribe(e,U,(e=>o(10,m=e)));const H=(e,t)=>{const o=.5*(A[t]-a[t])-(toFraction(e,$,b)*a[t]-.5*a[t]);return{x:"x"===t?o:0,y:"y"===t?o:0}},G=(e,t)=>{const o=-(e[t]-.5*A[t])/a[t];return $+o*r},j=U.subscribe((e=>{e&&O&&w(clamp(G(e,f),$,b))})),q=e=>{const t=[H(null!=v?v:$,f),H(null!=S?S:b,f)],o={x:"x"===f?m.x+e:0,y:"y"===f?m.y+e:0},r=clamp(o[f],t[1][f],t[0][f]),n={...m,[f]:r};set_store_value(U,m=n,m);const i=clamp(G(n,f),$,b);C(),w(i),T(i)};onDestroy((()=>{j()}));return e.$$set=e=>{"labelReset"in e&&o(1,g=e.labelReset),"direction"in e&&o(22,f=e.direction),"min"in e&&o(23,$=e.min),"max"in e&&o(24,b=e.max),"base"in e&&o(2,y=e.base),"value"in e&&o(0,_=e.value),"valueLabel"in e&&o(3,x=e.valueLabel),"valueMin"in e&&o(25,v=e.valueMin),"valueMax"in e&&o(26,S=e.valueMax),"oninputstart"in e&&o(27,C=e.oninputstart),"oninputmove"in e&&o(28,w=e.oninputmove),"oninputend"in e&&o(29,T=e.oninputend),"elasticity"in e&&o(30,k=e.elasticity),"nudgeMultiplier"in e&&o(31,R=e.nudgeMultiplier),"step"in e&&o(32,P=e.step)},e.$$.update=()=>{if(25165824&e.$$.dirty[0]&&o(34,r=b-$),41943040&e.$$.dirty[0]&&o(36,n=null!=v?Math.max(v,$):$),83886080&e.$$.dirty[0]&&o(35,i=null!=S?Math.min(S,b):b),25165828&e.$$.dirty[0]&&o(38,s=toFraction(y,$,b)),16&e.$$.dirty[0]|128&e.$$.dirty[1]&&A){const e=.5*A.y;let t,r=40*s,n="",i=A.y,a="";for(let o=0;o<=40;o++){const i=D.x+10*o,s=e;n+=z(i,s,o%5==0?2:.75)+" ",t=i+D.x,o===r&&(a=`<path d="M${i} ${s-4} l2 3 l-2 -1 l-2 1 z"/>`)}o(7,F=`<svg width="${t}" height="${i}" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 ${t} ${i}" aria-hidden="true" focusable="false">\n        ${a}\n        <rect rx="4" ry="4" y="${e-4}"" height="8"/>\n        <path fill-rule="evenodd" d="${n.trim()}"/></svg>`),o(33,L={x:t-2*D.x,y:i})}16&e.$$.dirty[0]|4&e.$$.dirty[1]&&(a=A&&L),25165824&e.$$.dirty[0]|48&e.$$.dirty[1]&&o(5,l=n!==$||i!==b),32&e.$$.dirty[0]|48&e.$$.dirty[1]&&o(37,c=l?function(e,t){const o=1/40,r=toFraction(e,$,b),n=toFraction(t,$,b);return[100*fixPrecision(M(r,o,0)-.0125)+"%",100*fixPrecision(M(n,o,0)-.0125)+"%"]}(n,i):void 0),64&e.$$.dirty[1]&&o(9,u=c?c[0]:""),64&e.$$.dirty[1]&&o(8,p=c?c[1]:""),4194385&e.$$.dirty[0]|8&e.$$.dirty[1]&&r&&A&&A.x&&A.y&&U.set(H(_,f),{hard:!1===d})},[_,g,y,x,A,l,d,F,p,u,m,I,E,D,()=>{N=!1,O=get_store_value(U),B=[H(null!=v?v:$,f),H(null!=S?S:b,f)],C()},()=>{N=!0},({detail:e})=>{V.snap=!N,V.elastic=!N,W(O,e.translation,V)},({detail:e})=>{V.snap=!1,V.elastic=!1;const t=W(O,e.translation,V);if(O=void 0,B=void 0,Math.abs(t-y)<.01)return T(y);T(t)},()=>{o(0,_=clamp(y,n,i)),C(),T(_)},U,e=>{e.preventDefault(),e.stopPropagation();const t=getWheelDelta(e,{fixScrollDirection:h})*P;q(t)},({detail:e})=>{q(e[f]*Math.abs(R||8))},f,$,b,v,S,C,w,T,k,R,P,L,r,i,n,c,s,e=>o(4,A=vectorCreateFromSize(e.detail))]}class RangeInput extends SvelteComponent{constructor(e){super(),init(this,e,instance$p,create_fragment$p,safe_not_equal,{labelReset:1,direction:22,min:23,max:24,base:2,value:0,valueLabel:3,valueMin:25,valueMax:26,oninputstart:27,oninputmove:28,oninputend:29,elasticity:30,nudgeMultiplier:31,step:32},null,[-1,-1])}}var DirectionRectMap={[Top]:e=>({x:e.x,y:e.y}),[TopRight]:e=>({x:e.x+e.width,y:e.y}),[Right]:e=>({x:e.x+e.width,y:e.y}),[BottomRight]:e=>({x:e.x+e.width,y:e.y+e.height}),[Bottom]:e=>({x:e.x,y:e.y+e.height}),[BottomLeft]:e=>({x:e.x,y:e.y+e.height}),[Left]:e=>({x:e.x,y:e.y}),[TopLeft]:e=>({x:e.x,y:e.y})};function get_each_context$3(e,t,o){const r=e.slice();return r[14]=t[o].key,r[15]=t[o].translate,r[16]=t[o].scale,r[17]=t[o].type,r[18]=t[o].opacity,r}function create_each_block$3(e,t){let o,r,n,i,a,s,l;return{key:e,first:null,c(){o=element("div"),attr(o,"role","button"),attr(o,"aria-label",r=`Drag ${t[17]} ${t[14]}`),attr(o,"tabindex",n="edge"===t[17]?-1:0),attr(o,"class","PinturaRectManipulator"),attr(o,"data-direction",i=t[14]),attr(o,"data-shape",a=""+("edge"===t[17]?"edge":`${t[0]}`)),set_style(o,"--tx",t[15].x),set_style(o,"--ty",t[15].y),set_style(o,"--sx",t[16].x),set_style(o,"--sy",t[16].y),set_style(o,"opacity",t[18]),this.first=o},m(e,r){insert(e,o,r),s||(l=[listen(o,"nudge",(function(){is_function(t[6](t[14]))&&t[6](t[14]).apply(this,arguments)})),action_destroyer(nudgeable.call(null,o,{preventDefault:!0})),listen(o,"interactionstart",(function(){is_function(t[5]("resizestart",t[14]))&&t[5]("resizestart",t[14]).apply(this,arguments)})),listen(o,"interactionupdate",(function(){is_function(t[5]("resizemove",t[14]))&&t[5]("resizemove",t[14]).apply(this,arguments)})),listen(o,"interactionend",(function(){is_function(t[5]("resizeend",t[14]))&&t[5]("resizeend",t[14]).apply(this,arguments)})),action_destroyer(interactable.call(null,o))],s=!0)},p(e,s){t=e,2&s&&r!==(r=`Drag ${t[17]} ${t[14]}`)&&attr(o,"aria-label",r),2&s&&n!==(n="edge"===t[17]?-1:0)&&attr(o,"tabindex",n),2&s&&i!==(i=t[14])&&attr(o,"data-direction",i),3&s&&a!==(a=""+("edge"===t[17]?"edge":`${t[0]}`))&&attr(o,"data-shape",a),2&s&&set_style(o,"--tx",t[15].x),2&s&&set_style(o,"--ty",t[15].y),2&s&&set_style(o,"--sx",t[16].x),2&s&&set_style(o,"--sy",t[16].y),2&s&&set_style(o,"opacity",t[18])},d(e){e&&detach(o),s=!1,run_all(l)}}}function create_fragment$o(e){let t,o=[],r=new Map,n=e[1];const i=e=>e[14];for(let t=0;t<n.length;t+=1){let a=get_each_context$3(e,n,t),s=i(a);r.set(s,o[t]=create_each_block$3(s,a))}return{c(){for(let e=0;e<o.length;e+=1)o[e].c();t=empty()},m(e,r){for(let t=0;t<o.length;t+=1)o[t].m(e,r);insert(e,t,r)},p(e,[a]){99&a&&(n=e[1],o=update_keyed_each(o,a,i,1,e,n,r,t.parentNode,destroy_block,create_each_block$3,t,get_each_context$3))},i:noop,o:noop,d(e){for(let t=0;t<o.length;t+=1)o[t].d(e);e&&detach(t)}}}function instance$o(e,t,o){let r,n,i,a,{rect:s=null}=t,{visible:l=!1}=t,{cornerStyle:c}=t;const u=getContext("isAnimated");component_subscribe(e,u,(e=>o(11,a=e)));const p=spring(void 0,{precision:1e-4,stiffness:.2,damping:.4});component_subscribe(e,p,(e=>o(10,i=e)));const d=spring(0,{precision:.001});let h;component_subscribe(e,d,(e=>o(9,n=e)));const m=createEventDispatcher();return e.$$set=e=>{"rect"in e&&o(7,s=e.rect),"visible"in e&&o(8,l=e.visible),"cornerStyle"in e&&o(0,c=e.cornerStyle)},e.$$.update=()=>{2304&e.$$.dirty&&p.set(l?1:.5,{hard:!1===a}),2304&e.$$.dirty&&d.set(l?1:0,{hard:!1===a}),1664&e.$$.dirty&&o(1,r=Object.keys(Direction).map(((e,t)=>{const o=Direction[e],r=DirectionRectMap[o](s),a=1===o.length?"edge":"corner",l="corner"===a;return{key:o,type:a,scale:{x:/^(t|b)$/.test(o)?s.width:l?clamp(i,.5,1.25):1,y:/^(r|l)$/.test(o)?s.height:l?clamp(i,.5,1.25):1},translate:{x:r.x,y:r.y},opacity:n}})))},[c,r,u,p,d,(e,t)=>({detail:o})=>{h&&t!==h||"resizestart"!==e&&void 0===h||("resizestart"===e&&(h=t),"resizeend"===e&&(h=void 0),m(e,{direction:t,translation:o&&o.translation}))},e=>({detail:t})=>{m("resizestart",{direction:e,translation:{x:0,y:0}}),m("resizemove",{direction:e,translation:t}),m("resizeend",{direction:e,translation:{x:0,y:0}})},s,l,n,i,a]}class RectManipulator extends SvelteComponent{constructor(e){super(),init(this,e,instance$o,create_fragment$o,safe_not_equal,{rect:7,visible:8,cornerStyle:0})}}var gesturable=e=>{function t(t,o){e.dispatchEvent(new CustomEvent(t,{detail:o}))}const o=o=>{o.preventDefault(),e.addEventListener("gesturechange",r),e.addEventListener("gestureend",n),t("gesturedown")},r=e=>{e.preventDefault(),t("gestureupdate",e.scale)},n=e=>{t("gestureup",e.scale),e.preventDefault(),i()},i=()=>{e.removeEventListener("gesturechange",r),e.removeEventListener("gestureend",n)};return e.addEventListener("gesturestart",o),{destroy:()=>{i(),e.removeEventListener("gesturestart",o)}}},DirectionInversionTable={[Top]:Bottom,[Right]:Left,[Bottom]:Top,[Left]:Right,[TopLeft]:BottomRight,[TopRight]:BottomLeft,[BottomRight]:TopLeft,[BottomLeft]:TopRight},getTranslationInfo=e=>{const t=e===Left||e===Right,o=e===Top||e===Bottom;return[e===Right||e===TopRight||e===BottomRight,e===Left||e===BottomLeft||e===TopLeft,e===Top||e===TopRight||e===TopLeft,e===Bottom||e===BottomRight||e===BottomLeft,t,o,t||o]},limitRectDirectionTranslation=(e,t,o,r={})=>{const{target:n,translate:i}=t,{aspectRatio:a,minSize:s,maxSize:l}=r,c=DirectionInversionTable[n],u=DirectionCoordinateTable[c],p=vectorAdd(vectorCreate(e.x,e.y),vectorCreate(u[0]*e.width,u[1]*e.height)),d=DirectionCoordinateTable[n],h=vectorAdd(rectClone$1(e),vectorCreate(d[0]*e.width,d[1]*e.height)),[m,g,f,$,b,y,_]=getTranslationInfo(n);let x=i.x,v=i.y;b?v=0:y&&(x=0);const{inner:S,outer:C}=getInteractionBounds(p,n,o,{aspectRatio:a,minSize:s,maxSize:l});let[w,T,k,R]=rectToBounds(e);if(m?R=p.x:g&&(T=p.x),$?w=p.y:f&&(k=p.y),m){const e=S.x+S.width,t=C.x+C.width;T=clamp(h.x+x,e,t)}else if(g){const e=C.x,t=S.x;R=clamp(h.x+x,e,t)}if($){const e=S.y+S.height,t=C.y+C.height;k=clamp(h.y+v,e,t)}else if(f){const e=C.y,t=S.y;w=clamp(h.y+v,e,t)}if(R>S.x&&(R=S.x),T<S.x+S.width&&(T=S.x+S.width),w>S.y&&(w=S.y),k<S.y+S.height&&(k=S.y+S.height),R<C.x){const e=C.x-R;R=C.x,T+=e}if(T>C.x+C.width){const e=T-(C.x+C.width);T=C.x+C.width,R-=e}if(w<C.y){const e=C.y-w;w=C.y,k+=e}if(k>C.y+C.height){const e=k-(C.y+C.height);k=C.y+C.height,w-=e}if(a)if(_){let e=T-R,t=k-w;b?(t=e/a,w=p.y-.5*t,k=p.y+.5*t):y&&(e=t*a,R=p.x-.5*e,T=p.x+.5*e)}else{const e=vectorCreate(h.x+x-p.x,h.y+v-p.y);n===TopRight?(e.x=Math.max(0,e.x),e.y=Math.min(0,e.y)):n===BottomRight?(e.x=Math.max(0,e.x),e.y=Math.max(0,e.y)):n===BottomLeft?(e.x=Math.min(0,e.x),e.y=Math.max(0,e.y)):n===TopLeft&&(e.x=Math.min(0,e.x),e.y=Math.min(0,e.y));const t=vectorLength(e),o=vectorLength(vectorCreate(S.width,S.height)),r=vectorLength(vectorCreate(C.width,C.height)),i=clamp(t,o,r),s=vectorCreate(a,1),l=vectorMultiply(vectorNormalize(s),i);n===TopRight?(T=p.x+l.x,w=p.y-l.y):n===BottomRight?(T=p.x+l.x,k=p.y+l.y):n===BottomLeft?(R=p.x-l.x,k=p.y+l.y):n===TopLeft&&(R=p.x-l.x,w=p.y-l.y)}return rectCreate(R,w,T-R,k-w)};const getInteractionBounds=(e,t,o,r)=>{const{aspectRatio:n,minSize:i,maxSize:a}=r,s=t===Right||t===TopRight||t===BottomRight,l=t===Left||t===BottomLeft||t===TopLeft,c=t===Top||t===TopRight||t===TopLeft,u=t===Bottom||t===BottomRight||t===BottomLeft,p=t===Left||t===Right,d=t===Top||t===Bottom,h=rectClone$1(o);s?(h.x=e.x,h.width-=e.x):l&&(h.width=e.x),u?(h.y=e.y,h.height-=e.y):c&&(h.height=e.y);const m=rectCreateFromDimensions(Math.min(h.width,a.width),Math.min(h.height,a.height));if(n)if(p){const t=Math.min(e.y,o.height-e.y);m.height=Math.min(2*t,m.height)}else if(d){const t=Math.min(e.x,o.width-e.x);m.width=Math.min(2*t,m.width)}const g=n?sizeCreateFromRect(rectCoverRect(rectCreateFromSize(i),n)):i,f=n?sizeCreateFromRect(rectContainRect(m,n)):m;let $,b,y,_;s?$=e.x:l&&(b=e.x),u?y=e.y:c&&(_=e.y),s?b=$+g.width:l&&($=b-g.width),u?_=y+g.height:c&&(y=_-g.height),p?(y=e.y-.5*g.height,_=e.y+.5*g.height):d&&($=e.x-.5*g.width,b=e.x+.5*g.width);const x=rectCreateFromPoints([vectorCreate($,y),vectorCreate(b,_)]);s?b=$+f.width:l&&($=b-f.width),u?_=y+f.height:c&&(y=_-f.height),p?(y=e.y-.5*f.height,_=e.y+.5*f.height):d&&($=e.x-.5*f.width,b=e.x+.5*f.width),$=Math.max(o.x,$),b=Math.min(o.x+o.width,b),y=Math.max(o.y,y),_=Math.min(o.y+o.height,_);return{inner:x,outer:rectCreateFromPoints([vectorCreate($,y),vectorCreate(b,_)])}};var applyRectDirectionTranslation=(e,t,o={})=>{const{target:r,translate:n}=t,{aspectRatio:i,minSize:a}=o,s=DirectionInversionTable[r],l=DirectionCoordinateTable[s],c=vectorAdd(rectClone$1(e),vectorCreate(l[0]*e.width,l[1]*e.height)),u=DirectionCoordinateTable[r],p=vectorAdd(rectClone$1(e),vectorCreate(u[0]*e.width,u[1]*e.height)),[d,h,m,g,f,$,b]=getTranslationInfo(r);let y=n.x,_=n.y;f?_=0:$&&(y=0);let[x,v,S,C]=rectToBounds(e);if(d?C=c.x:h&&(v=c.x),g?x=c.y:m&&(S=c.y),d?v=p.x+y:h&&(C=p.x+y),g?S=p.y+_:m&&(x=p.y+_),a&&f&&S-x<a.height){const e=a.height-(S-x);x-=.5*e,S+=.5*e}if(a&&$&&v-C<a.width){const e=a.width-(v-C);C-=.5*e,v+=.5*e}if(i)if(b){let e=v-C,t=S-x;f?(t=e/i,x=c.y-.5*t,S=c.y+.5*t):$&&(e=t*i,C=c.x-.5*e,v=c.x+.5*e)}else{const e=vectorCreate(p.x+y-c.x,p.y+_-c.y);r===TopRight?(e.x=Math.max(0,e.x),e.y=Math.min(0,e.y)):r===BottomRight?(e.x=Math.max(0,e.x),e.y=Math.max(0,e.y)):r===BottomLeft?(e.x=Math.min(0,e.x),e.y=Math.max(0,e.y)):r===TopLeft&&(e.x=Math.min(0,e.x),e.y=Math.min(0,e.y));const t=vectorLength(e),o=vectorCreate(i,1),n=vectorMultiply(vectorNormalize(o),t);r===TopRight?(v=c.x+n.x,x=c.y-n.y):r===BottomRight?(v=c.x+n.x,S=c.y+n.y):r===BottomLeft?(C=c.x-n.x,S=c.y+n.y):r===TopLeft&&(C=c.x-n.x,x=c.y-n.y)}return rectCreate(C,x,v-C,S-x)},radToDeg=e=>180*e/Math.PI;function create_fragment$n(e){let t,o,r;return o=new RangeInput({props:{elasticity:e[5],min:e[9],max:e[10],value:e[11],valueMin:Math.max(e[9],e[0]),valueMax:Math.min(e[10],e[1]),labelReset:e[6],base:e[12],valueLabel:`${Math.round(radToDeg(e[11]))}&deg;`,oninputstart:e[2],oninputmove:e[17],oninputend:e[18]}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"class","PinturaImageRotator")},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,[t]){const r={};32&t&&(r.elasticity=e[5]),512&t&&(r.min=e[9]),1024&t&&(r.max=e[10]),2048&t&&(r.value=e[11]),513&t&&(r.valueMin=Math.max(e[9],e[0])),1026&t&&(r.valueMax=Math.min(e[10],e[1])),64&t&&(r.labelReset=e[6]),4096&t&&(r.base=e[12]),2048&t&&(r.valueLabel=`${Math.round(radToDeg(e[11]))}&deg;`),4&t&&(r.oninputstart=e[2]),392&t&&(r.oninputmove=e[17]),400&t&&(r.oninputend=e[18]),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}const MARGIN=1e-9;function instance$n(e,t,o){let r,n,i,a,s,l,c,{rotation:u}=t,{valueMin:p}=t,{valueMax:d}=t,{oninputstart:h=noop$1}=t,{oninputmove:m=noop$1}=t,{oninputend:g=noop$1}=t,{elasticity:f=0}=t,{labelReset:$}=t,{rotationMin:b}=t,{rotationMax:y}=t;return e.$$set=e=>{"rotation"in e&&o(13,u=e.rotation),"valueMin"in e&&o(0,p=e.valueMin),"valueMax"in e&&o(1,d=e.valueMax),"oninputstart"in e&&o(2,h=e.oninputstart),"oninputmove"in e&&o(3,m=e.oninputmove),"oninputend"in e&&o(4,g=e.oninputend),"elasticity"in e&&o(5,f=e.elasticity),"labelReset"in e&&o(6,$=e.labelReset),"rotationMin"in e&&o(14,b=e.rotationMin),"rotationMax"in e&&o(15,y=e.rotationMax)},e.$$.update=()=>{16384&e.$$.dirty&&o(9,r=b+1e-9),32768&e.$$.dirty&&o(10,n=y-1e-9),1536&e.$$.dirty&&o(12,i=r+.5*(n-r)),32768&e.$$.dirty&&o(16,a=2*y),8192&e.$$.dirty&&o(8,s=Math.sign(u)),73728&e.$$.dirty&&o(7,l=Math.round(Math.abs(u)/a)*a),8576&e.$$.dirty&&o(11,c=u-s*l)},[p,d,h,m,g,f,$,l,s,r,n,c,i,u,b,y,a,e=>m(s*l+e),e=>g(s*l+e)]}class ImageRotator extends SvelteComponent{constructor(e){super(),init(this,e,instance$n,create_fragment$n,safe_not_equal,{rotation:13,valueMin:0,valueMax:1,oninputstart:2,oninputmove:3,oninputend:4,elasticity:5,labelReset:6,rotationMin:14,rotationMax:15})}}function create_fragment$m(e){let t,o,r,n,i;return{c(){t=element("div"),o=element("p"),r=text(e[0]),n=text(" × "),i=text(e[1]),attr(t,"class","PinturaImageInfo")},m(e,a){insert(e,t,a),append(t,o),append(o,r),append(o,n),append(o,i)},p(e,[t]){1&t&&set_data(r,e[0]),2&t&&set_data(i,e[1])},i:noop,o:noop,d(e){e&&detach(t)}}}function instance$m(e,t,o){let{width:r}=t,{height:n}=t;return e.$$set=e=>{"width"in e&&o(0,r=e.width),"height"in e&&o(1,n=e.height)},[r,n]}class ImageInfo extends SvelteComponent{constructor(e){super(),init(this,e,instance$m,create_fragment$m,safe_not_equal,{width:0,height:1})}}var getSelectionPresetOptionIcon=(e,t={})=>{const{width:o=24,height:r=24,bounds:n=16,radius:i=3}=t;let a,s,l,c,u=isArray(e)?getAspectRatio(e[0],e[1]):e,p=!!u;u=p?u:1,l=u>1?n:u*n,c=l/u,a=Math.round(.5*(o-l)),s=Math.round(.5*(r-c));return`<rect fill="${p?"currentColor":"none"}" stroke="${p?"none":"currentColor"}" stroke-width="${o/16}" stroke-dasharray="${[o/12,o/6].join(" ")}" x="${a}" y="${s}" width="${l}" height="${c}" rx="${i}"/>`};function create_controls_slot(e){let t,o;return t=new RadioGroup({props:{class:"PinturaPresetListFilter",layout:"row",options:e[8],selectedIndex:e[7],onchange:e[10]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};256&o&&(r.options=e[8]),128&o&&(r.selectedIndex=e[7]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_fragment$l(e){let t,o;return t=new Dropdown({props:{icon:e[0],label:e[1],labelClass:e[2],hideLabel:e[3],options:e[9],selectedIndex:e[4],onchange:e[5],optionMapper:e[6],$$slots:{controls:[create_controls_slot]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,[o]){const r={};1&o&&(r.icon=e[0]),2&o&&(r.label=e[1]),4&o&&(r.labelClass=e[2]),8&o&&(r.hideLabel=e[3]),512&o&&(r.options=e[9]),16&o&&(r.selectedIndex=e[4]),32&o&&(r.onchange=e[5]),64&o&&(r.optionMapper=e[6]),262528&o&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}const style='fill="none" stroke="currentColor"';function instance$l(e,t,o){let r,n,i,{icon:a}=t,{label:s}=t,{labelClass:l}=t,{hideLabel:c}=t,{options:u}=t,{selectedIndex:p}=t,{onchange:d}=t,{optionMapper:h}=t,{filter:m="landscape"}=t,{onfilterchange:g=noop$1}=t;const f=(e,t,o,r,n)=>`\n    <rect ${style} x="${e}" y="${t}" width="${o}" height="${r}" rx="${n}"/>`,$=(e,t)=>`<path ${style} d="M${e} ${t} l2 2 l3 -4"/>`;return e.$$set=e=>{"icon"in e&&o(0,a=e.icon),"label"in e&&o(1,s=e.label),"labelClass"in e&&o(2,l=e.labelClass),"hideLabel"in e&&o(3,c=e.hideLabel),"options"in e&&o(12,u=e.options),"selectedIndex"in e&&o(4,p=e.selectedIndex),"onchange"in e&&o(5,d=e.onchange),"optionMapper"in e&&o(6,h=e.optionMapper),"filter"in e&&o(11,m=e.filter),"onfilterchange"in e&&o(13,g=e.onfilterchange)},e.$$.update=()=>{6144&e.$$.dirty&&o(9,r=((e,t)=>(e||[]).map((e=>isString(e[0])?(e[1]=e[1].map(t),e):t(e))))(u,(e=>t=>{const[o,r,n={}]=t;return isNumber(o)&&(n.hidden="landscape"===e?o<1:o>1),[o,r,n]})(m))),2048&e.$$.dirty&&o(7,n="landscape"===m?0:1),128&e.$$.dirty&&o(8,i=[["landscape","Landscape",{hideLabel:!0,icon:f(2,6,19,12,2)+(0===n?$(9,12):"")}],["portrait","Portrait",{hideLabel:!0,icon:f(5,3,13,18,2)+(1===n?$(9,12):"")}]])},[a,s,l,c,p,d,h,n,i,r,e=>{o(11,m=e.value),g(e.value)},m,u,g]}class CropPresetList extends SvelteComponent{constructor(e){super(),init(this,e,instance$l,create_fragment$l,safe_not_equal,{icon:0,label:1,labelClass:2,hideLabel:3,options:12,selectedIndex:4,onchange:5,optionMapper:6,filter:11,onfilterchange:13})}}const EDGE_DISTANCE_FACTOR=.9999,PRECISION=6,fixVectorPrecision=e=>vectorApply(e,(e=>fixPrecision(e,6))),rectFixPrecision=e=>rectApply(e,(e=>fixPrecision(e,6))),quadFixPrecision=e=>e.map(fixVectorPrecision),floatEquals=(e,t,o=1e-4)=>Math.abs(e-t)<o;var getRectLimitedToQuad=(e,t,o,r,n={})=>{const{aspectRatio:i}=n;e=rectFixPrecision(e),r=quadFixPrecision(r);const a=rectGetCornerByTarget(e,DirectionInversionTable[o.target]),s=vectorApply(a,(e=>fixPrecision(e,6))),l=i?rectCoverRect(n.minSize,i):n.minSize,c=i?rectContainRect(n.maxSize,i):n.maxSize,u=rectGetCornerByTarget(t,o.target);if(vectorDistance(u,a)<1){t=rectClone$1(e);const o=Math.min(l.width/e.width,l.height/e.height);rectScale$1(t,o,a)}t=rectClamp(rectClone$1(t),l,c,a);let p=rectClone$1(t);t=rectFixPrecision(t);const d=quadToLines(r,1),h=rectGetCorners(e),m=rectGetCorners(t),g=h.findIndex((e=>vectorEqual(vectorApply(e,(e=>fixPrecision(e,6))),s))),f=e=>d.map((t=>lineLineIntersection(t,e))).filter(Boolean).pop();if(i){const t=m.map(((e,t)=>{if(t===g)return;const o=vectorCreate(a.x-e.x,a.y-e.y);vectorNormalize(o),vectorMultiply(o,.5);const r=vectorCreate(a.x-o.x,a.y-o.y),n=lineCreate(r,fixVectorPrecision(e)),i=f(n);if(!i)return;const s=h[t];return{intersection:i,cornerDist:vectorDistance(a,s),intersectionDist:vectorDistance(a,i)}})).filter(Boolean);if(t.length){const o=t.reduce(((e,t)=>{const o=t.intersectionDist/t.cornerDist;return o<e?o:e}),Number.MAX_SAFE_INTEGER);p=rectClone$1(e),rectScale$1(p,o,a)}}else{const e=1===o.target.length,n=!(r[0].y===r[1].y||r[0].x===r[1].x),i=h.map(((t,o)=>{if(o===g)return;const r=m[o],i=!floatEquals(r.x,s.x)&&!floatEquals(r.y,s.y);if(!e&&!n&&i)return;if(e&&(floatEquals(r.x,s.x)||floatEquals(r.y,s.y)))return;const l=vectorClone(e?t:a),c=vectorSubtract(vectorClone(l),r);vectorNormalize(c),vectorMultiply(c,.5),e?vectorAdd(l,c):vectorSubtract(l,c);const u=lineCreate(l,r),p=f(u);return p||void 0})).filter(Boolean);if(i.length){const[e,r,n,l]=getTranslationInfo(o.target);let[c,u,d,h]=rectToBounds(t);i.forEach((({x:t,y:o})=>{const i=fixPrecision(t,6),a=fixPrecision(o,6);n&&!floatEquals(a,s.y)&&(c=Math.max(c,o)),e&&!floatEquals(i,s.x)&&(u=Math.min(u,t)),l&&!floatEquals(a,s.y)&&(d=Math.min(d,o)),r&&!floatEquals(i,s.x)&&(h=Math.max(h,t))})),p=rectCreateFromBounds([c,u,d,h]),rectScale$1(p,.9999,a)}}return rectClamp(p,l,c,a),p};function create_default_slot_2$3(e){let t,o;return t=new DynamicComponentTree_1({props:{items:e[11]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};2048&o[0]&&(r.items=e[11]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_header_slot$1(e){let t,o,r;return o=new Toolbar({props:{$$slots:{default:[create_default_slot_2$3]},$$scope:{ctx:e}}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"slot","header")},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,t){const r={};2048&t[0]|64&t[7]&&(r.$$scope={dirty:t,ctx:e}),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function create_if_block_5$2(e){let t,o;return t=new Button({props:{onclick:e[88],label:e[4].cropLabelButtonRecenter,icon:e[4].cropIconButtonRecenter,disabled:!e[9],hideLabel:!0,class:"PinturaButtonCenter",style:`opacity:${e[29]};transform:translate3d(${e[30].x}px, ${e[30].y}px,0)`}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16&o[0]&&(r.label=e[4].cropLabelButtonRecenter),16&o[0]&&(r.icon=e[4].cropIconButtonRecenter),512&o[0]&&(r.disabled=!e[9]),1610612736&o[0]&&(r.style=`opacity:${e[29]};transform:translate3d(${e[30].x}px, ${e[30].y}px,0)`),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_4$3(e){let t,o;return t=new RectManipulator({props:{rect:e[8],visible:e[12],cornerStyle:e[1]}}),t.$on("resizestart",e[68]),t.$on("resizemove",e[69]),t.$on("resizeend",e[70]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};256&o[0]&&(r.rect=e[8]),4096&o[0]&&(r.visible=e[12]),2&o[0]&&(r.cornerStyle=e[1]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_3$3(e){let t,o;return t=new ImageInfo({props:{width:Math.round(e[13].width),height:Math.round(e[13].height)}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};8192&o[0]&&(r.width=Math.round(e[13].width)),8192&o[0]&&(r.height=Math.round(e[13].height)),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_main_slot$1(e){let t,o,r,n,i,a,s,l,c=e[21]&&e[10]&&create_if_block_5$2(e),u=e[21]&&create_if_block_4$3(e),p=e[22]&&create_if_block_3$3(e);return{c(){t=element("div"),o=element("div"),c&&c.c(),r=space(),u&&u.c(),i=space(),p&&p.c(),attr(o,"class","PinturaStage"),attr(t,"slot","main")},m(d,h){insert(d,t,h),append(t,o),c&&c.m(o,null),append(o,r),u&&u.m(o,null),e[164](o),append(t,i),p&&p.m(t,null),a=!0,s||(l=[action_destroyer(measurable.call(null,o)),listen(o,"measure",e[162]),listen(o,"wheel",(function(){is_function(e[2]&&e[87])&&(e[2]&&e[87]).apply(this,arguments)}),{passive:!1}),listen(o,"interactionstart",e[74]),listen(o,"interactionupdate",e[75]),listen(o,"interactionrelease",e[77]),listen(o,"interactionend",e[76]),action_destroyer(n=interactable.call(null,o,{drag:!0,inertia:!0,pinch:e[2],shouldStartInteraction:interactable_function$1,getEventPosition:e[165]})),listen(o,"gesturedown",e[84]),listen(o,"gestureupdate",e[85]),listen(o,"gestureup",e[86]),action_destroyer(gesturable.call(null,o))],s=!0)},p(i,a){(e=i)[21]&&e[10]?c?(c.p(e,a),2098176&a[0]&&transition_in(c,1)):(c=create_if_block_5$2(e),c.c(),transition_in(c,1),c.m(o,r)):c&&(group_outros(),transition_out(c,1,1,(()=>{c=null})),check_outros()),e[21]?u?(u.p(e,a),2097152&a[0]&&transition_in(u,1)):(u=create_if_block_4$3(e),u.c(),transition_in(u,1),u.m(o,null)):u&&(group_outros(),transition_out(u,1,1,(()=>{u=null})),check_outros()),n&&is_function(n.update)&&16777220&a[0]&&n.update.call(null,{drag:!0,inertia:!0,pinch:e[2],shouldStartInteraction:interactable_function$1,getEventPosition:e[165]}),e[22]?p?(p.p(e,a),4194304&a[0]&&transition_in(p,1)):(p=create_if_block_3$3(e),p.c(),transition_in(p,1),p.m(t,null)):p&&(group_outros(),transition_out(p,1,1,(()=>{p=null})),check_outros())},i(e){a||(transition_in(c),transition_in(u),transition_in(p),a=!0)},o(e){transition_out(c),transition_out(u),transition_out(p),a=!1},d(o){o&&detach(t),c&&c.d(),u&&u.d(),e[164](null),p&&p.d(),s=!1,run_all(l)}}}function create_if_block$9(e){let t,o,r,n;const i=[{class:"PinturaControlList"},{tabs:e[7]},e[18]];let a={$$slots:{default:[create_default_slot_1$3,({tab:e})=>({222:e}),({tab:e})=>[0,0,0,0,0,0,0,e?32:0]]},$$scope:{ctx:e}};for(let e=0;e<i.length;e+=1)a=assign(a,i[e]);t=new TabList({props:a}),t.$on("select",e[163]);const s=[{class:"PinturaControlPanels"},{panelClass:"PinturaControlPanel"},{panels:e[17]},e[18]];let l={$$slots:{default:[create_default_slot$a,({panel:e})=>({221:e}),({panel:e})=>[0,0,0,0,0,0,0,e?16:0]]},$$scope:{ctx:e}};for(let e=0;e<s.length;e+=1)l=assign(l,s[e]);return r=new TabPanels({props:l}),{c(){create_component(t.$$.fragment),o=space(),create_component(r.$$.fragment)},m(e,i){mount_component(t,e,i),insert(e,o,i),mount_component(r,e,i),n=!0},p(e,o){const n=262272&o[0]?get_spread_update(i,[i[0],128&o[0]&&{tabs:e[7]},262144&o[0]&&get_spread_object(e[18])]):{};96&o[7]&&(n.$$scope={dirty:o,ctx:e}),t.$set(n);const a=393216&o[0]?get_spread_update(s,[s[0],s[1],131072&o[0]&&{panels:e[17]},262144&o[0]&&get_spread_object(e[18])]):{};511721496&o[0]|80&o[7]&&(a.$$scope={dirty:o,ctx:e}),r.$set(a)},i(e){n||(transition_in(t.$$.fragment,e),transition_in(r.$$.fragment,e),n=!0)},o(e){transition_out(t.$$.fragment,e),transition_out(r.$$.fragment,e),n=!1},d(e){destroy_component(t,e),e&&detach(o),destroy_component(r,e)}}}function create_default_slot_1$3(e){let t,o,r=e[222].label+"";return{c(){t=element("span"),o=text(r)},m(e,r){insert(e,t,r),append(t,o)},p(e,t){32&t[7]&&r!==(r=e[222].label+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_if_block_2$4(e){let t,o;return t=new RangeInput({props:{elasticity:e[25]*e[44],base:imageZoomLevelBase,min:e[23],max:imageZoomLevelMax,valueMin:e[27][0],valueMax:e[27][1],value:e[28],labelReset:e[4].labelReset,valueLabel:`${Math.round(100*e[28])}%`,oninputstart:e[81],oninputmove:e[82],oninputend:e[83]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};33554432&o[0]&&(r.elasticity=e[25]*e[44]),8388608&o[0]&&(r.min=e[23]),134217728&o[0]&&(r.valueMin=e[27][0]),134217728&o[0]&&(r.valueMax=e[27][1]),268435456&o[0]&&(r.value=e[28]),16&o[0]&&(r.labelReset=e[4].labelReset),268435456&o[0]&&(r.valueLabel=`${Math.round(100*e[28])}%`),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_1$5(e){let t,o;return t=new ImageRotator({props:{elasticity:e[25]*e[44],rotation:e[14],labelReset:e[4].labelReset,valueMin:e[26][0],valueMax:e[26][1],rotationMin:-e[3],rotationMax:e[3],oninputstart:e[71],oninputmove:e[72],oninputend:e[73]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};33554432&o[0]&&(r.elasticity=e[25]*e[44]),16384&o[0]&&(r.rotation=e[14]),16&o[0]&&(r.labelReset=e[4].labelReset),67108864&o[0]&&(r.valueMin=e[26][0]),67108864&o[0]&&(r.valueMax=e[26][1]),8&o[0]&&(r.rotationMin=-e[3]),8&o[0]&&(r.rotationMax=e[3]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot$a(e){let t,o,r,n;const i=[create_if_block_1$5,create_if_block_2$4],a=[];function s(e,t){return e[221]===e[93]+"-rotation"?0:e[221]===e[93]+"-zoom"?1:-1}return~(t=s(e))&&(o=a[t]=i[t](e)),{c(){o&&o.c(),r=empty()},m(e,o){~t&&a[t].m(e,o),insert(e,r,o),n=!0},p(e,n){let l=t;t=s(e),t===l?~t&&a[t].p(e,n):(o&&(group_outros(),transition_out(a[l],1,1,(()=>{a[l]=null})),check_outros()),~t?(o=a[t],o?o.p(e,n):(o=a[t]=i[t](e),o.c()),transition_in(o,1),o.m(r.parentNode,r)):o=null)},i(e){n||(transition_in(o),n=!0)},o(e){transition_out(o),n=!1},d(e){~t&&a[t].d(e),e&&detach(r)}}}function create_footer_slot$6(e){let t,o,r=e[19]&&create_if_block$9(e);return{c(){t=element("div"),r&&r.c(),attr(t,"slot","footer"),set_style(t,"transform",e[16])},m(e,n){insert(e,t,n),r&&r.m(t,null),o=!0},p(e,o){e[19]?r?(r.p(e,o),524288&o[0]&&transition_in(r,1)):(r=create_if_block$9(e),r.c(),transition_in(r,1),r.m(t,null)):r&&(group_outros(),transition_out(r,1,1,(()=>{r=null})),check_outros()),65536&o[0]&&set_style(t,"transform",e[16])},i(e){o||(transition_in(r),o=!0)},o(e){transition_out(r),o=!1},d(e){e&&detach(t),r&&r.d()}}}function create_fragment$k(e){let t,o,r;function n(t){e[166](t)}let i={hasHeader:e[20],$$slots:{footer:[create_footer_slot$6],main:[create_main_slot$1],header:[create_header_slot$1]},$$scope:{ctx:e}};return void 0!==e[15]&&(i.root=e[15]),t=new Util({props:i}),binding_callbacks.push((()=>bind(t,"root",n))),t.$on("measure",e[167]),{c(){create_component(t.$$.fragment)},m(e,o){mount_component(t,e,o),r=!0},p(e,r){const n={};1048576&r[0]&&(n.hasHeader=e[20]),2146402302&r[0]|64&r[7]&&(n.$$scope={dirty:r,ctx:e}),!o&&32768&r[0]&&(o=!0,n.root=e[15],add_flush_callback((()=>o=!1))),t.$set(n)},i(e){r||(transition_in(t.$$.fragment,e),r=!0)},o(e){transition_out(t.$$.fragment,e),r=!1},d(e){destroy_component(t,e)}}}const imageZoomLevelMax=1,imageZoomLevelBase=0,interactable_function$1=(e,t)=>e.target===t;function instance$k(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,S,C,w,T,k,R,P,I,E,M,A,F,L,D,z,O,B,N,V,W,U,H,G,j,q,X,Y,Z,K,J,Q,ee,te,oe,re,ne,ie,ae,se,le,ce,ue,pe,de,he,me,ge,fe,$e,be,ye,_e,xe=noop,ve=()=>(xe(),xe=subscribe(Se,(e=>o(12,E=e))),Se);e.$$.on_destroy.push((()=>xe()));let{isActive:Se}=t;ve();let{stores:Ce}=t,{cropImageSelectionCornerStyle:we="circle"}=t,{cropWillRenderImageSelectionGuides:Te=(e,t)=>{const o="rotate"==e;return{rows:o?5:3,cols:o?5:3,opacity:.25*t}}}=t,{cropAutoCenterImageSelectionTimeout:ke}=t,{cropEnableZoomMatchImageAspectRatio:Re=!0}=t,{cropEnableRotateMatchImageAspectRatio:Pe="never"}=t,{cropEnableRotationInput:Ie=!0}=t,{cropEnableZoom:Ee=!0}=t,{cropEnableZoomInput:Me=!0}=t,{cropEnableZoomAutoHide:Ae=!0}=t,{cropEnableImageSelection:Fe=!0}=t,{cropEnableInfoIndicator:Le=!1}=t,{cropEnableZoomTowardsWheelPosition:De=!0}=t,{cropEnableLimitWheelInputToCropSelection:ze=!0}=t,{cropEnableCenterImageSelection:Oe=!0}=t,{cropEnableButtonRotateLeft:Be=!0}=t,{cropEnableButtonRotateRight:Ne=!1}=t,{cropEnableButtonFlipHorizontal:Ve=!0}=t,{cropEnableButtonFlipVertical:We=!1}=t,{cropSelectPresetOptions:Ue}=t,{cropEnableSelectPreset:He=!0}=t,{cropEnableFilterMatchAspectRatio:Ge=!0}=t,{cropSelectPresetFilter:je=!1}=t,{cropEnableButtonToggleCropLimit:qe=!1}=t,{cropWillRenderTools:Xe=passthrough}=t,{cropActiveTransformTool:Ye="rotation"}=t,{cropMinimizeToolbar:Ze="auto"}=t,{cropInteractionFocus:Ke="image"}=t,{cropRotationRange:Je=QUART_PI}=t,{cropMaskOpacity:Qe=.85}=t,{locale:et={}}=t,{cropFormatIconSelectPreset:tt=function(e){const{aspectRatio:t}=e,[o,r,n]=t?[t<1?1:.3,1===t?.85:.5,t>1?1:.3]:[.2,.3,.4];return{a:o,b:r,c:n}}}=t,{cropFormatIconCropBoundary:ot=function(e){const{isBoundToImage:t}=e,[o,r,n,i]=t?[.3,1,0,0]:[0,0,.3,1];return{a:o,b:r,c:n,d:i}}}=t;const rt=getContext("isAnimated");component_subscribe(e,rt,(e=>o(141,M=e)));const nt=getContext("elasticityMultiplier");component_subscribe(e,nt,(e=>o(25,ge=e)));const it=getContext("redrawTrigger");component_subscribe(e,it,(e=>o(161,me=e)));const at=getContext("imageIsStatic");component_subscribe(e,at,(e=>o(147,B=e)));const st=getContext("imageStaticVisualCorners");component_subscribe(e,st,(e=>o(183,ae=e)));const lt=getContext("fixScrollDirection");component_subscribe(e,lt,(e=>o(177,Q=e)));let ct="idle";const ut=writable();component_subscribe(e,ut,(e=>o(158,pe=e)));const pt=()=>void 0===ne,dt=e=>1/e,ht=e=>{Ge&&je!==e&&(o(95,je=e),ne&&1!==ne&&mt()&&set_store_value(Kt,ne=dt(ne),ne))},mt=()=>{if(1===ne||!r)return!1;const e=dt(ne);return!!flattenOptions(pe).find((([t])=>t===e))},gt=(e,t,o)=>isRotatedSideways(o)?t.width===Math.round(e.height)||t.height===Math.round(e.width):t.width===Math.round(e.width)||t.height===Math.round(e.height),ft=()=>(pt()||"always"===Pe&&mt())&&((e,t,o)=>{const r=sizeApply(sizeRotate(sizeClone(t),o),(e=>Math.abs(Math.round(e)))),n=sizeCenter(r),i=rectCenter(e);return vectorEqual(n,i)})(N,Y,Z)&&gt(N,Y,Z),$t=e=>{if("never"!==Pe&&ft()){set_store_value(Ot,Z+=e,Z);const t=isRotatedSideways(Z),o=t?Y.height:Y.width,r=t?Y.width:Y.height;set_store_value(qt,N=rectCreate(0,0,o,r),N),pt()||set_store_value(Kt,ne=getAspectRatio(o,r),ne)}else set_store_value(Ot,Z+=e,Z)},{history:bt,env:yt,isInteracting:_t,isInteractingFraction:xt,isTransformingImage:vt,rootRect:St,stageRect:Ct,utilRect:wt,utilRectPadded:Tt,rootLineColor:kt,allowPan:Rt,allowZoom:Pt,allowPlayPause:It,rangeInputElasticity:Et,presentationScalar:Mt,utilTools:At,imagePreviewModifiers:Ft,imageOutlineOpacity:Lt,imageFlipX:Dt,imageFlipY:zt,imageRotation:Ot,imageRotationRange:Bt,imageOutputSize:Nt,imageSelectionRect:Vt,imageSelectionRectSnapshot:Wt,imageSelectionRectIntent:Ut,imageSelectionRectPresentation:Ht,imageCropRectIntent:Gt,imageCropRectOrigin:jt,imageCropRect:qt,imageCropMinSize:Xt,imageCropMaxSize:Yt,imageCropRange:Zt,imageCropAspectRatio:Kt,imageCropLimitToImage:Jt,imageSize:Qt,imageScalar:eo,imageOverlayMarkup:to,stagePadded:oo,stageRecenter:ro}=Ce;function no(e,t){return isFunction(e.cropIconSelectPreset)?localize(e.cropIconSelectPreset,e,t):stringReplace(e.cropIconSelectPreset,tt({aspectRatio:t}),"{","}")}function io(e,t){return isFunction(e.cropIconCropBoundary)?localize(e.cropIconCropBoundary,e,t):stringReplace(e.cropIconCropBoundary,ot({isBoundToImage:t}),"{","}")}let ao;component_subscribe(e,yt,(e=>o(142,A=e))),component_subscribe(e,_t,(e=>o(146,O=e))),component_subscribe(e,vt,(e=>o(175,q=e))),component_subscribe(e,St,(e=>o(24,ee=e))),component_subscribe(e,Ct,(e=>o(153,j=e))),component_subscribe(e,Tt,(e=>o(150,U=e))),component_subscribe(e,Mt,(e=>o(149,W=e))),component_subscribe(e,At,(e=>o(185,le=e))),component_subscribe(e,Ft,(e=>o(174,D=e))),component_subscribe(e,Dt,(e=>o(160,he=e))),component_subscribe(e,zt,(e=>o(159,de=e))),component_subscribe(e,Ot,(e=>o(14,Z=e))),component_subscribe(e,Bt,(e=>o(26,fe=e))),component_subscribe(e,Nt,(e=>o(186,ce=e))),component_subscribe(e,Vt,(e=>o(152,G=e))),component_subscribe(e,Wt,(e=>o(151,H=e))),component_subscribe(e,Ut,(e=>o(184,se=e))),component_subscribe(e,Ht,(e=>o(145,z=e))),component_subscribe(e,Gt,(e=>o(178,te=e))),component_subscribe(e,jt,(e=>o(180,re=e))),component_subscribe(e,qt,(e=>o(13,N=e))),component_subscribe(e,Xt,(e=>o(156,J=e))),component_subscribe(e,Yt,(e=>o(182,ie=e))),component_subscribe(e,Zt,(e=>o(179,oe=e))),component_subscribe(e,Kt,(e=>o(181,ne=e))),component_subscribe(e,Jt,(e=>o(155,K=e))),component_subscribe(e,Qt,(e=>o(154,Y=e))),component_subscribe(e,eo,(e=>o(148,V=e))),component_subscribe(e,oo,(e=>o(144,L=e)));const so=(e,t)=>{const o={target:e,translate:t},r=sizeScale(sizeClone(J),W),n=sizeScale(sizeClone(ie),W);let i=limitRectDirectionTranslation(H,o,{...U,x:0,y:0},{aspectRatio:ne,minSize:r,maxSize:n});if(i=rectLimitInRect(i,{...U,x:0,y:0},ne),!K)return{boundsLimited:i,boundsIntent:i};let a=getRectLimitedToQuad(H,i,o,ae,{aspectRatio:ne,minSize:r,maxSize:n});return{boundsLimited:a,boundsIntent:a}},lo=(e,t)=>{const o={target:e,translate:t},r=sizeScale(sizeClone(J),W),n=sizeScale(sizeClone(ie),W),i=applyRectDirectionTranslation(H,o,{aspectRatio:ne,minSize:r});return{boundsLimited:limitRectDirectionTranslation(H,o,{...U,x:0,y:0},{aspectRatio:ne,minSize:r,maxSize:n}),boundsIntent:i}};let co,uo;const po=({translation:e,scalar:t})=>{B&&(t=1,e=vectorInvert(vectorClone(e)));const o=Math.min(G.width/N.width,G.height/N.height),r=vectorMultiply(vectorClone(e),1/o);let n;if(uo){const t=vectorSubtract(vectorClone(uo),e);uo=e,n=rectTranslate$1(rectClone$1(N),t)}else n=rectTranslate$1(rectClone$1(co),vectorInvert(vectorClone(r))),void 0!==t&&rectScale$1(n,1/t);set_store_value(Gt,te=n,te),set_store_value(qt,N=n,N)},ho=derived([Zt,qt],(([e,t],o)=>{if(!t)return;const[r,n]=e,i=rectAspectRatio(t);o([sizeCreateFromRect(rectApply(rectCoverRect(r,i),fixPrecision)),sizeCreateFromRect(rectApply(rectContainRect(n,i),fixPrecision))])}));component_subscribe(e,ho,(e=>o(176,X=e)));const mo=derived([Qt,Jt,Xt,Yt,Zt,Ot],(([e,t,o,r,n,i],a)=>{if(!e)return;const s=n[0],l=n[1];let c,u;t?(c=((e,t,o)=>isRotatedSideways(o)?1-1/Math.min(e.height/t.width,e.width/t.height):1-1/Math.min(e.width/t.width,e.height/t.height))(e,l,i),u=Math.min(s.width/o.width,s.height/o.height)):(c=-1,u=1);a([c,u].map((e=>fixPrecision(e))))}));component_subscribe(e,mo,(e=>o(27,$e=e)));const go=derived([Qt,qt,Zt,Ot],(([e,t,o,r],n)=>{if(!e||!t)return n(0);let i;const a=o[0],s=o[1],l=t.width,c=t.height,u=rectAspectRatio(t),p=isRotatedSideways(r)?sizeCreate(e.height,e.width):e,d=rectContainRect(p,u);if(l<=d.width||c<=d.height){const e=d.width-a.width,t=d.height-a.height;i=0===e||0===t?1:1-Math.min((l-a.width)/e,(c-a.height)/t)}else{const e=s.width-d.width,t=s.height-d.height,o=rectContainRect({width:e,height:t},u);i=-Math.min((l-d.width)/o.width,(c-d.height)/o.height)}n(i)}));component_subscribe(e,go,(e=>o(28,be=e)));const fo=e=>{const t=rectAspectRatio(co);let o,r,n;const i=isRotatedSideways(Z)?sizeCreate(Y.height,Y.width):Y,a=rectContainRect(i,t);if(e>=0){const i=a.width-oe[0].width,s=a.height-oe[0].height;o=a.width-i*e,r=a.height-s*e,n=rectCoverRect({width:o,height:r},t)}else{const i=oe[1].width-a.width,s=oe[1].height-a.height;o=a.width+i*-e,r=a.height+s*-e,n=rectContainRect({width:o,height:r},t)}o=n.width,r=n.height;const s=co.x+.5*co.width-.5*o,l=co.y+.5*co.height-.5*r;set_store_value(qt,N={x:s,y:l,width:o,height:r},N)};let $o;const bo=e=>{const t=rectScale$1(rectClone$1($o),1/e);set_store_value(Gt,te=t,te),set_store_value(qt,N=t,N)};let yo;const _o=()=>{ro.set({})};let xo;const vo=spring(0,{precision:1e-4});component_subscribe(e,vo,(e=>o(29,ye=e)));const So=spring();component_subscribe(e,So,(e=>o(30,_e=e)));const Co=derived([Kt,Nt,ut],(([e,t,o],n)=>{if(!r)return;const i=flattenOptions(o),a=[...i].map((e=>e[0])).sort(((e,t)=>isArray(e[0])&&!isArray(t[0])?1:-1)).find((o=>{if(isArray(o)&&t){const[r,n]=o,i=t.width===r&&t.height===n,a=e===getAspectRatio(r,n);return i&&a}return o===e}));if(!a)return n(void 0);n(i.map((e=>e[0])).findIndex((e=>isArray(e)?arrayEqual(e,a):e===a)))}));component_subscribe(e,Co,(e=>o(157,ue=e)));const wo=(e,t)=>{if(!r||-1===e||void 0===e)return;const o=flattenOptions(t)[e][0];return o?isArray(o)?getAspectRatio(o[0],o[1]):o:void 0},To=derived([kt,Ht,xt],(([e,t,o],r)=>{const{rows:n,cols:i,opacity:a}=Te(ct,o);if(!t||a<=0)return r([]);const{x:s,y:l,width:c,height:u}=t,p=c/i,d=u/n,h=[];for(let t=1;t<=n-1;t++){const o=l+d*t;h.push({id:`image-selection-guide-row-${t}`,points:[vectorCreate(s,o),vectorCreate(s+c,o)],opacity:a,strokeWidth:1,strokeColor:e})}for(let t=1;t<=i-1;t++){const o=s+p*t;h.push({id:`image-selection-guide-col-${t}`,points:[vectorCreate(o,l),vectorCreate(o,l+u)],opacity:a,strokeWidth:1,strokeColor:e})}r(h)}));component_subscribe(e,To,(e=>o(143,F=e)));const ko=`crop-${getUniqueId()}`;let Ro,Po,Io=ko+"-"+(Ie?Ye:"zoom"),Eo=Io;const Mo=spring(M?20:0);component_subscribe(e,Mo,(e=>o(140,I=e)));return e.$$set=e=>{"isActive"in e&&ve(o(0,Se=e.isActive)),"stores"in e&&o(97,Ce=e.stores),"cropImageSelectionCornerStyle"in e&&o(1,we=e.cropImageSelectionCornerStyle),"cropWillRenderImageSelectionGuides"in e&&o(98,Te=e.cropWillRenderImageSelectionGuides),"cropAutoCenterImageSelectionTimeout"in e&&o(99,ke=e.cropAutoCenterImageSelectionTimeout),"cropEnableZoomMatchImageAspectRatio"in e&&o(100,Re=e.cropEnableZoomMatchImageAspectRatio),"cropEnableRotateMatchImageAspectRatio"in e&&o(101,Pe=e.cropEnableRotateMatchImageAspectRatio),"cropEnableRotationInput"in e&&o(102,Ie=e.cropEnableRotationInput),"cropEnableZoom"in e&&o(2,Ee=e.cropEnableZoom),"cropEnableZoomInput"in e&&o(103,Me=e.cropEnableZoomInput),"cropEnableZoomAutoHide"in e&&o(104,Ae=e.cropEnableZoomAutoHide),"cropEnableImageSelection"in e&&o(105,Fe=e.cropEnableImageSelection),"cropEnableInfoIndicator"in e&&o(106,Le=e.cropEnableInfoIndicator),"cropEnableZoomTowardsWheelPosition"in e&&o(107,De=e.cropEnableZoomTowardsWheelPosition),"cropEnableLimitWheelInputToCropSelection"in e&&o(108,ze=e.cropEnableLimitWheelInputToCropSelection),"cropEnableCenterImageSelection"in e&&o(109,Oe=e.cropEnableCenterImageSelection),"cropEnableButtonRotateLeft"in e&&o(110,Be=e.cropEnableButtonRotateLeft),"cropEnableButtonRotateRight"in e&&o(111,Ne=e.cropEnableButtonRotateRight),"cropEnableButtonFlipHorizontal"in e&&o(112,Ve=e.cropEnableButtonFlipHorizontal),"cropEnableButtonFlipVertical"in e&&o(113,We=e.cropEnableButtonFlipVertical),"cropSelectPresetOptions"in e&&o(114,Ue=e.cropSelectPresetOptions),"cropEnableSelectPreset"in e&&o(115,He=e.cropEnableSelectPreset),"cropEnableFilterMatchAspectRatio"in e&&o(116,Ge=e.cropEnableFilterMatchAspectRatio),"cropSelectPresetFilter"in e&&o(95,je=e.cropSelectPresetFilter),"cropEnableButtonToggleCropLimit"in e&&o(117,qe=e.cropEnableButtonToggleCropLimit),"cropWillRenderTools"in e&&o(118,Xe=e.cropWillRenderTools),"cropActiveTransformTool"in e&&o(119,Ye=e.cropActiveTransformTool),"cropMinimizeToolbar"in e&&o(120,Ze=e.cropMinimizeToolbar),"cropInteractionFocus"in e&&o(121,Ke=e.cropInteractionFocus),"cropRotationRange"in e&&o(3,Je=e.cropRotationRange),"cropMaskOpacity"in e&&o(122,Qe=e.cropMaskOpacity),"locale"in e&&o(4,et=e.locale),"cropFormatIconSelectPreset"in e&&o(123,tt=e.cropFormatIconSelectPreset),"cropFormatIconCropBoundary"in e&&o(124,ot=e.cropFormatIconCropBoundary)},e.$$.update=()=>{4096&e.$$.dirty[0]|268435456&e.$$.dirty[3]&&at.set("selection"===Ke&&E),2097152&e.$$.dirty[3]&&o(131,r=Ue&&Array.isArray(Ue)&&Ue.length),2097152&e.$$.dirty[3]|128&e.$$.dirty[4]&&ut.set(r?Ue:[]),4096&e.$$.dirty[0]|131072&e.$$.dirty[4]&&E&&Lt.set(1,{hard:!M}),4096&e.$$.dirty[0]&&Rt.set(!E),4096&e.$$.dirty[0]&&Pt.set(!E),4096&e.$$.dirty[0]&&E&&It.set(!0),262144&e.$$.dirty[4]&&o(126,h="overlay"===A.layoutMode),4194304&e.$$.dirty[3]|4&e.$$.dirty[4]&&o(130,x=He&&!h),335544320&e.$$.dirty[4]&&o(139,l=U&&G&&rectCenterRect(U,G)),268468224&e.$$.dirty[4]&&o(137,c=!(!G||!l)),268476416&e.$$.dirty[4]&&o(135,u=c&&rectEqual(G,l,(e=>fixPrecision(e,5)))),16400&e.$$.dirty[0]|52297732&e.$$.dirty[3]|1074006208&e.$$.dirty[4]|127&e.$$.dirty[5]&&o(11,n=me&&Xe([Be&&["Button","rotate-left",{label:et.cropLabelButtonRotateLeft,labelClass:"PinturaToolbarContentWide",icon:et.cropIconButtonRotateLeft,onclick:()=>{$t(-Math.PI/2),bt.write()}}],Ne&&["Button","rotate-right",{label:et.cropLabelButtonRotateRight,labelClass:"PinturaToolbarContentWide",icon:et.cropIconButtonRotateRight,onclick:()=>{$t(Math.PI/2),bt.write()}}],Ve&&["Button","flip-horizontal",{label:et.cropLabelButtonFlipHorizontal,labelClass:"PinturaToolbarContentWide",icon:et.cropIconButtonFlipHorizontal,onclick:()=>{isRotatedSideways(Z)?set_store_value(zt,de=!de,de):set_store_value(Dt,he=!he,he),bt.write()}}],We&&["Button","flip-vertical",{label:et.cropLabelButtonFlipVertical,labelClass:"PinturaToolbarContentWide",icon:et.cropIconButtonFlipVertical,onclick:()=>{isRotatedSideways(Z)?set_store_value(Dt,he=!he,he):set_store_value(zt,de=!de,de),bt.write()}}],x&&r&&[!1===je?"Dropdown":CropPresetList,"select-preset",{icon:no(et,wo(ue,pe)),label:localize(et.cropLabelSelectPreset,et,wo(ue,pe)),labelClass:"PinturaToolbarContentWide",options:pe,filter:je,onfilterchange:ht,selectedIndex:ue,onchange:({value:e})=>{isArray(e)?(set_store_value(Kt,ne=getAspectRatio(e[0],e[1]),ne),set_store_value(Nt,ce=sizeCreateFromArray(e),ce)):set_store_value(Kt,ne=e,ne),u&&_o(),bt.write()},optionMapper:e=>{let t=!1;const o=isArray(e.value)?e.value[0]/e.value[1]:e.value;if(o){const e=getMaxSizeInRect(Y,Z,o);t=e.width<J.width||e.height<J.height}return e.icon=getSelectionPresetOptionIcon(e.value,{bounds:14}),{...e,disabled:t}}}],qe&&["Dropdown","select-crop-limit",{icon:io(et,K),label:et.cropLabelCropBoundary,labelClass:"PinturaToolbarContentWide",onchange:({value:e})=>{set_store_value(Jt,K=e,K),bt.write()},options:[[!0,et.cropLabelCropBoundaryEdge,{icon:io(et,!0)}],[!1,et.cropLabelCropBoundaryNone,{icon:io(et,!1)}]]}]].filter(Boolean),A,(()=>it.set({}))).filter(Boolean)),6144&e.$$.dirty[0]|134217728&e.$$.dirty[3]|262148&e.$$.dirty[4]&&set_store_value(At,le=E&&"never"!==Ze&&("always"===Ze||"short"===A.verticalSpace||h)?n.map((([e,t,o])=>Array.isArray(o)?[e,t,o]:[e,t,{...o,hideLabel:!0}])):[],le),1&e.$$.dirty[5]&&o(23,i=K?0:-1),603979776&e.$$.dirty[4]&&o(132,a=U&&vectorCreate(-(j.x-U.x),-(j.y-U.y))),2097408&e.$$.dirty[4]&&o(133,s=z&&a&&vectorCreate(snapToPixel(z.x+.5*z.width+a.x),snapToPixel(z.y+.5*z.height+a.y))),134217728&e.$$.dirty[4]&&o(136,p=null!=H),67141632&e.$$.dirty[4]&&o(138,d=U&&l&&(l.height===U.height||l.width===U.width)),50348032&e.$$.dirty[4]&&o(134,m=!d&&W<1&&V<1),15360&e.$$.dirty[4]&&o(9,g=c&&!p&&(!u||m)),8192&e.$$.dirty[0]|8192&e.$$.dirty[3]|4&e.$$.dirty[4]&&o(22,f=Le&&!!N&&!h),2097408&e.$$.dirty[4]&&o(8,y=z&&a&&{x:z.x+a.x,y:z.y+a.y,width:z.width,height:z.height}),256&e.$$.dirty[0]|4096&e.$$.dirty[3]|4&e.$$.dirty[4]&&o(21,$=Fe&&!!y&&!h),65600&e.$$.dirty[3]|8389120&e.$$.dirty[4]&&o(10,b=Oe&&!!s&&!ke&&!B),512&e.$$.dirty[0]|64&e.$$.dirty[3]|4194306&e.$$.dirty[4]&&g&&ke&&!O&&(clearTimeout(xo),o(125,xo=setTimeout(_o,ke))),4194306&e.$$.dirty[4]&&O&&clearTimeout(xo),1536&e.$$.dirty[0]|131072&e.$$.dirty[4]&&vo.set(b&&g?1:0,{hard:!1===M}),131584&e.$$.dirty[4]&&So.set(s,{hard:!1===M}),4096&e.$$.dirty[0]|1048576&e.$$.dirty[4]&&(E&&!L?(set_store_value(Ft,D.crop={maskOpacity:Qe,maskMarkupOpacity:Qe},D),Ft.set(D)):(delete D.crop,Ft.set(D))),524288&e.$$.dirty[4]&&F&&to.update((e=>{const t=e.filter((e=>!/^image\-selection\-guide/.test(e.id)));return E?[...t,...F]:t})),262144&e.$$.dirty[4]&&o(129,_="short"!==A.verticalSpace),134217728&e.$$.dirty[3]|36&e.$$.dirty[4]&&o(20,v="never"===Ze&&!h||_&&"always"!==Ze),4&e.$$.dirty[0]|1024&e.$$.dirty[3]&&o(128,S=Ee&&Me),2048&e.$$.dirty[3]|48&e.$$.dirty[4]&&o(127,C=Ae?_&&S:S),512&e.$$.dirty[3]|8&e.$$.dirty[4]&&o(19,w=Ie||C),8&e.$$.dirty[4]&&(C||o(5,Eo=Io)),32&e.$$.dirty[0]&&o(18,T={name:ko,selected:Eo}),16&e.$$.dirty[0]|512&e.$$.dirty[3]|8&e.$$.dirty[4]&&o(7,k=[Ie&&{id:ko+"-rotation",label:et.cropLabelTabRotation},C&&{id:ko+"-zoom",label:et.cropLabelTabZoom}].filter(Boolean)),128&e.$$.dirty[0]&&o(17,R=k.map((e=>e.id))),64&e.$$.dirty[0]|4&e.$$.dirty[4]&&Po&&!Po.children.length&&h&&Po.dispatchEvent(new CustomEvent("measure",{detail:Po.rect})),4096&e.$$.dirty[0]|131072&e.$$.dirty[4]&&M&&Mo.set(E?0:20),65536&e.$$.dirty[4]&&o(16,P=I?`translateY(${I}px)`:"none")},[Se,we,Ee,Je,et,Eo,Po,k,y,g,b,n,E,N,Z,Ro,P,R,T,w,v,$,f,i,ee,ge,fe,$e,be,ye,_e,rt,nt,it,at,st,lt,ut,yt,_t,vt,St,Ct,Tt,Et,Mt,At,Ft,Dt,zt,Ot,Bt,Nt,Vt,Wt,Ut,Ht,Gt,jt,qt,Xt,Yt,Zt,Kt,Jt,Qt,eo,oo,()=>{ct="select",set_store_value(_t,O=!0,O),set_store_value(Wt,H=rectClone$1(G),H),ao=B?so:lo},({detail:e})=>{const{boundsLimited:t,boundsIntent:o}=ao(e.direction,e.translation);set_store_value(vt,q=!0,q),set_store_value(Ut,se=o,se),set_store_value(Vt,G=t,G)},({detail:e})=>{const{boundsLimited:t}=ao(e.direction,e.translation);set_store_value(vt,q=!1,q),set_store_value(_t,O=!1,O),set_store_value(Ut,se=void 0,se),vectorLength(e.translation)&&(set_store_value(Vt,G=t,G),bt.write()),set_store_value(Wt,H=void 0,H),ct=void 0},()=>{ct="rotate",set_store_value(_t,O=!0,O),set_store_value(jt,re=rectClone$1(N),re)},e=>{set_store_value(vt,q=!0,q),set_store_value(Ot,Z=e,Z)},e=>{set_store_value(vt,q=!1,q),set_store_value(_t,O=!1,O),set_store_value(Ot,Z=e,Z),bt.write(),set_store_value(jt,re=void 0,re)},()=>{ct="pan",uo=void 0,set_store_value(_t,O=!0,O),co=rectClone$1(N)},({detail:e})=>{set_store_value(vt,q=!0,q),po(e)},({detail:e})=>{set_store_value(vt,q=!1,q),set_store_value(_t,O=!1,O),(vectorLength(e.translation)>0||0!==e.scalar)&&(po(e),bt.write()),set_store_value(Gt,te=void 0,te),co=void 0},({detail:{translation:e}})=>{B&&(e=vectorInvert(vectorClone(e))),uo=e,set_store_value(_t,O=!1,O)},ho,mo,go,()=>{ct="zoom",set_store_value(_t,O=!0,O),co=rectClone$1(N)},e=>{set_store_value(vt,q=!1,q),fo(e)},e=>{fo(e),bt.write(),set_store_value(vt,q=!1,q),set_store_value(_t,O=!1,O),co=void 0},()=>{ct="zoom",co||($o=rectClone$1(N),set_store_value(_t,O=!0,O))},({detail:e})=>{$o&&(set_store_value(vt,q=!0,q),bo(e))},({detail:e})=>{$o&&(set_store_value(vt,q=!1,q),set_store_value(_t,O=!1,O),bo(e),set_store_value(Gt,te=void 0,te),$o=void 0,bt.write())},e=>{const t=getEventPositionInStage(e,ee,j);if(ze&&!rectContainsPoint(G,t))return;ct="zoom",set_store_value(_t,O=!0,O),set_store_value(vt,q=!0,q),e.preventDefault(),e.stopPropagation();const o=getWheelDelta(e,{fixScrollDirection:Q}),r=1+o/100,n=rectClone$1(N),i=1===Math.min(N.width/J.width,N.height/J.height);if(Re&&K){const e=gt(N,Y,Z);if(pt()&&e&&o>0&&u){set_store_value(_t,O=!1,O),set_store_value(vt,q=!1,q);const e=isRotatedSideways(Z)?rectCreateFromSize({height:Y.width,width:Y.height}):rectCreateFromSize(Y);if(rectEqual(n,e))return;if(clearTimeout(yo),rectEqual(bt.state.crop,e))return;return set_store_value(qt,N=e,N),void bt.write()}}let a=rectCenter(N);if(De&&"selection"!==Ke&&o<0&&!i){const e=vectorSubtract(vectorClone(t),G),o=Math.min(G.width/N.width,G.height/N.height),r=rectScale$1(rectClone$1(G),1.1);a=rectContainsPoint(r,t)?vectorAdd(rectClone$1(N),vectorMultiply(e,1/o)):a}let s=rectScale$1(rectClone$1(N),r,a);if(sizeContains(X[1],s)||(s=rectCreateWithCenter(rectCenter(s),X[1])),sizeContains(s,X[0])||(s=rectCreateWithCenter(rectCenter(s),X[0])),rectEqual(n,s,fixPrecision))return set_store_value(_t,O=!1,O),void set_store_value(vt,q=!1,q);set_store_value(qt,N=rectApply(s,(e=>fixPrecision(e,5))),N),set_store_value(_t,O=!1,O),set_store_value(vt,q=!1,q),clearTimeout(yo),yo=setTimeout((()=>{bt.write()}),500)},_o,vo,So,Co,To,ko,Mo,je,"crop",Ce,Te,ke,Re,Pe,Ie,Me,Ae,Fe,Le,De,ze,Oe,Be,Ne,Ve,We,Ue,He,Ge,qe,Xe,Ye,Ze,Ke,Qe,tt,ot,xo,h,C,S,_,x,r,a,s,m,u,p,c,d,l,I,M,A,F,L,z,O,B,V,W,U,H,G,j,Y,K,J,ue,pe,de,he,me,function(t){bubble.call(this,e,t)},({detail:e})=>o(5,Eo=e),function(e){binding_callbacks[e?"unshift":"push"]((()=>{Po=e,o(6,Po)}))},e=>getEventPositionInViewport(e),function(e){Ro=e,o(15,Ro)},function(t){bubble.call(this,e,t)}]}class Crop extends SvelteComponent{constructor(e){super(),init(this,e,instance$k,create_fragment$k,safe_not_equal,{name:96,isActive:0,stores:97,cropImageSelectionCornerStyle:1,cropWillRenderImageSelectionGuides:98,cropAutoCenterImageSelectionTimeout:99,cropEnableZoomMatchImageAspectRatio:100,cropEnableRotateMatchImageAspectRatio:101,cropEnableRotationInput:102,cropEnableZoom:2,cropEnableZoomInput:103,cropEnableZoomAutoHide:104,cropEnableImageSelection:105,cropEnableInfoIndicator:106,cropEnableZoomTowardsWheelPosition:107,cropEnableLimitWheelInputToCropSelection:108,cropEnableCenterImageSelection:109,cropEnableButtonRotateLeft:110,cropEnableButtonRotateRight:111,cropEnableButtonFlipHorizontal:112,cropEnableButtonFlipVertical:113,cropSelectPresetOptions:114,cropEnableSelectPreset:115,cropEnableFilterMatchAspectRatio:116,cropSelectPresetFilter:95,cropEnableButtonToggleCropLimit:117,cropWillRenderTools:118,cropActiveTransformTool:119,cropMinimizeToolbar:120,cropInteractionFocus:121,cropRotationRange:3,cropMaskOpacity:122,locale:4,cropFormatIconSelectPreset:123,cropFormatIconCropBoundary:124},null,[-1,-1,-1,-1,-1,-1,-1,-1])}get name(){return this.$$.ctx[96]}get isActive(){return this.$$.ctx[0]}set isActive(e){this.$$set({isActive:e}),flush()}get stores(){return this.$$.ctx[97]}set stores(e){this.$$set({stores:e}),flush()}get cropImageSelectionCornerStyle(){return this.$$.ctx[1]}set cropImageSelectionCornerStyle(e){this.$$set({cropImageSelectionCornerStyle:e}),flush()}get cropWillRenderImageSelectionGuides(){return this.$$.ctx[98]}set cropWillRenderImageSelectionGuides(e){this.$$set({cropWillRenderImageSelectionGuides:e}),flush()}get cropAutoCenterImageSelectionTimeout(){return this.$$.ctx[99]}set cropAutoCenterImageSelectionTimeout(e){this.$$set({cropAutoCenterImageSelectionTimeout:e}),flush()}get cropEnableZoomMatchImageAspectRatio(){return this.$$.ctx[100]}set cropEnableZoomMatchImageAspectRatio(e){this.$$set({cropEnableZoomMatchImageAspectRatio:e}),flush()}get cropEnableRotateMatchImageAspectRatio(){return this.$$.ctx[101]}set cropEnableRotateMatchImageAspectRatio(e){this.$$set({cropEnableRotateMatchImageAspectRatio:e}),flush()}get cropEnableRotationInput(){return this.$$.ctx[102]}set cropEnableRotationInput(e){this.$$set({cropEnableRotationInput:e}),flush()}get cropEnableZoom(){return this.$$.ctx[2]}set cropEnableZoom(e){this.$$set({cropEnableZoom:e}),flush()}get cropEnableZoomInput(){return this.$$.ctx[103]}set cropEnableZoomInput(e){this.$$set({cropEnableZoomInput:e}),flush()}get cropEnableZoomAutoHide(){return this.$$.ctx[104]}set cropEnableZoomAutoHide(e){this.$$set({cropEnableZoomAutoHide:e}),flush()}get cropEnableImageSelection(){return this.$$.ctx[105]}set cropEnableImageSelection(e){this.$$set({cropEnableImageSelection:e}),flush()}get cropEnableInfoIndicator(){return this.$$.ctx[106]}set cropEnableInfoIndicator(e){this.$$set({cropEnableInfoIndicator:e}),flush()}get cropEnableZoomTowardsWheelPosition(){return this.$$.ctx[107]}set cropEnableZoomTowardsWheelPosition(e){this.$$set({cropEnableZoomTowardsWheelPosition:e}),flush()}get cropEnableLimitWheelInputToCropSelection(){return this.$$.ctx[108]}set cropEnableLimitWheelInputToCropSelection(e){this.$$set({cropEnableLimitWheelInputToCropSelection:e}),flush()}get cropEnableCenterImageSelection(){return this.$$.ctx[109]}set cropEnableCenterImageSelection(e){this.$$set({cropEnableCenterImageSelection:e}),flush()}get cropEnableButtonRotateLeft(){return this.$$.ctx[110]}set cropEnableButtonRotateLeft(e){this.$$set({cropEnableButtonRotateLeft:e}),flush()}get cropEnableButtonRotateRight(){return this.$$.ctx[111]}set cropEnableButtonRotateRight(e){this.$$set({cropEnableButtonRotateRight:e}),flush()}get cropEnableButtonFlipHorizontal(){return this.$$.ctx[112]}set cropEnableButtonFlipHorizontal(e){this.$$set({cropEnableButtonFlipHorizontal:e}),flush()}get cropEnableButtonFlipVertical(){return this.$$.ctx[113]}set cropEnableButtonFlipVertical(e){this.$$set({cropEnableButtonFlipVertical:e}),flush()}get cropSelectPresetOptions(){return this.$$.ctx[114]}set cropSelectPresetOptions(e){this.$$set({cropSelectPresetOptions:e}),flush()}get cropEnableSelectPreset(){return this.$$.ctx[115]}set cropEnableSelectPreset(e){this.$$set({cropEnableSelectPreset:e}),flush()}get cropEnableFilterMatchAspectRatio(){return this.$$.ctx[116]}set cropEnableFilterMatchAspectRatio(e){this.$$set({cropEnableFilterMatchAspectRatio:e}),flush()}get cropSelectPresetFilter(){return this.$$.ctx[95]}set cropSelectPresetFilter(e){this.$$set({cropSelectPresetFilter:e}),flush()}get cropEnableButtonToggleCropLimit(){return this.$$.ctx[117]}set cropEnableButtonToggleCropLimit(e){this.$$set({cropEnableButtonToggleCropLimit:e}),flush()}get cropWillRenderTools(){return this.$$.ctx[118]}set cropWillRenderTools(e){this.$$set({cropWillRenderTools:e}),flush()}get cropActiveTransformTool(){return this.$$.ctx[119]}set cropActiveTransformTool(e){this.$$set({cropActiveTransformTool:e}),flush()}get cropMinimizeToolbar(){return this.$$.ctx[120]}set cropMinimizeToolbar(e){this.$$set({cropMinimizeToolbar:e}),flush()}get cropInteractionFocus(){return this.$$.ctx[121]}set cropInteractionFocus(e){this.$$set({cropInteractionFocus:e}),flush()}get cropRotationRange(){return this.$$.ctx[3]}set cropRotationRange(e){this.$$set({cropRotationRange:e}),flush()}get cropMaskOpacity(){return this.$$.ctx[122]}set cropMaskOpacity(e){this.$$set({cropMaskOpacity:e}),flush()}get locale(){return this.$$.ctx[4]}set locale(e){this.$$set({locale:e}),flush()}get cropFormatIconSelectPreset(){return this.$$.ctx[123]}set cropFormatIconSelectPreset(e){this.$$set({cropFormatIconSelectPreset:e}),flush()}get cropFormatIconCropBoundary(){return this.$$.ctx[124]}set cropFormatIconCropBoundary(e){this.$$set({cropFormatIconCropBoundary:e}),flush()}}var _plugin_crop={util:["crop",Crop]};function create_option_slot$3(e){let t,o,r,n,i,a,s,l=e[77],c=(isFunction(e[77].label)?e[77].label(e[2]):e[77].label)+"";function u(...t){return e[51](e[77],...t)}const p=()=>e[52](o,l),d=()=>e[52](null,l);return{c(){t=element("div"),o=element("div"),r=space(),n=element("span"),i=text(c),attr(o,"class",FILTER_PREVIEW_CLASS_NAME),attr(t,"slot","option"),attr(t,"class","PinturaFilterOption")},m(e,l){insert(e,t,l),append(t,o),p(),append(t,r),append(t,n),append(n,i),a||(s=[listen(o,"measure",u),action_destroyer(measurable.call(null,o))],a=!0)},p(t,o){l!==(e=t)[77]&&(d(),l=e[77],p()),4&o[0]|32768&o[2]&&c!==(c=(isFunction(e[77].label)?e[77].label(e[2]):e[77].label)+"")&&set_data(i,c)},d(e){e&&detach(t),d(),a=!1,run_all(s)}}}function create_default_slot$9(e){let t,o;return t=new RadioGroup({props:{locale:e[2],layout:"row",options:e[3],selectedIndex:e[12],onchange:e[32],$$slots:{option:[create_option_slot$3,({option:e})=>({77:e}),({option:e})=>[0,0,e?32768:0]]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};4&o[0]&&(r.locale=e[2]),8&o[0]&&(r.options=e[3]),4096&o[0]&&(r.selectedIndex=e[12]),1028&o[0]|98304&o[2]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_footer_slot$5(e){let t,o,r,n,i,a,s,l;function c(t){e[54](t)}function u(t){e[55](t)}function p(t){e[56](t)}let d={elasticity:e[13]*e[19],onscroll:e[53],$$slots:{default:[create_default_slot$9]},$$scope:{ctx:e}};return void 0!==e[4]&&(d.maskFeatherStartOpacity=e[4]),void 0!==e[5]&&(d.maskFeatherEndOpacity=e[5]),void 0!==e[6]&&(d.maskFeatherSize=e[6]),o=new Scrollable({props:d}),binding_callbacks.push((()=>bind(o,"maskFeatherStartOpacity",c))),binding_callbacks.push((()=>bind(o,"maskFeatherEndOpacity",u))),binding_callbacks.push((()=>bind(o,"maskFeatherSize",p))),o.$on("measure",e[57]),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"slot","footer"),set_style(t,"transform",e[11])},m(r,n){insert(r,t,n),mount_component(o,t,null),a=!0,s||(l=[listen(t,"transitionend",e[30]),listen(t,"measure",e[58]),action_destroyer(measurable.call(null,t,{observePosition:!0}))],s=!0)},p(e,a){const s={};8192&a[0]&&(s.elasticity=e[13]*e[19]),128&a[0]&&(s.onscroll=e[53]),5132&a[0]|65536&a[2]&&(s.$$scope={dirty:a,ctx:e}),!r&&16&a[0]&&(r=!0,s.maskFeatherStartOpacity=e[4],add_flush_callback((()=>r=!1))),!n&&32&a[0]&&(n=!0,s.maskFeatherEndOpacity=e[5],add_flush_callback((()=>n=!1))),!i&&64&a[0]&&(i=!0,s.maskFeatherSize=e[6],add_flush_callback((()=>i=!1))),o.$set(s),2048&a[0]&&set_style(t,"transform",e[11])},i(e){a||(transition_in(o.$$.fragment,e),a=!0)},o(e){transition_out(o.$$.fragment,e),a=!1},d(e){e&&detach(t),destroy_component(o),s=!1,run_all(l)}}}function create_fragment$j(e){let t,o;return t=new Util({props:{$$slots:{footer:[create_footer_slot$5]},$$scope:{ctx:e}}}),t.$on("measure",e[59]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16380&o[0]|65536&o[2]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}let FILTER_PREVIEW_CLASS_NAME="PinturaFilterPreview";function instance$j(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,S=noop,C=()=>(S(),S=subscribe(R,(e=>o(43,u=e))),R),w=noop,T=()=>(w(),w=subscribe(k,(e=>o(49,y=e))),k);e.$$.on_destroy.push((()=>S())),e.$$.on_destroy.push((()=>w()));let{isActive:k}=t;T();let{isActiveFraction:R}=t;C();let{stores:P}=t,{locale:I}=t,{filterFunctions:E}=t,{filterOptions:M}=t;const A=getContext("elasticityMultiplier");component_subscribe(e,A,(e=>o(13,v=e)));const{history:F,interfaceImages:L,stageRectBase:D,utilRect:z,animation:O,scrollElasticity:B,imageSize:N,imagePreview:V,imageCropRect:W,imageRotation:U,imageFlipX:H,imageFlipY:G,imageBackgroundColor:j,imageGamma:q,imageColorMatrix:X,allowPan:Y,allowZoom:Z,allowZoomControls:K,allowPlayPause:J}=P;component_subscribe(e,L,(e=>o(60,p=e))),component_subscribe(e,D,(e=>o(48,b=e))),component_subscribe(e,z,(e=>o(47,$=e))),component_subscribe(e,O,(e=>o(50,_=e))),component_subscribe(e,N,(e=>o(62,h=e))),component_subscribe(e,V,(e=>o(42,c=e))),component_subscribe(e,j,(e=>o(61,d=e))),component_subscribe(e,q,(e=>o(44,m=e))),component_subscribe(e,X,(e=>o(40,s=e)));const Q=writable({});component_subscribe(e,Q,(e=>o(46,f=e)));const ee=(e,t)=>set_store_value(Q,f[e.value]=t,f),te=derived(Q,(e=>{if(!e[void 0])return;const t=e[void 0];return x&&sizeEqual(x,t)?x:sizeClone(t)}));component_subscribe(e,te,(e=>o(63,x=e)));const oe=derived([k,te,W,N,U,H,G],(([e,t,o,r,n,i,a],s)=>{if(!e||!t||!r)return g;const l=rectCreateFromSize(r),c=rectCenter(l),u=getBaseCropRect(r,o,n),p=rectCenter(u),d=vectorSubtract(vectorClone(c),p),h=vectorInvert(vectorClone(d)),m=Math.max(t.width/o.width,t.height/o.height);s({origin:h,translation:d,rotation:{x:a?Math.PI:0,y:i?Math.PI:0,z:n},scale:m})}));component_subscribe(e,oe,(e=>o(45,g=e)));const re=spring(_?20:0);let ne;component_subscribe(e,re,(e=>o(39,a=e)));const ie={};let ae,se,le,ce,ue,pe,de={x:0,y:0};const he=writable([]);component_subscribe(e,he,(e=>o(41,l=e)));const me=e=>{const t={...e,data:c,size:h,offset:{...e.offset},mask:{...e.mask},backgroundColor:d};return t.opacity=u,t.offset.y+=a,t.mask.y+=a,t.id="filter",t},ge=()=>p.filter((e=>"filter"!==e.id));onDestroy((()=>{L.set([])}));return e.$$set=e=>{"isActive"in e&&T(o(0,k=e.isActive)),"isActiveFraction"in e&&C(o(1,R=e.isActiveFraction)),"stores"in e&&o(34,P=e.stores),"locale"in e&&o(2,I=e.locale),"filterFunctions"in e&&o(35,E=e.filterFunctions),"filterOptions"in e&&o(3,M=e.filterOptions)},e.$$.update=()=>{if(262144&e.$$.dirty[1]&&Y.set(y),262144&e.$$.dirty[1]&&Z.set(y),262144&e.$$.dirty[1]&&K.set(y),262144&e.$$.dirty[1]&&y&&J.set(!1),8&e.$$.dirty[0]&&o(38,r=flattenOptions(M)),640&e.$$.dirty[1]&&o(12,n=((e,t)=>{if(!e||!e.filter||!t)return 0;const o=e.filter;return t.findIndex((([e])=>{if(!E[e])return!1;const t=E[e]();return arrayEqual(t,o)}))})(s,r)),786432&e.$$.dirty[1]&&_&&re.set(y?0:20),512&e.$$.dirty[0]|458752&e.$$.dirty[1]&&y&&$&&b&&pe&&o(37,ue={x:b.x-$.x,y:b.y-$.y+pe.y}),496&e.$$.dirty[0]|58096&e.$$.dirty[1]&&g&&ue&&de&&ce&&ne){const e=ue.x+ce.x+de.x,t=ue.y,o=ce.x+ue.x,n=o+ce.width;he.set(r.map((([r],i)=>{const a=f[r],l=de.x+a.x,c=l+a.width;if(c<0||l>ce.width)return!1;const u=e+a.x,p=t+a.y,d=(e=>({origin:vectorClone(e.origin),translation:vectorClone(e.translation),rotation:{...e.rotation},scale:e.scale}))(g);d.offset=vectorCreate(.5*a.width+u,.5*a.height+p);d.maskOpacity=1,d.mask=rectCreate(u+0,p,a.width+0,a.height),d.maskFeather=[1,0,1,0,1,n,1,n],l<le&&ae<1&&(d.maskFeather[0]=ae,d.maskFeather[1]=o,d.maskFeather[2]=1,d.maskFeather[3]=o+le),c>ce.width-le&&se<1&&(d.maskFeather[4]=se,d.maskFeather[5]=n-le,d.maskFeather[6]=1,d.maskFeather[7]=n),d.maskCornerRadius=ne[r];let h=s&&Object.keys(s).filter((e=>"filter"!=e)).map((e=>s[e]))||[];return isFunction(E[r])&&h.push(E[r]()),d.colorMatrix=h.length?getColorMatrixFromColorMatrices(h):void 0,d.gamma=m,d})).filter(Boolean))}if(7424&e.$$.dirty[1])if(u>0&&l){const e=[...ge(),...l.map(me)];L.set(e)}else L.set(ge());256&e.$$.dirty[1]&&o(11,i=a?`translateY(${a}px)`:"none")},[k,R,I,M,ae,se,le,de,ce,pe,ie,i,n,v,A,L,D,z,O,B,N,V,j,q,X,Q,ee,te,oe,re,e=>{e.target.className===FILTER_PREVIEW_CLASS_NAME&&o(36,ne=Object.keys(ie).reduce(((e,t)=>{const o=ie[t],r=getComputedStyle(o),n=["top-left","top-right","bottom-left","bottom-right"].map((e=>r.getPropertyValue(`border-${e}-radius`))).map(unitToPixels).map((e=>1.25*e));return e[t]=n,e}),{}))},he,({value:e})=>{set_store_value(X,s={...s,filter:isFunction(E[e])?E[e]():void 0},s),F.write()},"filter",P,E,ne,ue,r,a,s,l,c,u,m,g,f,$,b,y,_,(e,t)=>ee(e,t.detail),function(e,t){binding_callbacks[e?"unshift":"push"]((()=>{ie[t.value]=e,o(10,ie)}))},e=>o(7,de=e),function(e){ae=e,o(4,ae)},function(e){se=e,o(5,se)},function(e){le=e,o(6,le)},e=>o(8,ce=e.detail),e=>o(9,pe=e.detail),function(t){bubble.call(this,e,t)}]}class Filter extends SvelteComponent{constructor(e){super(),init(this,e,instance$j,create_fragment$j,safe_not_equal,{name:33,isActive:0,isActiveFraction:1,stores:34,locale:2,filterFunctions:35,filterOptions:3},null,[-1,-1,-1])}get name(){return this.$$.ctx[33]}get isActive(){return this.$$.ctx[0]}set isActive(e){this.$$set({isActive:e}),flush()}get isActiveFraction(){return this.$$.ctx[1]}set isActiveFraction(e){this.$$set({isActiveFraction:e}),flush()}get stores(){return this.$$.ctx[34]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[2]}set locale(e){this.$$set({locale:e}),flush()}get filterFunctions(){return this.$$.ctx[35]}set filterFunctions(e){this.$$set({filterFunctions:e}),flush()}get filterOptions(){return this.$$.ctx[3]}set filterOptions(e){this.$$set({filterOptions:e}),flush()}}var _plugin_filter={util:["filter",Filter]};function create_if_block$8(e){let t,o,r,n;t=new Scrollable({props:{elasticity:e[6]*e[9],class:"PinturaControlListScroller",$$slots:{default:[create_default_slot_1$2]},$$scope:{ctx:e}}});const i=[{class:"PinturaControlPanels"},{panelClass:"PinturaControlPanel"},{panels:e[4]},e[5]];let a={$$slots:{default:[create_default_slot$8,({panel:e})=>({42:e}),({panel:e})=>[0,e?2048:0]]},$$scope:{ctx:e}};for(let e=0;e<i.length;e+=1)a=assign(a,i[e]);return r=new TabPanels({props:a}),{c(){create_component(t.$$.fragment),o=space(),create_component(r.$$.fragment)},m(e,i){mount_component(t,e,i),insert(e,o,i),mount_component(r,e,i),n=!0},p(e,o){const n={};64&o[0]&&(n.elasticity=e[6]*e[9]),38&o[0]|8192&o[1]&&(n.$$scope={dirty:o,ctx:e}),t.$set(n);const a=48&o[0]?get_spread_update(i,[i[0],i[1],16&o[0]&&{panels:e[4]},32&o[0]&&get_spread_object(e[5])]):{};128&o[0]|10240&o[1]&&(a.$$scope={dirty:o,ctx:e}),r.$set(a)},i(e){n||(transition_in(t.$$.fragment,e),transition_in(r.$$.fragment,e),n=!0)},o(e){transition_out(t.$$.fragment,e),transition_out(r.$$.fragment,e),n=!1},d(e){destroy_component(t,e),e&&detach(o),destroy_component(r,e)}}}function create_default_slot_2$2(e){let t,o,r=e[43].label+"";return{c(){t=element("span"),o=text(r)},m(e,r){insert(e,t,r),append(t,o)},p(e,t){4096&t[1]&&r!==(r=e[43].label+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_default_slot_1$2(e){let t,o;const r=[{class:"PinturaControlList"},{tabs:e[1]},e[5]];let n={$$slots:{default:[create_default_slot_2$2,({tab:e})=>({43:e}),({tab:e})=>[0,e?4096:0]]},$$scope:{ctx:e}};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new TabList({props:n}),t.$on("select",e[24]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=34&o[0]?get_spread_update(r,[r[0],2&o[0]&&{tabs:e[1]},32&o[0]&&get_spread_object(e[5])]):{};12288&o[1]&&(n.$$scope={dirty:o,ctx:e}),t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot$8(e){let t,o;const r=[e[7][e[42]]];let n={};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new RangeInput({props:n}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=128&o[0]|2048&o[1]?get_spread_update(r,[get_spread_object(e[7][e[42]])]):{};t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_footer_slot$4(e){let t,o,r=e[5]&&create_if_block$8(e);return{c(){t=element("div"),r&&r.c(),attr(t,"slot","footer"),set_style(t,"transform",e[3])},m(e,n){insert(e,t,n),r&&r.m(t,null),o=!0},p(e,o){e[5]?r?(r.p(e,o),32&o[0]&&transition_in(r,1)):(r=create_if_block$8(e),r.c(),transition_in(r,1),r.m(t,null)):r&&(group_outros(),transition_out(r,1,1,(()=>{r=null})),check_outros()),8&o[0]&&set_style(t,"transform",e[3])},i(e){o||(transition_in(r),o=!0)},o(e){transition_out(r),o=!1},d(e){e&&detach(t),r&&r.d()}}}function create_fragment$i(e){let t,o;return t=new Util({props:{$$slots:{footer:[create_footer_slot$4]},$$scope:{ctx:e}}}),t.$on("measure",e[25]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};254&o[0]|8192&o[1]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function instance$i(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m=noop,g=()=>(m(),m=subscribe($,(e=>o(21,c=e))),$);e.$$.on_destroy.push((()=>m()));let{stores:f}=t,{isActive:$}=t;g();let{locale:b={}}=t,{finetuneControlConfiguration:y}=t,{finetuneOptions:_}=t,{finetuneNudgePrecision:x}=t;const{history:v,animation:S,scrollElasticity:C,rangeInputElasticity:w,imageColorMatrix:T,imageConvolutionMatrix:k,imageGamma:R,imageVignette:P,imageNoise:I,allowPan:E,allowZoom:M,allowZoomControls:A,allowPlayPause:F}=f;component_subscribe(e,S,(e=>o(22,u=e)));const L={imageColorMatrix:T,imageConvolutionMatrix:k,imageGamma:R,imageVignette:P,imageNoise:I},D=getContext("elasticityMultiplier");component_subscribe(e,D,(e=>o(6,d=e)));const z=`finetune-${getUniqueId()}`,O=writable({});component_subscribe(e,O,(e=>o(23,p=e)));const B=writable({});component_subscribe(e,B,(e=>o(7,h=e)));let N=[];const V=spring(u?20:0);component_subscribe(e,V,(e=>o(20,l=e)));return e.$$set=e=>{"stores"in e&&o(15,f=e.stores),"isActive"in e&&g(o(0,$=e.isActive)),"locale"in e&&o(16,b=e.locale),"finetuneControlConfiguration"in e&&o(17,y=e.finetuneControlConfiguration),"finetuneOptions"in e&&o(18,_=e.finetuneOptions),"finetuneNudgePrecision"in e&&o(19,x=e.finetuneNudgePrecision)},e.$$.update=()=>{var t;2097152&e.$$.dirty[0]&&E.set(c),2097152&e.$$.dirty[0]&&M.set(c),2097152&e.$$.dirty[0]&&A.set(c),2097152&e.$$.dirty[0]&&c&&F.set(!0),327680&e.$$.dirty[0]&&o(1,r=_?_.map((([e,t])=>({id:e,label:isFunction(t)?t(b):t}))):[]),2&e.$$.dirty[0]&&o(2,n=r.length?r[0].id:void 0),4&e.$$.dirty[0]&&o(5,i=n&&{name:z,selected:n}),2&e.$$.dirty[0]&&o(4,a=r.map((e=>e.id))),131072&e.$$.dirty[0]&&y&&(t=y,N&&N.forEach((e=>e())),N=a.map((e=>{const{getStore:o,getValue:r=passthrough}=t[e];return o(L).subscribe((t=>{const o=null!=t?r(t):t;set_store_value(O,p={...p,[e]:o},p)}))}))),8519680&e.$$.dirty[0]&&y&&p&&set_store_value(B,h=Object.keys(p).reduce(((e,t)=>{const{base:o,min:r,max:n,getLabel:i,getStore:a,setValue:s=(e,t)=>e.set(t)}=y[t],l=a(L),c=null!=p[t]?p[t]:o;return e[t]={base:o,min:r,max:n,value:c,valueLabel:i?i(c,r,n,n-r):Math.round(100*c),oninputmove:e=>{s(l,e)},oninputend:e=>{s(l,e),v.write()},elasticity:d*w,labelReset:b.labelReset,nudgeMultiplier:x},e}),{}),h),6291456&e.$$.dirty[0]&&u&&V.set(c?0:20),1048576&e.$$.dirty[0]&&o(3,s=l?`translateY(${l}px)`:"none")},[$,r,n,s,a,i,d,h,S,C,D,O,B,V,"finetune",f,b,y,_,x,l,c,u,p,({detail:e})=>o(2,n=e),function(t){bubble.call(this,e,t)}]}class Finetune extends SvelteComponent{constructor(e){super(),init(this,e,instance$i,create_fragment$i,safe_not_equal,{name:14,stores:15,isActive:0,locale:16,finetuneControlConfiguration:17,finetuneOptions:18,finetuneNudgePrecision:19},null,[-1,-1])}get name(){return this.$$.ctx[14]}get stores(){return this.$$.ctx[15]}set stores(e){this.$$set({stores:e}),flush()}get isActive(){return this.$$.ctx[0]}set isActive(e){this.$$set({isActive:e}),flush()}get locale(){return this.$$.ctx[16]}set locale(e){this.$$set({locale:e}),flush()}get finetuneControlConfiguration(){return this.$$.ctx[17]}set finetuneControlConfiguration(e){this.$$set({finetuneControlConfiguration:e}),flush()}get finetuneOptions(){return this.$$.ctx[18]}set finetuneOptions(e){this.$$set({finetuneOptions:e}),flush()}get finetuneNudgePrecision(){return this.$$.ctx[19]}set finetuneNudgePrecision(e){this.$$set({finetuneNudgePrecision:e}),flush()}}var _plugin_finetune={util:["finetune",Finetune]},arrayIndexWrap=(e,t)=>{const o=t.length;return e<0?e%o+o:e>=o?e%o:e};function get_each_context$2(e,t,o){const r=e.slice();return r[46]=t[o].key,r[47]=t[o].index,r[48]=t[o].translate,r[49]=t[o].scale,r[50]=t[o].selected,r[12]=t[o].rotate,r[51]=t[o].dir,r[52]=t[o].center,r[53]=t[o].type,r[2]=t[o].visible,r}function create_if_block_1$4(e){let t;return{c(){t=element("div"),attr(t,"class","PinturaShapeManipulator"),attr(t,"data-control","point"),set_style(t,"pointer-events","none"),set_style(t,"opacity",e[4]),set_style(t,"transform",`translate3d(${e[52].x}px, ${e[52].y}px, 0) scale(${e[5]}, ${e[5]})`)},m(e,o){insert(e,t,o)},p(e,o){16&o[0]&&set_style(t,"opacity",e[4]),40&o[0]&&set_style(t,"transform",`translate3d(${e[52].x}px, ${e[52].y}px, 0) scale(${e[5]}, ${e[5]})`)},d(e){e&&detach(t)}}}function create_each_block$2(e,t){let o,r,n,i,a,s,l,c,u;function p(...e){return t[18](t[47],...e)}let d="edge"===t[53]&&t[2]&&create_if_block_1$4(t);return{key:e,first:null,c(){o=element("div"),s=space(),d&&d.c(),l=empty(),attr(o,"role","button"),attr(o,"aria-label",r=`Drag ${t[53]} ${t[46]}`),attr(o,"tabindex",n="edge"===t[53]?-1:0),attr(o,"class","PinturaShapeManipulator"),attr(o,"data-control",i=t[53]),attr(o,"data-selected",a=t[50]),set_style(o,"cursor",t[51]?t[51]+"-resize":"move"),set_style(o,"opacity",t[4]),set_style(o,"--tx",t[48].x),set_style(o,"--ty",t[48].y),set_style(o,"--r","edge"===t[53]?t[12]:0),set_style(o,"--sx","point"===t[53]?t[5]:t[49].x),set_style(o,"--sy","point"===t[53]?t[5]:t[49].y),this.first=o},m(e,r){insert(e,o,r),insert(e,s,r),d&&d.m(e,r),insert(e,l,r),c||(u=[listen(o,"nudge",p),action_destroyer(nudgeable.call(null,o,{preventDefault:!0})),listen(o,"interactionstart",(function(){is_function(t[9]("start",t[47]))&&t[9]("start",t[47]).apply(this,arguments)})),listen(o,"interactionupdate",(function(){is_function(t[9]("move",t[47]))&&t[9]("move",t[47]).apply(this,arguments)})),listen(o,"interactionend",(function(){is_function(t[9]("end",t[47]))&&t[9]("end",t[47]).apply(this,arguments)})),action_destroyer(interactable.call(null,o,{observeKeys:!0}))],c=!0)},p(e,s){t=e,8&s[0]&&r!==(r=`Drag ${t[53]} ${t[46]}`)&&attr(o,"aria-label",r),8&s[0]&&n!==(n="edge"===t[53]?-1:0)&&attr(o,"tabindex",n),8&s[0]&&i!==(i=t[53])&&attr(o,"data-control",i),8&s[0]&&a!==(a=t[50])&&attr(o,"data-selected",a),8&s[0]&&set_style(o,"cursor",t[51]?t[51]+"-resize":"move"),16&s[0]&&set_style(o,"opacity",t[4]),8&s[0]&&set_style(o,"--tx",t[48].x),8&s[0]&&set_style(o,"--ty",t[48].y),8&s[0]&&set_style(o,"--r","edge"===t[53]?t[12]:0),40&s[0]&&set_style(o,"--sx","point"===t[53]?t[5]:t[49].x),40&s[0]&&set_style(o,"--sy","point"===t[53]?t[5]:t[49].y),"edge"===t[53]&&t[2]?d?d.p(t,s):(d=create_if_block_1$4(t),d.c(),d.m(l.parentNode,l)):d&&(d.d(1),d=null)},d(e){e&&detach(o),e&&detach(s),d&&d.d(e),e&&detach(l),c=!1,run_all(u)}}}function create_if_block$7(e){let t,o,r;return{c(){t=element("div"),attr(t,"role","button"),attr(t,"aria-label","Drag rotator"),attr(t,"tabindex","0"),attr(t,"class","PinturaShapeManipulator"),attr(t,"data-control","rotate"),set_style(t,"transform",`translate3d(${e[0].x}px, ${e[0].y}px, 0) scale(${e[5]}, ${e[5]})`),set_style(t,"opacity",e[4])},m(n,i){insert(n,t,i),o||(r=[listen(t,"nudge",e[11]),action_destroyer(nudgeable.call(null,t,{preventDefault:!0})),listen(t,"interactionstart",e[12]("start")),listen(t,"interactionupdate",e[12]("move")),listen(t,"interactionend",e[12]("end")),action_destroyer(interactable.call(null,t,{observeKeys:!0}))],o=!0)},p(e,o){33&o[0]&&set_style(t,"transform",`translate3d(${e[0].x}px, ${e[0].y}px, 0) scale(${e[5]}, ${e[5]})`),16&o[0]&&set_style(t,"opacity",e[4])},d(e){e&&detach(t),o=!1,run_all(r)}}}function create_fragment$h(e){let t,o,r=[],n=new Map,i=e[3];const a=e=>e[46];for(let t=0;t<i.length;t+=1){let o=get_each_context$2(e,i,t),s=a(o);n.set(s,r[t]=create_each_block$2(s,o))}let s=e[1]&&create_if_block$7(e);return{c(){for(let e=0;e<r.length;e+=1)r[e].c();t=space(),s&&s.c(),o=empty()},m(e,n){for(let t=0;t<r.length;t+=1)r[t].m(e,n);insert(e,t,n),s&&s.m(e,n),insert(e,o,n)},p(e,l){1592&l[0]&&(i=e[3],r=update_keyed_each(r,l,a,1,e,i,n,t.parentNode,destroy_block,create_each_block$2,t,get_each_context$2)),e[1]?s?s.p(e,l):(s=create_if_block$7(e),s.c(),s.m(o.parentNode,o)):s&&(s.d(1),s=null)},i:noop,o:noop,d(e){for(let t=0;t<r.length;t+=1)r[t].d(e);e&&detach(t),s&&s.d(e),e&&detach(o)}}}function instance$h(e,t,o){let r,n,i,a;const s=createEventDispatcher(),l=.5*QUART_PI,c=HALF_PI-l,u=HALF_PI+l,p=-HALF_PI,d=p-l,h=p+l,m=PI-l,g=-PI+l,f=l,$=-l,b=HALF_PI-QUART_PI,y=b-l,_=b+l,x=PI-QUART_PI,v=x-l,S=x+l,C=p-QUART_PI,w=C+l,T=C-l,k=p+QUART_PI,R=k+l,P=k-l;let{visible:I=!1}=t,{points:E=[]}=t,{rotatorPoint:M}=t,{selectedPoint:A}=t,{enableDragEdges:F=!0}=t,{enableDragPoints:L=!0}=t,{enableRotatePoints:D=!0}=t;const z=getContext("isAnimated");component_subscribe(e,z,(e=>o(17,n=e)));const O=spring(.5,{precision:1e-4,stiffness:.3,damping:.7});component_subscribe(e,O,(e=>o(5,a=e)));const B=spring(0,{precision:.001,stiffness:.3,damping:.7});component_subscribe(e,B,(e=>o(4,i=e)));const N=e=>{let t="";return(e<=u&&e>=c||e>=d&&e<=h)&&(t="ns"),(e<=g||e>=m||e>=$&&e<=f)&&(t="ew"),(e>=v&&e<=S||e<=R&&e>=P)&&(t="nesw"),(e>=y&&e<=_||e<=w&&e>=T)&&(t="nwse"),t},V=(e,t)=>{s("resizestart",{indexes:e,translation:vectorCreateEmpty(),isNudge:!0}),s("resizemove",{indexes:e,translation:t,isNudge:!0}),s("resizeend",{indexes:e,translation:vectorCreateEmpty(),isNudge:!0})};return e.$$set=e=>{"visible"in e&&o(2,I=e.visible),"points"in e&&o(13,E=e.points),"rotatorPoint"in e&&o(0,M=e.rotatorPoint),"selectedPoint"in e&&o(14,A=e.selectedPoint),"enableDragEdges"in e&&o(15,F=e.enableDragEdges),"enableDragPoints"in e&&o(16,L=e.enableDragPoints),"enableRotatePoints"in e&&o(1,D=e.enableRotatePoints)},e.$$.update=()=>{131076&e.$$.dirty[0]&&O.set(I?1:.5,{hard:!1===n}),131076&e.$$.dirty[0]&&B.set(I?1:0,{hard:!1===n}),8192&e.$$.dirty[0]&&o(3,r=(e=>{let t=0;const o=vectorCenter(e),r=[],n=e.length;for(;t<n;t++){const n=arrayIndexWrap(t-1,e),i=arrayIndexWrap(t+1,e),a=e[n],s=e[t],l=e[i],c=Math.atan2(l.y-s.y,l.x-s.x);if(L){const e=vectorNormalize(vectorCreate(a.x-s.x,a.y-s.y)),o=vectorNormalize(vectorCreate(l.x-s.x,l.y-s.y)),n=vectorCreate(e.x+o.x,e.y+o.y),i=F?L&&N(Math.atan2(n.y,n.x)):void 0;r.push({index:[t],key:`point-${t}`,type:"point",selected:A===t,scale:{x:1,y:1},translate:{x:s.x,y:s.y},angle:void 0,rotate:D,center:s,dir:i})}if(!F)continue;if(Array.isArray(F)&&!F.some((([e,o])=>t===e&&i===o)))continue;const u=vectorCreate(s.x+.5*(l.x-s.x),s.y+.5*(l.y-s.y));r.push({index:[t,i],key:`edge-${t}`,type:"edge",scale:{x:vectorDistance(s,l),y:1},translate:{x:s.x,y:s.y},angle:c,rotate:c,center:u,visible:Array.isArray(F),dir:N(Math.atan2(o.y-u.y,o.x-u.x))})}return r})(E))},[M,D,I,r,i,a,z,O,B,(e,t)=>({detail:o})=>{const r=o&&o.translation?o.translation:vectorCreate(0,0);s(`resize${e}`,{...o,indexes:t,translation:r})},V,({detail:e})=>{s("rotatestart",{translation:vectorCreateEmpty(),isNudge:!0}),s("rotatemove",{translation:e,isNudge:!0}),s("rotateend",{translation:vectorCreateEmpty(),isNudge:!0})},e=>({detail:t})=>{const o=t&&t.translation?t.translation:vectorCreate(0,0);s(`rotate${e}`,{...t,translation:o})},E,A,F,L,n,(e,{detail:t})=>V(e,t)]}class ShapeManipulator extends SvelteComponent{constructor(e){super(),init(this,e,instance$h,create_fragment$h,safe_not_equal,{visible:2,points:13,rotatorPoint:0,selectedPoint:14,enableDragEdges:15,enableDragPoints:16,enableRotatePoints:1},null,[-1,-1])}}var getEventPositionInEditor=(e,t)=>{const o=getEventPositionInViewport(e);return vectorSubtract(o,t)},t=e=>document.createTextNode(e),replaceDivWithBr=e=>(isSafari()&&e.endsWith("<div><br></div>")?e.replace(/<div><br><\/div>$/,"<br><br>"):e).replace(/<div><br><\/div>/g,"<br>").replace(/<\/div>/g,"").replace(/<div>/g,"<br>");function create_if_block$6(e){let t,o,r,n;return{c(){t=element("pre"),attr(t,"class","PinturaContentEditable")},m(i,a){insert(i,t,a),t.innerHTML=e[0],r||(n=action_destroyer(o=styleable.call(null,t,`${e[7]};position:absolute;z-index:-1;pointer-events:none;`)),r=!0)},p(e,r){1&r[0]&&(t.innerHTML=e[0]),o&&is_function(o.update)&&128&r[0]&&o.update.call(null,`${e[7]};position:absolute;z-index:-1;pointer-events:none;`)},d(e){e&&detach(t),r=!1,n()}}}function create_fragment$g(e){let t,o,r,n,i,a,s=e[8]&&create_if_block$6(e);return{c(){s&&s.c(),t=space(),o=element("pre"),attr(o,"class","PinturaContentEditable"),attr(o,"data-wrap-content",r=e[4]||e[5]?"wrap":"nowrap"),attr(o,"contenteditable",""),attr(o,"spellcheck",e[1]),attr(o,"autocorrect",e[2]),attr(o,"autocapitalize",e[3])},m(r,l){s&&s.m(r,l),insert(r,t,l),insert(r,o,l),e[26](o),i||(a=[action_destroyer(n=styleable.call(null,o,e[8]?e[15](e[7]):e[7])),listen(o,"input",e[13]),listen(o,"compositionend",e[12]),listen(o,"paste",e[14]),listen(o,"keydown",e[10]),listen(o,"keyup",e[11]),listen(o,"blur",e[9])],i=!0)},p(e,i){e[8]?s?s.p(e,i):(s=create_if_block$6(e),s.c(),s.m(t.parentNode,t)):s&&(s.d(1),s=null),48&i[0]&&r!==(r=e[4]||e[5]?"wrap":"nowrap")&&attr(o,"data-wrap-content",r),2&i[0]&&attr(o,"spellcheck",e[1]),4&i[0]&&attr(o,"autocorrect",e[2]),8&i[0]&&attr(o,"autocapitalize",e[3]),n&&is_function(n.update)&&384&i[0]&&n.update.call(null,e[8]?e[15](e[7]):e[7])},i:noop,o:noop,d(r){s&&s.d(r),r&&detach(t),r&&detach(o),e[26](null),i=!1,run_all(a)}}}function instance$g(e,o,r){let n,i,{spellcheck:a="false"}=o,{autocorrect:s="off"}=o,{autocapitalize:l="off"}=o,{wrapLines:c=!0}=o,{allowNewline:u=!0}=o,{textFormat:p="text"}=o,{formatInput:d=passthrough}=o,{formatPaste:m=passthrough}=o,{styles:g}=o,{innerHTML:f}=o,{oninput:$=noop$1}=o,{enableTextStyleShortcuts:b=!1}=o;const y=()=>{if(!x)return;const e=document.createRange();e.selectNodeContents(x);const t=R();t.removeAllRanges(),t.addRange(e)},_=createEventDispatcher();let x;document.execCommand("defaultParagraphSeparator",!1,"br");const v=e=>e.replace(/<\/?(?:i|b|em|u|s|strike|strong|font)>/,"").replace(/style=".*?"/g,"").replace(/\n/gim,"<br>"),S=()=>{r(0,f=x.innerHTML);const e=replaceDivWithBr(f);_("input",e),$(e),requestAnimationFrame((()=>x&&x.scrollTo(0,0)))},C=()=>{P(x);const e="html"===p?x.innerHTML:v(x.innerHTML);r(6,x.innerHTML=d(e),x),I(x),S()},w={b:"bold",i:"italic",u:"underline",s:"strikethrough"},T=e=>{const t=h("span");return t.dataset.bookmark=e,t},k=(e,o,r)=>{const n=T(r);if(e.nodeType===Node.TEXT_NODE){const i=e.textContent;if("start"===r){const r=t(i.substring(0,o)),a=t(i.substring(o));e.replaceWith(r,n,a)}else{const r=t(i.substring(0,o)),a=t(i.substring(o));e.replaceWith(r,n,a)}}else e.nodeType===Node.ELEMENT_NODE&&e.insertBefore(n,e.childNodes[o])},R=()=>{const e=x.getRootNode();return"getSelection"in e?e.getSelection():document.getSelection()},P=e=>{const t=R();if(!t.getRangeAt||!t.rangeCount)return;const o=t.getRangeAt(0),{startOffset:r,endOffset:n,startContainer:i,endContainer:a}=o;if(e.contains(o.startContainer)&&e.contains(o.endContainer))if(i.nodeType===Node.TEXT_NODE&&i===a){const e=i.textContent,t=e.substring(0,r),o=T("start"),a=n-r>0?e.substring(r,n):"",s=T("end"),l=e.substring(n);i.replaceWith(t,o,a,s,l)}else k(i,r,"start"),k(a,n+(i===a?1:0),"end")},I=e=>{const t=E(e,"start"),o=E(e,"end");if(!t||!o)return;const r=document.createRange();r.setStart(t,0),r.setEnd(o,0);const n=R();n.removeAllRanges(),n.addRange(r),t.remove(),o.remove()},E=(e,t)=>{const o=e.children;for(let e=0;e<o.length;e++){const r=o[e];if(r.dataset.bookmark===t)return r;if(r.children.length){const e=E(r,t);if(e)return e}}};let M;return e.$$set=e=>{"spellcheck"in e&&r(1,a=e.spellcheck),"autocorrect"in e&&r(2,s=e.autocorrect),"autocapitalize"in e&&r(3,l=e.autocapitalize),"wrapLines"in e&&r(4,c=e.wrapLines),"allowNewline"in e&&r(5,u=e.allowNewline),"textFormat"in e&&r(16,p=e.textFormat),"formatInput"in e&&r(17,d=e.formatInput),"formatPaste"in e&&r(18,m=e.formatPaste),"styles"in e&&r(19,g=e.styles),"innerHTML"in e&&r(0,f=e.innerHTML),"oninput"in e&&r(20,$=e.oninput),"enableTextStyleShortcuts"in e&&r(21,b=e.enableTextStyleShortcuts)},e.$$.update=()=>{var t;if(64&e.$$.dirty[0]&&r(25,n=!!x),33554433&e.$$.dirty[0]&&n&&f&&(t=f)!==x.innerHTML&&(r(6,x.innerHTML=t,x),x===document.activeElement&&y()),524336&e.$$.dirty[0])if(!c&&u){const e=g.includes(":right")?"text-indent:-100px!important":g.includes(":center")?"":"min-width:calc(100% + 100px)!important";r(7,M=g+";overflow:visible;"+e)}else r(7,M=g);524288&e.$$.dirty[0]&&r(8,i=g.includes("text-stroke"))},[f,a,s,l,c,u,x,M,i,()=>{_("blur")},e=>{if(/escape/i.test(e.code))return e.stopPropagation(),void _("cancel");const t=e.ctrlKey||e.metaKey;if("html"===p&&t&&/b|i|u|s/.test(e.key))return b&&(e=>{const t=w[e];t&&document.execCommand(t)})(e.key),void e.preventDefault();/enter/i.test(e.code)&&(e.stopPropagation(),e.isComposing||(t?_("confirm"):(u||e.preventDefault(),document.execCommand("insertLineBreak"),e.preventDefault())))},()=>{},e=>{""!==e.data&&C()},e=>{const{inputType:t}=e;"insertCompositionText"!==t&&"deleteCompositionText"!==t&&C()},e=>{e.preventDefault();const t=e.clipboardData.getData("text/plain"),o="html"===p?t:v(t),r=m(o);if(!r.length)return;const n=R().getRangeAt(0);n.deleteContents(),n.insertNode(document.createTextNode(r)),S()},e=>e.replace("-webkit-text-stroke","--text-stroke").replace("text-shadow","--text-shadow"),p,d,m,g,$,b,()=>C(),()=>x&&x.focus(),y,n,function(e){binding_callbacks[e?"unshift":"push"]((()=>{x=e,r(6,x)}))}]}class ContentEditable extends SvelteComponent{constructor(e){super(),init(this,e,instance$g,create_fragment$g,safe_not_equal,{spellcheck:1,autocorrect:2,autocapitalize:3,wrapLines:4,allowNewline:5,textFormat:16,formatInput:17,formatPaste:18,styles:19,innerHTML:0,oninput:20,enableTextStyleShortcuts:21,confirm:22,focus:23,select:24},null,[-1,-1])}get spellcheck(){return this.$$.ctx[1]}set spellcheck(e){this.$$set({spellcheck:e}),flush()}get autocorrect(){return this.$$.ctx[2]}set autocorrect(e){this.$$set({autocorrect:e}),flush()}get autocapitalize(){return this.$$.ctx[3]}set autocapitalize(e){this.$$set({autocapitalize:e}),flush()}get wrapLines(){return this.$$.ctx[4]}set wrapLines(e){this.$$set({wrapLines:e}),flush()}get allowNewline(){return this.$$.ctx[5]}set allowNewline(e){this.$$set({allowNewline:e}),flush()}get textFormat(){return this.$$.ctx[16]}set textFormat(e){this.$$set({textFormat:e}),flush()}get formatInput(){return this.$$.ctx[17]}set formatInput(e){this.$$set({formatInput:e}),flush()}get formatPaste(){return this.$$.ctx[18]}set formatPaste(e){this.$$set({formatPaste:e}),flush()}get styles(){return this.$$.ctx[19]}set styles(e){this.$$set({styles:e}),flush()}get innerHTML(){return this.$$.ctx[0]}set innerHTML(e){this.$$set({innerHTML:e}),flush()}get oninput(){return this.$$.ctx[20]}set oninput(e){this.$$set({oninput:e}),flush()}get enableTextStyleShortcuts(){return this.$$.ctx[21]}set enableTextStyleShortcuts(e){this.$$set({enableTextStyleShortcuts:e}),flush()}get confirm(){return this.$$.ctx[22]}get focus(){return this.$$.ctx[23]}get select(){return this.$$.ctx[24]}}const DefaultFormattingTags=["i","b","u","strike"].map((e=>({tag:e,tagOpen:new RegExp(`<${e}>`,"g"),tagClose:new RegExp(`</${e}>`,"g"),placeholderOpen:new RegExp(`___${e}O___`,"g"),placeholderClose:new RegExp(`___${e}C___`,"g")}))),replaceFormattingTags=(e,t=DefaultFormattingTags)=>(t.forEach((({tag:t,tagOpen:o,tagClose:r})=>{e=e.replace(o,`___${t}O___`).replace(r,`___${t}C___`)})),e),restoreFormattingTags=(e,t=DefaultFormattingTags)=>(t.forEach((({tag:t,placeholderOpen:o,placeholderClose:r})=>{e=e.replace(o,`<${t}>`).replace(r,`</${t}>`)})),e);var textToHTML=e=>(e=(e=replaceFormattingTags(e)).replace(/ {2,}/g," ").replace(/\u00a0/g,"&nbsp;").split("\n").join("<br>"),e=restoreFormattingTags(e)),htmlToText=e=>replaceDivWithBr(e).split(/<br>|<br\/>/g).join("\n").replace(/&nbsp;/g,String.fromCharCode(160)).replace(/&amp;/g,"&"),fromPercentage=(e,t)=>isString(e)?parseFloat(e)/100*t:e,toPercentagePoint=(e,t)=>({x:toPercentage(e.x,t.width),y:toPercentage(e.y,t.height)});function get_each_context$1(e,t,o){const r=e.slice();return r[300]=t[o],r[302]=o,r}function create_each_block$1(e,t){let o,r,n,i,a,s,l,c,u,p,d,h=t[300].name+"";function m(){return t[190](t[302])}return n=new ColorPreview({props:{color:t[300].color}}),{key:e,first:null,c(){o=element("li"),r=element("button"),create_component(n.$$.fragment),i=space(),a=element("span"),s=text(h),c=space(),attr(r,"class","PinturaShapeListItem"),attr(r,"type","button"),attr(r,"aria-label",l="Select shape "+t[300].name),this.first=o},m(e,t){insert(e,o,t),append(o,r),mount_component(n,r,null),append(r,i),append(r,a),append(a,s),append(o,c),u=!0,p||(d=listen(r,"click",m),p=!0)},p(e,o){t=e;const i={};2097152&o[0]&&(i.color=t[300].color),n.$set(i),(!u||2097152&o[0])&&h!==(h=t[300].name+"")&&set_data(s,h),(!u||2097152&o[0]&&l!==(l="Select shape "+t[300].name))&&attr(r,"aria-label",l)},i(e){u||(transition_in(n.$$.fragment,e),u=!0)},o(e){transition_out(n.$$.fragment,e),u=!1},d(e){e&&detach(o),destroy_component(n),p=!1,d()}}}function create_if_block_4$2(e){let t,o;return t=new ShapeManipulator({props:{visible:!0,points:e[12],rotatorPoint:e[28],selectedPoint:e[16],enableDragEdges:e[17],enableDragPoints:e[30],enableRotatePoints:e[14]}}),t.$on("resizestart",e[39]),t.$on("resizemove",e[40]),t.$on("resizeend",e[41]),t.$on("rotatestart",e[42]),t.$on("rotatemove",e[43]),t.$on("rotateend",e[44]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};4096&o[0]&&(r.points=e[12]),268435456&o[0]&&(r.rotatorPoint=e[28]),65536&o[0]&&(r.selectedPoint=e[16]),131072&o[0]&&(r.enableDragEdges=e[17]),1073741824&o[0]&&(r.enableDragPoints=e[30]),16384&o[0]&&(r.enableRotatePoints=e[14]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_1$3(e){let t,o,r,n;const i=[create_if_block_2$3,create_if_block_3$2],a=[];function s(e,t){return"modal"===e[4]?0:"inline"===e[4]?1:-1}return~(t=s(e))&&(o=a[t]=i[t](e)),{c(){o&&o.c(),r=empty()},m(e,o){~t&&a[t].m(e,o),insert(e,r,o),n=!0},p(e,n){let l=t;t=s(e),t===l?~t&&a[t].p(e,n):(o&&(group_outros(),transition_out(a[l],1,1,(()=>{a[l]=null})),check_outros()),~t?(o=a[t],o?o.p(e,n):(o=a[t]=i[t](e),o.c()),transition_in(o,1),o.m(r.parentNode,r)):o=null)},i(e){n||(transition_in(o),n=!0)},o(e){transition_out(o),n=!1},d(e){~t&&a[t].d(e),e&&detach(r)}}}function create_if_block_3$2(e){let t,o,r,n,i,a,s={formatInput:e[46],wrapLines:!!e[13].width,textFormat:e[13].format,enableTextStyleShortcuts:e[5],allowNewline:e[29],styles:e[27]};return o=new ContentEditable({props:s}),e[193](o),o.$on("input",e[47]),o.$on("keyup",e[50]),o.$on("cancel",e[52]),o.$on("confirm",e[51]),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"class","PinturaInlineInput")},m(s,l){insert(s,t,l),mount_component(o,t,null),n=!0,i||(a=[action_destroyer(r=styleable.call(null,t,e[26])),listen(t,"focusout",e[194])],i=!0)},p(e,t){const n={};8192&t[0]&&(n.wrapLines=!!e[13].width),8192&t[0]&&(n.textFormat=e[13].format),32&t[0]&&(n.enableTextStyleShortcuts=e[5]),536870912&t[0]&&(n.allowNewline=e[29]),134217728&t[0]&&(n.styles=e[27]),o.$set(n),r&&is_function(r.update)&&67108864&t[0]&&r.update.call(null,e[26])},i(e){n||(transition_in(o.$$.fragment,e),n=!0)},o(e){transition_out(o.$$.fragment,e),n=!1},d(r){r&&detach(t),e[193](null),destroy_component(o),i=!1,run_all(a)}}}function create_if_block_2$3(e){let t,o;return t=new InputForm({props:{panelOffset:e[2],onconfirm:e[51],oncancel:e[52],buttonCancel:{icon:e[6].shapeIconInputCancel,label:e[6].shapeLabelInputCancel},buttonConfirm:{icon:e[6].shapeIconInputConfirm,label:e[6].shapeLabelInputConfirm,hideLabel:!0},$$slots:{default:[create_default_slot$7]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};4&o[0]&&(r.panelOffset=e[2]),64&o[0]&&(r.buttonCancel={icon:e[6].shapeIconInputCancel,label:e[6].shapeLabelInputCancel}),64&o[0]&&(r.buttonConfirm={icon:e[6].shapeIconInputConfirm,label:e[6].shapeLabelInputConfirm,hideLabel:!0}),167772416&o[0]|16777216&o[9]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot$7(e){let t,o,r,n;return{c(){t=element("textarea"),attr(t,"spellcheck","false"),attr(t,"autocorrect","off"),attr(t,"autocapitalize","off")},m(i,a){insert(i,t,a),e[191](t),set_input_value(t,e[25]),r||(n=[listen(t,"keydown",e[49]),listen(t,"keypress",e[48]),listen(t,"keyup",e[50]),listen(t,"input",e[47]),listen(t,"input",e[192]),action_destroyer(o=styleable.call(null,t,e[27]))],r=!0)},p(e,r){33554432&r[0]&&set_input_value(t,e[25]),o&&is_function(o.update)&&134217728&r[0]&&o.update.call(null,e[27])},d(o){o&&detach(t),e[191](null),r=!1,run_all(n)}}}function create_if_block$5(e){let t,o,r,n,i;return o=new DynamicComponentTree_1({props:{items:e[22],key:e[10]}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"class","PinturaShapeControls"),set_style(t,"transform",e[24]),set_style(t,"opacity",e[23])},m(a,s){insert(a,t,s),mount_component(o,t,null),r=!0,n||(i=[listen(t,"measure",e[195]),action_destroyer(measurable.call(null,t))],n=!0)},p(e,r){const n={};4194304&r[0]&&(n.items=e[22]),1024&r[0]&&(n.key=e[10]),o.$set(n),16777216&r[0]&&set_style(t,"transform",e[24]),8388608&r[0]&&set_style(t,"opacity",e[23])},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o),n=!1,run_all(i)}}}function create_fragment$f(e){let t,o,r,n,i,a,s,l,c,u,p=[],d=new Map,h=e[21];const m=e=>e[300].id;for(let t=0;t<h.length;t+=1){let o=get_each_context$1(e,h,t),r=m(o);d.set(r,p[t]=create_each_block$1(r,o))}let g=e[15]&&create_if_block_4$2(e),f=e[11]&&create_if_block_1$3(e),$=e[18]>0&&create_if_block$5(e);return{c(){t=element("div"),o=element("nav"),r=element("ul");for(let e=0;e<p.length;e+=1)p[e].c();n=space(),g&&g.c(),i=space(),f&&f.c(),a=space(),$&&$.c(),attr(o,"class","PinturaShapeList"),attr(o,"data-visible",e[19]),attr(t,"class","PinturaShapeEditor"),attr(t,"tabindex","0")},m(d,h){insert(d,t,h),append(t,o),append(o,r);for(let e=0;e<p.length;e+=1)p[e].m(r,null);append(t,n),g&&g.m(t,null),append(t,i),f&&f.m(t,null),append(t,a),$&&$.m(t,null),e[196](t),l=!0,c||(u=[listen(o,"focusin",e[55]),listen(o,"focusout",e[56]),listen(t,"keydown",(function(){is_function(e[0]?noop$1:e[45])&&(e[0]?noop$1:e[45]).apply(this,arguments)})),listen(t,"nudge",(function(){is_function(e[0]?noop$1:e[54])&&(e[0]?noop$1:e[54]).apply(this,arguments)})),listen(t,"measure",e[189]),listen(t,"pointermove",(function(){is_function(e[0]?noop$1:e[57])&&(e[0]?noop$1:e[57]).apply(this,arguments)})),listen(t,"pointerleave",(function(){is_function(e[0]?noop$1:e[58])&&(e[0]?noop$1:e[58]).apply(this,arguments)})),listen(t,"interactionstart",(function(){is_function(e[0]?noop$1:e[33])&&(e[0]?noop$1:e[33]).apply(this,arguments)})),listen(t,"interactionupdate",(function(){is_function(e[0]?noop$1:e[35])&&(e[0]?noop$1:e[35]).apply(this,arguments)})),listen(t,"interactioncancel",(function(){is_function(e[0]?noop$1:e[34])&&(e[0]?noop$1:e[34]).apply(this,arguments)})),listen(t,"interactionrelease",(function(){is_function(e[0]?noop$1:e[36])&&(e[0]?noop$1:e[36]).apply(this,arguments)})),listen(t,"interactionend",(function(){is_function(e[0]?noop$1:e[37])&&(e[0]?noop$1:e[37]).apply(this,arguments)})),action_destroyer(measurable.call(null,t)),action_destroyer(nudgeable.call(null,t)),action_destroyer(s=interactable.call(null,t,{drag:!0,inertia:!0,multiTouch:!1,observeKeys:!0,shouldStartInteraction:interactable_function,getEventPosition:e[197]}))],c=!0)},p(n,c){e=n,2097282&c[0]&&(h=e[21],group_outros(),p=update_keyed_each(p,c,m,1,e,h,d,r,outro_and_destroy_block,create_each_block$1,null,get_each_context$1),check_outros()),(!l||524288&c[0])&&attr(o,"data-visible",e[19]),e[15]?g?(g.p(e,c),32768&c[0]&&transition_in(g,1)):(g=create_if_block_4$2(e),g.c(),transition_in(g,1),g.m(t,i)):g&&(group_outros(),transition_out(g,1,1,(()=>{g=null})),check_outros()),e[11]?f?(f.p(e,c),2048&c[0]&&transition_in(f,1)):(f=create_if_block_1$3(e),f.c(),transition_in(f,1),f.m(t,a)):f&&(group_outros(),transition_out(f,1,1,(()=>{f=null})),check_outros()),e[18]>0?$?($.p(e,c),262144&c[0]&&transition_in($,1)):($=create_if_block$5(e),$.c(),transition_in($,1),$.m(t,null)):$&&(group_outros(),transition_out($,1,1,(()=>{$=null})),check_outros()),s&&is_function(s.update)&&8&c[0]&&s.update.call(null,{drag:!0,inertia:!0,multiTouch:!1,observeKeys:!0,shouldStartInteraction:interactable_function,getEventPosition:e[197]})},i(e){if(!l){for(let e=0;e<h.length;e+=1)transition_in(p[e]);transition_in(g),transition_in(f),transition_in($),l=!0}},o(e){for(let e=0;e<p.length;e+=1)transition_out(p[e]);transition_out(g),transition_out(f),transition_out($),l=!1},d(o){o&&detach(t);for(let e=0;e<p.length;e+=1)p[e].d();g&&g.d(),f&&f.d(),$&&$.d(),e[196](null),c=!1,run_all(u)}}}const POLYGON_END_PATH_DISTANCE_SQUARED=256,POLYGON_VERTEX_MIN_DISTANCE_SQUARED=100,ROTATION_CONTROL_OFFSET=20,MIN_TEXT_MARKUP_WIDTH=10,HoverShapeId="markup-hover",interactable_function=(e,t)=>e.target===t;function instance$f(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,S,C,w,T,k,R,P,I,E,M,A,F,L,D,z,O,B,N,V,W,U,H,G,j,q,X,Y,Z,K,J,Q,ee,te,oe,re,ne,ie,ae,se,le,ce,ue,pe,de=noop,he=()=>(de(),de=subscribe($e,(e=>o(185,se=e))),$e);e.$$.on_destroy.push((()=>de()));let{uid:me=getUniqueId()}=t,{ui:ge}=t,{disabled:fe=!1}=t,{shapes:$e}=t;he();let{selection:be}=t,{offset:ye}=t,{contextRotation:_e=0}=t,{contextFlipX:xe=!1}=t,{contextFlipY:ve=!1}=t,{contextZoom:Se=1}=t,{active:Ce=!1}=t,{opacity:we=1}=t,{parentRect:Te}=t,{rootRect:ke}=t,{utilRect:Re}=t,{hoverColor:Pe}=t,{caretColor:Ie}=t,{gridColor:Ee}=t,{snapColor:Me}=t,{textInputMode:Ae="inline"}=t,{oninteractionstart:Fe=noop$1}=t,{oninteractionupdate:Le=noop$1}=t,{oninteractionrelease:De=noop$1}=t,{oninteractionend:ze=noop$1}=t,{oninteractioncancel:Oe=noop$1}=t,{onaddshape:Be=noop$1}=t,{onupdateshape:Ne=noop$1}=t,{onselectshape:Ve=noop$1}=t,{onblurshape:We=noop$1}=t,{onremoveshape:Ue=noop$1}=t,{ontapshape:He=noop$1}=t,{onhovershape:Ge=noop$1}=t,{ontriggerhistorywrite:je=noop$1}=t,{onhovercanvas:qe=noop$1}=t,{ontapcanvas:Xe=noop$1}=t,{onleavecanvas:Ye=noop$1}=t,{beforeSelectShape:Ze=()=>!0}=t,{beforeDeselectShape:Ke=()=>!0}=t,{beforeRemoveShape:Je=()=>!0}=t,{beforeUpdateShape:Qe=(e,t,o)=>t}=t,{willRenderShapeControls:et=passthrough}=t,{willRenderShapeTextControls:tt=passthrough}=t,{willStartInteraction:ot=(e,t)=>!0}=t,{mapEditorPointToImagePoint:rt}=t,{mapImagePointToEditorPoint:nt}=t,{eraseRadius:it}=t,{selectRadius:at}=t,{enableButtonFlipVertical:st=!1}=t,{enableTapToAddText:lt=!0}=t,{enableMultiSelect:ct=!1}=t,{enableTextStyleControls:ut=!0}=t,{locale:pt}=t,{snapThreshold:dt=0}=t,{snapPointer:ht=!0}=t,{enableSnapToContext:mt=!0}=t,{gridSize:gt=0}=t;const ft=e=>{if(0===dt)return[];let t;return mt&&(t={...Te,x:0,y:0}),[...se.filter((t=>t!==e)).filter((e=>!shapeIsDraft(e))).filter((e=>shapeCanAcceptSnap(e))).map((e=>shapeComputeDisplay({...e},Te))),t].filter(Boolean)},$t=(e,t,o,r)=>0===e?{snapTargets:[]}:{snapThreshold:e,gridSize:t,gridRect:o,snapTargets:ft(r)},bt=getContext("isAnimated");component_subscribe(e,bt,(e=>o(186,ce=e)));const yt=e=>e.set(get_store_value(e)),_t=e=>get_store_value(e).find(shapeIsDraft),xt=(e,t)=>{if(!_t(t))return shapeMakeDraft(e),wt(e,t)},vt=e=>{_t(e)&&e.update((e=>e.filter((e=>!shapeIsDraft(e)))))},St=e=>{const t=_t(e);if(t)return shapeMakeFinal(t),yt(e),t},Ct=(e,t,o=(e,t)=>({...e,...t}))=>{_t(t)&&t.update((t=>t.map((t=>shapeIsDraft(t)?o(t,e):t))))},wt=(e,t=$e)=>(t.update((t=>[...t,e])),e),Tt=(e,t,o)=>{const r=Qe({...e},t,{...o});return shapeUpdateProps(e,r,o),e},kt=(e,t)=>{const o=vectorDistance(e,t),r=vectorAngleBetween(e,t),n=Math.PI/8,i=n*Math.round(r/n)-_e%n;t.x=e.x+o*Math.cos(i),t.y=e.y+o*Math.sin(i)},Rt=getContext("keysPressed");component_subscribe(e,Rt,(e=>o(187,ue=e)));const Pt=(e,t,o)=>0===e||t&&o?e:t||o?-e:e,It=e=>{if(null===e.x&&null===e.y)return Et();e.x&&o(141,Mt=rt({x:e.x,y:0}).x),e.y&&o(142,At=rt({x:0,y:e.y}).y)},Et=()=>{o(141,Mt=null),o(142,At=null)};let Mt=null,At=null;const Ft=(e,t)=>{const o=nt(e);return rt(vectorAdd(o,t))},Lt=(e,t,o)=>{const r=(o-t)/e+1;return Array.from({length:r},((o,r)=>t+r*e))},Dt=e=>{let t=[],o=[],r=e.points;if(void 0!==e.x1&&(r=[{x:e.x1,y:e.y1},{x:e.x2,y:e.y2}]),r){const e=r.map(nt),n=rectCreateFromPoints(e),i=e[0],a=e[e.length-1];t=[n.x,n.x+.5*n.width,n.x+n.width,i.x,a.x],o=[n.y,n.y+.5*n.height,n.y+n.height,i.y,a.y]}else if(e.text||void 0!==e.width||void 0!==e.rx){let r;if(e.text&&void 0===e.height){const t=textToSize(e.text,e);r=rectCreate(e.x,e.y,t.width,t.height)}else r=void 0!==e.width?rectCreateFromAny(e):rectCreateFromAny({x:e.x-e.rx,y:e.y-e.ry,width:2*e.rx,height:2*e.ry});const n=rectGetCorners(r).map(nt),i=Math.abs(e.rotation)>0?rectRotate(r,e.rotation).map(nt):n,a=rectCreateFromPoints(i),s=rectCenter(a),l=.5*a.width,c=.5*a.height;t=[s.x-l,s.x,s.x+l],o=[s.y-c,s.y,s.y+c]}else if(void 0!==e.x){const r=nt(e);t=[r.x],o=[r.y]}return{x:t,y:o}},zt=(e,t,o)=>{let r,n,i,a=Number.Infinity,s=null,l=null;for(let c=0;c<e.length;c++){n=e[c];for(let e=0;e<t.length;e++)i=t[e],r=Math.abs(n-i),r<o&&(null===l||r<a)&&(a=r,s=n,l=i)}return{origin:s,target:l}},Ot=(e,t,o,r,n)=>{const i={x:null,y:null},a={x:null,y:null},s=t.map(Dt);if(r>0){const e=nt({x:0,y:0}),t=nt({x:r,y:r}),o=nt({x:n.width,y:n.height}),i=t.x-e.x,a=Lt(i,e.x,o.x),l=Lt(i,e.y,o.y);s.push({x:a,y:l})}return s.forEach((t=>{const{snapTranslation:r,snapLine:n}=((e,t,o)=>{const r={x:null,y:null},n={x:null,y:null},i=zt(e.x,t.x,o);null!==i.target&&(r.x=i.target,n.x=i.target-i.origin);const a=zt(e.y,t.y,o);return null!==a.target&&(r.y=a.target,n.y=a.target-a.origin),{snapTranslation:n,snapLine:r}})(e,t,o);null!==r.x&&(null===a.x||Math.abs(r.x)<Math.abs(a.x))&&(a.x=r.x||0,i.x=n.x),null!==r.y&&(null===a.y||Math.abs(r.y)<Math.abs(a.y))&&(a.y=r.y||0,i.y=n.y)})),{snapTranslation:a,snapLines:i}},Bt=(e,t)=>(null!==t.x&&(e.x+=t.x),null!==t.y&&(e.y+=t.y),e),Nt=(e,t,o,r)=>{const{snapThreshold:n=0,gridSize:i=0,gridRect:a,snapTargets:s=[]}=r||{};let l=null;if(shapeIsLine(e)){if(n){const r=shapeComputeDisplay({...e},Te),l=Ft(shapeLineGetStartPoint(t),o),c=Ft(shapeLineGetEndPoint(t),o),u=Dt({...r,x1:l.x,y1:l.y,x2:c.x,y2:c.y}),{snapTranslation:p,snapLines:d}=Ot(u,s,n,i,a);Bt(o,p),It(d)}const r=Ft(shapeLineGetStartPoint(t),o),c=Ft(shapeLineGetEndPoint(t),o);l={x1:r.x,y1:r.y,x2:c.x,y2:c.y}}else if(e.points){if(shapeCanSelectPoint(xo)&&Kt(xo,{selectedPoint:void 0}),n){const r=shapeComputeDisplay({...e},Te),l=Dt({...r,points:t.points.map((e=>Ft(e,o)))}),{snapTranslation:c,snapLines:u}=Ot(l,s,n,i,a);Bt(o,c),It(u)}l={points:t.points.map((e=>Ft(e,o)))}}else if(shapeIsRect(e)||shapeIsText(e)||shapeIsEllipse(e)){if(n){const r=shapeComputeDisplay({...e},Te),l=Ft(t,o),c=Dt({...r,...l}),{snapTranslation:u,snapLines:p}=Ot(c,s,n,i,a);Bt(o,u),It(p)}l=Ft(t,o)}l&&(Tt(e,l,Te),Yt())},Vt={0:1,1:0,2:3,3:2},Wt={0:3,1:2,2:1,3:0};let Ut;const Ht=(e,t)=>{const o=e.points.filter(((e,o)=>o!==t));Kt(e,{points:o,selectedPoint:void 0})},Gt=()=>{if(se.length)return se.find(shapeIsDraft)},jt=()=>{if(se.length)return se.findIndex(shapeIsDraft)},qt=()=>{const e=Gt();if(e)return shapeMakeFinal(e),Yt(),e},Xt=()=>{if(!Gt())return;const e=[...se];e.splice(jt(),1),$e.set(e)},Yt=()=>{$e.set(se)},Zt=(e,t=[],o=!0)=>{t.filter(Boolean).forEach((t=>delete e[t])),o&&Yt()},Kt=(e,t,o=!0)=>{e=Object.assign(e,t),o&&Yt()},Jt=(e,t,o,r=!0)=>{e[t]=o,r&&Yt()},Qt=(e,t=!0)=>{se.forEach((t=>Kt(t,e,!1))),t&&Yt()},eo=()=>[...se].reverse().filter(shapeIsSelected),to=()=>[...se].reverse().find(shapeIsSelected),oo=()=>!!to(),ro=(e,t=!0,o=!1)=>{const r=se.filter((e=>shapeCanRemove(e)&&shapeCanSelect(e))),n=r.findIndex((t=>t===e)),i=((e,t=!1)=>{if(!Je(e))return!1;$e.set(se.filter((t=>t!==e))),t||Ue(e)})(e,o);if(!1===i)return;if(io=e,r.length-1<=0)return ao();if(!t)return!0;const a=n-1<0?r.length-1:n-1;return lo(r[a]),!0},no=()=>{if(a){const e=[];return i.forEach(((t,o)=>{if(!shapeCanRemove(t))return;ro(t,o===i.length-1,!0)&&e.push(t)})),void(e.length&&je())}const e=to();e&&ro(e)};let io;const ao=(e={})=>{const{storePrevious:t=!0}=e;Object.keys(cr).forEach((e=>cr[e]={}));const o=so();t&&(io=o),Qt({isSelected:!1,isEditing:!1,_prerender:!1}),o&&We(o)},so=()=>se.find(shapeIsSelected),lo=(e,t=!0,o=!1)=>{if(shapeIsDraft(e))return;const r=so()||io,n=shapeIsSelected(e);io=void 0,Ze(r,e)&&(o||ao(),shapeSelect(e),!n&&Ve(e),t&&Yt())},co=e=>{or&&or.confirm&&e.isEditing&&or.confirm();const t={isSelected:!1,isEditing:!1,_prerender:!1};e.selectedPoint>-1&&(t.selectedPoint=void 0),Kt(e,t),We(e)},uo=e=>{Kt(e,{isSelected:!0,isEditing:!0,_prerender:"inline"===Ae})},po=e=>{Kt(e,{isSelected:!0,isEditing:!1,_prerender:!1})},ho=e=>{if(!e.length)return[];const t=e.filter(Je);return $e.set(se.filter((e=>!t.includes(e)))),t},mo=e=>{const t=textToSize(e.text,e);return rectCreate(e.x,e.y,e.width?Math.min(e.width,t.width):t.width,e.height?Math.min(e.height,t.height):t.height)},go=e=>{if(shapeHasSize(e))return rectCreateFromAny(e);if(shapeIsEllipse(e))return rectCreateFromEllipse(e);const t=mo(e);return t.width=Math.max(10,e.width||t.width),t},fo=(e,t,o=0,r=()=>!0)=>[...e].reverse().filter(r).map((e=>({shape:e,priority:1}))).filter((e=>{const{shape:r}=e,n=shapeComputeDisplay(shapeDeepCopy(r),Te),i=o+.5*(n.strokeWidth||0);if(shapeIsRect(n))return circleOverlapsWithRect(t,i,n,r.rotation);if(shapeIsText(n)){const o=go(n),a=circleOverlapsWithRect(t,i,o,r.rotation);let s=!1;if(a&&!shapeIsSelected(r)){const a=mo(n);"right"!==r.textAlign||r.flipX||(a.x=o.x+o.width-a.width),"center"===r.textAlign&&(a.x=o.x+.5*o.width-.5*a.width),s=circleOverlapsWithRect(t,i,a,r.rotation,rectCenter(o)),s||(e.priority=-1)}return a}return shapeIsEllipse(n)?circleOverlapsWithEllipse(t,i,n,r.rotation,r.flipX,r.flipY):shapeIsLine(n)?circleOverlapsWithLine(t,Math.max(16,i),shapeLineGetStartPoint(n),shapeLineGetEndPoint(n)):shapeIsPath(n)&&n.pathClose?circleOverlapsWithPolygon(t,i,n.points):!!shapeIsPath(n)&&(1===n.points.length?vectorDistanceSquared(t,n.points[0])<i*i:circleOverlapsWithPath(t,Math.max(16,i),n.points))})).sort(((e,t)=>e.priority<t.priority?1:e.priority>t.priority?-1:0)).map((e=>e.shape)),$o=(e,t,o,r=0)=>{const n=Math.abs(r),i=lineCreate(t,o),a=lineExtend(i,n),s=lineExtrude(a,n);return e.filter((e=>{const t=shapeComputeDisplay(shapeDeepCopy(e),Te);if(shapeIsLine(t)||shapeIsPath(t)){const e=t.points?[...t.points]:[shapeLineGetStartPoint(t),shapeLineGetEndPoint(t)];return!!linePointsIntersection(a,e)}return polyIntersectsWithPoly(s,((e,t=12)=>{if(shapeIsRect(e))return rectRotate(e,e.rotation,rectCenter(e));if(shapeIsText(e)){const t=go(e);return rectRotate(t,e.rotation,rectCenter(t))}return shapeIsEllipse(e)?ellipseToPolygon(vectorCreate(e.x,e.y),e.rx,e.ry,e.rotation,e.flipX,e.flipY,t):[]})(t))}))};let bo,yo,_o,xo,vo,So,Co,wo=!1,To=!1,ko=!1;const Ro=e=>{Co=e.map((e=>({shape:e,shapeOrigin:shapeDeepCopy(e),shapeOriginComputed:shapeComputeDisplay(shapeDeepCopy(e),Te)})))},Po=()=>{clearTimeout(yo),yo=void 0,o(144,ko=!1),Et()};let Io=null;const Eo=e=>{const t=isNumber(e.rotation)&&0!==e.rotation;if(shapeIsRect(e)){if(e.width<1&&e.height<1)return;const o=rectCenter(e),r=rectGetCorners(e);return(e.flipX||e.flipY)&&vectorsFlip(r,e.flipX,e.flipY,o.x,o.y),t?vectorsRotate(r,e.rotation,o.x,o.y):r}if(shapeIsEllipse(e)){if(e.rx<1&&e.ry<1)return;const o=e,r=rectGetCorners(rectCreateFromEllipse(e));return(e.flipX||e.flipY)&&vectorsFlip(r,e.flipX,e.flipY,o.x,o.y),t?vectorsRotate(r,e.rotation,o.x,o.y):r}if(shapeIsLine(e))return[shapeLineGetStartPoint(e),shapeLineGetEndPoint(e)];if(shapeIsPath(e)){if(e.bitmap&&!e.pathClose){const t=rectCreateFromPoints(e.points);t.x-=.5*e.strokeWidth,t.y-=.5*e.strokeWidth,t.width+=e.strokeWidth,t.height+=e.strokeWidth;return Eo({...e,...t})}return[...e.points]}if(shapeIsText(e)){if(e.width<5&&e.height<5)return;const o=go(e);o.width=Math.max(10,o.width);const r=rectCenter(o),n=rectGetCorners(o);return(e.flipX||e.flipY)&&vectorsFlip(n,e.flipX,e.flipY,r.x,r.y),t?vectorsRotate(n,e.rotation,r.x,r.y):n}return[]},Mo=e=>{const t=Eo(e);let o,r;return e.flipY?(o=vectorCenter([t[0],t[1]]),r=vectorNormalize(vectorCreate(t[1].x-t[2].x,t[1].y-t[2].y))):(o=vectorCenter([t[2],t[3]]),r=vectorNormalize(vectorCreate(t[2].x-t[1].x,t[2].y-t[1].y))),vectorMultiply(r,20/Se),{origin:o,dir:r}},Ao=e=>t=>t.id===e,Fo=e=>{const t=Ao(e);return e=>e.filter((e=>t=>!e(t))(t))},Lo=e=>{const t=Ao(e),o=Fo(e);return()=>ge.update((e=>e.some(t)?o(e):e))},Do=e=>{const t=Fo(e);return(...e)=>{ge.update((o=>[...t(o),...e.filter(Boolean)]))}},zo=Lo(HoverShapeId),Oo=Do(HoverShapeId);let Bo;const No="markup-manipulator-segment-"+me,Vo=Lo(No),Wo=Do(No),Uo=(e,t)=>{const o=e[t],r=t-1<0?e[e.length-1]:e[t-1],n=t+1<e.length?e[t+1]:e[0],i=vectorSubtract(vectorClone(r),o);vectorNormalize(i);const a=vectorAdd(vectorMultiply(i,10),o),s=vectorSubtract(vectorClone(n),o);vectorNormalize(s);return[a,o,vectorAdd(vectorMultiply(s,10),o)]},Ho=()=>{o(145,Bo=void 0),zo()},Go="markup-multi-selection-segment-"+me,jo=Lo(Go),qo=Do(Go),Xo=(e,t)=>{if(dt<=0)return e;if(t)return Et(),e;const o=rt(e),n=ft(),{snapTranslation:i,snapLines:a}=Ot(Dt(o),n,dt,gt,r);return It(a),Bt(e,i),e},Yo=spring(0);component_subscribe(e,Yo,(e=>o(188,pe=e)));const Zo=`markup-grid-line-${me}`,Ko=Lo(Zo),Jo=Do(Zo),Qo="markup-snap-line",er=Lo(Qo),tr=Do(Qo);let or;const rr=e=>{o(8,or.innerHTML=textToHTML(e),or)},nr=()=>{const e=(e=>{const t=void 0===e.value?e.innerHTML:e.value,o="text"===n.format?htmlToText(t):t,r=shapeIsTextBlock(n)&&!1!==n.disableNewline?(e=>{const t=e.split(/[\n\r]/g);return t.length>1?t.map((e=>e.trim())).filter((e=>e.length)).join(" "):t[0]})(o):o;return r})(or),t=shapeCanInput(n,e),o=!0===t?e:t;let r=D.x,i=D.y;if(!n.height){const e=rectRotate({...O},n.rotation),t=textToSize(o,p),a=rectRotate({x:r,y:i,...t},n.rotation),[s,,l]=e,[c,,u]=a;let d=s,h=c;n.flipX&&(d=l,h=u);const m=vectorSubtract(vectorClone(d),h);r+=m.x,i+=m.y}Kt(n,{x:isString(L.x)?toPercentage(r,Te.width):r,y:isString(L.y)?toPercentage(i,Te.height):i,text:o})},ir=()=>{c&&qt(),or&&or.confirm&&or.confirm(),nr(),po(n),Ne(n)},ar=()=>{c?Xt():(Kt(n,{text:L.text,x:L.x,y:L.y}),po(n))},sr=(e,t,{flipX:o,flipY:r,rotation:n},i="top left")=>{let a,s;const[l,c,u,p]=rectRotate(e,n),[d,h,m,g]=rectRotate(t,n);if("top center"===i){a=vectorCenter(r?[p,u]:[l,c]),s=vectorCenter(r?[g,m]:[d,h])}else"top right"===i&&!o||"top left"===i&&o?(a=r?u:c,s=r?m:h):(a=r?p:l,s=r?g:d);return vectorSubtract(vectorClone(a),s)},lr=(e,t,o)=>vectorCreate(isString(e.x)?toPercentage(t.x+o.x,Te.width):t.x+o.x,isString(e.y)?toPercentage(t.y+o.y,Te.height):t.y+o.y),cr={},ur=()=>Ht(n,n.selectedPoint),pr=()=>uo(n),dr=()=>{const e=sizeApply(textToSize(n.text,p),(e=>Math.ceil(e))),t=hasProp(n,"height"),o=!t&&hasProp(n,"width"),r=n.id;let i=cr[r];i||(cr[r]={},i=cr[r]);const a=e=>{const{width:t,...o}=p,r=textToSize(n.text,o),i=sr(rectCreate(p.x,p.y,e.width,e.height),rectCreate(p.x,p.y,r.width,r.height),p,`top ${n.textAlign}`),a=!1!==p.disableNewline;Zt(n,["width","height",a&&"textAlign"]),Kt(n,{...lr(n,p,i)})},s=t=>{const o=sizeCreate(i.width||p.width||e.width,e.height),r=i.textAlign||"left",a=sr(rectCreate(p.x,p.y,t.width,t.height),rectCreate(p.x,p.y,o.width,o.height),p,`top ${r}`);Zt(n,["height"]),Kt(n,{...lr(n,p,a),width:isString(n.width)?toPercentage(o.width,Te.width):o.width,textAlign:r})},l=t=>{const o=sizeCreate(i.width||e.width,i.height||e.height),r=i.textAlign||"left",a=sr(rectCreate(p.x,p.y,t.width,t.height),rectCreate(p.x,p.y,o.width,o.height),p,`top ${r}`);Kt(n,{...lr(n,p,a),width:isString(n.width)?toPercentage(o.width,Te.width):o.width,height:isString(n.width)?toPercentage(o.height,Te.height):o.height,textAlign:r})};if(t){i.textAlign=n.textAlign,i.width=p.width,i.height=p.height;const e=sizeCreate(p.width,p.height);shapeCanChangeTextLayout(n,"auto-height")?s(e):shapeCanChangeTextLayout(n,"auto-width")&&a(e)}else if(o){i.textAlign=n.textAlign,i.width=p.width;const t=sizeCreate(p.width,e.height);shapeCanChangeTextLayout(n,"auto-width")?a(t):shapeCanChangeTextLayout(n,"fixed-size")&&l(t)}else{i.textAlign=n.textAlign;const t=sizeCreate(Math.ceil(e.width),Math.ceil(e.height));shapeCanChangeTextLayout(n,"fixed-size")?l(t):shapeCanChangeTextLayout(n,"auto-height")&&s(t)}},hr=e=>{e.stopPropagation();const t=n.flipX||!1;Jt(n,"flipX",!t),Ne(n)},mr=e=>{e.stopPropagation();const t=n.flipY||!1;Jt(n,"flipY",!t),Ne(n)},gr=e=>{Jt(n,"opacity",e)},fr=e=>{gr(e),Ne(n)},$r=e=>{e.stopPropagation(),e.target.blur(),no()},br=e=>{e.stopPropagation();se.findIndex((e=>e===n))!==se.length-1&&($e.set(se.filter((e=>e!==n)).concat([n])),Ne(n))},yr=e=>{e.stopPropagation(),_r()},_r=()=>{const e=(a?i:[n]).filter(shapeCanDuplicate).map((e=>{const t=shapeDeepCopy(e);t.id=getUniqueId();const o=vectorCreate(50,-50);if(hasProp(t,"points")){const e=shapeGetPropsPixelValues(t,["points"],Te);e.points.forEach((e=>{e.x+=o.x,e.y+=o.y})),shapeUpdateProps(t,e,Te)}else if(shapeIsLine(t)){const e=shapeGetPropsPixelValues(t,["x1","y1","x2","y2"],Te);e.x1+=o.x,e.y1+=o.y,e.x2+=o.x,e.y2+=o.y,shapeUpdateProps(t,e,Te)}else{const e=shapeGetPropsPixelValues(t,["x","y"],Te);e.x+=50,e.y-=50,shapeUpdateProps(t,e,Te)}return $e.set([...se,t]),Be(t),t}));if(e.length>1)return ao(),void e.forEach((e=>{lo(e,!0,!0)}));lo(e[0])},xr=spring(0,{stiffness:.2,damping:.7});component_subscribe(e,xr,(e=>o(18,le=e)));let vr;const Sr=(e,t)=>{const{disableTextLayout:o=[]}=t;return"height"in t?o.includes("auto-height")?e.shapeIconButtonTextLayoutAutoWidth:e.shapeIconButtonTextLayoutAutoHeight:"width"in t?o.includes("auto-width")?e.shapeIconButtonTextLayoutFixedSize:e.shapeIconButtonTextLayoutAutoWidth:o.includes("fixed-size")?e.shapeIconButtonTextLayoutAutoHeight:e.shapeIconButtonTextLayoutFixedSize},Cr=(e,t)=>{const{disableTextLayout:o=[]}=t;return"height"in t?o.includes("auto-height")?e.shapeTitleButtonTextLayoutAutoWidth:e.shapeTitleButtonTextLayoutAutoHeight:"width"in t?o.includes("auto-width")?e.shapeTitleButtonTextLayoutFixedSize:e.shapeTitleButtonTextLayoutAutoWidth:o.includes("fixed-size")?e.shapeTitleButtonTextLayoutAutoHeight:e.shapeTitleButtonTextLayoutFixedSize};let wr=!1;let Tr,kr=vectorCreateEmpty();const Rr=e=>{Ge(e),o(145,Bo=e)};let Pr;onDestroy((()=>{er(),Ko(),Vo(),zo()}));return e.$$set=e=>{"uid"in e&&o(59,me=e.uid),"ui"in e&&o(60,ge=e.ui),"disabled"in e&&o(0,fe=e.disabled),"shapes"in e&&he(o(1,$e=e.shapes)),"selection"in e&&o(61,be=e.selection),"offset"in e&&o(2,ye=e.offset),"contextRotation"in e&&o(62,_e=e.contextRotation),"contextFlipX"in e&&o(63,xe=e.contextFlipX),"contextFlipY"in e&&o(64,ve=e.contextFlipY),"contextZoom"in e&&o(65,Se=e.contextZoom),"active"in e&&o(66,Ce=e.active),"opacity"in e&&o(67,we=e.opacity),"parentRect"in e&&o(68,Te=e.parentRect),"rootRect"in e&&o(3,ke=e.rootRect),"utilRect"in e&&o(69,Re=e.utilRect),"hoverColor"in e&&o(70,Pe=e.hoverColor),"caretColor"in e&&o(71,Ie=e.caretColor),"gridColor"in e&&o(72,Ee=e.gridColor),"snapColor"in e&&o(73,Me=e.snapColor),"textInputMode"in e&&o(4,Ae=e.textInputMode),"oninteractionstart"in e&&o(74,Fe=e.oninteractionstart),"oninteractionupdate"in e&&o(75,Le=e.oninteractionupdate),"oninteractionrelease"in e&&o(76,De=e.oninteractionrelease),"oninteractionend"in e&&o(77,ze=e.oninteractionend),"oninteractioncancel"in e&&o(78,Oe=e.oninteractioncancel),"onaddshape"in e&&o(79,Be=e.onaddshape),"onupdateshape"in e&&o(80,Ne=e.onupdateshape),"onselectshape"in e&&o(81,Ve=e.onselectshape),"onblurshape"in e&&o(82,We=e.onblurshape),"onremoveshape"in e&&o(83,Ue=e.onremoveshape),"ontapshape"in e&&o(84,He=e.ontapshape),"onhovershape"in e&&o(85,Ge=e.onhovershape),"ontriggerhistorywrite"in e&&o(86,je=e.ontriggerhistorywrite),"onhovercanvas"in e&&o(87,qe=e.onhovercanvas),"ontapcanvas"in e&&o(88,Xe=e.ontapcanvas),"onleavecanvas"in e&&o(89,Ye=e.onleavecanvas),"beforeSelectShape"in e&&o(90,Ze=e.beforeSelectShape),"beforeDeselectShape"in e&&o(91,Ke=e.beforeDeselectShape),"beforeRemoveShape"in e&&o(92,Je=e.beforeRemoveShape),"beforeUpdateShape"in e&&o(93,Qe=e.beforeUpdateShape),"willRenderShapeControls"in e&&o(94,et=e.willRenderShapeControls),"willRenderShapeTextControls"in e&&o(95,tt=e.willRenderShapeTextControls),"willStartInteraction"in e&&o(96,ot=e.willStartInteraction),"mapEditorPointToImagePoint"in e&&o(97,rt=e.mapEditorPointToImagePoint),"mapImagePointToEditorPoint"in e&&o(98,nt=e.mapImagePointToEditorPoint),"eraseRadius"in e&&o(99,it=e.eraseRadius),"selectRadius"in e&&o(100,at=e.selectRadius),"enableButtonFlipVertical"in e&&o(101,st=e.enableButtonFlipVertical),"enableTapToAddText"in e&&o(102,lt=e.enableTapToAddText),"enableMultiSelect"in e&&o(103,ct=e.enableMultiSelect),"enableTextStyleControls"in e&&o(5,ut=e.enableTextStyleControls),"locale"in e&&o(6,pt=e.locale),"snapThreshold"in e&&o(104,dt=e.snapThreshold),"snapPointer"in e&&o(105,ht=e.snapPointer),"enableSnapToContext"in e&&o(106,mt=e.enableSnapToContext),"gridSize"in e&&o(107,gt=e.gridSize)},e.$$.update=()=>{if(64&e.$$.dirty[2]|16384&e.$$.dirty[3]&&o(173,r=gt>0?{x:0,y:0,...Te}:void 0),1&e.$$.dirty[0]|1073741824&e.$$.dirty[5]&&o(149,n=!fe&&se&&(Gt()||to())),1024&e.$$.dirty[3]|1073741824&e.$$.dirty[5]&&o(165,i=ct?se.filter(shapeIsSelected):[]),1024&e.$$.dirty[5]&&o(164,a=i.length>1),64&e.$$.dirty[2]|1536&e.$$.dirty[5]&&o(184,s=a?i.map((e=>shapeComputeDisplay(shapeDeepCopy(e),Te))):[]),33554432&e.$$.dirty[4]&&o(181,l=!!n),33554432&e.$$.dirty[4]&&o(167,c=n&&shapeIsDraft(n)),33554432&e.$$.dirty[4]|4096&e.$$.dirty[5]&&o(10,u=n&&!c?n.id:void 0),8&e.$$.dirty[0]|64&e.$$.dirty[2]|33554432&e.$$.dirty[4]&&o(13,p=ke&&n&&shapeComputeDisplay(shapeDeepCopy(n),Te)),33554432&e.$$.dirty[4]|4096&e.$$.dirty[5]&&o(147,d=!(!n||!c)),8192&e.$$.dirty[0]|32&e.$$.dirty[2]|33554432&e.$$.dirty[4]&&o(180,h=n&&we&&Eo(p)||[]),536871424&e.$$.dirty[5]&&o(177,m=a?s.map(Eo):[]),33554432&e.$$.dirty[4]|512&e.$$.dirty[5]&&o(183,g=!a&&n&&shapeCanResize(n)&&!shapeIsTextEditing(n)),33554432&e.$$.dirty[4]|512&e.$$.dirty[5]&&o(14,f=!a&&n&&shapeCanRotate(n)&&!shapeIsTextEditing(n)),33554432&e.$$.dirty[4]|268435456&e.$$.dirty[5]&&o(17,$=g&&hasProp(n,"text")&&!n.height?[[1,2],[3,0]]:(!n||!shapeIsLine(n)&&!shapeIsPath(n))&&g),131072&e.$$.dirty[0]|33554432&e.$$.dirty[4]|268435456&e.$$.dirty[5]&&o(30,b=!!n&&(!Array.isArray($)&&g)),1536&e.$$.dirty[5]&&o(182,y=a?(e=>{const t=e.map((e=>Eo(shapeComputeDisplay(e,Te)))).flat(),o=rectCreateFromPoints(t);return rectGetCorners(o)})(i):[]),33554432&e.$$.dirty[4]|33554944&e.$$.dirty[5]&&o(15,_=n&&h.length>1||a),32&e.$$.dirty[3]|167772672&e.$$.dirty[5]&&o(178,x=a?y.map(nt):h.map(nt)),4&e.$$.dirty[0]|8388608&e.$$.dirty[5]&&o(12,v=x.map((e=>vectorCreate(e.x-ye.x,e.y-ye.y)))),33554432&e.$$.dirty[4]&&o(16,S=n&&n.points&&isNumber(n.selectedPoint)?n.selectedPoint:-1),65536&e.$$.dirty[0]&&o(157,C=S>=0),69632&e.$$.dirty[0]|4&e.$$.dirty[5]&&o(162,w=C?v[S]:void 0),33554432&e.$$.dirty[4]|67108864&e.$$.dirty[5]&&o(29,T=l&&(shapeIsTextBox(n)?!hasProp(n,"disableNewline")||!n.disableNewline:!1===n.disableNewline)),32&e.$$.dirty[3]|2097152&e.$$.dirty[4]&&(Bo&&nt&&!shapeIsSelected(Bo)&&shapeCanSelect(Bo)?(e=>{const t=Eo(shapeComputeDisplay(shapeDeepCopy(e),Te));if(!t)return;const o=t.map(nt),r=!!e.pathClose||!(!e.bitmap&&(shapeIsPath(e)||shapeIsLine(e))),n="hook"===e.selectionStyle,i=n?o.map(((e,t,o)=>({id:HoverShapeId,points:Uo(o,t),strokeColor:[0,0,0,.1],strokeWidth:2}))):[{id:HoverShapeId,points:o.map((e=>vectorCreate(e.x+1,e.y+1))),strokeColor:[0,0,0,.1],strokeWidth:2,pathClose:r}],a=n?o.map(((e,t,o)=>({id:HoverShapeId,points:Uo(o,t),strokeColor:Pe,strokeWidth:2}))):[{id:HoverShapeId,points:o,strokeColor:Pe,strokeWidth:2,pathClose:r}];Oo(...i,...a)})(Bo):zo()),61440&e.$$.dirty[0]|32&e.$$.dirty[2]&&o(179,k=_&&f&&we&&v?(e=>{const t=Mo(e),o=nt({x:t.origin.x+t.dir.x,y:t.origin.y+t.dir.y});return{origin:nt(t.origin),position:o}})(p):void 0),4&e.$$.dirty[0]|16777216&e.$$.dirty[5]&&o(28,R=k&&vectorCreate(k.position.x-ye.x,k.position.y-ye.y)),2&e.$$.dirty[6]&&o(172,M=!!(ue||[]).find((e=>[91,93,17].includes(e)))),4096&e.$$.dirty[3]|131072&e.$$.dirty[5]&&o(174,P=!(M||!ht)),32&e.$$.dirty[2]|37748736&e.$$.dirty[4]|8916992&e.$$.dirty[5]&&n&&x&&we>0&&(n===Bo&&Ho(),((e,t,o)=>{if(!shapeCanSelect(t))return;const r=shapeIsPath(t),n=r&&hasProp(t,"pathClose"),i=n&&shapeHasStroke(t),a=shapeIsDraft(t),s=shapeIsTextEditing(t),l="hook"===t.selectionStyle,c=!0!==t.disableShowPoints,{selectionOpacity:u=1}=t;if(a&&r&&!n)return;const p=[],d=[...x],m=d[d.length-1],g=d[0],f=(s?.05:.1)*e*u,$=f>0,b=(s?.5:1)*e*u,y=b>0,_=[0,0,0],v=[1,1,1],S=s?1:1.5;ue.includes(16)&&m&&o&&kt(m,o);const C=(d.length&&n&&a&&o?vectorDistanceSquared(g,o):1/0)<=256,w=(d.length&&n&&a&&o?vectorDistanceSquared(m,o):1/0)<=256;!C&&o&&d.push(o);const T=d.length>1,R=!!t.pathClose||!(!t.bitmap&&(shapeIsPath(t)||shapeIsLine(t)))||d.length>2&&C;T&&$&&(l?p.push(...d.map(((e,t,o)=>({id:No,points:Uo(o,t),strokeColor:_,opacity:f})))):p.push({id:No,points:d.map((e=>vectorCreate(e.x+1,e.y+1))),pathClose:R,strokeColor:_,strokeWidth:2,opacity:f})),n&&$&&c&&p.push(...d.map((e=>({id:No,...e,rx:2*S,ry:2*S,backgroundColor:_,opacity:f})))),k&&$&&p.push({id:No,points:[vectorCreate(k.origin.x+1,k.origin.y+1),vectorCreate(k.position.x+1,k.position.y+1)],strokeColor:_,strokeWidth:2,opacity:f}),T&&y&&(l?p.push(...d.map(((e,t,o)=>({id:No,points:Uo(o,t),strokeColor:v,strokeWidth:S,opacity:b})))):p.push({id:No,points:d,pathClose:R,strokeColor:v,strokeWidth:S,backgroundColor:a&&n&&t.backgroundColor&&t.backgroundColor[3]>0?t.backgroundColor:[0,0,0,0],opacity:b})),n&&c&&p.push(...d.map((e=>({id:No,...e,rx:3*S,ry:3*S,backgroundColor:[.5,.5,.5],strokeWidth:S,strokeColor:v})))),n&&a&&c&&x.length>=3&&p.push({...g,id:No,rx:S*(C?5:4),ry:S*(C?5:4),backgroundColor:C?Pe:[.5,.5,.5],strokeWidth:S,strokeColor:v}),n&&a&&i&&c&&!C&&h.length>=2&&p.push({...m,id:No,rx:S*(w?5:4),ry:S*(w?5:4),backgroundColor:w?Pe:[.5,.5,.5],strokeWidth:S,strokeColor:v}),k&&y&&!l&&p.push({id:No,points:[{x:k.origin.x,y:k.origin.y},{x:k.position.x,y:k.position.y}],strokeColor:v,strokeWidth:S,opacity:b}),Wo(...p)})(we,n,c&&shapeIsPath(n)?Xo({...Tr},!P):void 0)),33554432&e.$$.dirty[4]&&(n||(Ho(),Vo())),32&e.$$.dirty[3]|4194304&e.$$.dirty[5])if(m.length){jo();const e=m.map((e=>({id:Go,points:e.map(nt),strokeWidth:1,strokeColor:[1,1,1,.5],pathClose:!0})));qo(...e)}else jo();var t;2097152&e.$$.dirty[4]&&o(175,I=!!Bo),524288&e.$$.dirty[4]&&o(176,E=!!xo),4194304&e.$$.dirty[4]|3670016&e.$$.dirty[5]&&(!Tr||E||I||Xo({...Tr},!P)),1024&e.$$.dirty[2]|16416&e.$$.dirty[3]|262144&e.$$.dirty[5]|4&e.$$.dirty[6]&&gt>0&&r&&nt&&((e,t,o,r)=>{const n=nt({x:0,y:0}),i=nt({x:e,y:e}),a=nt({x:t.width,y:t.height}),s=i.x-n.x;if(Yo.set(s>6?1:0),r<=0)return Ko();const l=Lt(s,n.x,a.x).map((e=>({id:Zo,opacity:r,points:[{x:e,y:n.y},{x:e,y:a.y}],strokeWidth:1,strokeColor:o}))),c=Lt(s,n.y,a.y).map((e=>({id:Zo,opacity:r,points:[{x:n.x,y:e},{x:a.x,y:e}],strokeWidth:1,strokeColor:o})));Jo(...c,...l)})(gt,r,Ee,pe),2048&e.$$.dirty[2]|32&e.$$.dirty[3]|393216&e.$$.dirty[4]|131072&e.$$.dirty[5]&&nt&&(M?er():((e,t,o)=>{if(null===e&&null===t)return er();let r,n;null!==e&&(r={id:Qo,strokeColor:o,strokeWidth:1.5,points:[nt({x:e,y:0}),nt({x:e,y:Te.height})]}),null!==t&&(n={id:Qo,strokeColor:o,strokeWidth:1.5,points:[nt({x:0,y:t}),nt({x:Te.width,y:t})]}),tr(r,n)})(Mt,At,Me)),16&e.$$.dirty[2]&&(e=>{if(!e)return Qt({_prerender:!1});const t=se.find((e=>e.isEditing));t&&Kt(t,{_prerender:"inline"===Ae})})(Ce),2&e.$$.dirty[6]&&ue&&ue.length&&(()=>{const[e]=ue;8!==e&&46!==e||oo()&&(n.isEditing||(shapeIsPath(n)&&isNumber(n.selectedPoint)?setTimeout((()=>Ht(n,n.selectedPoint)),0):setTimeout((()=>no()),0)))})(),272&e.$$.dirty[0]&&or&&"inline"===Ae&&or.focus(),33554432&e.$$.dirty[4]&&o(171,A=n&&shapeIsText(n)),33554432&e.$$.dirty[4]|65536&e.$$.dirty[5]&&o(11,F=A&&!1!==shapeCanInput(n)&&shapeIsTextEditing(n)),2048&e.$$.dirty[0]&&o(166,L=F?{...n}:void 0),64&e.$$.dirty[2]|2048&e.$$.dirty[5]&&o(168,D=L&&shapeComputeDisplay({...L},Te)),8192&e.$$.dirty[5]&&o(170,z=D&&textToSize(D.text,D)),40960&e.$$.dirty[5]&&(O=D&&rectCreate(D.x,D.y,z.width,z.height)),2048&e.$$.dirty[0]|33554432&e.$$.dirty[4]&&o(25,B=F?n.text:""),2056&e.$$.dirty[0]|64&e.$$.dirty[2]|33554432&e.$$.dirty[4]&&o(169,N=ke&&n&&F&&shapeComputeDisplay({...shapeDeepCopy(n),width:isNumber(n.width)?Math.floor(n.width):void 0,height:isNumber(n.height)?Math.floor(n.height):void 0},Te)),2064&e.$$.dirty[0]|16384&e.$$.dirty[5]&&o(27,V=F&&((e,t)=>{const{textAlign:o="left",fontFamily:r="sans-serif",fontWeight:n="normal",fontStyle:i="normal",letterSpacing:a="normal",textShadowX:s=0,textShadowY:l=0,textShadowBlur:c=0,textShadowColor:u,textOutlineWidth:p=0,textOutlineColor:d}=e,h="!important",m=`caret-color:${U};text-align:${o}${h};font-family:${r}${h};font-weight:${n}${h};font-style:${i}${h};letter-spacing:${isNumber(a)?a+"px":"normal"}${h}`;if("modal"===t)return m;const g=p?`;-webkit-text-stroke:${2*p}px ${colorArrayToRGBA(d)} ${h}`:"",f=c||s||l?`;text-shadow:${s}px ${l}px ${c}px ${colorArrayToRGBA(u)} ${h}`:"";let $=e.fontSize,b=1,y="";$>1e3&&isFirefox()&&(b=$/1e3,y=`transform-origin:0 0;transform:scale(${b})`,$=1e3);let _=e.lineHeight/b;const x=colorArrayToRGBA(e.color),v=.5*Math.max(0,$-_);return`--font-scalar:${b};--bottom-inset:${v}px;padding:${v}px 0 0${h};color:${x}${h};font-size:${$}px${h};line-height:${_}px${h};${m};${y}${g}${f}`})(N,Ae)),2052&e.$$.dirty[0]|9&e.$$.dirty[2]|16384&e.$$.dirty[5]&&o(26,W=F&&((e,t,o,r)=>{let i,a;e.width&&e.height?(i=rectCenter(e),a=sizeCreateFromAny(e)):(a=textToSize(n.text,p),a.width=p.width||a.width,i=vectorCreate(e.x+.5*a.width,e.y+.5*a.height));const s=Math.max(0,e.fontSize-e.lineHeight)+e.lineHeight,l=nt(i);let c=l.x-t.x-.5*a.width,u=l.y-t.y-.5*a.height,d=e.flipX,h=e.flipY,m=e.rotation;xe&&ve?(d=!d,h=!h):xe?(d=!d,m=-m):ve&&(h=!h,m=-m),m+=r;const g=o*(d?-1:1),f=o*(h?-1:1);return`--line-height:${s}px;width:${a.width}px;height:${a.height}px;transform:translate(${c}px,${u}px) rotate(${m}rad) scale(${g}, ${f})`})(N,ye,Se,_e)),512&e.$$.dirty[2]&&(U=Ie?colorArrayToRGBA(Ie):"auto"),2320&e.$$.dirty[0]&&F&&or&&"inline"===Ae&&rr(B),578813952&e.$$.dirty[4]&&o(153,H=n&&!d?n:H),536870912&e.$$.dirty[4]&&o(155,G=H&&shapeCanFlip(H)),536870912&e.$$.dirty[4]&&o(150,j=H&&shapeCanChangeTextLayout(H)),536870912&e.$$.dirty[4]&&o(152,q=H&&shapeCanDuplicate(H)),536870912&e.$$.dirty[4]&&o(151,X=H&&shapeCanRemove(H)),536870912&e.$$.dirty[4]|512&e.$$.dirty[5]&&o(154,Y=!a&&H&&shapeCanReorder(H)),536870912&e.$$.dirty[4]&&o(148,Z=H&&!1!==shapeCanInput(H)),536870912&e.$$.dirty[4]&&o(156,K=H&&hasProp(H,"backgroundImage")&&shapeCanStyle(H,"opacity")),33554432&e.$$.dirty[4]&&o(159,J=n&&"html"===n.format),41943040&e.$$.dirty[4]|16&e.$$.dirty[5]&&o(163,Q=n&&(!d||J)),1048576&e.$$.dirty[4]|256&e.$$.dirty[5]|1&e.$$.dirty[6]&&xr.set(Q&&!ko?1:0,{hard:!1===ce}),4096&e.$$.dirty[0]|320&e.$$.dirty[5]&&o(161,ee=Q&&v.length?(t=rectCreateFromPoints(v),vectorApply(vectorCreate(t.x+.5*t.width,t.y),snapToPixel)):ee),512&e.$$.dirty[0]|128&e.$$.dirty[2]|192&e.$$.dirty[5]&&o(160,te=(w||ee)&&vr&&Re&&((e,t,o,r)=>{const n=e.x,i=e.y,a=n+e.width;let s=Math.max(t.x-.5*o.width,n),l=Math.max(t.y-o.height+r,i);return s+o.width>a&&(s=a-o.width),vectorCreate(s,l)})(Re,w||ee,vr,-16)),32&e.$$.dirty[5]&&o(24,oe=te?`translate(${te.x}px, ${te.y}px)`:void 0),262144&e.$$.dirty[0]|32&e.$$.dirty[5]&&o(23,re=te?le:void 0),2048&e.$$.dirty[0]&&o(158,ne=F?"text":"shape"),1088&e.$$.dirty[0]|262&e.$$.dirty[3]|2130706432&e.$$.dirty[4]|1073741855&e.$$.dirty[5]&&o(22,ie="text"===ne&&tt&&J?runSafe((()=>tt([["div","text-styles",{class:"PinturaShapeControlsGroup"},[...[["bold",{label:"B",style:"font-weight:900;",title:"Bold",shortcut:["CMD","B"]}],["italic",{label:"I",style:"font-family:Times New Roman;font-style:italic;",title:"Italic",shortcut:["CMD","I"]}],["underline",{label:"U",style:"text-decoration:underline;",title:"Underline",shortcut:["CMD","U"]}],["strikeThrough",{label:"S",style:"text-decoration:line-through;",title:"Strikethrough",shortcut:["CMD","S"]}]].map((([e,t])=>["Button","style-"+e,{onclick:()=>document.execCommand(e),...t,style:"font-size:1.25em;text-underline-offset:1px;text-decoration-thickness:1.5px;font-weight:400;"+t.style}]))]],["div","text-reset",{class:"PinturaShapeControlsGroup"},[["Button","style-reset",{onclick:()=>document.execCommand("removeFormat"),style:"font-weight:400",title:"Remove styles",label:[["span","T",{style:"font-size:1.25em;font-style:italic;font-family:Times New Roman;text-decoration:underline",textContent:"T"}],["span","x",{style:"position:relative;top:.175rem;",innerHTML:"&times;"}]]}]]]],u))):"shape"===ne&&et&&u?runSafe((()=>et(C?[["div","epsilon",{class:"PinturaShapeControlsGroup"},[["Button","remove-point",{onclick:ur,label:pt.shapeTitleButtonRemove,icon:pt.shapeIconButtonRemove,shortcut:["Backspace"],hideLabel:!0}]]]]:[K&&["div","alpha",{class:"PinturaShapeControlsGroup"},[["ToggleSlider","adjust-opacity",{onrelease:fr,onchange:gr,step:.01,value:hasProp(n,"opacity")?n.opacity:1,label:(e,t,o)=>`${Math.round(e/o*100)}%`,min:0,max:1,direction:"x"}]]],["div","beta",{class:"PinturaShapeControlsGroup"},[G&&["Button","flip-horizontal",{onclick:hr,label:pt.shapeTitleButtonFlipHorizontal,icon:pt.shapeIconButtonFlipHorizontal,hideLabel:!0}],G&&st&&["Button","flip-vertical",{onclick:mr,label:pt.shapeTitleButtonFlipVertical,icon:pt.shapeIconButtonFlipVertical,hideLabel:!0}],Y&&["Button","to-front",{onclick:br,label:pt.shapeTitleButtonMoveToFront,icon:pt.shapeIconButtonMoveToFront,hideLabel:!0,disabled:se[se.length-1]===H}],q&&["Button","duplicate",{onclick:yr,label:pt.shapeTitleButtonDuplicate,icon:pt.shapeIconButtonDuplicate,shortcut:["CMD","D"],hideLabel:!0}],X&&["Button","remove",{onclick:$r,label:pt.shapeTitleButtonRemove,icon:pt.shapeIconButtonRemove,shortcut:["Backspace"],hideLabel:!0}]].filter(Boolean)],Z&&j&&["div","gamma",{class:"PinturaShapeControlsGroup"},[["Button","text-layout",{onclick:dr,label:localize(Cr,pt,n),icon:localize(Sr,pt,n),hideLabel:!0}]]],Z&&["div","delta",{class:"PinturaShapeControlsGroup"},[["Button","edit-text",{label:pt.shapeLabelInputText,onclick:pr}]]]].filter(Boolean),u))):[]),64&e.$$.dirty[0]|1073741824&e.$$.dirty[5]&&o(21,ae=se.filter(shapeCanSelect).filter((e=>e.id)).filter((e=>!shapeIsDraft(e))).map((e=>({id:e.id,color:shapeIsText(e)?e.color:shapeIsLine(e)?e.strokeColor:e.backgroundColor,name:e.name||pt[`shapeLabelTool${capitalizeFirstLetter(shapeGetDescription(e))}`]}))))},[fe,$e,ye,ke,Ae,ut,pt,lo,or,vr,u,F,v,p,f,_,S,$,le,wr,Pr,ae,ie,re,oe,B,W,V,R,T,b,bt,Rt,e=>{const{origin:t}=e.detail,r=ct&&ue.includes(16);Co=void 0,o(143,xo=void 0),vo=void 0,So=void 0,wo=!1,_o=void 0,To=!1,Et(),clearTimeout(yo),yo=setTimeout((()=>o(144,ko=!0)),250);const s=Gt();if(!s||shapeIsPath(s)&&hasProp(s,"pathClose")||qt(),bo=rt(vectorClone(t)),s&&shapeIsPath(s)&&hasProp(s,"pathClose"))return Fe(e);const l=fo(se,bo,at,(e=>shapeCanSelect(e))),c=l.length&&l.shift();if(n&&shapeIsTextEditing(n)&&(ir(),lt&&(To=!0)),!c&&n&&shapeIsTextEditing(n)&&co(n),!ot(t))return;if(c&&shapeIsSelected(c))return wo=!0,o(143,xo=c),a?(r&&co(c),void Ro(i)):(vo=shapeDeepCopy(xo),void(So=shapeComputeDisplay(shapeDeepCopy(xo),Te)));_o=c||void 0;if(!Fe(e)&&c){if(lo(c,!0,r),o(143,xo=c),a)return Ro(i);vo=shapeDeepCopy(xo),So=shapeComputeDisplay(shapeDeepCopy(xo),Te)}},e=>{Po(),Oe(e)},e=>{const{translation:t,ctrlKey:o,metaKey:n,shiftKey:a,position:s}=e.detail;if(xo){if(!shapeCanMove(xo))return;if(shapeIsTextEditing(xo))return;if(a){let e=Math.abs(t.x),o=Math.abs(t.y);"x"===Io&&(o-=64),"y"===Io&&(e-=64),e>o?(t.y=0,Io="x"):o>e&&(t.x=0,Io="y")}else Io=null;const e=o||n;if(Co){if(!i.every(shapeCanMove))return;return void Co.forEach((({shape:e,shapeOriginComputed:o})=>{Nt(e,o,t,{...$t(0,gt,r,e)})}))}return Nt(xo,So,t,{...$t(e?0:dt,gt,r,xo)})}Le(e)},e=>{if(Po(),xo){if(a)return;if(shapeIsTextEditing(xo)&&ar(),e.detail.isTap&&shapeIsPath(xo)&&shapeCanAddPoint(xo)){const{position:t}=e.detail,o=rt(vectorClone(t));return void((e,t)=>{const o=e.points,r=[];for(let e=0;e<o.length-1;e++)r.push([o[e],o[e+1]]);r.push([o[o.length-1],o[0]]);const n=r.findIndex((([e,o])=>circleOverlapsWithLine(t,6,e,o)));let i;const a=[];for(let e=0;e<r.length;e++)a.push(r[e][0]),e===n&&(i=e+1,a.push(t));Kt(e,{points:a,selectedPoint:i})})(xo,o)}e.detail.isTap&&wo&&shapeIsText(xo)&&!1!==shapeCanInput(xo)&&uo(xo)}else De(e)},e=>{const t=_o&&e.detail.isTap,r=ct&&ue.includes(16);if(e.detail.isTap&&setTimeout((()=>{Xe({target:xo||_o,position:bo},0)})),xo)return He(xo),shapeEqual(xo,vo)||Ne(xo),void o(143,xo=void 0);let n=!0;if(!r){const e=so();n=!e||Ke(e,_o||void 0),n&&ao({storePrevious:!1})}ze(e),n&&t&&lo(_o,!0,r)},Yo,e=>{o(144,ko=!0),o(143,xo=n),So=p},e=>{if(!xo)return void o(144,ko=!1);const{translation:t,indexes:n,shiftKey:i,ctrlKey:a,metaKey:s,isNudge:l}=e.detail;((e,t,o,r,n)=>{const{shiftKey:i,snapThreshold:a=0,gridSize:s=0,gridRect:l,snapTargets:c=[]}=n||{},u=a?(e,t,o)=>{const{snapTranslation:r,snapLines:n}=Ot(Dt(e),c,a,s,l);Bt(t,r),It(n);const i=Ft(o(),t);e.x=i.x,e.y=i.y}:noop$1;if(shapeIsLine(e)||shapeIsPath(e)&&hasProp(e,"pathClose")){const[n]=o,a=i?kt:(e,t)=>t;let s,l,c;if(shapeIsLine(e))0===n?(s=()=>shapeLineGetStartPoint(t),l=e=>a(shapeLineGetEndPoint(t),e),c=(e,t)=>{e.x1=t.x,e.y1=t.y}):1===n&&(s=()=>shapeLineGetEndPoint(t),l=e=>a(shapeLineGetStartPoint(t),e),c=(e,t)=>{e.x2=t.x,e.y2=t.y});else{const e=t.points;s=()=>({...e[n]}),l=t=>{const o=e[arrayIndexWrap(n-1,e)],r=e[arrayIndexWrap(n+1,e)];a(o,t),a(r,t)},c=(e,t)=>e.points=e.points.map(((e,o)=>n===o?t:e))}const p=Ft(s(),r);u(p,r,s),l(p),c(e,p)}else if(shapeHasSize(e)||shapeIsEllipse(e)||shapeIsTextBox(e)){let i,a,s=!1;if(shapeIsEllipse(e))i=rectCreateFromEllipse(t);else if(shapeHasSize(e))i=rectCreateFromAny(t);else{s=!0,i=rectCreateFromAny(t);const e=textToSize(t.text,t);i.height=e.height}e.aspectRatio?a=e.aspectRatio:n.shiftKey&&!s&&(a=i.width/i.height);const l=rectCreateFromAny(i),c=rectCenter(l),p=e.rotation,d=rectGetCorners(l),h=rectRotate(l,p);if(1===o.length){let t=o[0];e.flipX&&(t=Vt[t]),e.flipY&&(t=Wt[t]);const[n,i,s,l]=d,m=nt(h[t]),g=vectorAdd({...m},r),f=rt(g);u(f,r,(()=>rt(m)));const $=vectorCreate(f.x-h[t].x,f.y-h[t].y),b=vectorRotate(vectorClone($),-p),y=vectorCreate(d[t].x+b.x,d[t].y+b.y);let _;0===t&&(_=s),1===t&&(_=l),2===t&&(_=n),3===t&&(_=i);const x=rectCreateFromPoints([_,y]);if(a){const{width:e,height:t}=rectContainRect(x,a),[o,r,n,i]=rectToBounds(x);x.width=e,x.height=t,y.y<_.y&&(x.y=n-t),y.x<_.x&&(x.x=r-e)}const v=rectRotate(x,p,c),S=vectorCenter(v),C=vectorRotate(v[0],-p,S),w=vectorRotate(v[2],-p,S),T=rectCreateFromPoints([C,w]);Tt(e,shapeIsEllipse(e)?ellipseCreateFromRect(T):T,Te)}else{o=o.map((t=>(e.flipX&&(t=Vt[t]),e.flipY&&(t=Wt[t]),t)));const[t,n]=o.map((e=>h[e])),i={x:t.x+.5*(n.x-t.x),y:t.y+.5*(n.y-t.y)},[l,m]=o.map((e=>d[e])),[g,f]=o.map((e=>{const t=e+2;return t<4?d[t]:d[t-4]})),$={x:g.x+.5*(f.x-g.x),y:g.y+.5*(f.y-g.y)},b=nt(i),y=vectorAdd({...b},r),_=rt(y);u(_,r,(()=>rt(b)));const x=vectorCreate(_.x-i.x,_.y-i.y),v=vectorRotate(vectorClone(x),-p),S=vectorSubtract(vectorClone(l),m),C=vectorApply(S,(e=>1-Math.abs(Math.sign(e)))),w=vectorCreate(v.x*C.x,v.y*C.y);vectorAdd(l,w),vectorAdd(m,w);const T=rectCreateFromPoints(d);if(a){let e=T.width,t=T.height;0===C.y?t=e/a:e=t*a,T.width=e,T.height=t,0===C.y?T.y=$.y-.5*t:T.x=$.x-.5*e}const k=rectRotate(T,p,c),R=vectorCenter(k),P=vectorRotate(k[0],-p,R),I=vectorRotate(k[2],-p,R),E=rectCreateFromPoints([P,I]);let M;shapeIsEllipse(e)?M=ellipseCreateFromRect(E):shapeHasSize(e)?M=E:s&&(M={x:E.x,y:E.y,width:E.width}),Tt(e,M,Te)}}Yt()})(xo,So,n,t,{shiftKey:!l&&i,...$t(a||s?0:dt,gt,r,xo)}),shapeCanSelectPoint(xo)&&vectorDistanceSquared(t)>16&&Kt(xo,{selectedPoint:void 0})},e=>{if(!xo)return void o(144,ko=!1);lo(xo);const{isTap:t,translation:r,indexes:i}=e.detail;t&&(shapeCanSelectPoint(xo)&&Kt(xo,{selectedPoint:xo.selectedPoint===i[0]?void 0:i[0]}),He(xo)),o(143,xo=void 0),o(144,ko=!1),Ne(n)},e=>{Ut=Mo(p).origin,o(144,ko=!0),o(143,xo=n),So=p},e=>{if(!xo)return void o(144,ko=!1);const{translation:t,shiftKey:r}=e.detail;((e,t,o,r)=>{const n=go(shapeComputeDisplay(shapeDeepCopy(e),Te)),i=rectCenter(n),a=Ft(Ut,o);let s=vectorAngleBetween(a,i)+Math.PI/2;if(r.shiftKey){const e=Math.PI/16;s=e*Math.round(s/e)-_e%e}Tt(e,{rotation:s},Te),Yt()})(xo,0,t,{shiftKey:r})},()=>{xo?(lo(xo),o(143,xo=void 0),o(144,ko=!1),Ne(n)):o(144,ko=!1)},e=>{const{key:t}=e,o=/escape/i.test(t);if(oo())return o?(e.preventDefault(),e.stopPropagation(),co(n)):void(q&&"d"===t&&(e.metaKey||e.ctrlKey)&&(e.preventDefault(),e.stopPropagation(),_r()))},e=>{const t=shapeCanInput(n,e);return!0===t?e:t},nr,e=>{const{target:t,key:o}=e,r=t.value||t.innerText,i=t.selectionStart||0,a=t.selectionEnd||r.length,s=r.substring(0,i)+o+r.substring(a);if(shapeCanInput(n,s)!==s)return e.preventDefault()},e=>shapeIsTextBlock(n)&&/enter/i.test(e.code)&&!1!==n.disableNewline?e.preventDefault():/arrow/i.test(e.code)?e.stopPropagation():/escape/i.test(e.key)?ar():void 0,e=>{const{key:t,ctrlKey:o,altKey:r}=e;if(/enter/i.test(t)&&(o||r))return ir()},ir,ar,xr,e=>{const t=eo();t&&(t.find(shapeIsTextEditing)||t.find((e=>!shapeCanMove(e)))||t.forEach((t=>{o(143,xo=t),So=shapeComputeDisplay(shapeDeepCopy(xo),Te),Nt(xo,So,e.detail)})))},e=>{o(19,wr=!0)},({relatedTarget:e})=>{e&&e.classList.contains("shape-selector__button")||o(19,wr=!1)},e=>{if("touch"===e.pointerType||"PinturaShapeEditor"!==e.target.className)return void Ye();(ko||yo)&&Rr(void 0);const t=getEventPositionInEditor(e,ke);o(146,Tr=vectorClone(t));const r=vectorApply(rt(t),(e=>Math.round(e)));if(vectorEqual(r,kr))return;if(kr=vectorClone(r),qe(ko,t,r),ko||yo)return;if(d)return;const[n]=fo(se,r,0,shapeCanSelect);n&&shapeIsDraft(n)||Rr(n)},e=>{"touch"!==e.pointerType&&Ye()},me,ge,be,_e,xe,ve,Se,Ce,we,Te,Re,Pe,Ie,Ee,Me,Fe,Le,De,ze,Oe,Be,Ne,Ve,We,Ue,He,Ge,je,qe,Xe,Ye,Ze,Ke,Je,Qe,et,tt,ot,rt,nt,it,at,st,lt,ct,dt,ht,mt,gt,yt,_t,xt,vt,St,Ct,wt,(e,t={})=>{let o,n,i,a=shapeIsEllipse(e),s=shapeIsText(e),l="relative"===t.position;const c=ft(),u=e=>{if(!dt)return e;const t=rt(e),{snapTranslation:o,snapLines:n}=Ot(Dt(t),c,dt,gt,r);return Bt(e,o),It(n),e},p=!!so(),d=t.isSelection?be:$e,h="step"===t.inputMode;if(shapeIsPath(e)){if(h){let t=!1;const r=(e,o)=>{const r=_t(d),n=e&&vectorCreate(fromPercentage(e.x,Te.width),fromPercentage(e.y,Te.height)),i=n&&nt(n);ue.includes(16)&&i&&kt(i,o);const a=rt(o),s=r.points.length?r.points[0]:a,c=vectorCreate(fromPercentage(s.x,Te.width),fromPercentage(s.y,Te.height)),u=nt(c),p=vectorDistanceSquared(u,o);if(!t&&1===r.points.length&&p<36)return vt(d);if(r.points.length>2&&p<=256){r.pathClose=!0,shapeCanSelect(r)&&lo(r);const e=St(d);return void Be(e)}const h=r.strokeWidth&&r.strokeColor&&(void 0===r.strokeColor[3]||r.strokeColor[3]>0),m=vectorDistanceSquared(i,o);if(h&&r.points.length>1&&m<256){r.pathClose=!1,r.backgroundColor=[0,0,0,0],shapeCanSelect(r)&&lo(r);const e=St(d);Be(e)}else if(!(r.points.length>0&&m<100))return l?toPercentagePoint(a,Te):a};return{start:e=>{const a=_t(d),{origin:s}=e.detail;if(n=4,o=u(vectorClone(s)),i=vectorClone(o),a){const e=a.points[a.points.length-1],t=r(e,o);return t&&(a.points=[...a.points,t]),void Ct({points:a.points},d)}t=!0},update:e=>{if(!t)return;const n=_t(d);if(!n)return;const i=n.points[0],a=r(i,vectorCreate(o.x+e.detail.translation.x,o.y+e.detail.translation.y));a&&(n.points[1]=a,Ct({points:n.points},d))},release:e=>e.detail.preventInertia(),cancel:()=>{vt(d)},end:r=>{if(!t)return;const n=rt(o),i=l?toPercentagePoint(n,Te):n,{isTap:a}=r.detail;if(a){if(fo(se,n,0,shapeCanSelect).length)return vt(d)}xt({...e,points:[i]},d)}}}return{start:t=>{const{origin:r}=t.detail;n=4,o=vectorClone(r),i=vectorClone(o);const a=rt(o),s=l?toPercentagePoint(a,Te):a;xt({...e,points:[s]},d)},update:e=>{const t=_t(d);if(!t)return;const{translation:r}=e.detail,a=vectorCreate(o.x+r.x,o.y+r.y),s=vectorDistance(i,a);if(fixPrecision(s,5)<=n)return;const c=vectorAngleBetween(a,i),u=n-s;i.x+=u*Math.cos(c),i.y+=u*Math.sin(c);const p=rt(i),h=l?toPercentagePoint(p,Te):p;Ct({points:t.points.concat(h)},d)},release:e=>e.detail.preventInertia(),cancel:()=>{vt(d)},end:e=>{const t=_t(d);if(!t)return;if(e.detail.isTap){let e=!1;if(t.bitmap?(_o&&(e=!0),p&&(e=!0)):e=!0,e)return vt(d)}const o=St(d);Be(o)}}}return a||s||shapeIsRect(e)?{start:t=>{const{origin:r}=t.detail;o=u(vectorClone(r));const n=rt(o),i=l?toPercentagePoint(n,Te):n,s=-1*Pt(_e,xe,ve),c={...e,rotation:s,...i};c.flipX=xe,c.flipY=ve,delete c.position,c.opacity=0;(a?["rx","ry"]:["width","height"]).forEach((e=>{c[e]=l?"0%":0})),xt(c,d)},update:e=>{const t=_t(d);if(!t)return;t.opacity=1;let{aspectRatio:r}=t,{translation:n,shiftKey:i,ctrlKey:s}=e.detail;!r&&i&&(r=1);const l=u(vectorCreate(o.x+n.x,o.y+n.y)),c=rt(o),p=rt(l);if(r){const e=rectCreateFromPoints([c,p]),t=rectContainRect(e,r),o=p.x<c.x?-1:1,n=p.y<c.y?-1:1;p.x=c.x+t.width*o,p.y=c.y+t.height*n}const h={x:c.x+.5*(p.x-c.x),y:c.y+.5*(p.y-c.y)},m=Pt(_e,xe,ve);vectorRotate(c,m,h),vectorRotate(p,m,h);const g=Math.min(c.x,p.x),f=Math.min(c.y,p.y);let $=Math.max(c.x,p.x)-g,b=Math.max(c.y,p.y)-f,y={};a?(s?(y.x=c.x,y.y=c.y):(y.x=g+.5*$,y.y=f+.5*b),y.rx=.5*$,y.ry=.5*b):(s?(y.x=c.x-.5*$,y.y=c.y-.5*b):(y.x=g,y.y=f),y.width=$,y.height=b),Ct(y,d,((e,t)=>Tt(e,t,Te)))},release:e=>{e.detail.preventInertia()},cancel:()=>{vt(d)},end:e=>{const t=_t(d);if(t){if(e.detail.isTap){if(shapeIsText(t)&&lt&&To)return vt(d);if(!shapeIsText(t)||!lt||_o)return vt(d);delete t.width,delete t.height,!1!==t.disableNewline&&delete t.textAlign;const e=shapeComputeDisplay({...t},Te),r=textToSize(t.text,e),n=rt({x:o.x,y:o.y-.5*r.height}),i=rt({x:o.x+r.width,y:o.y+.5*r.height}),a={x:n.x+.5*(i.x-n.x),y:n.y+.5*(i.y-n.y)},s=Pt(_e,xe,ve);vectorRotate(n,s,a),vectorRotate(i,s,a);let l=Math.min(n.x,i.x),c=Math.min(n.y,i.y);l<0&&(l=0),c<0&&(c=0),l+r.width>Te.width&&(l=Te.width-r.width),c+r.height>Te.height&&(c=Te.height-r.height),t.x=isString(t.x)?toPercentage(l,Te.width):l,t.y=isString(t.y)?toPercentage(c,Te.height):c}if(t.opacity=1,shapeIsText(t))Be(t);else{const e=St(d);Be(e)}shapeCanSelect(t)&&lo(t),shapeIsText(t)&&uo(t)}}}:shapeIsLine(e)?{start:t=>{const{origin:r}=t.detail,n=rt(u(r)),i=vectorApply(n,snapToPixel);o=vectorClone(r),xt({...e,x1:l?toPercentage(i.x,Te.width):i.x,y1:l?toPercentage(i.y,Te.height):i.y,x2:l?toPercentage(i.x,Te.width):i.x,y2:l?toPercentage(i.y,Te.height):i.y,opacity:0},d)},update:e=>{if(!_t(d))return;const{translation:t}=e.detail,r=u(vectorAdd(vectorClone(o),t));if(ue.includes(16)){const e=vectorDistance(o,r),t=vectorAngleBetween(o,r),n=Math.PI/4,i=n*Math.round(t/n);r.x=o.x+e*Math.cos(i),r.y=o.y+e*Math.sin(i)}const n=rt(r);Ct({x2:l?toPercentage(n.x,Te.width):n.x,y2:l?toPercentage(n.y,Te.height):n.y,opacity:1},d)},release:e=>e.detail.preventInertia(),cancel:()=>{vt(d)},end:e=>{const t=_t(d);if(!t)return;if(e.detail.isTap)return vt(d);t.opacity=1;const o=St(d);Be(o),shapeCanSelect(t)&&lo(o)}}:void 0},()=>{let e,t;const o=it*it,r=(e,t,r=!1)=>{const n=vectorDistanceSquared(e,t);if(!r&&n<2)return!1;const i=se.filter((e=>!e.disableErase));let a;a=n<o?fo(se,rt(t),it):$o(i,rt(e),rt(t),it);return ho(a).forEach(Ue),!0};return{start:o=>{e=vectorCreate(Math.round(o.detail.origin.x),Math.round(o.detail.origin.y)),r(e,e,!0),t=e},update:o=>{const{translation:n}=o.detail,i=vectorCreate(Math.round(e.x+n.x),Math.round(e.y+n.y));r(t,i)&&(t=vectorClone(i))},release:e=>e.detail.preventInertia(),cancel:()=>{vt(collection)},end:()=>{}}},Gt,jt,e=>{if(!Gt())return shapeMakeDraft(e),wt(e)},qt,Xt,(e={})=>({id:getUniqueId(),...e}),Yt,Zt,Kt,Jt,(e,t,o=!0)=>{se.forEach((o=>Jt(o,e,t,!1))),o&&Yt()},Qt,eo,to,oo,ao,co,uo,po,ho,mo,go,fo,$o,Mt,At,xo,ko,Bo,Tr,d,Z,n,j,X,q,H,Y,G,K,C,ne,J,te,ee,w,Q,a,i,L,c,D,N,z,A,M,r,P,I,E,m,x,k,h,l,y,g,s,se,ce,ue,pe,function(t){bubble.call(this,e,t)},e=>lo($e[e]),function(e){binding_callbacks[e?"unshift":"push"]((()=>{or=e,o(8,or)}))},function(){B=this.value,o(25,B),o(11,F),o(149,n),o(171,A),o(0,fe),o(185,se)},function(e){binding_callbacks[e?"unshift":"push"]((()=>{or=e,o(8,or)}))},()=>{Pr&&Pr.focus()},e=>o(9,vr=e.detail),function(e){binding_callbacks[e?"unshift":"push"]((()=>{Pr=e,o(20,Pr)}))},e=>getEventPositionInEditor(e,ke)]}class ShapeLayoutEditor extends SvelteComponent{constructor(e){super(),init(this,e,instance$f,create_fragment$f,safe_not_equal,{uid:59,ui:60,disabled:0,shapes:1,selection:61,offset:2,contextRotation:62,contextFlipX:63,contextFlipY:64,contextZoom:65,active:66,opacity:67,parentRect:68,rootRect:3,utilRect:69,hoverColor:70,caretColor:71,gridColor:72,snapColor:73,textInputMode:4,oninteractionstart:74,oninteractionupdate:75,oninteractionrelease:76,oninteractionend:77,oninteractioncancel:78,onaddshape:79,onupdateshape:80,onselectshape:81,onblurshape:82,onremoveshape:83,ontapshape:84,onhovershape:85,ontriggerhistorywrite:86,onhovercanvas:87,ontapcanvas:88,onleavecanvas:89,beforeSelectShape:90,beforeDeselectShape:91,beforeRemoveShape:92,beforeUpdateShape:93,willRenderShapeControls:94,willRenderShapeTextControls:95,willStartInteraction:96,mapEditorPointToImagePoint:97,mapImagePointToEditorPoint:98,eraseRadius:99,selectRadius:100,enableButtonFlipVertical:101,enableTapToAddText:102,enableMultiSelect:103,enableTextStyleControls:5,locale:6,snapThreshold:104,snapPointer:105,enableSnapToContext:106,gridSize:107,syncShapeCollection:108,getShapeDraft:109,addShapeDraft:110,discardShapeDraft:111,confirmShapeDraft:112,updateShapeDraft:113,addShape:114,createShape:115,eraseShape:116,getMarkupItemDraft:117,getMarkupItemDraftIndex:118,addMarkupItemDraft:119,confirmMarkupItemDraft:120,discardMarkupItemDraft:121,createMarkupItem:122,syncShapes:123,removeMarkupShapeProps:124,updateMarkupShape:125,updateMarkupShapeProperty:126,updateMarkupItemsShapeProperty:127,updateMarkupShapeItems:128,getActiveMarkupItems:129,getActiveMarkupItem:130,hasActiveMarkupItem:131,blurShapes:132,selectShape:7,deselectMarkupItem:133,editMarkupItem:134,finishEditMarkupItem:135,removeMarkupItems:136,getTextShapeRect:137,getMarkupShapeRect:138,getShapesNearPosition:139,getShapesBetweenPoints:140},null,[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])}get syncShapeCollection(){return this.$$.ctx[108]}get getShapeDraft(){return this.$$.ctx[109]}get addShapeDraft(){return this.$$.ctx[110]}get discardShapeDraft(){return this.$$.ctx[111]}get confirmShapeDraft(){return this.$$.ctx[112]}get updateShapeDraft(){return this.$$.ctx[113]}get addShape(){return this.$$.ctx[114]}get createShape(){return this.$$.ctx[115]}get eraseShape(){return this.$$.ctx[116]}get getMarkupItemDraft(){return this.$$.ctx[117]}get getMarkupItemDraftIndex(){return this.$$.ctx[118]}get addMarkupItemDraft(){return this.$$.ctx[119]}get confirmMarkupItemDraft(){return this.$$.ctx[120]}get discardMarkupItemDraft(){return this.$$.ctx[121]}get createMarkupItem(){return this.$$.ctx[122]}get syncShapes(){return this.$$.ctx[123]}get removeMarkupShapeProps(){return this.$$.ctx[124]}get updateMarkupShape(){return this.$$.ctx[125]}get updateMarkupShapeProperty(){return this.$$.ctx[126]}get updateMarkupItemsShapeProperty(){return this.$$.ctx[127]}get updateMarkupShapeItems(){return this.$$.ctx[128]}get getActiveMarkupItems(){return this.$$.ctx[129]}get getActiveMarkupItem(){return this.$$.ctx[130]}get hasActiveMarkupItem(){return this.$$.ctx[131]}get blurShapes(){return this.$$.ctx[132]}get selectShape(){return this.$$.ctx[7]}get deselectMarkupItem(){return this.$$.ctx[133]}get editMarkupItem(){return this.$$.ctx[134]}get finishEditMarkupItem(){return this.$$.ctx[135]}get removeMarkupItems(){return this.$$.ctx[136]}get getTextShapeRect(){return this.$$.ctx[137]}get getMarkupShapeRect(){return this.$$.ctx[138]}get getShapesNearPosition(){return this.$$.ctx[139]}get getShapesBetweenPoints(){return this.$$.ctx[140]}}function create_else_block$4(e){let t,o,r;return o=new DynamicComponentTree_1({props:{items:e[2]}}),{c(){t=element("ul"),create_component(o.$$.fragment),attr(t,"class","PinturaShapeStyleList")},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,t){const r={};4&t&&(r.items=e[2]),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function create_if_block$4(e){let t,o;return t=new Scrollable({props:{class:"PinturaShapeStyles",elasticity:e[0],$$slots:{default:[create_default_slot$6]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};1&o&&(r.elasticity=e[0]),524292&o&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot$6(e){let t,o,r;return o=new DynamicComponentTree_1({props:{items:e[2]}}),{c(){t=element("ul"),create_component(o.$$.fragment),attr(t,"class","PinturaShapeStyleList")},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,t){const r={};4&t&&(r.items=e[2]),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function create_fragment$e(e){let t,o,r,n;const i=[create_if_block$4,create_else_block$4],a=[];function s(e,t){return e[1]?0:1}return o=s(e),r=a[o]=i[o](e),{c(){t=element("div"),r.c(),set_style(t,"opacity",e[5]),set_style(t,"pointer-events",e[4]),set_style(t,"visibility",e[3])},m(e,r){insert(e,t,r),a[o].m(t,null),n=!0},p(e,[n]){let l=o;o=s(e),o===l?a[o].p(e,n):(group_outros(),transition_out(a[l],1,1,(()=>{a[l]=null})),check_outros(),r=a[o],r?r.p(e,n):(r=a[o]=i[o](e),r.c()),transition_in(r,1),r.m(t,null)),32&n&&set_style(t,"opacity",e[5]),16&n&&set_style(t,"pointer-events",e[4]),8&n&&set_style(t,"visibility",e[3])},i(e){n||(transition_in(r),n=!0)},o(e){transition_out(r),n=!1},d(e){e&&detach(t),a[o].d()}}}function instance$e(e,t,o){let r,n,i,a,s,l,c,u,{isActive:p=!1}=t,{controls:d=[]}=t,{locale:h}=t,{scrollElasticity:m}=t,{scrollEnable:g=!0}=t,{hideTitles:f=!1}=t,{willRenderControls:$=passthrough}=t;const b=getContext("redrawTrigger");component_subscribe(e,b,(e=>o(16,l=e)));const y=getContext("env");component_subscribe(e,y,(e=>o(15,s=e)));const _=getContext("isAnimated");component_subscribe(e,_,(e=>o(18,u=e)));const x=spring(0,{stiffness:.25,damping:.9});return component_subscribe(e,x,(e=>o(17,c=e))),e.$$set=e=>{"isActive"in e&&o(10,p=e.isActive),"controls"in e&&o(11,d=e.controls),"locale"in e&&o(12,h=e.locale),"scrollElasticity"in e&&o(0,m=e.scrollElasticity),"scrollEnable"in e&&o(1,g=e.scrollEnable),"hideTitles"in e&&o(13,f=e.hideTitles),"willRenderControls"in e&&o(14,$=e.willRenderControls)},e.$$.update=()=>{263168&e.$$.dirty&&x.set(p?1:0,{hard:!1===u}),131072&e.$$.dirty&&o(5,r=c),1024&e.$$.dirty&&o(4,n=p?"auto":"none"),131072&e.$$.dirty&&o(3,i=c<=0?"hidden":"visible"),129024&e.$$.dirty&&o(2,a=l&&$(d.map((e=>["ShapeStyle",e.id,{title:e.componentProps.title,locale:h,hideTitle:f,items:[[e.component,e.id,e.componentProps]]}])),s,(()=>b.set({}))))},[m,g,a,i,n,r,b,y,_,x,p,d,h,f,$,s,l,c,u]}class ShapeStyleControls extends SvelteComponent{constructor(e){super(),init(this,e,instance$e,create_fragment$e,safe_not_equal,{isActive:10,controls:11,locale:12,scrollElasticity:0,scrollEnable:1,hideTitles:13,willRenderControls:14})}}function get_each_context(e,t,o){const r=e.slice();return r[15]=t[o].key,r[6]=t[o].controls,r[16]=t[o].isActive,r}function create_each_block(e,t){let o,r,n;return r=new ShapeStyleControls({props:{isActive:t[16],controls:t[6],locale:t[1],scrollElasticity:t[2],scrollEnable:t[3],hideTitles:t[4],willRenderControls:t[5]}}),{key:e,first:null,c(){o=empty(),create_component(r.$$.fragment),this.first=o},m(e,t){insert(e,o,t),mount_component(r,e,t),n=!0},p(e,o){t=e;const n={};128&o&&(n.isActive=t[16]),128&o&&(n.controls=t[6]),2&o&&(n.locale=t[1]),4&o&&(n.scrollElasticity=t[2]),8&o&&(n.scrollEnable=t[3]),16&o&&(n.hideTitles=t[4]),32&o&&(n.willRenderControls=t[5]),r.$set(n)},i(e){n||(transition_in(r.$$.fragment,e),n=!0)},o(e){transition_out(r.$$.fragment,e),n=!1},d(e){e&&detach(o),destroy_component(r,e)}}}function create_fragment$d(e){let t,o,r,n=[],i=new Map,a=e[7];const s=e=>e[15];for(let t=0;t<a.length;t+=1){let o=get_each_context(e,a,t),r=s(o);i.set(r,n[t]=create_each_block(r,o))}return{c(){t=element("div");for(let e=0;e<n.length;e+=1)n[e].c();attr(t,"class",o=arrayJoin(["PinturaShapeStyleEditor",!e[3]&&"PinturaShapeStyleEditorOverflow",e[0]]))},m(e,o){insert(e,t,o);for(let e=0;e<n.length;e+=1)n[e].m(t,null);r=!0},p(e,[l]){190&l&&(a=e[7],group_outros(),n=update_keyed_each(n,l,s,1,e,a,i,t,outro_and_destroy_block,create_each_block,null,get_each_context),check_outros()),(!r||9&l&&o!==(o=arrayJoin(["PinturaShapeStyleEditor",!e[3]&&"PinturaShapeStyleEditorOverflow",e[0]])))&&attr(t,"class",o)},i(e){if(!r){for(let e=0;e<a.length;e+=1)transition_in(n[e]);r=!0}},o(e){for(let e=0;e<n.length;e+=1)transition_out(n[e]);r=!1},d(e){e&&detach(t);for(let e=0;e<n.length;e+=1)n[e].d()}}}function instance$d(e,t,o){let r,n,i,{class:a}=t,{controls:s={}}=t,{shapeProps:l}=t,{onchange:c}=t,{locale:u}=t,{scrollElasticity:p}=t,{scrollEnable:d=!0}=t,{hideTitles:h=!1}=t,{willRenderControls:m}=t;const g=[];return e.$$set=e=>{"class"in e&&o(0,a=e.class),"controls"in e&&o(6,s=e.controls),"shapeProps"in e&&o(8,l=e.shapeProps),"onchange"in e&&o(9,c=e.onchange),"locale"in e&&o(1,u=e.locale),"scrollElasticity"in e&&o(2,p=e.scrollElasticity),"scrollEnable"in e&&o(3,d=e.scrollEnable),"hideTitles"in e&&o(4,h=e.hideTitles),"willRenderControls"in e&&o(5,m=e.willRenderControls)},e.$$.update=()=>{64&e.$$.dirty&&o(11,r=Object.keys(s).filter((e=>s[e]))),2304&e.$$.dirty&&o(10,n=l&&Object.keys(l).length&&r&&shapeCanStyle(l)?(e=>{const t=r.filter((t=>t.split("_").every((t=>hasProp(e,t)&&shapeCanStyle(e,t))))).map((t=>{const o=(e.settings&&e.settings[t]||{}).control||t,r=t.split("_"),n=r.length>1?r.map((t=>e[t])):e[t];if(isFunction(s[o])){const{title:r,component:i}=s[o](n,(e=>{c({[t]:e})}),{selectedShapeId:e.id});return{id:o,component:DynamicComponentTree_1,componentProps:{title:r,items:i}}}let[i,a]=s[o];if(isString(i)&&s[i]){const e={...a};[i,a]=s[i],a={...a,...e}}const l=isFunction(a.options)?a.options(e):a.options;return"RadioGroup"===i&&(a.selectedIndex=-1),{id:o,component:i,componentProps:{...a,options:l,locale:u,value:n,optionLabelClass:"PinturaButtonLabel",onchange:o=>{const n=isObject(o)&&!isArray(o)?o.value:o;a.onchange&&a.onchange(n,e);const i=r.length>1?r.reduce(((e,t,o)=>({...e,[t]:Array.isArray(n)?n[o]:n})),{}):{[t]:n};c(i)}}}})).filter(Boolean);return t})(l):[]),1280&e.$$.dirty&&o(7,i=((e,t)=>{let o=g.find((t=>t.key===e));return o||(o={key:e,controls:t},g.push(o)),g.forEach((e=>e.isActive=!1)),o.controls=t,o.isActive=!0,g})(l&&Object.keys(l).length?Object.keys(l).join("_"):"none",n||[]))},[a,u,p,d,h,m,s,i,l,c,n,r]}class ShapeStyleEditor extends SvelteComponent{constructor(e){super(),init(this,e,instance$d,create_fragment$d,safe_not_equal,{class:0,controls:6,shapeProps:8,onchange:9,locale:1,scrollElasticity:2,scrollEnable:3,hideTitles:4,willRenderControls:5})}}var isSVGMarkup=e=>/<svg /.test(e);function create_if_block_6$1(e){let t,o;return t=new DynamicComponentTree_1({props:{items:e[10]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};1024&o&&(r.items=e[10]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block$3(e){let t,o,r,n;const i=[create_if_block_1$2,create_else_block$3],a=[];function s(e,t){return e[8]?0:1}return t=s(e),o=a[t]=i[t](e),{c(){o.c(),r=empty()},m(e,o){a[t].m(e,o),insert(e,r,o),n=!0},p(e,n){let l=t;t=s(e),t===l?a[t].p(e,n):(group_outros(),transition_out(a[l],1,1,(()=>{a[l]=null})),check_outros(),o=a[t],o?o.p(e,n):(o=a[t]=i[t](e),o.c()),transition_in(o,1),o.m(r.parentNode,r))},i(e){n||(transition_in(o),n=!0)},o(e){transition_out(o),n=!1},d(e){a[t].d(e),e&&detach(r)}}}function create_else_block$3(e){let t,o,r,n,i=e[10]&&create_if_block_5$1(e);return r=new Scrollable({props:{scrollAutoCancel:e[9],elasticity:e[0],$$slots:{default:[create_default_slot_5]},$$scope:{ctx:e}}}),{c(){t=element("div"),i&&i.c(),o=space(),create_component(r.$$.fragment),attr(t,"class","PinturaShapePresetsFlat")},m(e,a){insert(e,t,a),i&&i.m(t,null),append(t,o),mount_component(r,t,null),n=!0},p(e,n){e[10]?i?(i.p(e,n),1024&n&&transition_in(i,1)):(i=create_if_block_5$1(e),i.c(),transition_in(i,1),i.m(t,o)):i&&(group_outros(),transition_out(i,1,1,(()=>{i=null})),check_outros());const a={};512&n&&(a.scrollAutoCancel=e[9]),1&n&&(a.elasticity=e[0]),536871070&n&&(a.$$scope={dirty:n,ctx:e}),r.$set(a)},i(e){n||(transition_in(i),transition_in(r.$$.fragment,e),n=!0)},o(e){transition_out(i),transition_out(r.$$.fragment,e),n=!1},d(e){e&&detach(t),i&&i.d(),destroy_component(r)}}}function create_if_block_1$2(e){let t,o,r,n,i;o=new Scrollable({props:{elasticity:e[0],class:"PinturaShapePresetsGroups",$$slots:{default:[create_default_slot_2$1]},$$scope:{ctx:e}}});const a=[{class:"PinturaControlPanels"},{panelClass:"PinturaControlPanel"},{panels:e[11]},e[12]];let s={$$slots:{default:[create_default_slot$5,({panel:e,panelIsActive:t})=>({26:e,27:t}),({panel:e,panelIsActive:t})=>(e?67108864:0)|(t?134217728:0)]},$$scope:{ctx:e}};for(let e=0;e<a.length;e+=1)s=assign(s,a[e]);return n=new TabPanels({props:s}),{c(){t=element("div"),create_component(o.$$.fragment),r=space(),create_component(n.$$.fragment),attr(t,"class","PinturaShapePresetsGrouped")},m(e,a){insert(e,t,a),mount_component(o,t,null),append(t,r),mount_component(n,t,null),i=!0},p(e,t){const r={};1&t&&(r.elasticity=e[0]),536876128&t&&(r.$$scope={dirty:t,ctx:e}),o.$set(r);const i=6144&t?get_spread_update(a,[a[0],a[1],2048&t&&{panels:e[11]},4096&t&&get_spread_object(e[12])]):{};738206239&t&&(i.$$scope={dirty:t,ctx:e}),n.$set(i)},i(e){i||(transition_in(o.$$.fragment,e),transition_in(n.$$.fragment,e),i=!0)},o(e){transition_out(o.$$.fragment,e),transition_out(n.$$.fragment,e),i=!1},d(e){e&&detach(t),destroy_component(o),destroy_component(n)}}}function create_if_block_5$1(e){let t,o;return t=new DynamicComponentTree_1({props:{items:e[10]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};1024&o&&(r.items=e[10]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_5(e){let t,o;return t=new ImageButtonList({props:{items:e[7],onclickitem:e[1],ongrabitem:e[2],ondragitem:e[3],ondropitem:e[4]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};128&o&&(r.items=e[7]),2&o&&(r.onclickitem=e[1]),4&o&&(r.ongrabitem=e[2]),8&o&&(r.ondragitem=e[3]),16&o&&(r.ondropitem=e[4]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_4$1(e){let t,o;return t=new DynamicComponentTree_1({props:{items:e[10]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};1024&o&&(r.items=e[10]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_3$1(e){let t,o;return t=new Icon({props:{$$slots:{default:[create_default_slot_4$1]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};805306368&o&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_4$1(e){let t,o=e[28].icon+"";return{c(){t=svg_element("g")},m(e,r){insert(e,t,r),t.innerHTML=o},p(e,r){268435456&r&&o!==(o=e[28].icon+"")&&(t.innerHTML=o)},d(e){e&&detach(t)}}}function create_if_block_2$2(e){let t,o,r=e[28].label+"";return{c(){t=element("span"),o=text(r)},m(e,r){insert(e,t,r),append(t,o)},p(e,t){268435456&t&&r!==(r=e[28].label+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_default_slot_3$1(e){let t,o,r,n=e[28].icon&&create_if_block_3$1(e),i=!e[28].hideLabel&&create_if_block_2$2(e);return{c(){n&&n.c(),t=space(),i&&i.c(),o=empty()},m(e,a){n&&n.m(e,a),insert(e,t,a),i&&i.m(e,a),insert(e,o,a),r=!0},p(e,r){e[28].icon?n?(n.p(e,r),268435456&r&&transition_in(n,1)):(n=create_if_block_3$1(e),n.c(),transition_in(n,1),n.m(t.parentNode,t)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),e[28].hideLabel?i&&(i.d(1),i=null):i?i.p(e,r):(i=create_if_block_2$2(e),i.c(),i.m(o.parentNode,o))},i(e){r||(transition_in(n),r=!0)},o(e){transition_out(n),r=!1},d(e){n&&n.d(e),e&&detach(t),i&&i.d(e),e&&detach(o)}}}function create_default_slot_2$1(e){let t,o,r,n=e[10]&&create_if_block_4$1(e);const i=[{class:"PinturaControlList"},{tabs:e[5]},e[12],{layout:"compact"}];let a={$$slots:{default:[create_default_slot_3$1,({tab:e})=>({28:e}),({tab:e})=>e?268435456:0]},$$scope:{ctx:e}};for(let e=0;e<i.length;e+=1)a=assign(a,i[e]);return o=new TabList({props:a}),o.$on("select",e[18]),{c(){n&&n.c(),t=space(),create_component(o.$$.fragment)},m(e,i){n&&n.m(e,i),insert(e,t,i),mount_component(o,e,i),r=!0},p(e,r){e[10]?n?(n.p(e,r),1024&r&&transition_in(n,1)):(n=create_if_block_4$1(e),n.c(),transition_in(n,1),n.m(t.parentNode,t)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros());const a=4128&r?get_spread_update(i,[i[0],32&r&&{tabs:e[5]},4096&r&&get_spread_object(e[12]),i[3]]):{};805306368&r&&(a.$$scope={dirty:r,ctx:e}),o.$set(a)},i(e){r||(transition_in(n),transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(n),transition_out(o.$$.fragment,e),r=!1},d(e){n&&n.d(e),e&&detach(t),destroy_component(o,e)}}}function create_default_slot_1$1(e){let t,o;return t=new ImageButtonList({props:{items:e[13][e[26]].items,disabled:e[13][e[26]].disabled,onclickitem:e[1],ongrabitem:e[2],ondragitem:e[3],ondropitem:e[4]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};67117056&o&&(r.items=e[13][e[26]].items),67117056&o&&(r.disabled=e[13][e[26]].disabled),2&o&&(r.onclickitem=e[1]),4&o&&(r.ongrabitem=e[2]),8&o&&(r.ondragitem=e[3]),16&o&&(r.ondropitem=e[4]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot$5(e){let t,o;return t=new Scrollable({props:{scroll:e[27]?{scrollOffset:0,animate:!1}:void 0,scrollAutoCancel:e[9],elasticity:e[0],$$slots:{default:[create_default_slot_1$1]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};134217728&o&&(r.scroll=e[27]?{scrollOffset:0,animate:!1}:void 0),512&o&&(r.scrollAutoCancel=e[9]),1&o&&(r.elasticity=e[0]),603987998&o&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_fragment$c(e){let t,o,r,n;const i=[create_if_block$3,create_if_block_6$1],a=[];function s(e,t){return e[9]?0:e[10]?1:-1}return~(o=s(e))&&(r=a[o]=i[o](e)),{c(){t=element("div"),r&&r.c(),attr(t,"class","PinturaShapePresetsPalette")},m(e,r){insert(e,t,r),~o&&a[o].m(t,null),n=!0},p(e,[n]){let l=o;o=s(e),o===l?~o&&a[o].p(e,n):(r&&(group_outros(),transition_out(a[l],1,1,(()=>{a[l]=null})),check_outros()),~o?(r=a[o],r?r.p(e,n):(r=a[o]=i[o](e),r.c()),transition_in(r,1),r.m(t,null)):r=null)},i(e){n||(transition_in(r),n=!0)},o(e){transition_out(r),n=!1},d(e){e&&detach(t),~o&&a[o].d()}}}function instance$c(e,t,o){let r,n,i,a,s,l,c,u,p,{locale:d}=t,{presets:h}=t,{scrollElasticity:m}=t,{enableSelectImage:g=!0}=t,{willRenderPresetToolbar:f=passthrough}=t,{onaddpreset:$=noop$1}=t,{ongrabpreset:b}=t,{ondragpreset:y}=t,{ondroppreset:_}=t;const x=`presets-${getUniqueId()}`,v=(e,t="")=>isSVGMarkup(e)?e:isEmoji(e)?getEmojiSVG(e,t):`<img src="${e}" alt="${t}"/>`,S=e=>getFilenameWithoutExtension(getFilenameFromURL(e)),C=["src","alt","thumb","shape","id","mount","disabled"],w=e=>e.map((e=>(e=>isArray(e)&&isString(e[0])&&isArray(e[1]))(e)?{...e[2],id:`${x}-${e[0].toLowerCase()}`,label:e[0],items:w(e[1])}:(e=>{let t,o,r,n,i,a,s,l=e;return isString(e)?isEmoji(e)?(t=e,i=e,n=v(t,i)):(t=e,i=S(t),n=v(t,i)):(t=e.src,i=e.alt||(isString(t)?S(t):isString(e.thumb)?S(e.thumb):void 0),n=v(e.thumb||t,i),o=e.shape,a=e.mount,s=e.disabled,r=Object.keys(e).reduce(((t,o)=>(C.includes(o)||(t[o]=e[o]),t)),{})),{id:l,src:t,thumb:n,shape:o,shapeProps:r,alt:i,title:i,mount:a,disabled:s}})(e)));return e.$$set=e=>{"locale"in e&&o(14,d=e.locale),"presets"in e&&o(15,h=e.presets),"scrollElasticity"in e&&o(0,m=e.scrollElasticity),"enableSelectImage"in e&&o(16,g=e.enableSelectImage),"willRenderPresetToolbar"in e&&o(17,f=e.willRenderPresetToolbar),"onaddpreset"in e&&o(1,$=e.onaddpreset),"ongrabpreset"in e&&o(2,b=e.ongrabpreset),"ondragpreset"in e&&o(3,y=e.ondragpreset),"ondroppreset"in e&&o(4,_=e.ondroppreset)},e.$$.update=()=>{32768&e.$$.dirty&&o(7,r=w(h)),128&e.$$.dirty&&o(9,n=r.length),640&e.$$.dirty&&o(8,i=n&&r.some((e=>!!e.items))),384&e.$$.dirty&&o(5,a=i&&r),384&e.$$.dirty&&o(13,s=i&&r.reduce(((e,t)=>(e[t.id]=t,e)),{})),96&e.$$.dirty&&o(6,l=l||a&&(a.find((e=>!e.disabled))||{}).id),64&e.$$.dirty&&o(12,c={name:x,selected:l}),32&e.$$.dirty&&o(11,u=a&&a.map((e=>e.id))),212994&e.$$.dirty&&o(10,p=d&&f([g&&["Button","browse",{label:d.shapeLabelButtonSelectSticker,icon:d.shapeIconButtonSelectSticker,onclick:()=>{browse().then((e=>{e&&$(e)}))}}]]))},[m,$,b,y,_,a,l,r,i,n,p,u,c,s,d,h,g,f,({detail:e})=>o(6,l=e)]}class ShapePresetsPalette extends SvelteComponent{constructor(e){super(),init(this,e,instance$c,create_fragment$c,safe_not_equal,{locale:14,presets:15,scrollElasticity:0,enableSelectImage:16,willRenderPresetToolbar:17,onaddpreset:1,ongrabpreset:2,ondragpreset:3,ondroppreset:4})}}var createPingDispatcher=e=>(t,o)=>{e.dispatchEvent(createPing(t,o))};function create_default_slot_4(e){let t,o,r,n;return t=new DynamicComponentTree_1({props:{items:e[30]}}),r=new ShapeStyleEditor({props:{locale:e[4],shapeProps:e[49],onchange:e[85],controls:e[9],scrollEnable:!1,hideTitles:!0,willRenderControls:e[165]}}),{c(){create_component(t.$$.fragment),o=space(),create_component(r.$$.fragment)},m(e,i){mount_component(t,e,i),insert(e,o,i),mount_component(r,e,i),n=!0},p(e,o){const n={};1073741824&o[0]&&(n.items=e[30]),t.$set(n);const i={};16&o[0]&&(i.locale=e[4]),262144&o[1]&&(i.shapeProps=e[49]),512&o[0]&&(i.controls=e[9]),r.$set(i)},i(e){n||(transition_in(t.$$.fragment,e),transition_in(r.$$.fragment,e),n=!0)},o(e){transition_out(t.$$.fragment,e),transition_out(r.$$.fragment,e),n=!1},d(e){destroy_component(t,e),e&&detach(o),destroy_component(r,e)}}}function create_header_slot(e){let t,o,r;return o=new Toolbar({props:{$$slots:{default:[create_default_slot_4]},$$scope:{ctx:e}}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"slot","header")},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,t){const r={};1073742352&t[0]|262144&t[1]|134217728&t[6]&&(r.$$scope={dirty:t,ctx:e}),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function create_if_block_11(e){let t,o;const r=[{locale:e[4]},{ui:e[69]},{shapes:e[5]},{selection:e[58]},{uid:e[20]},{parentRect:e[37]},{rootRect:e[55]},{utilRect:e[39]},{offset:e[50]},{disabled:e[38]},{contextRotation:e[23]},{contextFlipX:e[24]},{contextFlipY:e[25]},{contextZoom:e[36]?e[36].scale:void 0},{active:e[35]},{opacity:e[56]},{hoverColor:e[57]},{caretColor:e[57]},{snapColor:e[57]},{gridColor:[1,1,1,.125]},{eraseRadius:e[47]},{selectRadius:e[6]},{enableButtonFlipVertical:e[10]},{enableMultiSelect:e[14]},{mapEditorPointToImagePoint:e[21]},{mapImagePointToEditorPoint:e[22]},{enableTapToAddText:e[13]},{textInputMode:e[8]},{snapThreshold:e[16]},{snapPointer:!e[48]},{enableSnapToContext:e[17]},{gridSize:e[15]},{willStartInteraction:e[95]},{oninteractionstart:e[79]},{oninteractionupdate:e[80]},{oninteractionrelease:e[81]},{oninteractionend:e[83]},{oninteractioncancel:e[82]},{onleavecanvas:e[87]},{onhovercanvas:e[86]},{onhovershape:e[89]},{ontapcanvas:e[88]},{onaddshape:e[156]},{onselectshape:e[157]},{onblurshape:e[158]},{ontapshape:e[159]},{onupdateshape:e[160]},{onremoveshape:e[161]},{ontriggerhistorywrite:e[162]},e[42]];let n={};for(let e=0;e<r.length;e+=1)n=assign(n,r[e]);return t=new ShapeLayoutEditor({props:n}),e[163](t),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const n=66315632&o[0]|252381681&o[1]|255721600&o[2]|12&o[3]?get_spread_update(r,[16&o[0]&&{locale:e[4]},128&o[2]&&{ui:e[69]},32&o[0]&&{shapes:e[5]},134217728&o[1]&&{selection:e[58]},1048576&o[0]&&{uid:e[20]},64&o[1]&&{parentRect:e[37]},16777216&o[1]&&{rootRect:e[55]},256&o[1]&&{utilRect:e[39]},524288&o[1]&&{offset:e[50]},128&o[1]&&{disabled:e[38]},8388608&o[0]&&{contextRotation:e[23]},16777216&o[0]&&{contextFlipX:e[24]},33554432&o[0]&&{contextFlipY:e[25]},32&o[1]&&{contextZoom:e[36]?e[36].scale:void 0},16&o[1]&&{active:e[35]},33554432&o[1]&&{opacity:e[56]},67108864&o[1]&&{hoverColor:e[57]},67108864&o[1]&&{caretColor:e[57]},67108864&o[1]&&{snapColor:e[57]},r[19],65536&o[1]&&{eraseRadius:e[47]},64&o[0]&&{selectRadius:e[6]},1024&o[0]&&{enableButtonFlipVertical:e[10]},16384&o[0]&&{enableMultiSelect:e[14]},2097152&o[0]&&{mapEditorPointToImagePoint:e[21]},4194304&o[0]&&{mapImagePointToEditorPoint:e[22]},8192&o[0]&&{enableTapToAddText:e[13]},256&o[0]&&{textInputMode:e[8]},65536&o[0]&&{snapThreshold:e[16]},131072&o[1]&&{snapPointer:!e[48]},131072&o[0]&&{enableSnapToContext:e[17]},32768&o[0]&&{gridSize:e[15]},4&o[3]&&{willStartInteraction:e[95]},131072&o[2]&&{oninteractionstart:e[79]},262144&o[2]&&{oninteractionupdate:e[80]},524288&o[2]&&{oninteractionrelease:e[81]},2097152&o[2]&&{oninteractionend:e[83]},1048576&o[2]&&{oninteractioncancel:e[82]},33554432&o[2]&&{onleavecanvas:e[87]},16777216&o[2]&&{onhovercanvas:e[86]},134217728&o[2]&&{onhovershape:e[89]},67108864&o[2]&&{ontapcanvas:e[88]},1&o[1]|8&o[3]&&{onaddshape:e[156]},1&o[1]&&{onselectshape:e[157]},1&o[1]&&{onblurshape:e[158]},1&o[1]&&{ontapshape:e[159]},1&o[1]|8&o[3]&&{onupdateshape:e[160]},1&o[1]|8&o[3]&&{onremoveshape:e[161]},8&o[3]&&{ontriggerhistorywrite:e[162]},2048&o[1]&&get_spread_object(e[42])]):{};t.$set(n)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(o){e[163](null),destroy_component(t,o)}}}function create_main_slot(e){let t,o,r,n,i=e[51]&&create_if_block_11(e);return{c(){t=element("div"),i&&i.c(),attr(t,"slot","main"),set_style(t,"cursor",e[46])},m(a,s){insert(a,t,s),i&&i.m(t,null),e[164](t),o=!0,r||(n=[listen(t,"keydown",e[84]),action_destroyer(dropable.call(null,t)),listen(t,"dropfiles",(function(){is_function(e[12]?e[94]:noop$1)&&(e[12]?e[94]:noop$1).apply(this,arguments)})),action_destroyer(measurable.call(null,t)),listen(t,"measure",e[152])],r=!0)},p(o,r){(e=o)[51]?i?(i.p(e,r),1048576&r[1]&&transition_in(i,1)):(i=create_if_block_11(e),i.c(),transition_in(i,1),i.m(t,null)):i&&(group_outros(),transition_out(i,1,1,(()=>{i=null})),check_outros()),32768&r[1]&&set_style(t,"cursor",e[46])},i(e){o||(transition_in(i),o=!0)},o(e){transition_out(i),o=!1},d(o){o&&detach(t),i&&i.d(),e[164](null),r=!1,run_all(n)}}}function create_if_block_10(e){let t,o;return t=new ShapePresetsPalette({props:{locale:e[4],presets:e[19],enableSelectImage:e[11],willRenderPresetToolbar:e[43],onaddpreset:e[93],ongrabpreset:e[90],ondragpreset:e[91],ondroppreset:e[92],scrollElasticity:e[44]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16&o[0]&&(r.locale=e[4]),524288&o[0]&&(r.presets=e[19]),2048&o[0]&&(r.enableSelectImage=e[11]),4096&o[1]&&(r.willRenderPresetToolbar=e[43]),8192&o[1]&&(r.scrollElasticity=e[44]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_2$1(e){let t,o,r,n="stack"===e[7]&&create_if_block_8(e),i=(e[53]&&e[34]||"row"===e[7])&&create_if_block_3(e);return{c(){n&&n.c(),t=space(),i&&i.c(),o=empty()},m(e,a){n&&n.m(e,a),insert(e,t,a),i&&i.m(e,a),insert(e,o,a),r=!0},p(e,r){"stack"===e[7]?n?(n.p(e,r),128&r[0]&&transition_in(n,1)):(n=create_if_block_8(e),n.c(),transition_in(n,1),n.m(t.parentNode,t)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),e[53]&&e[34]||"row"===e[7]?i?(i.p(e,r),128&r[0]|4194312&r[1]&&transition_in(i,1)):(i=create_if_block_3(e),i.c(),transition_in(i,1),i.m(o.parentNode,o)):i&&(group_outros(),transition_out(i,1,1,(()=>{i=null})),check_outros())},i(e){r||(transition_in(n),transition_in(i),r=!0)},o(e){transition_out(n),transition_out(i),r=!1},d(e){n&&n.d(e),e&&detach(t),i&&i.d(e),e&&detach(o)}}}function create_if_block_8(e){let t,o,r,n;const i=[create_if_block_9,create_else_block$2],a=[];function s(e,t){return e[45]?0:1}return o=s(e),r=a[o]=i[o](e),{c(){t=element("div"),r.c(),attr(t,"class","PinturaControlPanels")},m(e,r){insert(e,t,r),a[o].m(t,null),n=!0},p(e,n){let l=o;o=s(e),o===l?a[o].p(e,n):(group_outros(),transition_out(a[l],1,1,(()=>{a[l]=null})),check_outros(),r=a[o],r?r.p(e,n):(r=a[o]=i[o](e),r.c()),transition_in(r,1),r.m(t,null))},i(e){n||(transition_in(r),n=!0)},o(e){transition_out(r),n=!1},d(e){e&&detach(t),a[o].d()}}}function create_else_block$2(e){let t,o,r;return o=new ShapeStyleEditor({props:{locale:e[4],shapeProps:e[49],onchange:e[85],controls:e[9],scrollElasticity:e[44],willRenderControls:e[18]}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"class","PinturaControlPanel")},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,t){const r={};16&t[0]&&(r.locale=e[4]),262144&t[1]&&(r.shapeProps=e[49]),512&t[0]&&(r.controls=e[9]),8192&t[1]&&(r.scrollElasticity=e[44]),262144&t[0]&&(r.willRenderControls=e[18]),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function create_if_block_9(e){let t,o,r;return o=new ShapePresetsPalette({props:{locale:e[4],presets:e[19],enableSelectImage:e[11],willRenderPresetToolbar:e[43],onaddpreset:e[93],ongrabpreset:e[90],ondragpreset:e[91],ondroppreset:e[92],scrollElasticity:e[44]}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"class","PinturaControlPanel")},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,t){const r={};16&t[0]&&(r.locale=e[4]),524288&t[0]&&(r.presets=e[19]),2048&t[0]&&(r.enableSelectImage=e[11]),4096&t[1]&&(r.willRenderPresetToolbar=e[43]),8192&t[1]&&(r.scrollElasticity=e[44]),o.$set(r)},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function create_if_block_3(e){let t,o;return t=new Scrollable({props:{class:"PinturaControlListScroller",elasticity:e[44],$$slots:{default:[create_default_slot_2]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};8192&o[1]&&(r.elasticity=e[44]),262801&o[0]|262154&o[1]|134217728&o[6]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_5(e){let t,o;return t=new RadioGroup({props:{locale:e[4],class:"PinturaControlList",optionClass:"PinturaControlListOption",layout:"row",options:e[32],selectedIndex:e[32].findIndex(e[153]),onchange:e[78],$$slots:{option:[create_option_slot_1,({option:e})=>({212:e}),({option:e})=>[0,0,0,0,0,0,e?67108864:0]]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16&o[0]&&(r.locale=e[4]),2&o[1]&&(r.options=e[32]),1&o[0]|2&o[1]&&(r.selectedIndex=e[32].findIndex(e[153])),16&o[0]|201326592&o[6]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_7(e){let t,o;return t=new Icon({props:{$$slots:{default:[create_default_slot_3]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16&o[0]|201326592&o[6]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_3(e){let t,o=(isFunction(e[212].icon)?e[212].icon(e[4]):e[212].icon)+"";return{c(){t=svg_element("g")},m(e,r){insert(e,t,r),t.innerHTML=o},p(e,r){16&r[0]|67108864&r[6]&&o!==(o=(isFunction(e[212].icon)?e[212].icon(e[4]):e[212].icon)+"")&&(t.innerHTML=o)},d(e){e&&detach(t)}}}function create_if_block_6(e){let t,o,r=(isFunction(e[212].label)?e[212].label(e[4]):e[212].label)+"";return{c(){t=element("span"),o=text(r)},m(e,r){insert(e,t,r),append(t,o)},p(e,t){16&t[0]|67108864&t[6]&&r!==(r=(isFunction(e[212].label)?e[212].label(e[4]):e[212].label)+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_option_slot_1(e){let t,o,r,n=e[212].icon&&create_if_block_7(e),i=!e[212].hideLabel&&create_if_block_6(e);return{c(){t=element("div"),n&&n.c(),o=space(),i&&i.c(),attr(t,"slot","option")},m(e,a){insert(e,t,a),n&&n.m(t,null),append(t,o),i&&i.m(t,null),r=!0},p(e,r){e[212].icon?n?(n.p(e,r),67108864&r[6]&&transition_in(n,1)):(n=create_if_block_7(e),n.c(),transition_in(n,1),n.m(t,o)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),e[212].hideLabel?i&&(i.d(1),i=null):i?i.p(e,r):(i=create_if_block_6(e),i.c(),i.m(t,null))},i(e){r||(transition_in(n),r=!0)},o(e){transition_out(n),r=!1},d(e){e&&detach(t),n&&n.d(),i&&i.d()}}}function create_if_block_4(e){let t,o;return t=new ShapeStyleEditor({props:{locale:e[4],shapeProps:e[49],onchange:e[85],controls:e[9],scrollEnable:!1,hideTitles:!0,willRenderControls:e[154]}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16&o[0]&&(r.locale=e[4]),262144&o[1]&&(r.shapeProps=e[49]),512&o[0]&&(r.controls=e[9]),262144&o[0]&&(r.willRenderControls=e[154]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_2(e){let t,o,r,n=e[34]&&create_if_block_5(e),i="row"===e[7]&&create_if_block_4(e);return{c(){n&&n.c(),t=space(),i&&i.c(),o=empty()},m(e,a){n&&n.m(e,a),insert(e,t,a),i&&i.m(e,a),insert(e,o,a),r=!0},p(e,r){e[34]?n?(n.p(e,r),8&r[1]&&transition_in(n,1)):(n=create_if_block_5(e),n.c(),transition_in(n,1),n.m(t.parentNode,t)):n&&(group_outros(),transition_out(n,1,1,(()=>{n=null})),check_outros()),"row"===e[7]?i?(i.p(e,r),128&r[0]&&transition_in(i,1)):(i=create_if_block_4(e),i.c(),transition_in(i,1),i.m(o.parentNode,o)):i&&(group_outros(),transition_out(i,1,1,(()=>{i=null})),check_outros())},i(e){r||(transition_in(n),transition_in(i),r=!0)},o(e){transition_out(n),transition_out(i),r=!1},d(e){n&&n.d(e),e&&detach(t),i&&i.d(e),e&&detach(o)}}}function create_if_block$2(e){let t,o;return t=new Scrollable({props:{class:"PinturaControlListScroller",elasticity:e[44],$$slots:{default:[create_default_slot$4]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};8192&o[1]&&(r.elasticity=e[44]),134217744&o[0]|8388608&o[1]|134217728&o[6]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_if_block_1$1(e){let t,o;return t=new Icon({props:{$$slots:{default:[create_default_slot_1]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16&o[0]|201326592&o[6]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_default_slot_1(e){let t,o=(isFunction(e[212].icon)?e[212].icon(e[4]):e[212].icon)+"";return{c(){t=svg_element("g")},m(e,r){insert(e,t,r),t.innerHTML=o},p(e,r){16&r[0]|67108864&r[6]&&o!==(o=(isFunction(e[212].icon)?e[212].icon(e[4]):e[212].icon)+"")&&(t.innerHTML=o)},d(e){e&&detach(t)}}}function create_option_slot$2(e){let t,o,r,n,i,a=(isFunction(e[212].label)?e[212].label(e[4]):e[212].label)+"",s=e[212].icon&&create_if_block_1$1(e);return{c(){t=element("div"),s&&s.c(),o=space(),r=element("span"),n=text(a),attr(t,"slot","option")},m(e,a){insert(e,t,a),s&&s.m(t,null),append(t,o),append(t,r),append(r,n),i=!0},p(e,r){e[212].icon?s?(s.p(e,r),67108864&r[6]&&transition_in(s,1)):(s=create_if_block_1$1(e),s.c(),transition_in(s,1),s.m(t,o)):s&&(group_outros(),transition_out(s,1,1,(()=>{s=null})),check_outros()),(!i||16&r[0]|67108864&r[6])&&a!==(a=(isFunction(e[212].label)?e[212].label(e[4]):e[212].label)+"")&&set_data(n,a)},i(e){i||(transition_in(s),i=!0)},o(e){transition_out(s),i=!1},d(e){e&&detach(t),s&&s.d()}}}function create_default_slot$4(e){let t,o;return t=new RadioGroup({props:{locale:e[4],class:"PinturaControlList",optionClass:"PinturaControlListOption",layout:"row",options:e[54],selectedIndex:e[54].findIndex(e[155]),onchange:e[77],$$slots:{option:[create_option_slot$2,({option:e})=>({212:e}),({option:e})=>[0,0,0,0,0,0,e?67108864:0]]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};16&o[0]&&(r.locale=e[4]),8388608&o[1]&&(r.options=e[54]),134217728&o[0]|8388608&o[1]&&(r.selectedIndex=e[54].findIndex(e[155])),16&o[0]|201326592&o[6]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_footer_slot$3(e){let t,o,r,n,i;const a=[create_if_block_2$1,create_if_block_10],s=[];function l(e,t){return e[52]?0:e[45]?1:-1}~(o=l(e))&&(r=s[o]=a[o](e));let c=e[33]&&create_if_block$2(e);return{c(){t=element("div"),r&&r.c(),n=space(),c&&c.c(),attr(t,"slot","footer"),set_style(t,"transform",e[40])},m(e,r){insert(e,t,r),~o&&s[o].m(t,null),append(t,n),c&&c.m(t,null),i=!0},p(e,i){let u=o;o=l(e),o===u?~o&&s[o].p(e,i):(r&&(group_outros(),transition_out(s[u],1,1,(()=>{s[u]=null})),check_outros()),~o?(r=s[o],r?r.p(e,i):(r=s[o]=a[o](e),r.c()),transition_in(r,1),r.m(t,n)):r=null),e[33]?c?(c.p(e,i),4&i[1]&&transition_in(c,1)):(c=create_if_block$2(e),c.c(),transition_in(c,1),c.m(t,null)):c&&(group_outros(),transition_out(c,1,1,(()=>{c=null})),check_outros()),512&i[1]&&set_style(t,"transform",e[40])},i(e){i||(transition_in(r),transition_in(c),i=!0)},o(e){transition_out(r),transition_out(c),i=!1},d(e){e&&detach(t),~o&&s[o].d(),c&&c.d()}}}function create_fragment$b(e){let t,o;return t=new Util({props:{hasHeader:e[41],$$slots:{footer:[create_footer_slot$3],main:[create_main_slot],header:[create_header_slot]},$$scope:{ctx:e}}}),t.$on("measure",e[166]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};1024&o[1]&&(r.hasHeader=e[41]),2080374769&o[0]|134216703&o[1]|134217728&o[6]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}let isPanning=!1;function instance$b(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,S,C,w,T,k,R,P,I,E,M,A,F,L,D,z,O,B,N,V,W,U,H,G,j,q,X,Y,Z,K,J,Q,ee,te,oe,re,ne,ie,ae,se,le,ce,ue,pe,de,he,me,ge,fe,$e=noop,be=()=>($e(),$e=subscribe(ke,(e=>o(35,q=e))),ke),ye=noop,_e=()=>(ye(),ye=subscribe(Me,(e=>o(145,K=e))),Me),xe=noop,ve=()=>(xe(),xe=subscribe(pt,(e=>o(37,ne=e))),pt),Se=noop,Ce=()=>(Se(),Se=subscribe(Pe,(e=>o(151,de=e))),Pe),we=noop,Te=()=>(we(),we=subscribe(Re,(e=>o(56,ge=e))),Re);e.$$.on_destroy.push((()=>$e())),e.$$.on_destroy.push((()=>ye())),e.$$.on_destroy.push((()=>xe())),e.$$.on_destroy.push((()=>Se())),e.$$.on_destroy.push((()=>we()));let{isActive:ke}=t;be();let{isActiveFraction:Re}=t;Te();let{isVisible:Pe}=t;Ce();let{stores:Ie}=t,{locale:Ee={}}=t,{shapes:Me}=t;_e();let{toolbar:Ae=[]}=t,{toolShapes:Fe={}}=t,{toolActive:Le}=t,{toolSelectRadius:De}=t,{toolRetainStyles:ze=!1}=t,{toolbarLayout:Oe="stack"}=t,{textInputMode:Be}=t,{shapeControls:Ne={}}=t,{enableButtonFlipVertical:Ve=!1}=t,{enablePresetSelectImage:We=!0}=t,{enablePresetDropImage:Ue=!0}=t,{enableSelectToolToAddShape:He=!1}=t,{enableAutoSelectMoveTool:Ge=["line","arrow","path","rectangle","ellipse","text"]}=t,{enableTapToAddText:je=!1}=t,{enableMoveTool:qe=!1}=t,{enableViewTool:Xe=!1}=t,{enableToolShareStyles:Ye=!0}=t,{enableMultiSelect:Ze=!1}=t,{gridSize:Ke=0}=t,{snapThreshold:Je=0}=t,{enableSnapToContext:Qe=!0}=t,{willRenderHeaderTools:et=passthrough}=t,{willRenderPresetToolbar:tt}=t,{willRenderShapeStyleControls:ot}=t,{willStartInteraction:rt}=t,{shapePresets:nt=[]}=t,{utilKey:it}=t,{mapScreenPointToImagePoint:at}=t,{mapImagePointToScreenPoint:st}=t,{imageRotation:lt=0}=t,{imageFlipX:ct=!1}=t,{imageFlipY:ut=!1}=t,{parentRect:pt}=t;ve();let{hooks:dt={}}=t;const ht=getContext("selection");component_subscribe(e,ht,(e=>o(150,ce=e)));const mt=getContext("isAnimated");component_subscribe(e,mt,(e=>o(142,X=e)));const gt=getContext("elasticityMultiplier");component_subscribe(e,gt,(e=>o(146,J=e)));const ft=getContext("ui");component_subscribe(e,ft,(e=>o(177,ue=e)));const $t=getContext("keysPressed");let bt;component_subscribe(e,$t,(e=>o(149,le=e)));const{env:yt,history:_t,rootRect:xt,rootColorSecondary:vt,enablePanInput:St,enablePanInputStatus:Ct,enableZoomInput:wt,stageRect:Tt,utilRectPadded:kt,scrollElasticity:Rt,imageOverlayMarkup:Pt,imagePreviewModifiers:It,imageCropRect:Et,shapePreprocessor:Mt,stageScalar:At,imageSelectionRect:Ft,imageTransformsInterpolated:Lt,imageSelectionPan:Dt,imageSize:zt,allowPan:Ot,allowZoom:Bt,allowZoomControls:Nt,allowPlayPause:Vt}=Ie;component_subscribe(e,yt,(e=>o(143,Y=e))),component_subscribe(e,xt,(e=>o(55,me=e))),component_subscribe(e,vt,(e=>o(57,fe=e))),component_subscribe(e,Ct,(e=>o(38,ae=e))),component_subscribe(e,Tt,(e=>o(147,Q=e))),component_subscribe(e,kt,(e=>o(39,pe=e))),component_subscribe(e,It,(e=>o(178,he=e))),component_subscribe(e,Et,(e=>o(176,ie=e))),component_subscribe(e,At,(e=>o(174,oe=e))),component_subscribe(e,Ft,(e=>o(175,re=e))),component_subscribe(e,Lt,(e=>o(36,ee=e))),component_subscribe(e,Dt,(e=>o(173,te=e))),component_subscribe(e,zt,(e=>o(148,se=e)));let Wt=0,Ut={};const Ht=e=>{const[t,o]=bt[e];let r,n,i="relative"===o.position;const a=i?"0%":0,s=i?"0%":0;shapeIsRect(t)||shapeIsText(t)?(n=i?"20%":.2*ne.width,r=shapeDeepCopy(t),r.x=a,r.y=s,shapeUpdateProps(r,{width:n,height:n},ne)):shapeIsEllipse(t)?(n=i?"10%":.1*ne.width,r=shapeDeepCopy(t),r.x=a,r.y=s,shapeUpdateProps(r,{rx:n,ry:n},ne)):shapeIsLine(t)&&(n=i?"10%":.1*ne.width,r=shapeDeepCopy(t),r.x1=a,r.y1=s,r.x2=a,r.y2=s),r&&Promise.resolve().then((()=>{io(ro(r,void 0,n))}))},Gt=e=>at(getEventPositionInEditor(e,me));let jt,qt={};let Xt;let Yt;const Zt=e=>{if(!(shapeIsPath(e)&&hasProp(e,"pathClose")))return;const t=[...e.strokeColor];t[3]=1,jt.updateMarkupShape(e,{pathClose:!1,strokeColor:t},!1),jt.removeMarkupShapeProps(e,["backgroundColor"],!1),jt.confirmMarkupItemDraft(),jt.selectShape(e),B("addshape",e),_t.write()};let Kt;const Jt=(e,t)=>{const o={};return Object.entries(e).forEach((([e,r])=>{hasProp(t,e)&&(o[e]=r)})),o},Qt=(e,t)=>{if(isNumber(e))return e;if(e.endsWith("%")){return parseFloat(e)/100*t.width}};let eo,to,oo;const ro=(e,t,o)=>{let r=!1;t||(r=!0,t=O?at(rectCenter(Q)):rectCenter(ie)),t.x-=ne.x||0,t.y-=ne.y||0,(ct||ut)&&(e.flipX=ct,e.flipY=ut);const n=jt.getShapesNearPosition(K,t);if(r&&n.length){const e=.1*Math.min(ie.width,ie.height);t.x+=Math.round(-e+Math.random()*e*2),t.y+=Math.round(-e+Math.random()*e*2)}if(0!==lt&&(e.rotation=ct&&ut?-lt:ct||ut?lt:-lt),hasProp(e,"width")&&hasProp(e,"height")){const{width:o,height:r}=shapeGetPropsPixelValues(e,["width","height"],ne);shapeUpdateProps(e,{x:t.x-.5*o,y:t.y-.5*r},ne)}else if(shapeIsEllipse(e))shapeUpdateProps(e,{x:t.x,y:t.y},ne);else if(shapeIsLine(e)){const{x1:r,y1:n,x2:i,y2:a}=shapeGetPropsPixelValues(e,["x1","y1","x2","y2"],ne),s=vectorDistance(vectorCreate(r,n),vectorCreate(i,a)),l=isString(o)?toPixelValue(o,ne.width):s;shapeUpdateProps(e,{x1:t.x-l,y1:t.y+l,x2:t.x+l,y2:t.y-l},ne)}else if(shapeIsPath(e)){const{points:o}=shapeGetPropsPixelValues(e,["points"],ne),r=vectorCenter(o);shapeUpdateProps(e,{points:o.map((e=>({x:e.x+t.x-r.x,y:e.y+t.y-r.y})))},ne)}return e},no=(e,t)=>{const o=ro(shapeCreateFromPreset(e,ie),t);return e.shape&&(hasProp(e.shape,"x")&&(o.x=e.shape.x),hasProp(e.shape,"y")&&(o.y=e.shape.y)),io(o)},io=e=>{const{beforeAddShape:t=()=>!0}=dt;if(t(e))return jt.addShape(e),jt.selectShape(e),B("addshape",e),_t.write(),e};let ao=!1;const so=()=>{_t.write()};let lo;const co=getContext("redrawTrigger");component_subscribe(e,co,(e=>o(144,Z=e)));const uo=[],po=spring(X?20:0);component_subscribe(e,po,(e=>o(141,j=e)));return e.$$set=e=>{"isActive"in e&&be(o(1,ke=e.isActive)),"isActiveFraction"in e&&Te(o(2,Re=e.isActiveFraction)),"isVisible"in e&&Ce(o(3,Pe=e.isVisible)),"stores"in e&&o(100,Ie=e.stores),"locale"in e&&o(4,Ee=e.locale),"shapes"in e&&_e(o(5,Me=e.shapes)),"toolbar"in e&&o(101,Ae=e.toolbar),"toolShapes"in e&&o(102,Fe=e.toolShapes),"toolActive"in e&&o(0,Le=e.toolActive),"toolSelectRadius"in e&&o(6,De=e.toolSelectRadius),"toolRetainStyles"in e&&o(103,ze=e.toolRetainStyles),"toolbarLayout"in e&&o(7,Oe=e.toolbarLayout),"textInputMode"in e&&o(8,Be=e.textInputMode),"shapeControls"in e&&o(9,Ne=e.shapeControls),"enableButtonFlipVertical"in e&&o(10,Ve=e.enableButtonFlipVertical),"enablePresetSelectImage"in e&&o(11,We=e.enablePresetSelectImage),"enablePresetDropImage"in e&&o(12,Ue=e.enablePresetDropImage),"enableSelectToolToAddShape"in e&&o(104,He=e.enableSelectToolToAddShape),"enableAutoSelectMoveTool"in e&&o(105,Ge=e.enableAutoSelectMoveTool),"enableTapToAddText"in e&&o(13,je=e.enableTapToAddText),"enableMoveTool"in e&&o(106,qe=e.enableMoveTool),"enableViewTool"in e&&o(107,Xe=e.enableViewTool),"enableToolShareStyles"in e&&o(108,Ye=e.enableToolShareStyles),"enableMultiSelect"in e&&o(14,Ze=e.enableMultiSelect),"gridSize"in e&&o(15,Ke=e.gridSize),"snapThreshold"in e&&o(16,Je=e.snapThreshold),"enableSnapToContext"in e&&o(17,Qe=e.enableSnapToContext),"willRenderHeaderTools"in e&&o(109,et=e.willRenderHeaderTools),"willRenderPresetToolbar"in e&&o(110,tt=e.willRenderPresetToolbar),"willRenderShapeStyleControls"in e&&o(18,ot=e.willRenderShapeStyleControls),"willStartInteraction"in e&&o(111,rt=e.willStartInteraction),"shapePresets"in e&&o(19,nt=e.shapePresets),"utilKey"in e&&o(20,it=e.utilKey),"mapScreenPointToImagePoint"in e&&o(21,at=e.mapScreenPointToImagePoint),"mapImagePointToScreenPoint"in e&&o(22,st=e.mapImagePointToScreenPoint),"imageRotation"in e&&o(23,lt=e.imageRotation),"imageFlipX"in e&&o(24,ct=e.imageFlipX),"imageFlipY"in e&&o(25,ut=e.imageFlipY),"parentRect"in e&&ve(o(26,pt=e.parentRect)),"hooks"in e&&o(112,dt=e.hooks)},e.$$.update=()=>{if(33554432&e.$$.dirty[4]&&o(124,r=le.includes(18)),1049088&e.$$.dirty[3]&&(bt&&Fe===bt||o(113,bt=Fe)),16&e.$$.dirty[1]&&Ot.set(q),16&e.$$.dirty[1]&&Bt.set(q),16&e.$$.dirty[1]&&Nt.set(q),256&e.$$.dirty[3]&&o(33,n=Array.isArray(Ae)&&Ae.length>1&&Array.isArray(Ae[0][1])),4&e.$$.dirty[1]|256&e.$$.dirty[3]&&o(54,i=n?Ae.map(((e,t)=>[t,e[0]])):[]),134217728&e.$$.dirty[0]|4&e.$$.dirty[1]|256&e.$$.dirty[3]&&o(140,a=n?Ae[Wt][1]:Ae),524288&e.$$.dirty[0]|155648&e.$$.dirty[3]|65536&e.$$.dirty[4]&&o(32,s=((e,{willRenderPresetToolbar:t,shapePresets:o,enableViewTool:r,enableMoveTool:i})=>{let a=0!==o.length||t?e:e.filter((e=>"preset"!==e[0]));return n&&(a=[["move",e=>e.shapeLabelToolMove,{icon:e=>e.shapeIconToolMove}],["view",e=>e.shapeLabelToolView,{icon:e=>e.shapeIconToolView}],...a]),a=i?a:a.filter((e=>"move"!==e[0])),r?a:a.filter((e=>"view"!==e[0]))})(a,{willRenderPresetToolbar:tt,shapePresets:nt,enableMoveTool:qe,enableViewTool:Xe})),2&e.$$.dirty[1]&&o(138,u=!!s.length),1&e.$$.dirty[0]|2&e.$$.dirty[1]|16384&e.$$.dirty[4]&&u&&void 0===Le&&o(0,Le=s[0][0]),134217729&e.$$.dirty[0]|4&e.$$.dirty[1]|2097152&e.$$.dirty[3]|65536&e.$$.dirty[4]&&n&&o(114,Ut={...Ut,[Wt]:a.map((([e])=>e)).includes(Le)?Le:Ut[Wt]||a[0][0]}),512&e.$$.dirty[0]&&o(137,l=!!Object.keys(Ne).length),2&e.$$.dirty[1]&&o(34,c=s.length>1),12&e.$$.dirty[1]&&o(53,p=c||n),1&e.$$.dirty[0]&&o(139,d=void 0!==Le),57344&e.$$.dirty[4]&&o(52,h=(!d||u)&&l),536870912&e.$$.dirty[0]&&o(31,B=lo&&createPingDispatcher(lo)),1&e.$$.dirty[0]|17&e.$$.dirty[1]&&q&&B&&B("selectcontrol",Le),16&e.$$.dirty[1]&&(q?set_store_value(It,he[it]={maskMarkupOpacity:.85},he):delete he[it]),1&e.$$.dirty[0]|1048576&e.$$.dirty[3]&&o(136,m=Le&&bt[Le]?bt[Le][1]:void 0),4096&e.$$.dirty[4]&&o(125,g=m&&m.isSelection?"selection":"shapes"),3&e.$$.dirty[4]&&(e=>{if(!jt)return;const t=jt.getShapeDraft(ht);t&&(e&&(Xt=t.drawMode),jt.updateShapeDraft({drawMode:e?"subtract":Xt},ht))})("selection"===g&&r),268435457&e.$$.dirty[0]&&Le&&jt){const e=jt.getMarkupItemDraft();e&&Zt(e)}var t;if(1&e.$$.dirty[0]&&Le&&jt&&"move"!==Le&&jt.blurShapes(),16&e.$$.dirty[1]|134217728&e.$$.dirty[4]&&o(51,f=de&&q),256&e.$$.dirty[1]|8388608&e.$$.dirty[4]&&o(50,$=pe&&vectorCreate(Q.x-pe.x,Q.y-pe.y)),512&e.$$.dirty[0]&&o(135,b=Object.keys(Ne)),16384&e.$$.dirty[0]|16&e.$$.dirty[1]|2097152&e.$$.dirty[4]&&o(122,y=Ze?q&&K.filter(shapeIsSelected):[]),536870912&e.$$.dirty[3]&&o(123,_=y.length>1),16&e.$$.dirty[1]|2097152&e.$$.dirty[4]&&o(119,x=q&&K.filter(shapeIsSelected)[0]),16&e.$$.dirty[1]|2097152&e.$$.dirty[4]&&o(130,v=q&&K.find((e=>shapeIsEditing(e)))),16&e.$$.dirty[1]|2097152&e.$$.dirty[4]&&o(133,S=q&&K.find((e=>shapeIsDraft(e)))),1&e.$$.dirty[0]|16&e.$$.dirty[1]|1048576&e.$$.dirty[3]&&o(127,C=q&&bt[Le]?shapeFormat(shapeDeepCopy({...bt[Le][0],...ue[it]?ue[it][Le]:{}})):{}),1048576&e.$$.dirty[3]&&bt&&o(115,qt={}),1&e.$$.dirty[0]|4227072&e.$$.dirty[3]|2056&e.$$.dirty[4]&&o(126,w=C&&Object.keys(C).reduce(((e,t)=>{const o="disableStyle"===t,r="settings"===t,n=!!b.find((e=>e.split("_").includes(t)));if(!o&&!r&&!n)return e;if(void 0===C[t])return e;if(!0===C.disableStyle)return e;if(C.disableStyle&&C.disableStyle.includes(t))return e;if("strokeWidth"===t&&Object.keys(qt).includes("strokeWidth")&&void 0===qt[t]&&hasProp(C,"points"))return e[t]=C[t],e;const{share:i=!0}=C.settings&&C.settings[t]||{},a=Ye&&i?qt:qt[Le]||{};return e[t]=hasProp(a,t)?a[t]:C[t],e}),{})),1048577&e.$$.dirty[0]|1024&e.$$.dirty[3]|4&e.$$.dirty[4]&&(ze?((e,t,o)=>{const r=ue[e],n=r?r[t]:{};ft.set({...ue,[e]:{...r,[t]:{...n,...o}}})})(it,Le,w):(t=it,ft.set({[t]:{}}))),16&e.$$.dirty[1]|67108864&e.$$.dirty[3]|67108868&e.$$.dirty[4]&&o(134,T=ce&&q?x||w:void 0),1610612736&e.$$.dirty[3]|1536&e.$$.dirty[4]&&o(49,k=_?function(e){const t={};return e.forEach((e=>{Object.entries(e).filter((([e])=>!e.startsWith("_"))).forEach((([e,o])=>{hasProp(t,e)?"disableStyle"===e&&t[e].push(...o):t[e]=o}))})),t}(y):T||S),1&e.$$.dirty[0]|8&e.$$.dirty[4]&&o(48,R=hasProp(C,"eraseRadius")||hasProp(C,"points")&&!hasProp(C,"pathClose")||"move"===Le||"view"===Le),64&e.$$.dirty[1]|8&e.$$.dirty[4]&&o(47,P=C&&void 0!==C.eraseRadius?Qt(C.eraseRadius,ne):void 0),16&e.$$.dirty[1]|33554432&e.$$.dirty[4]&&o(131,I=q&&le.includes(32)),1&e.$$.dirty[0]|16&e.$$.dirty[1]&&o(132,E=q&&"view"===Le),384&e.$$.dirty[4]&&o(129,M=E||I),96&e.$$.dirty[4]&&o(128,A=!!M&&(!!v||isTextField(document.activeElement))),16&e.$$.dirty[1]|48&e.$$.dirty[4]&&St.set(!q||M&&!A),16&e.$$.dirty[1]|16&e.$$.dirty[4]&&wt.set(!q||!A),64&e.$$.dirty[1]|12&e.$$.dirty[4]&&o(120,F=C.cursorStyle?(({cursorStyle:e,cursorSize:t},o,r)=>{let n;const i=o[t];if(void 0===i?n=Qt(t,r):isNumber(i)?n=i:isString(i)&&(n=shapeComputeProp(t,o[t],r),"strokeWidth"===t&&(n*=.5)),!(n<=0||void 0===n))return{size:n,style:e}})(C,{...C,...w},ne):void 0),33554432&e.$$.dirty[3]|16777216&e.$$.dirty[4]&&o(121,L=oo&&vectorInSize(oo,se)),1048576&e.$$.dirty[0]|160&e.$$.dirty[1]|427819008&e.$$.dirty[3]|3&e.$$.dirty[4])if(L&&!eo&&F&&!ae){const e=F.size*ee.scale,t={id:`cursor-${it}`,x:to.x,y:to.y,strokeWidth:.5,strokeColor:[0,0,0]};"ellipse"===F.style&&(t.rx=e,t.ry=e);const o={strokeWidth:2.5,strokeColor:[1,1,1],opacity:.75},n=[{...t,...o},t];if("selection"===g&&r){const t=e,r=to.x+t,i=to.y+t+4,a={id:`cursor-${it}`,strokeWidth:.75,strokeColor:[0,0,0],points:[{x:r,y:i},{x:r+4,y:i}]};n.push({...a,...o,strokeWidth:2,points:[{x:r-.5,y:i},{x:r+4.5,y:i}]},a)}(e=>{Pt.update((t=>[...t.filter((e=>e.id!==`cursor-${it}`)),...e]))})(n)}else Pt.update((e=>e.filter((e=>e.id!==`cursor-${it}`))));1&e.$$.dirty[0]|128&e.$$.dirty[1]|478150656&e.$$.dirty[3]&&o(46,D=L?((e,t,o,r,n,i)=>{if(r)return n?"grabbing":"grab";if(e&&!t)return"none";if(!t)return"move"===i?"default":"crosshair";let a=t||o;return shapeIsSelected(a)?shapeIsEditing(a)?"modal"===Be?"default":"text":!shapeCanMove(a)||_&&!y.every(shapeCanMove)?"default":"move":"default"})(F,eo,x,ae,isPanning,Le):"default"),526337&e.$$.dirty[0]|131072&e.$$.dirty[3]&&o(45,z="preset"===Le&&(nt.length>0||We||tt)),64&e.$$.dirty[1]&&(O=!hasProp(ne,"x")&&!hasProp(ne,"y")),4194304&e.$$.dirty[4]&&o(44,N=J*Rt),131072&e.$$.dirty[3]|1572864&e.$$.dirty[4]&&o(43,V=Z&&tt?e=>runSafe((()=>tt(e,no,{...Y},(()=>co.set({}))))):passthrough),524288&e.$$.dirty[3]&&o(42,W=Object.keys(dt).reduce(((e,t)=>("beforeAddShape"===t||void 0===dt[t]||(e[t]=dt[t]),e)),{})),16&e.$$.dirty[1]&&(e=>{K&&Me.update((t=>t.map((t=>(t._prerender=!!e&&shapeIsEditing(t),t)))))})(q),65536&e.$$.dirty[3]|1572864&e.$$.dirty[4]&&o(30,U=Z&&et([],Y,(()=>co.set({})))),1073742336&e.$$.dirty[0]&&o(41,H=!!U.length||!!Object.keys(Ne).some((e=>uo.includes(e)))),16&e.$$.dirty[1]|262144&e.$$.dirty[4]&&X&&po.set(q?0:20),e.$$.dirty[4],131072&e.$$.dirty[4]&&o(40,G=j?`translateY(${j}px)`:"none")},Vt.set(!1),[Le,ke,Re,Pe,Ee,Me,De,Oe,Be,Ne,Ve,We,Ue,je,Ze,Ke,Je,Qe,ot,nt,it,at,st,lt,ct,ut,pt,Wt,jt,lo,U,B,s,n,c,q,ee,ne,ae,pe,G,H,W,V,N,z,D,P,R,k,$,f,h,p,i,me,ge,fe,ht,mt,gt,ft,$t,yt,xt,vt,Ct,Tt,kt,Pt,It,Et,At,Ft,Lt,Dt,zt,({index:e},t)=>{o(27,Wt=e),o(0,Le=Ut[e])},({value:e},t)=>{o(0,Le=e),(He||/enter/i.test(t.key))&&Ht(e)},e=>{if("eraser"===Le)Yt=jt.eraseShape();else if(Le&&bt[Le]){const[e,t={}]=bt[Le],{drawMode:o}=T;"selection"===g&&"new"===o&&ht.set([]);let n={};"selection"===g&&(B("selectiondown",[...ce]),r&&(Xt=e.drawMode,n.drawMode="subtract")),Yt=jt.createShape({...e,...w,...n},t)}else Yt=void 0;return!!Yt&&(Yt.start(e),!0)},e=>!!Yt&&(Yt.update(e),!0),e=>!!Yt&&(Yt.release(e),!0),e=>!!Yt&&(Yt.cancel(e),Yt=void 0,!0),e=>{if(!Yt)return!1;if(Yt.end(e),Yt=void 0,"selection"===g){if(e.detail.isTap){const[e]=bt[Le];e.bitmap||ht.set([])}B("selectionup",[...ce])}const t=jt.getMarkupItemDraft(),r=qe&&(!0===Ge||Array.isArray(Ge)&&Ge.includes(Le));return t&&!t.isEditing||!r||o(0,Le="move"),!0},e=>{const{key:t}=e,o=jt.getMarkupItemDraft();/escape/i.test(t)&&o&&(e.preventDefault(),e.stopPropagation(),jt.discardMarkupItemDraft(),Yt=void 0),/enter/i.test(t)&&o&&(e.preventDefault(),e.stopPropagation(),Zt(o),Yt=void 0)},function(e){Object.keys(e).forEach((t=>{const{retain:r=!0,share:n=!0}=C.settings&&C.settings[t]||{};r&&(Ye&&n?o(115,qt[t]=e[t],qt):(qt[Le]||o(115,qt[Le]={},qt),o(115,qt[Le][t]=e[t],qt)))})),B("selectstyle",e),x&&(_?y.forEach((t=>{jt.updateMarkupShape(t,Jt(e,t))})):jt.updateMarkupShape(x,e),clearTimeout(Kt),Kt=setTimeout((()=>{so()}),200))},(e,t,r)=>{o(117,to=t),o(118,oo=r)},()=>{o(118,oo=void 0),o(117,to=void 0)},e=>{B("markuptap",e)},e=>o(116,eo=e),()=>{ao=!1},(e,t)=>{if(ao)return;const{beforeAddShape:o=()=>!0}=dt,r=Gt(t),n=jt.getMarkupItemDraft(),i=rectContainsPoint(ie,{x:r.x+(ne.x||0),y:r.y+(ne.y||0)});if(n&&!i&&jt.discardMarkupItemDraft(),i){if(!n){const n=shapeCreateFromPreset(e,ie),i=ro(n,r);return o(i)?(shapeMakeDraft(i),void jt.addShape(i)):(ao=!0,void t.preventDefault())}shapeIsRect(n)&&(r.x-=.5*n.width,r.y-=.5*n.height),e.shape&&(hasProp(e.shape,"x")&&(r.x=e.shape.x),hasProp(e.shape,"y")&&(r.y=e.shape.y)),jt.updateMarkupShape(n,r)}},(e,t)=>{if(ao)return;const o=Gt(t);if(!rectContainsPoint(ie,{x:o.x+(ne.x||0),y:o.y+(ne.y||0)}))return void jt.discardMarkupItemDraft();const r=jt.confirmMarkupItemDraft();jt.selectShape(r),B("addshape",r),_t.write()},e=>no(e),e=>{return t=e.detail.resources,o=Gt(e.detail.event),t.forEach((e=>no(e,o)));var t,o},e=>{if(!rt)return!0;const t=rectClone(re);return rectScale(t,1/oe),rectTranslate(t,te),rectScale(t,ee.scale),rt(e,{...t,x:t.x+Q.x,y:t.y+Q.y})},so,co,uo,po,Ie,Ae,Fe,ze,He,Ge,qe,Xe,Ye,et,tt,rt,dt,bt,Ut,qt,eo,to,oo,x,F,L,y,_,r,g,w,C,A,M,v,I,E,S,T,b,m,l,u,d,a,j,X,Y,Z,K,J,Q,se,le,ce,de,function(t){bubble.call(this,e,t)},e=>e[0]===Le,(e,t,o)=>{const r=e.filter((([,e])=>!uo.includes(e)));return ot?ot(r,t,o):r},e=>e[0]===Wt,e=>{Promise.resolve().then((()=>{B("addshape",e),so()}))},e=>{B("selectshape",e)},e=>{Promise.resolve().then((()=>{B("blurshape",e)}))},e=>{B("tapshape",e)},e=>{B("updateshape",e),so()},e=>{B("removeshape",e),so()},()=>{so()},function(e){binding_callbacks[e?"unshift":"push"]((()=>{jt=e,o(28,jt)}))},function(e){binding_callbacks[e?"unshift":"push"]((()=>{lo=e,o(29,lo)}))},e=>e.filter((([,e])=>uo.includes(e))),function(t){bubble.call(this,e,t)}]}class ShapeUtil extends SvelteComponent{constructor(e){super(),init(this,e,instance$b,create_fragment$b,safe_not_equal,{isActive:1,isActiveFraction:2,isVisible:3,stores:100,locale:4,shapes:5,toolbar:101,toolShapes:102,toolActive:0,toolSelectRadius:6,toolRetainStyles:103,toolbarLayout:7,textInputMode:8,shapeControls:9,enableButtonFlipVertical:10,enablePresetSelectImage:11,enablePresetDropImage:12,enableSelectToolToAddShape:104,enableAutoSelectMoveTool:105,enableTapToAddText:13,enableMoveTool:106,enableViewTool:107,enableToolShareStyles:108,enableMultiSelect:14,gridSize:15,snapThreshold:16,enableSnapToContext:17,willRenderHeaderTools:109,willRenderPresetToolbar:110,willRenderShapeStyleControls:18,willStartInteraction:111,shapePresets:19,utilKey:20,mapScreenPointToImagePoint:21,mapImagePointToScreenPoint:22,imageRotation:23,imageFlipX:24,imageFlipY:25,parentRect:26,hooks:112},null,[-1,-1,-1,-1,-1,-1,-1])}get isActive(){return this.$$.ctx[1]}set isActive(e){this.$$set({isActive:e}),flush()}get isActiveFraction(){return this.$$.ctx[2]}set isActiveFraction(e){this.$$set({isActiveFraction:e}),flush()}get isVisible(){return this.$$.ctx[3]}set isVisible(e){this.$$set({isVisible:e}),flush()}get stores(){return this.$$.ctx[100]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[4]}set locale(e){this.$$set({locale:e}),flush()}get shapes(){return this.$$.ctx[5]}set shapes(e){this.$$set({shapes:e}),flush()}get toolbar(){return this.$$.ctx[101]}set toolbar(e){this.$$set({toolbar:e}),flush()}get toolShapes(){return this.$$.ctx[102]}set toolShapes(e){this.$$set({toolShapes:e}),flush()}get toolActive(){return this.$$.ctx[0]}set toolActive(e){this.$$set({toolActive:e}),flush()}get toolSelectRadius(){return this.$$.ctx[6]}set toolSelectRadius(e){this.$$set({toolSelectRadius:e}),flush()}get toolRetainStyles(){return this.$$.ctx[103]}set toolRetainStyles(e){this.$$set({toolRetainStyles:e}),flush()}get toolbarLayout(){return this.$$.ctx[7]}set toolbarLayout(e){this.$$set({toolbarLayout:e}),flush()}get textInputMode(){return this.$$.ctx[8]}set textInputMode(e){this.$$set({textInputMode:e}),flush()}get shapeControls(){return this.$$.ctx[9]}set shapeControls(e){this.$$set({shapeControls:e}),flush()}get enableButtonFlipVertical(){return this.$$.ctx[10]}set enableButtonFlipVertical(e){this.$$set({enableButtonFlipVertical:e}),flush()}get enablePresetSelectImage(){return this.$$.ctx[11]}set enablePresetSelectImage(e){this.$$set({enablePresetSelectImage:e}),flush()}get enablePresetDropImage(){return this.$$.ctx[12]}set enablePresetDropImage(e){this.$$set({enablePresetDropImage:e}),flush()}get enableSelectToolToAddShape(){return this.$$.ctx[104]}set enableSelectToolToAddShape(e){this.$$set({enableSelectToolToAddShape:e}),flush()}get enableAutoSelectMoveTool(){return this.$$.ctx[105]}set enableAutoSelectMoveTool(e){this.$$set({enableAutoSelectMoveTool:e}),flush()}get enableTapToAddText(){return this.$$.ctx[13]}set enableTapToAddText(e){this.$$set({enableTapToAddText:e}),flush()}get enableMoveTool(){return this.$$.ctx[106]}set enableMoveTool(e){this.$$set({enableMoveTool:e}),flush()}get enableViewTool(){return this.$$.ctx[107]}set enableViewTool(e){this.$$set({enableViewTool:e}),flush()}get enableToolShareStyles(){return this.$$.ctx[108]}set enableToolShareStyles(e){this.$$set({enableToolShareStyles:e}),flush()}get enableMultiSelect(){return this.$$.ctx[14]}set enableMultiSelect(e){this.$$set({enableMultiSelect:e}),flush()}get gridSize(){return this.$$.ctx[15]}set gridSize(e){this.$$set({gridSize:e}),flush()}get snapThreshold(){return this.$$.ctx[16]}set snapThreshold(e){this.$$set({snapThreshold:e}),flush()}get enableSnapToContext(){return this.$$.ctx[17]}set enableSnapToContext(e){this.$$set({enableSnapToContext:e}),flush()}get willRenderHeaderTools(){return this.$$.ctx[109]}set willRenderHeaderTools(e){this.$$set({willRenderHeaderTools:e}),flush()}get willRenderPresetToolbar(){return this.$$.ctx[110]}set willRenderPresetToolbar(e){this.$$set({willRenderPresetToolbar:e}),flush()}get willRenderShapeStyleControls(){return this.$$.ctx[18]}set willRenderShapeStyleControls(e){this.$$set({willRenderShapeStyleControls:e}),flush()}get willStartInteraction(){return this.$$.ctx[111]}set willStartInteraction(e){this.$$set({willStartInteraction:e}),flush()}get shapePresets(){return this.$$.ctx[19]}set shapePresets(e){this.$$set({shapePresets:e}),flush()}get utilKey(){return this.$$.ctx[20]}set utilKey(e){this.$$set({utilKey:e}),flush()}get mapScreenPointToImagePoint(){return this.$$.ctx[21]}set mapScreenPointToImagePoint(e){this.$$set({mapScreenPointToImagePoint:e}),flush()}get mapImagePointToScreenPoint(){return this.$$.ctx[22]}set mapImagePointToScreenPoint(e){this.$$set({mapImagePointToScreenPoint:e}),flush()}get imageRotation(){return this.$$.ctx[23]}set imageRotation(e){this.$$set({imageRotation:e}),flush()}get imageFlipX(){return this.$$.ctx[24]}set imageFlipX(e){this.$$set({imageFlipX:e}),flush()}get imageFlipY(){return this.$$.ctx[25]}set imageFlipY(e){this.$$set({imageFlipY:e}),flush()}get parentRect(){return this.$$.ctx[26]}set parentRect(e){this.$$set({parentRect:e}),flush()}get hooks(){return this.$$.ctx[112]}set hooks(e){this.$$set({hooks:e}),flush()}}var _mapImagePointToScreenPoint=(e,t,o,r,n,i,a,s,l)=>{const c=vectorClone(e),u=.5*o.width,p=.5*o.height,d=.5*t.width,h=.5*t.height,m=n.x+r.x,g=n.y+r.y;s&&(c.x=o.width-c.x),l&&(c.y=o.height-c.y);const f=Math.cos(i),$=Math.sin(i);c.x-=u,c.y-=p;const b=c.x*f-c.y*$,y=c.x*$+c.y*f;c.x=u+b,c.y=p+y,c.x*=a,c.y*=a,c.x+=d,c.y+=h,c.x+=m,c.y+=g,c.x-=u*a,c.y-=p*a;const _=(n.x-m)*a,x=(n.y-g)*a,v=_*f-x*$,S=_*$+x*f;return c.x+=v,c.y+=S,c},_mapScreenPointToImagePoint=(e,t,o,r,n,i,a,s,l)=>{const c=vectorClone(e),u=sizeCenter(o),p=sizeCenter(t),d=vectorCreate(n.x+r.x,n.y+r.y),h=Math.cos(i),m=Math.sin(i);c.x-=p.x,c.y-=p.y;const g=(n.x-d.x)*a,f=(n.y-d.y)*a,$=g*h-f*m,b=g*m+f*h;c.x-=$,c.y-=b,c.x-=d.x,c.y-=d.y,c.x/=a,c.y/=a;const y=c.x*h+c.y*m,_=c.x*m-c.y*h;return c.x=y,c.y=-_,c.x+=u.x,c.y+=u.y,s&&(c.x=o.width-c.x),l&&(c.y=o.height-c.y),c},isBoolean=e=>"boolean"==typeof e;function create_fragment$a(e){let t,o,r;function n(t){e[60](t)}let i={utilKey:e[1],stores:e[5],locale:e[6],isActive:e[2],isActiveFraction:e[3],isVisible:e[4],mapScreenPointToImagePoint:e[46],mapImagePointToScreenPoint:e[45],imageRotation:e[47],imageFlipX:e[44],imageFlipY:e[43],shapes:e[49],toolbar:e[21]||e[7],toolShapes:e[22]||e[8],toolRetainStyles:e[9],enableSelectToolToAddShape:e[31],enableTapToAddText:e[32],enableViewTool:e[30],enableMoveTool:e[34],enableAutoSelectMoveTool:e[33],enableMultiSelect:e[35],snapThreshold:e[16],gridSize:isNumber(e[18])?e[18]:e[15],enableSnapToContext:isBoolean(e[19])?e[19]:e[17],enableToolShareStyles:e[13],shapeControls:e[23]||e[10],shapePresets:e[27],enableButtonFlipVertical:e[24],parentRect:e[50],enablePresetDropImage:e[26],enablePresetSelectImage:e[25],toolSelectRadius:e[11],textInputMode:e[12],willStartInteraction:e[14],willRenderPresetToolbar:e[28]||e[20],willRenderShapeStyleControls:e[29],hooks:{willRenderShapeControls:e[36],willRenderShapeTextControls:e[37],beforeAddShape:e[38],beforeRemoveShape:e[39],beforeDeselectShape:e[40],beforeSelectShape:e[41],beforeUpdateShape:e[42]}};return void 0!==e[0]&&(i.toolActive=e[0]),t=new ShapeUtil({props:i}),binding_callbacks.push((()=>bind(t,"toolActive",n))),t.$on("measure",e[61]),{c(){create_component(t.$$.fragment)},m(e,o){mount_component(t,e,o),r=!0},p(e,r){const n={};32&r[0]&&(n.stores=e[5]),64&r[0]&&(n.locale=e[6]),4&r[0]&&(n.isActive=e[2]),8&r[0]&&(n.isActiveFraction=e[3]),16&r[0]&&(n.isVisible=e[4]),32768&r[1]&&(n.mapScreenPointToImagePoint=e[46]),16384&r[1]&&(n.mapImagePointToScreenPoint=e[45]),65536&r[1]&&(n.imageRotation=e[47]),8192&r[1]&&(n.imageFlipX=e[44]),4096&r[1]&&(n.imageFlipY=e[43]),2097280&r[0]&&(n.toolbar=e[21]||e[7]),4194560&r[0]&&(n.toolShapes=e[22]||e[8]),512&r[0]&&(n.toolRetainStyles=e[9]),1&r[1]&&(n.enableSelectToolToAddShape=e[31]),2&r[1]&&(n.enableTapToAddText=e[32]),1073741824&r[0]&&(n.enableViewTool=e[30]),8&r[1]&&(n.enableMoveTool=e[34]),4&r[1]&&(n.enableAutoSelectMoveTool=e[33]),16&r[1]&&(n.enableMultiSelect=e[35]),65536&r[0]&&(n.snapThreshold=e[16]),294912&r[0]&&(n.gridSize=isNumber(e[18])?e[18]:e[15]),655360&r[0]&&(n.enableSnapToContext=isBoolean(e[19])?e[19]:e[17]),8192&r[0]&&(n.enableToolShareStyles=e[13]),8389632&r[0]&&(n.shapeControls=e[23]||e[10]),134217728&r[0]&&(n.shapePresets=e[27]),16777216&r[0]&&(n.enableButtonFlipVertical=e[24]),67108864&r[0]&&(n.enablePresetDropImage=e[26]),33554432&r[0]&&(n.enablePresetSelectImage=e[25]),2048&r[0]&&(n.toolSelectRadius=e[11]),4096&r[0]&&(n.textInputMode=e[12]),16384&r[0]&&(n.willStartInteraction=e[14]),269484032&r[0]&&(n.willRenderPresetToolbar=e[28]||e[20]),536870912&r[0]&&(n.willRenderShapeStyleControls=e[29]),4064&r[1]&&(n.hooks={willRenderShapeControls:e[36],willRenderShapeTextControls:e[37],beforeAddShape:e[38],beforeRemoveShape:e[39],beforeDeselectShape:e[40],beforeSelectShape:e[41],beforeUpdateShape:e[42]}),!o&&1&r[0]&&(o=!0,n.toolActive=e[0],add_flush_callback((()=>o=!1))),t.$set(n)},i(e){r||(transition_in(t.$$.fragment,e),r=!0)},o(e){transition_out(t.$$.fragment,e),r=!1},d(e){destroy_component(t,e)}}}function instance$a(e,t,o){let r,n,i,a,s,l,c,u,p;let{isActive:d}=t,{isActiveFraction:h}=t,{isVisible:m}=t,{stores:g}=t,{locale:f={}}=t,{markupEditorToolbar:$}=t,{markupEditorToolStyles:b}=t,{markupEditorToolRetainStyles:y}=t,{markupEditorShapeStyleControls:_}=t,{markupEditorToolSelectRadius:x}=t,{markupEditorTextInputMode:v}=t,{markupEditorToolShareStyles:S}=t,{markupEditorWillStartInteraction:C}=t,{markupEditorGridSize:w=0}=t,{markupEditorSnapThreshold:T=0}=t,{markupEditorSnapToContext:k=!1}=t,{annotateGridSize:R}=t,{annotateSnapToContext:P}=t,{willRenderShapePresetToolbar:I}=t,{annotateTools:E}=t,{annotateToolShapes:M}=t,{annotateShapeControls:A}=t,{annotateActiveTool:F}=t,{annotateEnableButtonFlipVertical:L=!1}=t,{annotateEnableSelectImagePreset:D=!1}=t,{annotateEnableDropImagePreset:z=!0}=t,{annotatePresets:O=[]}=t,{annotateWillRenderShapePresetToolbar:B}=t,{annotateWillRenderShapeStyleControls:N}=t,{enableViewTool:V}=t,{enableSelectToolToAddShape:W}=t,{enableTapToAddText:U}=t,{enableAutoSelectMoveTool:H}=t,{enableMoveTool:G}=t,{enableMultiSelect:j}=t,{willRenderShapeControls:q}=t,{willRenderShapeTextControls:X}=t,{beforeAddShape:Y}=t,{beforeRemoveShape:Z}=t,{beforeDeselectShape:K}=t,{beforeSelectShape:J}=t,{beforeUpdateShape:Q}=t;const{rootRect:ee,imageAnnotation:te,imageSize:oe,imageRotation:re,imageFlipX:ne,imageFlipY:ie,imageTransforms:ae,imageTransformsInterpolated:se}=g;return component_subscribe(e,ee,(e=>o(59,u=e))),component_subscribe(e,oe,(e=>o(58,c=e))),component_subscribe(e,re,(e=>o(47,p=e))),component_subscribe(e,ne,(e=>o(44,a=e))),component_subscribe(e,ie,(e=>o(43,i=e))),component_subscribe(e,ae,(e=>o(57,l=e))),component_subscribe(e,se,(e=>o(56,s=e))),e.$$set=e=>{"isActive"in e&&o(2,d=e.isActive),"isActiveFraction"in e&&o(3,h=e.isActiveFraction),"isVisible"in e&&o(4,m=e.isVisible),"stores"in e&&o(5,g=e.stores),"locale"in e&&o(6,f=e.locale),"markupEditorToolbar"in e&&o(7,$=e.markupEditorToolbar),"markupEditorToolStyles"in e&&o(8,b=e.markupEditorToolStyles),"markupEditorToolRetainStyles"in e&&o(9,y=e.markupEditorToolRetainStyles),"markupEditorShapeStyleControls"in e&&o(10,_=e.markupEditorShapeStyleControls),"markupEditorToolSelectRadius"in e&&o(11,x=e.markupEditorToolSelectRadius),"markupEditorTextInputMode"in e&&o(12,v=e.markupEditorTextInputMode),"markupEditorToolShareStyles"in e&&o(13,S=e.markupEditorToolShareStyles),"markupEditorWillStartInteraction"in e&&o(14,C=e.markupEditorWillStartInteraction),"markupEditorGridSize"in e&&o(15,w=e.markupEditorGridSize),"markupEditorSnapThreshold"in e&&o(16,T=e.markupEditorSnapThreshold),"markupEditorSnapToContext"in e&&o(17,k=e.markupEditorSnapToContext),"annotateGridSize"in e&&o(18,R=e.annotateGridSize),"annotateSnapToContext"in e&&o(19,P=e.annotateSnapToContext),"willRenderShapePresetToolbar"in e&&o(20,I=e.willRenderShapePresetToolbar),"annotateTools"in e&&o(21,E=e.annotateTools),"annotateToolShapes"in e&&o(22,M=e.annotateToolShapes),"annotateShapeControls"in e&&o(23,A=e.annotateShapeControls),"annotateActiveTool"in e&&o(0,F=e.annotateActiveTool),"annotateEnableButtonFlipVertical"in e&&o(24,L=e.annotateEnableButtonFlipVertical),"annotateEnableSelectImagePreset"in e&&o(25,D=e.annotateEnableSelectImagePreset),"annotateEnableDropImagePreset"in e&&o(26,z=e.annotateEnableDropImagePreset),"annotatePresets"in e&&o(27,O=e.annotatePresets),"annotateWillRenderShapePresetToolbar"in e&&o(28,B=e.annotateWillRenderShapePresetToolbar),"annotateWillRenderShapeStyleControls"in e&&o(29,N=e.annotateWillRenderShapeStyleControls),"enableViewTool"in e&&o(30,V=e.enableViewTool),"enableSelectToolToAddShape"in e&&o(31,W=e.enableSelectToolToAddShape),"enableTapToAddText"in e&&o(32,U=e.enableTapToAddText),"enableAutoSelectMoveTool"in e&&o(33,H=e.enableAutoSelectMoveTool),"enableMoveTool"in e&&o(34,G=e.enableMoveTool),"enableMultiSelect"in e&&o(35,j=e.enableMultiSelect),"willRenderShapeControls"in e&&o(36,q=e.willRenderShapeControls),"willRenderShapeTextControls"in e&&o(37,X=e.willRenderShapeTextControls),"beforeAddShape"in e&&o(38,Y=e.beforeAddShape),"beforeRemoveShape"in e&&o(39,Z=e.beforeRemoveShape),"beforeDeselectShape"in e&&o(40,K=e.beforeDeselectShape),"beforeSelectShape"in e&&o(41,J=e.beforeSelectShape),"beforeUpdateShape"in e&&o(42,Q=e.beforeUpdateShape)},e.$$.update=()=>{503328768&e.$$.dirty[1]&&o(46,r=e=>_mapScreenPointToImagePoint(e,u,c,s.origin,s.translation,l.rotation.z,s.scale,a,i)),503328768&e.$$.dirty[1]&&o(45,n=e=>_mapImagePointToScreenPoint(e,u,c,s.origin,s.translation,l.rotation.z,s.scale,a,i))},[F,"annotate",d,h,m,g,f,$,b,y,_,x,v,S,C,w,T,k,R,P,I,E,M,A,L,D,z,O,B,N,V,W,U,H,G,j,q,X,Y,Z,K,J,Q,i,a,n,r,p,ee,te,oe,re,ne,ie,ae,se,s,l,c,u,function(e){F=e,o(0,F)},function(t){bubble.call(this,e,t)}]}class Annotate extends SvelteComponent{constructor(e){super(),init(this,e,instance$a,create_fragment$a,safe_not_equal,{name:1,isActive:2,isActiveFraction:3,isVisible:4,stores:5,locale:6,markupEditorToolbar:7,markupEditorToolStyles:8,markupEditorToolRetainStyles:9,markupEditorShapeStyleControls:10,markupEditorToolSelectRadius:11,markupEditorTextInputMode:12,markupEditorToolShareStyles:13,markupEditorWillStartInteraction:14,markupEditorGridSize:15,markupEditorSnapThreshold:16,markupEditorSnapToContext:17,annotateGridSize:18,annotateSnapToContext:19,willRenderShapePresetToolbar:20,annotateTools:21,annotateToolShapes:22,annotateShapeControls:23,annotateActiveTool:0,annotateEnableButtonFlipVertical:24,annotateEnableSelectImagePreset:25,annotateEnableDropImagePreset:26,annotatePresets:27,annotateWillRenderShapePresetToolbar:28,annotateWillRenderShapeStyleControls:29,enableViewTool:30,enableSelectToolToAddShape:31,enableTapToAddText:32,enableAutoSelectMoveTool:33,enableMoveTool:34,enableMultiSelect:35,willRenderShapeControls:36,willRenderShapeTextControls:37,beforeAddShape:38,beforeRemoveShape:39,beforeDeselectShape:40,beforeSelectShape:41,beforeUpdateShape:42},null,[-1,-1])}get name(){return this.$$.ctx[1]}get isActive(){return this.$$.ctx[2]}set isActive(e){this.$$set({isActive:e}),flush()}get isActiveFraction(){return this.$$.ctx[3]}set isActiveFraction(e){this.$$set({isActiveFraction:e}),flush()}get isVisible(){return this.$$.ctx[4]}set isVisible(e){this.$$set({isVisible:e}),flush()}get stores(){return this.$$.ctx[5]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[6]}set locale(e){this.$$set({locale:e}),flush()}get markupEditorToolbar(){return this.$$.ctx[7]}set markupEditorToolbar(e){this.$$set({markupEditorToolbar:e}),flush()}get markupEditorToolStyles(){return this.$$.ctx[8]}set markupEditorToolStyles(e){this.$$set({markupEditorToolStyles:e}),flush()}get markupEditorToolRetainStyles(){return this.$$.ctx[9]}set markupEditorToolRetainStyles(e){this.$$set({markupEditorToolRetainStyles:e}),flush()}get markupEditorShapeStyleControls(){return this.$$.ctx[10]}set markupEditorShapeStyleControls(e){this.$$set({markupEditorShapeStyleControls:e}),flush()}get markupEditorToolSelectRadius(){return this.$$.ctx[11]}set markupEditorToolSelectRadius(e){this.$$set({markupEditorToolSelectRadius:e}),flush()}get markupEditorTextInputMode(){return this.$$.ctx[12]}set markupEditorTextInputMode(e){this.$$set({markupEditorTextInputMode:e}),flush()}get markupEditorToolShareStyles(){return this.$$.ctx[13]}set markupEditorToolShareStyles(e){this.$$set({markupEditorToolShareStyles:e}),flush()}get markupEditorWillStartInteraction(){return this.$$.ctx[14]}set markupEditorWillStartInteraction(e){this.$$set({markupEditorWillStartInteraction:e}),flush()}get markupEditorGridSize(){return this.$$.ctx[15]}set markupEditorGridSize(e){this.$$set({markupEditorGridSize:e}),flush()}get markupEditorSnapThreshold(){return this.$$.ctx[16]}set markupEditorSnapThreshold(e){this.$$set({markupEditorSnapThreshold:e}),flush()}get markupEditorSnapToContext(){return this.$$.ctx[17]}set markupEditorSnapToContext(e){this.$$set({markupEditorSnapToContext:e}),flush()}get annotateGridSize(){return this.$$.ctx[18]}set annotateGridSize(e){this.$$set({annotateGridSize:e}),flush()}get annotateSnapToContext(){return this.$$.ctx[19]}set annotateSnapToContext(e){this.$$set({annotateSnapToContext:e}),flush()}get willRenderShapePresetToolbar(){return this.$$.ctx[20]}set willRenderShapePresetToolbar(e){this.$$set({willRenderShapePresetToolbar:e}),flush()}get annotateTools(){return this.$$.ctx[21]}set annotateTools(e){this.$$set({annotateTools:e}),flush()}get annotateToolShapes(){return this.$$.ctx[22]}set annotateToolShapes(e){this.$$set({annotateToolShapes:e}),flush()}get annotateShapeControls(){return this.$$.ctx[23]}set annotateShapeControls(e){this.$$set({annotateShapeControls:e}),flush()}get annotateActiveTool(){return this.$$.ctx[0]}set annotateActiveTool(e){this.$$set({annotateActiveTool:e}),flush()}get annotateEnableButtonFlipVertical(){return this.$$.ctx[24]}set annotateEnableButtonFlipVertical(e){this.$$set({annotateEnableButtonFlipVertical:e}),flush()}get annotateEnableSelectImagePreset(){return this.$$.ctx[25]}set annotateEnableSelectImagePreset(e){this.$$set({annotateEnableSelectImagePreset:e}),flush()}get annotateEnableDropImagePreset(){return this.$$.ctx[26]}set annotateEnableDropImagePreset(e){this.$$set({annotateEnableDropImagePreset:e}),flush()}get annotatePresets(){return this.$$.ctx[27]}set annotatePresets(e){this.$$set({annotatePresets:e}),flush()}get annotateWillRenderShapePresetToolbar(){return this.$$.ctx[28]}set annotateWillRenderShapePresetToolbar(e){this.$$set({annotateWillRenderShapePresetToolbar:e}),flush()}get annotateWillRenderShapeStyleControls(){return this.$$.ctx[29]}set annotateWillRenderShapeStyleControls(e){this.$$set({annotateWillRenderShapeStyleControls:e}),flush()}get enableViewTool(){return this.$$.ctx[30]}set enableViewTool(e){this.$$set({enableViewTool:e}),flush()}get enableSelectToolToAddShape(){return this.$$.ctx[31]}set enableSelectToolToAddShape(e){this.$$set({enableSelectToolToAddShape:e}),flush()}get enableTapToAddText(){return this.$$.ctx[32]}set enableTapToAddText(e){this.$$set({enableTapToAddText:e}),flush()}get enableAutoSelectMoveTool(){return this.$$.ctx[33]}set enableAutoSelectMoveTool(e){this.$$set({enableAutoSelectMoveTool:e}),flush()}get enableMoveTool(){return this.$$.ctx[34]}set enableMoveTool(e){this.$$set({enableMoveTool:e}),flush()}get enableMultiSelect(){return this.$$.ctx[35]}set enableMultiSelect(e){this.$$set({enableMultiSelect:e}),flush()}get willRenderShapeControls(){return this.$$.ctx[36]}set willRenderShapeControls(e){this.$$set({willRenderShapeControls:e}),flush()}get willRenderShapeTextControls(){return this.$$.ctx[37]}set willRenderShapeTextControls(e){this.$$set({willRenderShapeTextControls:e}),flush()}get beforeAddShape(){return this.$$.ctx[38]}set beforeAddShape(e){this.$$set({beforeAddShape:e}),flush()}get beforeRemoveShape(){return this.$$.ctx[39]}set beforeRemoveShape(e){this.$$set({beforeRemoveShape:e}),flush()}get beforeDeselectShape(){return this.$$.ctx[40]}set beforeDeselectShape(e){this.$$set({beforeDeselectShape:e}),flush()}get beforeSelectShape(){return this.$$.ctx[41]}set beforeSelectShape(e){this.$$set({beforeSelectShape:e}),flush()}get beforeUpdateShape(){return this.$$.ctx[42]}set beforeUpdateShape(e){this.$$set({beforeUpdateShape:e}),flush()}}var _plugin_annotate={util:["annotate",Annotate]};function create_fragment$9(e){let t,o,r;function n(t){e[52](t)}let i={utilKey:e[1],stores:e[5],locale:e[6],isActive:e[2],isActiveFraction:e[3],isVisible:e[4],mapScreenPointToImagePoint:e[44],mapImagePointToScreenPoint:e[43],shapes:e[46],toolbar:e[20]||e[7],toolShapes:e[21]||e[8],toolRetainStyles:e[9],shapeControls:e[22]||e[10],shapePresets:e[26],enableSelectToolToAddShape:e[29],enableTapToAddText:e[30],enableViewTool:e[31],enableMoveTool:e[32],enableAutoSelectMoveTool:e[33],enableMultiSelect:e[34],snapThreshold:e[16],gridSize:isNumber(e[18])?e[18]:e[15],enableSnapToContext:isBoolean(e[19])?e[19]:e[17],enableToolShareStyles:e[13],enablePresetSelectImage:e[24],enablePresetDropImage:e[25],enableButtonFlipVertical:e[23],parentRect:e[45],toolSelectRadius:e[11],textInputMode:e[12],willStartInteraction:e[42],willRenderPresetToolbar:e[27]||e[14],willRenderShapeStyleControls:e[28],hooks:{willRenderShapeControls:e[35],willRenderShapeTextControls:e[36],beforeAddShape:e[37],beforeRemoveShape:e[38],beforeDeselectShape:e[39],beforeSelectShape:e[40],beforeUpdateShape:e[41]}};return void 0!==e[0]&&(i.toolActive=e[0]),t=new ShapeUtil({props:i}),binding_callbacks.push((()=>bind(t,"toolActive",n))),t.$on("measure",e[53]),{c(){create_component(t.$$.fragment)},m(e,o){mount_component(t,e,o),r=!0},p(e,r){const n={};32&r[0]&&(n.stores=e[5]),64&r[0]&&(n.locale=e[6]),4&r[0]&&(n.isActive=e[2]),8&r[0]&&(n.isActiveFraction=e[3]),16&r[0]&&(n.isVisible=e[4]),8192&r[1]&&(n.mapScreenPointToImagePoint=e[44]),4096&r[1]&&(n.mapImagePointToScreenPoint=e[43]),1048704&r[0]&&(n.toolbar=e[20]||e[7]),2097408&r[0]&&(n.toolShapes=e[21]||e[8]),512&r[0]&&(n.toolRetainStyles=e[9]),4195328&r[0]&&(n.shapeControls=e[22]||e[10]),67108864&r[0]&&(n.shapePresets=e[26]),536870912&r[0]&&(n.enableSelectToolToAddShape=e[29]),1073741824&r[0]&&(n.enableTapToAddText=e[30]),1&r[1]&&(n.enableViewTool=e[31]),2&r[1]&&(n.enableMoveTool=e[32]),4&r[1]&&(n.enableAutoSelectMoveTool=e[33]),8&r[1]&&(n.enableMultiSelect=e[34]),65536&r[0]&&(n.snapThreshold=e[16]),294912&r[0]&&(n.gridSize=isNumber(e[18])?e[18]:e[15]),655360&r[0]&&(n.enableSnapToContext=isBoolean(e[19])?e[19]:e[17]),8192&r[0]&&(n.enableToolShareStyles=e[13]),16777216&r[0]&&(n.enablePresetSelectImage=e[24]),33554432&r[0]&&(n.enablePresetDropImage=e[25]),8388608&r[0]&&(n.enableButtonFlipVertical=e[23]),2048&r[0]&&(n.toolSelectRadius=e[11]),4096&r[0]&&(n.textInputMode=e[12]),2048&r[1]&&(n.willStartInteraction=e[42]),134234112&r[0]&&(n.willRenderPresetToolbar=e[27]||e[14]),268435456&r[0]&&(n.willRenderShapeStyleControls=e[28]),2032&r[1]&&(n.hooks={willRenderShapeControls:e[35],willRenderShapeTextControls:e[36],beforeAddShape:e[37],beforeRemoveShape:e[38],beforeDeselectShape:e[39],beforeSelectShape:e[40],beforeUpdateShape:e[41]}),!o&&1&r[0]&&(o=!0,n.toolActive=e[0],add_flush_callback((()=>o=!1))),t.$set(n)},i(e){r||(transition_in(t.$$.fragment,e),r=!0)},o(e){transition_out(t.$$.fragment,e),r=!1},d(e){destroy_component(t,e)}}}function instance$9(e,t,o){let r,n,i,a,s;let{isActive:l}=t,{isActiveFraction:c}=t,{isVisible:u}=t,{stores:p}=t,{locale:d={}}=t,{markupEditorToolbar:h}=t,{markupEditorToolStyles:m}=t,{markupEditorToolRetainStyles:g}=t,{markupEditorShapeStyleControls:f}=t,{markupEditorToolSelectRadius:$}=t,{markupEditorTextInputMode:b}=t,{markupEditorToolShareStyles:y}=t,{willRenderShapePresetToolbar:_}=t,{markupEditorGridSize:x}=t,{markupEditorSnapThreshold:v}=t,{markupEditorSnapToContext:S=!0}=t,{decorateGridSize:C}=t,{decorateSnapToContext:w}=t,{decorateTools:T}=t,{decorateToolShapes:k}=t,{decorateShapeControls:R}=t,{decorateActiveTool:P}=t,{decorateEnableButtonFlipVertical:I=!1}=t,{decorateEnableSelectImagePreset:E=!1}=t,{decorateEnableDropImagePreset:M=!0}=t,{decoratePresets:A=[]}=t,{decorateWillRenderShapePresetToolbar:F}=t,{decorateWillRenderShapeStyleControls:L}=t,{enableSelectToolToAddShape:D}=t,{enableTapToAddText:z}=t,{enableViewTool:O}=t,{enableMoveTool:B}=t,{enableAutoSelectMoveTool:N}=t,{enableMultiSelect:V}=t,{willRenderShapeControls:W}=t,{willRenderShapeTextControls:U}=t,{beforeAddShape:H}=t,{beforeRemoveShape:G}=t,{beforeDeselectShape:j}=t,{beforeSelectShape:q}=t,{beforeUpdateShape:X}=t,{markupEditorWillStartInteraction:Y}=t;const{imageCropRect:Z,imageDecoration:K,imageSelectionRectPresentation:J,imageTransformsInterpolated:Q}=p;return component_subscribe(e,J,(e=>o(50,a=e))),component_subscribe(e,Q,(e=>o(51,s=e))),e.$$set=e=>{"isActive"in e&&o(2,l=e.isActive),"isActiveFraction"in e&&o(3,c=e.isActiveFraction),"isVisible"in e&&o(4,u=e.isVisible),"stores"in e&&o(5,p=e.stores),"locale"in e&&o(6,d=e.locale),"markupEditorToolbar"in e&&o(7,h=e.markupEditorToolbar),"markupEditorToolStyles"in e&&o(8,m=e.markupEditorToolStyles),"markupEditorToolRetainStyles"in e&&o(9,g=e.markupEditorToolRetainStyles),"markupEditorShapeStyleControls"in e&&o(10,f=e.markupEditorShapeStyleControls),"markupEditorToolSelectRadius"in e&&o(11,$=e.markupEditorToolSelectRadius),"markupEditorTextInputMode"in e&&o(12,b=e.markupEditorTextInputMode),"markupEditorToolShareStyles"in e&&o(13,y=e.markupEditorToolShareStyles),"willRenderShapePresetToolbar"in e&&o(14,_=e.willRenderShapePresetToolbar),"markupEditorGridSize"in e&&o(15,x=e.markupEditorGridSize),"markupEditorSnapThreshold"in e&&o(16,v=e.markupEditorSnapThreshold),"markupEditorSnapToContext"in e&&o(17,S=e.markupEditorSnapToContext),"decorateGridSize"in e&&o(18,C=e.decorateGridSize),"decorateSnapToContext"in e&&o(19,w=e.decorateSnapToContext),"decorateTools"in e&&o(20,T=e.decorateTools),"decorateToolShapes"in e&&o(21,k=e.decorateToolShapes),"decorateShapeControls"in e&&o(22,R=e.decorateShapeControls),"decorateActiveTool"in e&&o(0,P=e.decorateActiveTool),"decorateEnableButtonFlipVertical"in e&&o(23,I=e.decorateEnableButtonFlipVertical),"decorateEnableSelectImagePreset"in e&&o(24,E=e.decorateEnableSelectImagePreset),"decorateEnableDropImagePreset"in e&&o(25,M=e.decorateEnableDropImagePreset),"decoratePresets"in e&&o(26,A=e.decoratePresets),"decorateWillRenderShapePresetToolbar"in e&&o(27,F=e.decorateWillRenderShapePresetToolbar),"decorateWillRenderShapeStyleControls"in e&&o(28,L=e.decorateWillRenderShapeStyleControls),"enableSelectToolToAddShape"in e&&o(29,D=e.enableSelectToolToAddShape),"enableTapToAddText"in e&&o(30,z=e.enableTapToAddText),"enableViewTool"in e&&o(31,O=e.enableViewTool),"enableMoveTool"in e&&o(32,B=e.enableMoveTool),"enableAutoSelectMoveTool"in e&&o(33,N=e.enableAutoSelectMoveTool),"enableMultiSelect"in e&&o(34,V=e.enableMultiSelect),"willRenderShapeControls"in e&&o(35,W=e.willRenderShapeControls),"willRenderShapeTextControls"in e&&o(36,U=e.willRenderShapeTextControls),"beforeAddShape"in e&&o(37,H=e.beforeAddShape),"beforeRemoveShape"in e&&o(38,G=e.beforeRemoveShape),"beforeDeselectShape"in e&&o(39,j=e.beforeDeselectShape),"beforeSelectShape"in e&&o(40,q=e.beforeSelectShape),"beforeUpdateShape"in e&&o(41,X=e.beforeUpdateShape),"markupEditorWillStartInteraction"in e&&o(42,Y=e.markupEditorWillStartInteraction)},e.$$.update=()=>{1048576&e.$$.dirty[1]&&o(49,r=s?s.scale:1),786432&e.$$.dirty[1]&&o(44,n=e=>{const t=vectorClone(e);return t.x-=a.x,t.y-=a.y,t.x/=r,t.y/=r,t}),786432&e.$$.dirty[1]&&o(43,i=e=>{const t=vectorClone(e);return t.x*=r,t.y*=r,t.x+=a.x,t.y+=a.y,t})},[P,"decorate",l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,S,C,w,T,k,R,I,E,M,A,F,L,D,z,O,B,N,V,W,U,H,G,j,q,X,Y,i,n,Z,K,J,Q,r,a,s,function(e){P=e,o(0,P)},function(t){bubble.call(this,e,t)}]}class Decorate extends SvelteComponent{constructor(e){super(),init(this,e,instance$9,create_fragment$9,safe_not_equal,{name:1,isActive:2,isActiveFraction:3,isVisible:4,stores:5,locale:6,markupEditorToolbar:7,markupEditorToolStyles:8,markupEditorToolRetainStyles:9,markupEditorShapeStyleControls:10,markupEditorToolSelectRadius:11,markupEditorTextInputMode:12,markupEditorToolShareStyles:13,willRenderShapePresetToolbar:14,markupEditorGridSize:15,markupEditorSnapThreshold:16,markupEditorSnapToContext:17,decorateGridSize:18,decorateSnapToContext:19,decorateTools:20,decorateToolShapes:21,decorateShapeControls:22,decorateActiveTool:0,decorateEnableButtonFlipVertical:23,decorateEnableSelectImagePreset:24,decorateEnableDropImagePreset:25,decoratePresets:26,decorateWillRenderShapePresetToolbar:27,decorateWillRenderShapeStyleControls:28,enableSelectToolToAddShape:29,enableTapToAddText:30,enableViewTool:31,enableMoveTool:32,enableAutoSelectMoveTool:33,enableMultiSelect:34,willRenderShapeControls:35,willRenderShapeTextControls:36,beforeAddShape:37,beforeRemoveShape:38,beforeDeselectShape:39,beforeSelectShape:40,beforeUpdateShape:41,markupEditorWillStartInteraction:42},null,[-1,-1])}get name(){return this.$$.ctx[1]}get isActive(){return this.$$.ctx[2]}set isActive(e){this.$$set({isActive:e}),flush()}get isActiveFraction(){return this.$$.ctx[3]}set isActiveFraction(e){this.$$set({isActiveFraction:e}),flush()}get isVisible(){return this.$$.ctx[4]}set isVisible(e){this.$$set({isVisible:e}),flush()}get stores(){return this.$$.ctx[5]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[6]}set locale(e){this.$$set({locale:e}),flush()}get markupEditorToolbar(){return this.$$.ctx[7]}set markupEditorToolbar(e){this.$$set({markupEditorToolbar:e}),flush()}get markupEditorToolStyles(){return this.$$.ctx[8]}set markupEditorToolStyles(e){this.$$set({markupEditorToolStyles:e}),flush()}get markupEditorToolRetainStyles(){return this.$$.ctx[9]}set markupEditorToolRetainStyles(e){this.$$set({markupEditorToolRetainStyles:e}),flush()}get markupEditorShapeStyleControls(){return this.$$.ctx[10]}set markupEditorShapeStyleControls(e){this.$$set({markupEditorShapeStyleControls:e}),flush()}get markupEditorToolSelectRadius(){return this.$$.ctx[11]}set markupEditorToolSelectRadius(e){this.$$set({markupEditorToolSelectRadius:e}),flush()}get markupEditorTextInputMode(){return this.$$.ctx[12]}set markupEditorTextInputMode(e){this.$$set({markupEditorTextInputMode:e}),flush()}get markupEditorToolShareStyles(){return this.$$.ctx[13]}set markupEditorToolShareStyles(e){this.$$set({markupEditorToolShareStyles:e}),flush()}get willRenderShapePresetToolbar(){return this.$$.ctx[14]}set willRenderShapePresetToolbar(e){this.$$set({willRenderShapePresetToolbar:e}),flush()}get markupEditorGridSize(){return this.$$.ctx[15]}set markupEditorGridSize(e){this.$$set({markupEditorGridSize:e}),flush()}get markupEditorSnapThreshold(){return this.$$.ctx[16]}set markupEditorSnapThreshold(e){this.$$set({markupEditorSnapThreshold:e}),flush()}get markupEditorSnapToContext(){return this.$$.ctx[17]}set markupEditorSnapToContext(e){this.$$set({markupEditorSnapToContext:e}),flush()}get decorateGridSize(){return this.$$.ctx[18]}set decorateGridSize(e){this.$$set({decorateGridSize:e}),flush()}get decorateSnapToContext(){return this.$$.ctx[19]}set decorateSnapToContext(e){this.$$set({decorateSnapToContext:e}),flush()}get decorateTools(){return this.$$.ctx[20]}set decorateTools(e){this.$$set({decorateTools:e}),flush()}get decorateToolShapes(){return this.$$.ctx[21]}set decorateToolShapes(e){this.$$set({decorateToolShapes:e}),flush()}get decorateShapeControls(){return this.$$.ctx[22]}set decorateShapeControls(e){this.$$set({decorateShapeControls:e}),flush()}get decorateActiveTool(){return this.$$.ctx[0]}set decorateActiveTool(e){this.$$set({decorateActiveTool:e}),flush()}get decorateEnableButtonFlipVertical(){return this.$$.ctx[23]}set decorateEnableButtonFlipVertical(e){this.$$set({decorateEnableButtonFlipVertical:e}),flush()}get decorateEnableSelectImagePreset(){return this.$$.ctx[24]}set decorateEnableSelectImagePreset(e){this.$$set({decorateEnableSelectImagePreset:e}),flush()}get decorateEnableDropImagePreset(){return this.$$.ctx[25]}set decorateEnableDropImagePreset(e){this.$$set({decorateEnableDropImagePreset:e}),flush()}get decoratePresets(){return this.$$.ctx[26]}set decoratePresets(e){this.$$set({decoratePresets:e}),flush()}get decorateWillRenderShapePresetToolbar(){return this.$$.ctx[27]}set decorateWillRenderShapePresetToolbar(e){this.$$set({decorateWillRenderShapePresetToolbar:e}),flush()}get decorateWillRenderShapeStyleControls(){return this.$$.ctx[28]}set decorateWillRenderShapeStyleControls(e){this.$$set({decorateWillRenderShapeStyleControls:e}),flush()}get enableSelectToolToAddShape(){return this.$$.ctx[29]}set enableSelectToolToAddShape(e){this.$$set({enableSelectToolToAddShape:e}),flush()}get enableTapToAddText(){return this.$$.ctx[30]}set enableTapToAddText(e){this.$$set({enableTapToAddText:e}),flush()}get enableViewTool(){return this.$$.ctx[31]}set enableViewTool(e){this.$$set({enableViewTool:e}),flush()}get enableMoveTool(){return this.$$.ctx[32]}set enableMoveTool(e){this.$$set({enableMoveTool:e}),flush()}get enableAutoSelectMoveTool(){return this.$$.ctx[33]}set enableAutoSelectMoveTool(e){this.$$set({enableAutoSelectMoveTool:e}),flush()}get enableMultiSelect(){return this.$$.ctx[34]}set enableMultiSelect(e){this.$$set({enableMultiSelect:e}),flush()}get willRenderShapeControls(){return this.$$.ctx[35]}set willRenderShapeControls(e){this.$$set({willRenderShapeControls:e}),flush()}get willRenderShapeTextControls(){return this.$$.ctx[36]}set willRenderShapeTextControls(e){this.$$set({willRenderShapeTextControls:e}),flush()}get beforeAddShape(){return this.$$.ctx[37]}set beforeAddShape(e){this.$$set({beforeAddShape:e}),flush()}get beforeRemoveShape(){return this.$$.ctx[38]}set beforeRemoveShape(e){this.$$set({beforeRemoveShape:e}),flush()}get beforeDeselectShape(){return this.$$.ctx[39]}set beforeDeselectShape(e){this.$$set({beforeDeselectShape:e}),flush()}get beforeSelectShape(){return this.$$.ctx[40]}set beforeSelectShape(e){this.$$set({beforeSelectShape:e}),flush()}get beforeUpdateShape(){return this.$$.ctx[41]}set beforeUpdateShape(e){this.$$set({beforeUpdateShape:e}),flush()}get markupEditorWillStartInteraction(){return this.$$.ctx[42]}set markupEditorWillStartInteraction(e){this.$$set({markupEditorWillStartInteraction:e}),flush()}}var _plugin_decorate={util:["decorate",Decorate]};function create_fragment$8(e){let t,o;return t=new ShapeUtil({props:{stores:e[3],locale:e[4],isActive:e[0],isActiveFraction:e[1],isVisible:e[2],mapScreenPointToImagePoint:e[26],mapImagePointToScreenPoint:e[25],utilKey:"sticker",shapePresets:e[5],shapes:e[6]?e[35]:e[36],toolActive:"preset",imageFlipX:!!e[6]&&e[24],imageFlipY:!!e[6]&&e[23],imageRotation:e[6]?e[31]:0,parentRect:e[6]?e[37]:e[33],snapThreshold:e[29],gridSize:e[28],enableMultiSelect:e[12],enableSnapToContext:e[27],enablePresetDropImage:e[7],enablePresetSelectImage:e[30],enableButtonFlipVertical:e[10]||e[8],toolSelectRadius:e[15],willStartInteraction:e[22],willRenderPresetToolbar:e[11]||e[9]||e[16],hooks:{willRenderShapeControls:e[13],willRenderShapeTextControls:e[14],beforeAddShape:e[17],beforeRemoveShape:e[18],beforeDeselectShape:e[19],beforeSelectShape:e[20],beforeUpdateShape:e[21]}}}),t.$on("measure",e[60]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};8&o[0]&&(r.stores=e[3]),16&o[0]&&(r.locale=e[4]),1&o[0]&&(r.isActive=e[0]),2&o[0]&&(r.isActiveFraction=e[1]),4&o[0]&&(r.isVisible=e[2]),67108864&o[0]&&(r.mapScreenPointToImagePoint=e[26]),33554432&o[0]&&(r.mapImagePointToScreenPoint=e[25]),32&o[0]&&(r.shapePresets=e[5]),64&o[0]&&(r.shapes=e[6]?e[35]:e[36]),16777280&o[0]&&(r.imageFlipX=!!e[6]&&e[24]),8388672&o[0]&&(r.imageFlipY=!!e[6]&&e[23]),64&o[0]|1&o[1]&&(r.imageRotation=e[6]?e[31]:0),64&o[0]&&(r.parentRect=e[6]?e[37]:e[33]),536870912&o[0]&&(r.snapThreshold=e[29]),268435456&o[0]&&(r.gridSize=e[28]),4096&o[0]&&(r.enableMultiSelect=e[12]),134217728&o[0]&&(r.enableSnapToContext=e[27]),128&o[0]&&(r.enablePresetDropImage=e[7]),1073741824&o[0]&&(r.enablePresetSelectImage=e[30]),1280&o[0]&&(r.enableButtonFlipVertical=e[10]||e[8]),32768&o[0]&&(r.toolSelectRadius=e[15]),4194304&o[0]&&(r.willStartInteraction=e[22]),68096&o[0]&&(r.willRenderPresetToolbar=e[11]||e[9]||e[16]),4087808&o[0]&&(r.hooks={willRenderShapeControls:e[13],willRenderShapeTextControls:e[14],beforeAddShape:e[17],beforeRemoveShape:e[18],beforeDeselectShape:e[19],beforeSelectShape:e[20],beforeUpdateShape:e[21]}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function instance$8(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$;let{isActive:b}=t,{isActiveFraction:y}=t,{isVisible:_}=t,{stores:x}=t,{locale:v={}}=t,{stickers:S=[]}=t,{stickerForceEnable:C=!1}=t,{stickerStickToImage:w=!1}=t,{stickerEnableSelectImagePreset:T=!0}=t,{stickerEnableDropImagePreset:k=!0}=t,{stickerEnableButtonFlipVertical:R=!1}=t,{stickerWillRenderShapePresetToolbar:P}=t,{stickerEnableSelectImage:I=!0}=t,{stickersEnableButtonFlipVertical:E=!1}=t,{stickersWillRenderShapePresetToolbar:M}=t,{markupEditorGridSize:A=0}=t,{markupEditorSnapThreshold:F=0}=t,{markupEditorSnapToContext:L=!1}=t,{enableMultiSelect:D}=t,{annotateGridSize:z}=t,{annotateSnapToContext:O}=t,{decorateGridSize:B}=t,{decorateSnapToContext:N}=t,{willRenderShapeControls:V}=t,{willRenderShapeTextControls:W}=t,{markupEditorToolSelectRadius:U}=t,{willRenderShapePresetToolbar:H}=t,{beforeAddShape:G}=t,{beforeRemoveShape:j}=t,{beforeDeselectShape:q}=t,{beforeSelectShape:X}=t,{beforeUpdateShape:Y}=t,{markupEditorWillStartInteraction:Z}=t;const{rootRect:K,imageCropRect:J,imageSelectionRectPresentation:Q,imageAnnotation:ee,imageDecoration:te,imageSize:oe,imageTransforms:re,imageTransformsInterpolated:ne,imageRotation:ie,imageFlipX:ae,imageFlipY:se}=x;return component_subscribe(e,K,(e=>o(59,f=e))),component_subscribe(e,Q,(e=>o(55,u=e))),component_subscribe(e,oe,(e=>o(58,g=e))),component_subscribe(e,re,(e=>o(57,m=e))),component_subscribe(e,ne,(e=>o(56,h=e))),component_subscribe(e,ie,(e=>o(31,$=e))),component_subscribe(e,ae,(e=>o(24,d=e))),component_subscribe(e,se,(e=>o(23,p=e))),e.$$set=e=>{"isActive"in e&&o(0,b=e.isActive),"isActiveFraction"in e&&o(1,y=e.isActiveFraction),"isVisible"in e&&o(2,_=e.isVisible),"stores"in e&&o(3,x=e.stores),"locale"in e&&o(4,v=e.locale),"stickers"in e&&o(5,S=e.stickers),"stickerForceEnable"in e&&o(44,C=e.stickerForceEnable),"stickerStickToImage"in e&&o(6,w=e.stickerStickToImage),"stickerEnableSelectImagePreset"in e&&o(45,T=e.stickerEnableSelectImagePreset),"stickerEnableDropImagePreset"in e&&o(7,k=e.stickerEnableDropImagePreset),"stickerEnableButtonFlipVertical"in e&&o(8,R=e.stickerEnableButtonFlipVertical),"stickerWillRenderShapePresetToolbar"in e&&o(9,P=e.stickerWillRenderShapePresetToolbar),"stickerEnableSelectImage"in e&&o(46,I=e.stickerEnableSelectImage),"stickersEnableButtonFlipVertical"in e&&o(10,E=e.stickersEnableButtonFlipVertical),"stickersWillRenderShapePresetToolbar"in e&&o(11,M=e.stickersWillRenderShapePresetToolbar),"markupEditorGridSize"in e&&o(47,A=e.markupEditorGridSize),"markupEditorSnapThreshold"in e&&o(48,F=e.markupEditorSnapThreshold),"markupEditorSnapToContext"in e&&o(49,L=e.markupEditorSnapToContext),"enableMultiSelect"in e&&o(12,D=e.enableMultiSelect),"annotateGridSize"in e&&o(50,z=e.annotateGridSize),"annotateSnapToContext"in e&&o(51,O=e.annotateSnapToContext),"decorateGridSize"in e&&o(52,B=e.decorateGridSize),"decorateSnapToContext"in e&&o(53,N=e.decorateSnapToContext),"willRenderShapeControls"in e&&o(13,V=e.willRenderShapeControls),"willRenderShapeTextControls"in e&&o(14,W=e.willRenderShapeTextControls),"markupEditorToolSelectRadius"in e&&o(15,U=e.markupEditorToolSelectRadius),"willRenderShapePresetToolbar"in e&&o(16,H=e.willRenderShapePresetToolbar),"beforeAddShape"in e&&o(17,G=e.beforeAddShape),"beforeRemoveShape"in e&&o(18,j=e.beforeRemoveShape),"beforeDeselectShape"in e&&o(19,q=e.beforeDeselectShape),"beforeSelectShape"in e&&o(20,X=e.beforeSelectShape),"beforeUpdateShape"in e&&o(21,Y=e.beforeUpdateShape),"markupEditorWillStartInteraction"in e&&o(22,Z=e.markupEditorWillStartInteraction)},e.$$.update=()=>{33554432&e.$$.dirty[1]&&o(54,r=h?h.scale:1),49152&e.$$.dirty[1]&&o(30,n=!1!==T&&I),131072&e.$$.dirty[1]&&o(29,i=F),64&e.$$.dirty[0]|2686976&e.$$.dirty[1]&&o(28,a=w?isNumber(z)?z:A:isNumber(B)?B:A),64&e.$$.dirty[0]|5505024&e.$$.dirty[1]&&o(27,s=w?isBoolean(O)?O:L:isBoolean(N)?N:L),25165888&e.$$.dirty[0]|528482304&e.$$.dirty[1]&&o(26,l=w?e=>_mapScreenPointToImagePoint(e,f,g,h.origin,h.translation,m.rotation.z,h.scale,d,p):e=>{const t=vectorClone(e);return t.x-=u.x,t.y-=u.y,t.x/=r,t.y/=r,t}),25165888&e.$$.dirty[0]|528482304&e.$$.dirty[1]&&o(25,c=w?e=>_mapImagePointToScreenPoint(e,f,g,h.origin,h.translation,m.rotation.z,h.scale,d,p):e=>{const t=vectorClone(e);return t.x*=r,t.y*=r,t.x+=u.x,t.y+=u.y,t})},[b,y,_,x,v,S,w,k,R,P,E,M,D,V,W,U,H,G,j,q,X,Y,Z,p,d,c,l,s,a,i,n,$,K,J,Q,ee,te,oe,re,ne,ie,ae,se,"sticker",C,T,I,A,F,L,z,O,B,N,r,u,h,m,g,f,function(t){bubble.call(this,e,t)}]}class Sticker extends SvelteComponent{constructor(e){super(),init(this,e,instance$8,create_fragment$8,safe_not_equal,{name:43,isActive:0,isActiveFraction:1,isVisible:2,stores:3,locale:4,stickers:5,stickerForceEnable:44,stickerStickToImage:6,stickerEnableSelectImagePreset:45,stickerEnableDropImagePreset:7,stickerEnableButtonFlipVertical:8,stickerWillRenderShapePresetToolbar:9,stickerEnableSelectImage:46,stickersEnableButtonFlipVertical:10,stickersWillRenderShapePresetToolbar:11,markupEditorGridSize:47,markupEditorSnapThreshold:48,markupEditorSnapToContext:49,enableMultiSelect:12,annotateGridSize:50,annotateSnapToContext:51,decorateGridSize:52,decorateSnapToContext:53,willRenderShapeControls:13,willRenderShapeTextControls:14,markupEditorToolSelectRadius:15,willRenderShapePresetToolbar:16,beforeAddShape:17,beforeRemoveShape:18,beforeDeselectShape:19,beforeSelectShape:20,beforeUpdateShape:21,markupEditorWillStartInteraction:22},null,[-1,-1])}get name(){return this.$$.ctx[43]}get isActive(){return this.$$.ctx[0]}set isActive(e){this.$$set({isActive:e}),flush()}get isActiveFraction(){return this.$$.ctx[1]}set isActiveFraction(e){this.$$set({isActiveFraction:e}),flush()}get isVisible(){return this.$$.ctx[2]}set isVisible(e){this.$$set({isVisible:e}),flush()}get stores(){return this.$$.ctx[3]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[4]}set locale(e){this.$$set({locale:e}),flush()}get stickers(){return this.$$.ctx[5]}set stickers(e){this.$$set({stickers:e}),flush()}get stickerForceEnable(){return this.$$.ctx[44]}set stickerForceEnable(e){this.$$set({stickerForceEnable:e}),flush()}get stickerStickToImage(){return this.$$.ctx[6]}set stickerStickToImage(e){this.$$set({stickerStickToImage:e}),flush()}get stickerEnableSelectImagePreset(){return this.$$.ctx[45]}set stickerEnableSelectImagePreset(e){this.$$set({stickerEnableSelectImagePreset:e}),flush()}get stickerEnableDropImagePreset(){return this.$$.ctx[7]}set stickerEnableDropImagePreset(e){this.$$set({stickerEnableDropImagePreset:e}),flush()}get stickerEnableButtonFlipVertical(){return this.$$.ctx[8]}set stickerEnableButtonFlipVertical(e){this.$$set({stickerEnableButtonFlipVertical:e}),flush()}get stickerWillRenderShapePresetToolbar(){return this.$$.ctx[9]}set stickerWillRenderShapePresetToolbar(e){this.$$set({stickerWillRenderShapePresetToolbar:e}),flush()}get stickerEnableSelectImage(){return this.$$.ctx[46]}set stickerEnableSelectImage(e){this.$$set({stickerEnableSelectImage:e}),flush()}get stickersEnableButtonFlipVertical(){return this.$$.ctx[10]}set stickersEnableButtonFlipVertical(e){this.$$set({stickersEnableButtonFlipVertical:e}),flush()}get stickersWillRenderShapePresetToolbar(){return this.$$.ctx[11]}set stickersWillRenderShapePresetToolbar(e){this.$$set({stickersWillRenderShapePresetToolbar:e}),flush()}get markupEditorGridSize(){return this.$$.ctx[47]}set markupEditorGridSize(e){this.$$set({markupEditorGridSize:e}),flush()}get markupEditorSnapThreshold(){return this.$$.ctx[48]}set markupEditorSnapThreshold(e){this.$$set({markupEditorSnapThreshold:e}),flush()}get markupEditorSnapToContext(){return this.$$.ctx[49]}set markupEditorSnapToContext(e){this.$$set({markupEditorSnapToContext:e}),flush()}get enableMultiSelect(){return this.$$.ctx[12]}set enableMultiSelect(e){this.$$set({enableMultiSelect:e}),flush()}get annotateGridSize(){return this.$$.ctx[50]}set annotateGridSize(e){this.$$set({annotateGridSize:e}),flush()}get annotateSnapToContext(){return this.$$.ctx[51]}set annotateSnapToContext(e){this.$$set({annotateSnapToContext:e}),flush()}get decorateGridSize(){return this.$$.ctx[52]}set decorateGridSize(e){this.$$set({decorateGridSize:e}),flush()}get decorateSnapToContext(){return this.$$.ctx[53]}set decorateSnapToContext(e){this.$$set({decorateSnapToContext:e}),flush()}get willRenderShapeControls(){return this.$$.ctx[13]}set willRenderShapeControls(e){this.$$set({willRenderShapeControls:e}),flush()}get willRenderShapeTextControls(){return this.$$.ctx[14]}set willRenderShapeTextControls(e){this.$$set({willRenderShapeTextControls:e}),flush()}get markupEditorToolSelectRadius(){return this.$$.ctx[15]}set markupEditorToolSelectRadius(e){this.$$set({markupEditorToolSelectRadius:e}),flush()}get willRenderShapePresetToolbar(){return this.$$.ctx[16]}set willRenderShapePresetToolbar(e){this.$$set({willRenderShapePresetToolbar:e}),flush()}get beforeAddShape(){return this.$$.ctx[17]}set beforeAddShape(e){this.$$set({beforeAddShape:e}),flush()}get beforeRemoveShape(){return this.$$.ctx[18]}set beforeRemoveShape(e){this.$$set({beforeRemoveShape:e}),flush()}get beforeDeselectShape(){return this.$$.ctx[19]}set beforeDeselectShape(e){this.$$set({beforeDeselectShape:e}),flush()}get beforeSelectShape(){return this.$$.ctx[20]}set beforeSelectShape(e){this.$$set({beforeSelectShape:e}),flush()}get beforeUpdateShape(){return this.$$.ctx[21]}set beforeUpdateShape(e){this.$$set({beforeUpdateShape:e}),flush()}get markupEditorWillStartInteraction(){return this.$$.ctx[22]}set markupEditorWillStartInteraction(e){this.$$set({markupEditorWillStartInteraction:e}),flush()}}var _plugin_sticker={util:["sticker",Sticker,({stickers:e,stickerEnableSelectImage:t,stickerEnableSelectImagePreset:o,stickerEnableDropImagePreset:r,stickerForceEnable:n})=>e&&e.length||t||o||r||n]};function create_else_block$1(e){let t,o,r=(e[14](e[36].value)||"")+"";return{c(){t=new HtmlTag(!1),o=empty(),t.a=o},m(e,n){t.m(r,e,n),insert(e,o,n)},p(e,o){32&o[1]&&r!==(r=(e[14](e[36].value)||"")+"")&&t.p(r)},i:noop,o:noop,d(e){e&&detach(o),e&&t.d()}}}function create_if_block$1(e){let t,o;return t=new DynamicComponentTree_1({props:{items:e[16](e[36].value)}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};32&o[1]&&(r.items=e[16](e[36].value)),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_option_slot$1(e){let t,o,r,n,i,a,s,l,c=(isFunction(e[36].label)?e[36].label(e[1]):e[36].label)+"";const u=[create_if_block$1,create_else_block$1],p=[];function d(e,t){return 32&t[1]&&(o=null),null==o&&(o=!!e[15](e[36].value)),o?0:1}return r=d(e,[-1,-1]),n=p[r]=u[r](e),{c(){t=element("div"),n.c(),i=space(),a=element("span"),s=text(c),attr(t,"slot","option")},m(e,o){insert(e,t,o),p[r].m(t,null),append(t,i),append(t,a),append(a,s),l=!0},p(e,o){let a=r;r=d(e,o),r===a?p[r].p(e,o):(group_outros(),transition_out(p[a],1,1,(()=>{p[a]=null})),check_outros(),n=p[r],n?n.p(e,o):(n=p[r]=u[r](e),n.c()),transition_in(n,1),n.m(t,i)),(!l||2&o[0]|32&o[1])&&c!==(c=(isFunction(e[36].label)?e[36].label(e[1]):e[36].label)+"")&&set_data(s,c)},i(e){l||(transition_in(n),l=!0)},o(e){transition_out(n),l=!1},d(e){e&&detach(t),p[r].d()}}}function create_default_slot$3(e){let t,o;return t=new RadioGroup({props:{locale:e[1],class:"PinturaControlList",layout:"row",options:e[2],selectedIndex:e[6],onchange:e[12],$$slots:{option:[create_option_slot$1,({option:e})=>({36:e}),({option:e})=>[0,e?32:0]]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};2&o[0]&&(r.locale=e[1]),4&o[0]&&(r.options=e[2]),64&o[0]&&(r.selectedIndex=e[6]),2&o[0]|96&o[1]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_footer_slot$2(e){let t,o,r,n,i;return o=new ShapeStyleEditor({props:{locale:e[1],class:"PinturaControlPanels",shapeProps:e[4],onchange:e[13],controls:e[3],scrollElasticity:e[7]}}),n=new Scrollable({props:{elasticity:e[10],$$slots:{default:[create_default_slot$3]},$$scope:{ctx:e}}}),{c(){t=element("div"),create_component(o.$$.fragment),r=space(),create_component(n.$$.fragment),attr(t,"slot","footer"),set_style(t,"transform",e[5])},m(e,a){insert(e,t,a),mount_component(o,t,null),append(t,r),mount_component(n,t,null),i=!0},p(e,r){const i={};2&r[0]&&(i.locale=e[1]),16&r[0]&&(i.shapeProps=e[4]),8&r[0]&&(i.controls=e[3]),128&r[0]&&(i.scrollElasticity=e[7]),o.$set(i);const a={};70&r[0]|64&r[1]&&(a.$$scope={dirty:r,ctx:e}),n.$set(a),32&r[0]&&set_style(t,"transform",e[5])},i(e){i||(transition_in(o.$$.fragment,e),transition_in(n.$$.fragment,e),i=!0)},o(e){transition_out(o.$$.fragment,e),transition_out(n.$$.fragment,e),i=!1},d(e){e&&detach(t),destroy_component(o),destroy_component(n)}}}function create_fragment$7(e){let t,o;return t=new Util({props:{$$slots:{footer:[create_footer_slot$2]},$$scope:{ctx:e}}}),t.$on("measure",e[25]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};254&o[0]|64&o[1]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function instance$7(e,t,o){let r,n,i,a,s,l,c,u,p=noop,d=()=>(p(),p=subscribe(h,(e=>o(22,s=e))),h);e.$$.on_destroy.push((()=>p()));let{isActive:h}=t;d();let{stores:m}=t,{locale:g={}}=t,{frameStyles:f={}}=t,{frameOptions:$=[]}=t,{markupEditorShapeStyleControls:b}=t;const y=getContext("elasticityMultiplier");component_subscribe(e,y,(e=>o(24,u=e)));const{history:_,animation:x,scrollElasticity:v,imageFrame:S,allowPan:C,allowZoom:w,allowZoomControls:T,allowPlayPause:k}=m;component_subscribe(e,x,(e=>o(23,l=e))),component_subscribe(e,S,(e=>o(4,c=e)));let R={};let P;const I=spring(l?20:0);return component_subscribe(e,I,(e=>o(21,a=e))),e.$$set=e=>{"isActive"in e&&d(o(0,h=e.isActive)),"stores"in e&&o(19,m=e.stores),"locale"in e&&o(1,g=e.locale),"frameStyles"in e&&o(20,f=e.frameStyles),"frameOptions"in e&&o(2,$=e.frameOptions),"markupEditorShapeStyleControls"in e&&o(3,b=e.markupEditorShapeStyleControls)},e.$$.update=()=>{4194304&e.$$.dirty[0]&&C.set(s),4194304&e.$$.dirty[0]&&w.set(s),4194304&e.$$.dirty[0]&&T.set(s),4194304&e.$$.dirty[0]&&s&&k.set(!0),16777216&e.$$.dirty[0]&&o(7,r=u*v),20&e.$$.dirty[0]&&o(6,n=c?$.findIndex((([e])=>e===c.id)):0),12582912&e.$$.dirty[0]&&l&&I.set(s?0:20),2097152&e.$$.dirty[0]&&o(5,i=a?`translateY(${a}px)`:"none")},[h,g,$,b,c,i,n,r,y,x,v,S,({value:e})=>{const t=f[e];if(!t||!t.shape)return S.set(void 0),void _.write();const{shape:o}=t,r={id:e,...shapeDeepCopy(o),...Object.keys(R).reduce(((e,t)=>o[t]?(e[t]=R[t],e):e),{})};S.set(r),_.write()},function(e){hasProp(e,"frameColor")&&(R.frameColor=e.frameColor),c&&(shapeUpdateProps(c,e),S.set(c),clearTimeout(P),P=setTimeout((()=>{_.write()}),200))},e=>{const t=f[e];var o;if(t&&t.thumb)return o=t.thumb,/div/i.test(o)||isSVGMarkup(o)?o:/rect|path|circle|line|<g>/i.test(o)?`<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" stroke-width="1" stroke="currentColor" fill="none" aria-hidden="true" focusable="false" stroke-linecap="round" stroke-linejoin="round">${o}</svg>`:`<img src="${o}" alt=""/>`},e=>{const t=f[e];return!(!t||!t.thumb)&&isArray(t.thumb)},e=>f[e].thumb,I,"frame",m,f,a,s,l,u,function(t){bubble.call(this,e,t)}]}class Frame extends SvelteComponent{constructor(e){super(),init(this,e,instance$7,create_fragment$7,safe_not_equal,{name:18,isActive:0,stores:19,locale:1,frameStyles:20,frameOptions:2,markupEditorShapeStyleControls:3},null,[-1,-1])}get name(){return this.$$.ctx[18]}get isActive(){return this.$$.ctx[0]}set isActive(e){this.$$set({isActive:e}),flush()}get stores(){return this.$$.ctx[19]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[1]}set locale(e){this.$$set({locale:e}),flush()}get frameStyles(){return this.$$.ctx[20]}set frameStyles(e){this.$$set({frameStyles:e}),flush()}get frameOptions(){return this.$$.ctx[2]}set frameOptions(e){this.$$set({frameOptions:e}),flush()}get markupEditorShapeStyleControls(){return this.$$.ctx[3]}set markupEditorShapeStyleControls(e){this.$$set({markupEditorShapeStyleControls:e}),flush()}}var _plugin_frame={util:["frame",Frame,({src:e})=>e&&!isVideoFile(e)]};function create_fragment$6(e){let t,o,r,n,i,a,s,l;return{c(){t=element("div"),o=element("input"),n=space(),i=element("label"),a=text(e[1]),attr(o,"id",e[0]),attr(o,"type","number"),attr(o,"min","1"),attr(o,"inputmode","numeric"),attr(o,"pattern","[0-9]*"),attr(o,"data-state",e[3]),attr(o,"autocomplete","off"),attr(o,"placeholder",e[4]),o.value=r=void 0===e[5]?"":e[7](e[5]+""),attr(i,"for",e[0]),attr(i,"title",e[2]),attr(i,"aria-label",e[2]),attr(t,"class","PinturaInputDimension")},m(r,c){insert(r,t,c),append(t,o),append(t,n),append(t,i),append(i,a),s||(l=listen(o,"input",e[8]),s=!0)},p(e,[t]){1&t&&attr(o,"id",e[0]),8&t&&attr(o,"data-state",e[3]),16&t&&attr(o,"placeholder",e[4]),160&t&&r!==(r=void 0===e[5]?"":e[7](e[5]+""))&&o.value!==r&&(o.value=r),2&t&&set_data(a,e[1]),1&t&&attr(i,"for",e[0]),4&t&&attr(i,"title",e[2]),4&t&&attr(i,"aria-label",e[2])},i:noop,o:noop,d(e){e&&detach(t),s=!1,l()}}}function instance$6(e,t,o){let{id:r}=t,{label:n}=t,{title:i}=t,{state:a}=t,{placeholder:s}=t,{value:l}=t,{onchange:c}=t,{format:u=e=>e.replace(/\D/g,"")}=t;return e.$$set=e=>{"id"in e&&o(0,r=e.id),"label"in e&&o(1,n=e.label),"title"in e&&o(2,i=e.title),"state"in e&&o(3,a=e.state),"placeholder"in e&&o(4,s=e.placeholder),"value"in e&&o(5,l=e.value),"onchange"in e&&o(6,c=e.onchange),"format"in e&&o(7,u=e.format)},[r,n,i,a,s,l,c,u,e=>c(u(e.currentTarget.value))]}class DimensionInput extends SvelteComponent{constructor(e){super(),init(this,e,instance$6,create_fragment$6,safe_not_equal,{id:0,label:1,title:2,state:3,placeholder:4,value:5,onchange:6,format:7})}}function create_default_slot$2(e){let t;return{c(){t=svg_element("g")},m(o,r){insert(o,t,r),t.innerHTML=e[2]},p(e,o){4&o&&(t.innerHTML=e[2])},d(e){e&&detach(t)}}}function create_fragment$5(e){let t,o,r,n,i,a,s,l;return i=new Icon({props:{$$slots:{default:[create_default_slot$2]},$$scope:{ctx:e}}}),{c(){t=element("div"),o=element("input"),r=space(),n=element("label"),create_component(i.$$.fragment),attr(o,"id",e[0]),attr(o,"class","implicit"),attr(o,"type","checkbox"),o.checked=e[1],attr(n,"for",e[0]),attr(n,"title",e[3])},m(c,u){insert(c,t,u),append(t,o),append(t,r),append(t,n),mount_component(i,n,null),a=!0,s||(l=listen(o,"change",e[5]),s=!0)},p(e,[t]){(!a||1&t)&&attr(o,"id",e[0]),(!a||2&t)&&(o.checked=e[1]);const r={};68&t&&(r.$$scope={dirty:t,ctx:e}),i.$set(r),(!a||1&t)&&attr(n,"for",e[0]),(!a||8&t)&&attr(n,"title",e[3])},i(e){a||(transition_in(i.$$.fragment,e),a=!0)},o(e){transition_out(i.$$.fragment,e),a=!1},d(e){e&&detach(t),destroy_component(i),s=!1,l()}}}function instance$5(e,t,o){let{id:r}=t,{locked:n}=t,{icon:i}=t,{title:a}=t,{onchange:s}=t;return e.$$set=e=>{"id"in e&&o(0,r=e.id),"locked"in e&&o(1,n=e.locked),"icon"in e&&o(2,i=e.icon),"title"in e&&o(3,a=e.title),"onchange"in e&&o(4,s=e.onchange)},[r,n,i,a,s,e=>s(e.currentTarget.checked)]}class DimensionLock extends SvelteComponent{constructor(e){super(),init(this,e,instance$5,create_fragment$5,safe_not_equal,{id:0,locked:1,icon:2,title:3,onchange:4})}}function create_default_slot$1(e){let t;return{c(){t=text("Save")},m(e,o){insert(e,t,o)},d(e){e&&detach(t)}}}function create_footer_slot$1(e){let t,o,r,n,i,a,s,l,c,u,p,d,h,m=e[1].resizeLabelFormCaption+"";return l=new DynamicComponentTree_1({props:{items:e[4]}}),u=new Button({props:{type:"submit",class:"implicit",$$slots:{default:[create_default_slot$1]},$$scope:{ctx:e}}}),{c(){t=element("form"),o=element("div"),r=element("fieldset"),n=element("legend"),i=text(m),a=space(),s=element("div"),create_component(l.$$.fragment),c=space(),create_component(u.$$.fragment),attr(n,"class","implicit"),attr(s,"class","PinturaFieldsetInner"),attr(o,"class","PinturaFormInner"),attr(t,"slot","footer"),set_style(t,"transform",e[3])},m(m,g){insert(m,t,g),append(t,o),append(o,r),append(r,n),append(n,i),append(r,a),append(r,s),mount_component(l,s,null),e[66](s),append(o,c),mount_component(u,o,null),p=!0,d||(h=[listen(s,"focusin",e[15]),listen(s,"focusout",e[16]),listen(t,"submit",prevent_default(e[17]))],d=!0)},p(e,o){(!p||2&o[0])&&m!==(m=e[1].resizeLabelFormCaption+"")&&set_data(i,m);const r={};16&o[0]&&(r.items=e[4]),l.$set(r);const n={};32&o[3]&&(n.$$scope={dirty:o,ctx:e}),u.$set(n),8&o[0]&&set_style(t,"transform",e[3])},i(e){p||(transition_in(l.$$.fragment,e),transition_in(u.$$.fragment,e),p=!0)},o(e){transition_out(l.$$.fragment,e),transition_out(u.$$.fragment,e),p=!1},d(o){o&&detach(t),destroy_component(l),e[66](null),destroy_component(u),d=!1,run_all(h)}}}function create_fragment$4(e){let t,o;return t=new Util({props:{$$slots:{footer:[create_footer_slot$1]},$$scope:{ctx:e}}}),t.$on("measure",e[67]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};30&o[0]|32&o[3]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function instance$4(e,t,o){let r,n,i,a,s,l,c,u,p,d,h,m,g,f,$,b,y,_,x,v,S,C,w,T,k,R,P,I,E,M,A=noop,F=()=>(A(),A=subscribe(D,(e=>o(50,h=e))),D);e.$$.on_destroy.push((()=>A()));const L=(e,t=0,o=9999)=>{if(isString(e)&&!(e=e.replace(/\D/g,"")).length)return;const r=Math.round(e);return Number.isNaN(r)?void 0:clamp(r,t,o)};let{isActive:D}=t;F();let{stores:z}=t,{locale:O={}}=t,{resizeMinSize:B=sizeCreate(1,1)}=t,{resizeMaxSize:N=sizeCreate(9999,9999)}=t,{resizeAspectRatioLocked:V=!1}=t,{resizeEnableButtonLockAspectRatio:W=!0}=t,{resizeSizePresetOptions:U}=t,{resizeWidthPresetOptions:H}=t,{resizeHeightPresetOptions:G}=t,{resizeWillRenderFooter:j=passthrough}=t,{resizeFormatIconButtonMaintainAspectRatio:q=function(e){const{active:t,activeFraction:o}=e;return{active:t,activeFraction:3*(o-1)}}}=t;const X=spring(0,{stiffness:.15,damping:.3});component_subscribe(e,X,(e=>o(55,b=e)));const{animation:Y,imageSize:Z,imageCropRect:K,imageCropRectAspectRatio:J,imageCropAspectRatio:Q,imageOutputSize:ee,imageSelectionZoom:te,imageSelectionPan:oe,history:re,env:ne,allowPan:ie,allowZoom:ae,allowZoomControls:se,allowPlayPause:le}=z;component_subscribe(e,Y,(e=>o(51,m=e))),component_subscribe(e,Z,(e=>o(74,I=e))),component_subscribe(e,K,(e=>o(53,f=e))),component_subscribe(e,J,(e=>o(54,$=e))),component_subscribe(e,Q,(e=>o(73,T=e))),component_subscribe(e,ee,(e=>o(62,w=e))),component_subscribe(e,te,(e=>o(75,E=e))),component_subscribe(e,oe,(e=>o(76,M=e))),component_subscribe(e,ne,(e=>o(52,g=e)));const ce=getUniqueId();let ue,pe,de,he,me,ge,fe=vectorCreateEmpty();const $e=(e,t,o,r,n)=>null!=e&&o!==t?e>=r[t]&&e<=n[t]?"valid":"invalid":"undetermined",be=(e,t,o)=>Math.round(null!=e?e/t:o.height),ye=()=>{V&&pe&&de&&("width"===he?o(40,de=Math.round(pe/$)):"height"===he?o(39,pe=Math.round(de*$)):("width"===me?o(40,de=Math.round(pe/$)):"height"===me&&o(39,pe=Math.round(de*$)),_e()))},_e=e=>{let t=L(pe),r=L(de),n=t,i=r,a=n&&i,s=e||$;if(!n&&!i)return;n&&!i?i=Math.round(n/s):i&&!n&&(n=Math.round(i*s)),s=e||a?getAspectRatio(n,i):$;let l=sizeCreate(n,i);sizeContains(N,l)||(l=rectContainRect(N,s)),sizeContains(l,B)||(l=rectCoverRect(B,s)),o(39,pe=null!=t?Math.round(l.width):void 0),o(40,de=null!=r?Math.round(l.height):void 0)},xe=()=>{_e();const{width:e,height:t}=w||{};e===pe&&t===de||(pe||de?(pe&&de&&set_store_value(Q,T=pe/de,T),set_store_value(ee,w=sizeCreate(pe,de),w)):(set_store_value(Q,T=I.width/I.height,T),set_store_value(Q,T=void 0,T),set_store_value(ee,w=void 0,w)),re.write())},ve=ee.subscribe((e=>{if(!e)return o(39,pe=void 0),void o(40,de=void 0);o(39,pe=e.width),o(40,de=e.height),_e()})),Se=Q.subscribe((e=>{(pe||de)&&e&&(pe&&de&&getAspectRatio(pe,de)!==e?(o(40,de=pe/e),_e(e)):_e())})),Ce=e=>isString(e[0])?(e[1]=e[1].map(Ce),e):isNumber(e)?[e,""+e]:e,we=e=>{if(isString(e[0]))return e[1]=e[1].map(we),e;let[t,o]=e;if(isNumber(t)&&isNumber(o)){const[e,r]=[t,o];o=`${e} &times; ${r}`,t=[e,r]}return[t,o]},Te=writable();component_subscribe(e,Te,(e=>o(61,C=e)));const ke=writable();component_subscribe(e,ke,(e=>o(65,P=e)));const Re=writable();component_subscribe(e,Re,(e=>o(59,v=e)));const Pe=writable();component_subscribe(e,Pe,(e=>o(64,R=e)));const Ie=writable();component_subscribe(e,Ie,(e=>o(57,_=e)));const Ee=writable();component_subscribe(e,Ee,(e=>o(63,k=e)));const Me=derived([ee,ke],(([e,t],o)=>{if(!t)return o(-1);const r=t.findIndex((([t])=>{if(!t&&!e)return!0;if(!t)return!1;const[o,r]=t;return e.width===o&&e.height===r}));o(r<0?0:r)}));component_subscribe(e,Me,(e=>o(60,S=e)));const Ae=derived([ee,Pe],(([e,t],o)=>{if(!t)return o(-1);const r=t.findIndex((([t])=>!t&&!e||!!t&&e.width===t));o(r<0?0:r)}));component_subscribe(e,Ae,(e=>o(58,x=e)));const Fe=derived([ee,Ee],(([e,t],o)=>{if(!t)return o(-1);const r=t.findIndex((([t])=>!t&&!e||!!t&&e.height===t));o(r<0?0:r)}));let Le,De;component_subscribe(e,Fe,(e=>o(56,y=e)));const ze=getContext("redrawTrigger"),Oe=spring(m?20:0);return component_subscribe(e,Oe,(e=>o(49,d=e))),onDestroy((()=>{ve(),Se()})),e.$$set=e=>{"isActive"in e&&F(o(0,D=e.isActive)),"stores"in e&&o(30,z=e.stores),"locale"in e&&o(1,O=e.locale),"resizeMinSize"in e&&o(31,B=e.resizeMinSize),"resizeMaxSize"in e&&o(32,N=e.resizeMaxSize),"resizeAspectRatioLocked"in e&&o(28,V=e.resizeAspectRatioLocked),"resizeEnableButtonLockAspectRatio"in e&&o(33,W=e.resizeEnableButtonLockAspectRatio),"resizeSizePresetOptions"in e&&o(34,U=e.resizeSizePresetOptions),"resizeWidthPresetOptions"in e&&o(35,H=e.resizeWidthPresetOptions),"resizeHeightPresetOptions"in e&&o(36,G=e.resizeHeightPresetOptions),"resizeWillRenderFooter"in e&&o(37,j=e.resizeWillRenderFooter),"resizeFormatIconButtonMaintainAspectRatio"in e&&o(38,q=e.resizeFormatIconButtonMaintainAspectRatio)},e.$$.update=()=>{524288&e.$$.dirty[1]&&ie.set(!h),524288&e.$$.dirty[1]&&ae.set(!h),524288&e.$$.dirty[1]&&se.set(!h),524288&e.$$.dirty[1]&&h&&le.set(!0),1073741832&e.$$.dirty[1]&&U&&(set_store_value(Te,C=U.map(we),C),set_store_value(ke,P=flattenOptions(C),P)),1073741824&e.$$.dirty[1]&&o(48,a=!!C),536870912&e.$$.dirty[1]|8&e.$$.dirty[2]&&o(47,r=S>-1&&P[S][1]),268435472&e.$$.dirty[1]&&H&&(set_store_value(Re,v=H.map(Ce),v),set_store_value(Pe,R=flattenOptions(v),R)),268566528&e.$$.dirty[1]&&o(45,s=!a&&v),134217728&e.$$.dirty[1]|4&e.$$.dirty[2]&&o(46,n=x>-1&&R[x][1]),67108896&e.$$.dirty[1]&&G&&(set_store_value(Ie,_=G.map(Ce),_),set_store_value(Ee,k=flattenOptions(_),k)),67239936&e.$$.dirty[1]&&o(44,l=!a&&_),33554432&e.$$.dirty[1]|2&e.$$.dirty[2]&&o(43,i=y>-1&&k[y][1]),155648&e.$$.dirty[1]&&o(42,c=!a&&!s&&!l),268435458&e.$$.dirty[0]|2145648583&e.$$.dirty[1]&&o(4,u=ze&&runSafe((()=>{return j([a&&["Dropdown","size-presets",{label:r,options:C,onchange:e=>{return(t=e.value)&&!Le&&(Le={...f},De=T),t?(set_store_value(Q,T=getAspectRatio(t[0],t[1]),T),set_store_value(ee,w=sizeCreateFromArray(t),w)):(set_store_value(K,f=Le,f),set_store_value(Q,T=De,T),set_store_value(ee,w=void 0,w),Le=void 0,De=void 0),void re.write();var t},selectedIndex:S}],s&&["Dropdown","width-presets",{label:n,options:v,onchange:e=>{o(39,pe=e.value),xe()},selectedIndex:x}],s&&l&&["span","times",{class:"PinturaResizeLabel",innerHTML:"&times;"}],l&&["Dropdown","height-presets",{label:i,options:_,onchange:e=>{o(40,de=e.value),xe()},selectedIndex:y}],c&&[DimensionInput,"width-input",{id:`width-${ce}`,title:O.resizeTitleInputWidth,label:O.resizeLabelInputWidth,placeholder:(e=L(de),t=$,u=f,Math.round(null!=e?e*t:u.width)),value:pe,state:$e(L(pe),"width",he,B,N),onchange:e=>{o(39,pe=e),ye()}}],c&&W&&[DimensionLock,"aspect-ratio-lock",{id:`aspect-ratio-lock-${ce}`,title:O.resizeTitleButtonMaintainAspectRatio,icon:isFunction(O.resizeIconButtonMaintainAspectRatio)?O.resizeIconButtonMaintainAspectRatio(V,b):stringReplace(O.resizeIconButtonMaintainAspectRatio,q({active:V,activeFraction:b}),"{","}"),locked:V,onchange:e=>{o(28,V=e),ye()}}],c&&[DimensionInput,"height-input",{id:`height-${ce}`,title:O.resizeTitleInputHeight,label:O.resizeLabelInputHeight,placeholder:be(L(pe),$,f),value:de,state:$e(L(de),"height",he,B,N),onchange:e=>{o(40,de=e),ye()}}]].filter(Boolean),{...g},(()=>ze.set({})));var e,t,u})).filter(Boolean)),268435456&e.$$.dirty[0]&&X.set(V?1:0),1024&e.$$.dirty[1]&&he&&(me=he),524288&e.$$.dirty[1]&&h&&(fe=M,ge=E),524288&e.$$.dirty[1]|1&e.$$.dirty[2]&&(h?setTimeout((()=>{return e=w,set_store_value(oe,M=vectorCreateEmpty(),M),void set_store_value(te,E=e&&f?e.width/f.width||e.height/f.height:1,E);var e}),0):(set_store_value(oe,M=fe,M),set_store_value(te,E=ge,E))),1572864&e.$$.dirty[1]&&m&&Oe.set(h?0:20),262144&e.$$.dirty[1]&&o(3,p=d?`translateY(${d}px)`:"none")},[D,O,ue,p,u,X,Y,Z,K,J,Q,ee,te,oe,ne,e=>{const t=e.target.id;/width/.test(t)?o(41,he="width"):/height/.test(t)?o(41,he="height"):/aspectRatio/i.test(t)?o(41,he="lock"):o(41,he=void 0)},e=>{ue.contains(e.relatedTarget)||xe(),o(41,he=void 0)},xe,Te,ke,Re,Pe,Ie,Ee,Me,Ae,Fe,Oe,V,"resize",z,B,N,W,U,H,G,j,q,pe,de,he,c,i,l,s,n,r,a,d,h,m,g,f,$,b,y,_,x,v,S,C,w,k,R,P,function(e){binding_callbacks[e?"unshift":"push"]((()=>{ue=e,o(2,ue)}))},function(t){bubble.call(this,e,t)}]}class Resize extends SvelteComponent{constructor(e){super(),init(this,e,instance$4,create_fragment$4,safe_not_equal,{name:29,isActive:0,stores:30,locale:1,resizeMinSize:31,resizeMaxSize:32,resizeAspectRatioLocked:28,resizeEnableButtonLockAspectRatio:33,resizeSizePresetOptions:34,resizeWidthPresetOptions:35,resizeHeightPresetOptions:36,resizeWillRenderFooter:37,resizeFormatIconButtonMaintainAspectRatio:38},null,[-1,-1,-1,-1])}get name(){return this.$$.ctx[29]}get isActive(){return this.$$.ctx[0]}set isActive(e){this.$$set({isActive:e}),flush()}get stores(){return this.$$.ctx[30]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[1]}set locale(e){this.$$set({locale:e}),flush()}get resizeMinSize(){return this.$$.ctx[31]}set resizeMinSize(e){this.$$set({resizeMinSize:e}),flush()}get resizeMaxSize(){return this.$$.ctx[32]}set resizeMaxSize(e){this.$$set({resizeMaxSize:e}),flush()}get resizeAspectRatioLocked(){return this.$$.ctx[28]}set resizeAspectRatioLocked(e){this.$$set({resizeAspectRatioLocked:e}),flush()}get resizeEnableButtonLockAspectRatio(){return this.$$.ctx[33]}set resizeEnableButtonLockAspectRatio(e){this.$$set({resizeEnableButtonLockAspectRatio:e}),flush()}get resizeSizePresetOptions(){return this.$$.ctx[34]}set resizeSizePresetOptions(e){this.$$set({resizeSizePresetOptions:e}),flush()}get resizeWidthPresetOptions(){return this.$$.ctx[35]}set resizeWidthPresetOptions(e){this.$$set({resizeWidthPresetOptions:e}),flush()}get resizeHeightPresetOptions(){return this.$$.ctx[36]}set resizeHeightPresetOptions(e){this.$$set({resizeHeightPresetOptions:e}),flush()}get resizeWillRenderFooter(){return this.$$.ctx[37]}set resizeWillRenderFooter(e){this.$$set({resizeWillRenderFooter:e}),flush()}get resizeFormatIconButtonMaintainAspectRatio(){return this.$$.ctx[38]}set resizeFormatIconButtonMaintainAspectRatio(e){this.$$set({resizeFormatIconButtonMaintainAspectRatio:e}),flush()}}var _plugin_resize={util:["resize",Resize]};function create_fragment$3(e){let t,o;return t=new ShapeUtil({props:{stores:e[3],locale:e[4],isActive:e[0],isActiveFraction:e[1],isVisible:e[2],mapScreenPointToImagePoint:e[10],mapImagePointToScreenPoint:e[9],enableMultiSelect:e[6],utilKey:"redact",imageRotation:e[11],imageFlipX:e[8],imageFlipY:e[7],shapes:e[12],toolbar:["rect"],toolShapes:{rectangle:[{x:0,y:0,width:0,height:0}]},toolActive:"rectangle",parentRect:e[14],enablePresetDropImage:!1,enablePresetSelectImage:!1,willStartInteraction:e[5],hooks:{willRenderShapeControls:e[25]}}}),t.$on("measure",e[26]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,[o]){const r={};8&o&&(r.stores=e[3]),16&o&&(r.locale=e[4]),1&o&&(r.isActive=e[0]),2&o&&(r.isActiveFraction=e[1]),4&o&&(r.isVisible=e[2]),1024&o&&(r.mapScreenPointToImagePoint=e[10]),512&o&&(r.mapImagePointToScreenPoint=e[9]),64&o&&(r.enableMultiSelect=e[6]),2048&o&&(r.imageRotation=e[11]),256&o&&(r.imageFlipX=e[8]),128&o&&(r.imageFlipY=e[7]),32&o&&(r.willStartInteraction=e[5]),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function instance$3(e,t,o){let r,n,i,a,s,l,c,u,p;let{isActive:d}=t,{isActiveFraction:h}=t,{isVisible:m}=t,{stores:g}=t,{locale:f={}}=t,{markupEditorWillStartInteraction:$}=t,{enableMultiSelect:b}=t;const{imageRedaction:y,rootRect:_,imageSize:x,imageRotation:v,imageFlipX:S,imageFlipY:C,imageTransforms:w,imageTransformsInterpolated:T}=g;component_subscribe(e,_,(e=>o(24,u=e))),component_subscribe(e,x,(e=>o(23,c=e))),component_subscribe(e,v,(e=>o(11,p=e))),component_subscribe(e,S,(e=>o(8,a=e))),component_subscribe(e,C,(e=>o(7,i=e))),component_subscribe(e,w,(e=>o(22,l=e))),component_subscribe(e,T,(e=>o(21,s=e)));return e.$$set=e=>{"isActive"in e&&o(0,d=e.isActive),"isActiveFraction"in e&&o(1,h=e.isActiveFraction),"isVisible"in e&&o(2,m=e.isVisible),"stores"in e&&o(3,g=e.stores),"locale"in e&&o(4,f=e.locale),"markupEditorWillStartInteraction"in e&&o(5,$=e.markupEditorWillStartInteraction),"enableMultiSelect"in e&&o(6,b=e.enableMultiSelect)},e.$$.update=()=>{31457664&e.$$.dirty&&o(10,r=e=>_mapScreenPointToImagePoint(e,u,c,s.origin,s.translation,l.rotation.z,s.scale,a,i)),31457664&e.$$.dirty&&o(9,n=e=>_mapImagePointToScreenPoint(e,u,c,s.origin,s.translation,l.rotation.z,s.scale,a,i))},[d,h,m,g,f,$,b,i,a,n,r,p,y,_,x,v,S,C,w,T,"redact",s,l,c,u,e=>{const t=getNodeChildren(e[0]);return removeNode("to-front",t),e},function(t){bubble.call(this,e,t)}]}class Redact extends SvelteComponent{constructor(e){super(),init(this,e,instance$3,create_fragment$3,safe_not_equal,{name:20,isActive:0,isActiveFraction:1,isVisible:2,stores:3,locale:4,markupEditorWillStartInteraction:5,enableMultiSelect:6})}get name(){return this.$$.ctx[20]}get isActive(){return this.$$.ctx[0]}set isActive(e){this.$$set({isActive:e}),flush()}get isActiveFraction(){return this.$$.ctx[1]}set isActiveFraction(e){this.$$set({isActiveFraction:e}),flush()}get isVisible(){return this.$$.ctx[2]}set isVisible(e){this.$$set({isVisible:e}),flush()}get stores(){return this.$$.ctx[3]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[4]}set locale(e){this.$$set({locale:e}),flush()}get markupEditorWillStartInteraction(){return this.$$.ctx[5]}set markupEditorWillStartInteraction(e){this.$$set({markupEditorWillStartInteraction:e}),flush()}get enableMultiSelect(){return this.$$.ctx[6]}set enableMultiSelect(e){this.$$set({enableMultiSelect:e}),flush()}}var _plugin_redact={util:["redact",Redact,({src:e})=>e&&!isVideoFile(e)]};function create_else_block(e){let t;return{c(){t=element("div")},m(e,o){insert(e,t,o)},p:noop,d(e){e&&detach(t)}}}function create_if_block_2(e){let t,o,r,n;return{c(){t=element("div"),attr(t,"class","PinturaFillTile")},m(i,a){insert(i,t,a),r||(n=action_destroyer(o=tile.call(null,t,e[31].value)),r=!0)},p(e,t){o&&is_function(o.update)&&1&t[1]&&o.update.call(null,e[31].value)},d(e){e&&detach(t),r=!1,n()}}}function create_if_block_1(e){let t,o,r;return{c(){t=element("div"),o=element("img"),src_url_equal(o.src,r=e[31].value)||attr(o,"src",r),attr(o,"alt",""),attr(o,"width","48"),attr(o,"height","64"),attr(t,"class","PinturaFillTile")},m(e,r){insert(e,t,r),append(t,o)},p(e,t){1&t[1]&&!src_url_equal(o.src,r=e[31].value)&&attr(o,"src",r)},d(e){e&&detach(t)}}}function create_if_block(e){let t,o,r=(isFunction(e[31].label)?e[31].label(e[1]):e[31].label)+"";return{c(){t=element("span"),o=text(r)},m(e,r){insert(e,t,r),append(t,o)},p(e,t){2&t[0]|1&t[1]&&r!==(r=(isFunction(e[31].label)?e[31].label(e[1]):e[31].label)+"")&&set_data(o,r)},d(e){e&&detach(t)}}}function create_option_slot(e){let t,o,r,n;function i(e,t){return 1&t[1]&&(o=null),1&t[1]&&(r=null),null==o&&(o=!!isString(e[31].value)),o?create_if_block_1:(null==r&&(r=!!isArray(e[31].value)),r?create_if_block_2:create_else_block)}let a=i(e,[-1,-1]),s=a(e),l=e[31].label&&create_if_block(e);return{c(){t=element("div"),s.c(),n=space(),l&&l.c(),attr(t,"slot","option")},m(e,o){insert(e,t,o),s.m(t,null),append(t,n),l&&l.m(t,null)},p(e,o){a===(a=i(e,o))&&s?s.p(e,o):(s.d(1),s=a(e),s&&(s.c(),s.m(t,n))),e[31].label?l?l.p(e,o):(l=create_if_block(e),l.c(),l.m(t,null)):l&&(l.d(1),l=null)},d(e){e&&detach(t),s.d(),l&&l.d()}}}function create_default_slot(e){let t,o;return t=new RadioGroup({props:{locale:e[1],class:"PinturaControlList",layout:"row",options:e[2],selectedIndex:e[4],onchange:e[10],$$slots:{option:[create_option_slot,({option:e})=>({31:e}),({option:e})=>[0,e?1:0]]},$$scope:{ctx:e}}}),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};2&o[0]&&(r.locale=e[1]),4&o[0]&&(r.options=e[2]),16&o[0]&&(r.selectedIndex=e[4]),2&o[0]|3&o[1]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function create_footer_slot(e){let t,o,r;return o=new Scrollable({props:{elasticity:e[5],$$slots:{default:[create_default_slot]},$$scope:{ctx:e}}}),{c(){t=element("div"),create_component(o.$$.fragment),attr(t,"slot","footer"),set_style(t,"transform",e[3])},m(e,n){insert(e,t,n),mount_component(o,t,null),r=!0},p(e,r){const n={};32&r[0]&&(n.elasticity=e[5]),22&r[0]|2&r[1]&&(n.$$scope={dirty:r,ctx:e}),o.$set(n),8&r[0]&&set_style(t,"transform",e[3])},i(e){r||(transition_in(o.$$.fragment,e),r=!0)},o(e){transition_out(o.$$.fragment,e),r=!1},d(e){e&&detach(t),destroy_component(o)}}}function create_fragment$2(e){let t,o;return t=new Util({props:{$$slots:{footer:[create_footer_slot]},$$scope:{ctx:e}}}),t.$on("measure",e[21]),{c(){create_component(t.$$.fragment)},m(e,r){mount_component(t,e,r),o=!0},p(e,o){const r={};62&o[0]|2&o[1]&&(r.$$scope={dirty:o,ctx:e}),t.$set(r)},i(e){o||(transition_in(t.$$.fragment,e),o=!0)},o(e){transition_out(t.$$.fragment,e),o=!1},d(e){destroy_component(t,e)}}}function tile(e){const t=document.createElement("div");return e.append(t),{update(o){const[r,n,i,a]=o.map(((e,t)=>t<3?Math.round(255*e):e));e.dataset.transparent=a<1,t.style.backgroundColor=`rgba(${r},${n},${i},${a})`}}}function instance$2(e,t,o){let r,n,i,a,s,l,c,u,p,d,h=noop,m=()=>(h(),h=subscribe(g,(e=>o(16,l=e))),g);e.$$.on_destroy.push((()=>h()));let{isActive:g}=t;m();let{stores:f}=t,{locale:$={}}=t,{fillOptions:b=[]}=t;const y=e=>e.map((e=>(e=>isArray(e)&&isString(e[0])&&isArray(e[1]))(e)?[e[0],y(e[1]),e[2]]:(e=>[Array.isArray(e)&&3===e.length?[...e,1]:e,void 0,{disabled:!1}])(e))),_=getContext("elasticityMultiplier");component_subscribe(e,_,(e=>o(20,d=e)));const{history:x,animation:v,scrollElasticity:S,imageBackgroundColor:C,imageBackgroundImage:w,allowPan:T,allowZoom:k,allowZoomControls:R,allowPlayPause:P}=f;component_subscribe(e,v,(e=>o(17,c=e))),component_subscribe(e,C,(e=>o(19,p=e))),component_subscribe(e,w,(e=>o(18,u=e)));const I=spring(c?20:0);return component_subscribe(e,I,(e=>o(15,s=e))),e.$$set=e=>{"isActive"in e&&m(o(0,g=e.isActive)),"stores"in e&&o(13,f=e.stores),"locale"in e&&o(1,$=e.locale),"fillOptions"in e&&o(14,b=e.fillOptions)},e.$$.update=()=>{16384&e.$$.dirty[0]&&o(2,r=y(b)),65536&e.$$.dirty[0]&&T.set(l),65536&e.$$.dirty[0]&&k.set(l),65536&e.$$.dirty[0]&&R.set(l),65536&e.$$.dirty[0]&&l&&P.set(!0),1048576&e.$$.dirty[0]&&o(5,n=d*S),786436&e.$$.dirty[0]&&o(4,i=r.findIndex((([e])=>u?e===u:Array.isArray(e)?arrayEqual(e,p):void 0))||0),196608&e.$$.dirty[0]&&c&&I.set(l?0:20),32768&e.$$.dirty[0]&&o(3,a=s?`translateY(${s}px)`:"none")},[g,$,r,a,i,n,_,v,C,w,({value:e})=>{isString(e)&&(set_store_value(C,p=void 0,p),set_store_value(w,u=e,u)),isArray(e)&&(set_store_value(C,p=e,p),set_store_value(w,u=void 0,u)),x.write()},I,"fill",f,b,s,l,c,u,p,d,function(t){bubble.call(this,e,t)}]}class Fill extends SvelteComponent{constructor(e){super(),init(this,e,instance$2,create_fragment$2,safe_not_equal,{name:12,isActive:0,stores:13,locale:1,fillOptions:14},null,[-1,-1])}get name(){return this.$$.ctx[12]}get isActive(){return this.$$.ctx[0]}set isActive(e){this.$$set({isActive:e}),flush()}get stores(){return this.$$.ctx[13]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[1]}set locale(e){this.$$set({locale:e}),flush()}get fillOptions(){return this.$$.ctx[14]}set fillOptions(e){this.$$set({fillOptions:e}),flush()}}var _plugin_fill={util:["fill",Fill,({src:e,fillOptions:t})=>e&&!isVideoFile(e)&&t&&t.length]};function create_fragment$1(e){let t,o,r;function n(t){e[42](t)}let i={utilKey:"retouch",stores:e[4],locale:e[5],isActive:e[1],isActiveFraction:e[2],isVisible:e[3],mapScreenPointToImagePoint:e[27],mapImagePointToScreenPoint:e[26],imageRotation:e[28],imageFlipX:e[25],imageFlipY:e[24],toolbar:e[6],toolbarLayout:"stack",shapes:e[30],toolShapes:e[7],enableMultiSelect:e[23],enableViewTool:e[14],enableMoveTool:e[13],enableToolShareStyles:!1,shapeControls:e[8],enablePresetSelectImage:!1,enablePresetDropImage:!1,parentRect:e[31],willStartInteraction:e[12],willRenderHeaderTools:e[10]||e[17],willRenderShapeStyleControls:e[9],hooks:{willRenderShapeControls:e[11]||e[15],willRenderShapeTextControls:e[16],beforeAddShape:e[18],beforeRemoveShape:e[19],beforeDeselectShape:e[20],beforeSelectShape:e[21],beforeUpdateShape:e[22]}};return void 0!==e[0]&&(i.toolActive=e[0]),t=new ShapeUtil({props:i}),binding_callbacks.push((()=>bind(t,"toolActive",n))),t.$on("measure",e[43]),{c(){create_component(t.$$.fragment)},m(e,o){mount_component(t,e,o),r=!0},p(e,r){const n={};16&r[0]&&(n.stores=e[4]),32&r[0]&&(n.locale=e[5]),2&r[0]&&(n.isActive=e[1]),4&r[0]&&(n.isActiveFraction=e[2]),8&r[0]&&(n.isVisible=e[3]),134217728&r[0]&&(n.mapScreenPointToImagePoint=e[27]),67108864&r[0]&&(n.mapImagePointToScreenPoint=e[26]),268435456&r[0]&&(n.imageRotation=e[28]),33554432&r[0]&&(n.imageFlipX=e[25]),16777216&r[0]&&(n.imageFlipY=e[24]),64&r[0]&&(n.toolbar=e[6]),128&r[0]&&(n.toolShapes=e[7]),8388608&r[0]&&(n.enableMultiSelect=e[23]),16384&r[0]&&(n.enableViewTool=e[14]),8192&r[0]&&(n.enableMoveTool=e[13]),256&r[0]&&(n.shapeControls=e[8]),4096&r[0]&&(n.willStartInteraction=e[12]),132096&r[0]&&(n.willRenderHeaderTools=e[10]||e[17]),512&r[0]&&(n.willRenderShapeStyleControls=e[9]),8226816&r[0]&&(n.hooks={willRenderShapeControls:e[11]||e[15],willRenderShapeTextControls:e[16],beforeAddShape:e[18],beforeRemoveShape:e[19],beforeDeselectShape:e[20],beforeSelectShape:e[21],beforeUpdateShape:e[22]}),!o&&1&r[0]&&(o=!0,n.toolActive=e[0],add_flush_callback((()=>o=!1))),t.$set(n)},i(e){r||(transition_in(t.$$.fragment,e),r=!0)},o(e){transition_out(t.$$.fragment,e),r=!1},d(e){destroy_component(t,e)}}}function instance$1(e,t,o){let r,n,i,a,s,l,c,u,p;let{isActive:d}=t,{isActiveFraction:h}=t,{isVisible:m}=t,{stores:g}=t,{locale:f={}}=t,{retouchTools:$}=t,{retouchToolShapes:b}=t,{retouchShapeControls:y}=t,{retouchActiveTool:_}=t,{retouchWillRenderShapeStyleControls:x}=t,{retouchWillRenderHeaderTools:v}=t,{retouchWillRenderShapeControls:S}=t,{markupEditorWillStartInteraction:C}=t,{retouchEnableMoveTool:w}=t,{retouchEnableViewTool:T}=t,{willRenderShapeControls:k}=t,{willRenderShapeTextControls:R}=t,{willRenderHeaderTools:P}=t,{beforeAddShape:I}=t,{beforeRemoveShape:E}=t,{beforeDeselectShape:M}=t,{beforeSelectShape:A}=t,{beforeUpdateShape:F}=t,{enableMultiSelect:L}=t;const{rootRect:D,imageManipulation:z,imageSize:O,imageRotation:B,imageFlipX:N,imageFlipY:V,imageTransforms:W,imageTransformsInterpolated:U}=g;return component_subscribe(e,D,(e=>o(41,u=e))),component_subscribe(e,O,(e=>o(40,c=e))),component_subscribe(e,B,(e=>o(28,p=e))),component_subscribe(e,N,(e=>o(25,a=e))),component_subscribe(e,V,(e=>o(24,i=e))),component_subscribe(e,W,(e=>o(39,l=e))),component_subscribe(e,U,(e=>o(38,s=e))),e.$$set=e=>{"isActive"in e&&o(1,d=e.isActive),"isActiveFraction"in e&&o(2,h=e.isActiveFraction),"isVisible"in e&&o(3,m=e.isVisible),"stores"in e&&o(4,g=e.stores),"locale"in e&&o(5,f=e.locale),"retouchTools"in e&&o(6,$=e.retouchTools),"retouchToolShapes"in e&&o(7,b=e.retouchToolShapes),"retouchShapeControls"in e&&o(8,y=e.retouchShapeControls),"retouchActiveTool"in e&&o(0,_=e.retouchActiveTool),"retouchWillRenderShapeStyleControls"in e&&o(9,x=e.retouchWillRenderShapeStyleControls),"retouchWillRenderHeaderTools"in e&&o(10,v=e.retouchWillRenderHeaderTools),"retouchWillRenderShapeControls"in e&&o(11,S=e.retouchWillRenderShapeControls),"markupEditorWillStartInteraction"in e&&o(12,C=e.markupEditorWillStartInteraction),"retouchEnableMoveTool"in e&&o(13,w=e.retouchEnableMoveTool),"retouchEnableViewTool"in e&&o(14,T=e.retouchEnableViewTool),"willRenderShapeControls"in e&&o(15,k=e.willRenderShapeControls),"willRenderShapeTextControls"in e&&o(16,R=e.willRenderShapeTextControls),"willRenderHeaderTools"in e&&o(17,P=e.willRenderHeaderTools),"beforeAddShape"in e&&o(18,I=e.beforeAddShape),"beforeRemoveShape"in e&&o(19,E=e.beforeRemoveShape),"beforeDeselectShape"in e&&o(20,M=e.beforeDeselectShape),"beforeSelectShape"in e&&o(21,A=e.beforeSelectShape),"beforeUpdateShape"in e&&o(22,F=e.beforeUpdateShape),"enableMultiSelect"in e&&o(23,L=e.enableMultiSelect)},e.$$.update=()=>{50331648&e.$$.dirty[0]|1920&e.$$.dirty[1]&&o(27,r=e=>_mapScreenPointToImagePoint(e,u,c,s.origin,s.translation,l.rotation.z,s.scale,a,i)),50331648&e.$$.dirty[0]|1920&e.$$.dirty[1]&&o(26,n=e=>_mapImagePointToScreenPoint(e,u,c,s.origin,s.translation,l.rotation.z,s.scale,a,i))},[_,d,h,m,g,f,$,b,y,x,v,S,C,w,T,k,R,P,I,E,M,A,F,L,i,a,n,r,p,D,z,O,B,N,V,W,U,"retouch",s,l,c,u,function(e){_=e,o(0,_)},function(t){bubble.call(this,e,t)}]}class Retouch extends SvelteComponent{constructor(e){super(),init(this,e,instance$1,create_fragment$1,safe_not_equal,{name:37,isActive:1,isActiveFraction:2,isVisible:3,stores:4,locale:5,retouchTools:6,retouchToolShapes:7,retouchShapeControls:8,retouchActiveTool:0,retouchWillRenderShapeStyleControls:9,retouchWillRenderHeaderTools:10,retouchWillRenderShapeControls:11,markupEditorWillStartInteraction:12,retouchEnableMoveTool:13,retouchEnableViewTool:14,willRenderShapeControls:15,willRenderShapeTextControls:16,willRenderHeaderTools:17,beforeAddShape:18,beforeRemoveShape:19,beforeDeselectShape:20,beforeSelectShape:21,beforeUpdateShape:22,enableMultiSelect:23},null,[-1,-1])}get name(){return this.$$.ctx[37]}get isActive(){return this.$$.ctx[1]}set isActive(e){this.$$set({isActive:e}),flush()}get isActiveFraction(){return this.$$.ctx[2]}set isActiveFraction(e){this.$$set({isActiveFraction:e}),flush()}get isVisible(){return this.$$.ctx[3]}set isVisible(e){this.$$set({isVisible:e}),flush()}get stores(){return this.$$.ctx[4]}set stores(e){this.$$set({stores:e}),flush()}get locale(){return this.$$.ctx[5]}set locale(e){this.$$set({locale:e}),flush()}get retouchTools(){return this.$$.ctx[6]}set retouchTools(e){this.$$set({retouchTools:e}),flush()}get retouchToolShapes(){return this.$$.ctx[7]}set retouchToolShapes(e){this.$$set({retouchToolShapes:e}),flush()}get retouchShapeControls(){return this.$$.ctx[8]}set retouchShapeControls(e){this.$$set({retouchShapeControls:e}),flush()}get retouchActiveTool(){return this.$$.ctx[0]}set retouchActiveTool(e){this.$$set({retouchActiveTool:e}),flush()}get retouchWillRenderShapeStyleControls(){return this.$$.ctx[9]}set retouchWillRenderShapeStyleControls(e){this.$$set({retouchWillRenderShapeStyleControls:e}),flush()}get retouchWillRenderHeaderTools(){return this.$$.ctx[10]}set retouchWillRenderHeaderTools(e){this.$$set({retouchWillRenderHeaderTools:e}),flush()}get retouchWillRenderShapeControls(){return this.$$.ctx[11]}set retouchWillRenderShapeControls(e){this.$$set({retouchWillRenderShapeControls:e}),flush()}get markupEditorWillStartInteraction(){return this.$$.ctx[12]}set markupEditorWillStartInteraction(e){this.$$set({markupEditorWillStartInteraction:e}),flush()}get retouchEnableMoveTool(){return this.$$.ctx[13]}set retouchEnableMoveTool(e){this.$$set({retouchEnableMoveTool:e}),flush()}get retouchEnableViewTool(){return this.$$.ctx[14]}set retouchEnableViewTool(e){this.$$set({retouchEnableViewTool:e}),flush()}get willRenderShapeControls(){return this.$$.ctx[15]}set willRenderShapeControls(e){this.$$set({willRenderShapeControls:e}),flush()}get willRenderShapeTextControls(){return this.$$.ctx[16]}set willRenderShapeTextControls(e){this.$$set({willRenderShapeTextControls:e}),flush()}get willRenderHeaderTools(){return this.$$.ctx[17]}set willRenderHeaderTools(e){this.$$set({willRenderHeaderTools:e}),flush()}get beforeAddShape(){return this.$$.ctx[18]}set beforeAddShape(e){this.$$set({beforeAddShape:e}),flush()}get beforeRemoveShape(){return this.$$.ctx[19]}set beforeRemoveShape(e){this.$$set({beforeRemoveShape:e}),flush()}get beforeDeselectShape(){return this.$$.ctx[20]}set beforeDeselectShape(e){this.$$set({beforeDeselectShape:e}),flush()}get beforeSelectShape(){return this.$$.ctx[21]}set beforeSelectShape(e){this.$$set({beforeSelectShape:e}),flush()}get beforeUpdateShape(){return this.$$.ctx[22]}set beforeUpdateShape(e){this.$$set({beforeUpdateShape:e}),flush()}get enableMultiSelect(){return this.$$.ctx[23]}set enableMultiSelect(e){this.$$set({enableMultiSelect:e}),flush()}}var _plugin_retouch={util:["retouch",Retouch,({src:e})=>e&&!isVideoFile(e)]};const IconCross='<g fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em"><path d="M18 6L6 18M6 6l12 12"></path></path></g>',CharacterA='<path fill="none" d="M9 15 L12 9 L15 15 M10 13.5 h3" stroke="currentColor" stroke-width=".125em"/>';var _locale_en_gb={labelReset:"Reset",labelDefault:"Default",labelAuto:"Auto",labelNone:"None",labelEdit:"Edit",labelClose:"Close",labelSupportError:"{features} not supported on this browser",labelColor:"Color",labelWidth:"Width",labelSize:"Size",labelOffset:"Offset",labelAmount:"Amount",labelInset:"Inset",labelRadius:"Radius",labelColorPalette:"Color palette",labelSizeExtraSmall:"Extra small",labelSizeSmall:"Small",labelSizeMediumSmall:"Medium small",labelSizeMedium:"Medium",labelSizeMediumLarge:"Medium large",labelSizeLarge:"Large",labelSizeExtraLarge:"Extra large",labelButtonCancel:"Cancel",labelButtonUndo:"Undo",labelButtonRedo:"Redo",labelButtonRevert:"Revert",labelButtonExport:"Done",labelZoom:"Zoom",labelZoomIn:"Zoom in",labelZoomOut:"Zoom out",labelZoomFit:"Fit to view",labelZoomActual:"Actual size",iconZoomIn:'<path stroke="currentColor" stroke-width=".125em" d="M8 12 h8 M12 8 v8" />',iconZoomOut:'<path stroke="currentColor" stroke-width=".125em" d="M9 12 h6" />',iconSupportError:'<g fill="none" stroke="currentColor" stroke-width="2"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/><g><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/></g>',iconButtonClose:IconCross,iconButtonRevert:'<g fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em"><path d="M7.388 18.538a8 8 0 10-2.992-9.03"/><path fill="currentColor" d="M2.794 11.696L2.37 6.714l5.088 3.18z"/><path d="M12 8v4M12 12l4 2"/></g>',iconButtonUndo:'<g fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em"><path d="M10 8h4c2.485 0 5 2 5 5s-2.515 5-5 5h-4"/><path fill="currentColor" d="M5 8l4-3v6z"/></g>',iconButtonRedo:'<g fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em"><path d="M14 8h-4c-2.485 0-5 2-5 5s2.515 5 5 5h4"/><path fill="currentColor" d="M19 8l-4-3v6z"/></g>',iconButtonExport:'<polyline points="20 6 9 17 4 12" fill="none" stroke="currentColor" stroke-width=".125em"></polyline>',statusLabelButtonClose:"Close",statusIconButtonClose:IconCross,statusImageLoadNone:"Waiting for image",statusImageLoadMinSize:"Minimum image size is {minWidth} &times; {minHeight}",statusImageLoadPrepare:"Preparing image&hellip;",statusImageLoadBusy:"Loading image&hellip;",statusImageLoadError:"Error loading image",statusImageProcessBusy:"Processing image&hellip;",statusImageProcessError:"Error processing image",statusImageUploadBusy:"Uploading image&hellip;",statusImageUploadError:"Error uploading image"};const MarkupEditor={shapeLabelButtonSelectSticker:"Select image",shapeIconButtonSelectSticker:'<g fill="none" stroke="currentColor" stroke-width="0.0625em"><path d="M8 21 L15 11 L19 15"/><path d="M15 2 v5 h5"/><path d="M8 2 h8 l4 4 v12 q0 4 -4 4 h-8 q-4 0 -4 -4 v-12 q0 -4 4 -4z"/></g><circle fill="currentColor" cx="10" cy="8" r="1.5"/>',shapeIconButtonFlipHorizontal:'<g stroke="currentColor" stroke-width=".125em"><path fill="none" d="M6 6.5h5v11H6z"/><path fill="currentColor" d="M15 6.5h3v11h-3z"/><path d="M11 4v16" fill="currentColor"/></g>',shapeIconButtonFlipVertical:'<g stroke="currentColor" stroke-width=".125em"><rect x="7" y="8" width="11" height="5" fill="none"/><rect x="7" y="17" width="11" height="2" fill="currentColor"/><line x1="5" y1="13" x2="20" y2="13"/></g>',shapeIconButtonRemove:'<g fill="none" fill-rule="evenodd"><path stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" d="M7.5 7h9z"/><path d="M7.916 9h8.168a1 1 0 01.99 1.14l-.972 6.862a2 2 0 01-1.473 1.653c-.877.23-1.753.345-2.629.345-.876 0-1.752-.115-2.628-.345a2 2 0 01-1.473-1.653l-.973-6.862A1 1 0 017.916 9z" fill="currentColor"/><rect fill="currentColor" x="10" y="5" width="4" height="3" rx="1"/></g>',shapeIconButtonDuplicate:'<g fill="none" fill-rule="evenodd"><path d="M15 13.994V16a2 2 0 01-2 2H8a2 2 0 01-2-2v-5a2 2 0 012-2h2.142" stroke="currentColor" stroke-width=".125em"/><path d="M15 9V8a1 1 0 00-2 0v1h-1a1 1 0 000 2h1v1a1 1 0 002 0v-1h1a1 1 0 000-2h-1zm-4-4h6a2 2 0 012 2v6a2 2 0 01-2 2h-6a2 2 0 01-2-2V7a2 2 0 012-2z" fill="currentColor"/></g>',shapeIconButtonMoveToFront:'<g fill="none" fill-rule="evenodd"><rect fill="currentColor" x="11" y="13" width="8" height="2" rx="1"/><rect fill="currentColor" x="9" y="17" width="10" height="2" rx="1"/><path d="M11.364 8H10a5 5 0 000 10M12 6.5L14.5 8 12 9.5z" stroke="currentColor" stroke-width=".125em" stroke-linecap="round"/></g>',shapeIconButtonTextLayoutAutoWidth:`${CharacterA}`,shapeIconButtonTextLayoutAutoHeight:`<g fill="currentColor"><circle cx="4" cy="12" r="1.5"/><circle cx="20" cy="12" r="1.5"/></g>${CharacterA}`,shapeIconButtonTextLayoutFixedSize:`<g fill="currentColor"><circle cx="5" cy="6" r="1.5"/><circle cx="19" cy="6" r="1.5"/><circle cx="19" cy="19" r="1.5"/><circle cx="5" cy="19" r="1.5"/></g>${CharacterA}`,shapeTitleButtonTextLayoutAutoWidth:"Auto width",shapeTitleButtonTextLayoutAutoHeight:"Auto height",shapeTitleButtonTextLayoutFixedSize:"Fixed size",shapeTitleButtonFlipHorizontal:"Flip Horizontal",shapeTitleButtonFlipVertical:"Flip Vertical",shapeTitleButtonRemove:"Remove",shapeTitleButtonDuplicate:"Duplicate",shapeTitleButtonMoveToFront:"Move to front",shapeLabelInputText:"Edit text",shapeIconInputCancel:'<g fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em"><path d="M18 6L6 18M6 6l12 12"/></g>',shapeIconInputConfirm:'<g fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em"><polyline points="20 6 9 17 4 12"/></g>',shapeLabelInputCancel:"Cancel",shapeLabelInputConfirm:"Confirm",shapeLabelStrokeNone:"No outline",shapeLabelFontStyleNormal:"Normal",shapeLabelFontStyleBold:"Bold",shapeLabelFontStyleItalic:"Italic",shapeLabelFontStyleItalicBold:"Bold Italic",shapeTitleBackgroundColor:"Fill color",shapeTitleCornerRadius:"Corner radius",shapeTitleFontFamily:"Font",shapeTitleFontSize:"Font size",shapeTitleFontStyle:"Font style",shapeTitleLineHeight:"Line height",shapeTitleLineStart:"Start",shapeTitleLineEnd:"End",shapeTitleStrokeWidth:"Line width",shapeTitleStrokeColor:"Line color",shapeTitleLineDecorationBar:"Bar",shapeTitleLineDecorationCircle:"Circle",shapeTitleLineDecorationSquare:"Square",shapeTitleLineDecorationArrow:"Arrow",shapeTitleLineDecorationCircleSolid:"Circle solid",shapeTitleLineDecorationSquareSolid:"Square solid",shapeTitleLineDecorationArrowSolid:"Arrow solid",shapeIconLineDecorationBar:'<g stroke="currentColor" stroke-linecap="round" stroke-width=".125em"><path d="M5,12 H16"/><path d="M16,8 V16"/></g>',shapeIconLineDecorationCircle:'<g stroke="currentColor" stroke-linecap="round"><path stroke-width=".125em" d="M5,12 H12"/><circle fill="none" stroke-width=".125em" cx="16" cy="12" r="4"/></g>',shapeIconLineDecorationSquare:'<g stroke="currentColor" stroke-linecap="round"><path stroke-width=".125em" d="M5,12 H12"/><rect fill="none" stroke-width=".125em" x="12" y="8" width="8" height="8"/></g>',shapeIconLineDecorationArrow:'<g stroke="currentColor" stroke-linecap="round" stroke-width=".125em"><path d="M5,12 H16 M13,7 l6,5 l-6,5" fill="none"/></g>',shapeIconLineDecorationCircleSolid:'<g stroke="currentColor" stroke-linecap="round"><path stroke-width=".125em" d="M5,12 H12"/><circle fill="currentColor" cx="16" cy="12" r="4"/></g>',shapeIconLineDecorationSquareSolid:'<g stroke="currentColor" stroke-linecap="round"><path stroke-width=".125em" d="M5,12 H12"/><rect fill="currentColor" x="12" y="8" width="8" height="8"/></g>',shapeIconLineDecorationArrowSolid:'<g stroke="currentColor" stroke-linecap="round" stroke-width=".125em"><path d="M5,12 H16"/><path d="M13,7 l6,5 l-6,5z" fill="currentColor"/></g>',shapeTitleColorTransparent:"Transparent",shapeTitleColorWhite:"White",shapeTitleColorSilver:"Silver",shapeTitleColorGray:"Gray",shapeTitleColorBlack:"Black",shapeTitleColorNavy:"Navy",shapeTitleColorBlue:"Blue",shapeTitleColorAqua:"Aqua",shapeTitleColorTeal:"Teal",shapeTitleColorOlive:"Olive",shapeTitleColorGreen:"Green",shapeTitleColorYellow:"Yellow",shapeTitleColorOrange:"Orange",shapeTitleColorRed:"Red",shapeTitleColorMaroon:"Maroon",shapeTitleColorFuchsia:"Fuchsia",shapeTitleColorPurple:"Purple",shapeTitleTextOutline:"Text outline",shapeTitleTextOutlineWidth:"Width",shapeTitleTextShadow:"Text shadow",shapeTitleTextShadowBlur:"Blur",shapeTitleTextColor:"Font color",shapeTitleTextAlign:"Text align",shapeTitleTextAlignLeft:"Left align text",shapeTitleTextAlignCenter:"Center align text",shapeTitleTextAlignRight:"Right align text",shapeIconTextAlignLeft:'<g stroke-width=".125em" stroke="currentColor"><line x1="5" y1="8" x2="15" y2="8"/><line x1="5" y1="12" x2="19" y2="12"/><line x1="5" y1="16" x2="14" y2="16"/></g>',shapeIconTextAlignCenter:'<g stroke-width=".125em" stroke="currentColor"><line x1="7" y1="8" x2="17" y2="8"/><line x1="5" y1="12" x2="19" y2="12"/><line x1="8" y1="16" x2="16" y2="16"/></g>',shapeIconTextAlignRight:'<g stroke-width=".125em" stroke="currentColor"><line x1="9" y1="8" x2="19" y2="8"/><line x1="5" y1="12" x2="19" y2="12"/><line x1="11" y1="16" x2="19" y2="16"/></g>',shapeLabelToolMove:"Move",shapeLabelToolView:"View",shapeLabelToolSharpie:"Sharpie",shapeLabelToolEraser:"Eraser",shapeLabelToolPath:"Path",shapeLabelToolRectangle:"Rectangle",shapeLabelToolEllipse:"Ellipse",shapeLabelToolArrow:"Arrow",shapeLabelToolLine:"Line",shapeLabelToolText:"Text",shapeLabelToolPreset:"Stickers",shapeIconToolView:'<g stroke-width=".125em" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path d="M10.98 9.703V2.567c0-1.19 1.19-1.785 1.784-1.785.595 0 1.784.595 1.784 1.785v3.568"/><path d="M14.548 9.703V4.35c0-1.19 1.19-1.784 1.784-1.784.595 0 1.784.594 1.784 1.784v2.973"/><path d="M18.116 10.244V7.271c0-1.19 1.19-1.784 1.784-1.784.595 0 1.785.595 1.785 1.784 0 1.19 0 8.92-1.19 12.488-1.19 3.569-10.704 4.758-13.678 0-2.973-4.757-2.973-4.757-4.163-6.541-1.189-1.784-1.153-2.974-.594-3.568.558-.595 1.784-1.19 2.973.594 1.277 1.916 2.07 2.907 2.379 2.974V5.487c0-1.19 1.19-1.784 1.784-1.784.595 0 1.784.595 1.784 1.784V8.46"/></g>',shapeIconToolMove:'<g stroke-width=".125em" stroke="currentColor" fill="none"><path d="M6 2 L6 19 L18 13 Z M13 18 L16 24" stroke="currentColor" stroke-width=".125em" fill="none" fill-rule="evenodd" stroke-linejoin="round"/></g>',shapeIconToolSharpie:'<g stroke-width=".125em" stroke="currentColor" fill="none"><path d="M2.025 5c5.616-2.732 8.833-3.857 9.65-3.374C12.903 2.351.518 12.666 2.026 14 3.534 15.334 16.536.566 17.73 2.566 18.924 4.566 3.98 17.187 4.831 18c.851.813 9.848-6 11.643-6 1.087 0-2.53 5.11-2.92 7-.086.41 3.323-1.498 4.773-1 .494.17.64 2.317 1.319 3 .439.443 1.332.776 2.679 1" stroke="currentColor" stroke-width=".125em" fill="none" fill-rule="evenodd" stroke-linejoin="round"/></g>',shapeIconToolEraser:'<g stroke-width=".125em" stroke="currentColor" stroke-linecap="round" fill="none"><g transform="translate(3, 15) rotate(-45)"><rect x="0" y="0" width="18" height="10" rx="3"/></g><line x1="11" y1="21" x2="18" y2="21"/><line x1="20" y1="21" x2="22" y2="21"/></g>',shapeIconToolPath:'<g stroke-width=".125em" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" fill="none"><circle cx="21" cy="3" r="2"/><circle cx="9" cy="9" r="2"/><circle cx="3" cy="21" r="2"/><path d="M19 4 11 8 M8 11 4 19"/></g>',shapeIconToolRectangle:'<g stroke-width=".125em" stroke="currentColor" fill="none"><rect x="1" y="1" width="22" height="22" rx="4"/></g>',shapeIconToolEllipse:'<g stroke-width=".125em" stroke="currentColor" fill="none"><circle cx="12" cy="12" r="11"/></g>',shapeIconToolArrow:'<g stroke-width=".125em" stroke="currentColor" fill="none"><line x1="20" y1="3" x2="6" y2="21"/><path d="m10 6 L21.5 1 L20 13.5" fill="currentColor" stroke="none"/></g>',shapeIconToolLine:'<g stroke-width=".125em" stroke="currentColor" fill="none"><line x1="20" y1="3" x2="6" y2="21"/></g>',shapeIconToolText:'<g stroke="none" fill="currentColor" transform="translate(6,0)"><path d="M8.14 20.085c.459 0 .901-.034 1.329-.102a8.597 8.597 0 001.015-.21v1.984c-.281.135-.695.247-1.242.336a9.328 9.328 0 01-1.477.133c-3.312 0-4.968-1.745-4.968-5.235V6.804H.344v-1.25l2.453-1.078L3.89.819h1.5v3.97h4.97v2.015H5.39v10.078c0 1.031.245 1.823.735 2.375s1.161.828 2.015.828z"/>',shapeIconToolPreset:'<g fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em"><path d="M12 22c2.773 0 1.189-5.177 3-7 1.796-1.808 7-.25 7-3 0-5.523-4.477-10-10-10S2 6.477 2 12s4.477 10 10 10z"></path><path d="M20 17c-3 3-5 5-8 5"></path></g>',shapeTitleSelectionMode:"Selection mode",shapeTitleBrushSize:"Brush size",shapeLabelSelectionModeNew:"New",shapeLabelSelectionModeAdd:"Add",shapeLabelSelectionModeSubtract:"Remove",shapeLabelToolSelectionBrush:"Brush",shapeLabelToolSelectionLassoo:"Lassoo",shapeLabelToolSelectionRectangle:"Rectangle marquee",shapeLabelToolSelectionEllipse:"Ellipse marquee",shapeIconSelectionModeNew:'<g fill="none" fill-rule="evenodd" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"><path d="M6.5 17H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v1.5"/><rect width="12" height="12" x="9" y="9" fill="currentColor" fill-opacity=".25" rx="2"/></g>',shapeIconSelectionModeAdd:'<g fill="none" fill-rule="evenodd" stroke="currentColor"><path fill="currentColor" fill-opacity=".25" stroke-linecap="round" stroke-linejoin="round" d="M15 3a2 2 0 0 1 2 2v4h2a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-8a2 2 0 0 1-2-2v-2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h10Z"/><path d="M13 15h4M15 13v4"/></g>',shapeIconSelectionModeSubtract:'<g fill="none" fill-rule="evenodd" stroke="currentColor"><path fill="currentColor" fill-opacity=".25" stroke-linecap="round" stroke-linejoin="round" d="M15 3a2 2 0 0 1 2 2v4h-6a2 2 0 0 0-1.995 1.85L9 11v6H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h10Z"/><rect width="12" height="12" x="9" y="9" stroke-linecap="round" stroke-linejoin="round" rx="2"/><path d="M13 15h4"/></g>',shapeIconToolSelectionBrush:'<g stroke-width=".125em" stroke="currentColor" fill="none"><path d="M2.025 5c5.616-2.732 8.833-3.857 9.65-3.374C12.903 2.351.518 12.666 2.026 14 3.534 15.334 16.536.566 17.73 2.566 18.924 4.566 3.98 17.187 4.831 18c.851.813 9.848-6 11.643-6 1.087 0-2.53 5.11-2.92 7-.086.41 3.323-1.498 4.773-1 .494.17.64 2.317 1.319 3 .439.443 1.332.776 2.679 1" stroke="currentColor" fill-rule="evenodd" stroke-linejoin="round"/></g>',shapeIconToolSelectionLassoo:'<g fill="none" fill-rule="evenodd" stroke-width=".125em" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M11.428 17.702a18.46 18.46 0 0 0 4.085-1.595c5.851-3.112 9.019-8.599 7.074-12.256-1.945-3.657-8.265-4.1-14.116-.988C2.619 5.974-.55 11.46 1.396 15.118c.63 1.186 1.72 2.033 3.105 2.532"/><ellipse cx="8" cy="18.5" rx="3.5" ry="2.833" transform="rotate(-15 8 18.5)"/><path stroke-linecap="round" d="M5 18c3.347 1.048 5.514 1.881 6.5 2.5.859.54 1.517.994 1.5 2.364"/></g>',shapeIconToolSelectionRectangle:'<g stroke-width=".125em" stroke="currentColor"><path d="M9 1 h6 m4 0 h4v4 m0 4 v6 m0 4 v4h-4 m-4 0 h-6 m-4 0 h-4v-4 m0 -4 v-6 m0 -4 v-4h4" fill="none" /></g>',shapeIconToolSelectionEllipse:'<path stroke-width=".125em" stroke="currentColor" d="M1.21 9.853a11.054 11.054 0 0 0 0 4.294m1.643 3.965a11.054 11.054 0 0 0 3.035 3.035m3.965 1.644a11.054 11.054 0 0 0 4.294 0m3.965-1.644a11.054 11.054 0 0 0 3.035-3.035m1.644-3.965a11.054 11.054 0 0 0 0-4.294m-1.644-3.965a11.054 11.054 0 0 0-3.035-3.035m-3.965-1.644a11.054 11.054 0 0 0-4.294 0M5.888 2.853a11.054 11.054 0 0 0-3.035 3.035"/>'};var _plugin_crop_locale_en_gb={cropLabel:"Crop",cropIcon:'<g stroke-width=".125em" stroke="currentColor" fill="none"><path d="M23 17H9a2 2 0 0 1-2-2v-5m0-3V1 M1 7h14a2 2 0 0 1 2 2v7m0 4v3"/></g>',cropIconButtonRecenter:'<path stroke="currentColor" fill="none" stroke-width="2" stroke-linejoin="bevel" d="M1.5 7.5v-6h6M1.5 16.5v6h6M22.5 16.5v6h-6M22.5 7.5v-6h-6"/><circle cx="12" cy="12" r="3.5" fill="currentColor" stroke="none"/>',cropIconButtonRotateLeft:'<g stroke="none" fill="currentColor"><path fill="none" d="M-1-1h582v402H-1z"/><rect x="3" rx="1" height="12" width="12" y="9"/><path d="M15 5h-1a5 5 0 015 5 1 1 0 002 0 7 7 0 00-7-7h-1.374l.747-.747A1 1 0 0011.958.84L9.603 3.194a1 1 0 000 1.415l2.355 2.355a1 1 0 001.415-1.414l-.55-.55H15z"/></g>',cropIconButtonRotateRight:'<g stroke="none" fill="currentColor"><path fill="none" d="M-1-1h582v402H-1z"/><path d="M11.177 5H10a5 5 0 00-5 5 1 1 0 01-2 0 7 7 0 017-7h1.374l-.747-.747A1 1 0 0112.042.84l2.355 2.355a1 1 0 010 1.415l-2.355 2.354a1 1 0 01-1.415-1.414l.55-.55z"/><rect rx="1" height="12" width="12" y="9" x="9"/></g>',cropIconButtonFlipVertical:'<g stroke="none" fill="currentColor"><path d="M19.993 12.143H7a1 1 0 0 1-1-1V5.994a1 1 0 0 1 1.368-.93l12.993 5.15a1 1 0 0 1-.368 1.93z"/><path d="M19.993 14a1 1 0 0 1 .368 1.93L7.368 21.078A1 1 0 0 1 6 20.148V15a1 1 0 0 1 1-1h12.993z" opacity=".6"/></g>',cropIconButtonFlipHorizontal:'<g stroke="none" fill="currentColor"><path d="M11.93 7.007V20a1 1 0 0 1-1 1H5.78a1 1 0 0 1-.93-1.368l5.15-12.993a1 1 0 0 1 1.929.368z"/><path d="M14 7.007V20a1 1 0 0 0 1 1h5.149a1 1 0 0 0 .93-1.368l-5.15-12.993A1 1 0 0 0 14 7.007z" opacity=".6"/></g>',cropIconSelectPreset:'<g fill="currentColor">\n        <rect opacity="{a}" x="2" y="4" width="10" height="18" rx="1"/>\n        <rect opacity="{b}" x="4" y="8" width="14" height="14" rx="1"/>\n        <rect opacity="{c}" x="6" y="12" width="17" height="10" rx="1"/>\n    </g>',cropIconCropBoundary:'<g fill="currentColor">\n        <rect opacity="{a}" x="2" y="3" width="20" height="20" rx="1"/>\n        <rect opacity="{b}" x="7" y="8" width="10" height="10" rx="1"/>\n        <rect opacity="{c}" x="4" y="8" width="14" height="14" rx="1"/>\n        <rect opacity="{d}" x="12" y="4" width="10" height="10" rx="1"/>\n    </g>',cropLabelButtonRecenter:"Recenter",cropLabelButtonRotateLeft:"Rotate left",cropLabelButtonRotateRight:"Rotate right",cropLabelButtonFlipHorizontal:"Flip horizontal",cropLabelButtonFlipVertical:"Flip vertical",cropLabelSelectPreset:"Crop shape",cropLabelCropBoundary:"Crop boundary",cropLabelCropBoundaryEdge:"Edge of image",cropLabelCropBoundaryNone:"None",cropLabelTabRotation:"Rotation",cropLabelTabZoom:"Scale"},_plugin_fill_locale_en_gb={fillLabel:"Fill",fillIcon:'\n    <g fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em">\n        <g transform="rotate(60, 12, 12)">\n            <rect x="4" y="4" width="14" height="16" rx="3"/>\n        </g>\n        <path d="M21 13 L21 21"></path>\n        <path d="M4.5 12.5 L19 12.5"></path>\n    </g>\n    '},_plugin_filter_locale_en_gb={filterLabel:"Filter",filterIcon:'<g stroke-width=".125em" stroke="currentColor" fill="none"><path d="M18.347 9.907a6.5 6.5 0 1 0-1.872 3.306M3.26 11.574a6.5 6.5 0 1 0 2.815-1.417 M10.15 17.897A6.503 6.503 0 0 0 16.5 23a6.5 6.5 0 1 0-6.183-8.51"/></g>',filterLabelChrome:"Chrome",filterLabelFade:"Fade",filterLabelCold:"Cold",filterLabelWarm:"Warm",filterLabelPastel:"Pastel",filterLabelMonoDefault:"Mono",filterLabelMonoNoir:"Noir",filterLabelMonoWash:"Wash",filterLabelMonoStark:"Stark",filterLabelSepiaDefault:"Sepia",filterLabelSepiaBlues:"Blues",filterLabelSepiaRust:"Rust",filterLabelSepiaColor:"Color"},_plugin_finetune_locale_en_gb={finetuneLabel:"Finetune",finetuneIcon:'<g stroke-width=".125em" stroke="currentColor" fill="none"><path d="M4 1v5.5m0 3.503V23M12 1v10.5m0 3.5v8M20 1v15.5m0 3.5v3M2 7h4M10 12h4M18 17h4"/></g>',finetuneLabelBrightness:"Brightness",finetuneLabelContrast:"Contrast",finetuneLabelSaturation:"Saturation",finetuneLabelExposure:"Exposure",finetuneLabelTemperature:"Temperature",finetuneLabelGamma:"Gamma",finetuneLabelClarity:"Clarity",finetuneLabelVignette:"Vignette"},_plugin_resize_locale_en_gb={resizeLabel:"Resize",resizeIcon:'<g stroke-width=".125em" stroke="currentColor" fill="none"><rect x="2" y="12" width="10" height="10" rx="2"/><path d="M4 11.5V4a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2h-5.5"/><path d="M14 10l3.365-3.365M14 6h4v4"/></g>',resizeLabelFormCaption:"Image output size",resizeLabelInputWidth:"w",resizeTitleInputWidth:"Width",resizeLabelInputHeight:"h",resizeTitleInputHeight:"Height",resizeTitleButtonMaintainAspectRatio:"Maintain aspectratio",resizeIconButtonMaintainAspectRatio:'<defs><mask id="mask1" x="-2" y="-2" width="24" height="24"><rect x="0" y="0" width="24" height="10" fill="#fff" stroke="none"/></mask></defs><g fill="none" fill-rule="evenodd"><g mask="url(#mask1)"><path transform="translate(0 {activeFraction})" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" d="M9.401 10.205v-.804a2.599 2.599 0 0 1 5.198 0V17"/></g><rect fill="currentColor" x="7" y="10" width="10" height="7" rx="1.5"/></g>'},_plugin_decorate_locale_en_gb={decorateLabel:"Decorate",decorateIcon:'<g fill="none" fill-rule="evenodd"><path stroke="currentColor" stroke-width=".125em" stroke-linecap="round" stroke-linejoin="round" d="M12 18.5l-6.466 3.4 1.235-7.2-5.23-5.1 7.228-1.05L12 2l3.233 6.55 7.229 1.05-5.231 5.1 1.235 7.2z"/></g>'},_plugin_annotate_locale_en_gb={annotateLabel:"Annotate",annotateIcon:'<g stroke-width=".125em" stroke="currentColor" fill="none"><path d="M17.086 2.914a2.828 2.828 0 1 1 4 4l-14.5 14.5-5.5 1.5 1.5-5.5 14.5-14.5z"/></g>'},_plugin_sticker_locale_en_gb={stickerLabel:"Sticker",stickerIcon:'<g fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em"><path d="M12 22c2.773 0 1.189-5.177 3-7 1.796-1.808 7-.25 7-3 0-5.523-4.477-10-10-10S2 6.477 2 12s4.477 10 10 10z"/><path d="M20 17c-3 3-5 5-8 5"/></g>'},_plugin_frame_locale_en_gb={frameLabel:"Frame",frameIcon:'<g fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em">\n            <rect x="2" y="2" width="20" height="20" rx="4"/>\n            <rect x="6" y="6" width="12" height="12" rx="1"/>\n        </g>',frameLabelMatSharp:"Mat",frameLabelMatRound:"Bevel",frameLabelLineSingle:"Line",frameLabelLineMultiple:"Zebra",frameLabelEdgeSeparate:"Inset",frameLabelEdgeOverlap:"Plus",frameLabelEdgeCross:"Lumber",frameLabelCornerHooks:"Hook",frameLabelPolaroid:"Polaroid"},_plugin_redact_locale_en_gb={redactLabel:"Redact",redactIcon:'<g fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" stroke-width=".125em"><path d="M 4 5 l 1 -1"/><path d="M 4 10 l 6 -6"/><path d="M 4 15 l 11 -11"/><path d="M 4 20 l 16 -16"/><path d="M 9 20 l 11 -11"/><path d="M 14 20 l 6 -6"/><path d="M 19 20 l 1 -1"/></g>'},_plugin_retouch_locale_en_gb={retouchLabel:"Retouch",retouchIcon:'\n    <g fill="none" fill-rule="evenodd"><path fill="currentColor" d="m17 6-2-1-2 1 1-2-1-2 2 1 2-1-1 2zM5.5 5.5 3 4 .5 5.5 2 3 .5.5 3 2 5.5.5 4 3zM9 21l-3-1.5L3 21l1.5-3L3 15l3 1.5L9 15l-1.5 3z"/><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="m9.266 6.705 13.529 13.529c-.071.78-.34 1.371-.765 1.796-.425.425-1.015.694-1.796.765h0L6.705 9.266c.071-.78.34-1.371.765-1.796.425-.425 1.015-.694 1.796-.765h0Z"/><path stroke="currentColor" stroke-width="1.5" d="M12 9.5c-.657.323-1.157.657-1.5 1-.343.343-.677.843-1 1.5"/></g>\n    '},hasDefinedCustomElement=e=>document.createElement(e).constructor!==HTMLElement,linkAccessors=(e,t)=>{const o=Object.getOwnPropertyDescriptors(e);Object.keys(o).forEach((r=>{o[r].get?Object.defineProperty(t,r,{get:()=>e[r],set:t=>e[r]=t}):t[r]=e[r]}))},hasDoctype=()=>isBrowser()&&null!==document.doctype,initEditorView=e=>{const t={},{sub:o,pub:r}=pubsub();hasDoctype()||console.warn("Browser is in quirks mode, add <!DOCTYPE html> to page to fix render issues");const n=createImageEditor();linkAccessors(n,t);const i=attachEditorView(e,n.stores);linkAccessors(i,t);const a=["loadImage","processImage","abortProcessImage","abortLoadImage"].map((e=>i.on(e,(t=>{const o=n[e](t&&t.detail);o instanceof Promise&&o.catch(noop$1)})))),s=(e,t)=>{const r=o(e,t),a=n.on(e,t),s=i.on(e,t);return()=>{r(),a(),s()}};t.handleEvent=noop$1;const l=editorEvents.map((e=>s(e,(o=>t.handleEvent(e,o)))));return defineMethods(t,{on:s,updateImage:e=>new Promise(((o,r)=>{const i=t.history.get(),a=t.history.index,s=t.imageState;n.loadImage(e).then((e=>{t.history.set(i),t.history.index=a,t.imageState=s,o(e)})).catch(r)})),close:()=>{r("close")},destroy:()=>{[...a,...l].forEach((e=>e())),i.destroy(),n.destroy(),r("destroy")}}),setTimeout((()=>r("init",t)),0),t};const TAG="pintura-editor";var _defineCustomElements=()=>new Promise((e=>{if(!PinturaImageEditorElement)return e([]);!hasDefinedCustomElement(TAG)&&customElements.define(TAG,PinturaImageEditorElement),customElements.whenDefined(TAG).then((()=>e(document.querySelectorAll(TAG))))}));const PinturaImageEditorElement=isBrowser()&&class extends HTMLElement{constructor(){super(),this._editor=void 0,this._unsubs=void 0}static get observedAttributes(){return["src"]}attributeChangedCallback(e,t,o){this[e]=o}connectedCallback(){this._editor=initEditorView(this),linkAccessors(this._editor,this),this._editor.src=this.getAttribute("src"),this._unsubs=dispatchEditorEvents(this._editor,this)}disconnectedCallback(){this._editor.destroy(),this._unsubs.forEach((e=>e()))}},CSS_CLASS_NAME="pintura-editor";var _appendEditor=(e,t={})=>{const o=isString(e)?document.querySelector(e):e;if(!isElement(o))return;t.class=t.class?`${CSS_CLASS_NAME} ${t.class}`:CSS_CLASS_NAME;const r=initEditorView(o);return Object.assign(r,t)};const{document:document_1,window:window_1}=globals;function create_fragment(e){let t,o,r,n;return add_render_callback(e[28]),{c(){t=space(),o=element("div"),attr(o,"class",e[4]),set_style(o,"--editor-modal",1),set_style(o,"--viewport-pad-footer",e[5]),set_style(o,"opacity",e[7]),set_style(o,"height",e[6])},m(i,a){insert(i,t,a),insert(i,o,a),e[29](o),r||(n=[listen(window_1,"keydown",e[12]),listen(window_1,"orientationchange",e[13]),listen(window_1,"resize",e[28]),listen(document_1.body,"focusin",(function(){is_function(!e[1]&&e[9])&&(!e[1]&&e[9]).apply(this,arguments)})),listen(document_1.body,"focusout",(function(){is_function(e[2]&&e[10])&&(e[2]&&e[10]).apply(this,arguments)})),listen(o,"wheel",e[11],{passive:!1})],r=!0)},p(t,r){e=t,16&r[0]&&attr(o,"class",e[4]),32&r[0]&&set_style(o,"--viewport-pad-footer",e[5]),128&r[0]&&set_style(o,"opacity",e[7]),64&r[0]&&set_style(o,"height",e[6])},i:noop,o:noop,d(i){i&&detach(t),i&&detach(o),e[29](null),r=!1,run_all(n)}}}function instance(e,t,o){let r,n,i,a,s,l,c,u,p;const d=createEventDispatcher();let{root:m}=t,{preventZoomViewport:g=!0}=t,{preventScrollBodyIfNeeded:f=!0}=t,{preventFooterOverlapIfNeeded:$=!0}=t,{class:b}=t,y=!0,_=!1,x=!1,v=isBrowser()&&document.documentElement,S=isBrowser()&&document.body,C=isBrowser()&&document.head;const w=spring(0,{precision:.001,damping:.5});component_subscribe(e,w,(e=>o(27,p=e)));const T=w.subscribe((e=>{x&&e>=1?(o(21,x=!1),o(1,y=!1),d("show")):_&&e<=0&&(o(20,_=!1),o(1,y=!0),d("hide"))}));let k,R,P,I=!1;const E=()=>document.querySelector("meta[name=viewport]"),M=()=>Array.from(document.querySelectorAll("meta[name=theme-color]"));let A;const F=(e,t)=>{const o=()=>{e()?t():requestAnimationFrame(o)};requestAnimationFrame(o)};let L,D,z,O=0;const B=()=>{D||(D=h("div",{style:"position:fixed;height:100vh;top:0"}),S.append(D))};let N;onMount((()=>{$&&isIOS()&&B()})),afterUpdate((()=>{D&&(o(23,z=D.offsetHeight),D.remove(),D=void 0)}));const V=()=>v.style.setProperty("--pintura-document-height",`${window.innerHeight}px`);return onDestroy((()=>{v.classList.remove("PinturaModalBodyLock"),T()})),e.$$set=e=>{"root"in e&&o(0,m=e.root),"preventZoomViewport"in e&&o(14,g=e.preventZoomViewport),"preventScrollBodyIfNeeded"in e&&o(15,f=e.preventScrollBodyIfNeeded),"preventFooterOverlapIfNeeded"in e&&o(16,$=e.preventFooterOverlapIfNeeded),"class"in e&&o(17,b=e.class)},e.$$.update=()=>{137363458&e.$$.dirty[0]&&o(26,r=x||_?p:y?0:1),16384&e.$$.dirty[0]&&(n="width=device-width,height=device-height,initial-scale=1"+(g?",maximum-scale=1,user-scalable=0":"")),3145730&e.$$.dirty[0]&&o(24,i=!x&&!y&&!_),12&e.$$.dirty[0]&&(I||o(22,L=O)),67108864&e.$$.dirty[0]&&o(7,a=r),4194304&e.$$.dirty[0]&&o(6,s=`${L}px`),8388616&e.$$.dirty[0]&&o(5,l=isNumber(z)?"--viewport-pad-footer:"+(z>O?0:1):void 0),131072&e.$$.dirty[0]&&o(4,c=arrayJoin(["pintura-editor","PinturaModal",b])),32768&e.$$.dirty[0]&&o(25,u=f&&isIOS()&&/15_/.test(navigator.userAgent)),50331648&e.$$.dirty[0]&&u&&(e=>{e?(N=window.scrollY,v.classList.add("PinturaDocumentLock"),V(),window.addEventListener("resize",V)):(window.removeEventListener("resize",V),v.classList.remove("PinturaDocumentLock"),isNumber(N)&&window.scrollTo(0,N),N=void 0)})(i)},[m,y,I,O,c,l,s,a,w,e=>{isTextField(e.target)&&(o(2,I=!0),A=O)},e=>{if(isTextField(e.target))if(clearTimeout(undefined),A===O)o(2,I=!1);else{const e=O;F((()=>O!==e),(()=>o(2,I=!1)))}},e=>{e.target&&/PinturaStage/.test(e.target.className)&&e.preventDefault()},e=>{const{key:t}=e;if(!/escape/i.test(t))return;const o=e.target;if(o&&/input|textarea/i.test(o.nodeName))return;const r=document.querySelectorAll(".PinturaModal");r[r.length-1]===m&&d("close")},B,g,f,$,b,()=>{if(x||!y)return;o(21,x=!0);const e=E()||h("meta",{name:"viewport"});k=!k&&e.getAttribute("content"),e.setAttribute("content",n+(/cover/.test(k)?",viewport-fit=cover":"")),e.parentNode||C.append(e);const t=getComputedStyle(m).getPropertyValue("--color-background"),r=M();if(r.length)R=r.map((e=>e.getAttribute("content")));else{const e=h("meta",{name:"theme-color"});C.append(e),r.push(e)}r.forEach((e=>e.setAttribute("content",`rgb(${t})`))),clearTimeout(P),P=setTimeout((()=>w.set(1)),250)},()=>{if(_||y)return;clearTimeout(P),o(20,_=!0);const e=E();k?e.setAttribute("content",k):e.remove();const t=M();R?t.forEach(((e,t)=>{e.setAttribute("content",R[t])})):t.forEach((e=>e.remove())),w.set(0)},_,x,L,z,i,u,r,p,function(){o(3,O=window_1.innerHeight)},function(e){binding_callbacks[e?"unshift":"push"]((()=>{m=e,o(0,m)}))}]}class Modal extends SvelteComponent{constructor(e){super(),init(this,e,instance,create_fragment,safe_not_equal,{root:0,preventZoomViewport:14,preventScrollBodyIfNeeded:15,preventFooterOverlapIfNeeded:16,class:17,show:18,hide:19},null,[-1,-1])}get root(){return this.$$.ctx[0]}set root(e){this.$$set({root:e}),flush()}get preventZoomViewport(){return this.$$.ctx[14]}set preventZoomViewport(e){this.$$set({preventZoomViewport:e}),flush()}get preventScrollBodyIfNeeded(){return this.$$.ctx[15]}set preventScrollBodyIfNeeded(e){this.$$set({preventScrollBodyIfNeeded:e}),flush()}get preventFooterOverlapIfNeeded(){return this.$$.ctx[16]}set preventFooterOverlapIfNeeded(e){this.$$set({preventFooterOverlapIfNeeded:e}),flush()}get class(){return this.$$.ctx[17]}set class(e){this.$$set({class:e}),flush()}get show(){return this.$$.ctx[18]}get hide(){return this.$$.ctx[19]}}var createModal=(e={},t)=>new Modal({target:t||document.body,props:{class:e.class,preventZoomViewport:e.preventZoomViewport,preventScrollBodyIfNeeded:e.preventScrollBodyIfNeeded,preventFooterOverlapIfNeeded:e.preventFooterOverlapIfNeeded}}),_openEditor=(e={},t)=>{const{sub:o,pub:r}=pubsub(),n={},i=createModal(e,t),a=()=>{i.hide&&i.hide()},s=()=>{i.show&&i.show()},l=initEditorView(i.root);linkAccessors(l,n),n.handleEvent=noop$1,l.handleEvent=(e,t)=>{if("init"===e)return n.handleEvent(e,n);n.handleEvent(e,t)},l.on("close",(async()=>{const{willClose:t}=e;if(!t)return a();await t()&&a()}));const c=(e,t)=>/show|hide/.test(e)?o(e,t):l.on(e,t),u=["show","hide"].map((e=>c(e,(t=>n.handleEvent(e,t))))),p=()=>{u.forEach((e=>e())),a(),i.$destroy(),l.destroy()};return defineMethods(n,{on:c,destroy:p,hide:a,show:s}),Object.defineProperty(n,"modal",{get:()=>i.root,set:()=>{}}),i.$on("close",l.close),i.$on("show",(()=>r("show"))),i.$on("hide",(()=>{r("hide"),!1!==e.enableAutoDestroy&&p()})),!1!==e.enableAutoHide&&l.on("process",a),l.on("loadstart",s),!1!==e.enableButtonClose&&(e.enableButtonClose=!0),delete e.class,Object.assign(n,e),n},_overlayEditor=(e,t)=>_appendEditor(e,{...t,layout:"overlay"});const getLineEndParams=(e,t,o,r)=>{const n=vectorCreate(t.x-e.x,t.y-e.y),i=vectorNormalize(n),a=5*o;let s;s=r?.5*a:Math.ceil(.5*(a-1));const l=vectorMultiply(vectorClone(i),s);return{anchor:vectorClone(e),offset:l,normal:i,solid:r,size:a,sizeHalf:s}},lineEndStyleArrow=(e,t,o)=>{const{strokeWidth:r,strokeColor:n,strokeJoin:i,strokeCap:a,...s}=e,{anchor:l,offset:c,normal:u,solid:p,size:d,sizeHalf:h}=t,m=l.x,g=l.y,f=vectorMultiply(vectorClone(u),d),$=vectorCreate(m+f.x,g+f.y);if(vectorMultiply(f,.55),p){vectorAdd(o,c);const e=vectorMultiply(vectorClone(u),.5*h);return[{...s,points:[vectorCreate(m-e.x,g-e.y),vectorCreate($.x-f.y,$.y+f.x),vectorCreate($.x+f.y,$.y-f.x)],pathClose:!0,backgroundColor:n}]}{const e=vectorMultiply(vectorPerpendicular(vectorClone(u)),.5),t=vectorCreate(m-e.x,g-e.y),o=vectorCreate(m+e.x,g+e.y);return[{...s,points:[vectorCreate($.x+f.y,$.y-f.x),t,vectorCreate(m,g),o,vectorCreate($.x-f.y,$.y+f.x)],pathClose:!1,strokeWidth:r,strokeColor:n,strokeJoin:i,strokeCap:a}]}},lineEndStyleCircle=(e,t,o)=>{const{strokeWidth:r,strokeColor:n,...i}=e,{anchor:a,solid:s,offset:l,normal:c,sizeHalf:u}=t;return vectorAdd(o,l),s&&vectorAdd(o,vectorInvert(vectorClone(c))),[{...i,x:a.x,y:a.y,rx:u,ry:u,backgroundColor:s?n:void 0,strokeWidth:s?void 0:r,strokeColor:s?void 0:n}]},lineEndStyleBar=(e,t)=>{const{strokeWidth:o,strokeColor:r,strokeJoin:n,strokeCap:i,...a}=e,{anchor:s,offset:l}=t;return[{...a,points:[vectorCreate(s.x-l.y,s.y+l.x),vectorCreate(s.x+l.y,s.y-l.x)],strokeWidth:o,strokeColor:r,strokeJoin:n,strokeCap:i}]},lineEndStyleSquare=(e,t,o)=>{const{strokeWidth:r,strokeColor:n,...i}=e,{anchor:a,solid:s,offset:l,normal:c,sizeHalf:u}=t;return vectorAdd(o,l),[{...i,x:a.x-u,y:a.y-u,width:2*u,height:2*u,rotation:vectorAngle(c),backgroundColor:s?n:void 0,strokeWidth:s?void 0:r,strokeColor:s?void 0:n}]},createLineEndProcessor=(e={})=>t=>{if(!t.lineStart&&!t.lineEnd)return;const o=[],{x1:r,y1:n,x2:i,y2:a,lineStart:s,lineEnd:l,strokeWidth:c,strokeColor:u,strokeJoin:p,strokeCap:d,strokeDash:h,bitmap:m,aboveFrame:g,opacity:f}=t,$=vectorCreate(r,n),b=vectorCreate(i,a),y=[$,b],_={bitmap:m,aboveFrame:g,opacity:f,strokeColor:u,strokeWidth:c,strokeJoin:p,strokeCap:d};if(s){const[t,r]=s.split("-"),n=e[t];if(n){const e=getLineEndParams($,b,c,!!r);o.push(...n(_,e,$))}}if(l){const[t,r]=l.split("-"),n=e[t];if(n){const e=getLineEndParams(b,$,c,!!r);o.push(...n(_,e,b))}}return[{..._,strokeDash:h,points:y},...o]},createDefaultLineEndStyles=()=>({arrow:lineEndStyleArrow,circle:lineEndStyleCircle,square:lineEndStyleSquare,bar:lineEndStyleBar}),safeFactor=(e,t)=>{const o=parseFloat(e)*t;return isString(e)?`${o}%`:o},toValue=(e,t)=>isString(e)?toPixelValue(e,t):e,frameStyleSolid=e=>[{...e,frameStyle:"line",frameInset:0,frameOffset:0,frameSize:e.frameSize?safeFactor(e.frameSize,2):"2.5%",frameRadius:e.frameRound?safeFactor(e.frameSize,2):0}],frameStyleNine=({width:e,height:t,frameImage:o,frameSize:r="15%",frameOutset:n=0,frameSlices:i={x1:.15,y1:.15,x2:.85,y2:.85}},{isPreview:a})=>{if(!o)return[];const s=Math.sqrt(e*t),l=toValue(r,s),c=a?l:Math.round(l),u=c,p=toValue(n,s),d=2*p,{x1:h,x2:m,y1:g,y2:f}=i,$={x0:0,y0:0,x1:c,y1:u,x2:e-c,y2:t-u,x3:e,y3:t,cw:c,ch:u,ew:e-c-c,eh:t-u-u},b=a?1:0,y=2*b,_=p>0,x={expandsCanvas:_,width:$.cw,height:$.ch,backgroundImage:o};return[{expandsCanvas:_,x:$.x1-b-p,y:$.y0-p,width:$.ew+y+d,height:$.ch,backgroundCorners:[{x:h,y:0},{x:m,y:0},{x:m,y:g},{x:h,y:g}],backgroundImage:o},{expandsCanvas:_,x:$.x1-b-p,y:$.y2+p,width:$.ew+y+d,height:$.ch,backgroundCorners:[{x:h,y:f},{x:m,y:f},{x:m,y:1},{x:h,y:1}],backgroundImage:o},{expandsCanvas:_,x:$.x0-p,y:$.y1-b-p,width:$.cw,height:$.eh+y+d,backgroundCorners:[{x:0,y:g},{x:h,y:g},{x:h,y:f},{x:0,y:f}],backgroundImage:o},{expandsCanvas:_,x:$.x2+p,y:$.y1-b-p,width:$.cw,height:$.eh+y+d,backgroundCorners:[{x:m,y:g},{x:1,y:g},{x:1,y:f},{x:m,y:f}],backgroundImage:o},{...x,x:$.x0-p,y:$.y0-p,backgroundCorners:[{x:0,y:0},{x:h,y:0},{x:h,y:g},{x:0,y:g}]},{...x,x:$.x2+p,y:$.y0-p,backgroundCorners:[{x:m,y:0},{x:1,y:0},{x:1,y:g},{x:m,y:g}]},{...x,x:$.x2+p,y:$.y2+p,backgroundCorners:[{x:m,y:f},{x:1,y:f},{x:1,y:1},{x:m,y:1}]},{...x,x:$.x0-p,y:$.y2+p,backgroundCorners:[{x:0,y:f},{x:h,y:f},{x:h,y:1},{x:0,y:1}]}]},frameStyleLine=({x:e,y:t,width:o,height:r,frameInset:n="3.5%",frameSize:i=".25%",frameColor:a=[1,1,1],frameOffset:s="5%",frameAmount:l=1,frameRadius:c=0,expandsCanvas:u=!1},{isPreview:p})=>{const d=Math.sqrt(o*r);let h=toValue(i,d);const m=toValue(n,d),g=toValue(s,d);let f=0;p||(h=Math.max(1,Math.round(h)),f=h%2==0?0:.5);const $=toValue(safeFactor(c,l),d);return new Array(l).fill(void 0).map(((n,i)=>{const s=g*i;let l=e+m+s,c=t+m+s,d=e+o-m-s,b=t+r-m-s;p||(l=Math.round(l),c=Math.round(c),d=Math.round(d),b=Math.round(b));return{x:l+f,y:c+f,width:d-l,height:b-c,cornerRadius:$>0?$-s:0,strokeWidth:h,strokeColor:a,expandsCanvas:u}}))},frameStyleEdge=({x:e,y:t,width:o,height:r,frameSize:n=".25%",frameOffset:i=0,frameInset:a="2.5%",frameColor:s=[1,1,1]},{isPreview:l})=>{const c=Math.sqrt(o*r);let u=toValue(n,c),p=toValue(a,c),d=toValue(i,c),h=0;l||(u=Math.max(1,Math.round(u)),p=Math.round(p),d=Math.round(d),h=u%2==0?0:.5);const m=d-p,g=e+p+h,f=t+p+h,$=e+o-p-h,b=t+r-p-h;return[{points:[vectorCreate(g+m,f),vectorCreate($-m,f)]},{points:[vectorCreate($,f+m),vectorCreate($,b-m)]},{points:[vectorCreate($-m,b),vectorCreate(g+m,b)]},{points:[vectorCreate(g,b-m),vectorCreate(g,f+m)]}].map((e=>(e.strokeWidth=u,e.strokeColor=s,e)))},frameStyleHook=({x:e,y:t,width:o,height:r,frameSize:n=".25%",frameInset:i="2.5%",frameLength:a="2.5%",frameColor:s=[1,1,1]},{isPreview:l})=>{const c=Math.sqrt(o*r);let u=toValue(n,c),p=toValue(i,c),d=toValue(a,c),h=0;l||(u=Math.max(1,Math.round(u)),p=Math.round(p),d=Math.round(d),h=u%2==0?0:.5);const m=e+p+h,g=t+p+h,f=e+o-p-h,$=t+r-p-h;return[{points:[vectorCreate(m,g+d),vectorCreate(m,g),vectorCreate(m+d,g)]},{points:[vectorCreate(f-d,g),vectorCreate(f,g),vectorCreate(f,g+d)]},{points:[vectorCreate(f,$-d),vectorCreate(f,$),vectorCreate(f-d,$)]},{points:[vectorCreate(m+d,$),vectorCreate(m,$),vectorCreate(m,$-d)]}].map((e=>(e.strokeWidth=u,e.strokeColor=s,e)))},frameStylePolaroid=({x:e,y:t,width:o,height:r,frameColor:n=[1,1,1]},{isPreview:i})=>{const a=Math.sqrt(o*r),s=.1*a;let l=.2*a,c=0;const u=.5*s;return i?c=1:l=Math.ceil(l),n.length=3,[{id:"border",x:e-u+c,y:t-u+c,width:o+s-2*c,height:r+l-2*c,frameStyle:"line",frameInset:0,frameOffset:0,frameSize:s,frameColor:n,expandsCanvas:!0},{id:"chin",x:e-u,y:r-c,width:o+s,height:l,backgroundColor:n,expandsCanvas:!0}].filter(Boolean)},createFrameStyleProcessor=(e={})=>(t,o)=>{if(!hasProp(t,"frameStyle"))return;const r=t.frameStyle,n=e[r];if(!n)return;const{frameStyle:i,...a}=t;return n(a,o)},createDefaultFrameStyles=()=>({solid:frameStyleSolid,hook:frameStyleHook,line:frameStyleLine,edge:frameStyleEdge,polaroid:frameStylePolaroid,nine:frameStyleNine}),createDefaultLineEndProcessors=()=>createLineEndProcessor(createDefaultLineEndStyles()),createDefaultFrameStyleProcessor=()=>createFrameStyleProcessor(createDefaultFrameStyles()),createDefaultShapeProcessors=()=>[createDefaultFrameStyleProcessor(),createDefaultLineEndProcessors()],createShapePreprocessor$1=e=>{const t=(o,r={isPreview:!0})=>{const n=e.map((e=>{const n=e(o,r);if(n)return n.map((e=>t(e,r)))})).filter(Boolean).flat();return n.length?n.flat().map(((e,t)=>(e.id=o.id+"_"+t,e))):o};return t},createDefaultImageReader=createDefaultImageReader$1,createDefaultImageWriter=createDefaultImageWriter$1,createDefaultMediaWriter=createDefaultMediaWriter$1,createDefaultImageOrienter=()=>({read:getImageOrientationFromFile,apply:orientImageData}),createDefaultImageScrambler=(e={})=>{const{blurAmount:t,dataSizeScalar:o,scrambleAmount:r,backgroundColor:n}=e;return(e,i)=>imageDataScramble(e,{blurAmount:t,scrambleAmount:r,backgroundColor:n,...i,dataSizeScalar:o||i.dataSizeScalar})},createEditor=createImageEditor,getEditorProps=()=>getEditorProps$1().concat(getEditorViewProps()),createMarkupEditorToolbar=createToolbar,createMarkupEditorToolStyles=createToolStyles,createMarkupEditorShapeStyleControls=createShapeStyleControls,getShapeById=(e,t)=>e.find((e=>e.id===t)),updateShapeById=(e,t,o)=>e.map((e=>e.id!==t?e:o(e))),markup_editor_defaults={markupEditorToolbar:createToolbar(),markupEditorToolStyles:createToolStyles(),markupEditorShapeStyleControls:createShapeStyleControls()},setPlugins=setEditorViewPlugins,plugin_crop=_plugin_crop,plugin_filter=_plugin_filter,plugin_finetune=_plugin_finetune,plugin_annotate=_plugin_annotate,plugin_decorate=_plugin_decorate,plugin_sticker=_plugin_sticker,plugin_frame=_plugin_frame,plugin_redact=_plugin_redact,plugin_resize=_plugin_resize,plugin_fill=_plugin_fill,plugin_retouch=_plugin_retouch,plugin_finetune_defaults=_plugin_finetune_defaults,plugin_filter_defaults=_plugin_filter_defaults,plugin_frame_defaults=_plugin_frame_defaults,locale_en_gb=_locale_en_gb,markup_editor_locale_en_gb=MarkupEditor,plugin_crop_locale_en_gb=_plugin_crop_locale_en_gb,plugin_fill_locale_en_gb=_plugin_fill_locale_en_gb,plugin_filter_locale_en_gb=_plugin_filter_locale_en_gb,plugin_finetune_locale_en_gb=_plugin_finetune_locale_en_gb,plugin_resize_locale_en_gb=_plugin_resize_locale_en_gb,plugin_decorate_locale_en_gb=_plugin_decorate_locale_en_gb,plugin_annotate_locale_en_gb=_plugin_annotate_locale_en_gb,plugin_sticker_locale_en_gb=_plugin_sticker_locale_en_gb,plugin_frame_locale_en_gb=_plugin_frame_locale_en_gb,plugin_redact_locale_en_gb=_plugin_redact_locale_en_gb,plugin_retouch_locale_en_gb=_plugin_retouch_locale_en_gb,elementsToEditor=(e,t,o={})=>(isString(t)?Array.from(document.querySelectorAll(t)):t).filter(Boolean).map((t=>e(t,deepCopy(o)))),appendEditor=_appendEditor,openEditor=_openEditor,overlayEditor=_overlayEditor,appendEditors=(e,t)=>elementsToEditor(appendEditor,e,t),createShapePreprocessor=createShapePreprocessor$1,createDefaultShapePreprocessor=(e=[])=>createShapePreprocessor$1([...createDefaultShapeProcessors(),...e]),getEditorDefaultReadWriteOptions=(e={})=>{let t,o,r;return Array.isArray(e.imageReader)||(t=e.imageReader,delete e.imageReader),Array.isArray(e.imageWriter)?o=createDefaultImageWriter():(o=isFunction(e.imageWriter)?e.imageWriter:createDefaultImageWriter(e.imageWriter),delete e.imageWriter),isFunction(e.imageScrambler)||(r=e.imageScrambler,delete e.imageScrambler),{imageReader:createDefaultImageReader(t),imageWriter:o,imageOrienter:createDefaultImageOrienter(),imageScrambler:createDefaultImageScrambler(r)}},processDefaultImage=(e,t={})=>{const o=getEditorDefaultReadWriteOptions(t),r="function"==typeof t.shapePreprocessor?t.shapePreprocessor:createDefaultShapePreprocessor(t.shapePreprocessor);return delete t.shapePreprocessor,t=mergeObjects([{...o,shapePreprocessor:r,stickerStickToImage:!0},t]),processImage(e,t)},getCropperDefaults=(e={})=>{setEditorViewPlugins(plugin_crop);const t=getEditorDefaultReadWriteOptions(e),o={...locale_en_gb,...plugin_crop_locale_en_gb,...e.locale};return delete e.locale,mergeObjects([{...t,utils:["crop"],locale:o},e])},getEditorDefaults=(e={})=>{setEditorViewPlugins(plugin_crop,plugin_filter,plugin_finetune,plugin_annotate,plugin_decorate,plugin_sticker,plugin_frame,plugin_redact,plugin_resize,plugin_fill);const t=getEditorDefaultReadWriteOptions(e),o={...locale_en_gb,...markup_editor_locale_en_gb,...plugin_crop_locale_en_gb,...plugin_fill_locale_en_gb,...plugin_filter_locale_en_gb,...plugin_finetune_locale_en_gb,...plugin_frame_locale_en_gb,...plugin_redact_locale_en_gb,...plugin_resize_locale_en_gb,...plugin_decorate_locale_en_gb,...plugin_annotate_locale_en_gb,...plugin_sticker_locale_en_gb,...e.locale};delete e.locale;const r="function"==typeof e.shapePreprocessor?e.shapePreprocessor:createDefaultShapePreprocessor(e.shapePreprocessor);if(delete e.shapePreprocessor,e.markupEditorShapeStyleControls){Object.entries(e.markupEditorShapeStyleControls).every((([e,t])=>/Options$/.test(e)||!Array.isArray(t)))&&(e.markupEditorShapeStyleControls=createMarkupEditorShapeStyleControls({...e.markupEditorShapeStyleControls}))}return mergeObjects([{...t,shapePreprocessor:r,utils:["trim","crop","filter","finetune","retouch","annotate","decorate","sticker","fill","frame","redact","resize"],...plugin_finetune_defaults,...plugin_filter_defaults,...plugin_frame_defaults,...markup_editor_defaults,stickerStickToImage:!0,locale:o},e])},defineCustomElements=async(e={})=>{const t=await _defineCustomElements();return t.forEach((t=>Object.assign(t,deepCopy(e)))),t},defineDefaultCustomElements=e=>defineCustomElements(getEditorDefaults(e)),openDefaultEditor=(e,t)=>openEditor(getEditorDefaults(e),t),appendDefaultEditor=(e,t)=>appendEditor(e,getEditorDefaults(t)),overlayDefaultEditor=(e,t)=>overlayEditor(e,getEditorDefaults(t)),appendDefaultEditors=(e,t)=>elementsToEditor(appendDefaultEditor,e,t),toSelectionShape=(e,t,o)=>{const r={...e};return shapeScale(r,t),r.width||r.rx?r.backgroundColor=o:r.points&&!r.pathClose?(r.strokeJoin="round",r.strokeCap="round",r.strokeColor=o):r.points&&(r.backgroundColor=o,r.strokeColor=[0,0,0,0]),r},selectionToMask=(e,t,o,r)=>new Promise((async(n,i)=>{const{format:a="canvas",backgroundColor:s=[0,0,0],foregroundColor:l=[1,1,1],scope:c="mask",padding:u=0,maxSize:p=t,targetSize:d,forceSquareCanvas:m=!1,precision:g=7}=r||{},{flipX:f,flipY:$,rotation:b}=o,y=Math.min(1,2048/t.width),_=sizeScale({...t},y),x=sizeRotate({...t},b),v=sizeRotate({..._},b),S={x:.5*(_.width-v.width),y:.5*(_.height-v.height),...v},C=void 0===l||0===l[3],w=C?[1,1,1]:l,T={imageAnnotation:e.map((e=>toSelectionShape(e,y,w))),imageBackgroundColor:"image"===c?[0,0,0]:void 0,imageCropLimitToImage:!1,imageCrop:S,imageFlipX:f,imageFlipY:$,imageRotation:b,imageWriter:{format:"canvas"}},{dest:k}=await processDefaultImage(h("canvas",_),{...T}),R=k.getContext("2d",{desynchronized:!0,willReadFrequently:!0});let P,I;{const e=Number.MAX_SAFE_INTEGER,{width:t,height:o}=k,r=R.getImageData(0,0,t,o).data;let n,i,a=Math.max(1,parseInt(g,10)),s=t-a,l=o-a,[c,u,d,h]=[e,-e,-e,e];for(n=0;n<=l;n+=a)for(i=0;i<=s;i+=a){r[4*(i+n*t)+3]<=32||(i<h?h=i:i>u&&(u=i),n<c?c=n:n>d&&(d=n))}const m=rectCreateFromBounds([c-g,u+g,d+g,h-g]),f=rectCenter(m),$=Math.min(m.width,p.width),b=Math.min(m.height,p.height);P=rectCreate(f.x-.5*$,f.y-.5*b,$,b)}rectScale$1(P,1/y,vectorCreateEmpty());let E=u,M=u;if("mask"===c){const e=sizeCreateFromRect(P);if(e.width+=2*E,e.height+=2*M,m){const t=Math.max(e.width,e.height);E+=.5*(t-e.width),M+=.5*(t-e.height),e.width=t,e.height=t}let t=1;d&&(t=Math.min(d.width/e.width,d.height/e.height,1)),sizeScale(e,t);const o=h("canvas",e),r=o.getContext("2d");r.fillStyle=colorArrayToRGBA(s),r.fillRect(0,0,o.width,o.height),C&&(r.globalCompositeOperation="destination-out"),r.scale(t,t),r.drawImage(k,-P.x+E,-P.y+M,x.width,x.height),I=o}else I=k;const A=rectCreateFromSize(t);A.x+=.5*(x.width-t.width),A.y+=.5*(x.height-t.height);const[F]=rectRotate(A,b),L=rectCenter({...P}),D=vectorCreate(L.x-F.x,L.y-F.y);P.x=Math.cos(b)*D.x+Math.sin(b)*D.y-.5*P.width,P.y=Math.cos(b)*D.y-Math.sin(b)*D.x-.5*P.height;const z={...P};if(z.x=P.x,z.y=P.y,f&&$?(z.flipX=!0,z.flipY=!0,z.rotation=-b):f?(z.flipX=!0,z.rotation=b):$?(z.flipY=!0,z.rotation=b):z.rotation=-b,f||$){const e={x:z.x+.5*z.width,y:z.y+.5*z.height};f&&(e.x=Math.abs(t.width-e.x),z.x=e.x-.5*z.width),$&&(e.y=Math.abs(t.height-e.y),z.y=e.y-.5*z.height)}if(E||M){const e=E/(P.width+2*E),t=M/(P.height+2*M);z.backgroundCorners=[{x:e,y:t},{x:1-e,y:t},{x:1-e,y:1-t},{x:e,y:1-t}],P.x-=E,P.y-=M,P.width+=2*E,P.height+=2*M}const O={canvas:I,rect:P,shape:z};"blob"!==a?n({...O,blob:void 0}):I.toBlob((e=>n({...O,blob:e})))})),createRetouchShapeDraft=(e=void 0,t={})=>({id:e,...t,selectionStyle:"hook",disableStyle:["backgroundColor","cornerRadius","opacity","strokeWidth","strokeColor"],disableFlip:!0,disableReorder:!0,disableMove:!0,disableRotate:!0,disableDuplicate:!0,disableSelect:!0}),applyLoadStartState=e=>(Object.assign(e,{status:"loading",cornerRadius:15,strokeWidth:1.5,strokeColor:[0,0,0,.25],backgroundColor:[0,0,0,.1],selectionOpacity:0}),e),applyLoadCompleteState=e=>(Object.assign(e,{selectionOpacity:1,cornerRadius:0,strokeWidth:0,strokeColor:[0,0,0,0],backgroundColor:[0,0,0,0]}),"error"!==e.status&&delete e.status,e),createRetouchShape=async(e,t,o,r,n,i)=>{const{retouches:a=[],maxSize:s=t,targetSize:l,padding:c=0,mimeType:u,foregroundColor:p,maskFormat:d="blob",imageFormat:h="blob",forceSquareCanvas:m=!1,didCreateDraft:g=()=>{}}=i||{},f=[...r],$=[...a],b=new AbortController,{blob:y,canvas:_,rect:x,shape:v}=await selectionToMask(f,t,o,{scope:"mask",format:d,padding:c,maxSize:s,targetSize:l,forceSquareCanvas:m,foregroundColor:p}),S=createRetouchShapeDraft(getUniqueId(),{...v});applyLoadStartState(S),g(S,{selection:f});let C={};(u||l||"canvas"===h)&&(C={imageWriter:{}},u&&(C.imageWriter.mimeType=u),l&&(C.imageWriter.targetSize=l),h&&(C.imageWriter.format=h));const{flipX:w,flipY:T,rotation:k}=o,{dest:R}=await processDefaultImage(e,{imageFlipX:w,imageFlipY:T,imageRotation:k,imageCrop:x,imageManipulation:$,imageCropLimitToImage:!1,...C});let P;try{await n(R,y||_,{shape:S,controller:b}),P="ok"}catch{P="error"}return applyLoadCompleteState({...S,status:P,disableSelect:!1})};export{appendDefaultEditor,appendDefaultEditors,appendEditor,appendEditors,appendNode,blobToFile,canvasToBlob,colorStringToColorArray,createDefaultColorOptions,createDefaultFontFamilyOptions,createDefaultFontScaleOptions,createDefaultFontSizeOptions,createDefaultFontStyleOptions,createDefaultFrameStyles,createDefaultImageOrienter,createDefaultImageReader,createDefaultImageScrambler,createDefaultImageWriter,createDefaultLineEndStyleOptions,createDefaultLineEndStyles,createDefaultLineHeightOptions,createDefaultLineHeightScaleOptions,createDefaultMediaWriter,createDefaultShapePreprocessor,createDefaultStrokeScaleOptions,createDefaultStrokeWidthOptions,createDefaultTextAlignOptions,createEditor,createFrameStyleProcessor,createLineEndProcessor,createBackgroundColorControl as createMarkupEditorBackgroundColorControl,createBrushSizeControl as createMarkupEditorBrushSizeControl,createColorControl as createMarkupEditorColorControl,createColorOptions as createMarkupEditorColorOptions,createFontColorControl as createMarkupEditorFontColorControl,createFontFamilyControl as createMarkupEditorFontFamilyControl,createFontFamilyOptions as createMarkupEditorFontFamilyOptions,createFontScaleOptions as createMarkupEditorFontScaleOptions,createFontSizeControl as createMarkupEditorFontSizeControl,createFontSizeOptions as createMarkupEditorFontSizeOptions,createFontStyleControl as createMarkupEditorFontStyleControl,createFontStyleOptions as createMarkupEditorFontStyleOptions,createLineEndStyleControl as createMarkupEditorLineEndStyleControl,createLineEndStyleOptions as createMarkupEditorLineEndStyleOptions,createLineHeightControl as createMarkupEditorLineHeightControl,createLineHeightOptions as createMarkupEditorLineHeightOptions,createLineHeightScaleOptions as createMarkupEditorLineHeightScaleOptions,createLineStartStyleControl as createMarkupEditorLineStartStyleControl,createOptionControl as createMarkupEditorOptionControl,createOptionsControl as createMarkupEditorOptionsControl,createSelectionModeControl as createMarkupEditorSelectionModeControl,createSelectionToolStyles as createMarkupEditorSelectionToolStyles,createSelectionTools as createMarkupEditorSelectionTools,createMarkupEditorShapeStyleControls,createStrokeColorControl as createMarkupEditorStrokeColorControl,createStrokeScaleOptions as createMarkupEditorStrokeScaleOptions,createStrokeWidthControl as createMarkupEditorStrokeWidthControl,createStrokeWidthOptions as createMarkupEditorStrokeWidthOptions,createTextAlignControl as createMarkupEditorTextAlignControl,createToolStyle as createMarkupEditorToolStyle,createMarkupEditorToolStyles,createMarkupEditorToolbar,createNode,createRetouchShape,createShapePreprocessor,defineCustomElements,defineDefaultCustomElements,degToRad,dispatchEditorEvents,brightness as effectBrightness,clarity as effectClarity,contrast as effectContrast,exposure as effectExposure,gamma as effectGamma,saturation as effectSaturation,temperature as effectTemperature,vignette as effectVignette,chrome as filterChrome,cold as filterCold,fade as filterFade,invert as filterInvert,monoDefault as filterMonoDefault,monoNoir as filterMonoNoir,monoStark as filterMonoStark,monoWash as filterMonoWash,pastel as filterPastel,sepiaBlues as filterSepiaBlues,sepiaColor as filterSepiaColor,sepiaDefault as filterSepiaDefault,sepiaRust as filterSepiaRust,warm as filterWarm,findNode,edgeCross as frameEdgeCross,edgeOverlap as frameEdgeOverlap,edgeSeparate as frameEdgeSeparate,hook as frameHook,lineMultiple as frameLineMultiple,lineSingle as frameLineSingle,polaroid as framePolaroid,solidRound as frameSolidRound,solidSharp as frameSolidSharp,getCropperDefaults,getEditorDefaults,getEditorProps,getShapeById,getUniqueId,imageStateToCanvas,insertNodeAfter,insertNodeBefore,isModernBrowser as isSupported,legacyDataToImageState,locale_en_gb,markup_editor_defaults,markup_editor_locale_en_gb,naturalAspectRatioToNumber,openDefaultEditor,openEditor,overlayDefaultEditor,overlayEditor,plugin_annotate,plugin_annotate_locale_en_gb,plugin_crop,plugin_crop_locale_en_gb,plugin_decorate,plugin_decorate_locale_en_gb,plugin_fill,plugin_fill_locale_en_gb,plugin_filter,plugin_filter_defaults,plugin_filter_locale_en_gb,plugin_finetune,plugin_finetune_defaults,plugin_finetune_locale_en_gb,plugin_frame,plugin_frame_defaults,plugin_frame_locale_en_gb,plugin_redact,plugin_redact_locale_en_gb,plugin_resize,plugin_resize_locale_en_gb,plugin_retouch,plugin_retouch_locale_en_gb,plugin_sticker,plugin_sticker_locale_en_gb,processDefaultImage,processImage,removeNode,selectionToMask,setPlugins,shapeGetCenter,shapeGetLength,shapeGetLevel,supportsWebGL,updateNode,updateShapeById};