<?php

namespace Bricks;

if (! defined('ABSPATH')) exit; // Exit if accessed directly

class Element_BrfApiQueryBuilderLoadMore extends Element
{
    public $block    = 'core/button';
    public $category = 'bricksforge api query builder';
    public $name     = 'brf-api-query-builder-load-more';
    public $icon     = 'ti-control-stop';
    public $tag      = 'span';

    public function get_label()
    {
        return esc_html__('Load More', 'bricksforge');
    }

    public function set_controls()
    {

        // Connection
        $this->controls['connection'] = [
            'label' => esc_html__('Connection', 'bricksforge'),
            'type'  => 'text',
            'description' => esc_html__('The connection to the API Query Builder. This field expects the ID of your API Query Builder Item OR the Bricks Query Loop ID', 'bricksforge'),
            'default' => '',
        ];

        // Loading Text
        $this->controls['loadingText'] = [
            'label' => esc_html__('Loading Text', 'bricksforge'),
            'type'  => 'text',
            'default' => esc_html__('Loading...', 'bricksforge'),
            'description' => esc_html__('The text to display while the content is loading.', 'bricksforge'),
        ];

        // General Separator
        $this->controls['generalSeparator'] = [
            'label' => esc_html__('General', 'bricksforge'),
            'type'  => 'separator',
        ];
        $this->controls['text'] = [
            'type'        => 'text',
            'default'     => esc_html__('Load More', 'bricksforge'),
            'placeholder' => esc_html__('Load More', 'bricksforge'),
        ];

        $this->controls['tag'] = [
            'label'          => esc_html__('HTML tag', 'bricksforge'),
            'type'           => 'text',
            'hasDynamicData' => false,
            'inline'         => true,
            'validate'       => $this->get_in_builder_html_tag_validation_rules(),
            'placeholder'    => 'span',
            'required'       => ['link', '=', ''],
            'default'        => 'button',
        ];

        $this->controls['size'] = [
            'label'       => esc_html__('Size', 'bricksforge'),
            'type'        => 'select',
            'options'     => $this->control_options['buttonSizes'],
            'inline'      => true,
            'reset'       => true,
            'placeholder' => esc_html__('Default', 'bricksforge'),
        ];

        $this->controls['style'] = [
            'label'       => esc_html__('Style', 'bricksforge'),
            'type'        => 'select',
            'options'     => $this->control_options['styles'],
            'inline'      => true,
            'reset'       => true,
            'default'     => 'primary',
            'placeholder' => esc_html__('Default', 'bricksforge'),
        ];

        $this->controls['circle'] = [
            'label' => esc_html__('Circle', 'bricksforge'),
            'type'  => 'checkbox',
            'reset' => true,
        ];

        $this->controls['outline'] = [
            'label' => esc_html__('Outline', 'bricksforge'),
            'type'  => 'checkbox',
            'reset' => true,
        ];

        // Icon
        $this->controls['iconSeparator'] = [
            'label' => esc_html__('Icon', 'bricksforge'),
            'type'  => 'separator',
        ];

        $this->controls['icon'] = [
            'label' => esc_html__('Icon', 'bricksforge'),
            'type'  => 'icon',
        ];

        $this->controls['iconTypography'] = [
            'label'    => esc_html__('Typography', 'bricksforge'),
            'type'     => 'typography',
            'css'      => [
                [
                    'property' => 'font',
                    'selector' => 'i',
                ],
            ],
            'required' => ['icon.icon', '!=', ''],
        ];

        $this->controls['iconPosition'] = [
            'label'       => esc_html__('Position', 'bricksforge'),
            'type'        => 'select',
            'options'     => $this->control_options['iconPosition'],
            'inline'      => true,
            'placeholder' => esc_html__('Right', 'bricksforge'),
            'required'    => ['icon', '!=', ''],
        ];

        $this->controls['iconGap'] = [
            'label'    => esc_html__('Gap', 'bricksforge'),
            'type'     => 'number',
            'units'    => true,
            'css'      => [
                [
                    'property' => 'gap',
                ],
            ],
            'required' => ['icon', '!=', ''],
        ];

        $this->controls['iconSpace'] = [
            'label'    => esc_html__('Space between', 'bricksforge'),
            'type'     => 'checkbox',
            'css'      => [
                [
                    'property' => 'justify-content',
                    'value'    => 'space-between',
                ],
            ],
            'required' => ['icon', '!=', ''],
        ];
    }

    public function render()
    {
        $settings = $this->settings;

        $this->set_attribute('_root', 'class', 'bricks-button');

        $connection = isset($settings['connection']) ? $settings['connection'] : false;
        $loadingText = isset($settings['loadingText']) ? $settings['loadingText'] : false;
        if (! empty($connection)) {
            $this->set_attribute('_root', 'data-connection', $connection);
        }

        if (! empty($loadingText)) {
            $this->set_attribute('_root', 'data-loading-text', $loadingText);
        }

        if (! empty($settings['size'])) {
            $this->set_attribute('_root', 'class', $settings['size']);
        }

        // Outline
        if (isset($settings['outline'])) {
            $this->set_attribute('_root', 'class', 'outline');
        }

        if (! empty($settings['style'])) {
            // Outline (border)
            if (isset($settings['outline'])) {
                $this->set_attribute('_root', 'class', "bricks-color-{$settings['style']}");
            }

            // Background (= default)
            else {
                $this->set_attribute('_root', 'class', "bricks-background-{$settings['style']}");
            }
        }

        // Button circle
        if (isset($settings['circle'])) {
            $this->set_attribute('_root', 'class', 'circle');
        }

        if (isset($settings['block'])) {
            $this->set_attribute('_root', 'class', 'block');
        }

        // Link
        if (! empty($settings['link'])) {
            $this->tag = 'a';

            $this->set_link_attributes('_root', $settings['link']);
        }

        $output = "<{$this->tag} {$this->render_attributes('_root')}>";

        $icon          = ! empty($settings['icon']) ? self::render_icon($settings['icon']) : false;
        $icon_position = ! empty($settings['iconPosition']) ? $settings['iconPosition'] : 'right';

        if ($icon && $icon_position === 'left') {
            $output .= $icon;
        }

        if (isset($settings['text'])) {
            $output .= trim($settings['text']);
        }

        if ($icon && $icon_position === 'right') {
            $output .= $icon;
        }

        $output .= "</{$this->tag}>";

        echo $output;
    }

    public function convert_element_settings_to_block($settings)
    {
        $text = isset($settings['text']) ? trim($settings['text']) : false;

        if (! $text) {
            return;
        }

        $text = str_replace('draggable="false"', '', $text);
        $text = str_replace('draggable="true"', '', $text);

        $block = ['blockName' => 'core/buttons'];

        $attributes = [];

        $html = '<div class="wp-block-buttons"><!-- wp:button -->';

        if (isset($settings['outline'])) {
            $attributes['className'] = 'is-style-outline';
            $html                   .= '<div class="wp-block-button is-style-outline">';
        } else {
            $html .= '<div class="wp-block-button"><a class="wp-block-button__link">';
        }

        if (isset($settings['_border']['radius']['top'])) {
            $attributes['borderRadius'] = intval($settings['_border']['radius']['top']);
        }

        $html .= $text . '</a></div><!-- /wp:button --></div>';

        $block['attrs']        = $attributes;
        $block['innerContent'] = [$html];

        return $block;
    }

    public function convert_block_to_element_settings($block, $attributes)
    {
        $text = strip_tags($block['innerHTML']);

        $element_settings = [
            'text'  => $text,
            'style' => 'dark',
        ];

        $border_radius = isset($attributes['borderRadius']) ? intval($attributes['borderRadius']) : false;

        // Outline
        if (isset($attributes['className']) && strpos($attributes['className'], 'is-style-outline') !== false) {
            $element_settings['outline'] = true;
        }

        if ($border_radius) {
            $element_settings['_border'] = [
                'radius' => [
                    'top'    => $border_radius,
                    'right'  => $border_radius,
                    'bottom' => $border_radius,
                    'left'   => $border_radius,
                ],
            ];
        }

        return $element_settings;
    }
}
