<?php

namespace Bricks;

if (!defined('ABSPATH'))
    exit;

class Brf_Pro_Forms_HCaptcha extends \Bricks\Element
{

    public $category = 'bricksforge forms';
    public $name = 'brf-pro-forms-field-hcaptcha';
    public $icon = 'fa-solid fa-shield-halved';
    public $css_selector = '';
    public $scripts = [];
    public $nestable = true;
    private $hcaptcha_key;
    private $hcaptcha_secret;

    public function get_label()
    {
        return esc_html__("hCaptcha", 'bricksforge');
    }

    public function enqueue_scripts()
    {
        wp_enqueue_script('bricksforge-elements');
        wp_enqueue_script('bricksforge-hcaptcha');
    }

    public function set_control_groups()
    {
        $this->control_groups['general'] = [
            'title'    => esc_html__('General', 'bricksforge'),
            'tab'      => 'content',
        ];
    }

    public function set_controls()
    {
        if ($this->check_for_hcaptcha_keys()[0] === true) {
            $this->controls['enableHCaptcha'] = [
                'tab'      => 'content',
                'group'    => 'general',
                'label'    => esc_html__('Enable hCaptcha', 'bricks'),
                'type'     => 'checkbox',
                'default'  => true
            ];

            $this->controls['hCaptchaTheme'] = [
                'tab'      => 'content',
                'group'    => 'general',
                'label'    => esc_html__('Theme', 'bricks'),
                'type'     => 'select',
                'options'  => [
                    'light' => esc_html__('Light', 'bricks'),
                    'dark'  => esc_html__('Dark', 'bricks'),
                ],
                'default'  => 'light',
                'required' => ['enableHCaptcha', '=', true],
            ];

            $this->controls['hCaptchaInfoMessage'] = [
                'tab'      => 'content',
                'group'    => 'general',
                'label'    => esc_html__('Info Message', 'bricks'),
                'type'     => 'text',
                'required' => ['enableHCaptcha', '=', true],
                'description' => esc_html__('Optional info message displayed below the hCaptcha.', 'bricks'),
            ];
        } else {
            $this->controls['hcaptchaInfo'] = [
                'tab'      => 'content',
                'content'  => '<a href="https://www.hcaptcha.com/" target="_blank">hCaptcha</a> ' . esc_html__('API key required! Add key in dashboard under: ', 'bricks') . 'Bricksforge -> Elements -> Pro Forms',
                'type'     => 'info',
            ];
        }
    }

    public function check_for_hcaptcha_keys()
    {
        $hcaptcha_settings = array_values(array_filter(get_option('brf_activated_elements'), function ($tool) {
            return $tool->id == 5;
        }));

        if (count($hcaptcha_settings) === 0) {
            return [false];
        }

        $hcaptcha_settings = $hcaptcha_settings[0];

        if (!isset($hcaptcha_settings->settings->useHCaptcha) || $hcaptcha_settings->settings->useHCaptcha !== true) {
            return [false];
        }

        if (empty($hcaptcha_settings->settings->hCaptchaKey) || empty($hcaptcha_settings->settings->hCaptchaSecret)) {
            return [false];
        }

        $utils = new \Bricksforge\Api\Utils();

        $decrypted_hcaptcha_key = $utils->decrypt($hcaptcha_settings->settings->hCaptchaKey);
        $decrypted_hcaptcha_secret = $utils->decrypt($hcaptcha_settings->settings->hCaptchaSecret);

        $this->hcaptcha_key = $decrypted_hcaptcha_key;
        $this->hcaptcha_secret = $decrypted_hcaptcha_secret;

        return [true, $decrypted_hcaptcha_key, $decrypted_hcaptcha_secret];
    }

    public function render()
    {
        $settings = $this->settings;

        // Only render if element is enabled and we have API keys
        if (!isset($settings['enableHCaptcha']) || !$settings['enableHCaptcha'] || $this->check_for_hcaptcha_keys()[0] !== true) {
            return;
        }

        /**
         * Wrapper
         */
        $this->set_attribute('_root', 'class', 'brf-hcaptcha-wrapper form-group');

        $output = '<div ' . $this->render_attributes('_root') . '>';

        $hcaptcha_theme = isset($settings['hCaptchaTheme']) && $settings['hCaptchaTheme'] === 'dark' ? 'dark' : 'light';

        $output .= '<div class="h-captcha" 
                        data-sitekey="' . $this->hcaptcha_key . '"
                        data-theme="' . $hcaptcha_theme . '"';

        if (isset($settings['hCaptchaInfoMessage']) && !empty($settings['hCaptchaInfoMessage'])) {
            $output .= ' data-info="' . esc_attr($settings['hCaptchaInfoMessage']) . '"';
        }

        $output .= '></div>';
        $output .= '</div>';

        echo $output;
    }
}
