<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Arrowbutton extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'arrowbutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['arrowbutton'];

  public function get_label() {
    return esc_html__( 'Arrow Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Arrow Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];
    $this->controls['buttonStyleSeparator'] = [
      'label'      => esc_html__( 'Button Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['buttonPadding'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Padding', 'bricks' ),
      'type' => 'spacing',
      'css'     => [
        [
          'property' => 'padding',
          'selector' => '',
        ],
      ],
    ];
    $this->controls['buttonBackground'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type' => 'background',
      'css'     => [
        [
          'property' => 'background',
          'selector' => '',
        ],
      ],
    ];
    $this->controls['buttonBorder'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Border', 'bricks' ),
      'type' => 'border',
      'css'     => [
        [
          'property' => 'border',
          'selector' => '',
        ],
      ],
    ];
    $this->controls['buttonGap'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Gap', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'inline'      => true,
      'css'     => [
        [
          'property' => 'gap',
          'selector' => '',
        ],
      ],
      'placeholder' => '',
    ];
    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Label Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['whitespace'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'White space', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'wrap' => 'wrap',
          'nowrap' => 'nowrap',
      ],
      'inline'      => true,
      'css'     => [
          [
            'property' => 'white-space',
            'selector' => '',
          ],
        ],
      'placeholder'        => 'wrap',
  ];
  $this->controls['paddingaux'] = [
    'tab'         => 'content',
    'label'       => esc_html__( 'Padding', 'bricks' ),
    'type'        => 'spacing',
    'css'     => [
        [
          'property' => 'padding',
          'selector' => '&{pseudo} .bc-arrow-button_title-wrapper',
        ],
      ],
      'placeholder' => [
        'top' => 10,
        'right' => 13,
        'bottom' => 16,
        'left' => 13,
      ],
  ];
  $this->controls['typography'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Typography', 'bricks' ),
      'type'        => 'typography',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'typography',
            'selector' => '&{pseudo} .bc-arrow-button_title-wrapper',
          ],
        ],
  ];
    $this->controls['background'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-arrow-button_title-wrapper',
            ],
          ],
    ];
    $this->controls['border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '&{pseudo} .bc-arrow-button_title-wrapper',
            ],
          ],
    ];
    $this->controls['swaptitleseparator'] = [
      'label'      => esc_html__( 'Swap Title', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['swaptitleenable'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Enable', 'bricks' ),
      'type'     => 'checkbox',
    ];
    $this->controls['swaptitlecontent'] = [
      'tab'            => 'content',
      'type'           => 'text',
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
      'required' => [ 'swaptitleenable', '=', true],
    ];
    $this->controls['transitiondurationswap'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--transitiondurationswap',
            'selector' => '',
          ],
      ],
      'placeholder'        => '0.5s',
      'required' => [ 'swaptitleenable', '=', true],
    ];
    $this->controls['transitioneaseswap'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'CSS Easing', 'bricks' ),
      'type'        => 'text',
      'css'     => [
          [
            'property' => '--easeswap',
            'selector' => '',
          ],
      ],
      'placeholder'        => 'cubic-bezier(0.1, 0, 0.3, 1)',
      'required' => [ 'swaptitleenable', '=', true],
    ];

    $this->controls['arrowseparator'] = [
      'label'      => esc_html__( 'Arrow Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['padding'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Padding', 'bricks' ),
      'type'        => 'spacing',
      'css'     => [
          [
            'property' => 'padding',
            'selector' => '&{pseudo} .bc-arrow-button__circle',
          ],
        ],
        'placeholder' => [
          'top' => 25,
          'right' => 25,
          'bottom' => 25,
          'left' => 25,
        ],
    ];
    $this->controls['arrowcolor'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Color', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--fill',
              'selector' => '&{pseudo} .bc-arrow-button__arrow',
            ],
        ],
    ];
    $this->controls['arrowbackground'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-arrow-button__circle',
            ],
          ],
    ];
    $this->controls['arrowborder'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '&{pseudo} .bc-arrow-button__circle',
            ],
        ],
    ];
    
    $this->controls['arrowSeparator'] = [
      'label'      => esc_html__( 'Arrow', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['arrowtype'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'type1' => 'Arrow 1',
          'type2' => 'Arrow 2',
          'type3' => 'Angle',
          'type4' => 'Angles',
          'type5' => 'Fancy',
      ],
      'inline' => true,
      'placeholder' => 'Arrow 1',
      'default' => 'type1',
  ];
    $this->controls['arrowposition'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Position', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'row-reverse' => 'Right',
            'row' => 'Left',
        ],
        'inline'      => true,
        'css'     => [
            [
              'property' => 'flex-direction',
              'selector' => '',
            ],
          ],
        'placeholder' => 'Right',
        'default' => 'row-reverse',
    ];
    $this->controls['arrowweight'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Weight', 'bricks' ),
        'type' => 'number',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'stroke-width',
              'selector' => '&{pseudo} .bc-arrow-button__arrow',
            ],
        ],
        'placeholder'        => '0.1',
    ];
    $this->controls['arrowrotation'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Rotation', 'bricks' ),
        'type' => 'number',
        'unit' => 'deg',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'rotate',
              'selector' => '&{pseudo} .bc-arrow-button__arrow',
            ],
        ],
        'placeholder'        => '-45deg',
    ];
    $this->controls['arrowdimensions'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Dimensions', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--dimensions',
              'selector' => '',
            ],
        ],
        'placeholder'        => '23px',
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['arrowdistance'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Distance between arrows', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => '--arrow-distance',
            'selector' => '',
          ],
      ],
      'placeholder'        => '300%',
    ];
    $this->controls['arrowscale'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Arrow scale', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'small'      => true,
        'css'     => [
            [
              'property' => '--scale',
              'selector' => '',
            ],
        ],
        'placeholder'        => '1.25',
    ];
    $this->controls['transitionduration'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--transitionduration',
            'selector' => '',
          ],
      ],
      'placeholder'        => '0.5s',
    ];
    $this->controls['transitionease'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'CSS Easing', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--ease',
            'selector' => '',
          ],
      ],
      'placeholder'        => 'cubic-bezier(0.1, 0, 0.3, 1)',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'arrowbutton', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_arrow_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $arrowtype = ! empty( $settings['arrowtype'] ) ? $settings['arrowtype'] : 'type1';
    $swaptitleenable = ! empty( $settings['swaptitleenable'] ) ? $settings['swaptitleenable'] : false;
    $swaptitlecontent = ! empty( $settings['swaptitlecontent'] ) ? $settings['swaptitlecontent'] : 'Arrow Button';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    /*Enable Swap Title*/
    if($swaptitleenable == 1){
      $swapDataAttribute = 'data-swap="enable"';
      $swapContentAttribute = "data-content=\"$swaptitlecontent\"";
    }else{
      $swapDataAttribute = 'data-swap="disable"';
      $swapContentAttribute = '';
    }

    /*Arrow Icons*/
    if($arrowtype == 'type1'){
      $arrow = 
      "<svg class='bc-arrow-button__arrow bc-arrow-button__arrow-left' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25'>
        <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
      </svg>
      <svg class='bc-arrow-button__arrow bc-arrow-button__arrow-right' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25'>
        <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
      </svg>";
    }
    if($arrowtype == 'type2'){
      $arrow = 
      "<svg class='bc-arrow-button__arrow bc-arrow-button__arrow-left' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'>
        <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
      </svg>
      <svg class='bc-arrow-button__arrow bc-arrow-button__arrow-right' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'>
        <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
      </svg>";
    }
    if($arrowtype == 'type3'){
      $arrow = 
      "<svg class='bc-arrow-button__arrow bc-arrow-button__arrow-left' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512'>
        <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
      </svg>
      <svg class='bc-arrow-button__arrow bc-arrow-button__arrow-right' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512'>
        <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
      </svg>";
    }
    if($arrowtype == 'type4'){
      $arrow = 
      "<svg class='bc-arrow-button__arrow bc-arrow-button__arrow-left' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'>
        <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
      </svg>
      <svg class='bc-arrow-button__arrow bc-arrow-button__arrow-right' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'>
        <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
      </svg>";
    }
    if($arrowtype == 'type5'){
      $arrow = 
      "<svg class='bc-arrow-button__arrow bc-arrow-button__arrow-left' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important'>
        <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
        <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
        <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
      </svg>
      <svg class='bc-arrow-button__arrow bc-arrow-button__arrow-right' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important'>
        <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
        <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
        <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
      </svg>";
    }

    $this->set_attribute( '_root', 'class', 'bc-arrow-button' );

    $output = "<$root_tag {$this->render_attributes( '_root' )} $swapDataAttribute>
    <div class='bc-arrow-button__circle'>
        $arrow
    </div>
    <div class='bc-arrow-button_title-wrapper'>
      <div class='bc-arrow-button_title-wrap'>
        <div class='bc-arrow-button__title' $swapContentAttribute>$inner_title</div>
      </div>
    </div>
    ";

    $output .= "</$root_tag>";

	echo $output;
  }
}



