<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Blended_Title extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'blended-title';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
  public $scripts      = ['blended_title'];

  public function get_label() {
    return esc_html__( 'Blended Hover', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
	    'hasDynamicData' => 'text',
      'default'        => esc_html__( 'Blended Hover', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
            'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-blended-title__inner-wrapper',
        ],
      ],
  ];
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0.5s',
    ];
    $this->controls['easing'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps'
        ],
        'inline' => true,
        'placeholder' => 'power2',
    ];

    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '.char',
        ],
      ],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_blended_title', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_blended_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : 0.5;
    $easing    = ! empty( $settings['easing'] ) ? $settings['easing'] : 'power2';
    
    $this->set_attribute( '_root', 'class', 'bc-blended-title' );
    $this->set_attribute( '_root', 'bc-blended-title-hide', '' );

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}
      data-duration=\"$duration\"
      data-easing=\"$easing\">
        <a class='bc-blended-title__anchor' {$this->render_attributes( '_link' )}>
          <span class='bc-blended-title__inner-wrapper'>
            <span class='bc-blended-title__title bc-blended-title__title--front'>$inner_title</span>
            <span class='bc-blended-title__title bc-blended-title__title--back'>$inner_title</span>
          </span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}
      data-duration=\"$duration\"
      data-easing=\"$easing\">
        <span class='bc-blended-title__inner-wrapper'>
          <span class='bc-blended-title__title bc-blended-title__title--front'>$inner_title</span>
          <span class='bc-blended-title__title bc-blended-title__title--back'>$inner_title</span>
        </span>
      </{$this->tag}>
      ";
    }

	echo $output;
  }
}