<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Bubbles extends \Bricks\Element {
    public $category     = 'Next Bricks - Backgrounds';
    public $name         = 'bubbles';
    public $icon         = 'fa-solid fa-soap';
    public $tag      = 'div';
    public $scripts      = ['bubbles'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Bubbles', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'article' => 'article',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'main' => 'main',
                'nav' => 'nav',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['note1'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Stop Bubbles animation at the builder for a better performance when editing.', 'bricks' )))
        ];
        $this->controls['builderedit'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Stop animation at the builder', 'bricks' ),
            'type'     => 'checkbox',
        ];
        $this->controls['separator'] = [
            'label'      => esc_html__( 'Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => 'width',
                  'selector' => '',
              ],
            ],
            'placeholder' => '100%',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => 'height',
                  'selector' => '',
              ],
            ],
            'placeholder' => '100vh',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'inline' => true,
            'css'     => [
              [
                  'property' => 'background',
                  'selector' => '',
              ],
            ],
        ];

        $this->controls['bubblesblurseparator'] = [
            'label'      => esc_html__( 'Bubbles blur', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [ 
            'tab' => 'content',
            'description' => sprintf(esc_html__( 'Blur must be set here. The rest of Bubble settings can be set at each Bubble.', 'bricks' ))
        ];
        $this->controls['blur'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Blur', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => '--blur',
                  'selector' => '.bc-bubbles__wrapper',
              ],
            ],
            'placeholder' => '40px',
        ];

        $this->controls['cursorseparator'] = [
            'label'      => esc_html__( 'Cursor Bubble', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['enablecursor'] = [
            'label' => esc_html__( 'Enable Cursor Bubble', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'small' => true,
            'default' => true,
        ];
        $this->controls['attachment'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Attachment', 'bricks' ),
            'type'     => 'text',
            'inline'  => true,
            'small'  => true,
            'placeholder' => '20',
            'required' => [ 'enablecursor', '=', true],
        ];
        $this->controls['dimensions'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Dimensions', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => '--dimensions',
                  'selector' => '.bc-bubbles__bubble--cursor',
              ],
            ],
            'placeholder' => '100%',
            'required' => [ 'enablecursor', '=', true],
        ];
        $this->controls['bubbleBackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css'     => [
              [
                  'property' => '--inner-background',
                  'selector' => '.bc-bubbles__bubble--cursor',
              ],
            ],
            'required' => [ 'enablecursor', '=', true],
        ];
        $this->controls['blendmode'] = [
			'tab'     => 'content',
			'label'   => 'Mix blend mode',
			'type'    => 'select',
			'inline'  => true,
			'options' => Setup::$control_options['blendMode'],
			'css'     => [
				[
					'property' => '--blending',
                    'selector' => '.bc-bubbles__bubble--cursor',
				]
			],
            'placeholder' => 'hard-light',
            'required' => [ 'enablecursor', '=', true],
		];
        $this->controls['opacity'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Opacity', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small'  => true,
			'css'     => [
				[
					'property' => 'opacity',
                    'selector' => '.bc-bubbles__bubble--cursor',
				]
			],
            'placeholder' => '0.7',
            'required' => [ 'enablecursor', '=', true],
        ];
    }

    /*Render children*/
    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'bc-bubbles__content',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Wonderful Heading', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ],
                ],
            ],

            [
                'name'     => 'bubbles_wrapper',
                'children' => [
                    [
                        'name'     => 'bubble',
                        'label'    => esc_html__( 'Bubble', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'bc-bubbles__bubble--1',
                            ],
                        ],
                    ],
        
                    [
                        'name'     => 'bubble',
                        'label'    => esc_html__( 'Bubble', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'bc-bubbles__bubble--2',
                            ],
                        ],
                    ],
        
                    [
                        'name'     => 'bubble',
                        'label'    => esc_html__( 'Bubble', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'bc-bubbles__bubble--3',
                            ],
                        ],
                    ],
        
                    [
                        'name'     => 'bubble',
                        'label'    => esc_html__( 'Bubble', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'bc-bubbles__bubble--4',
                            ],
                        ],
                    ],
        
                    [
                        'name'     => 'bubble',
                        'label'    => esc_html__( 'Bubble', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'bc-bubbles__bubble--5',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'bc-bubbles-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_bubbles.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $enablecursor = ! empty( $settings['enablecursor'] ) ? $settings['enablecursor'] : 0;
        $attachment = ! empty( $settings['attachment'] ) ? $settings['attachment'] : 20;
        $builderedit = ! empty( $settings['builderedit'] ) ? $settings['builderedit'] : 0;

        $this->set_attribute( '_root', 'class', "bc-bubbles");

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}
        data-bubble-cursor=\"$enablecursor\"
        data-attachment=\"$attachment\"
        data-builderedit=\"$builderedit\">";
            $output .= \Bricks\Frontend::render_children( $this );
        $output .= "
        <svg>
            <defs>
                <filter id='goo'>
                    <feGaussianBlur in='SourceGraphic' stdDeviation='10' result='blur' />
                    <feColorMatrix in='blur' mode='matrix' values='1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 18 -8' result='goo' />
                    <feBlend in='SourceGraphic' in2='goo' />
                </filter>
            </defs>
        </svg>
        <style>
        .bc-bubbles .bc-bubbles__wrapper{
            -moz-filter: url(#goo) blur(var(--blur));
            -webkit-filter: url(#goo) blur(var(--blur));
            filter: url(#goo) blur(var(--blur));
        }
        </style>
        </{$this->tag}>";

        echo $output;
    }
}