<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Circular_Title extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'circular-title';
  public $icon         = 'ti-text';
  public $tag      = 'span';
  public $css_selector = '';
  public $scripts      = ['next_arc_title'];

  public function get_label() {
    return esc_html__( 'Arc Title', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'textarea',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'circular·title·circular·title·circular·title·', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'h1' => 'h1',
          'h2' => 'h2',
          'h3' => 'h3',
          'h4' => 'h4',
          'h5' => 'h5',
          'h6' => 'h6',
          'p' => 'p',
          'span' => 'span',
          'custom' => 'custom',
      ],
      'inline'      => true,
      'placeholder' => 'span',
      'default'     => 'span',
    ];
    $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'span',
      'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['typography'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Typography', 'bricks' ),
      'type'        => 'typography',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'typography',
            'selector' => '.next-arc-title__inner',
          ],
        ],
        'default' => [
          'font-family' => 'Noto Sans Mono',
          'font-weight' => '700',
          'font-size' => '16px',
          'text-transform' => 'uppercase',
        ],
        'exclude'     => [
          [
            'line-height',
            'letter-spacing'
          ],
        ],
      ];

    $this->controls['width'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Dimensions', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => '--dimensions',
            'selector' => '',
          ],
      ],
      'placeholder'    => esc_html__( '200px', 'bricks' ),
    ];
    $this->controls['spacing'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Letter spacing', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline'      => true,
      'placeholder'    => esc_html__( '1', 'bricks' ),
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];

    $this->controls['reverse'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Reverse', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
      'rerender' => true,
    ];

    $this->controls['animationduration'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Rotate duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline'      => true,
      'css'     => [
        [
          'property' => '--duration',
          'selector' => '',
        ],
      ],
      'placeholder'    => esc_html__( '9s', 'bricks' ),
      'required' => [ 'scroll', '!=', true],
    ];
    $this->controls['easing'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Easing', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'css'     => [
        [
          'property' => '--easing',
          'selector' => '',
        ],
      ],
      'placeholder'    => esc_html__( 'linear', 'bricks' ),
      'required' => [ 'scroll', '!=', true],
    ];

    $this->controls['scroll'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Attach to scroll', 'bricks' ),
      'type'     => 'checkbox',
    ];
    $this->controls['scrollstart'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Start', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder'    => esc_html__( 'top bottom', 'bricks' ),
      'required' => [ 'scroll', '=', true],
    ];
    $this->controls['scrollend'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'End', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder'    => esc_html__( 'none', 'bricks' ),
      'required' => [ 'scroll', '=', true],
    ];
    $this->controls['scrub'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Scrub', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder'    => esc_html__( 'true', 'bricks' ),
      'required' => [ 'scroll', '=', true],
    ];
    $this->controls['scrollrotation'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Rotation', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder'    => esc_html__( '180', 'bricks' ),
      'required' => [ 'scroll', '=', true],
    ];
    $this->controls['scrolleasing'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps'
        ],
        'inline' => true,
        'placeholder' => 'none',
      'required' => [ 'scroll', '=', true],
    ];

    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '.next-arc-title__inner',
        ],
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'circular_title', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_circular_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Arc Title · Next Bricks · ';
    $spacing = ! empty( $settings['spacing'] ) ? $settings['spacing'] : '1';
    $reverse = ! empty( $settings['reverse'] ) ? $settings['reverse'] : '0';

    $scroll = ! empty( $settings['scroll'] ) ? $settings['scroll'] : false;
    $scrollstart = ! empty( $settings['scrollstart'] ) ? $settings['scrollstart'] : 'top bottom';
    $scrollend = ! empty( $settings['scrollend'] ) ? $settings['scrollend'] : 'none';
    $scrub = ! empty( $settings['scrub'] ) ? $settings['scrub'] : 'true';
    $scrollrotation = ! empty( $settings['scrollrotation'] ) ? $settings['scrollrotation'] : '180';
    $scrolleasing = ! empty( $settings['scrolleasing'] ) ? $settings['scrolleasing'] : 'none';

    $this->set_attribute( '_root', 'class', 'next-arc-title' );
    
    $scrollAttrs = '';
    if($scroll){
      $scrollAttrs = "data-scroll='true' data-scroll-start='{$scrollstart}' data-scroll-end='{$scrollend}' data-scrub='{$scrub}' data-scroll-rotation='{$scrollrotation}' data-scroll-easing='{$scrolleasing}'";
    }
    
    $reverseAttr = ($reverse == '1') ? "data-reverse='1'" : '';
    
    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = 'div';
    }
  
    $output = "<$root_tag {$this->render_attributes( '_root' )} data-spacing='{$spacing}' {$scrollAttrs} {$reverseAttr}>";
    $output .=
    "<{$this->tag} class='next-arc-title__inner' data-content='{$inner_title}'>$inner_title</{$this->tag}>";
    $output .= "</$root_tag>";

    echo $output;
  }
}