<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Copytoclipboard extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'clickandcopy';
  public $icon         = 'fa-regular fa-copy';
  public $scripts      = ['clickandcopy'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Click and Copy', 'bricks' );
  }

  public function set_controls() {
    $this->controls['copytype'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Copy type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'element' => 'Element text',
          'text' => 'Custom text',
      ],
      'clearable' => false,
      'inline'      => true,
      'placeholder' => 'Element text',
      'default' => 'element',
    ];
    $this->controls['TextElement'] = [
      'hasDynamicData' => true,
      'tab' => 'content',
      'label' => esc_html__( 'Content element', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'className',
      'required' => [ 'copytype', '!=', 'text'],
    ];
    $this->controls['customtext'] = [
      'hasDynamicData' => true,
      'tab' => 'content',
      'label' => esc_html__( 'Custom text', 'bricks' ),
      'type' => 'textarea',
      'placeholder' => 'Lorem ipsum dolor sit amet',
      'required' => [ 'copytype', '!=', 'element'],
    ];
    $this->controls['selection'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Apply select on copy', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
      'required' => [ 'copytype', '!=', 'text'],
    ];

    $this->controls['elementstyle'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['elementpadding'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Padding', 'bricks' ),
      'type'        => 'spacing',
      'css'     => [
          [
            'property' => 'padding',
            'selector' => '',
          ],
        ],
    ];
    $this->controls['elementbackground'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'background',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'background',
            'selector' => '',
          ],
        ],
    ];
    $this->controls['elementborder'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Border', 'bricks' ),
      'type'        => 'border',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'border',
            'selector' => '',
          ],
        ],
    ];
    $this->controls['elementboxShadow'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Box shadow', 'bricks' ),
      'type'  => 'box-shadow',
      'inline' => true,
      'css'     => [
        [
            'property' => 'box-shadow',
            'selector' => '',
        ],
      ],
  ];
    $this->controls['enableicon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Copy icon', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'enable' => 'Enable',
          'disable' => 'Disable',
      ],
      'inline' => true,
      'small' => true,
      'placeholder' => 'Enable',
      'default' => 'enable',
    ];

    $this->controls['iconstyle'] = [
      'label'      => esc_html__( 'Icon Style', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'enableicon', '=', 'enable'],
    ];

    $this->controls['IconShow'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'default' => [
        'library' => 'ionicons',
        'icon' => 'ion-md-clipboard',
      ],
      'css' => [
        [
          'selector' => '.bc-click-and-copy__icon',
        ],
      ],
      'required' => [ 'enableicon', '=', 'enable'],
    ];
    $this->controls['IconHidden'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Copied Icon', 'bricks' ),
      'type' => 'icon',
      'default' => [
        'library' => 'ionicons',
        'icon' => 'ion-md-checkmark', 
      ],
      'css' => [
        [
          'selector' => '.bc-click-and-copy__icon--hidden',
        ],
      ],
      'required' => [ 'enableicon', '=', 'enable'],
    ];
    $this->controls['iconsize'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Icon Size', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--icon-size',
            'selector' => '.bc-click-and-copy__icon',
          ],
        ],
      'placeholder' => 'auto',
      'required' => [ 'enableicon', '=', 'enable'],
    ];
    $this->controls['padding'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Padding', 'bricks' ),
      'type'        => 'spacing',
      'css'     => [
          [
            'property' => 'padding',
            'selector' => '.bc-click-and-copy__icon',
          ],
        ],
        'required' => [ 'enableicon', '=', 'enable'],
    ];
    $this->controls['color'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Color', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'color',
            'selector' => '.bc-click-and-copy__icon',
          ],
        ],
        'required' => [ 'enableicon', '=', 'enable'],
    ];

    $this->controls['background'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'background',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'background',
            'selector' => '.bc-click-and-copy__icon',
          ],
        ],
        'required' => [ 'enableicon', '=', 'enable'],
    ];

    $this->controls['border'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Border', 'bricks' ),
      'type'        => 'border',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'border',
            'selector' => '.bc-click-and-copy__icon',
          ],
        ],
        'required' => [ 'enableicon', '=', 'enable'],
    ];

    /*Tooltip*/
    $this->controls['tooltipSeparator'] = [
      'label'      => esc_html__( 'Tooltip', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['animation'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Enable Tooltip', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];

    $this->controls['arrow'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Arrow', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
      'required' => [ 'animation', '=', true],
    ];

    $this->controls['inertia'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Inertia', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
      'required' => [ 'animation', '=', true],
    ];

    $this->controls['tippyanimation'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Animation Type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'scale' => 'scale',
          'shift-away' => 'shift-away',
          'shift-toward' => 'shift-toward',
          'perspective' => 'perspective',
          'fade' => 'fade',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'scale',
      'required' => [ 'animation', '=', true],
    ];
    $this->controls['tippyplacement'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Tooltip Placement', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'auto' => 'auto',
          'top' => 'top',
          'left' => 'left',
          'bottom' => 'bottom',
          'right' => 'right',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'auto',
      'required' => [ 'animation', '=', true],
    ];

    $this->controls['touch'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Touch', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
      'required' => [ 'animation', '=', true],
    ];
    
    $this->controls['copycontent'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Tooltip copy state', 'bricks' ),
      'type' => 'textarea',
      'placeholder' => 'Copy',
      'required' => [ 'animation', '=', true],
    ];

    $this->controls['copiedcontent'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Tooltip copied state', 'bricks' ),
      'type' => 'textarea',
      'placeholder' => 'Copied!',
      'required' => [ 'animation', '=', true],
    ];

    $this->controls['tooltipstyle'] = [
      'label'      => esc_html__( 'Tooltip Style', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'animation', '=', true],
    ];

    $this->controls['tippybackground'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'color',
      'required' => [ 'animation', '=', true],
    ];
    $this->controls['tippyarrowcolor'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Arrow Color', 'bricks' ),
      'type'        => 'color',
      'required' => [ 'animation', '=', true],
    ];
    $this->controls['tippytypography'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Typography', 'bricks' ),
      'type'        => 'typography',
      'inline'      => true,

      'exclude' => [
        'font-style',
        'text-decoration',
        'text-align',
        'text-transform',
        'line-height',
        'letter-spacing',
        'text-shadow',
      ],
      'required' => [ 'animation', '=', true],
    ];
    $this->controls['tippyborder'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Border', 'bricks' ),
      'type'        => 'border',
      'inline'      => true,
      'required' => [ 'animation', '=', true],
    ];
    $this->controls['tippypadding'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Padding', 'bricks' ),
      'type'        => 'spacing',
      'required' => [ 'animation', '=', true],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'clickandcopy', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_clickandcopy.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'popper-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_popper.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'tippy-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_tippy.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_style( 'tippy-scale-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_scale.min.css', array(), NEXTBRICKS_VERSION, false);
    wp_enqueue_style( 'tippy-shift-away-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_shiftaway.min.css', array(), NEXTBRICKS_VERSION, false);
    wp_enqueue_style( 'tippy-shift-toward-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_shifttoward.min.css', array(), NEXTBRICKS_VERSION, false);
    wp_enqueue_style( 'tippy-perspective-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_perspective.min.css', array(), NEXTBRICKS_VERSION, false);
  }
    
  public function render() {
    $settings = $this->settings;
    $copytype = ! empty( $settings['copytype'] ) ? $settings['copytype'] : 'element';
    $customtext = ! empty( $settings['customtext'] ) ? $settings['customtext'] : 'Lorem ipsum dolor sit amet';
    $enableicon = ! empty( $settings['enableicon'] ) ? $settings['enableicon'] : 'enable';

    $textelement = ! empty( $settings['TextElement'] ) ? $settings['TextElement'] : 'bc-click-and-copy__text-to-copy';
    $selection = ! empty( $settings['selection'] ) ? $settings['selection'] : false;
    $animation = ! empty( $settings['animation'] ) ? $settings['animation'] : false;
    $arrow = ! empty( $settings['arrow'] ) ? $settings['arrow'] : false;
    $inertia = ! empty( $settings['inertia'] ) ? $settings['inertia'] : false;
    $tippyanimation = ! empty( $settings['tippyanimation'] ) ? $settings['tippyanimation'] : 'scale';
    $tippyplacement = ! empty( $settings['tippyplacement'] ) ? $settings['tippyplacement'] : 'auto';
    $touch = ! empty( $settings['touch'] ) ? $settings['touch'] : false;
    $copycontent = ! empty( $settings['copycontent'] ) ? $settings['copycontent'] : 'Copy';
    $copiedcontent = ! empty( $settings['copiedcontent'] ) ? $settings['copiedcontent'] : 'Copied!';

    if ( ! empty( $settings['IconShow'] ) ) {
      $iconshow = self::render_icon( $settings['IconShow'], [ 'bc-click-and-copy__icon' ] );
    }
    if ( ! empty( $settings['IconHidden'] ) ) {
      $iconauxhidden = self::render_icon( $settings['IconHidden'], [ 'bc-click-and-copy__icon bc-click-and-copy__icon--hidden' ] );
    }


    $tippytypography = !empty($settings['tippytypography']) && is_array($settings['tippytypography']) ? $settings['tippytypography'] : array();
    if ( ! empty( $tippytypography['font-family'] ) ) {
      $this->set_attribute( '_root', 'data-font-family', $tippytypography['font-family']);
    }  

    if (isset($tippytypography['color']['rgb'])) {
      $this->set_attribute( '_root', 'data-font-color', $tippytypography['color']['rgb']);
    }else if(isset($tippytypography['color']['raw'])){
      $this->set_attribute( '_root', 'data-font-color', $tippytypography['color']['raw']);
    }else if(isset($tippytypography['color']['hex'])){
      $this->set_attribute( '_root', 'data-font-color', $tippytypography['color']['hex']);
    }

    if ( ! empty( $tippytypography['font-weight'] ) ) {
      $this->set_attribute( '_root', 'data-font-weight', $tippytypography['font-weight']);
    }  
    if ( ! empty( $tippytypography['font-size'] ) ) {
      $this->set_attribute( '_root', 'data-font-size', $tippytypography['font-size']);
    }  

    $tippyborder = !empty($settings['tippyborder']) && is_array($settings['tippyborder']) ? $settings['tippyborder'] : array();
    if ( ! empty( $tippyborder['width']['top'] ) ) {
      $this->set_attribute( '_root', 'data-border-width-top', $tippyborder['width']['top']);
    }
    if ( ! empty( $tippyborder['width']['left'] ) ) {
      $this->set_attribute( '_root', 'data-border-width-left', $tippyborder['width']['left']);
    }
    if ( ! empty( $tippyborder['width']['bottom'] ) ) {
      $this->set_attribute( '_root', 'data-border-width-bottom', $tippyborder['width']['bottom']);
    }
    if ( ! empty( $tippyborder['width']['right'] ) ) {
      $this->set_attribute( '_root', 'data-border-width-right', $tippyborder['width']['right']);
    }
    if ( ! empty( $tippyborder['style'] ) ) {
      $this->set_attribute( '_root', 'data-border-style', $tippyborder['style']);
    }

    if (isset($tippyborder['color']['rgb'])) {
      $this->set_attribute( '_root', 'data-border-color', $tippyborder['color']['rgb']);
    }else if(isset($tippyborder['color']['raw'])){
      $this->set_attribute( '_root', 'data-border-color', $tippyborder['color']['raw']);
    }else if(isset($tippyborder['color']['hex'])){
      $this->set_attribute( '_root', 'data-border-color', $tippyborder['color']['hex']);
    }

    if ( ! empty( $tippyborder['radius']['top'] ) ) {
      $this->set_attribute( '_root', 'data-border-radius-top', $tippyborder['radius']['top']);
    }
    if ( ! empty( $tippyborder['radius']['left'] ) ) {
      $this->set_attribute( '_root', 'data-border-radius-left', $tippyborder['radius']['left']);
    }
    if ( ! empty( $tippyborder['radius']['bottom'] ) ) {
      $this->set_attribute( '_root', 'data-border-radius-bottom', $tippyborder['radius']['bottom']);
    }
    if ( ! empty( $tippyborder['radius']['right'] ) ) {
      $this->set_attribute( '_root', 'data-border-radius-right', $tippyborder['radius']['right']);
    }

    $tippypadding = !empty($settings['tippypadding']) && is_array($settings['tippypadding']) ? $settings['tippypadding'] : array();
    if ( ! empty( $tippypadding['top'] ) ) {
      $this->set_attribute( '_root', 'data-padding-top', $tippypadding['top']);
    }
    if ( ! empty( $tippypadding['left'] ) ) {
      $this->set_attribute( '_root', 'data-padding-left', $tippypadding['left']);
    }
    if ( ! empty( $tippypadding['bottom'] ) ) {
      $this->set_attribute( '_root', 'data-padding-bottom', $tippypadding['bottom']);
    }
    if ( ! empty( $tippypadding['right'] ) ) {
      $this->set_attribute( '_root', 'data-padding-right', $tippypadding['right']);
    }

    $tippybackground = !empty($settings['tippybackground']) && is_array($settings['tippybackground']) ? $settings['tippybackground'] : array();
    if (isset($tippybackground['rgb'])) {
      $this->set_attribute( '_root', 'data-background', $tippybackground['rgb']);
    }else if(isset($tippybackground['raw'])){
      $this->set_attribute( '_root', 'data-background', $tippybackground['raw']);
    }else if(isset($tippybackground['hex'])){
      $this->set_attribute( '_root', 'data-background', $tippybackground['hex']);
    }

    $tippyarrowcolor = !empty($settings['tippyarrowcolor']) && is_array($settings['tippyarrowcolor']) ? $settings['tippyarrowcolor'] : array();
    if (isset($tippyarrowcolor['rgb'])) {
      $this->set_attribute( '_root', 'data-arrow-color', $tippyarrowcolor['rgb']);
    }else if(isset($tippyarrowcolor['raw'])){
      $this->set_attribute( '_root', 'data-arrow-color', $tippyarrowcolor['raw']);
    }else if(isset($tippyarrowcolor['hex'])){
      $this->set_attribute( '_root', 'data-arrow-color', $tippyarrowcolor['hex']);
    }






    $this->set_attribute( '_root', 'class', 'bc-click-and-copy' );
    $this->set_attribute( '_root', 'data-text', $customtext );
    $this->set_attribute( '_root', 'tabindex', '0' );
    $output = "<div {$this->render_attributes( '_root' )}
    data-enableicon=\"$enableicon\"
    data-type=\"$copytype\"
    data-textelement=\"$textelement\"
    data-selection=\"$selection\"
    data-animation=\"$animation\"
    data-arrow=\"$arrow\"
    data-inertia=\"$inertia\"
    data-tippyanimation=\"$tippyanimation\"
    data-tippyplacement=\"$tippyplacement\"
    data-touch=\"$touch\"
    data-copycontent=\"$copycontent\"
    data-copiedcontent=\"$copiedcontent\">";

    if($enableicon == 'enable'){
      $output .= $iconshow;
      $output .= $iconauxhidden;
    }

    // Render children elements (= individual items)
    $output .= Frontend::render_children( $this );

    $output .= '</div>';

  echo $output;
  }
}