<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Core_Burguer extends \Bricks\Element {
  public $category     = 'Next Bricks - Menus';
  public $name         = 'coreburguer';
  public $icon         = 'ti-menu';
  public $scripts      = ['coreburguer'];

  public function get_label() {
    return esc_html__( 'Burger', 'bricks' );
  }

  public function set_controls() {
    $this->controls['type'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'generalGroupTitle' => esc_html__( 'General', 'bricks' ),
            //'style1' => 'spread',
            'style5' => 'simple',
            'style2' => 'unify',
            //'style6' => 'fade',
            'style8' => 'fade',
            'style7' => 'rotate',
            'style10' => 'rotatev2',
            'style3' => 'doble collapse',
            'style4' => 'triple collapse',
            'style9' => 'full collapse',
            'bounce' => 'bounce',

            'animatedGroupTitle' => esc_html__( 'Distorted', 'bricks' ),
            'distorsion' => 'distorsion',
            'distorsionv2' => 'distorsionv2',
            'distorsionv3' => 'distorsionv3',
            'arrow distorsion' => 'arrow distorsion',
            'arrow distorsionv2' => 'arrow distorsionv2',
            'chevron' => 'chevron',

            'arrowsGroupTitle' => esc_html__( 'Arrows', 'bricks' ),
            'arrowup' => 'arrow up',
            'arrowright' => 'arrow right',
            'arrowdown' => 'arrow down',
            'arrowleft' => 'arrow left',

            'flippingGroupTitle' => esc_html__( 'Flipped', 'bricks' ),
            'flipping' => 'flipping',
            'flippingv2' => 'flippingv2',
            'flippingv3' => 'flippingv3',
            'flippingv4' => 'flippingv4',
            'flippingv5' => 'flippingv5',
            'flippingtitle' => 'flipping title',
            'flippingarrow' => 'flipping arrow',
            'flippingarrowv2' => 'flipping arrowv2',

            'disfiguredGroupTitle' => esc_html__( 'Disfigured', 'bricks' ),
            'disfiguredbottomarrow' => 'arrow bottom',
            'disfiguredrightarrow' => 'arrow right',
            'disfiguredleftarrow' => 'arrow left',
            'disfiguredcross' => 'cross',
            'disfiguredchevron' => 'chevron',
            'disfiguredplus' => 'plus',
            'disfiguredminus' => 'minus',

            'linkGroupTitle' => esc_html__( 'Tasty Hamburgers', 'bricks' ),
            'slider' => 'slider',
            'squeeze' => 'squeeze',
            'arrow' => 'arrow',
            'arrow alt' => 'arrow alt',
            'arrow turn' => 'arrow turn',
            'spin' => 'spin',
            'elastic' => 'elastic',
            'emphatic' => 'emphatic',
            'collapse' => 'collapse',
            'vortex' => 'vortex',
            'stand' => 'stand',
            'spring' => 'spring',
            'minus' => 'minus',
            '3dx' => '3dx',
            '3dy' => '3dy',
            '3dxy' => '3dxy',
            'boring' => 'boring',
        ],
        'inline'      => true,
        'placeholder' => 'simple',
    ];
    $this->controls['reversed2'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Reverse', 'bricks' ),
        'type'     => 'checkbox',
        'required' => [ 'type', '=', 'style2'],
    ];
    $this->controls['reversed5'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Reverse', 'bricks' ),
        'type'     => 'checkbox',
        'required' => [ 'type', '=', 'style5'],
    ];
    $this->controls['reversed6'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Reverse', 'bricks' ),
        'type'     => 'checkbox',
        'required' => [ 'type', '=', 'style6'],
    ];
    $this->controls['reversed7'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Reverse', 'bricks' ),
        'type'     => 'checkbox',
        'required' => [ 'type', '=', 'style7'],
    ];
    $this->controls['reversed10'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Reverse', 'bricks' ),
        'type'     => 'checkbox',
        'required' => [ 'type', '=', 'style10'],
    ];
    $this->controls['reversedHamburger'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Reverse', 'bricks' ),
        'type'     => 'checkbox',
        'required'    => [ 'type', '=', [ 'slider', 'arrow', 'arrow alt', 'arrow turn', 'spin', 'elastic',
        'emphatic', 'collapse', 'vortex', 'stand', 'spring', '3dx', '3dy', '3dxy' ] ],
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['dimensions'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'     => [
        [
            'property' => '--burguer-dimensions',
            'selector' => '.bc-burguer-style1, .bc-burguer-style2, .bc-burguer-style3, .bc-burguer-style4, .bc-burguer-style5, 
            .bc-burguer-style6, .bc-burguer-style7, .bc-burguer-style8, .bc-burguer-style9, .bc-burguer-style10, 
            .hamburger, .next-burger-animated, .next-burger-animated--distorsionv3, .next-burger-animated--chevron, .next-burger-flipped, 
            .next-burger-disfigured, .next-burger-arrow, .next-burger-bounce',
        ],
        ],
        'placeholder' => '50px',
    ];
    $this->controls['strokecolor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'     => [
        [
            'property' => '--burguer-stroke-color',
            'selector' => '.bc-burguer-style1, .bc-burguer-style2, .bc-burguer-style3, .bc-burguer-style4, .bc-burguer-style5, 
            .bc-burguer-style6, .bc-burguer-style7, .bc-burguer-style8, .bc-burguer-style9, .bc-burguer-style10, 
            .hamburger, .next-burger-animated, .next-burger-animated--distorsionv3, .next-burger-animated--chevron, .next-burger-flipped, 
            .next-burger-disfigured, .next-burger-arrow, .next-burger-bounce',
        ],
        ],
    ];
    $this->controls['strokecolortoggle'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color when toggled', 'bricks' ),
        'type'  => 'color',
        'css'     => [
        [
            'property' => '--burguer-stroke-color',
            'selector' => '.bc-burguer-style1--opened, .bc-burguer-style2--opened, .bc-burguer-style3--opened, .bc-burguer-style4--opened, .bc-burguer-style5--opened, 
            .bc-burguer-style6--opened, .bc-burguer-style7--opened, .bc-burguer-style8--opened, .bc-burguer-style9--opened, .bc-burguer-style10--opened, 
            .hamburger--slider--opened, .hamburger--squeeze--opened, .hamburger--arrow--opened, .hamburger--arrowalt--opened, .hamburger--arrowturn--opened, 
            .hamburger--spin--opened, .hamburger--elastic--opened, .hamburger--emphatic--opened, .hamburger--collapse--opened, .hamburger--vortex--opened, 
            .hamburger--stand--opened, .hamburger--spring--opened, .hamburger--minus--opened, .hamburger--boring--opened, 
            .hamburger--3dx--opened, .hamburger--3dy--opened, .hamburger--3dxy--opened, 
            .hamburger--slider-r--opened, .hamburger--squeeze-r--opened, .hamburger--arrow-r--opened, .hamburger--arrowalt-r--opened, .hamburger--arrowturn-r--opened, 
            .hamburger--spin-r--opened, .hamburger--elastic-r--opened, .hamburger--emphatic-r--opened, .hamburger--collapse-r--opened, .hamburger--vortex-r--opened, 
            .hamburger--stand-r--opened, .hamburger--spring-r--opened, .hamburger--minus-r--opened, .hamburger--boring-r--opened, 
            .hamburger--3dx-r--opened, .hamburger--3dy-r--opened, .hamburger--3dxy-r--opened, 
            .next-burger-animated--1--opened, .next-burger-animated--2--opened, .next-burger-animated--3--opened, .next-burger-animated--4--opened, 
            .next-burger-animated--distorsionv3--opened, .next-burger-animated--chevron--opened, 
            .next-burger-flipped--flipping--opened, .next-burger-flipped--flippingv2--opened, .next-burger-flipped--flippingv3--opened, .next-burger-flipped--flippingv4--opened, 
            .next-burger-flipped--flippingv5--opened, .next-burger-flipped--flippingtitle--opened, .next-burger-flipped--flippingarrow--opened, .next-burger-flipped--flippingarrowv2--opened, 
            .next-burger-disfigured--bottom-arrow--opened, .next-burger-disfigured--right-arrow--opened, .next-burger-disfigured--left-arrow--opened, 
            .next-burger-disfigured--chevron--opened, .next-burger-disfigured--plus--opened, .next-burger-disfigured--minus--opened, 
            .next-burger-arrow--up--opened, .next-burger-arrow--down--opened, .next-burger-arrow--left--opened, .next-burger-arrow--right--opened, .next-burger-bounce--opened',
        ],
        ],
    ];
    $this->controls['strokewidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stroke Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css'     => [
        [
            'property' => '--burguer-stroke-width',
            'selector' => '.bc-burguer-style1, .bc-burguer-style2, .bc-burguer-style3, .bc-burguer-style4, .bc-burguer-style5, 
            .bc-burguer-style6, .bc-burguer-style7, .bc-burguer-style8, .bc-burguer-style9, .bc-burguer-style9',
        ],
        ],
        'required'    => [ 'type', '=', [ 'style1', 'style2', 'style3', 'style4', 'style5', 'style6', 'style7', 'style8', 'style9', 'style10' ] ],
        'placeholder' => '2px',
    ];
    $this->controls['hamburgerStrokeHeight'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Stroke height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css'     => [
        [
            'property' => '--hamburger-layer-height',
            'selector' => '.hamburger, .next-burger-animated, .next-burger-animated--distorsionv3, .next-burger-animated--chevron, .next-burger-flipped, 
            .next-burger-disfigured, .next-burger-arrow',
        ],
        ],
        'required'    => [ 'type', '=', [ 'slider', 'arrow', 'arrow alt', 'arrow turn', 'spin', 'elastic',
        'emphatic', 'collapse', 'vortex', 'stand', 'spring', '3dx', '3dy', '3dxy', 'squeeze', 'minus', 'boring',
        'distorsion', 'distorsionv2', 'distorsionv3', 'arrow distorsion', 'arrow distorsionv2', 'chevron',
        'flipping', 'flippingv2', 'flippingv3', 'flippingv4', 'flippingv5', 'flippingtitle', 'flippingarrow', 'flippingarrowv2',
        'disfiguredminus', 'disfiguredplus', 'disfiguredchevron', 'disfiguredcross', 'disfiguredleftarrow', 'disfiguredrightarrow', 'disfiguredbottomarrow',
        'arrowup', 'arrowdown', 'arrowright', 'arrowleft' ] ],
        'placeholder' => '4px',
    ];
    $this->controls['hamburgerStrokeSpacing'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Stroke spacing', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css'     => [
        [
            'property' => '--hamburger-layer-spacing',
            'selector' => '.hamburger',
        ],
        ],
        'required'    => [ 'type', '=', [ 'slider', 'arrow', 'arrow alt', 'arrow turn', 'spin', 'elastic',
        'emphatic', 'collapse', 'vortex', 'stand', 'spring', '3dx', '3dy', '3dxy', 'squeeze', 'minus', 'boring' ] ],
        'placeholder' => '6px',
    ];
    $this->controls['hamburgerStrokeRadius'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Stroke radius', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css'     => [
        [
            'property' => '--hamburger-border-radius',
            'selector' => '.hamburger, .next-burger-disfigured, .next-burger-arrow',
        ],
        ],
        'required'    => [ 'type', '=', [ 'slider', 'arrow', 'arrow alt', 'arrow turn', 'spin', 'elastic',
        'emphatic', 'collapse', 'vortex', 'stand', 'spring', '3dx', '3dy', '3dxy', 'squeeze', 'minus', 'boring',
        'disfiguredminus', 'disfiguredplus', 'disfiguredchevron', 'disfiguredcross', 'disfiguredleftarrow', 'disfiguredrightarrow', 'disfiguredbottomarrow',
        'arrowup', 'arrowdown', 'arrowright', 'arrowleft' ] ],
        'placeholder' => '4px',
    ];

    $this->controls['strokerounded'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Sharp', 'bricks' ),
        'type'     => 'checkbox',
        'css'      => [
            [
                'property' => '--burguer-rounded',
                'selector' => '.bc-burguer-style1, .bc-burguer-style2, .bc-burguer-style3, .bc-burguer-style4, .bc-burguer-style5, 
                .bc-burguer-style6, .bc-burguer-style7, .bc-burguer-style8, .bc-burguer-style9, .bc-burguer-style10, 
                .next-burger-animated, .next-burger-animated--distorsionv3, .next-burger-animated--chevron, .next-burger-flipped',
            ],
        ],
        'required'    => [ 'type', '=', [ 'style1', 'style2', 'style3', 'style4', 'style5', 'style6', 'style7', 'style8', 'style9', 'style10',
        'distorsion', 'distorsionv2', 'distorsionv3', 'arrow distorsion', 'arrow distorsionv2', 'chevron',
        'flipping', 'flippingv2', 'flippingv3', 'flippingv4', 'flippingv5', 'flippingtitle', 'flippingarrow', 'flippingarrowv2' ] ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type'  => 'number',
        'unit' => 'ms',
        'css'     => [
        [
            'property' => '--burguer-duration',
            'selector' => '.bc-burguer-style1, .bc-burguer-style2, .bc-burguer-style3, .bc-burguer-style4, .bc-burguer-style5, 
            .bc-burguer-style6, .bc-burguer-style7, .bc-burguer-style8, .bc-burguer-style9, .bc-burguer-style10, 
            .hamburger, .next-burger-animated, .next-burger-animated--distorsionv3, .next-burger-animated--chevron, .next-burger-flipped, 
            .next-burger-disfigured, .next-burger-arrow, .next-burger-bounce',
        ],
        ],
        'placeholder' => '600ms',
    ];
    $this->controls['easing'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'CSS Easing', 'bricks' ),
        'type'  => 'text',
        'inline' => true,
        'css'     => [
        [
            'property' => '--burguer-easing',
            'selector' => '.bc-burguer-style1, .bc-burguer-style2, .bc-burguer-style3, .bc-burguer-style4, .bc-burguer-style5, 
            .bc-burguer-style6, .bc-burguer-style7, .bc-burguer-style8, .bc-burguer-style9, .bc-burguer-style10, 
            .hamburger, .next-burger-animated, .next-burger-animated--distorsionv3, .next-burger-animated--chevron, .next-burger-flipped, 
            .next-burger-disfigured, .next-burger-arrow, .next-burger-bounce',
        ],
        ],
        'placeholder' => 'ease',
    ];

    $this->controls['bodyscrollingSeparator'] = [
        'type'       => 'separator',
    ];
    $this->controls['bodyscrollingnote'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'If true, Burger will lock body scrolling on click.', 'bricks' )))
    ];
    $this->controls['bodyscrolling'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Lock body scrolling', 'bricks' ),
        'type'     => 'checkbox',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'coreburguer', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_core_burguer.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'style5';
    $reversed2    = ! empty( $settings['reversed2'] ) ? $settings['reversed2'] : false;
    $reversed5    = ! empty( $settings['reversed5'] ) ? $settings['reversed5'] : false;
    $reversed6    = ! empty( $settings['reversed6'] ) ? $settings['reversed6'] : false;
    $reversed7    = ! empty( $settings['reversed7'] ) ? $settings['reversed7'] : false;
    $reversed10    = ! empty( $settings['reversed10'] ) ? $settings['reversed10'] : false;
    $reversedHamburger    = ! empty( $settings['reversedHamburger'] ) ? $settings['reversedHamburger'] : false;
    $bodyscrolling    = ! empty( $settings['bodyscrolling'] ) ? $settings['bodyscrolling'] : false;

    $this->set_attribute( '_root', 'class', 'bc-core-burguer' );
    $this->set_attribute( 'inner', 'aria-label', 'close' );
    $this->set_attribute( 'inner', 'data-scroll', $bodyscrolling );
    $output = "<div {$this->render_attributes( '_root' )}>";

    if ( $type ) {
        if ($type === 'style1') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style1' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 100 100'>
                <path class='bc-burguer-style1__line--line1' d='M 20,29.000046 H 80.000231 C 80.000231,29.000046 94.498839,28.817352 94.532987,66.711331 94.543142,77.980673 90.966081,81.670246 85.259173,81.668997 79.552261,81.667751 75.000211,74.999942 75.000211,74.999942 L 25.000021,25.000058' />
                <path shape-rendering='optimizeSpeed' class='bc-burguer-style1__line--line2' d='M 20,50 H 80'/>
                <path class='bc-burguer-style1__line--line3' d='M 20,70.999954 H 80.000231 C 80.000231,70.999954 94.498839,71.182648 94.532987,33.288669 94.543142,22.019327 90.966081,18.329754 85.259173,18.331003 79.552261,18.332249 75.000211,25.000058 75.000211,25.000058 L 25.000021,74.999942' />
                </svg>
            </button>";
        }
        else if ($type === 'style2') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style2' );
            if($reversed2){$this->set_attribute( 'inner', 'class', 'bc-burguer-style2--reversed' );}
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <div class='bc-burguer-style2__wrapper'>
                    <div class='bc-burguer-style2__line--half-first'></div>
                    <div class='bc-burguer-style2__line'></div>
                    <div class='bc-burguer-style2__line--half-last'></div>
                </div>
            </button>
            ";
        }
        else if ($type === 'style3') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style3' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='bc-burguer-style3__line'></span>
                <span class='bc-burguer-style3__line'></span>
            </button>
            ";
        }
        else if ($type === 'style4') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style4' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='bc-burguer-style4__line'></span>
            </button>
            ";
        }
        else if ($type === 'style5') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style5' );
            if($reversed5){$this->set_attribute( 'inner', 'class', 'bc-burguer-style5--reversed' );}
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='bc-burguer-style5__line'></span>
            </button>
            ";
        }
        else if ($type === 'style6') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style6' );
            if($reversed6){$this->set_attribute( 'inner', 'class', 'bc-burguer-style6--reversed' );}
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='bc-burguer-style6__icon'></span>
            </button>
            ";
        }
        else if ($type === 'style7') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style7' );
            if($reversed7){$this->set_attribute( 'inner', 'class', 'bc-burguer-style7--reversed' );}
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='bc-burguer-style7__line'></span>
            </button>
            ";
        }
        else if ($type === 'style8') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style8' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='bc-burguer-style8__left-icon'></span>
                <span class='bc-burguer-style8__right-icon'></span>
            </button>
            ";
        }
        else if ($type === 'style9') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style9' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='bc-burguer-style9__line'></span>
            </button>
            ";
        }
        else if ($type === 'style10') {
            $this->set_attribute( 'inner', 'class', 'bc-burguer-style10' );
            if($reversed10){$this->set_attribute( 'inner', 'class', 'bc-burguer-style10--reversed' );}
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <div class='bc-burguer-style10__first-line'></div>
                <div class='bc-burguer-style10__second-line'></div>
            </button>
            ";
        }
        //TASTY HAMBURGERS
        else if ($type === 'slider') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--slider-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--slider' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'squeeze') {
            $this->set_attribute( 'inner', 'class', 'hamburger--squeeze' );
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'arrow') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--arrow-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--arrow' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'arrow alt') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--arrowalt-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--arrowalt' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'arrow turn') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--arrowturn-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--arrowturn' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'spin') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--spin-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--spin' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'elastic') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--elastic-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--elastic' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'emphatic') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--emphatic-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--emphatic' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'collapse') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--collapse-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--collapse' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'vortex') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--vortex-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--vortex' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'stand') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--stand-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--stand' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'spring') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--spring-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--spring' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'minus') {
            $this->set_attribute( 'inner', 'class', 'hamburger--minus' );
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === '3dx') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--3dx-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--3dx' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === '3dy') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--3dy-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--3dy' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === '3dxy') {
            if($reversedHamburger){
                $this->set_attribute( 'inner', 'class', 'hamburger--3dxy-r' );
            }else{$this->set_attribute( 'inner', 'class', 'hamburger--3dxy' );}
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'boring') {
            $this->set_attribute( 'inner', 'class', 'hamburger--boring' );
            $this->set_attribute( 'inner', 'class', 'hamburger' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span class='hamburger-box'>
                    <span class='hamburger-inner'></span>
                </span>
            </button>
            ";
        }
        else if ($type === 'distorsion') {
            $this->set_attribute( 'inner', 'class', 'next-burger-animated--1' );
            $this->set_attribute( 'inner', 'class', 'next-burger-animated' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'>
                    <circle cx='50' cy='50' r='30' />
                    <path class='line--1' d='M0 40h62c13 0 6 28-4 18L35 35' />
                    <path class='line--2' d='M0 50h70' />
                    <path class='line--3' d='M0 60h62c13 0 6-28-4-18L35 65' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'distorsionv2') {
            $this->set_attribute( 'inner', 'class', 'next-burger-animated--2' );
            $this->set_attribute( 'inner', 'class', 'next-burger-animated' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'>
                    <circle cx='50' cy='50' r='30' />
                    <path class='line--1' d='M0 70l28-28c2-2 2-2 7-2h64' />
                    <path class='line--2' d='M0 50h99' />
                    <path class='line--3' d='M0 30l28 28c2 2 2 2 7 2h64' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'distorsionv3') {
            $this->set_attribute( 'inner', 'class', 'next-burger-animated--distorsionv3' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 64 48'>
                    <path d='M19,15 L45,15 C70,15 58,-2 49.0177126,7 L19,37'></path>
                    <path d='M19,24 L45,24 C61.2371586,24 57,49 41,33 L32,24'></path>
                    <path d='M45,33 L19,33 C-8,33 6,-2 22,14 L45,37'></path>
                </svg>
            </button>
            ";
        }
        else if ($type === 'arrow distorsion') {
            $this->set_attribute( 'inner', 'class', 'next-burger-animated--3' );
            $this->set_attribute( 'inner', 'class', 'next-burger-animated' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'>
                    <circle cx='50' cy='50' r='30' />
                    <path class='line--1' d='M0 40h62c18 0 18-20-17 5L31 55' />
                    <path class='line--2' d='M0 50h80' />
                    <path class='line--3' d='M0 60h62c18 0 18 20-17-5L31 45' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'arrow distorsionv2') {
            $this->set_attribute( 'inner', 'class', 'next-burger-animated--4' );
            $this->set_attribute( 'inner', 'class', 'next-burger-animated' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'>
                    <circle cx='50' cy='50' r='30' />
                    <path class='line--1' d='M0 55l14-10c4.7-3.3 9-5 13-5h72' />
                    <path class='line--2' d='M0 50h99' />
                    <path class='line--3' d='M0 45l14 10c4.7 3.3 9 5 13 5h72' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'chevron') {
            $this->set_attribute( 'inner', 'class', 'next-burger-animated--chevron' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <div class='nav'>
                    <input type='checkbox' />
                    <svg>
                        <use xlink:href='#menu' />
                        <use xlink:href='#menu' />
                    </svg>
                </div>
                <svg xmlns='http://www.w3.org/2000/svg' style='display: none;'>
                    <symbol xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 56' id='menu'>
                        <path d='M48.33,45.6H18a14.17,14.17,0,0,1,0-28.34H78.86a17.37,17.37,0,0,1,0,34.74H42.33l-21-21.26L47.75,4'/>
                    </symbol>
                </svg>
            </button>
            ";
        }
        else if ($type === 'flipping') {
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped--flipping' );
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg class='hamRotate' viewBox='0 0 100 100'>
                <path
                        class='line top'
                        d='m 30,33 h 40 c 0,0 9.044436,-0.654587 9.044436,-8.508902 0,-7.854315 -8.024349,-11.958003 -14.89975,-10.85914 -6.875401,1.098863 -13.637059,4.171617 -13.637059,16.368042 v 40' />
                <path
                        class='line middle'
                        d='m 30,50 h 40' />
                <path
                        class='line bottom'
                        d='m 30,67 h 40 c 12.796276,0 15.357889,-11.717785 15.357889,-26.851538 0,-15.133752 -4.786586,-27.274118 -16.667516,-27.274118 -11.88093,0 -18.499247,6.994427 -18.435284,17.125656 l 0.252538,40' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'flippingv2') {
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped--flippingv2' );
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg class='hamRotate' viewBox='0 0 100 100'>
                <path
                        class='line top'
                        d='m 70,33 h -40 c 0,0 -6,1.368796 -6,8.5 0,7.131204 6,8.5013 6,8.5013 l 20,-0.0013' />
                <path
                        class='line middle'
                        d='m 70,50 h -40' />
                <path
                        class='line bottom'
                        d='m 69.575405,67.073826 h -40 c -5.592752,0 -6.873604,-9.348582 1.371031,-9.348582 8.244634,0 19.053564,21.797129 19.053564,12.274756 l 0,-40' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'flippingv3') {
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped--flippingv3' );
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 100 100'>
                <path
                        class='line top'
                        d='m 30,33 h 40 c 13.100415,0 14.380204,31.80258 6.899646,33.421777 -24.612039,5.327373 9.016154,-52.337577 -12.75751,-30.563913 l -28.284272,28.284272' />
                <path
                        class='line middle'
                        d='m 70,50 c 0,0 -32.213436,0 -40,0 -7.786564,0 -6.428571,-4.640244 -6.428571,-8.571429 0,-5.895471 6.073743,-11.783399 12.286435,-5.570707 6.212692,6.212692 28.284272,28.284272 28.284272,28.284272' />
                <path
                        class='line bottom'
                        d='m 69.575405,67.073826 h -40 c -13.100415,0 -14.380204,-31.80258 -6.899646,-33.421777 24.612039,-5.327373 -9.016154,52.337577 12.75751,30.563913 l 28.284272,-28.284272' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'flippingv4') {
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped--flippingv4' );
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg class='hamRotate' viewBox='0 0 100 100'>
                <path
                        class='line top'
                        d='m 70,33 h -40 c 0,0 -8.5,-0.149796 -8.5,8.5 0,8.649796 8.5,8.5 8.5,8.5 h 20 v -20' />
                <path
                        class='line middle'
                        d='m 70,50 h -40' />
                <path
                        class='line bottom'
                        d='m 30,67 h 40 c 0,0 8.5,0.149796 8.5,-8.5 0,-8.649796 -8.5,-8.5 -8.5,-8.5 h -20 v 20' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'flippingv5') {
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped--flippingv5' );
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg class='hamRotate' viewBox='0 0 100 100'>
                <path
                        class='line top'
                        d='m 30,33 h 40 c 3.722839,0 7.5,3.126468 7.5,8.578427 0,5.451959 -2.727029,8.421573 -7.5,8.421573 h -20' />
                <path
                        class='line middle'
                        d='m 30,50 h 40' />
                <path
                        class='line bottom'
                        d='m 70,67 h -40 c 0,0 -7.5,-0.802118 -7.5,-8.365747 0,-7.563629 7.5,-8.634253 7.5,-8.634253 h 20' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'flippingtitle') {
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped--flippingtitle' );
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 100 100'>
                <path
                        class='line top'
                        d='m 70,33 h -40 c -11.092231,0 11.883874,13.496726 -3.420361,12.956839 -0.962502,-2.089471 -2.222071,-3.282996 -4.545687,-3.282996 -2.323616,0 -5.113897,2.622752 -5.113897,7.071068 0,4.448316 2.080609,7.007933 5.555839,7.007933 2.401943,0 2.96769,-1.283974 4.166879,-3.282995 2.209342,0.273823 4.031294,1.642466 5.857227,-0.252538 v -13.005715 16.288404 h 7.653568' />
                <path
                        class='line middle'
                        d='m 70,50 h -40 c -5.6862,0 -8.534259,5.373483 -8.534259,11.551069 0,7.187738 3.499166,10.922274 13.131984,10.922274 11.021777,0 7.022787,-15.773343 15.531095,-15.773343 3.268142,0 5.177031,-2.159429 5.177031,-6.7 0,-4.540571 -1.766442,-7.33533 -5.087851,-7.326157 -3.321409,0.0092 -5.771288,2.789632 -5.771288,7.326157 0,4.536525 2.478983,6.805271 5.771288,6.7' />
                <path
                        class='line bottom'
                        d='m 70,67 h -40 c 0,0 -3.680675,0.737051 -3.660714,-3.517857 0.02541,-5.415597 3.391687,-10.357143 10.982142,-10.357143 4.048418,0 17.88928,0.178572 23.482143,0.178572 0,2.563604 2.451177,3.403635 4.642857,3.392857 2.19168,-0.01078 4.373905,-1.369814 4.375,-3.392857 0.0011,-2.023043 -1.924401,-2.589191 -4.553571,-4.107143 -2.62917,-1.517952 -4.196429,-1.799562 -4.196429,-3.660714 0,-1.861153 2.442181,-3.118811 4.196429,-3.035715 1.754248,0.0831 4.375,0.890841 4.375,3.125 2.628634,0 6.160714,0.267857 6.160714,0.267857 l -0.178571,-2.946428 10.178571,0 -10.178571,0 v 6.696428 l 8.928571,0 -8.928571,0 v 7.142858 l 10.178571,0 -10.178571,0' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'flippingarrow') {
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped--flippingarrow' );
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 100 100'>
                <path
                        class='line top'
                        d='m 70,33 h -40 c -6.5909,0 -7.763966,-4.501509 -7.763966,-7.511428 0,-4.721448 3.376452,-9.583771 13.876919,-9.583771 14.786182,0 11.409257,14.896182 9.596449,21.970818 -1.812808,7.074636 -15.709402,12.124381 -15.709402,12.124381' />
                <path
                        class='line middle'
                        d='m 30,50 h 40' />
                <path
                        class='line bottom'
                        d='m 70,67 h -40 c -6.5909,0 -7.763966,4.501509 -7.763966,7.511428 0,4.721448 3.376452,9.583771 13.876919,9.583771 14.786182,0 11.409257,-14.896182 9.596449,-21.970818 -1.812808,-7.074636 -15.709402,-12.124381 -15.709402,-12.124381' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'flippingarrowv2') {
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped--flippingarrowv2' );
            $this->set_attribute( 'inner', 'class', 'next-burger-flipped' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg class='hamRotate180' viewBox='0 0 100 100'>
                <path
                        class='line top'
                        d='m 30,33 h 40 c 0,0 8.5,-0.68551 8.5,10.375 0,8.292653 -6.122707,9.002293 -8.5,6.625 l -11.071429,-11.071429' />
                <path
                        class='line middle'
                        d='m 70,50 h -40' />
                <path
                        class='line bottom'
                        d='m 30,67 h 40 c 0,0 8.5,0.68551 8.5,-10.375 0,-8.292653 -6.122707,-9.002293 -8.5,-6.625 l -11.071429,11.071429' />
                </svg>
            </button>
            ";
        }
        else if ($type === 'disfiguredbottomarrow') {
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured--bottom-arrow' );
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span></span>
                <span></span>
                <span></span>
            </button>
            ";
        }
        else if ($type === 'disfiguredrightarrow') {
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured--right-arrow' );
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span></span>
                <span></span>
                <span></span>
            </button>
            ";
        }
        else if ($type === 'disfiguredleftarrow') {
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured--left-arrow' );
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span></span>
                <span></span>
                <span></span>
            </button>
            ";
        }
        else if ($type === 'disfiguredcross') {
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured--cross' );
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span></span>
                <span></span>
                <span></span>
            </button>
            ";
        }
        else if ($type === 'disfiguredchevron') {
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured--chevron' );
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span></span>
                <span></span>
                <span></span>
            </button>
            ";
        }
        else if ($type === 'disfiguredplus') {
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured--plus' );
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span></span>
                <span></span>
                <span></span>
            </button>
            ";
        }
        else if ($type === 'disfiguredminus') {
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured--minus' );
            $this->set_attribute( 'inner', 'class', 'next-burger-disfigured' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <span></span>
                <span></span>
                <span></span>
            </button>
            ";
        }
        else if ($type === 'arrowup') {
            $this->set_attribute( 'inner', 'class', 'next-burger-arrow--up' );
            $this->set_attribute( 'inner', 'class', 'next-burger-arrow' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <i class='next-burger-arrow__icon next-burger-arrow_icon-up' aria-hidden='true'></i>
            </button>
            ";
        }
        else if ($type === 'arrowright') {
            $this->set_attribute( 'inner', 'class', 'next-burger-arrow--right' );
            $this->set_attribute( 'inner', 'class', 'next-burger-arrow' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <i class='next-burger-arrow__icon next-burger-arrow_icon-right' aria-hidden='true'></i>
            </button>
            ";
        }
        else if ($type === 'arrowdown') {
            $this->set_attribute( 'inner', 'class', 'next-burger-arrow--down' );
            $this->set_attribute( 'inner', 'class', 'next-burger-arrow' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <i class='next-burger-arrow__icon next-burger-arrow_icon-down' aria-hidden='true'></i>
            </button>
            ";
        }
        else if ($type === 'arrowleft') {
            $this->set_attribute( 'inner', 'class', 'next-burger-arrow--left' );
            $this->set_attribute( 'inner', 'class', 'next-burger-arrow' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <i class='next-burger-arrow__icon next-burger-arrow_icon-left' aria-hidden='true'></i>
            </button>
            ";
        }
        else if ($type === 'bounce') {
            $this->set_attribute( 'inner', 'class', 'next-burger-bounce' );
            $output .= "
            <button {$this->render_attributes( 'inner' )}
            data-scroll=\"$bodyscrolling\">
                <svg viewBox='0 0 24 24' xmlns='http://www.w3.org/2000/svg' fill='none'>
                    <rect width='18' height='1.5' fill=red ry='0.75' x='3' y='6.25' />
                    <rect width='18' height='1.5' fill=red ry='0.75' x='3' y='11.25' />
                    <rect width='18' height='1.5' fill=red ry='0.75' x='3' y='16.25' />
                </svg>
            </button>
            ";
        }

        $output .= '</div>';
    }

	echo $output;
  }
}