<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Coreslider extends Element {
  public $category     = 'Next Bricks - Sliders';
  public $name         = 'coreslider';
  public $icon         = 'ti-layout-slider-alt';
  public $scripts      = ['coreslider'];
  public $nestable     = true;

public function get_label() {
    return esc_html__( 'Next Slider', 'bricks' );
}

public function set_control_groups() {
  $this->control_groups['sliders'] = [
    'title' => esc_html__( 'Slides', 'bricks' ),
    'tab'   => 'content',
  ];
  $this->control_groups['arrows'] = [
    'title' => esc_html__( 'Arrows', 'bricks' ),
    'tab'   => 'content',
  ];
  $this->control_groups['pagination'] = [
    'title' => esc_html__( 'Pagination', 'bricks' ),
    'tab'   => 'content',
  ];
  $this->control_groups['autoplay'] = [
      'title' => esc_html__( 'Autoplay', 'bricks' ),
      'tab'   => 'content',
  ];
  $this->control_groups['autoscroll'] = [
      'title' => esc_html__( 'Autoscroll', 'bricks' ),
      'tab'   => 'content',
  ];
}

public function set_controls() {
      $this->controls['_children'] = [
        'type'          => 'repeater',
        'titleProperty' => 'label',
        'items'         => 'children',
      ];

      $this->controls['settingsSeparator'] = [
        'label'      => esc_html__( 'Settings', 'bricks' ),
        'type'       => 'separator',
      ];

      /*Default*/
      $this->controls['typeloopslide'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'loop' => 'loop',
            'slide' => 'slide',
        ],
        'clearable'   => true,
        'inline'      => true,
        'placeholder' => 'slide',
      ];

      $this->controls['drag'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Drag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'true' => 'true',
            'false' => 'false',
            'free' => 'free',
        ],
        'clearable'   => true,
        'inline'      => true,
        'placeholder' => 'true',
    ];

      $this->controls['autowidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Auto Width', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
    ];
  
      $this->controls['snap'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Snap', 'bricks' ),
          'type' => 'checkbox',
          'inline' => true,
          'small' => true,
          'default' => false,
      ];
  
      $this->controls['speed'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '400',
    ];

      $this->controls['easing'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'CSS Easing', 'bricks' ),
          'type' => 'text',
          'inline' => true,
          'placeholder' => 'cubic-bezier(0.25, 1, 0.5, 1)',
      ];

      $this->controls['rewindSeparator'] = [
        'label'      => esc_html__( 'Rewind', 'bricks' ),
        'type'       => 'separator',
      ];
  
      $this->controls['rewind'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Enable Rewind', 'bricks' ),
          'type' => 'checkbox',
          'inline' => true,
          'small' => true,
          'default' => true,
      ];
  
      $this->controls['rewindspeed'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Speed', 'bricks' ),
          'type' => 'text',
          'inline' => true,
          'placeholder' => '400',
          'required' => [ 'rewind', '=', true],
      ];
  
      $this->controls['rewinddrag'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Rewind by Drag', 'bricks' ),
          'type' => 'checkbox',
          'inline' => true,
          'small' => true,
          'default' => true,
          'required' => [ 'rewind', '=', true],
      ];
      
      $this->controls['flickSeparator'] = [
        'label'      => esc_html__( 'Flick', 'bricks' ),
        'type'       => 'separator',
      ];
  
      $this->controls['flickpower'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Power', 'bricks' ),
          'type' => 'text',
          'inline' => true,
          'placeholder' => '600',
      ];
  
      $this->controls['flickmaxpages'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Max Pages', 'bricks' ),
          'type' => 'text',
          'inline' => true,
          'placeholder' => '3',
      ];

      $this->controls['autoplayaccesibilitySeparator'] = [
        'label'      => esc_html__( 'Accesibility', 'bricks' ),
        'type'       => 'separator',
      ];
  
      $this->controls['keyboard'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Keyboard', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'true' => 'true',
            'false' => 'false',
            'global' => 'global',
        ],
        'clearable'   => true,
        'inline'      => true,
        'placeholder' => 'true',
    ];
  
    $this->controls['wheel'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Wheel', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
    ];
  
    $this->controls['wheelsleep'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Wheel Sleep', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0',
        'required' => [ 'wheel', '=', true],
    ];
  
    $this->controls['releasewheel'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Release Wheel', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
        'required' => [ 'wheel', '=', true],
    ];

    /*Sliders*/
    $this->controls['gap'] = [
      'group' => 'sliders',
      'hasDynamicData' => false,
      'tab' => 'content',
      'units' => true,
      'label' => esc_html__( 'Gap', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'inline' => true,
      'placeholder' => '10px',
  ];

    $this->controls['startelement'] = [
      'group' => 'sliders',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Starting Slide', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '0',
    ];

    $this->controls['perpage'] = [
      'group' => 'sliders',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Per page', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '1',
    ];

    $this->controls['permove'] = [
      'group' => 'sliders',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Per move', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1',
    ];

    $this->controls['breakpointsSeparator'] = [
      'group' => 'sliders',
      'type'       => 'separator',
    ];

    $this->controls['perpagebreakpoints'] = [
      'group' => 'sliders',
      'tab'           => 'content',
      'type'          => 'repeater',
      'label'         => esc_html__( 'Per page Breakpoints', 'bricks' ),
      'placeholder'   => esc_html__( 'Per page Breakpoint', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'breakpoint'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Breakpoint', 'bricks' ),
          'hasDynamicData' => false,
        ],
        'perpage'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Per page', 'bricks' ),
          'hasDynamicData' => false,
        ],
      ],
  ];

    /*Arrows*/ 
    $this->controls['arrows'] = [
      'group'     => 'arrows',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Enable arrows', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];

    $this->controls['scalearrow'] = [
      'group'     => 'arrows',
        'tab'     => 'content',
        'label'   => esc_html__( 'Scale', 'bricks' ),
        'type'    => 'text',
        'css'     => [
          [
            'property' => '--scale-arrow',
            'selector' => '.splide__arrow',
          ],
        ],
        'placeholder' => '1',
        'hasDynamicData' => false,
        'inline' => true,
        'required' => [ 'arrows', '=', true],
    ];

    $this->controls['prevarrowSeparator'] = [
      'group'     => 'arrows',
      'label'      => esc_html__( 'Previous Arrow', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'arrows', '=', true],
    ];

    $this->controls['prevarrowdisplay'] = [
      'group'     => 'arrows',
      'tab'     => 'content',
      'label'   => esc_html__( 'Display', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'flex' => 'flex',
          'none' => 'none',
      ],
      'css'     => [
        [
          'property' => 'display',
          'selector' => '.splide__arrow--prev',
        ],
      ],
      'clearable'   => false,
      'inline'      => true,
      'default'      => 'flex',
      'placeholder' => 'flex',
      'required' => [ 'arrows', '=', true],
    ];

    $this->controls['prevarrowmargin'] = [
      'group'     => 'arrows',
      'tab'     => 'content',
      'label'   => esc_html__( 'Margin', 'bricks' ),
      'type'    => 'spacing',
      'css'     => [
        [
          'property' => 'margin',
          'selector' => '.splide__arrow--prev',
        ],
      ],
      'required'    => [ ['arrows', '=', true] , [ 'prevarrowdisplay', '=', [ 'flex' ] ] ],
    ];

    $this->controls['prevarrowicon'] = [
      'group'     => 'arrows',
        'tab'     => 'content',
        'label'   => esc_html__( 'Icon', 'bricks' ),
        'type'    => 'icon',
        'default' => [
          'icon'    => 'ion-ios-arrow-back',
          'library' => 'ionicons',
        ],
        'required'    => [ ['arrows', '=', true] , [ 'prevarrowdisplay', '=', [ 'flex' ] ] ],
    ];

    $this->controls['prevarrowcolorsvg'] = [
      'group'     => 'arrows',
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
          [
            'property' => 'color',
            'selector' => '.splide__arrow--prev .prevarrowicon',
          ],
        ],
        'required'    => [ ['arrows', '=', true] , [ 'prevarrowdisplay', '=', [ 'flex' ] ] ],
    ];

    $this->controls['prevarrowcolor'] = [
      'group'     => 'arrows',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
          [
            'property' => 'background',
            'selector' => '.splide__arrow--prev',
          ],
        ],
        'required'    => [ ['arrows', '=', true] , [ 'prevarrowdisplay', '=', [ 'flex' ] ] ],
    ];

    $this->controls['nextarrowSeparator'] = [
      'group'     => 'arrows',
      'label'      => esc_html__( 'Next Arrow', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'arrows', '=', true],
    ];

    $this->controls['nextarrowdisplay'] = [
      'group'     => 'arrows',
      'tab'     => 'content',
      'label'   => esc_html__( 'Display', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'flex' => 'flex',
          'none' => 'none',
      ],
      'css'     => [
        [
          'property' => 'display',
          'selector' => '.splide__arrow--next',
        ],
      ],
      'clearable'   => false,
      'inline'      => true,
      'default'      => 'flex',
      'placeholder' => 'flex',
      'required' => [ 'arrows', '=', true],
    ];

    $this->controls['nextarrowmargin'] = [
      'group'     => 'arrows',
      'tab'     => 'content',
      'label'   => esc_html__( 'Margin', 'bricks' ),
      'type'    => 'spacing',
      'css'     => [
        [
          'property' => 'margin',
          'selector' => '.splide__arrow--next',
        ],
      ],
      'required'    => [ ['arrows', '=', true] , [ 'nextarrowdisplay', '=', [ 'flex' ] ] ],
    ];

    $this->controls['nextarrowicon'] = [
      'group'     => 'arrows',
        'tab'     => 'content',
        'label'   => esc_html__( 'Icon', 'bricks' ),
        'type'    => 'icon',
        'default' => [
          'icon'    => 'ion-ios-arrow-forward',
          'library' => 'ionicons',
        ],
        'required'    => [ ['arrows', '=', true] , [ 'nextarrowdisplay', '=', [ 'flex' ] ] ],
    ];

    $this->controls['nextarrowcolorsvg'] = [
      'group'     => 'arrows',
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
          [
            'property' => 'color',
            'selector' => '.splide__arrow--next .nextarrowicon',
          ],
        ],
        'required'    => [ ['arrows', '=', true] , [ 'nextarrowdisplay', '=', [ 'flex' ] ] ],
    ];

    $this->controls['nextarrowcolor'] = [
      'group'     => 'arrows',
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
          [
            'property' => 'background',
            'selector' => '.splide__arrow--next',
          ],
        ],
        'required'    => [ ['arrows', '=', true] , [ 'nextarrowdisplay', '=', [ 'flex' ] ] ],
    ];

    /*Pagination*/
    $this->controls['pagination'] = [
      'group'     => 'pagination',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Enable Pagination', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];
  
    $this->controls['paginationmargin'] = [
      'group'     => 'pagination',
      'tab'     => 'content',
      'label'   => esc_html__( 'Margin', 'bricks' ),
      'type'    => 'spacing',
      'css'     => [
        [
          'property' => 'margin',
          'selector' => '.splide__pagination',
        ],
      ],
      'required' => [ 'pagination', '=', true],
    ];

    $this->controls['paginationjustify'] = [
      'group'    => 'pagination',
      'tab'     => 'content',
      'label'   => esc_html__( 'Justify', 'bricks' ),
      'type'    => 'justify-content',
      'css'     => [
        [
          'property' => 'justify-content',
          'selector' => '.splide__pagination',
        ],
      ],
      'required' => [ 'pagination', '=', true],
  ];

    $this->controls['activepagcolor'] = [
      'group'     => 'pagination',
        'tab'     => 'content',
        'label'   => esc_html__( 'Active dot color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
          [
            'property' => 'background',
            'selector' => '.splide__pagination__page.is-active',
          ],
        ],
        'required' => [ 'pagination', '=', true],
    ];
    $this->controls['inactivepagcolor'] = [
      'group'     => 'pagination',
      'tab'     => 'content',
      'label'   => esc_html__( 'Inactive dot color', 'bricks' ),
      'type'    => 'color',
      'css'     => [
        [
          'property' => 'background',
          'selector' => '.splide__pagination__page',
        ],
      ],
      'required' => [ 'pagination', '=', true],
    ];



    /*Autoplay*/
    $this->controls['autoplay'] = [
        'group' => 'autoplay',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable Autoplay', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
    ];
    $this->controls['omitend'] = [
        'group' => 'autoplay',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Omit End', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
        'required' => [ 'autoplay', '=', true],
    ];

    $this->controls['pauseonhover'] = [
      'group' => 'autoplay',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Pause on hover', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
      'required' => [ 'autoplay', '=', true],
    ];

    $this->controls['interval'] = [
        'group' => 'autoplay',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Interval', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1500',
        'required' => [ 'autoplay', '=', true],
    ];

    $this->controls['lazyload'] = [
        'group' => 'autoplay',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Lazy load', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'false' => 'false',
            'nearby' => 'nearby',
            'sequential' => 'sequential',
        ],
        'clearable'   => true,
        'inline'      => true,
        'placeholder' => 'false',
        'required' => [ 'autoplay', '=', true],
    ];

    $this->controls['paginationautoplay'] = [
      'group' => 'autoplay',
        'tab'         => 'content',
        'label'       => esc_html__( 'Pagination Direction', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'rtl' => 'rtl',
            'ltr' => 'ltr',
        ],
        'clearable'   => true,
        'inline'      => true,
        'placeholder' => 'ltr',
        'required' => [ 'autoplay', '=', true],
    ];

    $this->controls['isnavigation'] = [
        'group' => 'autoplay',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Is Navigation', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
        'required' => [ 'autoplay', '=', true],
    ];

    /*Autoscroll*/
    $this->controls['autoscroll'] = [
        'group' => 'autoscroll',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable Autoscroll', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
    ];

    $this->controls['speedautoscroll'] = [
      'group' => 'autoscroll',
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Speed', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '2',
      'required' => [ 'autoscroll', '=', true],
  ];

    $this->controls['autostart'] = [
        'group' => 'autoscroll',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable Autostart', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
        'required' => [ 'autoscroll', '=', true],
    ];

    $this->controls['pauseonhoverautoscroll'] = [
        'group' => 'autoscroll',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Pause on hover', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
        'required' => [ 'autoscroll', '=', true],
    ];

    $this->controls['rewindautoscroll'] = [
        'group' => 'autoscroll',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Rewind', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
        'required' => [ 'autoscroll', '=', true],
    ];
}


/*Render sliders & children*/
public function get_nestable_item() {
    return [
        'name'     => 'block',
        'label'    => esc_html__( 'Slide Block', 'bricks' ),
        'settings' => [
          '_cssClasses' => 'splide__slide',
        ],
        'children' => [
          [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
              '_hidden' => [
                '_cssClasses' => 'bc-slider-block',
              ],
            ],
            'children' => [
              [
                'name'     => 'heading',
                'label'    => esc_html__( 'Heading', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. In id ipsum velit. Pellentesque faucibus magna arcu, et laoreet ligula lobortis eu. Interdum et malesuada fames ac ante ipsum primis in faucibus', 'bricks' ),
                    'tag'  => 'h3',
                    '_hidden' => [
                        '_cssClasses' => 'bc-slider-block-heading',
                    ],
                ],
              ],
            ],
          ],
        ],
    ];
}

public function get_nestable_children() {
  $children = [];

  for ( $i = 0; $i < 5; $i++ ) { /*Cantidad de item a generar*/
      $item = $this->get_nestable_item();

      // Replace {item_index} with $index
      $item       = json_encode( $item );
      $item       = str_replace( '{item_index}', $i + 1, $item );
      $item       = json_decode( $item, true );
      $children[] = $item;
  }

  return $children;
}


public function enqueue_scripts() {
    wp_enqueue_style( 'splide-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_splide.min.css', array(), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'splide-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_splide.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'splide-autoscroll-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_splide_autoscroll.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'coreslider-filejs', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_core_slider.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false); 
}

public function render() {
    $settings = $this->settings;
    $type = ! empty( $settings['typeloopslide'] ) ? $settings['typeloopslide'] : 'slide';
    $autowidth = ! empty( $settings['autowidth'] ) ? $settings['autowidth'] : false;
    $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : 400;
    $rewind = ! empty( $settings['rewind'] ) ? $settings['rewind'] : false;
    $rewindspeed = ! empty( $settings['rewindspeed'] ) ? $settings['rewindspeed'] : 400;
    $rewinddrag = ! empty( $settings['rewinddrag'] ) ? $settings['rewinddrag'] : false;
    $startelement = ! empty( $settings['startelement'] ) ? $settings['startelement'] : '0';
    $perpage = ! empty( $settings['perpage'] ) ? $settings['perpage'] : '1';
    $permove = ! empty( $settings['permove'] ) ? $settings['permove'] : '1';
    $gap = ! empty( $settings['gap'] ) ? $settings['gap'] : '10px';
    $arrows = ! empty( $settings['arrows'] ) ? $settings['arrows'] : false;
    $pagination = ! empty( $settings['pagination'] ) ? $settings['pagination'] : false;
    $drag = ! empty( $settings['drag'] ) ? $settings['drag'] : 'true';
    $snap = ! empty( $settings['snap'] ) ? $settings['snap'] : false;
    $easing = ! empty( $settings['easing'] ) ? $settings['easing'] : 'cubic-bezier(0.25, 1, 0.5, 1)';
    $flickpower = ! empty( $settings['flickpower'] ) ? $settings['flickpower'] : '600';
    $flickmaxpages = ! empty( $settings['flickmaxpages'] ) ? $settings['flickmaxpages'] : '3';

    $autoplay = ! empty( $settings['autoplay'] ) ? $settings['autoplay'] : false;
    $omitend = ! empty( $settings['omitend'] ) ? $settings['omitend'] : false;
    $interval = ! empty( $settings['interval'] ) ? $settings['interval'] : '1500';
    $pauseonhover = ! empty( $settings['pauseonhover'] ) ? $settings['pauseonhover'] : false;

    $lazyload = ! empty( $settings['lazyload'] ) ? $settings['lazyload'] : 'false';
    $keyboard = ! empty( $settings['keyboard'] ) ? $settings['keyboard'] : 'true';
    $wheel = ! empty( $settings['wheel'] ) ? $settings['wheel'] : false;
    $wheelsleep = ! empty( $settings['wheelsleep'] ) ? $settings['wheelsleep'] : '0';
    $releasewheel = ! empty( $settings['releasewheel'] ) ? $settings['releasewheel'] : false;
    $paginationautoplay = ! empty( $settings['paginationautoplay'] ) ? $settings['paginationautoplay'] : 'ltr';
    $isnavigation = ! empty( $settings['isnavigation'] ) ? $settings['isnavigation'] : false;

    $autoscroll = ! empty( $settings['autoscroll'] ) ? $settings['autoscroll'] : false;
    $autostart = ! empty( $settings['autostart'] ) ? $settings['autostart'] : false;
    $speedautoscroll = ! empty( $settings['speedautoscroll'] ) ? $settings['speedautoscroll'] : '2';
    $pauseonhoverautoscroll = ! empty( $settings['pauseonhoverautoscroll'] ) ? $settings['pauseonhoverautoscroll'] : false;
    $pauseonfocusautoscroll = ! empty( $settings['pauseonfocusautoscroll'] ) ? $settings['pauseonfocusautoscroll'] : false;
    $rewindautoscroll = ! empty( $settings['rewindautoscroll'] ) ? $settings['rewindautoscroll'] : false;

    /*Breakpoints variables as data*/
    $perpagebreakpoints = ! empty( $settings['perpagebreakpoints'] ) ? $settings['perpagebreakpoints'] : false;
    if ($perpagebreakpoints) {
      foreach ( $perpagebreakpoints as $perpagebreakpoint ) {
          if ( isset($perpagebreakpoint['breakpoint'])) {
            $perpagebreakpointsaux[] = $perpagebreakpoint['breakpoint'];    
          }
          if ( isset($perpagebreakpoint['perpage'])) {
            $breakpointperpages[] = $perpagebreakpoint['perpage'];     
          }
      }
      $breakpointsDataAttribute = "data-breakpoints=\"" . implode(',', $perpagebreakpointsaux) . "\"";
      $breakpointPerpagesDataAttribute = "data-breakpointperpages=\"" . implode(',', $breakpointperpages) . "\"";
    }
    

    $this->set_attribute( '_root', 'class', "bc-core-slider-wrapper");
    $this->set_attribute( '_root', 'class', "splide");


    
    /*Render Arrows Icons*/
    if ( ! empty( $settings['prevarrowicon'] )) {
			$previcon = self::render_icon( $settings['prevarrowicon'], [ 'prevarrowicon' ] );
		}
    if ( ! empty( $settings['nextarrowicon'] )) {
			$nexticon = self::render_icon( $settings['nextarrowicon'], [ 'nextarrowicon' ] );
		}

    $output = "<div {$this->render_attributes( '_root' )}";
    
    if ($perpagebreakpoints) {
        $output .= " $breakpointsDataAttribute $breakpointPerpagesDataAttribute";
    }
    
    $output .= "
    data-type=\"$type\"
    data-autowidth=\"$autowidth\"
    data-speed=\"$speed\"
    data-rewind=\"$rewind\"
    data-rewindspeed=\"$rewindspeed\"
    data-rewinddrag=\"$rewinddrag\"
    data-startelement=\"$startelement\"
    data-perpage=\"$perpage\"
    data-permove=\"$permove\"
    data-gap=\"$gap\"
    data-arrows=\"$arrows\"
    data-pagination=\"$pagination\"
    data-drag=\"$drag\"
    data-snap=\"$snap\"
    data-easing=\"$easing\"
    data-flickpower=\"$flickpower\"
    data-flickmaxpages=\"$flickmaxpages\"
    data-autoplay=\"$autoplay\"
    data-omitend=\"$omitend\"
    data-interval=\"$interval\"
    data-pauseonhover=\"$pauseonhover\"
    data-lazyload=\"$lazyload\"
    data-keyboard=\"$keyboard\"
    data-wheel=\"$wheel\"
    data-wheelsleep=\"$wheelsleep\"
    data-releasewheel=\"$releasewheel\"
    data-paginationautoplay=\"$paginationautoplay\"
    data-isnavigation=\"$isnavigation\"
    data-autoscroll=\"$autoscroll\"
    data-autostart=\"$autostart\"
    data-speedautoscroll=\"$speedautoscroll\"
    data-pauseonhoverautoscroll=\"$pauseonhoverautoscroll\"
    data-pauseonfocusautoscroll=\"$pauseonfocusautoscroll\"
    data-rewindautoscroll=\"$rewindautoscroll\">";
    
    $output .= "
      <div class='splide__arrows'>
        <button class='splide__arrow splide__arrow--prev'>";
        if ( ! empty( $settings['prevarrowicon'] )) {
          $output .= $previcon;
        }
        $output .= "</button>
        <button class='splide__arrow splide__arrow--next'>";
        if ( ! empty( $settings['nextarrowicon'] )) {
          $output .= $nexticon;
        }
        $output .= "</button>
      </div>

      <div class='splide__track'>
        <div class='splide__list'>";
          $output .= \Bricks\Frontend::render_children( $this );
        $output .="</div>
      </div>
    ";

    $output .= '</div>';

    echo $output;
  }
}