<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Core_Tabs extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'coretabs';
    public $icon         = 'ti-layout-tab';
    public $scripts      = ['coretabs'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Next Tabs', 'bricks' );
    }

    public function set_controls() {
        $this->controls['openatbuilder'] = [
            'hasDynamicData' => false,
            'tab'         => 'content',
            'label'       => esc_html__( 'Show tab at Bricks', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'Tab number',
        ];
        $this->controls['separatorAux'] = [
            'type'       => 'separator',
        ];
        $this->controls['note'] = [ 
            'tab' => 'content',
            'description' => sprintf(esc_html__( "Active Tab should match Morphing Nav's Active Item for a proper navigation understanding.", 'bricks' ))
        ];
        $this->controls['activetab'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Active Tab', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'small'      => true,
            'placeholder' => '1',
        ];
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['opacityFrom'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'From opacity', 'bricks' ),
            'type'  => 'text',
            'small'      => true,
            'inline'      => true,
            'css'     => [
            [
                'property' => '--opacity-from',
                'selector' => '',
            ],
            ],
            'placeholder' => '0',
        ];
        $this->controls['xFrom'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'From X', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline'      => true,
            'css'     => [
            [
                'property' => '--translate-x-from',
                'selector' => '',
            ],
            ],
            'placeholder' => '0px',
        ];
        $this->controls['yFrom'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'From Y', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline'      => true,
            'css'     => [
            [
                'property' => '--translate-y-from',
                'selector' => '',
            ],
            ],
            'placeholder' => '0px',
        ];
        $this->controls['duration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'inline'      => true,
            'css'     => [
            [
                'property' => '--fade-duration',
                'selector' => '',
            ],
            ],
            'placeholder' => '0.4s',
        ];
        $this->controls['ease'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'CSS Easing', 'bricks' ),
            'type'  => 'text',
            'inline'      => true,
            'css'     => [
            [
                'property' => '--fade-ease',
                'selector' => '',
            ],
            ],
            'placeholder' => 'ease',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'morphingmenu',
                'settings' => [
                    'trigger' => 'click',
                ],
                'children' => [
                    [
                        'name'     => 'morphingmenuitem',
                        'label'    => esc_html__( 'Morphing Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'bc-core-tabs__tab',
                            ],
                        ],
                    ],
                    [
                        'name'     => 'morphingmenuitem',
                        'label'    => esc_html__( 'Morphing Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'bc-core-tabs__tab',
                            ],
                        ],
                    ],
                    [
                        'name'     => 'morphingmenuitem',
                        'label'    => esc_html__( 'Morphing Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'bc-core-tabs__tab',
                            ],
                        ],
                    ],
                ]
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Tab', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'bc-core-tabs__tab-content',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'data-show',
                        'value' => '',
                        ],
                    ]
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Tab', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'bc-core-tabs__tab-content',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'data-show',
                        'value' => '',
                        ],
                    ]
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Tab', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'bc-core-tabs__tab-content',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'data-show',
                        'value' => '',
                        ],
                    ]
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'bc-core-tabs', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_core_tabs.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $openatbuilder = ! empty( $settings['openatbuilder'] ) ? $settings['openatbuilder'] : '';
        $activetab    = ! empty( $settings['activetab'] ) ? $settings['activetab'] : '1';

        $this->set_attribute( '_root', 'class', 'bc-core-tabs' );

        $output = "<div {$this->render_attributes( '_root' )}
        data-to-hide=\"\"
        data-openatbuilder=\"$openatbuilder\"
        data-activetab=\"$activetab\">";
        $output .= Frontend::render_children( $this );
        $output .= "</div>";

        echo $output;
    }
}