<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Crystalbutton extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'crystalbutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['crystalbutton'];

  public function get_label() {
    return esc_html__( 'Crystal Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Crystal Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-crystal-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-crystal-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-crystal-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-crystal-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-crystal-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-crystal-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-crystal-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-crystal-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['whitespace'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'White space', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'wrap' => 'wrap',
          'nowrap' => 'nowrap',
      ],
      'inline'      => true,
      'css'     => [
          [
            'property' => 'white-space',
            'selector' => '',
          ],
        ],
      'placeholder'        => 'wrap',
  ];
  $this->controls['padding'] = [
    'tab'         => 'content',
    'label'       => esc_html__( 'Padding', 'bricks' ),
    'type'        => 'spacing',
    'css'     => [
        [
          'property' => 'padding',
          'selector' => '',
        ],
      ],
      'placeholder' => [
        'top' => 12,
        'right' => 36,
        'bottom' => 12,
        'left' => 36,
      ],
];
    $this->controls['typography'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Typography', 'bricks' ),
      'type'        => 'typography',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'typography',
            'selector' => '',
          ],
        ],
      ];
      $this->controls['background'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-crystal-button__backdrop',
            ],
          ],
      ];
    $this->controls['bordermain'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Border', 'bricks' ),
      'type'        => 'border',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'border',
            'selector' => '',
          ],
        ],
      'exclude' => [
        'radius',
      ],
  ];
  $this->controls['border'] = [
    'tab'         => 'content',
    'label'       => esc_html__( 'Border radius', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'css'     => [
        [
          'property' => '--radius',
          'selector' => '',
        ],
      ],
      'placeholder'    => esc_html__( '15', 'bricks' ),
];

  $this->controls['crystalSeparator'] = [
    'label'      => esc_html__( 'Crystal', 'bricks' ),
    'type'       => 'separator',
  ];
$this->controls['filter'] = [
  'tab'         => 'content',
  'label'       => esc_html__( 'Filter', 'bricks' ),
  'type'        => 'text',
  'inline'      => true,
  'css'     => [
      [
        'property' => '--filter',
        'selector' => '',
      ],
    ],
    'placeholder'    => esc_html__( '0.7', 'bricks' ),
];
$this->controls['blur'] = [
  'tab'         => 'content',
  'label'       => esc_html__( 'Blur', 'bricks' ),
  'type'  => 'number',
  'units' => true,
  'inline'      => true,
  'css'     => [
      [
        'property' => '--blur',
        'selector' => '&{pseudo} .bc-crystal-button__backdrop',
      ],
    ],
    'placeholder'    => esc_html__( '20px', 'bricks' ),
];
$this->controls['brightness'] = [
  'tab'         => 'content',
  'label'       => esc_html__( 'Brightness', 'bricks' ),
  'type'        => 'text',
  'inline'      => true,
  'css'     => [
      [
        'property' => '--brightness',
        'selector' => '&{pseudo} .bc-crystal-button__backdrop',
      ],
    ],
    'placeholder'    => esc_html__( '1.2', 'bricks' ),
];
$this->controls['saturate'] = [
  'tab'         => 'content',
  'label'       => esc_html__( 'Saturate', 'bricks' ),
  'type'        => 'text',
  'inline'      => true,
  'css'     => [
      [
        'property' => '--saturate',
        'selector' => '&{pseudo} .bc-crystal-button__backdrop',
      ],
    ],
    'placeholder'    => esc_html__( '1', 'bricks' ),
];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'crystalbutton', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_crystal_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-crystal-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-crystal-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'bc-crystal-button' );
    $this->set_attribute( '_root', 'class', 'bc-crystal-button--dark' );
    $this->set_attribute( '_root', 'class', 'bc-crystal-button--control' );

    $output = "
    <$root_tag {$this->render_attributes( '_root' )}>
      <div class='bc-crystal-button__backdrop'></div>
      <div class='bc-crystal-button__title'>$leftIcon$inner_title$rightIcon</div>
    </$root_tag>
    ";

	echo $output;
  }
}