<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Drawer extends \Bricks\Element {
  public $category     = 'Next Bricks - Menus';
  public $name         = 'bc_drawer';
  public $icon         = 'ion-ios-archive';
  public $tag      = 'div';
  public $scripts      = ['bc_drawer'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Drawer', 'bricks' );
  }

  public function set_controls() {
    $this->controls['show'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Display at the builder', 'bricks' ),
      'type'     => 'checkbox',
    ];
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'section' => 'section',
          'nav' => 'nav',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['opendefault'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Opened by default', 'bricks' ),
      'type'     => 'checkbox',
    ];
    $this->controls['closeOutside'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( "Remove click at backdrop", 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ]; 
    $this->controls['trigger'] = [
      'hasDynamicData' => true,
      'tab' => 'content',
      'label' => esc_html__( 'Trigger element', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '.className',
    ];

    $this->controls['drawerSeparator'] = [
      'label'      => esc_html__( 'Drawer', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['drawerwidth'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Width', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'width',
          'selector' => '',
        ]
      ],
      'placeholder' => '100%',
    ];
    $this->controls['drawerheight'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Height', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'height',
          'selector' => '',
        ]
      ],
      'placeholder' => '500px',
    ];
    $this->controls['drawerpadding'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type' => 'spacing',
      'css' => [
        [
          'property' => 'padding',
          'selector' => '',
        ]
      ],
    ];
    $this->controls['drawerbackground'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Background', 'bricks' ),
      'type' => 'background',
      'inline' => true,
      'css' => [
        [
          'property' => 'background',
          'selector' => '',
        ]
      ],
    ];
    $this->controls['drawerborder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Border', 'bricks' ),
      'type' => 'border',
      'inline' => true,
      'css' => [
        [
          'property' => 'border',
          'selector' => '',
        ]
      ],
    ];
    $this->controls['drawerboxshadow'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Box shadow', 'bricks' ),
      'type' => 'box-shadow',
      'inline' => true,
      'css' => [
        [
          'property' => 'box-shadow',
          'selector' => '',
        ]
      ],
    ];
    $this->controls['drawerindex'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'zIndex', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'css' => [
        [
          'property' => 'z-index',
          'selector' => '',
        ]
      ],
      'placeholder' => '99999',
    ];
    $this->controls['drawerduration'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Translate duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline' => true,
      'css' => [
        [
          'property' => '--drawer-duration',
          'selector' => '',
        ]
      ],
      'placeholder' => '.4s',
    ];
    $this->controls['drawereasing'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Translate easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'css' => [
        [
          'property' => '--drawer-easing',
          'selector' => '',
        ]
      ],
      'placeholder' => 'cubic-bezier(.32,.72,0,1)',
    ];

    $this->controls['dragSeparator'] = [
      'label'      => esc_html__( 'Mini drag', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['drag'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Enable mini drag', 'bricks' ),
      'type'     => 'checkbox',
      'default'       => true,
    ];
    $this->controls['dragmargin'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type' => 'spacing',
      'css' => [
        [
          'property' => 'margin',
          'selector' => '.bc-drawer__drag',
        ]
      ],
      'required' => [ 'drag', '=', true],
    ];
    $this->controls['dragheight'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Height', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'height',
          'selector' => '.bc-drawer__drag',
        ]
      ],
      'required' => [ 'drag', '=', true],
      'placeholder' => '8px',
    ];
    $this->controls['dragwidth'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Width', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'width',
          'selector' => '.bc-drawer__drag',
        ]
      ],
      'required' => [ 'drag', '=', true],
      'placeholder' => '100px',
    ];
    $this->controls['dragbackground'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Background', 'bricks' ),
      'type' => 'background',
      'inline' => true,
      'css' => [
        [
          'property' => 'background',
          'selector' => '.bc-drawer__drag',
        ]
      ],
      'required' => [ 'drag', '=', true],
    ];

    $this->controls['overlaySeparator'] = [
      'label'      => esc_html__( 'Backdrop', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['overlaybackground'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Background', 'bricks' ),
      'type' => 'background',
      'inline' => true,
      'css' => [
        [
          'property' => 'background',
          'selector' => '~ .bc-drawer__overlay',
        ]
      ],
    ];
    $this->controls['overlayindex'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'zIndex', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'css' => [
        [
          'property' => 'z-index',
          'selector' => '~ .bc-drawer__overlay',
        ]
      ],
      'placeholder' => '99998',
    ];
    $this->controls['overlayduration'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Fade duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline' => true,
      'css' => [
        [
          'property' => '--overlay-duration',
          'selector' => '~ .bc-drawer__overlay',
        ]
      ],
      'placeholder' => '.4s',
    ];
    $this->controls['overlayeasing'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Fade easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'css' => [
        [
          'property' => '--overlay-easing',
          'selector' => '~ .bc-drawer__overlay',
        ]
      ],
      'placeholder' => 'cubic-bezier(.32,.72,0,1)',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc-drawer', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_drawer.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $trigger = ! empty( $settings['trigger'] ) ? $settings['trigger'] : '';
    $show = ! empty( $settings['show'] ) ? $settings['show'] : false;
    $opendefault = ! empty( $settings['opendefault'] ) ? $settings['opendefault'] : false;
    $drag = ! empty( $settings['drag'] ) ? $settings['drag'] : 0;
    $closeOutside = ! empty( $settings['closeOutside'] ) ? $settings['closeOutside'] : false;
    
    $this->set_attribute( '_root', 'class', 'bc-drawer__drawer' );

    $output = "<{$this->tag} class='bc-drawer'>";

    $output .= "<div {$this->render_attributes( '_root' )}
data-trigger=\"$trigger\"
data-show=\"$show\"
data-opendefault=\"$opendefault\"
data-close-outside=\"$closeOutside\">";
    if($drag == 1){
      $output .= "<div class='bc-drawer__drag'></div>";
    }
    // Render children elements (= individual items)
    $output .= Frontend::render_children( $this );
    $output .= "</div>";

    $output .= "<div class='bc-drawer__overlay'></div>";
    $output .= "</{$this->tag}>";

	echo $output;
  }
}