<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Exchange_Title extends \Bricks\Element {
    public $category     = 'Next Bricks - Texts';
    public $name         = 'exchange_title';
    public $icon         = 'ti-layout-width-default';
    public $scripts      = ['exchange_title'];
    public $nestable     = true;
    public $tag      = 'div';

    public function get_label() {
    return esc_html__( 'Exchange Title', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'div' => 'div',
                'span' => 'span',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'div',
			'required'    => [ 'tag', '=', 'custom' ],
        ];
        
        $this->controls['prefix'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Prefix', 'bricks' ),
            'type' => 'text',
            'inline' => true,
        ];
        $this->controls['gap'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'gap',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['_children'] = [
            'type'          => 'repeater',
            'titleProperty' => 'label',
            'items'         => 'children',
        ];

        $this->controls['styleseparator'] = [
            'label'      => esc_html__( 'Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( "You may need to reload canvas when changing a title size.", 'bricks' )))
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'     => [
              [
                  'property' => 'width',
                  'selector' => '',
              ],
            ],
            'placeholder' => '100%',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'placeholder' => 'fit-content',
        ];
        $this->controls['prefix_typography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Prefix Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
              [
                'property' => 'typography',
                'selector' => '.bc-exchange-title__prefix',
              ],
            ],
            'rerender' => true,
        ];
        $this->controls['typography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Lines Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
              [
                'property' => 'typography',
                'selector' => '.bc-exchange-title__wrapper',
              ],
            ],
            'rerender' => true,
        ];

        $this->controls['animationseparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['disablebuilder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['returntotop'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Return to top', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['duration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Exchange duration', 'bricks' ),
            'type'  => 'number',
            'unit'  => 's',
            'css'     => [
                [
                  'property' => '--duration',
                  'selector' => '',
                ],
            ],
            'inline' => true,
            'placeholder' => '0.2s',
        ];
        $this->controls['delay'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Delay between Exchanges', 'bricks' ),
            'type'  => 'number',
            'unit'  => 's',
            'inline' => true,
            'placeholder' => '2s',
        ];
        $this->controls['easing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
              'none' => 'none',
              'power1' => 'power1',
              'power2' => 'power2',
              'power3' => 'power3',
              'power4' => 'power4',
              'back' => 'back',
              'bounce' => 'bounce',
              'circ' => 'circ',
              'elastic' => 'elastic',
              'expo' => 'expo',
              'sine' => 'sine',
              'steps' => 'steps'
            ],
            'inline' => true,
            'placeholder' => 'none',
            'required' => [ 'returntotop', '=', true],
        ];
        $this->controls['CSSeasing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'CSS easing', 'bricks' ),
            'type' => 'text',
            'css'     => [
                [
                  'property' => '--easing',
                  'selector' => '',
                ],
            ],
            'inline' => true,
            'placeholder' => 'ease-in-out',
            'required' => [ 'returntotop', '=', false],
        ];
        $this->controls['stopfinal'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Stop at the end', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
            'required' => [ 'returntotop', '=', false],
        ];
    }

    /*Render children*/
    public function get_nestable_children() {
        return [
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Title', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'A great caption #1', 'bricks' ),
                    'tag'  => 'h3',
                ],
            ],

            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Title', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'A great caption #2', 'bricks' ),
                    'tag'  => 'h3',
                ],
            ],

            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Title', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'A great caption #3', 'bricks' ),
                    'tag'  => 'h3',
                ],
            ],
        ];
      }

    public function enqueue_scripts() {
        wp_enqueue_script( 'bc_exchange_title', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_exchange_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
        $stopfinal    = ! empty( $settings['stopfinal'] ) ? $settings['stopfinal'] : 0;

        $returntotop    = ! empty( $settings['returntotop'] ) ? $settings['returntotop'] : false;
        if(!$returntotop){
            $returntotop = 2;
        }
        $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : '0.2s';
        $delay    = ! empty( $settings['delay'] ) ? $settings['delay'] : '2s';
        $easing    = ! empty( $settings['easing'] ) ? $settings['easing'] : 'none';
        $height    = ! empty( $settings['height'] ) ? $settings['height'] : '';

        $this->set_attribute( '_root', 'class', 'bc-exchange-title' );

        $this->set_attribute( '_inner', 'class', 'bc-exchange-title__wrapper' );
        
        $prefix    = ! empty( $settings['prefix'] ) ? $settings['prefix'] : '';

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        if($prefix) {
            $output .= "<span class='bc-exchange-title__prefix'>{$prefix}</span>";
        }
        $output .= "<div {$this->render_attributes( '_inner' )}
data-duration=\"$duration\"
data-delay=\"$delay\"
data-easing=\"$easing\"
data-height=\"$height\"
data-returntotop=\"$returntotop\"
data-disable-builder=\"$disablebuilder\"
data-stop-final=\"$stopfinal\">";
        $output .= Frontend::render_children( $this );
        $output .= "</div>";
        $output .= "</{$this->tag}>";

        echo $output;
    }
}