<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Expanding_Menu extends \Bricks\Element {
  public $category     = 'Next Bricks - Menus';
  public $name         = 'expandingmenu';
  public $icon         = 'ti-menu-alt';
  public $tag      = 'div';
  public $scripts      = ['expanding_menu'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Expanding Menu', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'section' => 'section',
          'nav' => 'nav',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Use flex settings available at the Style tab to combine Type with positioning.', 'bricks' )))
    ];
    $this->controls['expandingtype'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
          'fromTopLeft' => 'From Top Left',
          'fromTopRight' => 'From Top Right',
          'fromBottomLeft' => 'From Bottom Left',
          'fromBottomRight' => 'From Bottom Right',
        ],
        'inline'      => true,
        'placeholder' => 'From Top Left',
        'default' => 'fromTopLeft',
    ];
    $this->controls['expandingduration'] = [
        'label'       => esc_html__( 'Duration', 'bricks' ),
        'type'        => 'number',
        'unit'      => 's',
        'inline'      => true,
        'placeholder' => '0.4s',
    ];
    $this->controls['expandingeasing'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps'
        ],
        'inline' => true,
        'placeholder' => 'power1',
    ];
    $this->controls['enablefade'] = [
        'label' => esc_html__( 'Enable fade', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => true,
    ];
    $this->controls['openbuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Open at the builder', 'bricks' ),
      'type'     => 'checkbox',
    ];

    $this->controls['separator'] = [
      'description' => sprintf(html_entity_decode(esc_html__( '<br>All elements with this class will toggle the menu alongside all the Burgers inside the menu.', 'bricks' ))),
      'type'       => 'separator',
    ];
    $this->controls['customtoggle'] = [
        'label'       => esc_html__( 'Custom Toggle', 'bricks' ),
        'type'        => 'text',
        'placeholder' => '.bc-core-burger',
    ];
    $this->controls['lockBodyScrollingSeparator'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'If true, Custom Toggle will lock body scrolling on click.', 'bricks' )))
  ];
    $this->controls['lockBodyScrolling'] = [
      'label' => esc_html__( 'Lock body scrolling', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];

    $this->controls['contentseparator'] = [
        'label'       => esc_html__( 'Content Style', 'bricks' ),
        'description' => sprintf(html_entity_decode(esc_html__( 'Edit Expanding Content styles at its element or directly from here.', 'bricks' ))),
        'type'       => 'separator',
    ];
    $this->controls['margin'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'units' => true,
        'css'     => [
          [
              'property' => 'margin',
              'selector' => '.bc-expanding-menu__expanding',
          ],
        ],
    ];
    $this->controls['padding'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Padding', 'bricks' ),
        'type'  => 'spacing',
        'units' => true,
        'css'     => [
          [
              'property' => 'padding',
              'selector' => '.bc-expanding-menu__expanding',
          ],
        ],
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css'     => [
          [
              'property' => 'width',
              'selector' => '.bc-expanding-menu__expanding',
          ],
        ],
        'placeholder' => 'fit-content',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css'     => [
          [
              'property' => 'height',
              'selector' => '.bc-expanding-menu__expanding',
          ],
        ],
        'placeholder' => 'fit-content',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'background',
        'units' => true,
        'css'     => [
          [
              'property' => 'background',
              'selector' => '.bc-expanding-menu__expanding',
          ],
        ],
    ];
    $this->controls['border'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'units' => true,
        'css'     => [
          [
              'property' => 'border',
              'selector' => '.bc-expanding-menu__expanding',
          ],
        ],
    ];

    $this->controls['accessibilitySeparator'] = [
      'label'      => esc_html__( 'Accessibility', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['closeOnEsc'] = [
      'label' => esc_html__( 'Close when pressing ESC key', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];
  }
  
/*Render children*/
public function get_nestable_children() {
return [
    [
      'name'     => 'coreburguer',
      'label'    => esc_html__( 'Burger', 'bricks' ),
      'settings' => [
        '_hidden' => [
            '_cssClasses' => 'bc-core-burguer--expanding-menu',
        ],
      ],
    ],

    [
        'name'     => 'block',
        'label'    => esc_html__( 'Expanding Content', 'bricks' ),
        'settings' => [
          '_hidden'  => [
              '_cssClasses' => 'bc-expanding-menu__expanding',
          ],
        ],
        'children' => [
            [
                'name'     => 'swap-hover',
            ],
            [
                'name'     => 'swap-hover',
            ],
            [
                'name'     => 'swap-hover',
            ],
        ],

    ]
];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'expanding-menu-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_expanding_menu.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $openbuilder = ! empty( $settings['openbuilder'] ) ? $settings['openbuilder'] : 0;
    $expandingtype = ! empty( $settings['expandingtype'] ) ? $settings['expandingtype'] : 'fromTopLeft';
    $expandingduration = ! empty( $settings['expandingduration'] ) ? $settings['expandingduration'] : '0.4s';
    $expandingeasing = ! empty( $settings['expandingeasing'] ) ? $settings['expandingeasing'] : 'power1';
    $enablefade = ! empty( $settings['enablefade'] ) ? $settings['enablefade'] : 0;
    $customtoggle = ! empty( $settings['customtoggle'] ) ? $settings['customtoggle'] : '';
    $lockBodyScrolling = ! empty( $settings['lockBodyScrolling'] ) ? $settings['lockBodyScrolling'] : 0;
    $closeOnEsc = ! empty( $settings['closeOnEsc'] ) ? $settings['closeOnEsc'] : 0;

    $this->set_attribute( '_root', 'class', 'bc-core-menu' );
    $this->set_attribute( '_root', 'class', 'bc-expanding-menu' );
    
    $typeAttr = '';
    if($expandingtype === 'fromTopLeft'){
        $typeAttr = 'bc-expanding-menu--fromtopleft';
    }else if($expandingtype === 'fromTopRight'){
        $typeAttr = 'bc-expanding-menu--fromtopright';
    }else if($expandingtype === 'fromBottomLeft'){
        $typeAttr = 'bc-expanding-menu--frombottomleft';
    }else if($expandingtype === 'fromBottomRight'){
        $typeAttr = 'bc-expanding-menu--frombottomright';
    }

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
    data-duration='{$expandingduration}'
    data-easing='{$expandingeasing}'
    data-fade='{$enablefade}'
    data-customtoggle='{$customtoggle}'
    data-customtoggle-lock-body-scrolling='{$lockBodyScrolling}'
    data-open-builder='{$openbuilder}'
    data-close-on-esc='{$closeOnEsc}'
    data-type='{$typeAttr}'>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

    echo $output;
  }
}