<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Fluid_Gradient_Titke extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'fluid-gradient';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $scripts      = ['bc_fluid_gradient'];

  public function get_label() {
    return esc_html__( 'Fluid Gradient Title', 'bricks' );
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Fluid Gradient Title', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'HTML tag', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'h1' => 'h1',
				'h2' => 'h2',
				'h3' => 'h3',
				'h4' => 'h4',
				'h5' => 'h5',
				'h6' => 'h6',
        'p' => 'p',
        'span' => 'span',
        'custom' => 'custom',
			],
			'clearable'   => false,
			'inline'      => true,
			'placeholder' => 'h3',
			'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Link to', 'bricks' ),
      'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
      'css'     => [
        [
          'property' => 'typography',
          'selector' => '',
        ],
      ],
      'exclude' => [
        [
          'color'
        ],
      ],
    ];

    $this->controls['prefixsufixSeparator'] = [
      'label'      => esc_html__( 'Prefix & Sufix', 'bricks' ),
      'type'       => 'separator',
  ];
    $this->controls['prefix'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Prefix', 'bricks' ),
      'type' => 'text',
      'inline'      => true,
      'hasDynamicData' => true,
      'placeholder' => '',
    ];
    $this->controls['prefixTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Prefix typography', 'bricks' ),
      'type'    => 'typography',
        'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-fuid-gradient__prefix',
        ],
      ],
    ];
    $this->controls['sufix'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Sufix', 'bricks' ),
      'type' => 'text',
      'inline'      => true,
      'hasDynamicData' => true,
      'placeholder' => '',
    ];
    $this->controls['sufixTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Sufix typography', 'bricks' ),
      'type'    => 'typography',
        'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-fuid-gradient__sufix',
        ],
      ],
    ];

    $this->controls['gradientSeparator'] = [
        'label'      => esc_html__( 'Gradient', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['degree'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Degree', 'bricks' ),
        'type'    => 'number',
        'placeholder'    => '125',
    ];
    //Gradient
    $this->controls['colors'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Colors', 'bricks' ),
        'titleProperty' => 'title',
        'fields'        => [
            'gradientcolor'       => [
                'type'    => 'color',
                'label'   => esc_html__( 'Color', 'bricks' ),
            ],
        ],
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
    $this->controls['duration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
          [
            'property' => '--duration',
            'selector' => '',
          ],
        ],
        'placeholder'    => '15s',
    ];
    $this->controls['easing'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Easing', 'bricks' ),
        'type'    => 'text',
        'css'     => [
          [
            'property' => '--easing',
            'selector' => '',
          ],
        ],
        'placeholder'    => 'linear',
        'inline'    => true,
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_fluid_gradient', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_fluid_gradient_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;

    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'linear';
    $degree    = ! empty( $settings['degree'] ) ? $settings['degree'] : 125;
    $radialposition    = ! empty( $settings['radialposition'] ) ? $settings['radialposition'] : 'Center center';

    $prefix    = ! empty( $settings['prefix'] ) ? $settings['prefix'] : '';
    $sufix    = ! empty( $settings['sufix'] ) ? $settings['sufix'] : '';
    

    $colors = ! empty( $settings['colors'] ) ? $settings['colors'] : '';
    
    if ($colors) {
        $gradientcolors = '';
        foreach ( $colors as $color ) {
            if ( isset($color['gradientcolor']) && is_array($color['gradientcolor'])) {
                if (isset($color['gradientcolor']['rgb'])) {
                  $gradientcolor = $color['gradientcolor']['rgb'];
                }else if(isset($color['gradientcolor']['raw'])){
                  $gradientcolor = $color['gradientcolor']['raw'];
                }else if(isset($color['gradientcolor']['hex'])){
                  $gradientcolor = $color['gradientcolor']['hex'];
                }
                $gradientcolors .= $gradientcolor . 'bc11';
            }else{
                $gradientcolors .= 'unset' . 'bc11';
            }
        }
        $gradientcolors .= '';
    }else{
        $gradientcolors = 'unset';
    }

    $this->set_attribute( '_root', 'class', 'bc-fuid-gradient' );
    $this->set_attribute( '_gradient', 'class', 'bc-fuid-gradient__gradient' );

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-fuid-gradient__anchor' {$this->render_attributes( '_link' )}>
          <span class='bc-fuid-gradient__inner-wrapper'>";
          if($prefix != ''){$output .= "<span class='bc-fuid-gradient__prefix'>$prefix</span>";}
          $output .= "<span {$this->render_attributes( '_gradient' )}
data-type=\"$type\"
data-degree=\"$degree\"
data-radial-position=\"$radialposition\"
data-disable-builder=\"$disablebuilder\"
data-gradient-colors=\"$gradientcolors\">$inner_title</span>";
          if($sufix != ''){$output .= "<span class='bc-fuid-gradient__sufix'>$sufix</span>";}
          $output .= "</span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span class='bc-fuid-gradient__inner-wrapper'>";
        if($prefix != ''){$output .= "<span class='bc-fuid-gradient__prefix'>$prefix</span>";}
        $output .= "<span {$this->render_attributes( '_gradient' )}
data-type=\"$type\"
data-degree=\"$degree\"
data-radial-position=\"$radialposition\"
data-disable-builder=\"$disablebuilder\"
data-gradient-colors=\"$gradientcolors\">$inner_title</span>";
        if($sufix != ''){$output .= "<span class='bc-fuid-gradient__sufix'>$sufix</span>";}
        $output .= "</span>
      </{$this->tag}>
      ";
    }

		echo $output;
  }
}

