<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Generatorism extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'generatorism';
  public $icon         = 'ion-ios-options';
  public $tag      = 'div';
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Generatorism', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['type'] = [
      'clearable' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'glassmorphism' => 'glassmorphism',
        'neumorphism' => 'neumorphism',
        'neumorphism-v2' => 'neumorphism-v2',
        'neobrutalism' => 'neobrutalism',
      ],
      'inline'      => true,
      'placeholder' => 'glassmorphism',
      'default' => 'glassmorphism',
    ];

    //glassmorphism
    $this->controls['separatorGlassmorphism'] = [
      'label'      => esc_html__( 'Glassmorphism', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'type', '=', 'glassmorphism']
    ];
    $this->controls['backdropBlurGlassmorphism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Backdrop blur', 'bricks' ),
      'type'  => 'number',
      'units'  => true,
      'inline' => true,
      'css'     => [
      [
          'property' => '--filter',
          'selector' => '&.bc-generatorism[data-class="bc-generatorism--glassmorphism"]', //& selector for itself
      ],
      ],
      'placeholder' => '10px',
      'required' => [ 'type', '=', 'glassmorphism'],
    ];
    $this->controls['noteGlassmorphism'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Shadow, Border and Background colors should be chosen with RGBA.<br> Setting 0.1 at the alpha channel is highly recommended to achieve a stunning glass effect.', 'bricks' ))),
      'required' => [ 'type', '=', 'glassmorphism'],
    ];
    $this->controls['boxShadowGlassmorphism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Box shadow', 'bricks' ),
      'type'  => 'box-shadow',
      'inline' => true,
      'css'     => [
        [
            'property' => 'box-shadow',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--glassmorphism"]',
        ],
      ],
      'required' => [ 'type', '=', 'glassmorphism'],
    ];
    $this->controls['backgroundGlassmorphism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Background', 'bricks' ),
      'type'  => 'background',
      'inline' => true,
      'css'     => [
        [
            'property' => 'background',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--glassmorphism"]',
        ],
      ],
      'required' => [ 'type', '=', 'glassmorphism'],
    ];
    $this->controls['borderGlassmorphism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Border', 'bricks' ),
      'type'  => 'border',
      'inline' => true,
      'css'     => [
        [
            'property' => 'border',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--glassmorphism"]',
        ],
      ],
      'required' => [ 'type', '=', 'glassmorphism'],
    ];

    //neumorphism
    $this->controls['separatorNeumorphism'] = [
      'label'      => esc_html__( 'Neumorphism', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'type', '=', 'neumorphism']
    ];
    $this->controls['noteNeumorphism'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Neumorphism´s background should be transparent to achieve a solid Neumorphism effect.', 'bricks' ))),
      'required' => [ 'type', '=', 'neumorphism'],
    ];
    $this->controls['spreadNeumorphism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Spread', 'bricks' ),
      'type'  => 'number',
      'unit'  => 'px',
      'inline' => true,
      'css'     => [
        [
            'property' => '--dimensions',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neumorphism"]',
        ],
      ],
      'placeholder' => '20px',
      'required' => [ 'type', '=', 'neumorphism'],
    ];
    $this->controls['leftColorNeumorphism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left color', 'bricks' ),
      'type'  => 'color',
      'inline' => true,
      'css'     => [
        [
            'property' => '--neumorphism-left-color',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neumorphism"]',
        ],
      ],
      'required' => [ 'type', '=', 'neumorphism'],
    ];
    $this->controls['rightColorNeumorphism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right color', 'bricks' ),
      'type'  => 'color',
      'inline' => true,
      'css'     => [
        [
            'property' => '--neumorphism-right-color',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neumorphism"]',
        ],
      ],
      'required' => [ 'type', '=', 'neumorphism'],
    ];
    $this->controls['borderNeumorphism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Border', 'bricks' ),
      'type'  => 'border',
      'inline' => true,
      'css'     => [
        [
            'property' => 'border',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neumorphism"]',
        ],
      ],
      'required' => [ 'type', '=', 'neumorphism'],
    ];

    //neumorphismv2
    $this->controls['separatorNeumorphismv2'] = [
      'label'      => esc_html__( 'Neumorphism', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'type', '=', 'neumorphism-v2']
    ];
    $this->controls['noteNeumorphismv2'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Neumorphism´s background should be transparent to achieve a solid Neumorphism effect.', 'bricks' ))),
      'required' => [ 'type', '=', 'neumorphism-v2'],
    ];
    $this->controls['spreadNeumorphismv2'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Spread', 'bricks' ),
      'type'  => 'number',
      'unit'  => 'px',
      'inline' => true,
      'css'     => [
        [
            'property' => '--dimensions-v2',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neumorphism-v2"]',
        ],
      ],
      'placeholder' => '20px',
      'required' => [ 'type', '=', 'neumorphism-v2'],
    ];
    $this->controls['leftColorNeumorphismv2'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left color', 'bricks' ),
      'type'  => 'color',
      'inline' => true,
      'css'     => [
        [
            'property' => '--neumorphism-v2-left-color',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neumorphism-v2"]',
        ],
      ],
      'required' => [ 'type', '=', 'neumorphism-v2'],
    ];
    $this->controls['rightColorNeumorphismv2'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right color', 'bricks' ),
      'type'  => 'color',
      'inline' => true,
      'css'     => [
        [
            'property' => '--neumorphism-v2-right-color',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neumorphism-v2"]',
        ],
      ],
      'required' => [ 'type', '=', 'neumorphism-v2'],
    ];
    $this->controls['borderNeumorphismv2'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Border', 'bricks' ),
      'type'  => 'border',
      'inline' => true,
      'css'     => [
        [
            'property' => 'border',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neumorphism-v2"]',
        ],
      ],
      'required' => [ 'type', '=', 'neumorphism-v2'],
    ];

    //neobrutalism
    $this->controls['separatorNeobrutalism'] = [
      'label'      => esc_html__( 'Neobrutalism', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'type', '=', 'neobrutalism']
    ];
    $this->controls['thicknessNeobrutalism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Thickness', 'bricks' ),
      'type'  => 'number',
      'units'  => true,
      'inline' => true,
      'css'     => [
      [
          'property' => '--thickness',
          'selector' => '&.bc-generatorism[data-class="bc-generatorism--neobrutalism"]',
      ],
      ],
      'placeholder' => '10px',
      'required' => [ 'type', '=', 'neobrutalism'],
    ];
    $this->controls['thicknessColorNeobrutalism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Thickness color', 'bricks' ),
      'type'  => 'color',
      'inline' => true,
      'css'     => [
      [
          'property' => '--thickness-color',
          'selector' => '&.bc-generatorism[data-class="bc-generatorism--neobrutalism"]',
      ],
      ],
      'required' => [ 'type', '=', 'neobrutalism'],
    ];
    $this->controls['backgroundNeobrutalism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Background', 'bricks' ),
      'type'  => 'background',
      'inline' => true,
      'css'     => [
        [
            'property' => 'background',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neobrutalism"]',
        ],
      ],
      'required' => [ 'type', '=', 'neobrutalism'],
    ];
    $this->controls['borderNeobrutalism'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Border radius', 'bricks' ),
      'type'  => 'border',
      'inline' => true,
      'css'     => [
        [
            'property' => 'border',
            'selector' => '&.bc-generatorism[data-class="bc-generatorism--neobrutalism"]',
        ],
      ],
      'exclude' => [
        'width',
        'style',
        'color',
      ],
      'required' => [ 'type', '=', 'neobrutalism'],
    ];
  }

  public function render() {
    $settings = $this->settings;
    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'glassmorphism';

    $this->set_attribute( '_root', 'class', 'bc-generatorism' );
    
    $dataClass = '';
    if($type === 'glassmorphism'){
      $dataClass = 'bc-generatorism--glassmorphism';
    }else if($type === 'neumorphism'){
      $dataClass = 'bc-generatorism--neumorphism';
    }else if($type === 'neumorphism-v2'){
      $dataClass = 'bc-generatorism--neumorphism-v2';
    }else if($type === 'neobrutalism'){
      $dataClass = 'bc-generatorism--neobrutalism';
    }

    $output = "<{$this->tag} {$this->render_attributes( '_root' )} data-class='{$dataClass}'>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

    echo $output;
  }
}