<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Glowing_Card extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'bc_glowing_card';
  public $icon         = 'fa-solid fa-square-full';
  public $scripts      = ['bc_glowing_card'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Glowing Card', 'bricks' );
  }

  public function set_controls() {
    $this->controls['note1'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Glowing Card is a nestable element so you can place any content at it.', 'bricks' )))
    ];
    $this->controls['note2'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Disable at touch devices will disable also any other Glowing Card at the page.', 'bricks' )))
    ];
    $this->controls['disableTouchDevices'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at touch devices', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];

    /*style*/
    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['padding'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type' => 'spacing',
      'css'     => [
          [
            'property' => 'padding',
            'selector' => '',
          ],
      ],
    ];
    $this->controls['width'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Width', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'css'     => [
          [
            'property' => 'width',
            'selector' => '',
          ],
      ],
      'placeholder' => '300px',
    ];
    $this->controls['height'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Height', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'css'     => [
          [
            'property' => 'height',
            'selector' => '',
          ],
      ],
      'placeholder' => '300px',
    ];
    $this->controls['boxShadow'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Box shadow', 'bricks' ),
      'type' => 'box-shadow',
      'units' => true,
      'css'     => [
          [
            'property' => 'box-shadow',
            'selector' => '',
          ],
      ],
    ];

    /*glow color*/
    $this->controls['glowcolorSeparator'] = [
        'label'      => esc_html__( 'Glow hsl color', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['colorbase'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Base', 'bricks' ),
        'type' => 'slider',
        'units'    => [
          'px' => [
            'min' => 0,
            'max' => 359,
            'step' => 1,
          ],
        ],
        'css'     => [
            [
              'property' => '--base',
              'selector' => '',
            ],
        ],
        'default' => '80',
        'placeholder' => '80',
    ];
    $this->controls['colorspread'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Spread', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 0,
          'max' => 1000,
          'step' => 1,
        ],
      ],
      'css'     => [
          [
            'property' => '--spread',
            'selector' => '',
          ],
      ],
      'default' => '500',
      'placeholder' => '500',
    ];
    $this->controls['saturationglow'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Saturation', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 0,
          'max' => 100,
          'step' => 1,
        ],
      ],
      'css'     => [
          [
            'property' => '--saturation',
            'selector' => '',
          ],
      ],
      'default' => '100',
      'placeholder' => '100',
    ];
    $this->controls['lightnessglow'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Lightness', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 0,
          'max' => 100,
          'step' => 1,
        ],
      ],
      'css'     => [
          [
            'property' => '--lightness',
            'selector' => '',
          ],
      ],
      'default' => '50',
      'placeholder' => '50',
    ];

    /*glow*/
    $this->controls['glowSeparator'] = [
      'label'      => esc_html__( 'Glow', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['outerglow'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Outer', 'bricks' ),
      'type'     => 'checkbox',
      'css'     => [
        [
          'property' => '--outer',
          'selector' => '',
        ],
      ],
      'default' => true,
    ];
    $this->controls['sizeglow'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 1,
          'max' => 250,
          'step' => 1,
        ],
      ],
      'css'     => [
          [
            'property' => '--size',
            'selector' => '',
          ],
      ],
      'default' => '200',
      'placeholder' => '200',
    ];

    /*backdrop*/
    $this->controls['backdropSeparator'] = [
      'label'      => esc_html__( 'Backdrop', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['backgroundbackdrop'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Background', 'bricks' ),
      'type' => 'background',
      'css'     => [
          [
            'property' => '--backdrop',
            'selector' => '',
          ],
      ],
    ];
    $this->controls['spotalphabackdrop'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Spot Alpha', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 0,
          'max' => 1,
          'step' => 0.1,
        ],
      ],
      'css'     => [
          [
            'property' => '--bg-spot-opacity',
            'selector' => '',
          ],
      ],
      'default' => '0.1',
      'placeholder' => '0.1',
    ];
    $this->controls['blurbackdrop'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Blur', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 0,
          'max' => 20,
          'step' => 1,
        ],
      ],
      'css'     => [
          [
            'property' => '--cardblur',
            'selector' => '',
          ],
      ],
      'default' => '5',
      'placeholder' => '5',
    ];

    /*border*/
    $this->controls['borderSeparator'] = [
      'label'      => esc_html__( 'Border', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['widthborder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Width', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 1,
          'max' => 5,
          'step' => 1,
        ],
      ],
      'css'     => [
          [
            'property' => '--border-width',
            'selector' => '',
          ],
      ],
      'default' => '3',
      'placeholder' => '3',
    ];
    $this->controls['radiusborder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Radius', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 0,
          'max' => 20,
          'step' => 1,
        ],
      ],
      'css'     => [
          [
            'property' => '--get-border-radius',
            'selector' => '',
          ],
      ],
      'default' => '14',
      'placeholder' => '14',
    ];
    $this->controls['spotalphaborder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Spot Alpha', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 0,
          'max' => 1,
          'step' => 100,
        ],
      ],
      'css'     => [
          [
            'property' => '--border-spot-opacity',
            'selector' => '',
          ],
      ],
      'default' => '1',
      'placeholder' => '1',
    ];
    $this->controls['lightalphaborder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Light Alpha', 'bricks' ),
      'type' => 'slider',
      'units'    => [
        'px' => [
          'min' => 0,
          'max' => 1,
          'step' => 100,
        ],
      ],
      'css'     => [
          [
            'property' => '--border-light-opacity',
            'selector' => '',
          ],
      ],
      'default' => '1',
      'placeholder' => '1',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_glowing_card', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_glowing_card.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disableTouchDevices = ! empty( $settings['disableTouchDevices'] ) ? $settings['disableTouchDevices'] : 0;

    $this->set_attribute( '_root', 'class', "bc-glowing-card");
    $this->set_attribute( '_inner', 'class', "bc-glowing-card__mask");

    $output = "<div {$this->render_attributes( '_root' )}
    data-disable-touch-devices='{$disableTouchDevices}'
    data-glow=''
    data-flickering='1'>";
    $output .= Frontend::render_children( $this );
    $output .= "<div {$this->render_attributes( '_inner' )}></div>";
    $output .= '</div>';

	echo $output;
  }
}