<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Gradiently extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'gradiently';
  public $icon         = 'fa-solid fa-square-full';
  public $tag      = 'div';
  public $scripts      = ['bc_gradiently'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Gradiently', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Gradiently is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => ' ',
          ]
        ],
        'placeholder' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'placeholder' => '500px',
    ];

    /*gradient*/
    $this->controls['gradientSeparator'] = [
        'label'      => esc_html__( 'Gradient', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['colors'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Colors', 'bricks' ),
        'titleProperty' => 'title',
        'fields'        => [
            'gradientcolor'       => [
            'type'    => 'color',
            'label'   => esc_html__( 'Color', 'bricks' ),
            'inline'      => true,
            ],
        ],
    ];

    /*js settings*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Disable at the builder', 'bricks' ),
      'type' => 'checkbox',
    ];
    $this->controls['speed'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 0.01,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '4',
        'placeholder' => '4',
    ];
    $this->controls['horizontalpressure'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Horizontal Pressure', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 0.01,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '4',
        'placeholder' => '4',
    ];
    $this->controls['verticalpressure'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Vertical Pressure', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 0.01,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '5',
        'placeholder' => '5',
    ];
    $this->controls['wavefrequencyx'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Wave Frequency X', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 0.01,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '2',
        'placeholder' => '2',
    ];
    $this->controls['wavefrequencyy'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Wave Frequency Y', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 0.01,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '3',
        'placeholder' => '3',
    ];
    $this->controls['waveamplitude'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Wave Amplitude', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 0.01,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '5',
        'placeholder' => '5',
    ];
    $this->controls['shadows'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Shadows', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 0.01,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '0',
        'placeholder' => '0',
    ];
    $this->controls['highlights'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Highlights', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 0.01,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '2',
        'placeholder' => '2',
    ];
    $this->controls['saturation'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Saturation', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => -10,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '7',
        'placeholder' => '7',
    ];
    $this->controls['colorblending'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color Blending', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 0.01,
              'max' => 10,
              'step' => 1,
            ],
        ],
        'default' => '6',
        'placeholder' => '6',
    ];
    $this->controls['grainscale'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Grain Scale', 'bricks' ),
      'type' => 'slider',
      'units' => [
          'px' => [
            'min' => 0.01,
            'max' => 10,
            'step' => 0.1,
          ],
      ],
      'default' => '2',
      'placeholder' => '2',
    ];
    $this->controls['grainintensity'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Grain Intensity', 'bricks' ),
      'type' => 'slider',
      'units' => [
          'px' => [
            'min' => 0.01,
            'max' => 10,
            'step' => 0.1,
          ],
      ],
      'default' => '0.01',
      'placeholder' => '0.01',
  ];
  $this->controls['grainsparsity'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Grain Sparsity', 'bricks' ),
    'type' => 'slider',
    'units' => [
        'px' => [
          'min' => 0.01,
          'max' => 10,
          'step' => 0.1,
        ],
    ],
    'default' => '0.0',
    'placeholder' => '0.0',
  ];
  $this->controls['grainspeed'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Grain Speed', 'bricks' ),
    'type' => 'slider',
    'units' => [
        'px' => [
          'min' => 0.01,
          'max' => 10,
          'step' => 0.1,
        ],
    ],
    'default' => '0.1',
    'placeholder' => '0.1',
  ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_three-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_three.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'bc_gradiently-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_gradiently.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'bc_gradiently', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_gradiently.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : 4;
    $horizontalpressure = ! empty( $settings['horizontalpressure'] ) ? $settings['horizontalpressure'] : 4;
    $verticalpressure = ! empty( $settings['verticalpressure'] ) ? $settings['verticalpressure'] : 5;
    $wavefrequencyx = ! empty( $settings['wavefrequencyx'] ) ? $settings['wavefrequencyx'] : 2;
    $wavefrequencyy = ! empty( $settings['wavefrequencyy'] ) ? $settings['wavefrequencyy'] : 3;
    $waveamplitude = ! empty( $settings['waveamplitude'] ) ? $settings['waveamplitude'] : 5;
    $shadows = ! empty( $settings['shadows'] ) ? $settings['shadows'] : 0;
    $highlights = ! empty( $settings['highlights'] ) ? $settings['highlights'] : 2;
    $saturation = ! empty( $settings['saturation'] ) ? $settings['saturation'] : 7;
    $colorblending = ! empty( $settings['colorblending'] ) ? $settings['colorblending'] : 6;
    $grainscale = ! empty( $settings['grainscale'] ) ? $settings['grainscale'] : 2;
    $grainintensity = ! empty( $settings['grainintensity'] ) ? $settings['grainintensity'] : 0.01;
    $grainsparsity = ! empty( $settings['grainsparsity'] ) ? $settings['grainsparsity'] : 0.0;
    $grainspeed = ! empty( $settings['grainspeed'] ) ? $settings['grainspeed'] : 0.1;

    $this->set_attribute( '_root', 'class', "bc-gradiently");

    $colors = ! empty( $settings['colors'] ) ? $settings['colors'] : '';
    if ($colors) {
        $gradientcolors = '';
        foreach ( $colors as $color ) {
            if ( isset($color['gradientcolor']) && is_array($color['gradientcolor'])) {
                if (isset($color['gradientcolor']['rgb'])) {
                  $gradientcolor = $color['gradientcolor']['rgb'];
                }else if(isset($color['gradientcolor']['raw'])){
                  $gradientcolor = $color['gradientcolor']['raw'];
                }else if(isset($color['gradientcolor']['hex'])){
                  $gradientcolor = $color['gradientcolor']['hex'];
                }
                $gradientcolors .= $gradientcolor . 'bc11';
            }else{
                $gradientcolors .= '#fff' . 'bc11';
            }
        }
        $gradientcolors .= '';
    }else{
        $gradientcolors = 'unset';
    }

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
        data-disable-builder='{$disablebuilder}'
        data-speed='{$speed}'
        data-horizontal-pressure='{$horizontalpressure}'
        data-vertical-pressure='{$verticalpressure}'
        data-wave-frequency-x='{$wavefrequencyx}'
        data-wave-frequency-y='{$wavefrequencyy}'
        data-wave-amplitude='{$waveamplitude}'
        data-shadows='{$shadows}'
        data-highlights='{$highlights}'
        data-saturation='{$saturation}'
        data-color-blending='{$colorblending}'
        data-grain-scale='{$grainscale}'
        data-grain-intensity='{$grainintensity}'
        data-grain-sparsity='{$grainsparsity}'
        data-grain-speed='{$grainspeed}'
        data-gradient-colors='{$gradientcolors}'
        data-flickering=''
    >";
    $output .= "<canvas class='bc-gradiently__canvas'></canvas>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}