<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Grained extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'grained';
  public $icon         = 'fa-solid fa-square-full';
  public $tag      = 'div';
  public $scripts      = ['grained'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Grainy', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Grainy is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];
    $this->controls['note1'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Stop Grainy animation at the builder for a better performance when editing.', 'bricks' )))
    ];
    $this->controls['builderedit'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Stop animation at the builder', 'bricks' ),
        'type'     => 'checkbox',
    ];


    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'placeholder' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'placeholder' => '500px',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type' => 'background',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '',
          ]
        ],
    ];

    $this->controls['grainSeparator'] = [
      'label'      => esc_html__( 'Grain', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['opacity'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Opacity', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'css' => [
        [
          'property' => 'opacity',
          'selector' => '.bc-grained__child',
        ]
      ],
      'placeholder' => '0.05',
    ];
    $this->controls['grainDimension'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Dimensions', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '1000',
  ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['speed'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '25',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'grained', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_grained.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : 25;
    $grainDimension = ! empty( $settings['grainDimension'] ) ? $settings['grainDimension'] : '1000';
    $builderedit = ! empty( $settings['builderedit'] ) ? $settings['builderedit'] : 0;

    $this->set_attribute( '_root', 'class', "bc-grained");
    $this->set_attribute( '_root', 'bc-grained__to-hide', "");

    $output = "<{$this->tag} role='main' {$this->render_attributes( '_root' )}
data-speed=\"$speed\"
data-grainDimension=\"$grainDimension\"
data-builderedit=\"$builderedit\">";
    $output .= "<canvas id='bc-noise' class='bc-grained__child'></canvas>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}