<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Highlight_Hover extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'highlight-hover';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
  public $scripts      = ['highlight_hover'];

  public function get_label() {
    return esc_html__( 'Highlight Hover', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Highlight Hover', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Link to', 'bricks' ),
      'type'  => 'link',
   ];

   $this->controls['iconsSeparator'] = [
    'label'      => esc_html__( 'Icons', 'bricks' ),
    'type'       => 'separator',
  ];
  $this->controls['includeLeftIcon'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Left Icon', 'bricks' ),
    'type' => 'checkbox',
    'default' => false,
  ];
  $this->controls['leftIcon'] = [
    'tab' => 'content',
    'label' => esc_html__( 'Icon', 'bricks' ),
    'type' => 'icon',
    'css' => [
      [
        'selector' => '&{pseudo} .bc-highlight-title__left-icon',
      ],
    ],
    'required'   => [ 'includeLeftIcon', '=', true ],
  ];
  $this->controls['leftIconMargin'] = [
    'tab'   => 'content',
    'label' => esc_html__( 'Margin', 'bricks' ),
    'type'  => 'spacing',
    'css'   => [
      [
        'property' => 'margin',
        'selector' => '&{pseudo} .bc-highlight-title__left-icon',
      ],
    ],
    'required' => [ 'includeLeftIcon', '=', true ],
  ];
  $this->controls['leftIconSize'] = [
    'tab'   => 'content',
    'label' => esc_html__( 'Size', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'css'   => [
      [
        'property' => 'font-size',
        'selector' => '&{pseudo} .bc-highlight-title__left-icon',
      ],
    ],
    'required' => [ 'includeLeftIcon', '=', true ],
  ];
  $this->controls['leftIconColor'] = [
    'tab'   => 'content',
    'label' => esc_html__( 'Color', 'bricks' ),
    'type'  => 'color',
    'css'   => [
      [
        'property' => 'color',
        'selector' => '&{pseudo} .bc-highlight-title__left-icon',
      ],
    ],
    'required' => [ 'includeLeftIcon', '=', true ],
  ];
  $this->controls['includeRightIcon'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Right Icon', 'bricks' ),
    'type' => 'checkbox',
    'default' => false,
  ];
  $this->controls['rightIcon'] = [
    'tab' => 'content',
    'label' => esc_html__( 'Icon', 'bricks' ),
    'type' => 'icon',
    'css' => [
      [
        'selector' => '&{pseudo} .bc-highlight-title__right-icon',
      ],
    ],
    'required'   => [ 'includeRightIcon', '=', true ],
  ];
  $this->controls['rightIconMargin'] = [
    'tab'   => 'content',
    'label' => esc_html__( 'Margin', 'bricks' ),
    'type'  => 'spacing',
    'css'   => [
      [
        'property' => 'margin',
        'selector' => '&{pseudo} .bc-highlight-title__right-icon',
      ],
    ],
    'required' => [ 'includeRightIcon', '=', true ],
  ];
  $this->controls['rightIconSize'] = [
    'tab'   => 'content',
    'label' => esc_html__( 'Size', 'bricks' ),
    'type'  => 'number',
    'units' => true,
    'css'   => [
      [
        'property' => 'font-size',
        'selector' => '&{pseudo} .bc-highlight-title__right-icon',
      ],
    ],
    'required' => [ 'includeRightIcon', '=', true ],
  ];
  $this->controls['rightIconColor'] = [
    'tab'   => 'content',
    'label' => esc_html__( 'Color', 'bricks' ),
    'type'  => 'color',
    'css'   => [
      [
        'property' => 'color',
        'selector' => '&{pseudo} .bc-highlight-title__right-icon',
      ],
    ],
    'required' => [ 'includeRightIcon', '=', true ],
  ];

   $this->controls['styleSeparator'] = [
    'label'      => esc_html__( 'Style', 'bricks' ),
    'type'       => 'separator',
  ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
			'css'     => [
        [
          'property' => 'typography',
          'selector' => '&{pseudo} .bc-highlight-title__element',
        ],
      ],
    ];
    $this->controls['highlightSeparator'] = [
      'label'      => esc_html__( 'Highlight', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['type'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'Bottom to Full' => 'Bottom to Full',
            'Full to Bottom' => 'Full to Bottom',
            'Left to Full' => 'Left to Full',
            'Full to Left' => 'Full to Left',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'Bottom to Full',
    ];
    $this->controls['height'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Thickness', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'     => [
          [
            'property' => '--height',
            'selector' => '&{pseudo} .bc-highlight-title__element',
          ],
        ],
        'inline' => true,
        'placeholder' => '7px',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Duration', 'bricks' ),
          'type'  => 'number',
          'unit' => 's',
          'css'     => [
            [
              'property' => '--duration',
              'selector' => '&{pseudo} .bc-highlight-title__element',
            ],
          ],
          'inline' => true,
          'placeholder' => '0.3s',
      ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
          [
            'property' => '--after-background',
            'selector' => '&{pseudo} .bc-highlight-title__element',
          ],
        ],
    ];
    $this->controls['ease'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'CSS Easing', 'bricks' ),
        'type'  => 'text',
        'inline' => true,
        'css'     => [
          [
            'property' => '--ease',
            'selector' => '&{pseudo} .bc-highlight-title__element',
          ],
        ],
        'placeholder' => 'cubic-bezier(0.16, 1, 0.3, 1)',
    ];

    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '&{pseudo} .bc-highlight-title__element',
        ],
      ],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'Bottom to Full';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = 'span';
    }

    $this->set_attribute( '_root', 'class', 'bc-highlight-title' );

    $this->set_attribute( 'inner_title', 'class', 'bc-highlight-title__element' );
    if ($type === 'Bottom to Full') {
      $this->set_attribute( 'inner_title', 'class', 'bc-highlight-title__bottom-to-full' );
    }
    if ($type === 'Full to Bottom') {
      $this->set_attribute( 'inner_title', 'class', 'bc-highlight-title__full-to-bottom' );
    }
    if ($type === 'Left to Full') {
      $this->set_attribute( 'inner_title', 'class', 'bc-highlight-title__left-to-full' );
    }
    if ($type === 'Full to Left') {
      $this->set_attribute( 'inner_title', 'class', 'bc-highlight-title__full-to-left' );
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-highlight-title__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-highlight-title__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-highlight-title__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( 'inner_title' )}>$leftIcon$inner_title$rightIcon</span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span {$this->render_attributes( 'inner_title' )}>$leftIcon$inner_title$rightIcon</span>
      </{$this->tag}>
      ";
    }

	echo $output;
  }
}

