<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Image_Hotspot extends \Bricks\Element {
  public $name         = 'imagehotspot';
  public $icon         = 'ti-control-record';
  public $scripts      = ['imagehotspots'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Hotspot', 'bricks' );
  }

  public function set_controls() {
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];
    $this->controls['stylingSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Padding', 'bricks' ),
        'type' => 'spacing',
        'css'     => [
            [
              'property' => 'padding',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['left'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Left', 'bricks' ),
        'type' => 'number',
        'units'        => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => 'left',
              'selector' => '',
            ],
        ],
        'placeholder' => '20%',
    ];
    $this->controls['top'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Top', 'bricks' ),
        'type' => 'number',
        'units'        => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => 'top',
              'selector' => '',
            ],
        ],
        'placeholder' => '20%',
    ];
    $this->controls['typography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type' => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['background'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type' => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type' => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['pulseSeparator'] = [
        'label'      => esc_html__( 'Pulse', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['pulseduration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit'        => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--wave-duration',
              'selector' => '',
            ],
        ],
        'placeholder' => '1s',
    ];
    $this->controls['pulseintensity'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Intensity', 'bricks' ),
        'type' => 'number',
        'units'        => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--wave-intensity',
              'selector' => '',
            ],
        ],
        'placeholder' => '10px',
    ];
    $this->controls['pulsecolor'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Color', 'bricks' ),
        'type' => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--wave-color',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['tooltipSeparator'] = [
        'label'      => esc_html__( 'Tooltip', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['tooltiptrigger'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Trigger', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'hover' => 'hover',
            'click' => 'click',
        ],
        'inline'      => true,
        'placeholder' => 'hover',
    ];
    $this->controls['tooltipposition'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Placement', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'top' => 'top',
            'bottom' => 'bottom',
            'left' => 'left',
            'right' => 'right',
        ],
        'inline'      => true,
        'placeholder' => 'bottom',
        'default' => 'bottom',
    ];
    $this->controls['tooltipYdistance'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Manual Y distance', 'bricks' ),
        'type' => 'number',
        'units'        => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--y-distance',
              'selector' => '',
            ],
        ],
        'placeholder' => '100%',
        'required' => [ 'tooltipposition', '=', [ 'top', 'bottom' ] ],
    ];
    $this->controls['tooltipXdistance'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Manual X distance', 'bricks' ),
        'type' => 'number',
        'units'        => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--x-distance',
              'selector' => '',
            ],
        ],
        'placeholder' => '100%',
        'required' => [ 'tooltipposition', '=', [ 'left', 'right' ] ],
    ];
    $this->controls['tooltipduration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Reveal duration', 'bricks' ),
        'type' => 'number',
        'unit'        => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--reveal-duration',
              'selector' => '',
            ],
        ],
        'placeholder' => '0.4s',
    ];
    $this->controls['tooltipbackground'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type' => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '.bc-image-hotspots__tooltip',
            ],
        ],
    ];
    $this->controls['tooltiptypography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type' => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '.bc-image-hotspots__tooltip',
            ],
        ],
    ];
    $this->controls['tooltipborder'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type' => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '.bc-image-hotspots__tooltip',
            ],
        ],
    ];
    $this->controls['tooltippadding'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Padding', 'bricks' ),
        'type' => 'spacing',
        'css'     => [
            [
              'property' => 'padding',
              'selector' => '.bc-image-hotspots__tooltip',
            ],
        ],
    ];
    $this->controls['arrowSeparator'] = [
        'label'      => esc_html__( 'Arrow', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['enablearrow'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Arrow', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'block' => 'enable',
            'none' => 'disable',
        ],
        'css'     => [
            [
              'property' => 'display',
              'selector' => '.bc-image-hotspots__tooltip::after',
            ],
        ],
        'inline'      => true,
        'placeholder' => 'enable',
    ];
    $this->controls['arrowbackground'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Arrow Color', 'bricks' ),
        'type' => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--bordercolor',
              'selector' => '.bc-image-hotspots__tooltip::after',
            ],
        ],
        'required' => [ 'enablearrow', '!=', 'none'],
    ];
  }
    
  public function render() {
    $settings = $this->settings;
    $tooltiptrigger = ! empty( $settings['tooltiptrigger'] ) ? $settings['tooltiptrigger'] : 'hover';
    $tooltipposition = ! empty( $settings['tooltipposition'] ) ? $settings['tooltipposition'] : 'bottom';

    if($tooltipposition == 'top'){
        $this->set_attribute( '_root', 'data-arrow', 'top' );
    }
    if($tooltipposition == 'bottom'){
        $this->set_attribute( '_root', 'data-arrow', 'bottom' );
    }
    if($tooltipposition == 'left'){
        $this->set_attribute( '_root', 'data-arrow', 'left' );
    }
    if($tooltipposition == 'right'){
        $this->set_attribute( '_root', 'data-arrow', 'right' );
    }

    if ( ! empty( $settings['link'] ) ) {
        $this->set_link_attributes( '_root', $settings['link'] );
        $root_tag = 'a';
    }else{
        $root_tag = 'div';
    }

    $this->set_attribute( '_root', 'class', 'bc-image-hotspots__hotspot' );
    $this->set_attribute( '_root', 'data-bc-hide', '' );
    $this->set_attribute( '_root', 'tabindex', 0);
    $this->set_attribute( '_root', 'data-type', "$tooltiptrigger");

    $output = "<$root_tag {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= "</$root_tag>";

	echo $output;
  }
}