<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Letter_Launcher extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'letter-launcher';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
  public $scripts      = ['letter_launcher'];

  public function get_label() {
    return esc_html__( 'Letter Launcher', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
			'hasDynamicData' => 'text',
      'default'        => esc_html__( 'Letter Launcher', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'HTML tag', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'h1' => 'h1',
				'h2' => 'h2',
				'h3' => 'h3',
				'h4' => 'h4',
				'h5' => 'h5',
				'h6' => 'h6',
        'p' => 'p',
        'span' => 'span',
        'custom' => 'custom',
			],
			'clearable'   => false,
			'inline'      => true,
			'placeholder' => 'h3',
			'default'     => 'h3',
		];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Link to', 'bricks' ),
      'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
      'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-letter-launcher__inner',
        ],
      ],
  ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];

    $this->controls['letteraltitude'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Letter altitude', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'placeholder' => '20px',
    ];

    $this->controls['letterrotation'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Letter rotation', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '-30',
    ];

    $this->controls['duration'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0.3s',
    ];

    $this->controls['staggervar'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stagger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.05',
    ];

    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['trigger'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
    ];

    $this->controls['start'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom',
    ];

    $this->controls['end'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'End', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'unset',
  ];

    $this->controls['delay'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.2',
    ];

    $this->controls['scrub'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scrub', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'false',
    ];

    $this->controls['toggleActions'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'toggleActions', 'bricks' ),
      'type' => 'text',
      'placeholder' => 'play none none none',
    ];

    $this->controls['triggerSeparator'] = [
      'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
      'type'       => 'separator',
    ];
  
    $this->controls['animationType'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Trigger on', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'Click' => 'Click',
        'Hover' => 'Hover',
      ],
      'inline' => true,
      'placeholder' => ' ',
    ];

    $this->controls['removescroll'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable on scroll', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
  
    $this->controls['classTriggerClick'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Click'],
    ];
    $this->controls['classTriggerHover'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Hover'],
    ];

    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '.bc-letter-launcher__inner .char',
        ],
      ],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'letter_launcher', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_letter_launcher.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $removescroll    = ! empty( $settings['removescroll'] ) ? $settings['removescroll'] : 0;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $end = ! empty( $settings['end'] ) ? $settings['end'] : 'unset';
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 0.3;
    $delay = ! empty( $settings['delay'] ) ? $settings['delay'] : 0.2;
    $staggervar = ! empty( $settings['staggervar'] ) ? $settings['staggervar'] : 0.05;
    $letterrotation = ! empty( $settings['letterrotation'] ) ? $settings['letterrotation'] : -30;
    $letteraltitude = ! empty( $settings['letteraltitude'] ) ? $settings['letteraltitude'] : 20;
    $trigger = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $scrub = ! empty( $settings['scrub'] ) ? $settings['scrub'] : 'false';
    $toggleActions = ! empty( $settings['toggleActions'] ) ? $settings['toggleActions'] : 'play none none none';

    $this->set_attribute( '_root', 'class', 'bc-letter-launcher' );
    $this->set_attribute( '_inner', 'class', 'bc-letter-launcher__inner' );
    $this->set_attribute( '_inner', 'class', 'bc-letter-launcher__inner--to-hide' );

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-letter-launcher__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( '_inner' )}
            data-start='{$start}'
            data-end='{$end}'
            data-duration='{$duration}'
            data-delayvar='{$delay}'
            data-staggervar='{$staggervar}'
            data-letterrotation='{$letterrotation}'
            data-letteraltitude='{$letteraltitude}'
            data-trigger='{$trigger}'
            data-scrub='{$scrub}'
            data-toggleActions='{$toggleActions}'
            data-disable-builder='{$disablebuilder}'
            data-animationType='{$animationType}'
            data-remove-scroll='{$removescroll}'
            data-classTriggerClick='{$classTriggerClick}'
            data-classTriggerHover='{$classTriggerHover}'
          >$inner_title</span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span {$this->render_attributes( '_inner' )}
          data-start='{$start}'
          data-end='{$end}'
          data-duration='{$duration}'
          data-delayvar='{$delay}'
          data-staggervar='{$staggervar}'
          data-letterrotation='{$letterrotation}'
          data-letteraltitude='{$letteraltitude}'
          data-trigger='{$trigger}'
          data-scrub='{$scrub}'
          data-toggleActions='{$toggleActions}'
          data-disable-builder='{$disablebuilder}'
          data-animationType='{$animationType}'
          data-remove-scroll='{$removescroll}'
          data-classTriggerClick='{$classTriggerClick}'
          data-classTriggerHover='{$classTriggerHover}'
        >$inner_title</span>
      </{$this->tag}>
      ";
    }

		echo $output;
  }
}

