<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_BC_Lottie extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'bclottie';
  public $icon         = 'fa-solid fa-circle-play';
  public $css_selector = '';
  public $scripts      = ['bclottie'];

  public function get_label() {
    return esc_html__( 'Lottie', 'bricks' );
  }

  public function set_controls() {
    $this->controls['source'] = [
      'tab'            => 'content',
      'type'           => 'text',
	  'hasDynamicData' => 'text',
      'placeholder'    => esc_html__( 'Source', 'bricks' ),
    ];

    $this->controls['width'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
              'css'     => [
          [
            'property' => 'width',
            'selector' => '',
          ],
        ],
        'placeholder'    => esc_html__( '350px', 'bricks' ),
        'inline' => true,
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['autoplay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Autoplay', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => true,
    ];

    $this->controls['loop'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Loop', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => true,
    ];

    $this->controls['speed'] = [
        'hasDynamicData' => false,
        'tab'     => 'content',
        'label'   => esc_html__( 'Speed', 'bricks' ),
        'type'    => 'text',
        'placeholder'    => esc_html__( '1', 'bricks' ),
        'inline' => true,
        'small' => true,
    ];

    $this->controls['note'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Autoplay must be disabled in order to apply a Custom Trigger', 'bricks' )))
    ];
    $this->controls['mode'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom Trigger', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'cursor' => 'cursor',
            'scroll' => 'scroll',
        ],
        'inline'      => true,
        'placeholder' => 'cursor',
        'default' => 'cursor',
    ];

    $this->controls['cursorSeparator'] = [
        'label'      => esc_html__( 'Cursor', 'bricks' ),
        'type'       => 'separator',
        'required' => [ 'mode', '=', 'cursor'],
    ];
    $this->controls['cursortype'] = [
        'tab'            => 'content',
        'label'          => esc_html__( 'Cursor Type', 'bricks' ),
        'type'           => 'select',
        'options'        => [
            'hover' => 'hover',
            'click' => 'click',
        ],
        'inline'      => true,
        'placeholder' => 'hover',
        'required' => [ 'mode', '=', 'cursor'],
    ];
    $this->controls['forceflag'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Force Flag', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => true,
        'required' => [ 'mode', '=', 'cursor'],
    ];

    $this->controls['scrollSeparator'] = [
        'label'      => esc_html__( 'Scroll', 'bricks' ),
        'type'       => 'separator',
        'required' => [ 'mode', '=', 'scroll'],
    ];
    $this->controls['scrolltype'] = [
        'tab'            => 'content',
        'label'          => esc_html__( 'Scroll Type', 'bricks' ),
        'type'           => 'select',
        'options'        => [
            'seek' => 'seek',
            'play' => 'play',
        ],
        'inline'      => true,
        'placeholder' => 'seek',
        'required' => [ 'mode', '=', 'scroll'],
    ];
    $this->controls['startvisibility'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Start Visibility', 'bricks' ),
        'type'    => 'text',
        'placeholder'    => esc_html__( '0', 'bricks' ),
        'inline' => true,
        'required' => [ 'mode', '=', 'scroll'],
    ];
    $this->controls['endvisibility'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'End Visibility', 'bricks' ),
        'type'    => 'text',
        'placeholder'    => esc_html__( '1', 'bricks' ),
        'inline' => true,
        'required' => [ 'mode', '=', 'scroll'],
    ];
    $this->controls['startframe'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Start Frame', 'bricks' ),
        'type'    => 'text',
        'placeholder'    => esc_html__( '0', 'bricks' ),
        'inline' => true,
        'required' => [ 'mode', '=', 'scroll'],
    ];
    $this->controls['endframe'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'End Frame', 'bricks' ),
        'type'    => 'text',
        'placeholder'    => esc_html__( '120', 'bricks' ),
        'inline' => true,
        'required' => [ 'mode', '=', 'scroll'],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bclottie', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_lottie.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'lottieplayer-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_lottie-player.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'lottieinteractivity-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_lottie-interactivity.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $source = ! empty( $settings['source'] ) ? $settings['source'] : 'https://lottie.host/2e337c0e-f196-4645-961f-fdb284b7d865/v8mS898Exa.json';
    $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : 1;

    $hayautoplay = 0;
    $autoplay = ! empty( $settings['autoplay'] ) ? $settings['autoplay'] : false;
    $autoplayaux = 'autoplay';
    if($autoplay == true){
        $autoplayaux = 'autoplay';
    }else{
        $autoplayaux = '';
        $hayautoplay = 1;
    }

    $loop = ! empty( $settings['loop'] ) ? $settings['loop'] : false;
    $loopaux = 'loop';
    if($loop == true){
        $loopaux = 'loop';
    }else{
        $loopaux = '';
    }

    $forceflag = ! empty( $settings['forceflag'] ) ? $settings['forceflag'] : false;
    $forceflagaux = 0;
    if($forceflag == true){
        $forceflagaux = 1;
    }else{
        $forceflagaux = 0;
    }

    $mode = ! empty( $settings['mode'] ) ? $settings['mode'] : 'cursor';

    $cursortype = ! empty( $settings['cursortype'] ) ? $settings['cursortype'] : 'hover';
    $scrolltype = ! empty( $settings['scrolltype'] ) ? $settings['scrolltype'] : 'seek';
    $type = $cursortype . '-' . $scrolltype;

    $startvisibility = ! empty( $settings['startvisibility'] ) ? $settings['startvisibility'] : 0;
    $endvisibility = ! empty( $settings['endvisibility'] ) ? $settings['endvisibility'] : 1;
    $startframe = ! empty( $settings['startframe'] ) ? $settings['startframe'] : 0;
    $endframe = ! empty( $settings['endframe'] ) ? $settings['endframe'] : 120;

    $this->set_attribute( '_root', 'class', "bc-lottie");
    $output = "<div {$this->render_attributes( '_root' )}>";

    $this->set_attribute( 'inner_lottie', 'src', "$source");
    $this->set_attribute( 'inner_lottie', 'speed', "$speed");
    $this->set_attribute( 'inner_lottie', 'data-hayautoplay', "$hayautoplay");
    $this->set_attribute( 'inner_lottie', 'data-mode', "$mode");
    $this->set_attribute( 'inner_lottie', 'data-type', "$type");
    $this->set_attribute( 'inner_lottie', 'data-startvisibility', "$startvisibility");
    $this->set_attribute( 'inner_lottie', 'data-endvisibility', "$endvisibility");
    $this->set_attribute( 'inner_lottie', 'data-startframe', "$startframe");
    $this->set_attribute( 'inner_lottie', 'data-endframe', "$endframe");
    $this->set_attribute( 'inner_lottie', 'data-forceflag', "$forceflagaux");

    $output .=
    "
    <lottie-player $autoplayaux $loopaux class='bc-lottie__element bc-lottie__to-hide' {$this->render_attributes( 'inner_lottie' )}></lottie-player>
    ";

    $output .= '</div>';

	echo $output;
  }
}

