<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Mask_Hover extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'mask-hover';
  public $icon         = 'ti-layout-media-center';
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Mask Hover', 'bricks' );
  }

  public function set_controls() {
    $this->controls['note'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'NOTE: <br>Visible content must be placed inside "Content" element. Mask content must be placed at the "Mask content" element. <br>Their styles can be applied right at them.', 'bricks' )))
    ];
    $this->controls['openAtBuilder'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Open mask at Bricks', 'bricks' ),
      'type'        => 'checkbox',
      'inline' => true,
      'small' => true,
    ];
    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Mask Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['maskcolor'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Mask color', 'bricks' ),
      'type'    => 'color',
      'css'     => [
        [
          'property' => 'background',
          'selector' => '.bc-mask-hover__content-wrapper',
        ],
      ],
  ];
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['type'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'fromTop' => 'From top',
          'fromCenter' => 'From center',
          'fromBottom' => 'From bottom',
      ],
      'inline'      => true,
      'small'      => true,
      'placeholder' => 'From center',
    ];
    $this->controls['duration'] = [
        'tab'     => 'content',
        'inline'    => true,
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
          [
            'property' => '--duration',
            'selector' => '',
          ],
        ],
        'placeholder'    => '0.6s',
    ];
    $this->controls['easing'] = [
        'tab'     => 'content',
        'inline'    => true,
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'css'     => [
          [
            'property' => '--easing',
            'selector' => '',
          ],
        ],
        'placeholder'    => 'cubic-bezier(.165,.84,.44,1)',
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
              '_hidden'         => [
                    '_cssClasses' => 'bc-mask-hover__content',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Heading', 'bricks' ),
                        'tag'  => 'h3',
                        '_hidden' => [
                            '_cssClasses' => 'bc-mask-hover__title',
                        ],
                    ],
                ]
            ],
        ],

        [
            'name'     => 'block',
            'label'    => esc_html__( 'Mask Content', 'bricks' ),
            'settings' => [
              '_hidden'         => [
                    '_cssClasses' => 'bc-mask-hover__content-wrapper',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Mask Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Mask Heading', 'bricks' ),
                        'tag'  => 'h3',
                        '_hidden' => [
                            '_cssClasses' => 'bc-mask-hover__title',
                        ],
                    ],
                ]
            ],
        ],
    ];
  }

  public function render() {
    $settings = $this->settings;
    $openAtBuilder = ! empty( $settings['openAtBuilder'] ) ? $settings['openAtBuilder'] : 0;
    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'fromCenter';

    $this->set_attribute( '_root', 'class', 'bc-mask-hover' );
    $this->set_attribute( '_root', 'data-openAtBuilder', $openAtBuilder );
    $this->set_attribute( '_root', 'data-type', $type );

    $output = "<div {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= '</div>';

	echo $output;
  }
}

