<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Microbox_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'microboxbutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['microbox_button'];

  public function get_label() {
    return esc_html__( 'Microbox Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Microbox Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-microbox-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-microbox-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-microbox-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-microbox-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-microbox-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-microbox-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-microbox-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-microbox-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['whitespace'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'White space', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'wrap' => 'wrap',
          'nowrap' => 'nowrap',
      ],
      'inline'      => true,
      'css'     => [
          [
            'property' => 'white-space',
            'selector' => '',
          ],
        ],
      'placeholder'        => 'wrap',
  ];
    $this->controls['typography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '&{pseudo} .bc-microbox-button__title',
            ],
        ],
    ];
    $this->controls['buttonbackground'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Button background', 'bricks' ),
        'type'        => 'background',
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-microbox-button__square',
            ],
        ],
    ];
    $this->controls['squarebackground'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Squares background', 'bricks' ),
        'type'        => 'background',
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-microbox-button__grid',
            ],
        ],
    ];
    $this->controls['border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '',
            ],
          ],
    ];
    $this->controls['multiplydimensions'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Scale dimensions', 'bricks' ),
      'type'        => 'text',
      'inline'        => true,
      'small'        => true,
      'css'     => [
          [
            'property' => '--multiply',
            'selector' => '',
          ],
        ],
        'placeholder' => '0.75',
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['induration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'In duration', 'bricks' ),
        'type'        => 'text',
        'inline'        => true,
        'small'        => true,
        'placeholder' => '500',
    ];
    $this->controls['outduration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Out duration', 'bricks' ),
        'type'        => 'text',
        'inline'        => true,
        'small'        => true,
        'placeholder' => '1200',
    ];
    $this->controls['stagger'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Stagger', 'bricks' ),
        'type'        => 'text',
        'inline'        => true,
        'small'        => true,
        'placeholder' => '200',
    ];
    $this->controls['autoplay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Autoplay', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
    ];
    $this->controls['loop'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Loop', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc-animejs', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_anime.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'bcmicroboxbutton', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_microbox_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $autoplay = ! empty( $settings['autoplay'] ) ? $settings['autoplay'] : false;
    $autoplayaux = 0;
    if($autoplay == true){
        $autoplayaux = 1;
    }else{
        $autoplayaux = 0;
    }

    $loop = ! empty( $settings['loop'] ) ? $settings['loop'] : false;
    $loopaux = 0;
    if($loop == true){
        $loopaux = 1;
    }else{
        $loopaux = 0;
    }

    $induration = ! empty( $settings['induration'] ) ? $settings['induration'] : 500;
    $outduration = ! empty( $settings['outduration'] ) ? $settings['outduration'] : 1200;
    $stagger = ! empty( $settings['stagger'] ) ? $settings['stagger'] : 200;

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-microbox-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-microbox-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'bc-microbox-button' );
    $this->set_attribute( '_root', 'data-induration', "$induration");
    $this->set_attribute( '_root', 'data-outduration', "$outduration");
    $this->set_attribute( '_root', 'data-stagger', "$stagger");
    $this->set_attribute( '_root', 'data-autoplay', "$autoplayaux");
    $this->set_attribute( '_root', 'data-loop', "$loopaux");

    $output = "<$root_tag {$this->render_attributes( '_root' )}>
    <div class='bc-microbox-button__grid'>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
      <div class='bc-microbox-button__square' style='transform: scale(1);'></div>
    </div>
    <span class='bc-microbox-button__title'>$leftIcon$inner_title$rightIcon</span>
    ";

    $output .= "</$root_tag>";

	echo $output;
  }
}