<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Multi_Offcanvas_Menu extends \Bricks\Element {
  public $category     = 'Next Bricks - Menus';
  public $name         = 'multioffcanvasmenu';
  public $icon         = 'ti-menu-alt';
  public $tag      = 'div';
  public $scripts      = ['multioffcanvasmenu'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Multi OffCanvas Menu', 'bricks' );
  }

  public function set_controls() {  
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'section' => 'section',
          'nav' => 'nav',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];  
    $this->controls['slidetype'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'fromRight' => 'From Right',
        'fromLeft' => 'From Left',
      ],
      'inline'      => true,
      'placeholder' => 'From Right',
      'default' => 'fromRight',
    ];
    $this->controls['slideduration'] = [
        'label'       => esc_html__( 'Duration', 'bricks' ),
        'type'        => 'number',
        'unit'        => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--slide-duration',
              'selector' => '',
            ],
          ],
        'placeholder' => '1s',
    ];
    $this->controls['slideeasing'] = [
        'label'       => esc_html__( 'CSS Easing', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--slide-easing',
              'selector' => '',
            ],
          ],
        'placeholder' => 'cubic-bezier(.33,1,.68,1)',
    ];
    $this->controls['openbuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Open at the builder', 'bricks' ),
      'type'     => 'checkbox',
    ];

    $this->controls['separator'] = [
      'description' => sprintf(html_entity_decode(esc_html__( '<br>All elements with this class will toggle the menu alongside all the Burgers inside the menu.', 'bricks' ))),
      'type'       => 'separator',
    ];
    $this->controls['customtoggle'] = [
      'label'       => esc_html__( 'Custom Toggle', 'bricks' ),
      'type'        => 'text',
      'placeholder' => '.bc-core-burguer',
    ];
    $this->controls['lockBodyScrollingSeparator'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'If true, Custom Toggle will lock body scrolling on click.', 'bricks' )))
  ];
    $this->controls['lockBodyScrolling'] = [
      'label' => esc_html__( 'Lock body scrolling', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'OffCanvas Content Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['__width'] = [
      'label'       => esc_html__( 'Width', 'bricks' ),
      'type'        => 'number',
      'units'      => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => '--width',
            'selector' => '',
          ],
      ],
      'placeholder' => '50vw',
    ];
    $this->controls['height'] = [
        'label'       => esc_html__( 'Height', 'bricks' ),
        'type'        => 'number',
        'units'      => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => 'height',
              'selector' => '.bc-multi-offcanvas-menu__items-wrapper',
            ],
        ],
        'placeholder' => '100vh',
    ];
    $this->controls['padding'] = [
        'label'       => esc_html__( 'Padding', 'bricks' ),
        'type'        => 'spacing',
        'css'     => [
            [
              'property' => 'padding',
              'selector' => '.bc-multi-offcanvas-menu__items-wrapper',
            ],
        ],
    ];
    $this->controls['background'] = [
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--background',
              'selector' => '.bc-multi-offcanvas-menu__items-wrapper',
            ],
        ],
    ];
    $this->controls['border'] = [
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '.bc-multi-offcanvas-menu__items-wrapper',
            ],
        ],
    ];
    $this->controls['boxShadow'] = [
        'label'       => esc_html__( 'Box shadow', 'bricks' ),
        'type'        => 'box-shadow',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'box-shadow',
              'selector' => '.bc-multi-offcanvas-menu__items-wrapper',
            ],
        ],
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Backdrop Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['backdropduration'] = [
      'label'       => esc_html__( 'Duration', 'bricks' ),
      'type'        => 'number',
      'unit'      => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--transition-duration-backdrop',
            'selector' => '',
          ],
        ],
      'placeholder' => '1',
    ];
    $this->controls['backdropeasing'] = [
        'label'       => esc_html__( 'CSS Easing', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--transition-easing-backdrop',
              'selector' => '',
            ],
        ],
        'placeholder' => 'linear',
    ];

    $this->controls['accessibilitySeparator'] = [
      'label'      => esc_html__( 'Accessibility', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['closeOnEsc'] = [
      'label' => esc_html__( 'Close when pressing ESC key', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];
  }
  
/*Render children*/
public function get_nestable_children() {
return [
    [
      'name'     => 'coreburguer',
      'label'    => esc_html__( 'Opening Burger', 'bricks' ),
      'settings' => [
        '_hidden' => [
            '_cssClasses' => 'bc-core-burguer--multi-offcanvas-menu',
        ],
      ],
    ],

    [
      'name'     => 'block',
      'label'    => esc_html__( 'OffCanvas', 'bricks' ),
      'settings' => [
        '_hidden'  => [
            '_cssClasses' => 'bc-multi-offcanvas-menu__items-wrapper',
        ],
      ],
      'children' => [
      [
        'name'     => 'coreburguer',
        'label'    => esc_html__( 'Closing Burger', 'bricks' ),
        'settings' => [
          '_hidden' => [
              '_cssClasses' => 'bc-core-burguer--multi-offcanvas-menu',
          ],
        ],
      ],
      [
          'name'     => 'swap-hover',
      ],
      [
          'name'     => 'swap-hover',
      ],
      [
          'name'     => 'swap-hover',
      ],
      [
        'name'     => 'suboffcanvas',
        'children' => [
          [
            'name'     => 'swap-hover',
          ],
        ],
      ],
      ],
    ],

    [
      'name'     => 'block',
      'label'    => esc_html__( 'Backdrop', 'bricks' ),
      'settings' => [
        '_hidden'  => [
            '_cssClasses' => 'bc-multi-offcanvas-menu__backdrop',
        ],
      ],
    ],
];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'multioffcanvas-menu-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_multioffcanvas.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $openbuilder = ! empty( $settings['openbuilder'] ) ? $settings['openbuilder'] : 0;
    $slidetype = ! empty( $settings['slidetype'] ) ? $settings['slidetype'] : 'fromRight';
    $customtoggle = ! empty( $settings['customtoggle'] ) ? $settings['customtoggle'] : '';
    $lockBodyScrolling = ! empty( $settings['lockBodyScrolling'] ) ? $settings['lockBodyScrolling'] : 0;
    $closeOnEsc = ! empty( $settings['closeOnEsc'] ) ? $settings['closeOnEsc'] : 0;

    $this->set_attribute( '_root', 'class', 'bc-core-menu' );
    $this->set_attribute( '_root', 'class', 'bc-multi-offcanvas-menu' );

    $data_classtype = '';
    if($slidetype === 'fromRight'){
      $data_classtype = 'bc-multi-offcanvas-menu--fromright';
    }else if($slidetype === 'fromLeft'){
      $data_classtype = 'bc-multi-offcanvas-menu--fromleft';
    }

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
        data-type='{$slidetype}'
        data-customtoggle='{$customtoggle}'
        data-customtoggle-lock-body-scrolling='{$lockBodyScrolling}'
        data-open-builder='{$openbuilder}'
        data-close-on-esc='{$closeOnEsc}'
        data-classtype='{$data_classtype}'>";
    $output .= Frontend::render_children( $this ); //Menu items
    $output .= "</{$this->tag}>";

    echo $output;
  }
}