<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Neumorphic_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'neumorphicbutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Neumorphic Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Neumorphic Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-neumorphic-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-neumorphic-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-neumorphic-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-neumorphic-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-neumorphic-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-neumorphic-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-neumorphic-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-neumorphic-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['whitespace'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'White space', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'wrap' => 'wrap',
          'nowrap' => 'nowrap',
      ],
      'inline'      => true,
      'css'     => [
          [
            'property' => 'white-space',
            'selector' => '',
          ],
        ],
      'placeholder'        => 'wrap',
    ];
    $this->controls['padding'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Padding', 'bricks' ),
        'type'        => 'spacing',
        'css'     => [
            [
              'property' => 'padding',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['typography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['leftcolor'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Left corner color', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--right-color',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['rightcolor'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Right corner color', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--left-color',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['spread'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Spread', 'bricks' ),
        'type'        => 'number',
        'units'      => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--spread',
              'selector' => '',
            ],
        ],
        'placeholder' => '2px',
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['duration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Duration', 'bricks' ),
        'type'        => 'number',
        'unit'      => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--duration',
              'selector' => '',
            ],
        ],
        'placeholder' => '0.3s',
    ];
    $this->controls['easing'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'CSS Easing', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--ease',
              'selector' => '',
            ],
        ],
        'placeholder' => 'ease-in-out',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-neumorphic-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-neumorphic-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'bc-neumorphic-button' );

    $output = "
    <$root_tag {$this->render_attributes( '_root' )}>
      <span class='bc-neumorphic-button__title'>$leftIcon$inner_title$rightIcon</span>
    </$root_tag>
    ";

	echo $output;
  }
}