<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Offcanvas_Menu extends \Bricks\Element {
  public $category     = 'Next Bricks - Menus';
  public $name         = 'offcanvasmenu';
  public $icon         = 'ti-menu-alt';
  public $tag      = 'div';
  public $scripts      = ['offcanvasmenu'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'OffCanvas Menu', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'section' => 'section',
          'nav' => 'nav',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['slidetype'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'fromLeft' => 'From Left',
        'fromRight' => 'From Right',
        'fromTop' => 'From Top',
      ],
      'inline'      => true,
      'placeholder' => 'From Top',
      'default' => 'fromLeft',
    ];
    $this->controls['slideduration'] = [
        'label'       => esc_html__( 'Duration', 'bricks' ),
        'type'        => 'number',
        'unit'      => 's',
        'inline'      => true,
        'placeholder' => '1s',
    ];
    $this->controls['slideeasing'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps'
        ],
        'inline' => true,
        'placeholder' => 'power2',
    ];
    $this->controls['openbuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Open at the builder', 'bricks' ),
      'type'     => 'checkbox',
    ];

    $this->controls['separator'] = [
      'description' => sprintf(html_entity_decode(esc_html__( '<br>All elements with this class will toggle the menu alongside all the Burgers inside the menu.', 'bricks' ))),
      'type'       => 'separator',
    ];
    $this->controls['customtoggle'] = [
      'label'       => esc_html__( 'Custom Toggle', 'bricks' ),
      'type'        => 'text',
      'placeholder' => '.bc-core-burger',
    ];
    $this->controls['lockBodyScrollingSeparator'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'If true, Custom Toggle will lock body scrolling on click.', 'bricks' )))
  ];
    $this->controls['lockBodyScrolling'] = [
      'label' => esc_html__( 'Lock body scrolling', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Backdrop Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['backdropduration'] = [
      'label'       => esc_html__( 'Duration', 'bricks' ),
      'type'        => 'number',
      'unit'      => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--transition-duration-backdrop',
            'selector' => '',
          ],
        ],
      'placeholder' => '1',
    ];
    $this->controls['backdropeasing'] = [
        'label'       => esc_html__( 'Easing', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--transition-easing-backdrop',
              'selector' => '',
            ],
        ],
        'placeholder' => 'linear',
    ];

    $this->controls['accessibilitySeparator'] = [
      'label'      => esc_html__( 'Accessibility', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['closeOnEsc'] = [
      'label' => esc_html__( 'Close when pressing ESC key', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => true,
    ];
  }
  
/*Render children*/
public function get_nestable_children() {
return [
    [
      'name'     => 'coreburguer',
      'label'    => esc_html__( 'Opening Burger', 'bricks' ),
      'settings' => [
        '_hidden' => [
            '_cssClasses' => 'bc-core-burguer--offcanvas-menu',
        ],
      ],
    ],

    [
      'name'     => 'block',
      'label'    => esc_html__( 'OffCanvas Content', 'bricks' ),
      'settings' => [
        '_hidden'  => [
            '_cssClasses' => 'bc-offcanvas-menu__items-wrapper',
        ],
      ],
      'children' => [
      [
        'name'     => 'coreburguer',
        'label'    => esc_html__( 'Closing Burger', 'bricks' ),
        'settings' => [
          '_hidden' => [
              '_cssClasses' => 'bc-core-burguer--offcanvas-menu',
          ],
        ],
      ],
      [
          'name'     => 'swap-hover',
      ],
      [
          'name'     => 'swap-hover',
      ],
      [
          'name'     => 'swap-hover',
      ],
      ],
    ],

    [
      'name'     => 'block',
      'label'    => esc_html__( 'Backdrop', 'bricks' ),
      'settings' => [
        '_hidden'  => [
            '_cssClasses' => 'bc-offcanvas-menu__backdrop',
        ],
      ],
    ],
];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'offcanvas-menu-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_offcanvas_menu.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $openbuilder = ! empty( $settings['openbuilder'] ) ? $settings['openbuilder'] : 0;
    $slidetype = ! empty( $settings['slidetype'] ) ? $settings['slidetype'] : 'From Top';
    $slideduration = ! empty( $settings['slideduration'] ) ? $settings['slideduration'] : 1;
    $slideeasing = ! empty( $settings['slideeasing'] ) ? $settings['slideeasing'] : 'power2.out';
    $customtoggle = ! empty( $settings['customtoggle'] ) ? $settings['customtoggle'] : '';
    $lockBodyScrolling = ! empty( $settings['lockBodyScrolling'] ) ? $settings['lockBodyScrolling'] : 0;
    $closeOnEsc = ! empty( $settings['closeOnEsc'] ) ? $settings['closeOnEsc'] : 0;

    $this->set_attribute( '_root', 'class', 'bc-core-menu' );
    $this->set_attribute( '_root', 'class', 'bc-offcanvas-menu' );

    if($slidetype === 'fromTop'){
      $this->set_attribute( '_root', 'data-classtype', 'bc-offcanvas-menu--fromtop' );
    }else if($slidetype === 'fromLeft'){
      $this->set_attribute( '_root', 'data-classtype', 'bc-offcanvas-menu--fromleft' );
    }else if($slidetype === 'fromRight'){
      $this->set_attribute( '_root', 'data-classtype', 'bc-offcanvas-menu--fromright' );
    }

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
    data-hide-content='true'
    data-type='{$slidetype}'
    data-duration='{$slideduration}'
    data-easing='{$slideeasing}'
    data-customtoggle='{$customtoggle}'
    data-customtoggle-lock-body-scrolling='{$lockBodyScrolling}'
    data-open-builder='{$openbuilder}'data-close-on-esc='{$closeOnEsc}'>";
    $output .= Frontend::render_children( $this ); //Menu items
    $output .= "</{$this->tag}>";

    echo $output;
  }
}