<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Parallax extends \Bricks\Element {
  public $category     = 'Next Bricks - Medias';
  public $name         = 'parallax';
  public $icon         = 'fa-regular fa-clone';
  public $scripts      = ['parallax'];

  public function get_label() {
    return esc_html__( 'Parallax', 'bricks' );
  }

  public function set_controls() {
    $this->controls['image'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Image', 'bricks' ),
        'type' => 'image',
    ];
    $this->controls['alt'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Alt text', 'bricks' ),
        'type' => 'text',
        'inline' => true,
    ];
    $this->controls['_objectFit'] = [
      'label'   => esc_html__( 'Object fit', 'bricks' ),
      'type'    => 'select',
      'inline'  => true,
      'options' => $this->control_options['objectFit'],
      'css' => [
        [
          'property' => 'object-fit',
          'selector' => '.bc-parallax__element',
        ],
      ],
    ];
    $this->controls['_objectPosition'] = [
      'tab' => 'content',
      'label'  => esc_html__( 'Object position', 'bricks' ),
      'type'   => 'text',
      'inline' => true,
      'dd'     => false,
      'css' => [
        [
          'property' => 'object-position',
          'selector' => '.bc-parallax__element',
        ],
      ],
    ];
    $this->controls['imageFilters'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Filters', 'bricks' ),
      'type' => 'filters',
      'inline' => true,
      'css' => [
        [
          'property' => 'filter',
          'selector' => '.bc-parallax__element',
        ],
      ],
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '', /*el hijo y su wrapper*/
          ]
        ],
        'placeholder' => 'auto',
    ];
    $this->controls['height'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Height', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'height',
          'selector' => '', /*el hijo y su wrapper*/
        ]
      ],
      'placeholder' => 'auto',
  ];
    $this->controls['parallaxSeparator'] = [
      'label'      => esc_html__( 'Parallax', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
    $this->controls['disabletouchdevices'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at touch devices', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
    $this->controls['orientation'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Orientation', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'down' => 'down',
            'right' => 'right',
            'up' => 'up',
            'left' => 'left',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'down',
    ];
    $this->controls['scale'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scale', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1.2',
    ];
    $this->controls['overflow'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Overflow', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'true' => 'true',
            'false' => 'false',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'true',
    ];
    $this->controls['delay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1.6',
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'CSS Easing', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'cubic-bezier(0,0,0,1)',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'parallax', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_parallax.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'parallax-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_simpleparallax.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $width = 0;
    $height = 0;
    
    // Render dynamic data
    if (isset($settings['image']['useDynamicData'])) {
        $images = $this->render_dynamic_data_tag($settings['image']['useDynamicData'], 'image');
        if (!empty($images) && isset($images[0])) {
            $last_image = wp_get_attachment_url($images[0]);
            $attachment_id = attachment_url_to_postid($last_image);
            $image_metadata = wp_get_attachment_metadata($attachment_id);
            
            $width = isset($image_metadata['width']) ? $image_metadata['width'] : 0;
            $height = isset($image_metadata['height']) ? $image_metadata['height'] : 0;
        }
    }
    // Render normal image
    else if (isset($settings['image']['url'])) {
        $last_image = $settings['image']['url'];
        $image_dimensions = @getimagesize($last_image);
        
        if ($image_dimensions !== false) {
            $width = $image_dimensions[0];
            $height = $image_dimensions[1];
        }
    }
    // Render default
    else {
        $last_image = 'https://images.pexels.com/photos/17050728/pexels-photo-17050728/free-photo-of-madera-carretera-paisaje-agua.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1';
        $image_dimensions = @getimagesize($last_image);
        
        if ($image_dimensions !== false) {
            $width = $image_dimensions[0];
            $height = $image_dimensions[1];
        }
    }

    // Si no se pudieron obtener dimensiones, usar valores por defecto
    if ($width === 0 || $height === 0) {
        $width = 1260;  // dimensión por defecto
        $height = 750;  // dimensión por defecto
    }

    $disablebuilder = !empty($settings['disablebuilder']) ? $settings['disablebuilder'] : 0;
    $disabletouchdevices = !empty($settings['disabletouchdevices']) ? $settings['disabletouchdevices'] : 0;
    $alt = !empty($settings['alt']) ? "alt='{$settings['alt']}'" : '';
    $orientation = !empty($settings['orientation']) ? $settings['orientation'] : 'down';
    $scale = !empty($settings['scale']) ? $settings['scale'] : 1.2;
    $overflow = !empty($settings['overflow']) ? $settings['overflow'] : 'true';
    $delay = !empty($settings['delay']) ? $settings['delay'] : 1.6;
    $ease = !empty($settings['ease']) ? $settings['ease'] : 'cubic-bezier(0,0,0,1)';

    $this->set_attribute('_image', 'data-disable-builder', $disablebuilder);
    $this->set_attribute('_image', 'data-disable-touch-devices', $disabletouchdevices);
    $this->set_attribute('_image', 'data-orientation', $orientation);
    $this->set_attribute('_image', 'data-scale', $scale);
    $this->set_attribute('_image', 'data-overflow', $overflow);
    $this->set_attribute('_image', 'data-delay', $delay);
    $this->set_attribute('_image', 'data-ease', $ease);

    $this->set_attribute('_root', 'class', 'bc-parallax');

    if (strpos($last_image, 'cloudinary.com') !== false) {
      $src_decoding = 'decoding="async"';
    } else {
        $src_decoding = '';
    }

    $output = "<div {$this->render_attributes('_root')}>
    <img class='bc-parallax__element bc-parallax__to-hide' src='$last_image' width='$width' height='$height' $alt {$this->render_attributes('_image')} $src_decoding>";
    $output .= '</div>';

    echo $output;
}

}