<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Prism_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'prismbutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['prismbutton'];

  public function get_label() {
    return esc_html__( 'Prism Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['whitespace'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'White space', 'bricks' ),
      'type'        => 'select',
      'inline'      => true,
      'options'     => [
          'wrap' => 'wrap',
          'nowrap' => 'nowrap',
      ],
      'css'     => [
          [
            'property' => 'white-space',
            'selector' => '',
          ],
        ],
      'placeholder'        => 'nowrap',
    ];
    $this->controls['padding'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Padding', 'bricks' ),
        'type'        => 'spacing',
        'css'     => [
            [
              'property' => '--padding-prism',
              'selector' => '',
            ],
        ],
        'placeholder'     => [
          'top' => 10,
          'bottom' => 10,
          'left' => 10,
          'right' => 10,
        ],
    ];
    $this->controls['font_size'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Font size', 'bricks' ),
        'type'        => 'number',
        'units'      => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--font-size',
              'selector' => '',
            ],
        ],
        'placeholder'        => '27px',
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['from'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'From', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'data-from-top' => 'top',
          'data-from-bottom' => 'bottom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'top',
    ];
    $this->controls['perspective'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Perspective', 'bricks' ),
      'type'        => 'number',
      'units'      => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => '--perspective',
            'selector' => '',
          ],
      ],
      'placeholder'        => '1000px',
    ];
    $this->controls['transition_duration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Transition duration', 'bricks' ),
        'type'        => 'number',
        'unit'      => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--transition-duration',
              'selector' => '',
            ],
          ],
        'placeholder'        => '0.25s',
    ];
    $this->controls['easing'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'CSS Easing', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--ease',
            'selector' => '',
          ],
        ],
      'placeholder'        => 'cubic-bezier(0.645, 0.045, 0.355, 1)',
    ];

    $this->controls['frontSeparator'] = [
        'label'      => esc_html__( 'Front', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['front_inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Prism Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Prism Button', 'bricks' ),
    ];
    $this->controls['front_typography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '&{pseudo} .bc-prism-button__front-text',
            ],
        ],
        'exclude' => [
          'font-size',
          'line-height',
        ],
    ];
    $this->controls['front_background'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-prism-button__front-text',
            ],
        ],
    ];
    $this->controls['front_border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '&{pseudo} .bc-prism-button__front-text',
            ],
        ],
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-prism-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-prism-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-prism-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-prism-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-prism-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-prism-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-prism-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-prism-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['backSeparator'] = [
        'label'      => esc_html__( 'Back', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['back_inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Button Prism', 'bricks' ),
        'placeholder'    => esc_html__( 'Button Prism', 'bricks' ),
    ];
    $this->controls['back_typography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '&{pseudo} .bc-prism-button__back-text',
            ],
        ],
        'exclude' => [
          'font-size',
          'line-height',
        ],
    ];
    $this->controls['back_background'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-prism-button__back-text',
            ],
        ],
    ];
    $this->controls['back_border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '&{pseudo} .bc-prism-button__back-text',
            ],
        ],
    ];
    $this->controls['backIncludeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['backLeftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-prism-button__left-icon--back',
        ],
      ],
      'required'   => [ 'backIncludeLeftIcon', '=', true ],
    ];
    $this->controls['backLeftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-prism-button__left-icon--back',
        ],
      ],
      'required' => [ 'backIncludeLeftIcon', '=', true ],
    ];
    $this->controls['backLeftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-prism-button__left-icon--back',
        ],
      ],
      'required' => [ 'backIncludeLeftIcon', '=', true ],
    ];
    $this->controls['backLeftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-prism-button__left-icon--back',
        ],
      ],
      'required' => [ 'backIncludeLeftIcon', '=', true ],
    ];
    $this->controls['backIncludeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['backRightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-prism-button__right-icon--back',
        ],
      ],
      'required'   => [ 'backIncludeRightIcon', '=', true ],
    ];
    $this->controls['backRightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-prism-button__right-icon--back',
        ],
      ],
      'required' => [ 'backIncludeRightIcon', '=', true ],
    ];
    $this->controls['backRightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-prism-button__right-icon--back',
        ],
      ],
      'required' => [ 'backIncludeRightIcon', '=', true ],
    ];
    $this->controls['backRightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-prism-button__right-icon--back',
        ],
      ],
      'required' => [ 'backIncludeRightIcon', '=', true ],
    ];
  }

  public function render() {
    $settings = $this->settings;
    $front_inner_title    = ! empty( $settings['front_inner_title'] ) ? $settings['front_inner_title'] : 'Prism Button';
    $back_inner_title    = ! empty( $settings['back_inner_title'] ) ? $settings['back_inner_title'] : 'Button Prism';
    $from    = ! empty( $settings['from'] ) ? $settings['from'] : 'data-from-top';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }
    
    // Store data attribute for later use
    $data_from_attribute = '';
    if (  $from == 'data-from-top' ) {
      $data_from_attribute = 'data-from-top';
    }else if (  $from == 'data-from-bottom' ) {
      $data_from_attribute = 'data-from-bottom';
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-prism-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-prism-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $backIncludeLeftIcon = ! empty( $settings['backIncludeLeftIcon'] ) ? $settings['backIncludeLeftIcon'] : 0;
    $backIncludeRightIcon = ! empty( $settings['backIncludeRightIcon'] ) ? $settings['backIncludeRightIcon'] : 0;
    if ( $backIncludeLeftIcon !== 0 ) {
      $backLeftIcon = self::render_icon( $settings['backLeftIcon'], [ 'bc-prism-button__left-icon--back' ] );
    }else{
      $backLeftIcon = '';
    }
    if ( $backIncludeRightIcon !== 0 ) {
      $backRightIcon = self::render_icon( $settings['backRightIcon'], [ 'bc-prism-button__right-icon--back' ] );
    }else{
      $backRightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'bc-prism-button' );

    $output = "
    <$root_tag {$this->render_attributes( '_root' )}" . ($data_from_attribute ? " {$data_from_attribute}" : "") . ">
        <div class='bc-prism-button__wrapper'>
            <span class='bc-prism-button__front-text'>$leftIcon$front_inner_title$rightIcon</span>
            <span class='bc-prism-button__back-text'>$backLeftIcon$back_inner_title$backRightIcon</span>
        </div>
    </$root_tag>
    ";

	echo $output;
  }
}