<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_ScribbleChild extends \Bricks\Element {
  public $name         = 'scribblechild';
  public $icon         = 'ti-text';
  public $nestable     = true;
  public $scripts      = ['scribbletitle'];

  public function get_label() {
    return esc_html__( 'Scribble', 'bricks' );
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Example', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
          [
            'property' => 'typography',
            'selector' => '',
          ],
        ],
    ];

    $this->controls['scribbleSeparator'] = [
        'label'      => esc_html__( 'Scribble', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['strokewidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stroke Width', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'placeholder' => '75px',
        'css'     => [
            [
              'property' => 'stroke-width',
              'selector' => '.bc-scribble-title__svg path',
            ],
        ],
    ];

    $this->controls['strokecolor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stroke Color', 'bricks' ),
        'type' => 'color',
        'inline' => true,
        'css'     => [
            [
              'property' => 'stroke',
              'selector' => '.bc-scribble-title__svg path',
            ],
        ],
    ];

    $this->controls['linewidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'placeholder' => '100%',
        'css'     => [
            [
              'property' => 'width',
              'selector' => '.bc-scribble-title__svg',
            ],
        ],
    ];

    $this->controls['linetop'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Top Distance', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'placeholder' => '60%',
        'css'     => [
            [
              'property' => 'top',
              'selector' => '.bc-scribble-title__svg',
            ],
        ],
    ];

    $this->controls['lineleft'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Left Distance', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'placeholder' => '0',
        'css'     => [
            [
              'property' => 'left',
              'selector' => '.bc-scribble-title__svg',
            ],
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
    ];

    $this->controls['scribbletype'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'Basic' => 'Basic',
            'Stacked1' => 'Stacked A',
            'Stacked2' => 'Stacked B',
            'Stacked3' => 'Stacked C',
            'Scratch1' => 'Scratch A',
            'Scratch2' => 'Scratch B',
            'Scratch3' => 'Scratch C',
            'Signature' => 'Signature',
            'Circle' => 'Circle',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'Scratch A',
    ];

    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '1.3s',
        'css'     => [
            [
              'property' => '--svg-duration',
              'selector' => '.bc-scribble-title__svg',
            ],
        ],
    ];

    $this->controls['easing'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'CSS Easing', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'cubic-bezier(0.65,0,0.35,1)',
        'css'     => [
            [
              'property' => '--svg-easing',
              'selector' => '.bc-scribble-title__svg',
            ],
        ],
    ];

    $this->controls['scrolltrigger'] = [
        'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
        'type'       => 'separator',
        'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['start'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom',
    ];

    $this->controls['replay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Replay on enter back', 'bricks' ),
        'type'     => 'checkbox',
    ];

    $this->controls['triggerSeparator'] = [
        'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['animationType'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Trigger on', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'Click' => 'Click',
            'Hover' => 'Hover',
        ],
        'inline' => true,
        'placeholder' => ' ',
    ];

    $this->controls['classTriggerClick'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Element', 'bricks' ),
        'type' => 'text',
        'placeholder' => '.className',
        'inline' => true,
        'required' => [ 'animationType', '=', 'Click'],
    ];
    $this->controls['classTriggerHover'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Element', 'bricks' ),
        'type' => 'text',
        'placeholder' => '.className',
        'inline' => true,
        'required' => [ 'animationType', '=', 'Hover'],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'scribble_title', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_scribble_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $scribbletype    = ! empty( $settings['scribbletype'] ) ? $settings['scribbletype'] : 'Scratch1';
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $replay = ! empty( $settings['replay'] ) ? $settings['replay'] : 0;


    $output = "<em {$this->render_attributes( '_root' )}> $inner_title";

    if($scribbletype == 'Basic'){
        $output .= "
        <svg {$this->render_attributes( 'svg_scribble_data' )}
        data-start=\"$start\"
        data-replay=\"$replay\"
        data-disable-builder=\"$disablebuilder\"
        data-animationType=\"$animationType\"
        data-classTriggerClick=\"$classTriggerClick\"
        data-classTriggerHover=\"$classTriggerHover\"
        class='bc-scribble-title__svg' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 2904 281'>
            <path class='bc-scribble-title__line' d='M0.5 280.002C641.5 -67.9991 2001 -48.4975 2903 111.002' stroke-linecap='round'/>
        </svg>
        ";
    }else if($scribbletype == 'Stacked1'){
        $output .= "
        <svg {$this->render_attributes( 'svg_scribble_data' )}
        data-start=\"$start\"
        data-replay=\"$replay\"
        data-disable-builder=\"$disablebuilder\"
        data-animationType=\"$animationType\"
        data-classTriggerClick=\"$classTriggerClick\"
        data-classTriggerHover=\"$classTriggerHover\"
        class='bc-scribble-title__svg' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1548 220'>
            <path class='bc-scribble-title__stacked' d='M0.5 57.7003C122.665 17.8824 550.328 -28.2639 1364 25.2003C2127.84 75.3901 264.5 112.699 90 144.199C-84.5 175.699 435 218.699 816 218.699' stroke-linecap='round'/>
        </svg>
        ";
    }else if($scribbletype == 'Stacked2'){
        $output .= "
        <svg {$this->render_attributes( 'svg_scribble_data' )}
        data-start=\"$start\"
        data-replay=\"$replay\"
        data-disable-builder=\"$disablebuilder\"
        data-animationType=\"$animationType\"
        data-classTriggerClick=\"$classTriggerClick\"
        data-classTriggerHover=\"$classTriggerHover\"
        class='bc-scribble-title__svg' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1358 309'>
            <path class='bc-scribble-title__stacked2' d='M0.5 37.5C64 27.0011 556.625 -18.3876 1224.5 10.5005C1892.37 39.3886 -197.5 186.507 83 203.499C363.5 220.491 651 172.499 794.5 307.999' stroke-linecap='round'/>
        </svg>
        ";
    }else if($scribbletype == 'Stacked3'){
        $output .= "
        <svg {$this->render_attributes( 'svg_scribble_data' )}
        data-start=\"$start\"
        data-replay=\"$replay\"
        data-disable-builder=\"$disablebuilder\"
        data-animationType=\"$animationType\"
        data-classTriggerClick=\"$classTriggerClick\"
        data-classTriggerHover=\"$classTriggerHover\"
        class='bc-scribble-title__svg' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 2583 499''>
            <path class='bc-scribble-title__stacked3' d='M1022.46 1C815.958 82 361.958 66.5 38.9576 144.5C-376.591 244.849 2760.92 97.4771 2574.46 144.5C2056.97 275 314.958 310.501 433.958 437.501C552.958 564.501 1431.46 227.001 1428.46 498.001' stroke-linecap='round'/>
        </svg>
        ";
    }else if($scribbletype == 'Scratch1'){
        $output .= "
        <svg {$this->render_attributes( 'svg_scribble_data' )}
        data-start=\"$start\"
        data-replay=\"$replay\"
        data-disable-builder=\"$disablebuilder\"
        data-animationType=\"$animationType\"
        data-classTriggerClick=\"$classTriggerClick\"
        data-classTriggerHover=\"$classTriggerHover\"
        class='bc-scribble-title__svg' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1917 317'>
            <path class='bc-scribble-title__scratch1' d='M0.5 273.001C16 206.834 95.2 61.0009 288 7.00094C529 -60.4991 4 468.001 256 273.001C508 78.0009 579 38.5 621.5 134.5C664 230.5 635 312.002 788 273.001C941 234 1423 -4.00095 1916.5 134.5' stroke-linecap='round'/>
        </svg>
        ";
    }
    else if($scribbletype == 'Scratch2'){
        $output .= "
        <svg {$this->render_attributes( 'svg_scribble_data' )}
        data-start=\"$start\"
        data-replay=\"$replay\"
        data-disable-builder=\"$disablebuilder\"
        data-animationType=\"$animationType\"
        data-classTriggerClick=\"$classTriggerClick\"
        data-classTriggerHover=\"$classTriggerHover\"
        class='bc-scribble-title__svg' xmlns='http://www.w3.org/2000/svg'viewBox='0 0 1122 121'>
            <path class='bc-scribble-title__scratch2' d='M1 101.784C43.1667 40.1172 128.4 -52.6161 132 69.7839C136.5 222.784 238 -45.716 277 24.284C316 94.284 322.396 180.269 398 53.2841C462 -54.211 500 34.2871 506 53.2841C510.99 69.0827 526.5 154.289 575 101.786C635.141 36.6828 676 -70.7137 705 76.7839C733.843 223.483 829.5 -53.2158 896.5 24.284C963.5 101.784 929 197.784 1121.5 16.7844' stroke-linecap='round'/>
        </svg>
        ";
    }
    else if($scribbletype == 'Scratch3'){
        $output .= "
        <svg {$this->render_attributes( 'svg_scribble_data' )}
        data-start=\"$start\"
        data-replay=\"$replay\"
        data-disable-builder=\"$disablebuilder\"
        data-animationType=\"$animationType\"
        data-classTriggerClick=\"$classTriggerClick\"
        data-classTriggerHover=\"$classTriggerHover\"
        class='bc-scribble-title__svg' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 2593 616'>
            <path class='bc-scribble-title__scratch3' d='M1 615.14C126.5 -484.354 174.974 184.735 184.004 399.651C191 566.148 211.858 526.573 220.5 462.646C293.5 -77.3529 352.388 86.3739 368 162.634C394 289.633 370.597 596.481 421.661 388.648C543.161 -105.853 582.661 341.648 698.661 341.648C1066.03 341.648 1142.5 227.65 2592.5 317.65' stroke-linecap='round'/>
        </svg>
        ";
    }else if($scribbletype == 'Signature'){
        $output .= "
        <svg {$this->render_attributes( 'svg_scribble_data' )}
        data-start=\"$start\"
        data-replay=\"$replay\"
        data-disable-builder=\"$disablebuilder\"
        data-animationType=\"$animationType\"
        data-classTriggerClick=\"$classTriggerClick\"
        data-classTriggerHover=\"$classTriggerHover\"
        class='bc-scribble-title__svg' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 3586 600'>
            <path class='bc-scribble-title__signature' d='M3585.11 309.935C1808.11 150.935 990.813 555.148 248.605 377.935C47.6045 329.943 -19.1858 242.645 6.1057 150.935C59.6047 -43.0573 557.106 -143.062 557.106 456.939C557.106 802.572 1422.75 456.939 1422.75 57.4849' stroke-linecap='round'/>
        </svg>
        ";
    }else if($scribbletype == 'Circle'){
        $output .= "
        <svg {$this->render_attributes( 'svg_scribble_data' )} class='bc-scribble-title__svg bc-scribble-title__svg-circle' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 2327 1178'>
            <path class='bc-scribble-title__circle' d='M1648.5 1.00209C1316 1.00069 0.999837 -5.13019 1 658.49C1.00011 1103.49 816.509 1176.99 1163.51 1176.99C1163.51 1176.99 2326.5 1210.48 2326.5 658.488C2326.5 106.494 1366 110.492 1163.51 142.992' stroke-linecap='round'/>
        </svg>
        ";
    }

    $output .= "</em>";

  echo $output;
  }
}