<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Scroll_Cascading extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'bc_scroll_cascading';
  public $icon         = 'fa-solid fa-align-center';
  public $tag      = 'p';
  public $scripts      = ['bc_scroll_cascading'];

  public function get_label() {
    return esc_html__( 'Scroll Cascading', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'p',
        'default'     => 'p',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'p',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'default'        => esc_html__( 'Scroll cascading.', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['titlesNumber'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Titles number', 'bricks' ),
        'type' => 'slider',
        'units' => [
            'px' => [
              'min' => 2,
              'max' => 20,
              'step' => 1,
            ],
        ],
        'default' => '8',
        'placeholder' => '8',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['typography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.bc-scroll-cascading__title',
            ],
        ],
    ];
    $this->controls['color'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--color',
                'selector' => '',
            ],
        ],
    ];
    $this->controls['strokeWidth'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Stroke width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--stroke-width',
                'selector' => '',
            ],
        ],
        'placeholder' => '4px',
    ];
    $this->controls['hue'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Stroke Hue', 'bricks' ),
        'type' => 'slider',
        'css'     => [
            [
              'property' => '--hue',
              'selector' => '',
            ],
        ],
        'units' => [
            'px' => [
              'min' => 0,
              'max' => 360,
              'step' => 1,
            ],
        ],
        'default' => '0',
        'placeholder' => '0',
    ];
    $this->controls['saturation'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Stroke Saturation', 'bricks' ),
        'type' => 'slider',
        'css'     => [
            [
              'property' => '--saturation',
              'selector' => '',
            ],
        ],
        'units' => [
            'px' => [
              'min' => 0,
              'max' => 100,
              'step' => 1,
            ],
        ],
        'default' => '0',
        'placeholder' => '0',
    ];
    $this->controls['lightness'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Stroke Lightness', 'bricks' ),
        'type' => 'slider',
        'css'     => [
            [
              'property' => '--lightness',
              'selector' => '',
            ],
        ],
        'units' => [
            'px' => [
              'min' => 0,
              'max' => 100,
              'step' => 1,
            ],
        ],
        'default' => '0',
        'placeholder' => '0',
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['distanceTitle'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Distance between titles', 'bricks' ),
        'type' => 'slider',
        'css'     => [
            [
              'property' => '--leading',
              'selector' => '',
            ],
        ],
        'units' => [
            'px' => [
              'min' => 0,
              'max' =>0.5,
              'step' => 0.01,
            ],
        ],
        'default' => '0.25',
        'placeholder' => '0.25',
    ];
    $this->controls['note'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Each scroll unit is multiplied by 1vh.', 'bricks' )))
    ];
    $this->controls['scrollDistance'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Scroll units', 'bricks' ),
        'type'    => 'text',
        'inline'   => true,
        'css'     => [
          [
            'property' => '--scroll',
            'selector' => '',
          ],
        ],
        'placeholder' => '162',
    ];

    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['trigger'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
    ];

    $this->controls['start'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top top',
    ];

    $this->controls['scroller'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scroller', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'body',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_scroll_cascading', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_scroll_cascading.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Scroll cascading.';
    $vartrigger    = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $varstart    = ! empty( $settings['varstart'] ) ? $settings['varstart'] : 'top top';
    $varscroller    = ! empty( $settings['varscroller'] ) ? $settings['varscroller'] : 'body';

    $this->set_attribute( '_root', 'class', 'bc-scroll-cascading' );
    $this->set_attribute( '_root', 'data-trigger', $vartrigger );
    $this->set_attribute( '_root', 'data-start', $varstart );
    $this->set_attribute( '_root', 'data-scroller', $varscroller );

    $titlesNumber = !empty($settings['titlesNumber']) ? intval($settings['titlesNumber']) : 8;
    $titlesHtml = '';
    for ($i = 0; $i < $titlesNumber; $i++) {
        $titlesHtml .= "<span aria-hidden='true' class='bc-scroll-cascading__title' style='--i: $i'>$inner_title</span>";
    }

    $output = "
    <div {$this->render_attributes( '_root' )}>
        <div class='bc-scroll-cascading__sticker'>
            <{$this->tag} class='bc-scroll-cascading__content' style='--count: $titlesNumber'>
                $titlesHtml
            </{$this->tag}>
        </div>
    </div>
    ";

	echo $output;
  }
}