<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Scroll_Gradient extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'scroll-gradient';
  public $icon         = 'fa-solid fa-align-center';
  public $tag      = 'p';
  public $scripts      = ['bc_scroll_gradient'];

  public function get_label() {
    return esc_html__( 'Scroll Gradient', 'bricks' );
  }

  public function set_controls() {
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'NOTE: Do not wrap Scroll Gradient. It has to be drop as a body direct child for a properly pin effect.', 'bricks' )))
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'p',
        'default'     => 'p',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'p',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'textarea',
        'default'        => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales.', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Gradient Wrapper Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['width'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Width', 'bricks' ),
      'type'    => 'number',
      'units' => true,
      'css'     => [
        [
          'property' => 'width',
          'selector' => '',
        ],
      ],
      'placeholder' => '100%',
      'rerender' => true,
    ];
    $this->controls['height'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Height', 'bricks' ),
      'type'    => 'number',
      'units' => true,
      'css'     => [
        [
          'property' => 'height',
          'selector' => '',
        ],
      ],
      'placeholder' => '100vh',
      'rerender' => true,
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
          [
            'property' => 'padding',
            'selector' => '',
          ],
        ],
        'rerender' => true,
    ];

    //Gradient
    $this->controls['gradientSeparator'] = [
        'label'      => esc_html__( 'Gradient Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['colors'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Colors', 'bricks' ),
        'titleProperty' => 'title',
        'fields'        => [
            'gradientcolor'       => [
                'type'    => 'color',
                'label'   => esc_html__( 'Color', 'bricks' ),
                'type'    => 'color',
            ],
        ],
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
      'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-scroll-gradient__text',
        ],
      ],
      'exclude' => [
        [
          'color'
        ],
      ],
      'rerender' => true,
    ];
    $this->controls['gradientWidth'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Width', 'bricks' ),
      'type'    => 'number',
      'units' => true,
      'css'     => [
        [
          'property' => 'width',
          'selector' => '.bc-scroll-gradient__text',
        ],
      ],
      'placeholder' => '100%',
      'rerender' => true,
    ];
    $this->controls['gradientMaxWidth'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Max width', 'bricks' ),
      'type'    => 'number',
      'units' => true,
      'css'     => [
        [
          'property' => 'max-width',
          'selector' => '.bc-scroll-gradient__text',
        ],
      ],
      'placeholder' => '780px',
      'rerender' => true,
    ];

    /*js*/
    $this->controls['scrolltrigger'] = [
        'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
        'type'       => 'separator',
        'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];
    $this->controls['from'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'From', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'top' => 'top',
            'bottom' => 'bottom',
        ],
        'inline'      => true,
        'placeholder' => 'bottom',
    ];
    $this->controls['start'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top top',
    ];
    $this->controls['end'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'End', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '+=300%',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_scroll_gradient', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_scroll_gradient.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $from    = ! empty( $settings['from'] ) ? $settings['from'] : 'bottom';
    $start    = ! empty( $settings['start'] ) ? $settings['start'] : 'top top';
    $end    = ! empty( $settings['end'] ) ? $settings['end'] : '+=300%';

    $colors = ! empty( $settings['colors'] ) ? $settings['colors'] : '';
    if ($colors) {
        $gradientcolors = '';
        foreach ( $colors as $color ) {
            if ( isset($color['gradientcolor']) && is_array($color['gradientcolor'])) {
                if (isset($color['gradientcolor']['rgb'])) {
                  $gradientcolor = $color['gradientcolor']['rgb'];
                }else if(isset($color['gradientcolor']['raw'])){
                  $gradientcolor = $color['gradientcolor']['raw'];
                }else if(isset($color['gradientcolor']['hex'])){
                  $gradientcolor = $color['gradientcolor']['hex'];
                }
                $gradientcolors .= $gradientcolor . 'bc11';
            }else{
                $gradientcolors .= '#fff' . 'bc11';
            }
        }
        $gradientcolors .= '';
    }else{
        $gradientcolors = 'unset';
    }
    $this->set_attribute( '_root', 'data-gradient-colors', $gradientcolors);

    $this->set_attribute( '_root', 'class', 'bc-scroll-gradient' );
    $this->set_attribute( '_root', 'data-hide', 'bc-scroll-gradient--to-hide' );
    $this->set_attribute( '_root', 'data-from', $from);
    $this->set_attribute( '_root', 'data-start', $start);
    $this->set_attribute( '_root', 'data-end', $end);
    $this->set_attribute( 'inner_title', 'class', 'bc-scroll-gradient__text');

    $output = "<div {$this->render_attributes( '_root' )}>";
    $output .="<{$this->tag} {$this->render_attributes( 'inner_title' )}>$inner_title</{$this->tag}>";
    $output .= '</div>';

	echo $output;
  }
}