<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Scroll_Reading extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'scroll reading';
  public $icon         = 'fa-solid fa-align-center';
  public $tag      = 'p';
  public $css_selector = '';
  public $scripts      = ['scroll_reading'];

  public function get_label() {
    return esc_html__( 'Scroll Reading', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'h1' => 'h1',
          'h2' => 'h2',
          'h3' => 'h3',
          'h4' => 'h4',
          'h5' => 'h5',
          'h6' => 'h6',
          'p' => 'p',
          'span' => 'span',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'p',
      'default'     => 'p',
  ];
  $this->controls['customTag'] = [
    'tab'         => 'content',
    'label'       => esc_html__( 'Custom tag', 'bricks' ),
    'type'        => 'text',
    'inline'      => true,
    'placeholder' => 'p',
    'required'    => [ 'tag', '=', 'custom' ],
  ];

  $this->controls['inner_title'] = [
    'hasDynamicData'      => true,
    'tab'            => 'content',
    'type'           => 'textarea',
    'default'        => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales.', 'bricks' ),
    'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
  ];

  $this->controls['styleSeparator'] = [
    'label'      => esc_html__( 'Style', 'bricks' ),
    'type'       => 'separator',
  ];

  $this->controls['titleTypography'] = [
    'tab'     => 'content',
    'label'   => esc_html__( 'Typography', 'bricks' ),
    'type'    => 'typography',
    'css'     => [
      [
        'property' => 'typography',
        'selector' => '.bc-scroll-reading__element',
      ],
    ],
  ];

  $this->controls['MaskColor'] = [
    'tab'     => 'content',
    'label'   => esc_html__( 'Mask color', 'bricks' ),
    'type'    => 'color',
    'css'     => [
      [
        'property' => 'background-color',
        'selector' => '.bc-scroll-reading__line-mask',
      ],
    ],
  ];

  $this->controls['MaskzIndex'] = [
    'tab'     => 'content',
    'label'   => esc_html__( 'Mask zIndex', 'bricks' ),
    'type'    => 'text',
    'inline' => true,
    'css'     => [
      [
        'property' => 'z-index',
        'selector' => '.bc-scroll-reading__line-mask',
      ],
    ],
    'placeholder' => '9999',
  ];

  $this->controls['Opacity'] = [
    'tab'     => 'content',
    'label'   => esc_html__( 'Text opacity', 'bricks' ),
    'type'    => 'text',
    'placeholder' => '0.1',
    'inline' => true,
    'css'     => [
      [
        'property' => '--opacity',
        'selector' => '.bc-scroll-reading__line-mask',
      ],
    ],
  ];
  $this->controls['animationSeparator'] = [
    'label'      => esc_html__( 'Animation', 'bricks' ),
    'type'       => 'separator',
  ];
    $this->controls['duration'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1',
    ];

    $this->controls['type'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Split type', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'chars' => 'chars',
        'words' => 'words',
        'lines' => 'lines',
    ],
      'inline' => true,
      'placeholder' => 'lines',
  ];

    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['start'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top center',
    ];

    $this->controls['end'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'End', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'bottom center',
    ];

    $this->controls['scroller'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scroller', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'body',
    ];

    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '.word',
        ],
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'scrollreading', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_scroll_reading.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Brickscore';
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top center';
    $end = ! empty( $settings['end'] ) ? $settings['end'] : 'bottom center';
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 1;
    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'lines';
    $scroller = ! empty( $settings['scroller'] ) ? $settings['scroller'] : 'body';

    if (is_rtl()) { // RTL
      $this->set_attribute('_root', 'class', 'bc-scroll-reading--rtl');
    }
    $this->set_attribute( '_root', 'class', 'bc-scroll-reading' );
    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";

    if ( $inner_title ) {
      $this->set_attribute( 'inner_title', 'class', 'bc-scroll-reading__element' );
      $this->set_attribute( 'inner_title', 'class', 'bc-scroll-reading__to-hide' );

      $output .=
      "<span {$this->render_attributes( 'inner_title' )}
          data-start='{$start}'
          data-end='{$end}'
          data-duration='{$duration}'
          data-type='{$type}'
          data-scroller='{$scroller}'>$inner_title</span>";
    }

    $output .= "</{$this->tag}>";


		echo $output;
  }
}

