<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Sharer extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'sharer';
  public $icon         = 'fa-solid fa-hashtag';
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Sharer', 'bricks' );
  }

  public function set_controls() {
    $this->controls['removeText'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Remove text', 'bricks' ),
      'type'        => 'checkbox',
      'inline'      => true,
      'default'     => false,
    ];
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
      'hasDynamicData' => 'text',
      'label'    => esc_html__( 'Text', 'bricks' ),
      'default'        => esc_html__( 'Share on social media', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
      'required' => [ 'removeText', '=', false],
    ];

    $this->controls['settingsSeparator'] = [
      'label'      => esc_html__( 'Settings', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['type'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'twitter' => 'twitter',
            'facebook' => 'facebook',
            'whatsapp' => 'whatsapp',
            'linkedin' => 'linkedin',
            'telegram' => 'telegram',
            'reddit' => 'reddit',
            'skype' => 'skype',
            'viber' => 'viber',
        ],
        'inline'      => true,
        'default'     => 'twitter',
        'placeholder' => 'twitter',
    ];
    $this->controls['title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Just a text to share', 'bricks' ),
        'label'    => esc_html__( 'Title to share', 'bricks' ),
    ];
    $this->controls['url'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'https://nextbricks.io', 'bricks' ),
        'label'    => esc_html__( 'Url to share', 'bricks' ),
    ];

    $this->controls['tab'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Open as a tab', 'bricks' ),
      'type'        => 'checkbox',
      'inline'      => true,
      'default'     => false,
      'required'    => [ 'type', '=', [ 'twitter', 'facebook', 'whatsapp', 'telegram', 'reddit', 'skype', 'linkedin' ] ],
    ];
    $this->controls['width'] = [
      'tab'            => 'content',
      'inline'            => true,
      'type'  => 'number',
      'units' => true,
      'hasDynamicData' => 'text',
      'placeholder'        => esc_html__( '500px', 'bricks' ),
      'label'    => esc_html__( 'Pop up width', 'bricks' ),
      'required'    => [ ['tab', '=', false] , [ 'type', '=', [ 'twitter', 'facebook', 'whatsapp', 'telegram', 'reddit', 'skype', 'linkedin' ] ] ],
    ];
    $this->controls['height'] = [
      'tab'            => 'content',
      'inline'            => true,
      'type'  => 'number',
      'units' => true,
      'hasDynamicData' => 'text',
      'placeholder'        => esc_html__( '500px', 'bricks' ),
      'label'    => esc_html__( 'Pop up height', 'bricks' ),
      'required'    => [ ['tab', '=', false] , [ 'type', '=', [ 'twitter', 'facebook', 'whatsapp', 'telegram', 'reddit', 'skype', 'linkedin' ] ] ],
    ];

    //Twitter
    $this->controls['twitterSeparator'] = [
      'label'      => esc_html__( 'Twitter', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'type', '=', 'twitter'],
    ];
    $this->controls['hashtags'] = [
      'tab'         => 'content',
      'type'           => 'text',
      'hasDynamicData' => 'text',
      'label'    => esc_html__( 'Hashtags. e.g: "awesome,nextbricks"', 'bricks' ),
      'default'        => esc_html__( 'awesome,nextbricks', 'bricks' ),
      'required' => [ 'type', '=', 'twitter'],
    ];
    $this->controls['username'] = [
      'tab'         => 'content',
      'type'           => 'text',
      'hasDynamicData' => 'text',
      'default'        => esc_html__( 'nextbricks', 'bricks' ),
      'label'    => esc_html__( 'Username', 'bricks' ),
      'required' => [ 'type', '=', 'twitter'],
    ];

    //Facebook
    $this->controls['facebookSeparator'] = [
      'label'      => esc_html__( 'Facebook', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'type', '=', 'facebook'],
    ];
    $this->controls['facebookhashtag'] = [
      'tab'         => 'content',
      'type'           => 'text',
      'hasDynamicData' => 'text',
      'default'        => esc_html__( 'nextbricks', 'bricks' ),
      'label'    => esc_html__( 'Hashtag', 'bricks' ),
      'required' => [ 'type', '=', 'facebook'],
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'icon',
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'sharer', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_sharer.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'sharer-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_sharer.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $removeText = ! empty( $settings['removeText'] ) ? $settings['removeText'] : 0;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Share on social media';
    $datasharer = ! empty( $settings['type'] ) ? $settings['type'] : 'twitter';
    $datatitle    = ! empty( $settings['title'] ) ? $settings['title'] : 'Just a title to share';
    $dataurl    = ! empty( $settings['url'] ) ? $settings['url'] : 'https://nextbricks.io';
    $datawidth   = ! empty( $settings['width'] ) ? $settings['width'] : '500px';
    $dataheight    = ! empty( $settings['height'] ) ? $settings['height'] : '500px';
    $datatab    = ! empty( $settings['tab'] ) ? $settings['tab'] : 0;
    if($datatab == 0){
      $datatab = 'false';
    }else if($datatab == 1){
      $datatab = 'true';
    }
    $datahashtags   = ! empty( $settings['hashtags'] ) ? $settings['hashtags'] : '';
    $datausername   = ! empty( $settings['username'] ) ? $settings['username'] : '';
    $datafacebookhashtag   = ! empty( $settings['facebookhashtag'] ) ? $settings['facebookhashtag'] : '';

    $this->set_attribute( '_root', 'data-sharer', "$datasharer" );
    $this->set_attribute( '_root', 'data-title', "$datatitle" );
    $this->set_attribute( '_root', 'data-url', "$dataurl" );

    if($datasharer == 'twitter' || $datasharer == 'facebook' || $datasharer == 'whatsapp' || $datasharer == 'telegram' || $datasharer == 'reddit' || $datasharer == 'skype' || $datasharer == 'linkedin'){
      $this->set_attribute( '_root', 'data-width', "$datawidth" );
      $this->set_attribute( '_root', 'data-height', "$dataheight" );
      $this->set_attribute( '_root', 'data-link', "$datatab" );
      $this->set_attribute( '_root', 'data-blank', "$datatab" );
      $this->set_attribute( '_root', 'data-hashtags', "$datahashtags" );
      $this->set_attribute( '_root', 'data-via', "$datausername" );
      $this->set_attribute( '_root', 'data-hashtag', "$datafacebookhashtag" );
    }

    $this->set_attribute( '_root', 'class', 'bc-sharer' );

    $output = "<div {$this->render_attributes( '_root' )}>";
    if($removeText == 0){
      $output .= $inner_title;
    }
    $output .= Frontend::render_children( $this );
    $output .= '</div>';

    echo $output;
  }
}
