<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Spinner extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'bc_spinner';
  public $icon         = 'ion-md-medical';
  public $scripts      = ['bc_spinner'];

  public function get_label() {
    return esc_html__( 'Spinner', 'bricks' );
  }

  public function set_controls() {
    $this->controls['disablebuilder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable animation at the builder', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
    ];
    $this->controls['type'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'Type--a' => 'Type--a',
            'Type--b' => 'Type--b',
            'Type--c' => 'Type--c',
            'Type--d' => 'Type--d',
            'Type--e' => 'Type--e',
            'Type--f' => 'Type--f',
            'Type--g' => 'Type--g',
            'Type--h' => 'Type--h',
        ],
        'rerender'      => true,
        'inline'      => true,
        'placeholder' => 'Type--a',
        'default' => 'Type--a',
    ];

    /*style*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['dimensions'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Dimensions', 'bricks' ),
        'type'     => 'number',
        'units'     => true,
        'css'     => [
            [
                'property' => '--dimensions',
                'selector' => '',
            ],
        ],
        'placeholder' => '200px',
    ];
    /*only for draw types*/
    $this->controls['fill'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Fill', 'bricks' ),
        'type'     => 'color',
        'css'     => [
            [
                'property' => 'fill',
                'selector' => '&.bc-spinner--fill',
            ],
        ],
        'required'    => [ 'type', '=', [ 'Type--d', 'Type--e', 'Type--f', 'Type--g', 'Type--h' ] ],
    ];
    $this->controls['strokeColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Stroke color', 'bricks' ),
        'type'     => 'color',
        'css'     => [
            [
                'property' => 'stroke',
                'selector' => '',
            ],
        ],
    ];
    $this->controls['strokeWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Stroke width', 'bricks' ),
        'type'     => 'number',
        'units'     => true,
        'css'     => [
            [
                'property' => 'stroke-width',
                'selector' => '',
            ],
        ],
        'placeholder' => '3px',
    ];

    /*Path animation*/
    $this->controls['pathAnimationSeparator'] = [
        'label'      => esc_html__( 'Path Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['enableentrancenormal'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Enable', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
        'required'    => [ 'type', '=', [ 'Type--a', 'Type--b', 'Type--c' ] ],
    ];
    $this->controls['durationnormal'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Duration', 'bricks' ),
        'type'     => 'number',
        'unit'     => 's',
        'required'    => [ ['enableentrancenormal', '=', true] , [ 'type', '=', [ 'Type--a', 'Type--b', 'Type--c' ] ] ],
        'placeholder'     => '1s',
    ];
    $this->controls['staggernormal'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Stagger', 'bricks' ),
        'type'     => 'text',
        'required'    => [ ['enableentrancenormal', '=', true] , [ 'type', '=', [ 'Type--a', 'Type--b', 'Type--c' ] ] ],
        'placeholder'     => '0.25',
        'inline' => true,
    ];

    $this->controls['enableentrancedraw'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Enable', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
        'required'    => [ 'type', '=', [ 'Type--d', 'Type--e', 'Type--f', 'Type--g', 'Type--h' ] ],
    ];
    $this->controls['durationdraw'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Duration', 'bricks' ),
        'type'     => 'number',
        'unit'     => 's',
        'required'    => [ ['enableentrancedraw', '=', true] , [ 'type', '=', [ 'Type--d', 'Type--e', 'Type--f', 'Type--g', 'Type--h' ] ] ],
        'placeholder'     => '1s',
    ];

    //ScrollTrigger for normal Path
    $this->controls['scrolltrigger'] = [
        'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
        'type'       => 'separator',
        'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
        'required'    => [ ['enableentrancenormal', '=', true] , [ 'type', '=', [ 'Type--a', 'Type--b', 'Type--c' ] ] ],
    ];
    $this->controls['trigger'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
        'required'    => [ ['enableentrancenormal', '=', true] , [ 'type', '=', [ 'Type--a', 'Type--b', 'Type--c' ] ] ],
    ];
    $this->controls['start'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom',
        'required'    => [ ['enableentrancenormal', '=', true] , [ 'type', '=', [ 'Type--a', 'Type--b', 'Type--c' ] ] ],
    ];
    //ScrollTrigger for draw Path
    $this->controls['scrolltriggerDraw'] = [
        'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
        'type'       => 'separator',
        'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
        'required'    => [ ['enableentrancedraw', '=', true] , [ 'type', '=', [ 'Type--d', 'Type--e', 'Type--f', 'Type--g', 'Type--h' ] ] ],
    ];
    $this->controls['triggerDraw'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
        'required'    => [ ['enableentrancedraw', '=', true] , [ 'type', '=', [ 'Type--d', 'Type--e', 'Type--f', 'Type--g', 'Type--h' ] ] ],
    ];
    $this->controls['startDraw'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom',
        'required'    => [ ['enableentrancedraw', '=', true] , [ 'type', '=', [ 'Type--d', 'Type--e', 'Type--f', 'Type--g', 'Type--h' ] ] ],
    ];

    /*Animation*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Rotation Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Duration', 'bricks' ),
        'type'     => 'number',
        'unit'     => 's',
        'placeholder'     => '6s',
    ];
    $this->controls['delay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Delay', 'bricks' ),
        'type'     => 'number',
        'unit'     => 's',
        'placeholder'     => '1s',
    ];
    $this->controls['easing'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps'
        ],
        'inline' => true,
        'placeholder' => 'none',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'motion-path-plugin-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_motion_path_plugin.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'draw-svg-plugin-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_draw_svg_plugin.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'bc_spinner', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_spinner.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'Type--a';
    $enableentrancenormal    = ! empty( $settings['enableentrancenormal'] ) ? $settings['enableentrancenormal'] : 0;
    $enableentrancedraw    = ! empty( $settings['enableentrancedraw'] ) ? $settings['enableentrancedraw'] : 0;
    $durationnormal    = ! empty( $settings['durationnormal'] ) ? $settings['durationnormal'] : 1;
    $durationdraw    = ! empty( $settings['durationdraw'] ) ? $settings['durationdraw'] : 1;
    $staggernormal    = ! empty( $settings['staggernormal'] ) ? $settings['staggernormal'] : 0.25;

    $trigger    = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $start    = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $triggerDraw    = ! empty( $settings['triggerDraw'] ) ? $settings['triggerDraw'] : 'this';
    $startDraw    = ! empty( $settings['startDraw'] ) ? $settings['startDraw'] : 'top bottom';

    $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : 6;
    $delay    = ! empty( $settings['delay'] ) ? $settings['delay'] : '1';
    $easing    = ! empty( $settings['easing'] ) ? $settings['easing'] : 'none';

    $this->set_attribute( '_root', 'class', "bc-spinner");
    $this->set_attribute( '_root', 'data-hide', "bc-spinner--hide");
    $this->set_attribute( '_root', 'fill', "none");
    $this->set_attribute( '_root', 'xmlns', "http://www.w3.org/2000/svg");

    $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_root', 'data-entrance-normal', $enableentrancenormal);
    $this->set_attribute( '_root', 'data-entrance-draw', $enableentrancedraw);
    $this->set_attribute( '_root', 'data-duration-normal', $durationnormal);
    $this->set_attribute( '_root', 'data-duration-draw', $durationdraw);
    $this->set_attribute( '_root', 'data-stagger-normal', $staggernormal);

    $this->set_attribute( '_root', 'data-trigger', $trigger);
    $this->set_attribute( '_root', 'data-start', $start);
    $this->set_attribute( '_root', 'data-trigger-draw', $triggerDraw);
    $this->set_attribute( '_root', 'data-start-draw', $startDraw);

    $this->set_attribute( '_root', 'data-duration', $duration);
    $this->set_attribute( '_root', 'data-delay', $delay);
    $this->set_attribute( '_root', 'data-easing', $easing);

    if($type == 'Type--a'){
        $this->set_attribute( '_root', 'class', 'bc-spinner--entrance' );
        $output = "
        <svg {$this->render_attributes( '_root' )} viewBox='0 0 392 392'>
            <line class='bc-spinner__line' x1='195.5' y1='391.021' x2='195.5' y2='6.10352e-05'/>
            <line class='bc-spinner__line' y1='195.01' x2='391.02' y2='195.01'/>
            <line class='bc-spinner__line' x1='56.6464' y1='334.14' x2='333.14' y2='57.6464'/>
            <line class='bc-spinner__line' x1='58.3536' y1='57.6464' x2='334.847' y2='334.14'/>
        </svg>";
    }
    if($type == 'Type--b'){
        $this->set_attribute( '_root', 'class', 'bc-spinner--entrance' );
        $output = "
        <svg {$this->render_attributes( '_root' )} viewBox='0 0 373 392'>
            <line class='bc-spinner__line' x1='185.747' y1='391.757' x2='185.747' y2='0.736389'/>
            <line class='bc-spinner__line' x1='70.9241' y1='354.124' x2='300.76' y2='37.7816'/>
            <line class='bc-spinner__line' x1='0.150831' y1='256.187' x2='372.033' y2='135.355'/>
            <line class='bc-spinner__line' x1='0.459848' y1='135.355' x2='372.342' y2='256.187'/>
            <line class='bc-spinner__line' x1='71.7331' y1='37.7815' x2='301.569' y2='354.124'/>
        </svg>";
    }
    if($type == 'Type--c'){
        $this->set_attribute( '_root', 'class', 'bc-spinner--entrance' );
        $output = "
        <svg {$this->render_attributes( '_root' )} viewBox='0 0 392 392'>
            <line class='bc-spinner__line' x1='195.5' y1='391.021' x2='195.5' y2='6.10352e-05'/>
            <line class='bc-spinner__line' y1='195.01' x2='391.02' y2='195.01'/>
            <line class='bc-spinner__line' x1='14.4274' y1='270.603' x2='375.683' y2='120.966'/>
            <line class='bc-spinner__line' x1='56.6464' y1='334.14' x2='333.14' y2='57.6464'/>
            <line class='bc-spinner__line' x1='119.966' y1='376.683' x2='269.603' y2='15.4274'/>
            <line class='bc-spinner__line' x1='15.8101' y1='120.966' x2='377.066' y2='270.603'/>
            <line class='bc-spinner__line' x1='58.3536' y1='57.6464' x2='334.847' y2='334.14'/>
            <line class='bc-spinner__line' x1='121.89' y1='15.4273' x2='271.527' y2='376.683'/>
        </svg>";
    }
    if($type == 'Type--d'){
        $this->set_attribute( '_root', 'class', 'bc-spinner--fill' );
        $output = "
        <svg {$this->render_attributes( '_root' )} viewBox='0 0 350 350'>
            <path class='bc-spinner__line--draw' d='M8.4374 341.563C89.9026 245.595 89.9026 104.405 8.4374 8.4374C104.405 89.9026 245.595 89.9026 341.563 8.4374C260.097 104.405 260.097 245.595 341.563 341.563C245.595 260.097 104.405 260.097 8.4374 341.563Z'/>
        </svg>";
    }
    if($type == 'Type--e'){
        $this->set_attribute( '_root', 'class', 'bc-spinner--fill' );
        $output = "
        <svg {$this->render_attributes( '_root' )} viewBox='0 0 190 199'>
            <path class='bc-spinner__line--draw' d='M60.8386 128.355C44.7096 131.581 13.7418 129.968 0.838623 115.452C14.7096 124.807 42.1289 115.775 55.0322 109.323C35.9999 103.516 10.1935 92.2261 4.06443 65.7745C13.4193 79.9681 36.9677 92.8713 53.4193 86.4197C32.7741 67.0648 23.0967 49.6455 25.6773 25.1294C28.9031 44.4842 51.1612 64.1616 67.2902 70.6132C60.8386 38.0326 63.7419 18.6777 81.4838 0.290649C66.3225 25.4519 78.5806 49.3229 88.258 62.5487C97.6128 38.6778 110.516 23.5165 135.677 10.6132C116.645 26.7423 106.323 45.1294 110.193 63.1939C131.806 46.4197 152.774 29.0003 182.774 37.0648C165.355 32.2261 134.71 59.9681 130.193 75.452C148.903 70.6132 176.968 72.5487 189.548 88.6777C175.032 83.1939 149.548 85.4519 136.645 95.1294C158.258 99.3229 167.935 108.678 185.355 134.484C170.193 115.775 137.613 108.678 126.323 114.162C136.323 124.162 164.064 142.871 160.193 176.42C155.355 147.387 126.968 136.742 116.968 130.936C120.839 150.936 124.064 175.775 106.968 199.323C116.968 179 108.903 155.129 98.258 139C92.7741 162.226 82.129 181.258 59.5483 190.936C72.4515 178.033 75.0322 159.968 78.258 140.613C55.6773 153.516 35.9999 165.452 8.58056 159.645C31.4838 159 47.6128 144.484 60.8386 128.355Z'/>
        </svg>";
    }
    if($type == 'Type--f'){
        $this->set_attribute( '_root', 'class', 'bc-spinner--fill' );
        $output = "
        <svg {$this->render_attributes( '_root' )} viewBox='0 0 196 197'>
            <path class='bc-spinner__line--draw' d='M159.857 80.9289C159.5 80.2146 159.5 79.1432 159.143 78.4289C168.786 69.8575 189.5 64.5003 187.714 84.8575C212.357 62.3575 157.714 29.1432 143.071 53.0718C142.357 52.3575 142 52.0003 141.286 51.6432C144.857 39.1432 160.571 23.0718 169.5 42.0003C179.5 9.85749 114.857 8.78606 114.857 37.3575C114.143 37.0003 113.429 37.0003 112.714 37.0003C109.143 24.8575 114.5 1.6432 132 14.1432C124.857 -18.7139 67.7143 12.7146 82.3572 37.3575C81.6429 37.3575 80.9286 37.7146 80.2143 38.0718C70.9286 29.1432 64.1429 6.6432 85.5715 8.42892C63.0715 -16.2139 29.5 38.7861 54.1429 53.4289C53.4286 53.7861 53.0715 54.5003 52.3572 55.2146C39.8572 52.0003 23.4286 35.9289 42.7143 27.0003C10.9286 17.0003 9.50003 80.2146 37 81.6432C36.6429 82.3575 36.6429 83.4289 36.2857 84.1432C23.7857 87.0003 2.71431 81.2861 14.5 64.5003C-17.6428 71.6432 11.6429 125.929 35.9286 115.215C36.2857 116.286 36.2857 117 36.6429 118.072C27 126.286 7.00003 131.286 8.78574 111.286C-15.1428 133.072 35.5715 165.215 52 144.857L54.1429 147C49.5 158.786 35.2143 172 26.6429 154.143C17 184.857 75.9286 187.357 80.9286 162.357C82 162.715 83.0715 163.072 84.1429 163.072C85.9286 175.572 79.8572 193.429 63.7857 182.357C70.5715 213.786 123.071 186.286 114.857 162.357L118.071 161.286C125.929 171.286 129.5 189.857 110.214 188.072C132 212 163.786 161.286 144.143 144.857L146.286 142.715C158.071 147.357 170.929 161.643 153.429 169.857C184.5 179.5 186.643 118.786 160.571 115.215C160.929 114.143 160.929 113.429 161.286 112.357C173.786 110.215 193.429 115.929 181.643 132.357C214.143 123.786 184.5 68.7861 159.857 80.9289Z'/>
        </svg>";
    }
    if($type == 'Type--g'){
        $this->set_attribute( '_root', 'class', 'bc-spinner--fill' );
        $output = "
        <svg {$this->render_attributes( '_root' )} viewBox='0 0 200 200'>
            <path class='bc-spinner__line--draw' fill-rule='evenodd' clip-rule='evenodd' d='M107.143 0H92.8571V63.2531L69.1621 4.60582L55.9166 9.95735L80.2255 70.1239L34.3401 24.2385L24.2386 34.3401L68.2177 78.3191L11.2241 53.4181L5.50459 66.5089L65.8105 92.8571H0V107.143H65.8104L5.50461 133.491L11.2241 146.582L68.2176 121.681L24.2386 165.66L34.3401 175.761L80.2255 129.876L55.9166 190.043L69.1621 195.394L92.8571 136.747V200H107.143V136.747L130.838 195.394L144.083 190.043L119.775 129.876L165.66 175.761L175.761 165.66L131.782 121.681L188.776 146.582L194.495 133.491L134.19 107.143H200V92.8571H134.189L194.495 66.5089L188.776 53.4181L131.782 78.3191L175.761 34.34L165.66 24.2385L119.775 70.1238L144.083 9.95735L130.838 4.60582L107.143 63.2531V0Z'/>
        </svg>";
    }
    if($type == 'Type--h'){
        $this->set_attribute( '_root', 'class', 'bc-spinner--fill' );
        $output = "
        <svg {$this->render_attributes( '_root' )} viewBox='0 0 200 200'>
            <path class='bc-spinner__line--draw' d='M97.8118 1.84638C98.2359 -0.615472 101.764 -0.615455 102.188 1.8464L106.863 28.9805C107.236 31.1438 110.179 31.5163 111.077 29.5138L122.339 4.39701C123.361 2.11817 126.778 2.99725 126.578 5.48745L124.371 32.9338C124.195 35.1221 126.953 36.2162 128.32 34.5003L145.463 12.9789C147.018 11.0263 150.11 12.7293 149.298 15.0913L140.348 41.1255C139.634 43.2011 142.034 44.9481 143.784 43.6267L165.73 27.053C167.721 25.5493 170.293 27.9691 168.92 30.0546L153.789 53.0407C152.583 54.8733 154.474 57.1634 156.497 56.3195L181.867 45.7349C184.169 44.7746 186.06 47.7592 184.212 49.4371L163.851 67.9308C162.228 69.4053 163.491 72.0946 165.66 71.7812L192.86 67.8507C195.328 67.4941 196.419 70.8561 194.213 72.021L169.901 84.8603C167.963 85.8839 168.519 88.8034 170.697 89.0403L198.019 92.0109C200.498 92.2805 200.719 95.8084 198.294 96.3871L171.559 102.765C169.427 103.274 169.241 106.24 171.292 107.012L197.018 116.697C199.352 117.576 198.691 121.048 196.198 121.005L168.72 120.521C166.529 120.482 165.613 123.309 167.408 124.568L189.922 140.359C191.964 141.792 190.462 144.99 188.058 144.326L161.564 137.011C159.451 136.428 157.862 138.937 159.288 140.604L177.175 161.509C178.798 163.406 176.549 166.129 174.385 164.887L150.539 151.2C148.637 150.109 146.475 152.144 147.443 154.113L159.579 178.818C160.68 181.06 157.826 183.137 156.039 181.396L136.338 162.197C134.768 160.666 132.168 162.098 132.617 164.247L138.24 191.199C138.75 193.645 135.469 194.946 134.171 192.814L119.855 169.309C118.713 167.435 115.84 168.174 115.741 170.367L114.497 197.875C114.385 200.37 110.884 200.813 110.156 198.424L102.124 172.091C101.483 169.992 98.5168 169.992 97.8764 172.091L89.8444 198.424C89.1156 200.813 85.6154 200.37 85.5025 197.875L84.259 170.367C84.1599 168.174 81.2866 167.435 80.1453 169.309L65.8294 192.814C64.5305 194.946 61.2502 193.645 61.7604 191.199L67.3835 164.247C67.8318 162.098 65.2323 160.666 63.6617 162.197L43.9615 181.396C42.1741 183.137 39.3198 181.06 40.421 178.818L52.5574 154.113C53.525 152.144 51.3625 150.109 49.4613 151.2L25.6147 164.887C23.4511 166.129 21.2022 163.406 22.8251 161.509L40.7123 140.604C42.1384 138.937 40.5489 136.428 38.4365 137.011L11.9418 144.326C9.53794 144.99 8.03576 141.792 10.0784 140.359L32.5924 124.568C34.3874 123.309 33.4707 120.482 31.28 120.521L3.80194 121.005C1.30888 121.048 0.64776 117.576 2.98188 116.697L28.708 107.012C30.7591 106.24 30.5728 103.274 28.4413 102.765L1.7065 96.3871C-0.719138 95.8084 -0.497589 92.2805 1.98131 92.0109L29.3032 89.0403C31.4815 88.8034 32.0373 85.8839 30.099 84.8603L5.78724 72.021C3.58145 70.856 4.67171 67.4941 7.13963 67.8507L34.3405 71.7812C36.5091 72.0946 37.7722 69.4053 36.1488 67.9308L15.7877 49.4371C13.9404 47.7592 15.8308 44.7746 18.1327 45.7349L43.5034 56.3195C45.5262 57.1634 47.417 54.8733 46.2107 53.0407L31.0796 30.0546C29.7067 27.9691 32.2786 25.5493 34.2698 27.053L56.2162 43.6267C57.966 44.9481 60.3658 43.2011 59.6523 41.1255L50.7019 15.0913C49.8899 12.7293 52.9816 11.0263 54.537 12.9789L71.6801 34.5003C73.0469 36.2162 75.805 35.122 75.6291 32.9338L73.4219 5.48743C73.2216 2.99724 76.6389 2.11816 77.6608 4.39699L88.9235 29.5138C89.8214 31.5163 92.7645 31.1438 93.1372 28.9805L97.8118 1.84638Z'/>
        </svg>";
    }

	echo $output;
  }
}