<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Spotlight extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'spotlight';
  public $icon         = 'fa-solid fa-slash';
  public $tag      = 'div';
  public $scripts      = ['bc_spotlight'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Spotlight', 'bricks' );
  }

  public function set_controls() {
		// Display
		$this->controls['_display'] = [
			'label'     => esc_html__( 'Display', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'flex'         => 'flex',
				'grid'         => 'grid',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'    => true,
			'lowercase' => true,
			'css'       => [
				[
					'property' => 'display',
					'selector' => '',
				],
				/**
				 * Use 'required' property to add CSS rule if display is set to 'grid'
				 *
				 * @prev 1.7.2: Used .brx-grid class on nestable to set align-items to initial.
				 *
				 * @since 1.7.2
				 */
				[
					'selector' => '',
					'property' => 'align-items',
					'value'    => 'initial',
					'required' => 'grid',
				],
			],
		];

		// Display: grid

		$this->controls['_gridGap'] = [
			'label'       => esc_html__( 'Gap', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'css'         => [
				[
					'property' => 'grid-gap', // '{column-gap} {row-gap}' e.g. '20px 40px'
					'selector' => '',
				],
			],
			'placeholder' => '',
			'required'    => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridTemplateColumns'] = [
			'label'          => esc_html__( 'Grid template columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-tempate-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-columns',
					'selector' => '',
				],
			],
			'placeholder'    => '',
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridTemplateRows'] = [
			'label'          => esc_html__( 'Grid template rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-tempate-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-rows',
					'selector' => '',
				],
			],
			'placeholder'    => '',
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridAutoColumns'] = [
			'label'          => esc_html__( 'Grid auto columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-columns',
					'selector' => '',
				],
			],
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridAutoRows'] = [
			'label'          => esc_html__( 'Grid auto rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-rows',
					'selector' => '',
				],
			],
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridAutoFlow'] = [
			'label'    => esc_html__( 'Grid auto flow', 'bricks' ),
			'type'     => 'select',
			'options'  => [
				'row'    => 'row',
				'column' => 'column',
				'dense'  => 'dense',
			],
			'tooltip'  => [
				'content'  => 'grid-auto-flow',
				'position' => 'top-left',
			],
			'css'      => [
				[
					'property' => 'grid-auto-flow',
					'selector' => '',
				],
			],
			'required' => [ '_display', '=', 'grid' ],
		];

		$this->controls['_justifyItemsGrid'] = [
			'label'     => esc_html__( 'Justify items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-items',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-items',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		$this->controls['_alignItemsGrid'] = [
			'label'     => esc_html__( 'Align items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-items',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		$this->controls['_justifyContentGrid'] = [
			'label'     => esc_html__( 'Justify content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-content',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		$this->controls['_alignContentGrid'] = [
			'label'     => esc_html__( 'Align content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-content',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-content',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		// Display: flex

		// Flex controls
		$this->controls['_flexWrap'] = [
			'label'    => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'     => 'select',
			'options'  => [
				'nowrap'       => esc_html__( 'No wrap', 'bricks' ),
				'wrap'         => esc_html__( 'Wrap', 'bricks' ),
				'wrap-reverse' => esc_html__( 'Wrap reverse', 'bricks' ),
			],
			'inline'   => true,
			'css'      => [
				[
					'property' => 'flex-wrap',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_direction'] = [
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
				],
			],
			'inline'   => true,
			'rerender' => true,
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_alignSelf'] = [
			'label'    => esc_html__( 'Align self', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-self',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property'  => 'align-self',
					'important' => true,
				],
				[
					'selector' => '',
					'property' => 'width',
					'value'    => '100%',
					'required' => 'stretch', // NOTE: Undocumented (@since 1.4)
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_justifyContent'] = [
			'label'    => esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     => 'justify-content',
			'css'      => [
				[
					'property' => 'justify-content',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_alignItems'] = [
			'label'    => esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_columnGap'] = [
			'label'    => esc_html__( 'Column gap', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'column-gap',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_rowGap'] = [
			'label'    => esc_html__( 'Row gap', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'row-gap',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		// @since 1.3.5
		$this->controls['_flexGrow'] = [
			'label'       => esc_html__( 'Flex grow', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-grow',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-grow',
				],
			],
			'placeholder' => 0,
			'required'    => [ '_display', '=', 'flex' ],
		];

		$this->controls['_flexShrink'] = [
			'label'       => esc_html__( 'Flex shrink', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-shrink',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-shrink',
				],
			],
			'placeholder' => 1,
			'required'    => [ '_display', '=', 'flex' ],
		];

		$this->controls['_flexBasis'] = [
			'label'          => esc_html__( 'Flex basis', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'flex-basis',
				'position' => 'top-left',
			],
			'css'            => [
				[
					'property' => 'flex-basis',
				],
			],
			'inline'         => true,
			'small'          => true,
			'placeholder'    => 'auto',
			'hasDynamicData' => false,
			'required'       => [ '_display', '=', 'flex' ],
		];

		// TAB: STYLE

		// Inner container (direct children)
		$this->controls['_innerContainerSeparator'] = [
			'type'  => 'separator',
			'label' => esc_html__( 'Inner container', 'bricks' ) . ' / div',
			'tab'   => 'style',
			'group' => '_layout',
		];

		$this->controls['_innerContainerMargin'] = [
			'tab'   => 'style',
			'group' => '_layout',
			'label' => esc_html__( 'Margin', 'bricks' ),
			'type'  => 'spacing',
			'css'   => [
				[
					'property' => 'margin',
					'selector' => '> .brxe-container',
				],
				[
					'property' => 'margin',
					'selector' => '> .brxe-block',
				],
				[
					'property' => 'margin',
					'selector' => '> .brxe-div',
				],
			],
		];

		$this->controls['_innerContainerPadding'] = [
			'tab'   => 'style',
			'group' => '_layout',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => 'spacing',
			'css'   => [
				[
					'property' => 'padding',
					'selector' => '> .brxe-container',
				],
				[
					'property' => 'padding',
					'selector' => '> .brxe-block',
				],
				[
					'property' => 'padding',
					'selector' => '> .brxe-div',
				],
			],
		];






        /*Element settings*/
		$this->controls['tag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'HTML tag', 'bricks' ),
			'type'        => 'select',
			'options'     => [
                'div' => 'div',
                'section' => 'section',
                'article' => 'article',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'main' => 'main',
                'nav' => 'nav',
                'custom' => 'custom',
			],
			'clearable'   => false,
			'inline'      => true,
			'placeholder' => 'div',
			'default'     => 'div',
		];
		$this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'div',
			'required'    => [ 'tag', '=', 'custom' ],
		];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'css'     => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'inline' => true,
            'placeholder' => '100%',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'css'     => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'inline' => true,
            'placeholder' => '100vh',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type' => 'background',
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '',
                ],
            ],
            'inline' => true,
        ];

        $this->controls['spotlightSeparator'] = [
            'label'      => esc_html__( 'Spotlight', 'bricks' ),
            'type'       => 'separator',
        ];

        $this->controls['mode'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Type', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'light' => 'light',
                'dark' => 'dark',
            ],
            'inline'      => true,
            'placeholder' => 'light',
        ];
		$this->controls['palette'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Palette', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'rainbow' => 'rainbow',
                'custom' => 'custom',
            ],
            'inline'      => true,
            'placeholder' => 'rainbow',
        ];
		$this->controls['colors'] = [
			'tab'           => 'content',
			'type'          => 'repeater',
			'label'         => esc_html__( 'Colors', 'bricks' ),
			'titleProperty' => 'title',
			'fields'        => [
				'gradientcolor'       => [
				'type'    => 'color',
				'label'   => esc_html__( 'Color', 'bricks' ),
				'inline'      => true,
				],
			],
			'required' => ['palette', '=', 'custom'],
		];
        $this->controls['opacity'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Opacity', 'bricks' ),
            'type' => 'text',
            'css'     => [
                [
                    'property' => 'opacity',
                    'selector' => '.bc-spotlight__spotlight',
                ],
            ],
            'inline' => true,
            'placeholder' => '0.5',
        ];
        $this->controls['heightspotlight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'css'     => [
                [
                    'property' => 'height',
                    'selector' => '.bc-spotlight__spotlight',
                ],
            ],
            'inline' => true,
            'placeholder' => '100%',
        ];
        $this->controls['speed'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Speed', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'css'     => [
                [
                    'property' => '--speed',
                    'selector' => '',
                ],
            ],
            'inline' => true,
            'placeholder' => '60',
        ];
        $this->controls['easing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'CSS easing', 'bricks' ),
            'type' => 'text',
            'css'     => [
                [
                    'property' => '--easing',
                    'selector' => '',
                ],
            ],
            'inline' => true,
            'placeholder' => 'linear',
        ];

		$this->controls['stopanimationSeparator'] = [
            'type'       => 'separator',
        ];
		$this->controls['note1'] = [
			'tab' => 'content',
			'description' => sprintf(html_entity_decode(esc_html__( 'Stop Spotlight animation at the builder for a better performance when editing.', 'bricks' )))
		];
		$this->controls['builderedit'] = [
			'hasDynamicData' => false,
			'tab' => 'content',
			'label'    => esc_html__( 'Stop animation at the builder', 'bricks' ),
			'type'     => 'checkbox',
		];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_spotlight', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_spotlight.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $mode    = ! empty( $settings['mode'] ) ? $settings['mode'] : 'light';
	$builderedit = ! empty( $settings['builderedit'] ) ? $settings['builderedit'] : 0;

    if($mode == 'light'){
        $this->set_attribute( '_root', 'data-light', '' );
    }else if($mode == 'dark'){
        $this->set_attribute( '_root', 'data-dark', '' );
    }
    $this->set_attribute( '_root', 'class', 'bc-spotlight' );

	$this->set_attribute( '_root', 'data-builderedit', $builderedit);

	/*custom palette*/
	$palette = ! empty( $settings['palette'] ) ? $settings['palette'] : 'rainbow';
	$colors = ! empty( $settings['colors'] ) ? $settings['colors'] : '';
    if ($colors) {
        $gradientcolors = '';
        foreach ( $colors as $color ) {
            if ( isset($color['gradientcolor']) && is_array($color['gradientcolor'])) {
                if (isset($color['gradientcolor']['rgb'])) {
                  $gradientcolor = $color['gradientcolor']['rgb'];
                }else if(isset($color['gradientcolor']['raw'])){
                  $gradientcolor = $color['gradientcolor']['raw'];
                }else if(isset($color['gradientcolor']['hex'])){
                  $gradientcolor = $color['gradientcolor']['hex'];
                }
                $gradientcolors .= $gradientcolor . 'bc11';
            }else{
                $gradientcolors .= '#fff' . 'bc11';
            }
        }
        $gradientcolors .= '';
    }else{
        $gradientcolors = 'unset';
    }
	$this->set_attribute( '_root', 'data-flickering', '');
	$this->set_attribute( '_root', 'data-palette', $palette);
	$this->set_attribute( '_root', 'data-gradient-colors', $gradientcolors);

    $output = "
    <{$this->tag} {$this->render_attributes( '_root' )}>
        <div class='bc-spotlight__wrapper'>
            <div class='bc-spotlight__spotlight'></div>
        </div>";

    // Render children elements (= individual items)
    $output .= Frontend::render_children( $this );

    $output .= "</{$this->tag}>";

	echo $output;
  }
}