<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Stickynav_Menu extends \Bricks\Element {
  public $category     = 'Next Bricks - Menus';
  public $name         = 'stickynav';
  public $icon         = 'ti-menu-alt';
  public $tag      = 'div';
  public $scripts      = ['stickynavmenu'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Sticky Header', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'section' => 'section',
          'nav' => 'nav',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['enableoffset'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Enable Offset', 'bricks' ),
      'type'     => 'checkbox',
      'default'      => true,
    ];
    $this->controls['offset'] = [
      'label'       => esc_html__( 'Offset Scrolling', 'bricks' ),
      'type'        => 'text',
      'hasDynamicData' => false,
      'small'      => true,
      'units'      => true,
      'inline'      => true,
      'placeholder' => '100',
      'required' => [ 'enableoffset', '=', true],
    ];
    $this->controls['goupwards'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Show when going up', 'bricks' ),
      'type'     => 'checkbox',
      'default'      => false,
      'required' => [ 'enableoffset', '=', true],
    ];
    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Offset Animation', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'enableoffset', '=', true],
    ];
    $this->controls['animationduration'] = [
      'label'       => esc_html__( 'Duration', 'bricks' ),
      'type'        => 'number',
      'unit'      => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--transition-duration',
            'selector' => '',
          ],
        ],
      'placeholder' => '0.5s',
      'required' => [ 'enableoffset', '=', true],
    ];
    $this->controls['animationeasing'] = [
        'label'       => esc_html__( 'CSS Easing', 'bricks' ),
        'type'        => 'text',
        'hasDynamicData' => false,
        'inline'      => true,
        'css'     => [
            [
              'property' => '--transition-easing',
              'selector' => '',
            ],
        ],
        'placeholder' => 'ease',
        'required' => [ 'enableoffset', '=', true],
    ];
    //Nav style
    $this->controls['navStyleSeparator'] = [
      'label'      => esc_html__( 'Nav scroll style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['note2'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Nav styles can be applied at Nav element.<br>The following background and backdrop styles are applied to Nav element when the following offset is reached.', 'bricks' )))
    ];
    $this->controls['offsetScrolling'] = [
      'label'       => esc_html__( 'Offset Scrolling', 'bricks' ),
      'type'        => 'text',
      'hasDynamicData' => false,
      'small'      => true,
      'units'      => true,
      'inline'      => true,
      'placeholder' => '50',
    ];
    $this->controls['backgroundNav'] = [
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'background',
      'css'     => [
          [
            'property' => 'background',
            'selector' => '&.bc-stickynav-menu--scroll-start .bc-stickynav-menu__items-wrapper',
          ],
        ],
    ];
    $this->controls['backdropFilterNav'] = [
      'label'       => esc_html__( 'Backdrop filter', 'bricks' ),
      'type'        => 'number',
      'units'      => true,
      'css'     => [
          [
            'property' => '--filter',
            'selector' => '&.bc-stickynav-menu--scroll-start .bc-stickynav-menu__items-wrapper',
          ],
      ],
      'placeholder' => '0px',
    ];
    $this->controls['animatiodurationNav'] = [
      'label'       => esc_html__( 'Duration', 'bricks' ),
      'type'        => 'number',
      'unit'      => 's',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--nav-transition-duration',
            'selector' => '.bc-stickynav-menu__items-wrapper',
          ],
        ],
      'placeholder' => '0.2s',
    ];
    $this->controls['animationeasingNav'] = [
      'label'       => esc_html__( 'CSS Easing', 'bricks' ),
      'type'        => 'text',
      'hasDynamicData' => false,
      'inline'      => true,
      'css'     => [
          [
            'property' => '--nav-transition-easing',
            'selector' => '.bc-stickynav-menu__items-wrapper',
          ],
      ],
      'placeholder' => 'ease',
    ];

    $this->controls['responsiveSeparator'] = [
      'label'      => esc_html__( 'Responsive', 'bricks' ),
      'type'       => 'separator',
    ];

    //Responsive
    $this->controls['enablemobilemenu'] = [
      'label' => esc_html__( 'Enable Mobile Menu', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
    ];

    $this->controls['note'] = [
      'description' => sprintf(html_entity_decode(esc_html__( 'Select a breakpoint to determine at which pixel to display Core Burger and hide Items Wrapper.', 'bricks' ))),
      'required' => [ 'enablemobilemenu', '=', true],
    ];

    //Breakpoints control
		$breakpoints        = Breakpoints::$breakpoints;
		$breakpoint_options = [];

		foreach ( $breakpoints as $index => $breakpoint ) {
			$breakpoint_options[ $breakpoint['key'] ] = $breakpoint['label'];
		}

		$this->controls['mobileMenu'] = [
			'type'        => 'select',
			'options'     => $breakpoint_options,
			'rerender'    => true,
			'placeholder' => esc_html__( 'Mobile landscape', 'bricks' ),
      'required' => [ 'enablemobilemenu', '=', true],
		];

    $this->controls['showonresponsivemedia'] = [
      'label' => esc_html__( 'Display at the builder', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
      'required' => [ 'enablemobilemenu', '=', true],
    ];

    $this->controls['noteanimationtype'] = [
      'description' => sprintf(html_entity_decode(esc_html__( 'Select an animation to display at mobile', 'bricks' ))),
      'required' => [ 'enablemobilemenu', '=', true],
    ];
    $this->controls['animationtype'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Animation Type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'opacity' => 'Opacity',
          'translatexleft' => 'From Left',
          'translatexright' => 'From Right',
      ],
      'inline'      => true,
      'placeholder' => 'Opacity',
      'required' => [ 'enablemobilemenu', '=', true],
    ];
    $this->controls['animationdurationresponsive'] = [
      'label'       => esc_html__( 'Animation Duration', 'bricks' ),
      'type'     => 'number',
      'unit'    => 's',
      'inline'      => true,
      'css'     => [
        [
          'property' => '--transition-duration-responsive',
          'selector' => '',
        ],
      ],
      'placeholder' => '0.3s',
      'required' => [ 'enablemobilemenu', '=', true],
    ];
    $this->controls['animationdelayresponsive'] = [
      'label'       => esc_html__( 'Animation Delay', 'bricks' ),
      'type'     => 'number',
      'unit'    => 's',
      'inline'      => true,
      'css'     => [
        [
          'property' => '--transition-delay-responsive',
          'selector' => '',
        ],
      ],
      'placeholder' => '0s',
      'required' => [ 'enablemobilemenu', '=', true],
    ];
    $this->controls['animationeaseresponsive'] = [
      'label'       => esc_html__( 'Animation Easing', 'bricks' ),
      'type'     => 'text',
      'inline'      => true,
      'css'     => [
        [
          'property' => '--transition-ease-responsive',
          'selector' => '',
        ],
      ],
      'placeholder' => 'ease',
      'required' => [ 'enablemobilemenu', '=', true],
    ];
  }
  
/*Render children*/
public function get_nestable_children() {
return [
    [
        'name'     => 'coreburguer',
        'label'    => esc_html__( 'Burger', 'bricks' ),
        'settings' => [
          '_hidden' => [
              '_cssClasses' => 'bc-core-burguer--stickynav-menu',
          ],
        ],
    ],

    [
        'name'     => 'block',
        'label'    => esc_html__( 'Nav', 'bricks' ),
        'settings' => [
          '_hidden'  => [
              '_cssClasses' => 'bc-stickynav-menu__items-wrapper',
          ],
        ],
        'children' => [
        [
            'name'     => 'swap-hover',
        ],
        [
            'name'     => 'swap-hover',
        ],
        [
            'name'     => 'swap-hover',
        ],
        ],
    ],
];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'stickynav-menu-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_sticky_nav.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $enableoffset = ! empty( $settings['enableoffset'] ) ? $settings['enableoffset'] : false;
    $offset = ! empty( $settings['offset'] ) ? $settings['offset'] : 100;
    $enablegoupwards = ! empty( $settings['goupwards'] ) ? $settings['goupwards'] : false;
    $offsetScrolling = ! empty( $settings['offsetScrolling'] ) ? $settings['offsetScrolling'] : 50;

    $this->set_attribute( '_root', 'class', 'bc-core-menu' );
    $this->set_attribute( '_root', 'class', 'bc-stickynav-menu' );
    $this->set_attribute( '_root', 'data-enableoffset', $enableoffset );
    $this->set_attribute( '_root', 'data-offset', $offset );
    $this->set_attribute( '_root', 'data-goupwards', $enablegoupwards );
    $this->set_attribute( '_root', 'data-navstyleoffset', $offsetScrolling );


    $enablemobilemenu = ! empty( $settings['enablemobilemenu'] ) ? $settings['enablemobilemenu'] : false;
    $showonresponsivemedia = ! empty( $settings['showonresponsivemedia'] ) ? $settings['showonresponsivemedia'] : false;
    $animationtype = ! empty( $settings['animationtype'] ) ? $settings['animationtype'] : 'opacity';

    $show_nav_button_at = ! empty( $settings['mobileMenu'] ) ? $settings['mobileMenu'] : 'mobile_landscape';
    $breakpoint = Breakpoints::get_breakpoint_by( 'key', $show_nav_button_at );
    $breakpoint_width    = ! empty( $breakpoint['width'] ) ? intval( $breakpoint['width'] ) : 0;

    $this->set_attribute( '_root', 'data-enable-mobile-menu', $enablemobilemenu );
    $this->set_attribute( '_root', 'data-breakpoint', $breakpoint_width );
    $this->set_attribute( '_root', 'data-animationtype', $animationtype );
    if($showonresponsivemedia && $enablemobilemenu){
      $this->set_attribute( '_root', 'data-class', 'bc-stickynav-menu--responsive-media' );
    }

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this ); //Menu items
    $output .= "</{$this->tag}>";





    $animationtype_inline_css = '';
    if($animationtype == 'opacity'){
      $animationtype_inline_css = 'transition: opacity var(--transition-duration-responsive) var(--transition-delay-responsive); transition-timing-function: var(--transition-delay-ease); opacity: 0;';
    }
    if($animationtype == 'translatexleft'){
      $animationtype_inline_css = "transition: left var(--transition-duration-responsive) var(--transition-delay-responsive); transition-timing-function: var(--transition-delay-ease); left: -100svw;";
    }
    if($animationtype == 'translatexright'){
      $animationtype_inline_css = "transition: left var(--transition-duration-responsive) var(--transition-delay-responsive); transition-timing-function: var(--transition-delay-ease); left: 100svw;";
    }

    //Media Query en el Front (no flick ya que se carga primero)
    //Hay que hacer Media Query en el JS igual a este mediante data-atributo ya que no se carga en el builder
    $nav_menu_inline_css = '';

    if($enablemobilemenu){
      $nav_menu_inline_css .= "@media (max-width: {$breakpoint_width}px) {";
      $nav_menu_inline_css .= ".bc-stickynav-menu { pointer-events: none;}";
      $nav_menu_inline_css .= ".bc-core-burguer--stickynav-menu { display: flex !important; pointer-events: all;}";
      $nav_menu_inline_css .= ".bc-stickynav-menu__items-wrapper { pointer-events: none; $animationtype_inline_css }";
      $nav_menu_inline_css .= '}';
  
      $output .= "<style>$nav_menu_inline_css</style>";
    }

    echo $output;
  }
}