<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Swap_Hover extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'swap-hover';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
  public $scripts      = ['swap_hover'];

  public function get_label() {
    return esc_html__( 'Swap Hover', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'label'       => esc_html__( 'Title', 'bricks' ),
      'tab'            => 'content',
      'type'           => 'text',
      'hasDynamicData' => 'text',
      'default'        => esc_html__( 'Swap Hover', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Link to', 'bricks' ),
			'type'  => 'link',
		];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];

    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
			'css'     => [
        [
          'property' => 'typography',
          'selector' => '',
        ],
      ],
    ];
    $this->controls['titlepadding'] = [
      'hasDynamicData' => false,
      'tab'     => 'content',
      'label'   => esc_html__( 'Swap padding', 'bricks' ),
      'type'        => 'spacing',
      'css'     => [
          [
            'property' => 'padding',
            'selector' => '&:not(:has(a)), a',
          ],
        ],
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['type'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'line' => 'line',
          'words' => 'words',
          'chars' => 'chars',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'line',
      'default' => 'line',
  ];
  $this->controls['swap_title'] = [
    'label'       => esc_html__( 'Custom Swap title', 'bricks' ),
    'tab'            => 'content',
    'type'           => 'text',
    'hasDynamicData' => 'text',
    'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    'required' => [ 'type', '=', 'line'],
  ];
  $this->controls['from'] = [
    'hasDynamicData' => false,
    'tab'         => 'content',
    'label'       => esc_html__( 'From', 'bricks' ),
    'type'        => 'select',
    'options'     => [
        '-1' => 'top',
        '1' => 'bottom',
    ],
    'css'     => [
      [
        'property' => '--fromtype',
        'selector' => '.bc-swap-title__span, .bc-swap-title__span .char, .bc-swap-title__span .word',
      ],
    ],
    'clearable'   => false,
    'inline'      => true,
    'placeholder' => 'bottom',
    'default' => '1',
];
  $this->controls['skew'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Skew', 'bricks' ),
    'type' => 'number',
    'unit' => 'deg',
    'small' => true,
    'inline' => true,
    'css'     => [
      [
        'property' => '--skew',
        'selector' => '.bc-swap-title__span, .bc-swap-title__span .char, .bc-swap-title__span .word',
      ],
    ],
    'placeholder' => '0',
  ];
  $this->controls['stagger'] = [
    'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Stagger', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'small' => true,
      'placeholder' => '0.25',
  ];
    $this->controls['duration'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'small' => true,
        'inline' => true,
        'css'     => [
          [
            'property' => '--duration',
            'selector' => '.bc-swap-title__span, .bc-swap-title__span .char, .bc-swap-title__span .word',
          ],
        ],
        'placeholder' => '1s',
    ];
    $this->controls['ease'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'CSS Easing', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'css'     => [
          [
            'property' => '--ease',
            'selector' => '.bc-swap-title__span, .bc-swap-title__span .char, .bc-swap-title__span .word',
          ],
        ],
        'placeholder' => 'cubic-bezier(0.19, 1, 0.22, 1)',
    ];

    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '.bc-swap-title__span, .bc-swap-title__span::after',
        ],
      ],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
			'tab'   => 'style',
			'group' => '_layout',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => 'spacing',
			'css'   => [
				[
					'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
				]
			],
		];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'swap_title', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_swap_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $swap_title    = ! empty( $settings['swap_title'] ) ? $settings['swap_title'] : '';
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'line';
    $stagger    = ! empty( $settings['stagger'] ) ? $settings['stagger'] : '0.25';

    $this->set_attribute( '_root', 'class', 'bc-swap-title' );
    $this->set_attribute( '_root', 'data-inner', "$swap_title" );
    $this->set_attribute( '_root', 'data-type', "$type" );
    $this->set_attribute( '_root', 'data-stagger', "$stagger" );

    if ($type === 'words' || $type === 'chars') {
      $this->set_attribute('_root', 'class', 'bc-swap-title--remove-line');
    }

		if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-swap-title__anchor' {$this->render_attributes( '_link' )}>
          <span class='bc-swap-title__span-wrapper'>
            <span class='bc-swap-title__span'>$inner_title</span>
          </span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span class='bc-swap-title__span-wrapper'>
          <span class='bc-swap-title__span'>$inner_title</span>
        </span>
      </{$this->tag}>
      ";
    }

	echo $output;
  }
}

