<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Underlined_Hover extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'underlined-hover';
  public $icon         = 'fa-solid fa-underline';
  public $tag      = 'h3';
  public $css_selector = '';

  public function get_label() {
    return esc_html__( 'Underline Hover', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Underline Hover', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Link to', 'bricks' ),
      'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-underlined-title__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-underlined-title__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-underlined-title__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-underlined-title__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-underlined-title__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-underlined-title__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-underlined-title__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-underlined-title__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
			'css'     => [
        [
          'property' => 'typography',
          'selector' => '&{pseudo} .bc-underlined-title__element',
        ],
      ],
    ];
    $this->controls['underlineSeparator'] = [
      'label'      => esc_html__( 'Underline', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['type'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'Side to Side' => 'Side to Side',
            'One Sided' => 'One Sided',
            'Two Sided' => 'Two Sided',
            'Full Sided' => 'Full Sided',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'Side to Side',
    ];
    $this->controls['colorunderline'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Color', 'bricks' ),
      'type'    => 'color',
			'css'     => [
        [
          'property' => '--background',
          'selector' => '&{pseudo} .bc-underlined-title__element',
        ],
      ],
    ];
    $this->controls['initialwidth'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Initial width', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css'     => [
        [
          'property' => '--width',
          'selector' => '&{pseudo} .bc-underlined-title__element',
        ],
      ],
      'placeholder' => '0px',
      'required' => [ 'type', '=', [ 'One Sided', 'Two Sided' ] ],
    ];
    $this->controls['height'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Thickness', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css'     => [
        [
          'property' => '--height',
          'selector' => '&{pseudo} .bc-underlined-title__element',
        ],
      ],
      'placeholder' => '1px',
    ];
    $this->controls['bottom'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Bottom distance', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css'     => [
        [
          'property' => '--bottom-distance',
          'selector' => '&{pseudo} .bc-underlined-title__element',
        ],
      ],
      'placeholder' => '0px',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Duration', 'bricks' ),
          'type'  => 'number',
          'unit' => 's',
          'inline' => true,
          'css'     => [
            [
              'property' => '--duration',
              'selector' => '&{pseudo} .bc-underlined-title__element',
            ],
          ],
          'placeholder' => '0.7s',
      ];
      $this->controls['ease'] = [
        'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'CSS Easing', 'bricks' ),
          'type'  => 'text',
          'inline' => true,
          'css'     => [
            [
              'property' => '--ease',
              'selector' => '&{pseudo} .bc-underlined-title__element',
            ],
          ],
          'placeholder' => 'cubic-bezier(0.16, 1, 0.3, 1)',
    ];

    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '&{pseudo} .bc-underlined-title__element',
        ],
      ],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'Side to Side';

    $this->set_attribute( '_root', 'class', 'bc-underlined-title' );

    $this->set_attribute( 'inner_title', 'class', 'bc-underlined-title__element' );
    if ($type === 'Side to Side') {
      $this->set_attribute( 'inner_title', 'class', 'bc-underlined-title__side-to-side' );
    }
    if ($type === 'One Sided') {
      $this->set_attribute( 'inner_title', 'class', 'bc-underlined-title__one-sided' );
    }
    if ($type === 'Two Sided') {
      $this->set_attribute( 'inner_title', 'class', 'bc-underlined-title__two-sided' );
    }
    if ($type === 'Full Sided') {
      $this->set_attribute( 'inner_title', 'class', 'bc-underlined-title__full-sided' );
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-underlined-title__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-underlined-title__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-underlined-title__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( 'inner_title' )}>$leftIcon$inner_title$rightIcon</span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span {$this->render_attributes( 'inner_title' )}>$leftIcon$inner_title$rightIcon</span>
      </{$this->tag}>
      ";
    }

    echo $output;
  }
}

