function next_mouse_parallax(){class ParallaxEffect{constructor(container,options={}){this.container=container;this.elements=new Map();this.position={x:0,y:0};this.sensitivity=options.sensitivity;this.easingFactor=options.easingFactor;this.invertMovement=options.invertMovement??!0;this.useDeviceOrientation=options.useDeviceOrientation??!0;this.maxTilt=options.maxTilt;this.customClass=options.customClass;this.init()}
init(){this.container.querySelectorAll(this.customClass).forEach(element=>{const depth=parseFloat(element.dataset.depth)||1;this.elements.set(element,{depth,currentPosition:{x:0,y:0}})});this.handleMouseMove=this.handleMouseMove.bind(this);this.handleTouchMove=this.handleTouchMove.bind(this);this.handleDeviceOrientation=this.handleDeviceOrientation.bind(this);this.animate=this.animate.bind(this);window.addEventListener('mousemove',this.handleMouseMove);window.addEventListener('touchmove',this.handleTouchMove);if(this.useDeviceOrientation){if(typeof DeviceOrientationEvent!=='undefined'&&typeof DeviceOrientationEvent.requestPermission==='function'){document.body.addEventListener('click',async()=>{try{const permission=await DeviceOrientationEvent.requestPermission();if(permission==='granted'){window.addEventListener('deviceorientation',this.handleDeviceOrientation)}}catch(error){console.error('Error requesting device orientation permission:',error)}},{once:!0})}else{window.addEventListener('deviceorientation',this.handleDeviceOrientation)}}
requestAnimationFrame(this.animate)}
handleMouseMove(e){const rect=this.container.getBoundingClientRect();const centerX=rect.width/2;const centerY=rect.height/2;this.position={x:(e.clientX-rect.left-centerX),y:(e.clientY-rect.top-centerY)}}
handleTouchMove(e){e.preventDefault();const touch=e.touches[0];const rect=this.container.getBoundingClientRect();const centerX=rect.width/2;const centerY=rect.height/2;this.position={x:(touch.clientX-rect.left-centerX),y:(touch.clientY-rect.top-centerY)}}
handleDeviceOrientation(e){const x=e.gamma;const y=e.beta;const normalizedX=(x/this.maxTilt)*(this.container.clientWidth/2);const normalizedY=(y/this.maxTilt)*(this.container.clientHeight/2);this.position={x:normalizedX,y:normalizedY}}
animate(){this.elements.forEach((data,element)=>{const strength=(data.depth*this.sensitivity)/20;const modifier=this.invertMovement?-1:1;const targetX=this.position.x*strength*modifier;const targetY=this.position.y*strength*modifier;const dx=targetX-data.currentPosition.x;const dy=targetY-data.currentPosition.y;data.currentPosition.x+=dx*this.easingFactor;data.currentPosition.y+=dy*this.easingFactor;element.style.transform=`translate3d(${data.currentPosition.x}px, ${data.currentPosition.y}px, 0)`});requestAnimationFrame(this.animate)}
destroy(){window.removeEventListener('mousemove',this.handleMouseMove);window.removeEventListener('touchmove',this.handleTouchMove);window.removeEventListener('deviceorientation',this.handleDeviceOrientation)}}
var isBricks=window.location.href.includes("brickspreview");if(isBricks){setTimeout(()=>{document.querySelectorAll('.next-mouse-parallax').forEach(parallaxContainer=>{const customClass=parallaxContainer.getAttribute('data-custom-class');if(customClass){document.querySelectorAll(customClass).forEach(element=>{element.setAttribute('parallax-element','true')});new ParallaxEffect(parallaxContainer,{customClass:customClass,sensitivity:parseFloat(parallaxContainer.getAttribute('data-sensitivity')),easingFactor:parseFloat(parallaxContainer.getAttribute('data-easing-factor')),invertMovement:parallaxContainer.getAttribute('data-invert-movement')=='1',useDeviceOrientation:parallaxContainer.getAttribute('data-use-device-orientation')=='1',maxTilt:parseFloat(parallaxContainer.getAttribute('data-max-tilt'))})}})},2000)}else{document.querySelectorAll('.next-mouse-parallax').forEach(parallaxContainer=>{const customClass=parallaxContainer.getAttribute('data-custom-class');if(customClass){document.querySelectorAll(customClass).forEach(element=>{element.setAttribute('parallax-element','true')});new ParallaxEffect(parallaxContainer,{customClass:customClass,sensitivity:parseFloat(parallaxContainer.getAttribute('data-sensitivity')),easingFactor:parseFloat(parallaxContainer.getAttribute('data-easing-factor')),invertMovement:parallaxContainer.getAttribute('data-invert-movement')=='1',useDeviceOrientation:parallaxContainer.getAttribute('data-use-device-orientation')=='1',maxTilt:parseFloat(parallaxContainer.getAttribute('data-max-tilt'))})}})}}
document.addEventListener("DOMContentLoaded",function(t){bricksIsFrontend&&next_mouse_parallax()})