function next_physics(){var bricksPreview=window.location.href.includes("brickspreview");document.querySelectorAll(".next-physics").forEach((nextPhysics)=>{var disableBuilder=nextPhysics.getAttribute("data-disable-builder");const{Engine,Render,Bodies,World,MouseConstraint,Runner}=Matter;let engine,renderer,runner;const elementStyles=getComputedStyle(nextPhysics);function createPhysics(){var gravityHorizontal=nextPhysics.getAttribute("data-gravity-horizontal");var gravityVertical=nextPhysics.getAttribute("data-gravity-vertical");var varTimeScale=nextPhysics.getAttribute("data-time-scale");var enableWireframes=nextPhysics.getAttribute("data-wireframes")==="1";var varStiffness=nextPhysics.getAttribute("data-stiffness");var enableTopWall=nextPhysics.getAttribute("data-enable-top-wall")==="1";var enableBottomWall=nextPhysics.getAttribute("data-enable-bottom-wall")==="1";var enableLeftWall=nextPhysics.getAttribute("data-enable-left-wall")==="1";var enableRightWall=nextPhysics.getAttribute("data-enable-right-wall")==="1";var wallVisible=nextPhysics.getAttribute("data-wall-visible")==="1";engine=Engine.create({gravity:{x:parseFloat(gravityHorizontal),y:parseFloat(gravityVertical)},timing:{timeScale:parseFloat(varTimeScale)}});renderer=Render.create({element:nextPhysics,engine:engine,options:{width:nextPhysics.clientWidth,height:nextPhysics.clientHeight,wireframes:enableWireframes,pixelRatio:window.devicePixelRatio}});var elementsData=nextPhysics.querySelector(".next-elements-list");var shapeData=elementsData.getAttribute("data-shape").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var horizontalData=elementsData.getAttribute("data-horizontal").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var verticalData=elementsData.getAttribute("data-vertical").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var widthData=elementsData.getAttribute("data-width").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var heightData=elementsData.getAttribute("data-height").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var radiusCircleData=elementsData.getAttribute("data-radius-circle").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var radiusPolygonData=elementsData.getAttribute("data-radius-polygon").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var sidesData=elementsData.getAttribute("data-sides").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var borderRadiusData=elementsData.getAttribute("data-border-radius").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var imageUrlData=elementsData.getAttribute("data-image-url").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var imageScale=elementsData.getAttribute("data-image-scale").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var fillData=elementsData.getAttribute("data-fill").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var strokeColorData=elementsData.getAttribute("data-stroke-color").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var strokeWidthData=elementsData.getAttribute("data-stroke-width").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var staticData=elementsData.getAttribute("data-static").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var restitutionData=elementsData.getAttribute("data-restitution").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var frictionData=elementsData.getAttribute("data-friction").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var frictionAirData=elementsData.getAttribute("data-friction-air").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var densityData=elementsData.getAttribute("data-density").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var linkData=elementsData.getAttribute("data-links").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");var linkTargetData=elementsData.getAttribute("data-links-tabs").split("d4511782").map((valor)=>valor.trim()).filter((valor)=>valor!=="");shapeData.forEach((shape,index)=>{var varStatic=!1;if(staticData[index]=="1"){varStatic=!0}
var varImageUrl="";if(imageUrlData[index]!="unset"){varImageUrl=imageUrlData[index]}
var varLink="";if(linkData[index]!="unset"){varLink=linkData[index];if(linkTargetData[index]==="1"){varLink={url:varLink,target:"_blank"}}else{varLink={url:varLink,target:""}}}
if(horizontalData[index].includes("%")){horizontalData[index]=(parseFloat(horizontalData[index])/100)*nextPhysics.clientWidth}
if(verticalData[index].includes("%")){verticalData[index]=(parseFloat(verticalData[index])/100)*nextPhysics.clientHeight}
const commonProperties={isStatic:varStatic,restitution:parseFloat(restitutionData[index]),friction:parseFloat(frictionData[index]),frictionAir:parseFloat(frictionAirData[index]),density:parseFloat(densityData[index]),chamfer:{radius:parseFloat(borderRadiusData[index])},render:{visible:!0,sprite:{texture:varImageUrl,xScale:parseFloat(imageScale[index]),yScale:parseFloat(imageScale[index])},fillStyle:fillData[index],lineWidth:parseFloat(strokeWidthData[index]),strokeStyle:strokeColorData[index],},customLink:varLink};let body;switch(shape){case "rectangle":body=Bodies.rectangle(parseFloat(horizontalData[index]),parseFloat(verticalData[index]),parseFloat(widthData[index]),parseFloat(heightData[index]),commonProperties);break;case "circle":body=Bodies.circle(parseFloat(horizontalData[index]),parseFloat(verticalData[index]),parseFloat(radiusCircleData[index]),commonProperties);break;case "polygon":body=Bodies.polygon(parseFloat(horizontalData[index]),parseFloat(verticalData[index]),parseFloat(sidesData[index]),parseFloat(radiusPolygonData[index]),commonProperties);break}
World.add(engine.world,[body])});const mouseControl=MouseConstraint.create(engine,{element:nextPhysics,constraint:{stiffness:parseFloat(varStiffness),render:{visible:!1}}});mouseControl.mouse.element.removeEventListener("mousewheel",mouseControl.mouse.mousewheel);mouseControl.mouse.element.removeEventListener("DOMMouseScroll",mouseControl.mouse.mousewheel);mouseControl.mouse.element.removeEventListener('touchstart',mouseControl.mouse.mousedown);mouseControl.mouse.element.removeEventListener('touchmove',mouseControl.mouse.mousemove);mouseControl.mouse.element.removeEventListener('touchend',mouseControl.mouse.mouseup);mouseControl.mouse.element.addEventListener('touchstart',mouseControl.mouse.mousedown,{passive:!0});mouseControl.mouse.element.addEventListener('touchmove',(e)=>{if(mouseControl.body){mouseControl.mouse.mousemove(e)}});mouseControl.mouse.element.addEventListener('touchend',(e)=>{if(mouseControl.body){mouseControl.mouse.mouseup(e)}});World.add(engine.world,[mouseControl]);nextPhysics.addEventListener('click',function(event){const bounds=nextPhysics.getBoundingClientRect();const click={x:event.clientX-bounds.left,y:event.clientY-bounds.top};const bodies=Matter.Composite.allBodies(engine.world);bodies.forEach(body=>{if(Matter.Bounds.contains(body.bounds,click)&&Matter.Vertices.contains(body.vertices,click)&&body.customLink){if(body.customLink.target==='_blank'){window.open(body.customLink.url,'_blank')}else{window.location.href=body.customLink.url}}})});const wallOptions={isStatic:!0,render:{visible:wallVisible,fillStyle:elementStyles.getPropertyValue('--fill-wall').trim()}};var borderWidth=parseFloat(nextPhysics.getAttribute("data-wall-width"));if(enableTopWall){World.add(engine.world,[Bodies.rectangle(nextPhysics.clientWidth/2,0,nextPhysics.clientWidth,borderWidth,wallOptions)])}
if(enableBottomWall){World.add(engine.world,[Bodies.rectangle(nextPhysics.clientWidth/2,nextPhysics.clientHeight,nextPhysics.clientWidth,borderWidth,wallOptions)])}
if(enableLeftWall){World.add(engine.world,[Bodies.rectangle(0,nextPhysics.clientHeight/2,borderWidth,nextPhysics.clientHeight,wallOptions)])}
if(enableRightWall){World.add(engine.world,[Bodies.rectangle(nextPhysics.clientWidth,nextPhysics.clientHeight/2,borderWidth,nextPhysics.clientHeight,wallOptions)])}
if(!(bricksPreview&&disableBuilder=="1")){Matter.Runner.run(engine);Render.run(renderer)}}
var varTrigger=nextPhysics.getAttribute("data-trigger");if(varTrigger=="this"){varTrigger=nextPhysics}
var varStart=nextPhysics.getAttribute("data-start");var physicsCreated=!1;ScrollTrigger.create({trigger:nextPhysics,start:varStart,onEnter:()=>{if(!physicsCreated){createPhysics();physicsCreated=!0}},});function clearPhysics(){Render.stop(renderer);World.clear(engine.world);Engine.clear(engine);renderer.canvas.remove();renderer.canvas=null;renderer.context=null;renderer.textures={}}
var windowWidth=jQuery(window).width();window.addEventListener("resize",()=>{if(jQuery(window).width()!=windowWidth){windowWidth=jQuery(window).width();clearPhysics();createPhysics()}})})}
document.addEventListener("DOMContentLoaded",function(e){bricksIsFrontend&&next_physics()})