function next_proximity_hover(){class ProximityHover{constructor(element,settings={}){this.element=element;this.settings={radius:settings.radius,type:settings.type,minWeight:settings.minWeight,maxWeight:settings.maxWeight,minScale:settings.minScale,maxScale:settings.maxScale,...settings};this.letters=[];this.mousePosition={x:0,y:0};this.rafId=null;this.init()}
init(){this.splitter=new SplitText(this.element,{type:"chars",charsClass:"next-proximity-hover__char"});this.splitter.chars.forEach(char=>{this.letters.push(char)});this.handleMouseMove=this.handleMouseMove.bind(this);this.animate=this.animate.bind(this);window.addEventListener('mousemove',this.handleMouseMove);this.rafId=requestAnimationFrame(this.animate)}
handleMouseMove(e){const rect=this.element.getBoundingClientRect();this.mousePosition.x=e.clientX-rect.left;this.mousePosition.y=e.clientY-rect.top}
animate(){const rect=this.element.getBoundingClientRect();this.letters.forEach(letter=>{const letterRect=letter.getBoundingClientRect();const letterX=letterRect.left+letterRect.width/2-rect.left;const letterY=letterRect.top+letterRect.height/2-rect.top;const distance=Math.sqrt(Math.pow(this.mousePosition.x-letterX,2)+Math.pow(this.mousePosition.y-letterY,2));const falloff=Math.max(0,Math.min(1,1-distance/this.settings.radius));if(this.settings.type==='weight'){const weight=this.settings.minWeight+falloff*(this.settings.maxWeight-this.settings.minWeight);letter.style.transform='scale(1)';letter.style.fontVariationSettings=`'wght' ${weight}`}else if(this.settings.type==='size'){const scale=this.settings.minScale+falloff*(this.settings.maxScale-this.settings.minScale);letter.style.fontVariationSettings='';letter.style.transform=`scale(${scale})`}});this.rafId=requestAnimationFrame(this.animate)}
destroy(){if(this.rafId){cancelAnimationFrame(this.rafId)}
window.removeEventListener('mousemove',this.handleMouseMove);this.splitter.revert()}}
document.querySelectorAll('.next-proximity-hover__inner').forEach(element=>{new ProximityHover(element,{type:element.getAttribute('data-type'),radius:parseFloat(element.getAttribute('data-radius')),minWeight:parseFloat(element.getAttribute('data-min-weight')),maxWeight:parseFloat(element.getAttribute('data-max-weight')),minScale:parseFloat(element.getAttribute('data-min-scale')),maxScale:parseFloat(element.getAttribute('data-max-scale')),})})}
document.addEventListener("DOMContentLoaded",function(t){document.fonts.ready.then(function(){bricksIsFrontend&&next_proximity_hover()})})