<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Arrow_Button_v5 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-arrow-button-v5';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Arrow Button v5', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Arrow Button v5', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-arrow-button-v5__container',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-arrow-button-v5__background',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-arrow-button-v5__background',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];
    $this->controls['gap'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Gap', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'gap',
                'selector' => '&{pseudo} .nb-arrow-button-v5__container',
            ],
        ],
        'default' => 8,
    ];

    $this->controls['iconStyleSeparator'] = [
        'label'      => esc_html__( 'Arrow Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['iconType'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'type1' => 'Arrow 1',
            'type2' => 'Arrow 2',
            'type3' => 'Angle',
            'type4' => 'Angles',
            'type5' => 'Fancy',
        ],
        'inline' => true,
        'placeholder' => 'Arrow 2',
        'default' => 'type2',
    ];
    $this->controls['iconDimensions'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Dimensions', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--dimensions',
                'selector' => '&{pseudo} .nb-arrow-button-v5__icon-item',
            ],
        ],
        'default' => 18,
    ];
    $this->controls['iconFill'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Fill', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--stroke',
                'selector' => '&{pseudo} .nb-arrow-button-v5__icon-item',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['iconLeft'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duplicated Arrow Left', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--left',
                'selector' => '',
            ],
        ],
        'default' => 15,
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['arrowDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'css'     => [
            [
                'property' => '--arrow-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.6s',
    ];
    $this->controls['arrowsStagger'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Stagger', 'bricks' ),
        'type'    => 'number',
        'unit'   => 's',
        'css'     => [
            [
                'property' => '--arrows-blur-stagger',
                'selector' => '',
            ],
        ],
        'default' => '0.02s',
    ];
    $this->controls['arrowEase'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--arrow-ease',
                'selector' => '',
            ],
        ],
        'default' => 'cubic-bezier(.32, .72, 0, 1)',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Arrow Button v5';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    /*Icon*/
    $iconType = ! empty( $settings['iconType'] ) ? $settings['iconType'] : 'type2';
    if($iconType == 'type1'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25' style='--index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25' style='--index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25' style='--index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25' style='--index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>
        ";
    }
    if($iconType == 'type2'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' style='--index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' style='--index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' style='--index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' style='--index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>
        ";
    }
    if($iconType == 'type3'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512' style='--index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512' style='--index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512' style='--index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512' style='--index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>
        ";
    }
    if($iconType == 'type4'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' style='--index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' style='--index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' style='--index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' style='--index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>
        ";
    }
    if($iconType == 'type5'){
        $icon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important; --index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important; --index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important; --index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important; --index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>
        ";
    }

    /*Duplicated Icon*/
    $duplicatedIconType = ! empty( $settings['duplicatedIconType'] ) ? $settings['duplicatedIconType'] : 'type2';
    if($duplicatedIconType == 'type1'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25' style='--index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25' style='--index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25' style='--index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25' style='--index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>";
    }
    if($duplicatedIconType == 'type2'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' style='--index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' style='--index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' style='--index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' style='--index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>";
    }
    if($duplicatedIconType == 'type3'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512' style='--index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512' style='--index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512' style='--index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512' style='--index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>";
    }
    if($duplicatedIconType == 'type4'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' style='--index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' style='--index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' style='--index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' style='--index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>";
    }
    if($duplicatedIconType == 'type5'){
        $duplicatedIcon = 
        "<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important; --index:3;' class='nb-arrow-button-v5__icon-item'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important; --index:2;' class='nb-arrow-button-v5__icon-item'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important; --index:1;' class='nb-arrow-button-v5__icon-item'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important; --index:0;' class='nb-arrow-button-v5__icon-item'>
            <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
            <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
            <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>";
    }

    $this->set_attribute( '_root', 'class', 'nb-arrow-button-v5' );
    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-arrow-button-v5__container'>
            <div class='nb-arrow-button-v5__icon nb-arrow-button-v5__icon--first'>
                $duplicatedIcon
            </div>
            <span class='nb-arrow-button-v5__text'>$inner_title</span>
            <div class='nb-arrow-button-v5__icon'>
                $icon
            </div>
        </span>
        <span class='nb-arrow-button-v5__background'></span>
    </$root_tag>
    ";

	echo $output;
  }
}