<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Arrow_Icon extends \Bricks\Element {
    public $category     = 'Next Bricks - Buttons';
    public $name         = 'nextarrowicon';
    public $icon         = 'fas fa-circle-arrow-right';
    public $tag      = 'div';
    public $scripts      = ['next_arrow_icon'];

    public function get_label() {
        return esc_html__( 'Arrow Icon', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'span' => 'span',
                'button' => 'button',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['toggle'] = [
            'label'       => esc_html__( 'Toggle selector', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'classname',
        ];
        $this->controls['trigger'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Event', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'click' => 'click',
                'hover' => 'hover',
            ],
            'inline'      => true,
            'placeholder' => 'hover',
        ];

        //Accesibility
        $this->controls['accesibilitySeparator'] = [
            'label'       => esc_html__( 'Accessibility', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['opendefault'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Toggled by default', 'bricks' ),
            'type'     => 'checkbox',
            'required' => [ 'trigger', '=', 'click'],
        ];
        $this->controls['closeclick'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Close when clicking outside', 'bricks' ),
            'type'     => 'checkbox',
            'required' => [ 'trigger', '=', 'click'],
        ];
        $this->controls['closeesc'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Close when pressing ESC', 'bricks' ),
            'type'     => 'checkbox',
        ];

        //Wrapper style
        $this->controls['wrapperStyleSeparator'] = [
            'label'       => esc_html__( 'Wrapper style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'     => [
              [
                  'property' => 'width',
                  'selector' => '',
              ],
            ],
            'placeholder' => '40px',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'     => [
              [
                  'property' => 'height',
                  'selector' => '',
              ],
            ],
            'placeholder' => '40px',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'css'     => [
              [
                  'property' => 'background',
                  'selector' => '',
              ],
            ],
        ];
        $this->controls['border'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'css'     => [
              [
                  'property' => 'border',
                  'selector' => '',
              ],
            ],
        ];

        //Arrow style
        $this->controls['arrowStyleSeparator'] = [
            'label'       => esc_html__( 'Arrow style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['arrowtype'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Icon', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'type1' => 'Arrow 1',
                'type2' => 'Arrow 2',
                'type3' => 'Angle',
                'type4' => 'Angles',
                'type5' => 'Fancy',
            ],
            'inline' => true,
            'placeholder' => 'Arrow 2',
            'default' => 'type2',
        ];
        $this->controls['arrowColor'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type'  => 'color',
            'css'     => [
                [
                    'property' => '--fill',
                    'selector' => '&{pseudo} .next-arrow-icon__arrow',
                ],
            ],
        ];
        $this->controls['arrowweight'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Weight', 'bricks' ),
            'type' => 'number',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'stroke-width',
                  'selector' => '&{pseudo} .next-arrow-icon__arrow',
                ],
            ],
            'placeholder'        => '1',
            'default'        => '1',
        ];
        $this->controls['arrowScale'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Size (scale)', 'bricks' ),
            'type'  => 'text',
            'css'     => [
                [
                    'property' => '--arrow-scale',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0.5',
        ];
        $this->controls['arrowRotate'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Rotate', 'bricks' ),
            'type'  => 'number',
            'unit'  => 'deg',
            'css'     => [
                [
                    'property' => '--arrow-rotate',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0deg',
        ];

        //Scale animation
        $this->controls['scaleAnimationSeparator'] = [
            'label'       => esc_html__( 'Scale animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['enableScaleAnimation'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable animation', 'bricks' ),
            'type' => 'checkbox',
            'default'      => true,
        ];
        $this->controls['scaleAnimation'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Scale', 'bricks' ),
            'type'  => 'text',
            'css'     => [
              [
                  'property' => '--icon-hover-scale',
                  'selector' => '',
              ],
            ],
            'placeholder' => '1.3',
            'required' => [ 'enableScaleAnimation', '=', true],
        ];
        $this->controls['scaleDuration'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit'  => 's',
            'css'     => [
              [
                  'property' => '--scale-duration',
                  'selector' => '',
              ],
            ],
            'placeholder' => '0.4s',
            'required' => [ 'enableScaleAnimation', '=', true],
        ];
        $this->controls['scaleEasing'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'CSS Easing', 'bricks' ),
            'type'  => 'text',
            'css'     => [
              [
                  'property' => '--scale-easing',
                  'selector' => '',
              ],
            ],
            'placeholder' => 'ease',
            'required' => [ 'enableScaleAnimation', '=', true],
        ];
        $this->controls['scaleDelay'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Delay', 'bricks' ),
            'type'  => 'number',
            'unit'  => 's',
            'css'     => [
              [
                  'property' => '--scale-delay',
                  'selector' => '',
              ],
            ],
            'placeholder' => '0s',
            'required' => [ 'enableScaleAnimation', '=', true],
        ];

        //Double translate animation
        $this->controls['doubleTranslateAnimationSeparator'] = [
            'label'       => esc_html__( 'Double arrow animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['enableDoubleTranslateAnimation'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable animation', 'bricks' ),
            'type' => 'checkbox',
            'default'      => true,
        ];
        $this->controls['distanceArrows'] = [
            'hasDynamicData' => false,
            'inline' => true,
            'tab' => 'content',
            'label' => esc_html__( 'Distance between arrows', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'     => [
              [
                  'property' => '--distance-between-arrows',
                  'selector' => '',
              ],
            ],
            'placeholder' => '50px',
            'required' => [ 'enableDoubleTranslateAnimation', '=', true],
        ];
        $this->controls['transformDuration'] = [
            'hasDynamicData' => false,
            'inline' => true,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'css'     => [
              [
                  'property' => '--transform-duration',
                  'selector' => '',
              ],
            ],
            'placeholder' => '0.4s',
            'required' => [ 'enableDoubleTranslateAnimation', '=', true],
        ];
        $this->controls['transformEasing'] = [
            'hasDynamicData' => false,
            'inline' => true,
            'tab' => 'content',
            'label' => esc_html__( 'CSS Easing', 'bricks' ),
            'type'  => 'text',
            'css'     => [
              [
                  'property' => '--transform-easing',
                  'selector' => '',
              ],
            ],
            'placeholder' => 'ease',
            'required' => [ 'enableDoubleTranslateAnimation', '=', true],
        ];
        $this->controls['transformDelay'] = [
            'hasDynamicData' => false,
            'inline' => true,
            'tab' => 'content',
            'label' => esc_html__( 'Delay', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'css'     => [
              [
                  'property' => '--transform-delay',
                  'selector' => '',
              ],
            ],
            'placeholder' => '0s',
            'required' => [ 'enableDoubleTranslateAnimation', '=', true],
        ];


        //Rotate animation
        $this->controls['rotateAnimationSeparator'] = [
            'label'       => esc_html__( 'Rotate Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['enableRotateAnimation'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable animation', 'bricks' ),
            'type' => 'checkbox',
            'default'      => true,
        ];
        $this->controls['arrowRotateAnimation'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Rotate', 'bricks' ),
            'type'  => 'number',
            'unit'  => 'deg',
            'css'     => [
                [
                    'property' => '--arrow-hover-rotate',
                    'selector' => '',
                ],
            ],
            'placeholder' => '45deg',
            'required' => [ 'enableRotateAnimation', '=', true],
        ];
        $this->controls['rotateDuration'] = [
            'hasDynamicData' => false,
            'inline' => true,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'css'     => [
              [
                  'property' => '--rotate-duration',
                  'selector' => '',
              ],
            ],
            'placeholder' => '0.4s',
            'required' => [ 'enableRotateAnimation', '=', true],
        ];
        $this->controls['rotateEasing'] = [
            'hasDynamicData' => false,
            'inline' => true,
            'tab' => 'content',
            'label' => esc_html__( 'CSS Easing', 'bricks' ),
            'type'  => 'text',
            'css'     => [
              [
                  'property' => '--rotate-easing',
                  'selector' => '',
              ],
            ],
            'placeholder' => 'ease',
            'required' => [ 'enableRotateAnimation', '=', true],
        ];
        $this->controls['rotateDelay'] = [
            'hasDynamicData' => false,
            'inline' => true,
            'tab' => 'content',
            'label' => esc_html__( 'Delay', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'css'     => [
              [
                  'property' => '--rotate-delay',
                  'selector' => '',
              ],
            ],
            'placeholder' => '0s',
            'required' => [ 'enableRotateAnimation', '=', true],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-arrow-icon', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_arrow_icon.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $toggle = ! empty( $settings['toggle'] ) ? $settings['toggle'] : 'classname';
        $trigger = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'hover';
        $arrowtype = ! empty( $settings['arrowtype'] ) ? $settings['arrowtype'] : 'type2';

        $enableDoubleTranslateAnimation = ! empty( $settings['enableDoubleTranslateAnimation'] ) ? $settings['enableDoubleTranslateAnimation'] : 0;
        $enableScaleAnimation = ! empty( $settings['enableScaleAnimation'] ) ? $settings['enableScaleAnimation'] : 0;
        $enableRotateAnimation = ! empty( $settings['enableRotateAnimation'] ) ? $settings['enableRotateAnimation'] : 0;

        if($enableDoubleTranslateAnimation == 1){
            $this->set_attribute( '_root', 'data-enable-transform', '' );
        }
        if($enableScaleAnimation == 1){
            $this->set_attribute( '_root', 'data-enable-scale', '' );
        }
        if($enableRotateAnimation == 1){
            $this->set_attribute( '_root', 'data-enable-rotate', '' );
        }

        /*Arrow Icons*/
        if($arrowtype == 'type1'){
            $arrow = 
            "<svg class='next-arrow-icon__arrow' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25'>
            <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
            </svg>";
        }
        if($arrowtype == 'type2'){
            $arrow = 
            "<svg class='next-arrow-icon__arrow' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'>
            <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
            </svg>";
        }
        if($arrowtype == 'type3'){
            $arrow = 
            "<svg class='next-arrow-icon__arrow' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512'>
            <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
            </svg>";
        }
        if($arrowtype == 'type4'){
            $arrow = 
            "<svg class='next-arrow-icon__arrow' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'>
            <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
            </svg>";
        }
        if($arrowtype == 'type5'){
            $arrow = 
            "<svg class='next-arrow-icon__arrow next-arrow-icon__arrow--fancy' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important'>
              <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
              <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
              <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
            </svg>";
          }

        $this->set_attribute( '_root', 'class', 'next-arrow-icon' );

        $closeclick = ! empty( $settings['closeclick'] ) ? $settings['closeclick'] : 0;
        $closeesc = ! empty( $settings['closeesc'] ) ? $settings['closeesc'] : 0;

        $opendefault = ! empty( $settings['opendefault'] ) ? $settings['opendefault'] : 0;
        if($opendefault == 1 && $trigger == 'click'){
            $this->set_attribute( '_root', 'data-active', '' );
        }

        $this->set_attribute( '_root', 'data-toggle', $toggle );
        $this->set_attribute( '_root', 'data-trigger', $trigger );

        $this->set_attribute( '_root', 'data-closeclick', $closeclick );
        $this->set_attribute( '_root', 'data-closeesc', $closeesc );

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= $arrow;
        $output .= $arrow;
        $output .= "</{$this->tag}>";

        echo $output;
    }
}