<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class NB_Border_Beam extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next-border-beam';
  public $icon         = 'fa-solid fa-square-full';
  public $tag      = 'div';
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Border Beam', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Border Beam is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];

    $this->controls['blockStyleSeparator'] = [
        'label'      => esc_html__( 'Block style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Padding', 'bricks' ),
        'type'  => 'spacing',
        'units' => true,
        'css' => [
          [
            'property' => 'padding',
            'selector' => '',
          ]
        ],
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'placeholder' => '400px',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'placeholder' => '400px',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'background',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '',
          ]
        ],
    ];
    $this->controls['borderRadius'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'inline' => true,
        'css' => [
          [
            'property' => 'border',
            'selector' => '&, .nb-border-beam__mask',
          ]
        ],
    ];
    $this->controls['boxShadow'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Box shadow', 'bricks' ),
        'type'  => 'box-shadow',
        'inline' => true,
        'css' => [
          [
            'property' => 'box-shadow',
            'selector' => '',
          ]
        ],
    ];

    $this->controls['beamStyleSeparator'] = [
        'label'      => esc_html__( 'Beam style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['size'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => false,
        'inline' => true,
        'css' => [
          [
            'property' => '--size',
            'selector' => '.nb-border-beam__mask',
          ]
        ],
        'placeholder' => '200',
    ];
    $this->controls['anchor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Anchor', 'bricks' ),
        'type'  => 'number',
        'units' => false,
        'inline' => true,
        'css' => [
          [
            'property' => '--anchor',
            'selector' => '.nb-border-beam__mask',
          ]
        ],
        'placeholder' => '90',
    ];
    $this->controls['borderWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => false,
        'inline' => true,
        'css' => [
          [
            'property' => '--border-width',
            'selector' => '.nb-border-beam__mask',
          ]
        ],
        'placeholder' => '1.5',
    ];
    $this->controls['colorFrom'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color from', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => '--color-from',
            'selector' => '.nb-border-beam__mask',
          ]
        ],
    ];
    $this->controls['colorTo'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color to', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => '--color-to',
            'selector' => '.nb-border-beam__mask',
          ]
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['disableBuilder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
        'type'     => 'checkbox',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type'  => 'number',
        'unit' => 's',
        'inline' => true,
        'css' => [
          [
            'property' => '--duration',
            'selector' => '.nb-border-beam__mask',
          ]
        ],
        'placeholder' => '10s',
    ];
    $this->controls['cssEasing'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'CSS easing', 'bricks' ),
        'type'  => 'text',
        'inline' => true,
        'css' => [
          [
            'property' => '--easing',
            'selector' => '.nb-border-beam__mask',
          ]
        ],
        'placeholder' => 'linear',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'nb-border-beam', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_border_beam.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disableBuilder = ! empty( $settings['disableBuilder'] ) ? $settings['disableBuilder'] : 0;
    if($disableBuilder != 0){
        $this->set_attribute( '_root', 'class', "nb-border-beam--disable-builder");
    }

    $this->set_attribute( '_root', 'class', "nb-border-beam");

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= "<div class='nb-border-beam__mask'></div>";
    $output .= "</{$this->tag}>";

	echo $output;
  }
}