<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Bubbles_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-bubbles-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Bubbles Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Bubbles Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

        $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .nb-bubbles-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .nb-bubbles-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .nb-bubbles-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .nb-bubbles-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .nb-bubbles-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .nb-bubbles-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .nb-bubbles-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .nb-bubbles-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-bubbles-button__wrapper',
            ],
        ],
        'default' => [
            'top'    => 12,
            'right'  => 20, 
            'bottom' => 12,
            'left'   => 20,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo} .nb-bubbles-button__label',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['innerbackground'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Inner Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--c-radial-inner',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#15bdff',
        ],
    ];
    $this->controls['outerbackground'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Outer Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--c-radial-outer',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#2f58ed',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
          [
            'property' => '--border-radius',
            'selector' => '',
          ],
        ],
        'default' => 24,
    ];
    $this->controls['innerBoxShadow'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Inner Box Shadow', 'bricks' ),
      'type'    => 'box-shadow',
      'css'     => [
        [
          'property' => 'box-shadow',
          'selector' => '&{pseudo}:before',
        ],
      ],
      'default' => [
        'color' => [
            'hex' => '#15bdff',
        ],
        'values' => [
            'offsetX' => 0,
            'offsetY' => 3,
            'blur' => 12,
            'spread' => 0,
        ],
        'inset' => true,
    ],
    ];
  }

  public function get_nestable_children() {
    return [
        [ /*1*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 8,
                'background' => [
                    'rgb' => 'rgba(255, 232, 26, 0.7)',
                ],
                'animationType' => 'move-down-right',
                'positionX' => '0px',
                'positionY' => '-40px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '0.2s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*2*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 12,
                'background' => [
                    'rgb' => 'rgba(255, 163, 26, 0.7)',
                ],
                'animationType' => 'move-up-left',
                'positionX' => '92px',
                'positionY' => '8px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '0.5s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*3*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 14,
                'background' => [
                    'hex' => '#1a23ff',
                ],
                'animationType' => 'move-diagonal',
                'positionX' => '-12px',
                'positionY' => '-12px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '0.8s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*4*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 14,
                'background' => [
                    'hex' => '#1a23ff',
                ],
                'animationType' => 'move-right',
                'positionX' => '80px',
                'positionY' => '-12px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '1.2s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*5*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 16,
                'background' => [
                    'hex' => '#e21bda',
                ],
                'animationType' => 'move-zigzag',
                'positionX' => '12px',
                'positionY' => '-4px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '0.3s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*6*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 16,
                'background' => [
                    'hex' => '#e21bda',
                ],
                'animationType' => 'move-left',
                'positionX' => '56px',
                'positionY' => '16px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '1.5s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*7*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 12,
                'background' => [
                    'rgb' => 'rgba(255, 163, 26, 0.7)',
                ],
                'animationType' => 'move-up',
                'positionX' => '8px',
                'positionY' => '28px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '0.7s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*8*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 12,
                'background' => [
                    'rgb' => 'rgba(255, 163, 26, 0.7)',
                ],
                'animationType' => 'move-horizontal',
                'positionX' => '28px',
                'positionY' => '-4px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '1.8s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*9*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 8,
                'background' => [
                    'rgb' => 'rgba(255, 232, 26, 0.7)',
                ],
                'animationType' => 'move-vertical',
                'positionX' => '20px',
                'positionY' => '-12px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '1.0s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*10*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 8,
                'background' => [
                    'rgb' => 'rgba(255, 232, 26, 0.7)',
                ],
                'animationType' => 'move-right-up',
                'positionX' => '64px',
                'positionY' => '16px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '0.4s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*11*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 12,
                'background' => [
                    'rgb' => 'rgba(255, 163, 26, 0.7)',
                ],
                'animationType' => 'move-straight',
                'positionX' => '4px',
                'positionY' => '4px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '1.3s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
        [ /*12*/
            'name'     => 'next-bubbles-button-bubble',
            'settings' => [
                'width' => 40,
                'height' => 40,
                'blur' => 14,
                'background' => [
                    'rgb' => 'rgba(255, 163, 26, 0.7)',
                ],
                'animationType' => 'move-right-down',
                'positionX' => '52px',
                'positionY' => '4px',
                'bubblesDuration' => '7s',
                'bubblesDelay' => '0.6s',
                'bubblesEasing' => 'ease-in-out',
            ],
        ],
    ];
}

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Bubbles Button';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'nb-bubbles-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'nb-bubbles-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'nb-bubbles-button' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <div class='nb-bubbles-button__wrapper'>
            <span class='nb-bubbles-button__label'>$leftIcon$inner_title$rightIcon</span>";
            $output .= Frontend::render_children( $this );
        $output .= "</div>
    </$root_tag>
    ";

	echo $output;
  }
}