<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Counter_V2 extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next-counter-v2';
  public $icon         = 'ion-ios-timer';
  public $tag      = 'h3';
  public $scripts      = ['next_counter_v2'];

  public function get_label() {
    return esc_html__( 'Counter v2', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['startFrom'] = [
        'hasDynamicData' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Start from', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'placeholder' => '0',
    ];
    
    $this->controls['endAt'] = [
        'hasDynamicData' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'End at', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'placeholder' => '1252.5',
    ];

    $this->controls['thousandsSeparator'] = [
        'hasDynamicData' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Thousands separator', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'placeholder' => '.',
    ];

    $this->controls['decimalSeparator'] = [
        'hasDynamicData' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Decimals separator', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'placeholder' => ',',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['generalTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
              'css'     => [
          [
            'property' => 'typography',
            'selector' => '.next-counter-v2__character',
          ],
        ],
    ];
    $this->controls['thousandsTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Thousands typography', 'bricks' ),
        'type'    => 'typography',
              'css'     => [
          [
            'property' => 'typography',
            'selector' => '.next-counter-v2__character--float',
          ],
        ],
    ];
    $this->controls['decimalsTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Decimals typography', 'bricks' ),
        'type'    => 'typography',
              'css'     => [
          [
            'property' => 'typography',
            'selector' => '.next-counter-v2__character--decimal',
          ],
        ],
    ];
    $this->controls['separatorsTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Separators typography', 'bricks' ),
        'type'    => 'typography',
              'css'     => [
          [
            'property' => 'typography',
            'selector' => '.next-counter-v2__character--symbol',
          ],
        ],
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];

    $this->controls['duration'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'css'     => [
            [
              'property' => '--next-counter-transition',
              'selector' => '',
            ],
          ],
        'placeholder' => '3s',
    ];

    $this->controls['delay'] = [
    'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0s',
    ];

    $this->controls['easing'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'basic' => 'basic',
          'back' => 'back', 
          'expo' => 'expo',
          'sine' => 'sine',
          'power' => 'power', 
          'circ' => 'circ',
          'bounce' => 'bounce',
          'elastic' => 'elastic',
      ],
        'inline' => true,
        'clearable' => false,
        'placeholder' => 'expo',
    ];

    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['trigger'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
    ];

    $this->controls['start'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom',
    ];

  $this->controls['triggerSeparator'] = [
    'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
    'type'       => 'separator',
  ];

  $this->controls['animationType'] = [
    'tab' => 'content',
    'label' => esc_html__( 'Trigger on', 'bricks' ),
    'type' => 'select',
    'options'     => [
      'click' => 'Click',
      'mouseover' => 'Hover',
    ],
    'inline' => true,
    'placeholder' => ' ',
  ];

  $this->controls['classTriggerClick'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Element', 'bricks' ),
    'type' => 'text',
    'placeholder' => '.className',
    'inline' => true,
    'required' => [ 'animationType', '=', 'click'],
  ];
  $this->controls['classTriggerHover'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Element', 'bricks' ),
    'type' => 'text',
    'placeholder' => '.className',
    'inline' => true,
    'required' => [ 'animationType', '=', 'mouseover'],
  ];

  //Gradient
  $this->controls['titleGradient'] = [
    'group' => 'gradient',
    'tab' => 'content',
    'type' => 'gradient',
    'css' => [
      [
        'property' => 'background-image',
        'selector' => '.next-counter-v2__character--symbol, .next-counter-v2__character--float span, .next-counter-v2__character--decimal span',
      ],
    ],
  ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next-counter-v2', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_counter_v2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $startfrom    = ! empty( $settings['startfrom'] ) ? $settings['startfrom'] : '0';
    $endAt    = ! empty( $settings['endAt'] ) ? $settings['endAt'] : '1252.5';
    $thousandsSeparator = ! empty( $settings['thousandsSeparator'] ) ? $settings['thousandsSeparator'] : '.';
    $decimalSeparator = ! empty( $settings['decimalSeparator'] ) ? $settings['decimalSeparator'] : ',';

    $trigger    = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $start    = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $delay    = ! empty( $settings['delay'] ) ? $settings['delay'] : 0;

    $easing    = ! empty( $settings['easing'] ) ? $settings['easing'] : 'expo';

    $this->set_attribute( '_root', 'class', 'next-counter-v2' );
    $eventSelector = '';
    if($classTriggerClick != 0 && $animationType == 'click'){
        $eventSelector = $classTriggerClick;
    }
    if($classTriggerHover != 0 && $animationType == 'mouseover'){
        $eventSelector = $classTriggerHover;
    }

    $output ="<{$this->tag} {$this->render_attributes( '_root' )}
        data-easing='{$easing}'
        data-value='{$startfrom}'
        data-start-number='{$startfrom}'
        data-end-number='{$endAt}'
        data-thousands-separator='{$thousandsSeparator}'
        data-decimal-separator='{$decimalSeparator}'
        data-trigger='{$trigger}'
        data-start='{$start}'
        data-delay='{$delay}'
        data-event='{$animationType}'
        " . ($eventSelector ? "data-event-selector='{$eventSelector}'" : "") . "
    >
    <div class='next-counter-v2__character'></div>
    </{$this->tag}>";

    echo $output;
  }
}

