<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Crosshair extends \Bricks\Element {
  public $category     = 'Next Bricks - Cursors';
  public $name         = 'next_crosshair';
  public $icon         = 'fas fa-crosshairs';
  public $tag      = 'div';
  public $scripts      = ['next_crosshair'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Crosshair', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Crosshair is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '',
          ]
        ],
        'default' => [
            'hex' => '#e3e3e3',
        ],
    ];

    $this->controls['crosshairSeparator'] = [
        'label'      => esc_html__( 'Crosshair Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['crosshairZIndex'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'zIndex', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'css' => [
          [
            'property' => '--crosshair-z-index',
            'selector' => '.nb-crosshair__cursor',
          ]
        ],
        'default' => '10000',
    ];
    $this->controls['crosshairDimensions'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Thickness', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => '--crosshair-dimensions',
            'selector' => '.nb-crosshair__cursor',
          ]
        ],
        'default' => '1px',
    ];
    $this->controls['crosshairColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '.nb-crosshair__line-horizontal, .nb-crosshair__line-vertical',
          ]
        ],
        'default' => [
            'rgb' => 'rgb(0, 0, 0)',
        ]
    ];

    /*js settings*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Crosshair Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Disable in the Builder', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'default' => false,
    ];
    $this->controls['crosshairAttach'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Attachness', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'default' => '0.15',
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-crosshair__content',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Crosshair', 'bricks' ),
                        'tag'  => 'h3',
                    ],
                ]
            ]
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_crosshair', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_crosshair.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $crosshairattach = ! empty( $settings['crosshairAttach'] ) ? $settings['crosshairAttach'] : 0.15;

    $this->set_attribute( '_root', 'class', "nb-crosshair");
    $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_root', 'data-crosshair-attach', $crosshairattach);

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= '<div class="nb-crosshair__cursor">
                    <div class="nb-crosshair__line-horizontal"></div>
                    <div class="nb-crosshair__line-vertical"></div>';
    $output .= '</div>';
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}